// ################################################################################
//
//  Wireless Transceiver Sketch v0.00 Beta
//
//  Released:  03/02/2019
//
//  Author: TechKnowTone
//
// ################################################################################
/*
    TERMS OF USE: This software is furnished "as is", without technical support, and
    with no warranty, expressed or implied, as to its usefulness for any purpose. In
    no event shall the author or copyright holder be liable for any claim, damages,
    or other liability, whether in an action of contract, tort or otherwise, arising
    from, out of or in connection with the software or the use or other dealings in
    the software.

    This code provides baseline functions for the receiving end of a wireless link,
    that is being controlled from a Wii Nunchuk controller. It has been extracted from
    Quadruped_RC. It should therefore work, but is unproven in this reduced form.

*/
// Define general constants
#define BattMin 804 // minimum A0 reading to trigger a battery LOW event
#define CmdPin 3  // pin assigned to transceiver CMD pin
#define DbLLX 117 // JoyX deadband lower limit
#define DbULX 137 // JoyX deadband Upper limit
#define DbLLY 118 // JoyY deadband lower limit
#define DbULY 138 // JoyY deadband Upper limit

// Declare and initialise global variables
int BattAv; // average battery voltage
int BattCnt; // battery failed 1s time-out counter
int BattSum; // cumulative battery voltage
int BattVol; // instantaneous battery voltage
int C_Cnt; // counter used in 'C' button detection
byte C_Dn; // counter for 'C' button down period
byte C_Up; // counter for 'C' button up period
byte checksum; // XOR Rx data to detect corruption at edge of range
int CZ = 0; // received button values
boolean CZ_Wait; // flag used for button release wait function
unsigned long interval; // main loop interval in microseconds
int JoyX; // received value
int JoyXV; // converted value 0 - 127
int JoyY; // received value
int JoyYV; // converted value 0 - 128
unsigned long nextMicros; // main loop interval timer in microseconds
int RTxTimeout = 0; // counter used to auto-reset if WiFi fails
int RxCZ = 0; // buffered received CZ value
int RxJoyX = 0; // buffered received JoyX value
int RxJoyY = 0; // buffered received JoyY value
boolean RxRec = false ; // set true when a valid frame of data is received
int RxState = 0; // receiver state machine state
int RxVal = -1; // value received from serial Rx
int Z_Cnt; // counter used in 'Z' button detection
byte Z_Dn; // counter for 'Z' button down period
byte Z_Up; // counter for 'Z' button up period


void setup() {
  // put your setup code here, to run once:
  setDefaults();
  Serial.begin(9600); // baud rate for Rx/Tx comms
  runPOST();
  nextMicros = micros() + interval; // set loop timer
}

void loop() {
  // put your main code here, to run repeatedly without timer limits

  // regularly check serial receive buffer
  ReadRx();
  if (RxRec) {
    // a valid frame of data has been received over the wireless interface
    // frames should be received every 40ms; if not then auto reset
    RxRec = false; RTxTimeout = 25; // set timeout to approx 500ms
    decodeCZ(); // regularly track button presses

    // respond to joystick demands every 40ms (25Hz)
    if ((JoyX >= DbLLX) && (JoyX <= DbULX) && (JoyY >= DbLLY) && (JoyY <= DbULY)) {
      // joystick is in centre deadband position
      // put code here that responds to releasing the joystick
    }
    if (Z_Dn < 1) {
      // 'Z' button is not pressed so normal joystick movements
      if (JoyY > DbULY) {} // code responding to Joy Y pressed forward
      if (JoyY < DbLLY) {} // code responding to Joy Y pulled backward
      if (JoyX > DbULX) {} // code responding to Joy X pressed right
      if (JoyX < DbLLX) {} // code responding to Joy X pressed left
    } else {
      // 'Z' button pressed so perform special actions
      if (JoyY > DbULY) {} // code responding to Joy Y pressed forward
      if (JoyY < DbLLY) {} // code responding to Joy Y pulled backward
      if (JoyX > DbULX) {} // code responding to Joy X pressed right
      if (JoyX < DbLLX) {} // code responding to Joy X pressed left
    }
  }


  if (micros() >= nextMicros) {
    // do these tasks every 20ms based on interval value
    // note that you can change the speed of this code by changing interval
    nextMicros = nextMicros + interval; // set next time point
    
    // if WiFi fails stop movement
    if (RTxTimeout > 0) {
      RTxTimeout--;
      if (RTxTimeout == 1) {
        Serial.println(F("WiFi failed!..."));

        // put code here to handle wireless link failure
        
      }
    }
    
    // check battery voltage averaged over 16 cycles
    BattVol = analogRead(A0);
    BattAv = BattSum >> 4; BattSum = BattSum + BattVol - BattAv;
    if (BattAv <= BattMin) {
      // battery voltage has reached minimum level
      // a one second timeout counter avoids brownouts and glitches
      BattCnt++; if (BattCnt > 50) {BatteryFailed();}
    } else {BattCnt = 0;} // reset battery LOW timeout
//    Serial.print(F("0,")); Serial.print(BattAv); Serial.println(F(",816"));
  }

}

// ----------------------------------------------------------------------

void runPOST() {
  // called during start-up
  Serial.println(F("\n\nQuadruped 'RC' v0.09"));
  Serial.println(F("Starting POST..."));

  // put any power-on code here
  
  Serial.println(F("POST complete!"));
}

// ----------------------------------------------------------------------

void setDefaults() {
  // load default values into variables
  BattCnt = 0; // battery failed 1s time-out counter
  BattSum = BattMin << 4; //  pre-set cumulative battery voltage
  C_Cnt = 0; // counter used in 'C' button detection
  C_Dn = 0; // counter for 'C' button down period
  C_Up = 50; // counter for 'C' button up period
  CZ_Wait = false; // flag used for button release wait function
  interval = 20000; // main loop interval in microseconds, 50Hz
  JoyX= 0; // received value
  JoyXV = 0; // converted value 0 - 127
  JoyY = 0; // received value
  JoyYV = 0; // converted value 0 - 128
  Z_Cnt = 0; // counter used in 'Z' button detection
  Z_Dn = 0; // counter for 'Z' button down period
  Z_Up = 50; // counter for 'Z' button up period
}

