
// ----------------------------------------------------------------------

void BatteryFailed() {
  // if battery voltage drops below trigger level for more than 1 second
  // we end up here, and never return!

  // put code here to handle this condition
  
  while (true) {} // do nothing forever
}

// ----------------------------------------------------------------------

void decodeCZ() {
  // called whenever Rx data has been received (25Hz) to track button presses
  
  // check 'Z' button which is active LOW
  if ((CZ & 1) == 0) {
    // 'Z' button is being pressed
    Z_Dn++; Z_Up = 0;
    if (Z_Dn >= 50) {Z_Dn = 50;} // limit 'Z' down count to 2 seconds
  } else {
    // 'Z' button is released or not pressed
    if (Z_Up < 50) {Z_Up++;}
    if ((Z_Up == 25) && (Z_Cnt > 0)) {
      // button released for 1 second and presses were counted
      } Z_Cnt = 0; Z_Up = 50;
  }
  if ((Z_Dn > 0) && (Z_Dn < 25)) {
    // 'Z' button was pressed for less than 1 second
    Z_Cnt++;
    Serial.print(F("Z_Cnt=")); Serial.println(Z_Cnt);
  } Z_Dn = 0;
  
  // check 'C' button which is active LOW
  if ((CZ & 2) == 0) {
    // 'C' button is being pressed
    C_Dn++; C_Up = 0;
    
    if (C_Dn >= 25) {
      C_Dn = 25; // limit C_Dn count to 25
      // 'C' button is pressed > 1 seconds

    }
  } else {
    // 'C' button is released or not pressed
    if (C_Up < 50) {C_Up++;}
    if ((C_Up == 25) && (C_Cnt > 0)) {
      // button released for 1 second and presses were counted

    } C_Cnt = 0; C_Up = 50;
  }

  if (C_Dn > 0) {
    if (C_Dn < 25) {
      // 'C' button was pressed for less than 1 second so count it
      C_Cnt++;
      Serial.print(F("C_Cnt=")); Serial.println(C_Cnt);
    } else {
      // if 'C' was held >=1 second then clear the count
      C_Cnt = 0;
    }
  } C_Dn = 0;
}

// ----------------------------------------------------------------------

void ReadRx() {
  // reads the serial receive buffer looking for a valid sequence of bytes
  // we expect to receive a 6 byte frame with a 2 byte key and 1 byte checksum
  // the checksum is for detecting edge of range data corruption
  // values are only transferred on receipt of a valid frame
  RxVal = Serial.read();
  if (RxVal != -1) {
    // receiver contains a data byte
    switch (RxState) {
      case 0: // check for first key value
        if (RxVal == 0x0AA) {
          checksum = 0x0AA; RxState++;
//          Serial.println("\n");
//          Serial.println("K0");
        } break;
      case 1: // check for second key value
        if (RxVal == 0x055) {
          checksum = checksum ^ RxVal; RxState++;
//          Serial.println("K1");
        } else {
          RxState = 0;
          Serial.println("Invalid K1");
        } break;
      case 2: // receive JoyX value, centre value = 127
        checksum = checksum ^ RxVal;
        RxJoyX = RxVal; RxState++;
        break;
      case 3: // receive JoyY value, centre value = 128
        checksum = checksum ^ RxVal;
        RxJoyY = RxVal; RxState++;
        break;
      case 4: // receive CZ value
        checksum = checksum ^ RxVal;
        RxCZ = RxVal; RxState++;
        break;
      case 5: // receive checksum value and confirm it is valid
        if (checksum == RxVal) {
          // frame checksum byte is confirmed as valid
          JoyX = RxJoyX; JoyY = RxJoyY; CZ = RxCZ;
          RxRec = true;
          // Only use print statements at the end of the received frame
          // you can only send up to 30 characters
//            PrintBinary(JoyX);
//            PrintBinary(JoyY);
//            PrintBinary(CZ);
        } else {
          // frame checksum byte is invalid
//          Serial.println("Invalid checksum");
//          PrintBinary(RxVal);
        }
        RxState = 0; // reset state machine
//        Serial.println(".");
//        PrintBinary(checksum);
        break;
    }
  }
}

// ----------------------------------------------------------------------



