
// --------------------------------------------------------------------------------

void Gun_Moves() {
  // called every 40ms whenever GunMode > 0
  // modes:
  //  0 - no action
  //  1 - centre gun, then no action
  //  2 - move gun whilst talking
  //  3 - Gun side to side sin() function
  //  4 - Air defence Gun engagement
  if (GunDel > 0) {GunDel--; return;} // delay set by sub tasks

  switch (GunMode) {
    case 0: break;  // no action
    case 1: // centres Gun within 1 sec
      servoTgt[0] = Gun0; servoCnt[0] = 25; GunMode = 99; break;
    case 2: // move Gun whilst talking
      Gun_Moves_2(); break;
    case 3: // Gun side to side sin() function
      Gun_Moves_3(); break;
    case 4: // Air defence Gun engagement
      Gun_Moves_4(); break;
    
    case 99:  // wait for Gun move to end
      if (servoCnt[0] == 0) {GunMode = 0; detachServo(0);}
      break;
  }
}

// --------------------------------------------------------------------------------

void Gun_Moves_2() {
  // move gun side to side whilst talking
  switch (GunSub) {
    case 0: // set a new target
      if (servoVal[0] != Gun0) {
        // gun is not central, so centre it
        servoTgt[0] = Gun0;
      } else {
        // head is looking to the right, so choose a left angle range
        if (random(8) > 3) {servoTgt[0] += (Gun60N - Gun0)/3;}
        else {servoTgt[0] += (Gun60P - Gun0)/3;}
      } servoCnt[0] = 10;
      GunSub++; break;
    case 1: // wait for target to be reached
      if (servoTgt[0] == servoVal[0]) {GunSub++;}
      break;
    case 2: // random pause before restart
      GunDel = 5 + random(10); GunSub = 0;
      break;
  }
}

// --------------------------------------------------------------------------------

void Gun_Moves_3() {
  // side to side crude sin() function
  switch (GunSub) {
    case 0: // initialise
      GunAmp = (Gun60N - Gun0)/2; GunCnt = 12;
      GunSub++; break;
    case 1: // gun at 0°
      servoTgt[0] = Gun0; servoCnt[0] = GunCnt;
      GunNext = GunSub + 1; GunSub = 99; break;
    case 2: // gun tgt 30°
      servoTgt[0] = Gun0 + (0.5 * GunAmp); servoCnt[0] = GunCnt;
      GunNext = GunSub + 1; GunSub = 99; break;
    case 3: // gun tgt 60°
      servoTgt[0] = Gun0 + (0.87 * GunAmp); servoCnt[0] = GunCnt;
      GunNext = GunSub + 1; GunSub = 99; break;
    case 4: // gun tgt 90°
      servoTgt[0] = Gun0 + GunAmp; servoCnt[0] = GunCnt;
      GunNext = GunSub + 1; GunSub = 99; break;
    case 5: // gun tgt 60°
      servoTgt[0] = Gun0 + (0.87 * GunAmp); servoCnt[0] = GunCnt;
      GunNext = GunSub + 1; GunSub = 99; break;
    case 6: // gun tgt 30°
      servoTgt[0] = Gun0 + (0.5 * GunAmp); servoCnt[0] = GunCnt;
      GunNext = 1; GunAmp = -GunAmp; GunSub = 99; break;

    case 99:
      if (servoVal[0] == servoTgt[0]) {GunSub = GunNext;}
      break;
  }
}

// --------------------------------------------------------------------------------

void Gun_Moves_4() {
  // Air defence Gun engagement
  // when active, called as a task every 40ms
  if (GunDel > 0) {GunDel--; return;}

  switch (GunSub) {
    case 0: // initialise, ensure gun is at 0°
      if (servoTgt[0] != Gun0) {servoCnt[0] = 25;}
      GunTgt0 = false; GunTgt1= false;  // clear target detected flags
      GunSub++; break;
    case 1: // wait for end of head sweep
      if (!GunAirEn) {GunSub = 0; return;}  // exit if gun is disabled
      if (Range <= 250) {
        // a target is being detected
        if (!GunTgt0) {GunTgt0 = true; GunAng0 = HeadAngle;} // first point detected
        else {
          // more points detected so record latest point and get gun ready
          GunTgt1 = true; GunAng1 = HeadAngle;
          GunTgtAng = GunAng0 + ((GunAng1 - GunAng0)/2);
          SetServoNow(0,getGunPWM(GunTgtAng));
        }
      } else if (Range <= 333) {
        // target detected but not in range, so fire or just move the gun
        if (!GunTgt0) {
          // no target in range yet, so just move the gun to look at object
          servoTgt[0] = getGunPWM(HeadAngle); servoCnt[0] = 10; GunCnt = 25;
        } else {
          // a target has been detected to go into fire mode
          GunTgt1 = true; GunAng1 = HeadAngle;
          GunTgtAng = GunAng0 + ((GunAng1 - GunAng0)/2);
          SetServoNow(0,getGunPWM(GunTgtAng));  GunSub = 2;
        }
      } else {
        // Range > 333mm so check for target being seen previously
        if (GunTgt0) {
          // target was seen, so record transition point
          GunTgt1 = true; GunAng1 = HeadAngle;
          GunTgtAng = GunAng0 + ((GunAng1 - GunAng0)/2);
          SetServoNow(0,getGunPWM(GunTgtAng));  GunSub = 2;
        }
      }
      // test for target near end of sweep
      if ((HeadAngle == -60) || (HeadAngle == 60)) {
        if (GunTgt0) {
          GunTgt1 = true; GunAng1 = HeadAngle;
          GunTgtAng = GunAng0 + ((GunAng1 - GunAng0)/2);
          SetServoNow(0,getGunPWM(GunTgtAng));
          GunSub = 2;
        }
      } break;
    case 2: // engage target if one was seen in the last sweep
      if (!GunAirEn) {GunSub = 0; return;}  // exit if gun is disabled
      GunTgtAng = constrain(GunTgtAng,-60,60);  // ensuree angle is within limits
      SetServoNow(0,getGunPWM(GunTgtAng));
      // fire at target
      PrintTx += "!" + String(GunTgtAng + 90) + ".";
      GunFire = 1;
      GunTgt0 = false; GunTgt1= false;  // clear target detected flags
      GunSub = 1; GunCnt = 25;
      break;
  }
  // return gun to its rest position after firing?
  if (GunCnt > 0) {
    GunCnt--; if (GunCnt == 0) {servoTgt[0] = Gun0; servoCnt[0] = 25;}
  }
}

// --------------------------------------------------------------------------------

void Head_Moves() {
  // called every 40ms whenever HeadMode > 0
  // modes:
  //  0 - no action
  //  1 - centre head, then no action, power off
  //  2 - move head whilst talking
  //  3 - air defence side to side scanning
  if (HeadDel > 0) {HeadDel--; return;} // delay set by sub tasks

  switch (HeadMode) {
    case 0: break;  // no action
    case 1: // centres head within 1 sec
      servoTgt[1] = Sen0; servoCnt[1] = 25; HeadMode = 99; break;
    case 2: // move head whilst talking
      Head_Moves_2(); break;
    case 3: //  3 - air defence side to side scanning
      Head_Moves_3(); break;
    
    case 99:  // wait for head to stop moving, then rest
      if ((servoCnt[1] == 0) || (servoTgt[1] == servoVal[1])) {
        // Head is at target
        HeadMode = 0; servoCnt[1] = 0; detachServo(1);
      } break;
  }
}

// --------------------------------------------------------------------------------

void Head_Moves_2() {
  // move head side to side whilst talking
  switch (HeadSub) {
    case 0: // move head to centre, then set a new target
      if (servoVal[1] != Sen0) {
        // head is is not central, so centre it
        servoTgt[1] = Sen0;
      } else {
        // head is looking to the right, so choose a left angle range
        servoTgt[1] = (((Sen60N - Sen0) * (2 + random(5)))/18);
        if (random(8) > 3) {servoTgt[1] = Sen0 + servoTgt[1];}
        else {servoTgt[1] = Sen0 - servoTgt[1];}
      }
      servoCnt[1] = 1 + (abs(servoTgt[1] - servoVal[1])/10);
      HeadSub++; break;
    case 1: // wait for target to be reached
      if (servoTgt[1] == servoVal[1]) {HeadSub++;}
      break;
    case 2: // random pause before restart
      HeadDel = 5 + random(10); HeadSub = 0;
      break;
  }
}

// --------------------------------------------------------------------------------

void Head_Moves_3() {
  // move head side to side for range scanning in air defence mode
  // for scanning movement to proceed HeadAirEn == true
  // send range data before moving to the next position
  if (App == 1) {
    // Air defence app is connected
    if (HCSR04 ||(VL53L1X_Task > 0)) {
      // if a ranging device is enabled then send Range values
      PrintTx += ">" + String(Range) + "," + String(HeadAngle + 90) + ".";
    } else {PrintTx += ">" + String(LtofLimit) + "," + String(HeadAngle + 90) + ".";}
  }
  if (!HeadAirEn) {
    // movement is not enabled
    if (HeadSub == 0) {HeadSub = -1; servoTgt[1] = Sen0; servoCnt[1] = 5;}
    HeadDel = 0; return;
  }
  HeadSub = abs(HeadSub);

  switch (HeadSub) {
    case 0: // initialise and start from the centre position
      HeadAngle = 0;  // set initial angle as centre, facing forward
      servoTgt[1] = Sen0; servoCnt[1] = 5; HeadSub = 99;
      break;
    case 1: // start from the centre, swing right
      SetServoNow(1,getHeadPWM(HeadAngle));
      HeadAngle+= HeadInc;
      if (HeadAngle > 60) {
        HeadAngle = 60; HeadSub++;
        if (App == 1) {PrintTx += ">-1,60.";} // Air defence app is connected
      } break;
    case 2: // swing right to left, +60 to -60
      SetServoNow(1,getHeadPWM(HeadAngle));
      HeadAngle-= HeadInc;
      if (HeadAngle < -60) {
        HeadAngle = -60; HeadSub = 1;
        if (App == 1) {PrintTx += ">-1,-60.";}  // Air defence app is connected
      } break;

    case 99: // wait for head to centralise, then disable function ready for moves
      if (servoVal[1] == Sen0) {HeadSub = 1;}
      break;
  }
}

// --------------------------------------------------------------------------------

void JoyMoveBwd() {
  // called from main loop to respond to joystick demands
  // this function drives and steers in a backwards direction
  // Serial.println("JoyMoveBwd");
  if (Drive == 0) {
    // the start of a new movement
    Drive = JoyMode; SetLedMode(23); PWM_Start = PWM_StartMax;
  }
  // ensure joystick values are in the required range
  if (JoyX < 128) {JoyXV = 127 - JoyX;} // convert -ve vector to +ve
  else {JoyXV = JoyX - 128;} // ensure JoyX = 0 - 128
  if (JoyY < 128) {JoyYV = 127 - JoyY;} // convert -ve vector to +ve
  else {JoyYV = JoyY - 128;} // ensure JoyY = 0 - 128
  JoySpd = JoyYV; if (JoyXV > JoyYV) {JoySpd = JoyXV;}
  if (Gear == 1) {JoySpd = PWM_Start + ((JoySpd *  3)/10);}  // 1st gear demand
  if (Gear == 2) {JoySpd = PWM_Start + ((JoySpd *  6)/10);}  // 2nd gear demand
  if (Gear == 3) {JoySpd = PWM_Start + ((JoySpd * 10)/10);}  // 3rd gear demand
  if (Gear == 4) {JoySpd = PWM_Start + ((JoySpd * 14)/10);}  // 4th gear demand
  if (Gear == 5) {JoySpd = PWM_Start + ((JoySpd * 18)/10);}  // 5th gear demand
  LedSpd = 1 + JoySpd;  // grab speed for LED animation

  // now apply steering, this is achieved by slowing down the track on the side
  // to which we want to turn, and increasing the power on the other side by 33%
  if (JoyX < DbLLX) {
      // turning to the left in reverse
    Steer = ((JoySpd * (DbLLX - JoyX))/192);
    DriveLft = -JoySpd + Steer; DriveRht = -JoySpd - (Steer/3);
  } else if (JoyX > DbULX) {
      // turning to the right in reverse
    Steer = -((JoySpd * (JoyX - DbULX))/192);
    DriveLft = -JoySpd + (Steer/3); DriveRht = -JoySpd - Steer;
  } else {Steer = 0; DriveLft = -JoySpd; DriveRht = -JoySpd;}
  
  // now apply demand
  DriveLft = constrain(DriveLft,-255,-1);
  DriveRht = constrain(DriveRht,-255,-1);
  // Serial.println("MotorPWM (" + String(DriveLft) + "," + String(DriveRht) + "," + String(DriveLft) + "," + String(DriveRht) + ")");
  MotorPWM (DriveLft,DriveRht);
  if (PWM_Start > PWM_StartMin) {PWM_Start = PWM_StartMin + ((PWM_Start - PWM_StartMin)/2);}
}

// --------------------------------------------------------------------------------

void JoyMoveFwd() {
  // called from main loop to respond to joystick demands
  // this function drives and steers in a forwards direction
  // Serial.println("JoyMoveFwd");
  if (Drive == 0) {
    // the start of a new movement
    Drive = JoyMode; SetLedMode(21); PWM_Start = PWM_StartMax;
  }
  // ensure joystick values are in the required range
  if (JoyX < 128) {JoyXV = 127 - JoyX;} // convert -ve vector to +ve
  else {JoyXV = JoyX - 128;} // ensure JoyX = 0 - 128
  if (JoyY < 128) {JoyYV = 127 - JoyY;} // convert -ve vector to +ve
  else {JoyYV = JoyY - 128;} // ensure JoyY = 0 - 128
  JoySpd = JoyYV; if (JoyXV > JoyYV) {JoySpd = JoyXV;}
  if (Gear == 1) {JoySpd = PWM_Start + ((JoySpd *  3)/10);}  // 1st gear demand
  if (Gear == 2) {JoySpd = PWM_Start + ((JoySpd *  6)/10);}  // 2nd gear demand
  if (Gear == 3) {JoySpd = PWM_Start + ((JoySpd * 10)/10);}  // 3rd gear demand
  if (Gear == 4) {JoySpd = PWM_Start + ((JoySpd * 14)/10);}  // 4th gear demand
  if (Gear == 5) {JoySpd = PWM_Start + ((JoySpd * 18)/10);}  // 5th gear demand
  LedSpd = 1 + JoySpd;  // grab speed for LED animation

  // now apply steering, this is achieved by slowing down the track on the side
  // to which we want to turn, and increasing the power on the other side by 33%
  if (JoyX < DbLLX) {
    // turning to the left going forward
    Steer = ((JoySpd * (DbLLX - JoyX))/192);
    DriveLft = JoySpd - Steer; DriveRht = JoySpd + (Steer/3);
  } else if (JoyX > DbULX) {
    // turning to the right going forward
    Steer = -((JoySpd * (JoyX - DbULX))/192);
    DriveLft = JoySpd - (Steer/3); DriveRht = JoySpd + Steer;
  } else {Steer = 0; DriveLft = JoySpd; DriveRht = JoySpd;}
  
  // now apply constraints and demand
  DriveLft = constrain(DriveLft,1,255);
  DriveRht = constrain(DriveRht,1,255);
  // Serial.println("MotorPWM (" + String(DriveLft) + "," + String(DriveRht) + "," + String(DriveLft) + "," + String(DriveRht) + ")");
  MotorPWM (DriveLft,DriveRht);
  if (PWM_Start > PWM_StartMin) {PWM_Start = PWM_StartMin + ((PWM_Start - PWM_StartMin)/2);}
}

// --------------------------------------------------------------------------------

void JoyTurnLft() {
  // called from main loop to respond to joystick demands
  // this function neutral turns in a leftwards direction
  // Serial.println("JoyTurnLft");
 if (Drive == 0) {
    // the start of a new movement
    Drive = JoyMode; SetLedMode(25); PWM_Start = PWM_StartMax;
  }
  // ensure joystick values are in the required range
  if (JoyX < 128) {JoyXV = 127 - JoyX;} // convert -ve vector to +ve 0 - 128
  else {JoyXV = JoyX - 128;} // ensure JoyX = 0 - 128
  JoySpd = JoyXV;
  if (Gear == 1) {JoySpd = PWM_Start + ((JoySpd *  3)/10);}  // 1st gear demand
  if (Gear == 2) {JoySpd = PWM_Start + ((JoySpd *  6)/10);}  // 2nd gear demand
  if (Gear == 3) {JoySpd = PWM_Start + ((JoySpd * 10)/10);}  // 3rd gear demand
  if (Gear == 4) {JoySpd = PWM_Start + ((JoySpd * 14)/10);}  // 4th gear demand
  if (Gear == 5) {JoySpd = PWM_Start + ((JoySpd * 18)/10);}  // 5th gear demand
  LedSpd = 1 + JoySpd;  // grab speed for LED animation

  // now apply steering
  Steer = -JoySpd; DriveLft = -JoySpd; DriveRht = JoySpd;
  // now apply demand
  DriveLft = constrain(DriveLft,-255,-1); DriveRht = constrain(DriveRht,1,255);
  // Serial.println("MotorPWM (" + String(DriveLft) + "," + String(DriveRht) + "," + String(DriveLft) + "," + String(DriveRht) + ")");
  MotorPWM (DriveLft,DriveRht);
  if (PWM_Start > PWM_StartMin) {PWM_Start = PWM_StartMin + ((PWM_Start - PWM_StartMin)/2);}
}

// --------------------------------------------------------------------------------

void JoyTurnRgt() {
  // called from main loop to respond to joystick demands
  // this function turns in a rightwards direction
  // Serial.println("JoyTurnRgt");
 if (Drive == 0) {
    // the start of a new movement
    Drive = JoyMode; SetLedMode(26); PWM_Start = PWM_StartMax;
  }
  // ensure joystick values are in the required range
  if (JoyX < 128) {JoyXV = 127 - JoyX;} // convert -ve vector to +ve 0 - 128
  else {JoyXV = JoyX - 128;} // ensure JoyX = 0 - 128
  JoySpd = JoyXV;
  if (Gear == 1) {JoySpd = PWM_Start + ((JoySpd *  3)/10);}  // 1st gear demand
  if (Gear == 2) {JoySpd = PWM_Start + ((JoySpd *  6)/10);}  // 2nd gear demand
  if (Gear == 3) {JoySpd = PWM_Start + ((JoySpd * 10)/10);}  // 3rd gear demand
  if (Gear == 4) {JoySpd = PWM_Start + ((JoySpd * 14)/10);}  // 4th gear demand
  if (Gear == 5) {JoySpd = PWM_Start + ((JoySpd * 18)/10);}  // 5th gear demand
  LedSpd = 1 + JoySpd;  // grab speed for LED animation

  // now apply steering
  Steer = JoySpd; DriveLft = JoySpd; DriveRht = -JoySpd;
  // now apply demand
  DriveLft = constrain(DriveLft,1,255); DriveRht = constrain(DriveRht,-255,-1);
  // Serial.println("MotorPWM (" + String(DriveLft) + "," + String(DriveRht) + "," + String(DriveLft) + "," + String(DriveRht) + ")");
  MotorPWM (DriveLft,DriveRht);
  if (PWM_Start > PWM_StartMin) {PWM_Start = PWM_StartMin + ((PWM_Start - PWM_StartMin)/2);}
}

// --------------------------------------------------------------------------------

void MoveGun() {
  // called when servo value does not match target value, at 20ms intervals
  // when setting up a move you must set the target value and the number of steps in servoCnt[]
  if (servoCnt[0] > 1) {
    // in the middle of a movement
    servoVal[0] += (servoTgt[0] - servoVal[0])/servoCnt[0];
    servoCnt[0]--;
  } else {
    // last step in the movement
    servoVal[0] = servoTgt[0]; servoCnt[0] = 0;
  }
  // Update the servo PWM value, if not playing audio
  if (IsrRun || Talk) {
    // playing audio, so set the mask such that it is updated during the ISR
    ServoMask |= 0b000000001;
  } else {
    // not playing audio, so change servo PWM directly
    if (!servoAtt[0]) {attachServoN(0);}
    else {servoInst[0].writeMicroseconds(servoVal[0]);}
  }
}

// --------------------------------------------------------------------------------

void MoveHead() {
  // called when servo value does not match target value, at 20ms intervals
  // when setting up a move you must set the target value and the number of steps in servoCnt[]
  if (servoCnt[1] > 1) {
    // in the middle of a movement
    servoVal[1] += (servoTgt[1] - servoVal[1])/servoCnt[1];
    servoCnt[1]--;
  } else {
    // last step in the movement
    servoVal[1] = servoTgt[1]; servoCnt[1] = 0;
  }
  // update the Head servo PWM value
  if (IsrRun || Talk) {
    // playing audio, so set the mask such that it is updated during the ISR
    ServoMask |= 0b000000010;
  } else {
    // not playing audio, so change servo PWM directly
    if (!servoAtt[1]) {attachServoN(1);}
    else {servoInst[1].writeMicroseconds(servoVal[1]);}
  }
}

// --------------------------------------------------------------------------------

void SetGunMode(int16_t zM) {
  // called to initiate a Gun move task
  GunAmp = 0; GunCnt = 0; GunDel = 0; GunMode = zM; GunSub = 0;
}

// --------------------------------------------------------------------------------

void SetGunTo(int16_t zVal) {
  // Sets Gun servo immediately to value zVal and clears flags
  servoTgt[0] = servoVal[0]; servoCnt[0] = 0;
  // Update the servo PWM value, if not playing audio
  if (IsrRun || Talk) {
    // playing audio, so set the mask such that it is updated during the ISR
    ServoMask |= 0b000000001;
  } else {
    // not playing audio, so change servo PWM directly
    if (!servoAtt[0]) {attachServoN(0);}
    else {servoInst[0].writeMicroseconds(servoVal[0]);}
  }
}

// --------------------------------------------------------------------------------

void SetHeadMode(int16_t zM) {
  // called to initiate a Head move task
  HeadDel = 0; HeadMode = zM; HeadSub = 0;
}

// --------------------------------------------------------------------------------

void SetHeadTo(int16_t zVal) {
  // Sets head servo immediately to value zVal and clears flags
  servoTgt[1] = servoVal[1]; servoCnt[1] = 0;
  // update the Head servo PWM value
  if (IsrRun || Talk) {
    // playing audio, so set the mask such that it is updated during the ISR
    ServoMask |= 0b000000010;
  } else {
    // not playing audio, so change servo PWM directly
    if (!servoAtt[1]) {attachServoN(1);}
    else {servoInst[1].writeMicroseconds(servoVal[1]);}
  }
}

// --------------------------------------------------------------------------------

