
// ---------------------------------------------------------------------------------

void attachServoN(int zS) {
  // attach a single servo zS, 0 - 1
  if (ESC) return;
  
  ServoEn = true; // flag at least 1 servo is attached
  // attach this servos
  // servoInst[zS].setPeriodHertz(PWM_Freq);    // set PWM frequency
  // servoInst[zS].attach(servoPins[zS],500,2400);
  servoInst[zS].writeMicroseconds(servoVal[zS]);
  servoTgt[zS] = servoVal[zS]; // align target pointer
  servoAtt[zS] = true;
}

// ---------------------------------------------------------------------------------

void attachServos(int zDel) {
  // Attach both gun and LTOF servos
  // zDel delay is used during power-up reset, otherwiswe set to 0
  // PWM_Freq frequency is 30 kHz for motor H-bridge drivers
  if (ESC) return;
  
  ServoEn = true; // flag servos are attached
  // attach both servos
  for (int zS = 0; zS < 2; zS++) {
    if (!ServoAttOnce) {
      servoInst[zS].setPeriodHertz(PWM_Freq);     // set PWM frequency
      servoInst[zS].attach(servoPins[zS],500,2400);
    }
    servoInst[zS].writeMicroseconds(servoVal[zS]);
    servoTgt[zS] = servoVal[zS];                // align target pointer
    servoAtt[zS] = true;
    delay(zDel);
  }
  ServoAttOnce = true;
  // Serial.println("Turret servos attached.");
}

// --------------------------------------------------------------------------------

void Change_DispMode() {
  // Called from the SW0 button relase action or Classic Pro 'L' button
  if (MainMode == 0) {
    switch (DispMode) {
      case  0: DispMode = 3; DispRet = 3; break;  // Battery
      default: DispMode = 0; break;               // Sleep
    }
  }
  else if (MainMode == 1) {
    // Sonar fixed mode, SW0 cycles display options
    // Description is new DispMode set            
    switch (DispMode) {
      case 10: DispMode = 11; break;  // Range
      default: DispMode = 11; break;  // Range
    }
  }
  else if (MainMode == 2) {
    // Sonar auto mode, SW0 cycles display options
    // Description is new DispMode set            
    switch (DispMode) {
      case 20: DispMode = 21; break;  // Range
      case 21: DispMode = 22; break;  // Range map
      default: DispMode = 21; break;  // Range
    }
  }
    else if (MainMode == 3) {
    // LTOF fixed mode, SW0 cycles display options
    // Description is new DispMode set            
    switch (DispMode) {
      case 30: DispMode = 31; break;  // Range
      default: DispMode = 31; break;  // Range
    }
  }
  else if (MainMode == 4) {
    // LTOF auto mode, SW0 cycles display options
    // Description is new DispMode set            
    switch (DispMode) {
      case 40: DispMode = 41; break;  // Range
      case 41: DispMode = 42; break;  // Range map
      default: DispMode = 41; break;  // Range
    }
  }
  else if (MainMode == 5) {
    // Audio mode, SW0 cycles display options in MainMode = 50
  }
  else if (MainMode == 6) {
    // Drive mode, cycle display options
    // Description is new DispMode set            
    // if connected to Wii transceiver then show additional screens
    switch (DispMode) {
      case 60: DispMode = 61; break;  // Motor PWM
      case 61: DispMode = 62; break;  // Motor PWM waveforms
      case 62: DispMode = 63; break;  // Slot sensors
      case 63: DispMode = 64; break;  // Slot periods
      case 64: DispMode = 65; break;  // Slot counts
      case 65: DispMode = 66; break;  // Slot rpms
      case 66:
        if (WiFiEn) {DispMode = 67;}  // X/Y joystick demands
        else {DispMode =  61;}        // Motor PWM
        break;
      case 67: DispMode = 68; break;  // Wii control data
      default: DispMode = 61; break;  // Motor PWM
      }
  }
  else if (MainMode == 7) {
    // Wi-Fi mode, cycle display options
    // Description is new DispMode set            
    switch (DispMode) {
      case 60: DispMode = 61; break;  // Motor PWM
      case 61: DispMode = 62; break;  // Motor PWM waveforms
      case 62: DispMode = 63; break;  // Slot sensors
      case 63: DispMode = 64; break;  // Slot periods
      case 64: DispMode = 65; break;  // Slot counts
      case 65: DispMode = 66; break;  // Slot rpms
      case 66: DispMode = 67; break;  // X/Y joystick demands
      case 67: DispMode = 68; break;  // Wii control data
      default: DispMode = 61; break;  // Motor PWM
      }
  }
  DispDel = 0; DispCnt = 0; DispNxtCnt = 0;
  // Display_setBrightness(Brightness);
}

// --------------------------------------------------------------------------------

void checkTgts() {
  // ensure that set targets are within servo min/max limits
  servoTgt[ 0] = min16(servoTgt[ 0],Max0); servoTgt[ 0] = max16(servoTgt[ 0],Min0);
  servoTgt[ 1] = min16(servoTgt[ 1],Max1); servoTgt[ 1] = max16(servoTgt[ 1],Min1);
}

// ---------------------------------------------------------------------------------

void clearRangeData(int16_t zVal) {
  // sets all of the RangeData[] values   
  for (int zD = 0; zD < RngDpth; zD++) {RangeData[zD] = zVal;}
}

// ---------------------------------------------------------------------------------

void decodeKey(int zkeyVal) {
  // decodes zkeyVal and excutes commands on '.'
  // every time we receive a character set response to 10ms later, just in case
  // there is another packet behind it coming from the controller
  print40ms = millis() - 30;
  if (zkeyVal == 10) {return;}
  if (zkeyVal == 13) {return;}
  keyChar = char(zkeyVal);
  switch (keyChar) {
    case '.': doCmd(); return;                        // command terminator
    case '!': esp_restart(); break;                   // forces a system soft RESET
    case '~': // connected to OLED Mirror app via USB or WiFi
      if (!DispMon) {DispMon = true; Display_Mirrored();} // display mirrored message
      DispTx = 50; return;
    case '-': cmdSgn = -1; return;                    // numeric sign
    case '*': cmdMode = ' '; cmdType = ' '; cmdVal = 0; cmdSgn = 1; return; // ESC abort command
    case '0': extendCmdVal(0); return;
    case '1': extendCmdVal(1); return;
    case '2': extendCmdVal(2); return;
    case '3': extendCmdVal(3); return;
    case '4': extendCmdVal(4); return;
    case '5': extendCmdVal(5); return;
    case '6': extendCmdVal(6); return;
    case '7': extendCmdVal(7); return;
    case '8': extendCmdVal(8); return;
    case '9': extendCmdVal(9); return;
  }
  if (cmdMode == ' ') {
    // test for new Command Mode char?
    // only accept certain characters as valid commands, or ignore them
    // delay battery update by 10 seconds whilst receiving commands
    cmdMode = keyChar;
    switch (keyChar) {
      // convert upper-case
      case 'a': cmdMode = 'A'; break;
      case 'b': cmdMode = 'B'; break;
      case 'c': cmdMode = 'C'; break;
      case 'd': cmdMode = 'D'; break;
      case 'e': cmdMode = 'E'; break;
      case 'f': cmdMode = 'F'; break;
      case 'g': cmdMode = 'G'; break;
      case 'j': cmdMode = 'J'; break;
      case 'm': cmdMode = 'M'; break;
      case 'p': cmdMode = 'P'; break;
      case 'r': cmdMode = 'R'; break;
      case 's': cmdMode = 'S'; break;
      case 't': cmdMode = 'T'; break;
      case 'v': cmdMode = 'V'; break;
      case 'w': cmdMode = 'W'; break;
      case 'z': cmdMode = 'Z'; break;
    } cmdType = ' '; cmdVal = 0;
  } else {
    // test for Command Type char?
    cmdType = keyChar;
    switch (keyChar) {
      // convert to upper-case
      case 'a': cmdType = 'A'; break;
      case 'b': cmdType = 'B'; break;
      case 'c': cmdType = 'C'; break;
      case 'd': cmdType = 'D'; break;
      case 'e': cmdType = 'E'; break;
      case 'f': cmdType = 'F'; break;
      case 'h': cmdType = 'H'; break;
      case 'l': cmdType = 'L'; break;
      case 'o': cmdType = 'O'; break;
      case 'p': cmdType = 'P'; break;
      case 'r': cmdType = 'R'; break;
      case 's': cmdType = 'S'; break;
      case 't': cmdType = 'T'; break;
      case 'u': cmdType = 'U'; break;
      case 'v': cmdType = 'V'; break;
      case 'x': cmdType = 'X'; break;
      case 'y': cmdType = 'Y'; break;
    }
  }
}

// ---------------------------------------------------------------------------------

void detachServo(int16_t zS) {
  // Detatch servo zS using the release() function
  // zS = 0 - Gun servo
  // zS = 1 - Head servo
  ServoEn = false; // flag at least one servo is detached
  servoAtt[zS] = false;
  servoInst[zS].release();  // sets PWM value to zero
}

// ---------------------------------------------------------------------------------

void detachServos() {
  // detatch both servos, normally used when at rest
  if (!ServoEn) {return;}
  
  ServoEn = false; // flag servos are detached
  // detach the leg servos
  for (int zS = 0; zS < 2; zS++) {
    if (servoAtt[zS]) {
      servoInst[zS].release();  // sets PWM value to zero
    }
    servoAtt[zS] = false;
  }
}

// ---------------------------------------------------------------------------------

void DM_AudEng_() {
  //##################################
  // Audio Engine display
  //##################################
  // user has clicked on a blue field in Monitor+ display
  if ((DmX < 15) && (DmY < 21)) {
    // Add the current audio file to the Play engine
    PlayAdd(FilePath$);
  } else if ((DmX > 85) && (DmY < 21)) {
    // Add the current audio file to the Talk engine
    TalkAdd(FilePath$);
  } else {
    if (DmX < 50) {DispMode = DML;  // left side click
    } else {DispMode = DMR; }       // right side click
  }
}

// ---------------------------------------------------------------------------------

void DM_FleLst_() {
  //##################################
  // File List display
  //##################################
  // user has clicked on a blue field in Monitor+ display
  if ((DmX > 12) && (DmX < 20) && (DmY > 6)  && (DmY < 18)) {
    // Change Dir pointer, and set flag to reload file list
    if (DmB == 0) { // left mouse click
      switch (DirPnt) {
        case 'A' : DirPnt = 'M'; break;
        case 'M' : DirPnt = 'N'; break;
        case 'N' : DirPnt = 'P'; break;
        case 'P' : DirPnt = 'A'; break;
      }
    } else {
      switch (DirPnt) { // right mouse click
        case 'A' : DirPnt = 'P'; break;
        case 'M' : DirPnt = 'A'; break;
        case 'N' : DirPnt = 'M'; break;
        case 'P' : DirPnt = 'N'; break;
      }
    }
    DirLast = ' ';  // force an update in the file list
    ListPnt = 0;;   // reset the list pointer
    ListSel = -1;   // clear the selected file flag
  } else if ((DmX < 15) && (DmY > 36) && (DmY < 49)) {
    // change the attenuator setting
    if (Atten) {AttenOFF();} else {AttenON();}
  } else if ((DmX > 21) && (DmX < 69)) {
    // Add the selected audio file to the Talk engine
    int16_t zY = (6 * DmY)/99; zY = constrain(zY,0,5);
    ListSel = ListPnt + zY;
    // Serial.println("ListSel: " + String(ListSel));
    if ((Play != 0) || (Talk != 0)) {
      // Currently outputing audio, so stop it
      AudioStop(); PlayStop(); TalkStop(); SetLedMode(0);
    } else {
      if (ListSel < ListCnt) {
        FilePath$ = "/" + String(DirPnt) + "/" + FileList$[zY];
        TalkAdd(FilePath$);
      }
    }
  } else if ((DmX > 76) && (DmX < 87)) {
    // User has clicked in P/T column
    int16_t zY = (6 * DmY)/99; zY = constrain(zY,0,5);
    int16_t zListSel = ListSel; // remember the current value
    ListSel = ListPnt + zY;
    // Serial.println("ListSel: " + String(ListSel));
    if ((Play != 0) || (Talk != 0)) {
      // currently outputing audio, so stop it
      AudioStop(); PlayStop(); TalkStop(); SetLedMode(0);
    } else {
      if (ListSel < ListCnt) {
        FilePath$ = "/" + String(DirPnt) + "/" + FileList$[zY];
        if (DmX < 81) {PlayAdd(FilePath$);}
                else {TalkAdd(FilePath$);}
      }
    }
  } else if (DmX > 94) {
    // slider column
    if (DmY < 10) {
      // clicked on UP button
      if (ListPnt > 0) {ListPnt--;}
    } else if (DmY > 87) {
      // clicked on DOWN button
      if (ListPnt < (ListCnt - 5)) {ListPnt++;}
    } else {
      // clicked in slider region
      int zY = ((DmY - 10) * ListCnt)/76;
      ListPnt = zY;
      if (ListPnt > (ListCnt - 5)) {ListPnt = ListCnt - 5;}
      if (ListPnt < 0) {ListPnt = 0;}
    }
    DirLast = ' ';  // force an update in the file list
  } else {
    if (DmX < 50) {DispMode = DML;  // left side click
    } else {DispMode = DMR; }       // right side click
  }
  DispDel = 1;
}

// ---------------------------------------------------------------------------------

void DM_TalkEng_() {
  //##################################
  // Talk Engine display
  //##################################
  // user has clicked on a blue field in Monitor+ display
  if ((DmX < 15) && (DmY < 21)) {
    // Add the current audio file to the Play engine
    PlayAdd(FilePath$);
  } else if ((DmX > 85) && (DmY < 21)) {
    // Add the current audio file to the Talk engine
    TalkAdd(FilePath$);
  } else {
    if (DmX < 50) {DispMode = DML;  // left side click
    } else {DispMode = DMR; }       // right side click
  }
}

// ---------------------------------------------------------------------------------

void DoClassic() {
  // connecting the Wii Classic controller to the transceiver provides extended features
  // most of these are dependant on the MainTask running at the time
  // by default the robots drive is controlled by the right-hand joystick
  // and the Nunchuk 'C' and 'Z' buttons are front buttons right and left
  // this function is called every 40ms when WiFi is active, shortly after boot
  // HowOften(); // check the timing of this function
  RxClass = false;  // clear the received data flag, so as not to repeat
  JoyLX  = (RxWiFi[0] & 0b00111111)<<2;  // get 6-bit LX demands, 0 - 252
  if (JoyLX > 128) {JoyLX = map(JoyLX,128,252,128,255);}  // remap to 128 - 255
  JoyLY  = (RxWiFi[1] & 0b00111111)<<2;  // get 6-bit LY demands, 0 - 252
  if (JoyLY > 128) {JoyLY = map(JoyLY,128,252,128,255);}  // remap to 128 - 255
  // Serial.println("X=" + String(JoyLX) + "\tY=" + String(JoyLY));
  // gather left-hand digital pad bits as [BDR][BDD][BDL][BDU], these are active LOW bits
  WiiDigi = ((RxWiFi[4] & 0b11000000)>>4) + (RxWiFi[5] & 0b00000011);
  // gather [Select][Home][Start] centre buttons
  WiiSHS = (RxWiFi[4] & 0b00011100)>>2; // right-shifted bits
  // gather [BB][BY][BA][BX] right-hand button switches
  WiiBYAX = (RxWiFi[5] & 0b01111000)>>3; // right-shifted bits
  //##################################################################################
  //
  // All modes
  //
  //##################################################################################
  // Audio loud/soft, buttons [a] and [b]
  if (!(WiiBYAX & 0b00000010)) { // button BA pressed
    if (!BA) {
      BA = true; AttenOFF(); AttenRef = Atten;
      if ((Talk) || (!IsrRun)) {TalkAtt = Atten;}
      // say "Audio HIGH."
      if (!IsrRun) {TalkAdd("/P/AU0000.WAV");}
    }
  } else {BA = false;}
  if (!(WiiBYAX & 0b00001000)) { // button BB pressed
    if (!BB) {
      BB = true; AttenON(); AttenRef = Atten;
      if ((Talk) || (!IsrRun)) {TalkAtt = Atten;}
      // say "Audio LOW"
      if (!IsrRun) {TalkAdd("/P/AU0001.WAV");}
    }
  } else {BB = false;}

  //##################################################################################
  //
  // Wii Classic Pro - all modes
  //
  //##################################################################################
  // Left-hand [L] button, changes display mode
  if (WiiType == 'P') {
    if (!(RxWiFi[4] & 0b00100000)) {
      if (!BLT) {BLT = true; Change_DispMode();}
    } else {BLT = false;}
  }

  //##################################################################################
  //
  // Jukebox features
  //
  //##################################################################################
  // Audio track selection and playing
  // read the select, home and start buttons to choose jukebox mode
  // button reads are temporarily latched, until released, to prevent multiple events
  if (!(WiiSHS & 0b00000100)) {
    if (!Bsel) {Bsel = true; JukeboxSet(0);}
  } else {Bsel = false;}
  if (!(WiiSHS & 0b00000010)) {
    if (!Bhome) {Bhome = true; JukeboxSet(1);}
  } else {Bhome = false;}
  if (!(WiiSHS & 0b00000001)) {
    if (!Bstrt) {Bstrt = true; JukeboxSet(2);}
  } else {Bstrt = false;}
  // digi-pad is used for play, pause, next, previous track functions
  if (!(WiiDigi & 0b00001000)) { // right - 'next'
    if (!BDR) {BDR = true; BDRcnt++; BDRdwn = 0;}
  } else {BDR = false; BDRdwn++; if (BDRdwn == 25) {JukeboxNext(); BDRcnt = 0;}}
  if (!(WiiDigi & 0b00000100)) { // down - 'pause'
    if (!BDD) {BDD = true; JukeboxPause();}
  } else {BDD = false;}
  if (!(WiiDigi & 0b00000010)) { // left - 'previous'
    if (!BDL) {BDL = true; BDLcnt++; BDLdwn = 0;}
  } else {BDL = false; BDLdwn++; if (BDLdwn == 25) {JukeboxPrev(); BDLcnt = 0;}}
  if (!(WiiDigi & 0b00000001)) { // up - 'Play'
    if (!BDU) {BDU = true; JukeboxPlay();}
  } else {BDU = false;}

  // toggle audio LED animations
  if (!(WiiBYAX & 0b00000100)) { // button BY pressed
    if (!BY) {if (LedMode == 50) {SetLedMode(LedLast); LedGunMode = 0;} else {SetLedMode(50);}} BY = true;
  } else {BY = false;}

  // toggle auto moves with long button X press, if not in Wii control mode
  if ((!WiFiEn) && (MainTask != 50)) {
    // only do this if Wii control is disabled, so that the two modes don't conflict
    // toggle audio automoves, ON after long press, OFF on button click
    if (!(WiiBYAX & 0b00000001)) { // button BX pressed
      if (!BX) {
        if (AutoMove) {
          if (AutoMove) {
            SetGunMode(1);  // rest Gun if moving
            SetHeadMode(1); // rest Head if moving
          }
          AutoMove = 0; BX = true;
        } else {BX_Cnt++; if (BX_Cnt >= 50) {
          // 40ms counter time-out of 2 sec invokes AutoMove
          AutoMove = 1; BX = true;
          SetHeadMode(2);   // talking, Head movement
          SetGunMode(3);    // crude sin(), Gun movement
          }
        }
      }
    } else {
      BX = false; BX_Cnt = 0;
    }
  }

  //##################################################################################
  //
  // Task dependant features
  //
  //##################################################################################
  switch (MainTask) {
    case 50: // Audio
      // toggle audio automoves
      if (!(WiiBYAX & 0b00000001)) { // button BX pressed
        if (!BX) {if (AutoMove) {AutoMove = 0;} else {AutoMove = 1;}} BX = true;
      } else {BX = false;}
      break;
    case 71: // Wi-Fi control
      // Look for left joystick control and weapon firing.
      // Both gun and head move to demand
      if (JoyLX > 128) {
        any16t = map(JoyLX,128,255,Gun0,Gun60P);
        if (servoTgt[0] != any16t) {servoTgt[0] = any16t; servoCnt[0] = 10;}
        any16t = map(JoyLX,128,255,Sen0,Sen60P);
        if (servoTgt[1] != any16t) {servoTgt[1] = any16t; servoCnt[1] = 10;}
      } else if (JoyLX < 128) {
        any16t = map(JoyLX,0,128,Gun60N,Gun0);
        if (servoTgt[0] != any16t) {servoTgt[0] = any16t; servoCnt[0] = 10;}
        any16t = map(JoyLX,0,128,Sen60N,Sen0);
        if (servoTgt[1] != any16t) {servoTgt[1] = any16t; servoCnt[1] = 10;}
      } else {
        // Centre gun and head when no demand on left joystick
        if (servoTgt[0] != Gun0) {servoTgt[0] = Gun0; servoCnt[0] = 25;}
        if (servoTgt[1] != Sen0) {servoTgt[1] = Sen0; servoCnt[1] = 25;}
      }
      // gun trigger button is BZL, test for it going LOW
      if ((RxWiFi[5] & 0b10000000) == 0) {if ((!GunFire) || (GunFire >= 10)) {GunFire = 1;}}
      break;
  }
}

// ---------------------------------------------------------------------------------

void doCmd() {
  // a '.' has been received on the serial port so execute command if valid
  // Commands:
  // An.      - play note 'A' in octave n
  // Bbn.     - play note 'Bb' flat in ocatve n
  // Bn.      - play note 'B' in octave n
  // Cn.      - play note 'C' in octave n
  // C#n.     - play note 'C#' sharp in ocatve n
  // DLn.     - toggle display lock, n=0 OFF, n=1 ON
  // Dn.      - play note 'D' in octave n
  // DMxxyy.  - display monitor left mouse click, xx = 0-99, yy = 0-99
  // DPn.     - Air defence degrees per pulse
  // Ebn.     - play note 'Eb' flat in ocatve n
  // En.      - play note 'E' in octave n
  // Fn.      - play note 'F' in octave n
  // F#n.     - play note 'F#' sharp in ocatve n
  // Gn.      - play note 'G' in octave n
  // G#n.     - play note 'G#' sharp in ocatve n
  // GAn.     - Air defence Gun ON/OFF
  // GC.      - Air defence Gun to centre
  // JXnn.    - set global variable JX to nn
  // JYnn.    - set global variable JY to nn
  // Mn.      - Air defence modes
  // MBnn.    - move backwards until count -nn
  // MFnn.    - move forward until count nn
  // MS.      - STOP track movements
  // PTnn.    - set target wheel PWM pointer 0 - 3
  // PVnn.    - set target motor PWM, 0 - 255
  // RC.      - Air defence Radar to centre
  // RSn.     - Air defence radar sweep ON/OFF
  // SAnn.    - set target servo angle in microseconds, 600 - 2400
  // SLnn.    - set target servo lower limit in microseconds
  // STnn.    - set the target servo number 0 - 1
  // SUnn.    - set target servo upper limit in microseconds
  // SVnn.    - set target servo PWM, 500 - 2200
  // T0.      - detach the Tone o/p
  // T1.      - attach the Tone o/p, playing the last note and octave
  // TL.      - attenuator pin active ON, reduce tone volume
  // TH.      - attenuator pin inactive OFF, increase tone volume
  // Un.      - Air defence Radar ON/OFF
  // ZAn.     - Air defence app signature beat, switch to that mode if not already in it

  cmdVal*= cmdSgn;  // correct cmdVal with the sign value
  
  switch (cmdMode) {
    case ' ': break;
    case 'A':
      if (!ToneAtt) {ToneAttach();}
      switch (cmdType) {
        case ' ': ToneNote(NOTE_A,cmdVal); break;
      } break;
    case 'B':
      if (!ToneAtt) {ToneAttach();}
      switch (cmdType) {
        case ' ': ToneNote(NOTE_B,cmdVal); break;
        case 'B': ToneNote(NOTE_Bb,cmdVal); break;
      } break;
    case 'C':
      if (!ToneAtt) {ToneAttach();}
      switch (cmdType) {
        case ' ': ToneNote(NOTE_C,cmdVal); break;
        case '#': ToneNote(NOTE_Cs,cmdVal); break;
      } break;
    case 'D':
      switch (cmdType) {
        case ' ': if (!ToneAtt) {ToneAttach();} ToneNote(NOTE_D,cmdVal); break;
        case 'L':
          if (cmdVal != 0) {DispLock = true; DispOveride = DispMode;}
          else {DispLock = false;}
          break;
        case 'M':
          if (cmdSgn < 0) {}  // mouse click released
          else {
            if (cmdVal >= 10000) {
              // this is a Display Monitor mouse right-click
              // determine whether it is a left or right button click
              cmdVal /= 10000; cmdVal --; DmB = 1;
              DmY = cmdVal % 100; DmX = cmdVal/100;
            } else {
              // this is a Display Monitor mouse left-click
              DmY = cmdVal % 100; DmX = cmdVal/100; DmB = 0;
            }
                 if (DispMode == DM_AudEng)  {DM_AudEng_();}
            else if (DispMode == DM_FleLst)  {DM_FleLst_();}
            else if (DispMode == DM_TalkEng) {DM_TalkEng_();}
            else {
              // this is not a special 'clickable' display, so simply change it
              if (DmX < 50) {DispMode = DML;  // left side click
              } else {DispMode = DMR; }        // right side click
            }
          } break;
        case 'P': // Air defence sets the number of degrees per pulse
          HeadInc = cmdVal; break;
      } break;
    case 'E':
      if (!ToneAtt) {ToneAttach();}
      switch (cmdType) {
        case ' ': ToneNote(NOTE_E,cmdVal); break;
        case 'B': ToneNote(NOTE_Eb,cmdVal); break;
      } break;
    case 'F':
      if (!ToneAtt) {ToneAttach();}
      switch (cmdType) {
        case ' ': ToneNote(NOTE_F,cmdVal); break;
        case '#': ToneNote(NOTE_Fs,cmdVal); break;
      } break;
    case 'G':
      switch (cmdType) {
        case ' ': // Gn. command
         if (!ToneAtt) {ToneAttach();} ToneNote(NOTE_G,cmdVal); break;
        case '#': if (!ToneAtt) {ToneAttach();} ToneNote(NOTE_Gs,cmdVal); break;
        case 'A': // Air defence Gun ON/OFF
          if (cmdVal) {
            // say "Weapon, on."
            TalkAdd("/P/WE0001.WAV");
            SetGunMode(4); GunAirEn = true;}  // turn Gun defence ON
          else {
            // say "Weapon, off."
            TalkAdd("/P/WE0000.WAV");
            SetGunMode(1); GunAirEn = false;} // turn Gun defence Off
          break;
        case 'C': // Air defence centre the Gun in 200ms
          servoTgt[0] = Gun0; servoCnt[0] = 10;
          // say "Centre, weapon."
          TalkAdd("/P/CE0001.WAV");
          break;
      } break;
    case 'J':
      // commands used to set global variables in association with Joystick app
      switch (cmdType) {
        case 'X': // set global variable JX to cmdVal
          JX = cmdVal; //Serial.println("JX=" + String(JX));
          break;
        case 'Y': // set global variable JY to cmdVal
          JY = cmdVal; //Serial.println("JY=" + String(JY));
          break;
      } break;
    case 'M':
      // commands used to test auto drive functions
      switch (cmdType) {
        case ' ': // Air defence modes.
          if (MainTask == 24) {
            // sonar mode
            GunAirEn = false;
            if (cmdVal == 0) {
              TalkAdd("/P/AI0000.WAV");                         // say "Air defence."
              SetMainTask(24);}                                 // Air defence RESET everything OFF
            if (cmdVal == 1) {TalkAdd("/P/SW0002.WAV");}        // say "Sweep, activated."
            if (cmdVal >= 1) {HeadAirEn = true; HCSR04 = true;} // Air defence M1 radar ON
            if (cmdVal == 2) {
              TalkAdd("/P/WE0002.WAV");                         // say "Weapon, activated."
              GunAirEn = true;}                                 // Air defence M2 radar ON & Gun ON
          }
          if (MainTask == 44) {
            // LTOF mode
            GunAirEn = false;
            if (cmdVal == 0) {
              TalkAdd("/P/AI0000.WAV");                         // say "Air defence."
              SetMainTask(44);}                                 // Air defence RESET everything OFF
            if (cmdVal == 1) {TalkAdd("/P/SW0002.WAV");}        // say "Sweep, activated."
            if (cmdVal >= 1) {HeadAirEn = true; if (VL53L1X_Task == 0) {VL53L1X_ON();}}  // Air defence M1 radar ON
            if (cmdVal == 2) {
              TalkAdd("/P/WE0002.WAV");                         // say "Weapon, activated."
              GunAirEn = true;}                                 // Air defence M2 radar ON & Gun ON
          } break;
        case 'B': // move backwards cmdVal steps
          Slots_ON();  // reset and enable slot counters
          AutoStopFL = -cmdVal; AutoStopFR = -cmdVal; // set distance to travel in slot counts
          DriveTask = 2;  // set reverse auto-drive tasks
          DispMode = 65; DispDel= 0; DispCnt = 0; break;
        case 'F': // move forwards cmdVal steps
          Slots_ON();  // reset and enable slot counters
          AutoStopFL = cmdVal; AutoStopFR = cmdVal; // set distance to travel in slot counts
          DriveTask = 1;  // set forward auto-drive tasks
          DispMode = 65; DispDel= 0; DispCnt = 0; break;
        case 'L': // turn left cmdVal steps
          Slots_ON();  // reset and enable slot counters
          AutoStopFL = -cmdVal; AutoStopFR = cmdVal; // set distance to travel in slot counts
          DriveTask = 4;  // set turn left auto-drive tasks
          DispMode = 65; DispDel= 0; DispCnt = 0; break;
        case 'R': // turn right cmdVal steps
          Slots_ON();  // reset and enable slot counters
          AutoStopFL = cmdVal; AutoStopFR = -cmdVal; // set distance to travel in slot counts
          DriveTask = 3;  // set turn auto-drive tasks
          DispMode = 65; DispDel= 0; DispCnt = 0; break;
        case 'S': // STOP the motor drive functions
          Slots_OFF();  // reset and disable slot counters
          PWM_Lft = 0; PWM_Rht = 0; DriveTask = 0; break;
      } break;
    case 'P':
      // keyboard/serial commands used to set target PWM pointer
      switch (cmdType) {
        case 'T': // set target servo pointer in range 0 - 5
          if (cmdVal < 0) {cmdVal = PwmPnt;}
          if (cmdVal > 3) {cmdVal = PwmPnt;}
          PwmPnt = cmdVal; break;
        case 'V': // set track PWM values 0 - 255
          // if audio is playing we do this through the ISR
          if (IsrRun) {
            // playing audio
            switch(PwmPnt) {
              case 0: PwmLftA = cmdVal; PwmLftAL = cmdVal; PwmMask |= 0b00001000; break;
              case 1: PwmLftB = cmdVal; PwmLftBL = cmdVal; PwmMask |= 0b00000100; break;
              case 2: PwmRhtA = cmdVal; PwmRhtAL = cmdVal; PwmMask |= 0b00000010;; break;
              case 3: PwmRhtB = cmdVal; PwmRhtBL = cmdVal; PwmMask |= 0b00000001; break;
            }
          } else {
            // not playing audio
            switch(PwmPnt) {
              case 0: PwmLftA = cmdVal; PwmLftAL = cmdVal; ledcWrite(PinLftA, cmdVal); break;
              case 1: PwmLftB = cmdVal; PwmLftBL = cmdVal; ledcWrite(PinLftB, cmdVal); break;
              case 2: PwmRhtA = cmdVal; PwmRhtAL = cmdVal; ledcWrite(PinRhtA, cmdVal); break;
              case 3: PwmRhtB = cmdVal; PwmRhtBL = cmdVal; ledcWrite(PinRhtB, cmdVal); break;
            }
          }
          MDEn = false; // disable MotorDriveTask()
          break;
      } break;
    case 'R':
      switch (cmdType) {
        case 'C': // Air defence centre the head radar in 200ms
          servoTgt[1] = Sen0; servoCnt[1] = 10; HeadAngle = 0;
          // say "Centre, sweep."
          TalkAdd("/P/CE0000.WAV");
          break;
        case 'S': // Air defence turn radar sweep ON/OFF
          if (cmdVal) {
              // say "Sweep, on."
              TalkAdd("/P/SW0001.WAV");
            HeadAirEn = true;}   // turn sweep ON
          else {
              // say "Sweep, off."
              TalkAdd("/P/SW0000.WAV");
            HeadAirEn = false;}         // turn sweep OFF
          break;
      } break;
    case 'S':
      // keyboard/serial commands used to set servo values
      switch (cmdType) {
        case 'A': // set target servo angle in microseconds, 600-2400
          if (ServoPnt == 0) {servoVal[0] = cmdVal;}
          if (ServoPnt == 1) {servoVal[1] = cmdVal;}
          break;
        case 'L': // set target servo lower limit in microseconds
          if (ServoPnt == 0) {servoMin[0] = cmdVal;}
          if (ServoPnt == 1) {servoMin[1] = cmdVal;}
          break;
        case 'T': // set turret servo pointer in range 4 - 5
          if (cmdVal < 0) {cmdVal = ServoPnt;}
          if (cmdVal > 1) {cmdVal = ServoPnt;}
          ServoPnt = cmdVal; break;
        case 'U': // set target servo upper limit in microseconds
          if (ServoPnt == 0) {servoMax[0] = cmdVal;}
          if (ServoPnt == 1) {servoMax[1] = cmdVal;}
          break;
        case 'V': // set servo PWM values 0 - 255
          switch(ServoPnt) {
            case 0: // Gun servo
              SetServoNow(0,cmdVal); break;
            case 1: // Head servo
              SetServoNow(1,cmdVal); break;
          } break;
      } break;
    case 'T':
      switch (cmdType) {
        case ' ':
          if (cmdVal == 0) {ToneDetach();}
          else if (cmdVal == 1) {ToneAttach(); ledcWriteNote(PinTone,NoteLast,Octave);}
          break;
        case 'H': AttenOFF(); break;  // increase tone volume
        case 'L': AttenON(); break;   // reduce tone volume
      } break;
    case 'U':
      switch(cmdType){
        case ' ':
          if (cmdVal == 0) {
                // say "Radar, off."
                TalkAdd("/P/RA0000.WAV");
                 if (MainTask == 24) {HCSR04 = false;}
            else if (MainTask == 44) {if (VL53L1X_Task > 0) {VL53L1X_OFF();}}
          }
          if (cmdVal == 1) {
                // say "Radar, on."
                TalkAdd("/P/RA0001.WAV");
                 if (MainTask == 24) {HCSR04 = true;}
            else if (MainTask == 44) {if (VL53L1X_Task == 0) {VL53L1X_ON();}}
          }
          break;
      } break;
    case 'Z':
      switch (cmdType) {
        case 'A': // switch to an 'Air Defence' mode, if not already in it
          // respond with ZA. to turn off 1 sec ping
          // cmdVal sets the sensor mode, 0 = sonar, 1 = LTOF
          App = 1;  // set app to air defence
          if ((cmdVal == 0) && (MainTask != 24)) {
            if (MainTask == 44) {MainTask = 24; HCSR04 = true; VL53L1X_OFF();}
            else {SetMainMode(2); SetMainTask(24);}
            // say "Sonar, range."
            TalkAdd("/P/SO0050.WAV");
          } else if ((cmdVal == 1) && (MainTask != 44)) {
            if (MainTask == 24) {MainTask = 44; HCSR04 = false; VL53L1X_ON();}
            else {SetMainMode(4); SetMainTask(44);}
            // say "Laser, range."
            TalkAdd("/P/LA0050.WAV");
          }
          PrintTx += "ZA."; break;  // reply to cancel Pings
      } break;
    default:
      PrintTx += "Unknown cmd: " + cmdMode + cmdType + String(cmdVal) + "\n";
      break;
  }
  // now reset the variables
  cmdMode = ' '; cmdType = ' '; cmdVal = 0; cmdSgn = 1;
}

// ---------------------------------------------------------------------------------

void DoNunchuk() {
  // when not in WiFi mode we can still use buttons on the Nunchuk, provided it is
  // connected to the transceiver. This functions picks up those user actions.
  RxNunch = false;  // clear the received data flag, so as not to repeat
  if (MainTask == 71) {return;}  // in Wi-Fi mode, so Nunchuk actions are taken elsewhere

  // the actions taken are mainly dependant on the MainMode
  switch (MainTask) {

  }
}

// ---------------------------------------------------------------------------------

void extendCmdVal(int zVal) {
  // adds a new digit to the right-hand end of cmdVal
  cmdVal = abs(cmdVal * 10) + zVal;
}

// --------------------------------------------------------------------------------

String getBAhex() {
  // Rerturns the current Broardcast Address MAC, ie: 50:02:91:68:F7:3F
  String zRet$ = ""; uint8_t zV;
  for (int zP = 0;zP < 6;zP++) {
    zV = broadcastAddress[zP]/16;
    if (zV < 10) {zRet$ += char(zV + 48);} else {zRet$ += char(zV + 55);}
    zV = broadcastAddress[zP] - (zV *16);
    if (zV < 10) {zRet$ += char(zV + 48);} else {zRet$ += char(zV + 55);}
    if (zP < 5) {zRet$ += ":";}
  }
  return zRet$;
}

// --------------------------------------------------------------------------------

String GetBIN(byte zVal) {
  // returns an 8 character binary representation of zVal
  String zBIN$ = "";
  // convert zVal into binary
  if (zVal & 0B10000000) {zBIN$ += "1";} else {zBIN$ += "0";}
  if (zVal & 0B01000000) {zBIN$ += "1";} else {zBIN$ += "0";}
  if (zVal & 0B00100000) {zBIN$ += "1";} else {zBIN$ += "0";}
  if (zVal & 0B00010000) {zBIN$ += "1";} else {zBIN$ += "0";}
  if (zVal & 0B00001000) {zBIN$ += "1";} else {zBIN$ += "0";}
  if (zVal & 0B00000100) {zBIN$ += "1";} else {zBIN$ += "0";}
  if (zVal & 0B00000010) {zBIN$ += "1";} else {zBIN$ += "0";}
  if (zVal & 0B00000001) {zBIN$ += "1";} else {zBIN$ += "0";}
  return zBIN$;
}

// --------------------------------------------------------------------------------

int16_t getGunPWM(int16_t zAng) {
  // returns the servo PWM value for a given angle in degrees
  int16_t zPWM;
  if (zAng >= 0) {zPWM = map(zAng,0,60,Gun0,Gun60P);}
  else {zPWM = map(zAng,-60,0,Gun60N,Gun0);}
  zPWM = constrain(zPWM,Gun60P,Gun60N);
  return zPWM;
}

// --------------------------------------------------------------------------------

int16_t getHeadPWM(int16_t zHA) {
  // returns a servo PWM value for a given head angle
  int16_t zPWM;
  if (zHA >= 0) {zPWM = map(zHA,0,60,Sen0,Sen60P);}
  else {zPWM = map(zHA,-60,0,Sen60N,Sen0);}
  return zPWM;
}

// --------------------------------------------------------------------------------

String getHmTime(unsigned long zMillis) {
  // returns a 'time' string in Hrs:Min base on zMillis
  String zTime$ = ""; zMillis = zMillis/60000;  // reduce zMillis to minutes
  long zU = zMillis/60; zMillis = zMillis%60;    // get hours and minutes
  zTime$ = String(zU) + ":";
  if (zMillis < 10) {zTime$ += "0";}
  zTime$ += String(zMillis);  // add minutes
  return zTime$;
}

// --------------------------------------------------------------------------------

String getHmsTime(unsigned long zMillis) {
  // returns a 'time' string in Hrs:Min:sec base on zMillis
  String zTime$ = "";
  long zU = zMillis/3600000; zMillis = zMillis%3600000;
  if (zU > 0) {zTime$ = String(zU) + ":";}
  zU = zMillis/60000; zMillis = zMillis%60000;
  if (zU < 10) {zTime$ += "0";}
  zTime$ += String(zU);
  zU = zMillis/1000;
  if (zU < 10) {zTime$ += ":0";} else {zTime$ += ":";}
  zTime$ += String(zU);
  return zTime$;
}

// --------------------------------------------------------------------------------

int16_t getPanAngle() {
  // returns the Pan angle based on the current Pan servo value
  // the value should range between 30° - 150°, with centre being 90°
  // servoVal[0] low turns to the right, servoVal[0] large turns to the left
  int16_t zAng;
  // if (servoVal[0] < servoCtr[0]) {
  //   // servo is pointing to the right
  //   zAng = map(servoVal[0],servoMin[0],servoCtr[0],150,90);
  //   if (zAng > 150) {zAng = 150;}
  // } else {
  //   // servo is pointing to the left
  //   zAng = map(servoVal[0],servoCtr[0],servoMax[0],90,30);
  //   if (zAng < 30) {zAng = 30;}
  // }
  return zAng;
}

// --------------------------------------------------------------------------------

void GetRndCol(byte zB) {
  // return a random colour of strength zB
  if (zB < 2) {zB = 2;}
  switch(random(6)) {
    case 0: Col_R =   zB; Col_G =    0; Col_B =    0; break;  // red
    case 1: Col_R = zB/2; Col_G = zB/2; Col_B =    0; break;  // yellow
    case 2: Col_R =    0; Col_G =   zB; Col_B =    0; break;  // green
    case 3: Col_R =    0; Col_G = zB/2; Col_B = zB/2; break;  // cyan
    case 4: Col_R =    0; Col_G =    0; Col_B =   zB; break;  // blue
    case 5: Col_R = zB/2; Col_G =    0; Col_B = zB/2; break;  // magenta
  }
}

// --------------------------------------------------------------------------------

void GunLEDs() {
  // gun LED tasks. Set LEDGunMode to get an effect
  // check for gun firing, which takes priority over other tasks
  if (GunFire) {GunLED_Fire(); return;}

  if (LED_Del1 > 0) {LED_Del1--; LED_Run1 = false; return;} // delay by skipping tasks

  // do general gun effects
  switch (LedGunMode) {
    case  0: // default gun LED mode
      GetRndCol(8);
      Guns_LEDs[0].setRGB(Col_R,Col_G,Col_B);
      Guns_LEDs[1].setRGB(Col_R,Col_G,Col_B);
      LED_Run1 = false; LED_Del1 = 20; LEDnow1 = true;
      break;
    case 99: // allow front LED tasks to take control
      LED_Run1 = false; LED_Del1 = 20; break;
    default: LedGunMode = 0; break; // catch-all
  }
}

// --------------------------------------------------------------------------------

void GunLED_Fire() {
  // runs through a firing sequence, then cancels itself
  // if audio is playing then we must stop it
  if (IsrRun) {AudioPauseNow();}
  AttenON();
  if (ToneFreq) {TonePlay(ToneFreq - 50);}
  if (LED_Del1 > 0) {LED_Del1--; LED_Run1 = false; return;} // delay by skipping tasks

  switch(GunFire) {
    case  1: Guns_LEDs[0].setRGB(196,196,196); TonePlay(2093); LED_Del1 = 5; break;
    case  2: Guns_LEDs[0].setRGB(  0,  0,  0); ToneDetach(); LED_Del1 = 5; break;
    case  3: Guns_LEDs[0].setRGB(196,196,196); TonePlay(2093); LED_Del1 = 5; break;
    case  4: Guns_LEDs[0].setRGB(  0,  0,  0); ToneDetach(); LED_Del1 = 5; break;
    case  5: Guns_LEDs[0].setRGB(196,196,196); TonePlay(2093); LED_Del1 = 5; break;
    case  6: Guns_LEDs[0].setRGB(  0,  0,  0); LED_Del1 = 5; break;
    case  7: Guns_LEDs[0].setRGB(128,  0,  0); LED_Del1 = 5; break;
    case  8: Guns_LEDs[0].setRGB( 64,  0,  0); ToneDetach(); LED_Del1 = 5; break;
    case  9: Guns_LEDs[0].setRGB( 32,  0,  0); LED_Del1 = 5; break;
    case 10: Guns_LEDs[0].setRGB(  8,  0,  8); LED_Del1 = 5; break;
    case 11: Guns_LEDs[0].setRGB(  2,  0,  6); LED_Del1 = 5; break;
    case 12: Guns_LEDs[0].setRGB(  0,  0,  4); LED_Del1 = 5; break;
    case 13: Guns_LEDs[0].setRGB(  0,  0,  2); LED_Del1 = 5; break;
    case 14: Guns_LEDs[0].setRGB(  0,  0,  1); LED_Del1 = 5; break;
    case 15: Guns_LEDs[0].setRGB(  0,  0,  0); LED_Del1 = 5; break;
    default: // reached the end of the sequence
      if (AudioPause) {AudioPlayNow();} // resume the audio that was playing
      if (!AttenRef) {AttenOFF();}      // return attenuator to previous setting
      GunFire = 0; return;
  }
   Guns_LEDs[1] = Guns_LEDs[0];
  LED_Run1 = false; LEDnow1 = true; GunFire++;
}

// --------------------------------------------------------------------------------

void HowOften() {
  // called oin a temporary basis to determine the time bewteen repetitive events
  // simply prints the elapsed time plus a carriage return
  // at 115200 baud you can print at 11.5 chars/sec
  if (Often > 0) {Serial.println(millis() - Often);}
  Often = millis();
}

// --------------------------------------------------------------------------------

void Init_ESP_NOW() {
  // called to initiate an ESEP-NOW link or connect to another trannsceiver
  // each time this function is called it will attempt to connect to a different
  // boradcast address, cycling through them, over and over
  // Serial.println("Init_ESP_NOW()");

  // if we have previously tried a connection then we need to de-initialise it
  if (ESP_NOW_Init) {
    // already attempted to initialise ESP-NOW so strip everything back
    Serial.println("Closing ESP-NOW");
    esp_now_del_peer(broadcastAddress);
    // WiFi.disconnect();
  }
  
  // Init ESP-NOW and returns its status
  if (esp_now_init() != ESP_OK) {
    Serial.println("Error initializing ESP-NOW");
    return;
  }
  ESP_NOW_Init = true;
  
  // change the broadcast address pointer each time
  ESP_NOW_BA++;
  // Serial.println("ESP_NOW_BA = " + String(ESP_NOW_BA));
  
  switch (ESP_NOW_BA) {
    case 0: // Wii Transciever unique MAC: 50:02:91:68:F7:3F
      broadcastAddress[0] = 0x50;
      broadcastAddress[1] = 0x02;
      broadcastAddress[2] = 0x91;
      broadcastAddress[3] = 0x68;
      broadcastAddress[4] = 0xF7;
      broadcastAddress[5] = 0x3F;
      break;
    case 1: // Wii Transciever unique MAC: 50:02:91:68:F0:D2
      broadcastAddress[0] = 0x50;
      broadcastAddress[1] = 0x02;
      broadcastAddress[2] = 0x91;
      broadcastAddress[3] = 0x68;
      broadcastAddress[4] = 0xF0;
      broadcastAddress[5] = 0xD2;
      break;
    case 2: // Wii D1 Mk1 Transciever unique MAC: 58:BF:25:DB:27:A2
      broadcastAddress[0] = 0x58;
      broadcastAddress[1] = 0xBF;
      broadcastAddress[2] = 0x25;
      broadcastAddress[3] = 0xDB;
      broadcastAddress[4] = 0x27;
      broadcastAddress[5] = 0xA2;
      break;
    case 3: // Wii ESP32-C3 Zero Transciever unique MAC: EC:DA:3B:BD:4B:AC
      broadcastAddress[0] = 0xEC;
      broadcastAddress[1] = 0xDA;
      broadcastAddress[2] = 0x3B;
      broadcastAddress[3] = 0xBD;
      broadcastAddress[4] = 0x4B;
      broadcastAddress[5] = 0xAC;

      // End of list reached, so extend pause time and reset cycle
      // Turn off serial port reporting after first pass, unless connection fails
      ESP_NOW_BA = -1;      // 1st case will be 0
      WiFiConCnt = 75;      // 3 sec delay between trying cycles
      WiFiTryOnce = false;  // don't report trying after one cycle
      break;
  }

  // Once ESPNow is successfully Init, we will register for Send CB to
  // get the status of Trasnmitted packet
  esp_now_register_send_cb(OnDataSent);

  // Register peer
  esp_now_peer_info_t peerInfo; //initialize and assign the peer information as a pointer to an addres
  memset(&peerInfo, 0, sizeof(peerInfo));
  memcpy(peerInfo.peer_addr, broadcastAddress, 6); //copy the value of  broadcastAddress with 6 bytes to peerInfo.peer_addr
  peerInfo.channel = 0;     //channel at which the esp talk. 0 means undefined and data will be sent on the current channel. 1-14 are valid channels which is the same with the local device 
  peerInfo.encrypt = false; //not encrypted

  //Add the device to the paired device list 
  if (esp_now_add_peer(&peerInfo) != ESP_OK){ 
    Serial.println("Failed to add peer");
    return;
  }

  // Register for a callback function that will be called when data is received
  esp_now_register_recv_cb(OnDataRecv);
}

// --------------------------------------------------------------------------------

void LED_DriveBck() {
  // generates a driving backward pattern for the front 7 LEDs
  switch (LED_Task) {
    case 0: // create LED pattern
      fill_solid(Face_LEDs, 7, CRGB::Black);  // clear the LED array
      Face_LEDs[0] = Gear_LEDs[0]; Face_LEDs[6] = Gear_LEDs[0]; // white
      Face_LEDs[2].setRGB( 0, 0, 1); Face_LEDs[4] = Face_LEDs[1];
      switch(Gear) {
        case 1: Face_LEDs[3].setRGB( 0, 2, 0); Face_LEDs[6] = Face_LEDs[0]; break;
        case 2: Face_LEDs[3].setRGB( 1, 2, 0); Face_LEDs[6] = Face_LEDs[0]; break;
        case 3: Face_LEDs[3].setRGB( 2, 2, 0); Face_LEDs[6] = Face_LEDs[0]; break;
        case 4: Face_LEDs[3].setRGB( 3, 1, 0); Face_LEDs[6] = Face_LEDs[0]; break;
        case 5: Face_LEDs[3].setRGB( 2, 0, 0); Face_LEDs[6] = Face_LEDs[0]; break;
      } LED_Task++; break;
    case 1: // rotate LED pattern
      LED_Cnt--;
      if (LED_Cnt <= 0) {
        Temp_LED[0] = Face_LEDs[3]; // grab the last body LED rgb values
        Face_LEDs[3] = Face_LEDs[2];
        Face_LEDs[2] = Face_LEDs[1]; Face_LEDs[4] = Face_LEDs[5];
        Face_LEDs[1] = Face_LEDs[0]; Face_LEDs[5] = Face_LEDs[6];
        Face_LEDs[0] = Temp_LED[0]; Face_LEDs[6] = Temp_LED[0];
        LED_Cnt = 8; LEDnow0 = true;
      } break;
  }
  LED_Run0 = false;
}

// --------------------------------------------------------------------------------

void LED_DriveFwd() {
  // generates a driving forward pattern for the front 7 LEDs
  switch (LED_Task) {
    case 0: // create LED pattern
      fill_solid(Face_LEDs, 7, CRGB::Black);  // clear the LED array
      Face_LEDs[3] = Gear_LEDs[0];                             // white
      Face_LEDs[1].setRGB( 0, 0, 1); Face_LEDs[5] = Face_LEDs[1];
      switch(Gear) {
        case 1: Face_LEDs[0].setRGB( 0, 2, 0); Face_LEDs[6] = Face_LEDs[0]; break;
        case 2: Face_LEDs[0].setRGB( 1, 2, 0); Face_LEDs[6] = Face_LEDs[0]; break;
        case 3: Face_LEDs[0].setRGB( 2, 2, 0); Face_LEDs[6] = Face_LEDs[0]; break;
        case 4: Face_LEDs[0].setRGB( 3, 1, 0); Face_LEDs[6] = Face_LEDs[0]; break;
        case 5: Face_LEDs[0].setRGB( 2, 0, 0); Face_LEDs[6] = Face_LEDs[0]; break;
      } LED_Task++; break;
    case 1: // rotate LED pattern
      LED_Cnt--;
      if (LED_Cnt <= 0) {
        Temp_LED[0] = Face_LEDs[0]; // grab the last body LED rgb values
        Face_LEDs[0] = Face_LEDs[1]; Face_LEDs[6] = Face_LEDs[5];
        Face_LEDs[1] = Face_LEDs[2]; Face_LEDs[5] = Face_LEDs[4];
        Face_LEDs[2] = Face_LEDs[3]; Face_LEDs[4] = Face_LEDs[3];
        Face_LEDs[3] = Temp_LED[0];
        LED_Cnt = 8; LEDnow0 = true;
      }
      break;
  }
  LED_Run0 = false;
}

// --------------------------------------------------------------------------------

void LED_GearChange() {
  // display the gear change on the front LEDs
  fill_solid(Face_LEDs, 7, CRGB::Black);  // clear the LED array
  switch (Gear) {
    case 1: Face_LEDs[3] = Gear_LEDs[0]; break;
    case 2: Face_LEDs[2] = Gear_LEDs[0]; Face_LEDs[4] = Gear_LEDs[0]; break;
    case 3: Face_LEDs[2] = Gear_LEDs[0]; Face_LEDs[3] = Gear_LEDs[0]; Face_LEDs[4] = Gear_LEDs[0]; break;
    case 4: Face_LEDs[1] = Gear_LEDs[0]; Face_LEDs[2] = Gear_LEDs[0];
      Face_LEDs[4] = Gear_LEDs[0]; Face_LEDs[5] = Gear_LEDs[0]; break;
    case 5: Face_LEDs[1] = Gear_LEDs[0]; Face_LEDs[2] = Gear_LEDs[0];  Face_LEDs[3] = Gear_LEDs[0];
      Face_LEDs[4] = Gear_LEDs[0]; Face_LEDs[5] = Gear_LEDs[0]; break;
  }
  LedMode = LedLast; LED_Del0 = 50;
  LED_Run0 = false; LEDnow0 = true;
}

// --------------------------------------------------------------------------------

void LED_Main() {
  // tasks for manipulating RGB LED patterns
  // Blink clock and modes
  Blink = false; BlinkCnt++; if (BlinkCnt > 50) {BlinkCnt = 0; Blink = true;}
  // button switches over-ride all modes
  if ((sw0State == LOW) || (sw1State == LOW)) {
    if (!LED_SWL) {
      LED_SWL = true;                         // set flag for switch release
      fill_solid(Face_LEDs, 7, CRGB::Black);  // clear the LED array
      if (sw0State == LOW) {LED_SW0();}       // force left side LEDs
      if (sw1State == LOW) {LED_SW1();}       // force right side LEDs
      LED_Run0 = false; LED_Del0 = 1; LEDnow0 = true;
    }
    return;
  } else if (LED_SWL) {
    // on button release, pause with not front LEDs, then resume
    LED_SWL = false;
    fill_solid(Face_LEDs, 7, CRGB::Black);  // clear the LED array
    LED_Run0 = false; LED_Del0 = 20; LEDnow0 = true;
  }
  if (LED_Del0 > 0) {LED_Del0--; LED_Run0 = false; return;} // delay by skipping tasks

  // Serial.println(LedMode);
  // when performing drive tasks vary rate with LedSpd
  if (LedMode >= 21) {
    LED_Period0 = map(LedSpd,PWM_StartMin,255,40,5);
    if (LED_Period0 < 5) {LED_Period0 = 5;}
  }
  
  switch(LedMode) {
    case 0: // doing nothing
     LED_Sleep(); break;
    case 2: // Ready
     LED_Ready(); break;
    case 5: // Range bar graph
     LED_Range(); break;
    case 6: // Audio pk tracking
      LED_Pk_Audio(); break;
    case 10: // random LED colours
      GetRndCol(8); Face_LEDs[0].setRGB(Col_R,Col_G,Col_B);
      GetRndCol(8); Face_LEDs[1].setRGB(Col_R,Col_G,Col_B);
      GetRndCol(8); Face_LEDs[2].setRGB(Col_R,Col_G,Col_B);
      GetRndCol(8); Face_LEDs[3].setRGB(Col_R,Col_G,Col_B);
      GetRndCol(8); Face_LEDs[4].setRGB(Col_R,Col_G,Col_B);
      GetRndCol(8); Face_LEDs[5].setRGB(Col_R,Col_G,Col_B);
      GetRndCol(8); Face_LEDs[6].setRGB(Col_R,Col_G,Col_B);
      GetRndCol(8); Face_LEDs[7].setRGB(Col_R,Col_G,Col_B);
      LED_Run0 = false; LED_Del0 = 3; LEDnow0 = true;
      break;
    case 20: // Gear change
      LED_GearChange(); break;
    case 21: // driving forward
     LED_DriveFwd(); break;
    // case 22: // driving sideways to the right
    //   LED_DriveRht(); break;
    case 23: // driving backward
      LED_DriveBck(); break;
    // case 24: // driving sideways to the left
    //   LED_DriveLft(); break;
    case 25: // driving neutral turn left
      LED_NeutLft(); break;
    case 26: // driving neutral turn right
      LED_NeutRht(); break;
    
    case 50:  // music mode
      LED_Music(); break;
  }
}

// --------------------------------------------------------------------------------

void LED_Music() {
  // this LED mode takes control of front and gun LEDs
  // it generates a range of colour patterns, whicvh are switched between at random
  // intervals and speeds to give a greater range of effects
  // when the gun is firing we do not write to the gun LEDs
  switch (LED_Task) {
    case  0: // initialise
      fill_solid(Face_LEDs, 7, CRGB::Black);  // clear the front LED array
      LED_Run0 = false; LEDnow0 = true;
      LedGunMode = 99;                        // disable normal gun LED modes so we can drive them from here
      if (!GunFire) {
        fill_solid(Guns_LEDs, 2, CRGB::Black);  // clear the gun LED array
        LED_Run1 = false; LEDnow1 = true;
      }
      LED_Task++; break;
    case  1: // random selection, random speed
      LED_Pnt = random(4); LedSpd = 3 + random(4);
      switch (LED_Pnt) {
        case 0: LED_Task = 10; LED_Cycles = 6 + random(15); LedSpd = 6; break;
        case 1: LED_Task = 20; LED_Cycles = 6 + random(20); LedSpd = 4;break;
        case 3: LED_Task = 30; LED_Cycles = 6 + random(25); LedSpd = 3; break;
      } break;
    case 10: // random colours in all LEDs
      GetRndCol(8); Face_LEDs[0].setRGB(Col_R,Col_G,Col_B);
      GetRndCol(8); Face_LEDs[1].setRGB(Col_R,Col_G,Col_B);
      GetRndCol(8); Face_LEDs[2].setRGB(Col_R,Col_G,Col_B);
      GetRndCol(8); Face_LEDs[3].setRGB(Col_R,Col_G,Col_B);
      GetRndCol(8); Face_LEDs[4].setRGB(Col_R,Col_G,Col_B);
      GetRndCol(8); Face_LEDs[5].setRGB(Col_R,Col_G,Col_B);
      GetRndCol(8); Face_LEDs[6].setRGB(Col_R,Col_G,Col_B);
      GetRndCol(8); Face_LEDs[7].setRGB(Col_R,Col_G,Col_B);
      // gun LEDs
      if (!GunFire) {
        GetRndCol(8); Guns_LEDs[0].setRGB(Col_R,Col_G,Col_B);
        GetRndCol(8); Guns_LEDs[1].setRGB(Col_R,Col_G,Col_B);
      }
      LED_Run0 = false; LED_Del0 = LedSpd; LEDnow0 = true;
      break;
    case 20:  // side to side random colours
      fill_solid(Face_LEDs, 7, CRGB::Black);  // clear the front LED array
      fill_solid(Guns_LEDs, 2, CRGB::Black);  // clear the gun LED array
      if (LED_Pnt) { // light left-hand LEDs
        LED_Pnt = 0;
        GetRndCol(8); Face_LEDs[0].setRGB(Col_R,Col_G,Col_B); Face_LEDs[1] = Face_LEDs[0];
        Face_LEDs[2] = Face_LEDs[0];
        if (!GunFire) {Guns_LEDs[0] = Face_LEDs[0];}
      } else { // light right-hand LEDs
        LED_Pnt = 1;
        GetRndCol(8); Face_LEDs[4].setRGB(Col_R,Col_G,Col_B); Face_LEDs[5] = Face_LEDs[4];
        Face_LEDs[6] = Face_LEDs[4];
        if (!GunFire) {Guns_LEDs[1] = Face_LEDs[4];}
      }
      LED_Run0 = false; LED_Del0 = LedSpd; LEDnow0 = true;
      break;
    case 30:  // rotating rainbow pattern
      GetRndCol(18);
      if (!GunFire) {Guns_LEDs[1].setRGB(Col_R,Col_G,Col_B); Face_LEDs[6] = Guns_LEDs[1]/3;}
      else {Face_LEDs[6].setRGB(Col_R,Col_G,Col_B);}
      Face_LEDs[5] = Face_LEDs[6]/3; Face_LEDs[4] = Face_LEDs[5]/3; Face_LEDs[3].setRGB( 0, 0, 0);
      GetRndCol(18); Face_LEDs[2].setRGB(Col_R,Col_G,Col_B); Face_LEDs[1] = Face_LEDs[2]/3;
      Face_LEDs[0] = Face_LEDs[1]/3;
      if (!GunFire) {Guns_LEDs[0] = Face_LEDs[0]/3;}
      LED_Run0 = false; LED_Del0 = LedSpd; LEDnow0 = true;
      LED_Task++; if (random(2)) {LED_Task++;}; break;
    case 31: // rotate clockwise
      if (!GunFire) {Temp_LED[0] = Guns_LEDs[0]; Guns_LEDs[0] = Guns_LEDs[1]; Guns_LEDs[1] = Face_LEDs[6];}
      else {Temp_LED[0] = Guns_LEDs[6];}
      Face_LEDs[6] = Face_LEDs[5]; Face_LEDs[5] = Face_LEDs[4]; Face_LEDs[4] = Face_LEDs[3];
      Face_LEDs[3] = Face_LEDs[2]; Face_LEDs[2] = Face_LEDs[1]; Face_LEDs[1] = Face_LEDs[0];
      Face_LEDs[0] =  Temp_LED[0];
      LED_Run0 = false; LED_Del0 = LedSpd; LEDnow0 = true;
      break;
    case 32: // rotate anti-clockwise
      if (!GunFire) {Temp_LED[0] = Guns_LEDs[1]; Guns_LEDs[1] = Guns_LEDs[0]; Guns_LEDs[0] = Face_LEDs[0];}
      else {Temp_LED[0] = Face_LEDs[0];}
      Face_LEDs[0] = Face_LEDs[1]; Face_LEDs[1] = Face_LEDs[2]; Face_LEDs[2] = Face_LEDs[3];
      Face_LEDs[3] = Face_LEDs[4]; Face_LEDs[4] = Face_LEDs[5]; Face_LEDs[5] = Face_LEDs[6];
      Face_LEDs[6] =  Temp_LED[0];
      LED_Run0 = false; LED_Del0 = LedSpd; LEDnow0 = true;
      break;
  }
  // decrement cycles and change task once == 0
  LED_Cycles--; if (LED_Cycles == 0) {LED_Task = 1;}
}

// --------------------------------------------------------------------------------

void LED_NeutLft() {
  // use when neutral turning left
  // fill the temp[] buffer with the pattern
  switch (LED_Task) {
    case 0: // create LED pattern
      fill_solid(Temp_LED, 8, CRGB::Black);  // clear the LED array
      Temp_LED[3] = Gear_LEDs[0]; Temp_LED[7] = Gear_LEDs[0];
      Temp_LED[1].setRGB( 0, 0, 1); Temp_LED[5] = Temp_LED[1];
      switch(Gear) {
        case 1: Temp_LED[0].setRGB( 0, 2, 0); Temp_LED[4] = Temp_LED[0]; break;
        case 2: Temp_LED[0].setRGB( 1, 2, 0); Temp_LED[4] = Temp_LED[0]; break;
        case 3: Temp_LED[0].setRGB( 2, 2, 0); Temp_LED[4] = Temp_LED[0]; break;
        case 4: Temp_LED[0].setRGB( 3, 1, 0); Temp_LED[4] = Temp_LED[0]; break;
        case 5: Temp_LED[0].setRGB( 2, 0, 0); Temp_LED[4] = Temp_LED[0]; break;
      }
      LED_Pnt = 0; LED_Task++; break;
    case 1: // rotate LED pattern by copying it from Temp[]
      LED_Cnt--;
      if (LED_Cnt <= 0) {
        for (int16_t zP = 0;zP < 7;zP++) {
          Face_LEDs[zP] = Temp_LED[LED_Pnt];
          LED_Pnt++; if (LED_Pnt > 7) {LED_Pnt = 0;}
        }
        LED_Pnt-= 6; if (LED_Pnt < 0) {LED_Pnt += 8;}
        LED_Cnt = 8; LEDnow0 = true;
      }
      break;
  }
  LED_Run0 = false;
}

// --------------------------------------------------------------------------------

void LED_NeutRht() {
  // use when neutral turning right
  switch (LED_Task) {
    case 0: // create LED pattern
      fill_solid(Temp_LED, 8, CRGB::Black);  // clear the LED array
      Temp_LED[3] = Gear_LEDs[0]; Temp_LED[7] = Gear_LEDs[0];
      Temp_LED[1].setRGB( 0, 0, 1); Temp_LED[5] = Temp_LED[1];
      switch(Gear) {
        case 1: Temp_LED[2].setRGB( 0, 2, 0); Temp_LED[6] = Temp_LED[2]; break;
        case 2: Temp_LED[2].setRGB( 1, 2, 0); Temp_LED[6] = Temp_LED[2]; break;
        case 3: Temp_LED[2].setRGB( 2, 2, 0); Temp_LED[6] = Temp_LED[2]; break;
        case 4: Temp_LED[2].setRGB( 3, 1, 0); Temp_LED[6] = Temp_LED[2]; break;
        case 5: Temp_LED[2].setRGB( 2, 0, 0); Temp_LED[6] = Temp_LED[2]; break;
      }
      LED_Pnt = 0; LED_Task++; break;
    case 1: // rotate LED pattern by copying it from Temp[]
      LED_Cnt--;
      if (LED_Cnt <= 0) {
        for (int16_t zP = 0;zP < 7;zP++) {
          Face_LEDs[zP] = Temp_LED[LED_Pnt];
          LED_Pnt++; if (LED_Pnt > 7) {LED_Pnt = 0;}
        }
        LED_Pnt-= 8; if (LED_Pnt < 0) {LED_Pnt += 8;}
        LED_Cnt = 8;  LEDnow0 = true;
      }
      break;
  }
  LED_Run0 = false;
}

// --------------------------------------------------------------------------------

void LED_Pk_Audio() {
  // audio Pk tracking using the value of AudioPkVal (0 - 128)
  fill_solid(Face_LEDs, 7, CRGB::Black);  // clear the LED array
  if (AudioPkVal >  20) {Face_LEDs[3].setRGB(0,0,AudioPkVal);} // centre
  if (AudioPkVal >  50) {Face_LEDs[2] = Face_LEDs[3]; Face_LEDs[4] = Face_LEDs[3];} // 2-C-4
  if (AudioPkVal >  80) {Face_LEDs[1] = Face_LEDs[3]; Face_LEDs[5] = Face_LEDs[3];} // 1-2-C-4-5
  if (AudioPkVal > 100) {Face_LEDs[0] = Face_LEDs[3]; Face_LEDs[6] = Face_LEDs[3];} // 0-1-2-C-4-5-6
  LED_Run0 = false; LED_Del0 = 0; LEDnow0 = true;
}

// --------------------------------------------------------------------------------

void LED_Range() {
  // drive LEDs in response to LTOF ranging   
  fill_solid(Face_LEDs, 7, CRGB::Black);  // clear the LED array
  if (!RangeUL) {
    // Range has not exceed the upper limit
    anyVal = map(Range,LtofMin,LtofLimit,150,0);
         if (anyVal >= 140) {Face_LEDs[6].setRGB(5,0,0); Face_LEDs[5].setRGB(5,0,0);
      Face_LEDs[4].setRGB(5,0,0); Face_LEDs[3].setRGB(5,0,0); Face_LEDs[2].setRGB(5,0,0); Face_LEDs[1].setRGB(5,0,0); Face_LEDs[0].setRGB(5,0,0);}
    else if (anyVal >= 130) {Face_LEDs[6].setRGB(1,1,0); Face_LEDs[5].setRGB(5,0,0);
      Face_LEDs[4].setRGB(5,0,0); Face_LEDs[3].setRGB(5,0,0); Face_LEDs[2].setRGB(5,0,0); Face_LEDs[1].setRGB(5,0,0); Face_LEDs[0].setRGB(5,0,0);}
    else if (anyVal >= 120) {Face_LEDs[5].setRGB(5,0,0);
      Face_LEDs[4].setRGB(5,0,0); Face_LEDs[3].setRGB(5,0,0); Face_LEDs[2].setRGB(5,0,0); Face_LEDs[1].setRGB(5,0,0); Face_LEDs[0].setRGB(5,0,0);}
    else if (anyVal >= 110) {Face_LEDs[5].setRGB(1,1,0);
      Face_LEDs[4].setRGB(5,0,0); Face_LEDs[3].setRGB(5,0,0); Face_LEDs[2].setRGB(5,0,0); Face_LEDs[1].setRGB(5,0,0); Face_LEDs[0].setRGB(5,0,0);}
    else if (anyVal >= 100) {Face_LEDs[4].setRGB(5,0,0); Face_LEDs[3].setRGB(5,0,0); Face_LEDs[2].setRGB(5,0,0); Face_LEDs[1].setRGB(5,0,0); Face_LEDs[0].setRGB(5,0,0);}
    else if (anyVal >=  90) {Face_LEDs[4].setRGB(1,1,0); Face_LEDs[3].setRGB(5,0,0); Face_LEDs[2].setRGB(5,0,0); Face_LEDs[1].setRGB(5,0,0); Face_LEDs[0].setRGB(5,0,0);}
    else if (anyVal >=  80) {Face_LEDs[3].setRGB(5,0,0); Face_LEDs[2].setRGB(5,0,0); Face_LEDs[1].setRGB(5,0,0); Face_LEDs[0].setRGB(5,0,0);}
    else if (anyVal >=  70) {Face_LEDs[3].setRGB(1,1,0); Face_LEDs[2].setRGB(5,0,0); Face_LEDs[1].setRGB(5,0,0); Face_LEDs[0].setRGB(5,0,0);}
    else if (anyVal >=  60) {Face_LEDs[2].setRGB(5,0,0); Face_LEDs[1].setRGB(5,0,0); Face_LEDs[0].setRGB(5,0,0);}
    else if (anyVal >=  50) {Face_LEDs[2].setRGB(1,1,0); Face_LEDs[1].setRGB(5,0,0); Face_LEDs[0].setRGB(5,0,0);}
    else if (anyVal >=  40) {Face_LEDs[1].setRGB(5,0,0); Face_LEDs[0].setRGB(5,0,0);}
    else if (anyVal >=  30) {Face_LEDs[1].setRGB(1,1,0); Face_LEDs[0].setRGB(5,0,0);}
    else if (anyVal >=  20) {Face_LEDs[0].setRGB(5,0,0);}
    else if (anyVal >=  10) {Face_LEDs[0].setRGB(1,1,0);}
  } else {
    // Range has exceeded the upper limit so just blink centre LED
    if (Blink) {Face_LEDs[3].setRGB(4,0,0);}
  }
  LED_Run0 = false; LED_Del0 = 0; LEDnow0 = true;
}

// --------------------------------------------------------------------------------

void LED_Ready() {
  // when static on Wi-Fi, display wandering green dot
  LED_Cnt += LED_Inc;
  if (LED_Cnt > 5) {LED_Inc = -1;}
  else if (LED_Cnt < 1) {LED_Inc = 1;}
  fill_solid(Face_LEDs, 7, CRGB::Black);  // clear the LED array
  Face_LEDs[LED_Cnt] = Gear_LEDs[0];
  LED_Run0 = false; LED_Del0 = 5; LEDnow0 = true;
}

// --------------------------------------------------------------------------------

void LED_Sleep() {
  // when sleeping, display wandering blue dot
  LED_Cnt += LED_Inc;
  if (LED_Cnt > 5) {LED_Inc = -1;}
  else if (LED_Cnt < 1) {LED_Inc = 1;}
  fill_solid(Face_LEDs, 7, CRGB::Black);  // clear the LED array
  Face_LEDs[LED_Cnt].setRGB(0,1,1);
  LED_Run0 = false; LED_Del0 = 40; LEDnow0 = true;
  // Serial.println(LED_Cnt);
}

// --------------------------------------------------------------------------------

void LED_SW0() {
  // called as an over-ride when SW0 is pressed
  fill_solid(Face_LEDs, 7, CRGB::Black);  // clear the LED array
  Face_LEDs[0].setRGB(0,0,8); Face_LEDs[1].setRGB(0,0,8);
}

// --------------------------------------------------------------------------------

void LED_SW1() {
  // called as an over-ride when SW1 is pressed
  fill_solid(Face_LEDs, 7, CRGB::Black);  // clear the LED array
  Face_LEDs[5].setRGB(0,0,8); Face_LEDs[6].setRGB(0,0,8);
}

// --------------------------------------------------------------------------------

int16_t max16(int16_t zA,int16_t zB) {
  // returns the larger of zA or zB
  if (zA >= zB) {return zA;} else {return zB;}  
}

// --------------------------------------------------------------------------------

int16_t min16(int16_t zA,int16_t zB) {
  // returns the smaller of zA or zB
  if (zA <= zB) {return zA;} else {return zB;}  
}

// --------------------------------------------------------------------------------

void MotorPWM (int16_t zL,int16_t zR) {
  // sets the two H-bridge PWM values for drive control
  // zV > 0 - move wheel in direction for forward motion
  // zV = 0 - lock wheel in brake condition
  // zV < 0 - move wheel in direction for reverse motion

  // store variables for display and counters
  // PWM applied in MotorDriveTask() function, which also applied dither
  PWM_Lft = zL; PWM_Rht = zR;
  if (!PwmEn) {zL = 0; zR = 0;} // motor PWM is disabled
}

// ---------------------------------------------------------------------------------

void PwmAttach(uint8_t zCh) {
  // Attached the micros internal PWM counter to an output pin
  // Note we adjust PW values later using ledcWrite() as it is quicker
  switch (zCh) {
    case 0: analogWrite(PinLftA, 0); break;
    case 1: analogWrite(PinLftB, 0); break;
    case 2: analogWrite(PinRhtA, 0); break;
    case 3: analogWrite(PinRhtB, 0); break;
  }
}

// ---------------------------------------------------------------------------------

void PwmSetup(uint8_t zCh) {
  // setup the PWM counter to an output pin
  switch (zCh) {
    case 0: analogWriteFrequency(PinLftA, PwmFreq); analogWriteResolution(PinLftA, PwmBits); break;
    case 1: analogWriteFrequency(PinLftB, PwmFreq); analogWriteResolution(PinLftB, PwmBits); break;
    case 2: analogWriteFrequency(PinRhtA, PwmFreq); analogWriteResolution(PinRhtA, PwmBits); break;
    case 3: analogWriteFrequency(PinRhtB, PwmFreq); analogWriteResolution(PinRhtB, PwmBits); break;
  }
}

// --------------------------------------------------------------------------------

void readBattery() {
  // called from the main loop every 200ms
  // read the voltage on the analog input and average it over 20 counts
  BatVol = analogRead(BatPin); BatTms = millis(); // take the reading
  // Serial.println("BatVol = " + String(BatVol));
  BatSum = BatSum + BatVol - BatAvg;
  BatAvg = BatSum/20;     // ADC is averaged over 20 readings to remove noise
  // uncomment the following line if you want to see readings on serial monitor
  // Serial.print(F("BattAv = ")); Serial.print(BattAv); Serial.print(F("\t")); Serial.print((5.0 * BattAv)/608.9); Serial.println(F("v"));
  
  //#############################################################################
  //
  // Battery life prediction code + data logger
  //
  //#############################################################################
  // BatDel is set to 10 second interval to start with, to ignore initial readings
  if (!USBPwr) {
    if (BatDel > 0) {BatDel--;}
    else {
      BatDel = 5;  // use a 1 second timer for prediction updates & data logging
      if (BatAvg > BatAvgMax) {BatAvgMax = BatAvg;}
      // BatData[] is for display purposes, in the Y range 0 - 62
      BatData[BatDP] = (62L * (BatAvg - BatCritical))/(BatAvgMax - BatCritical);
      // Serial.println("BatData: " + String(BatData[BatDP]));
      // move the data pinter to teh end, then start shifting the whole array
      if (BatDP < 59) {BatDP++;} else {shiftBatData();}
      
      if (BatT0 == 0) {
        // this is the first measurement after 10 second start delay
        // this value is the cornerstone of the prediction
        BatT0 = BatTms; BatV0 = BatAvg; BatV1 = BatAvg;
        // Serial.print("BatT0 "); Serial.println(BatT0);
      } else {
        if (BatAvg != BatV1) {
          // there has been a change in the battery voltage setting a new discharge point
          // and the current battery voltage is different, so avoid divide by zero error
          // recalculate battery life predicition base on new value and time
          // Serial.print("BatAvg "); Serial.println(BatAvg);
          BatV1 = BatAvg; // record the latest low point
          if  (BatV0 == BatV1) {BatV1--;} // avoid divide by zero error
          AnyLong = ((BatTms - BatT0)*(BatV1 - BatCritical))/(BatV0 - BatV1);
      //      Serial.print("AnyLong "); Serial.println(AnyLong);
          if (AnyLong > 0) {
            // don't make -ve predictions
            BatTime$ = getHmTime(AnyLong);
          }
        }
      }
    }  
  
  //##############################################################################
  //
  //  critical battery test
  //
  //##############################################################################
  // test for battery low condition, 683 == 6.6v
    if (BatAvg < BatCritical) {
      // battery has reached critical level so STOP and blink centre LED
      BatCritCnt++;
      if (BatCritCnt >= 100) {
        // low voltage sustained for 4 seconds or more, so we shut down
        // the delay ignores brown-outs caused by heavy drive demands
        IsrRun = false; // kill any audio ISR tasks
        Display_Text2x16("LOW","BATTERY");
        // stop Core0 tasks, LEDs, motors and release servos
        SlotEn = false;
        LEDshow0 = false;
        LEDshow1 = false;
        fill_solid(Face_LEDs, 7, CRGB::Black);
        fill_solid(Guns_LEDs, 2, CRGB::Black);
        FastLED[0].showLeds(255); FastLED[1].showLeds(255);
        ledcWrite(PinLftA,255); ledcWrite(PinLftB,255);
        ledcWrite(PinRhtA,255); ledcWrite(PinRhtB,255);
        detachServos();
        delay(10000);  // display message for 10 seconds
        Display_clear(); Display_display();
        
        while (true) {
          // stay here indefinately
          yield();
        }
      }
    } else {BatCritCnt = 0;}  // reset the 4 second timer
  }
}

// --------------------------------------------------------------------------------

void Read_Echo() {
  // called from the main loop, when enabled, to read the HC-SR04 sensor
  // a HIGH to LOW transition triggers the device
  digitalWrite(PinTrig,HIGH);
  delayMicroseconds(10);
  digitalWrite(PinTrig,LOW);

  // Reads the echoPin, returns the sound wave travel time in microseconds
  // time for Echo to go HIGH is around 2ms, so 5.5ms is allowed for ~500mm ranges
  duration = pulseIn(PinEcho, HIGH,6000L);

  // get range in mm
  int zRange = (10 * duration)/58;
  if (zRange < 10) {zRange = LtofLimit;}  // set range to max if too close
  else if (zRange > LtofLimit) {zRange = LtofLimit;RangeUL = true;} else {RangeUL = false;}
  if (zRange <= LtofMin) {zRange = LtofMin; RangeLL = true;} else {RangeLL = false;}
  Range = (zRange + RangeLast)/2;
  RangeLast = zRange;
  LTOFfps = 50; // call from main loop every 20ms
}

// --------------------------------------------------------------------------------

void readSerial() {
  // reads characters from the serial port and responds to commands
  // set PrintTgt to indicate source as serial port for responses
  keyVal = Serial.read();
  if (keyVal != -1) {SerialRx = true; PrintTgt = 0; decodeKey(keyVal);}
}

// ---------------------------------------------------------------------------------

void Read_Slots() {
  // called regularly from main loop when Slot_En == true
  // assynchronously tracks slot pulse trigger transitions
  // FL sensor:
  if (digitalRead(INT_P34) != IntP34State) {
    // a transition has occured in the left sensor
    IntMicros[0] = micros(); IntP34State = !IntP34State; IntP34Cnt+= DIR_FL;
    IntPeriods[0] = (IntPeriods[0] + IntMicros[0] - IntLast[0])/2; IntLast[0]= IntMicros[0];
    // record period for 1/4 revolution (5 slots, 10 edges)
    if (IntLast40[0] == 0) {
      // 1st pulse after reset
      IntLast40[0] = millis(); IntPeriods[0] = 0;
    } else {Int34Rev++; if (Int34Rev >= 10) {
        // we determine rpm over a 1/4 cycle, ie. 10 edges in a 20 slot wheel
        // int rpm is 10 times larger than actual for display purposes
        if (millis() != IntLast40[0]) { // avoid divide by zero error!
          Int34RPM = (DIR_FL * 150000)/int16_t(millis() - IntLast40[0]);
          IntLast40[0] = millis(); Int34Rev = 0;
      // Serial.println(0.1 * Int36RPM);
        }
      }
    } IntP34Ch = true;  // flag change has occurred, wheel is moving
    // check for auto stop on left-hand track
    if (AutoStopFL) {
      if (AutoStopFL > 0) {
        // we are looking for a positive count to be reached
        if (IntP34Cnt >= AutoStopFL) {PWM_Lft = 0; AutoStopFL = 0; Serial.println("PWM_Lft = 0");}
      } else {
        // we are looking for a negative count to be reached
        if (IntP34Cnt <= AutoStopFL) {PWM_Lft = 0; AutoStopFL = 0; Serial.println("PWM_Lft = 0");}
      }
    }
  }
  
  // FR sensor:
  if (digitalRead(INT_P39) != IntP39State) {
    // a transition has occured in the right sensor
    IntMicros[1] = micros(); IntP39State = !IntP39State; IntP39Cnt+= DIR_FR;
    IntPeriods[1] = (IntPeriods[1] + IntMicros[1] - IntLast[1])/2; IntLast[1]= IntMicros[1];
    // record period for 1/4 revolution (5 slots, 10 edges)
    if (IntLast40[1] == 0) {
      // 1st pulse after reset
      IntLast40[1] = millis(); IntPeriods[1] = 0;
    } else {Int39Rev++; if (Int39Rev >= 10) {
        // we determine rpm over a 1/4 cycle, ie. 10 edges in a 20 slot wheel
        // int rpm is 10 times larger than actual for display purposes
        if (millis() != IntLast40[1]) { // avoid divide by zero error!
          Int39RPM = (DIR_FR * 150000)/int16_t(millis() - IntLast40[1]);
          IntLast40[1] = millis(); Int39Rev = 0;
        }
      }
    }IntP39Ch = true;  // flag change has occurred, wheel is moving
    // check for auto stop on right-hand track
    if (AutoStopFR) {
      if (AutoStopFR > 0) {
        // we are looking for a positive count to be reached
        if (IntP39Cnt >= AutoStopFR) {PWM_Rht = 0; AutoStopFR = 0; Serial.println("PWM_Rht = 0");}
      } else {
        // we are looking for a negative count to be reached
        if (IntP39Cnt <= AutoStopFR) {PWM_Rht = 0; AutoStopFR = 0; Serial.println("PWM_Rht = 0");}
      }
    }
  }
}

// ---------------------------------------------------------------------------------

void readSW0() {
  // Read the left button switch and respond accordingly, pressed == LOW
  // a button press will automatical drop the current task
  // SW0 is read every 20ms (50Hz) to debounce
  sw0State = digitalRead(sw0Pin); // record button state
  if (sw0_Nop) {return;}          // block this function whilst == true
  
  bool sw0Clr = false;
  if (!sw0State) {
    //##############################################################################
    //
    // SW0 button is pressed down
    //
    //##############################################################################
    if (sw0Wup) {return;}   // SW0 is waiting to be released
    
    if (sw0LastState == HIGH) {
      // SW0 has just been pressed down
      // Serial.println("SW0 Hi-LO");
      if (TEST) {Serial.println("SW0 Hi-LO");}
      sw0DwnTime = 0; // restart button down time counter
      sw0Cnt++;       // count on the falling edge
      sw0Timer = 0;   // reset the timer
      // SW0 can be pressed in WiFiEn mode to change display functions
      if (MainMode == 5) {
        // Audio mode already playing a tune, so stop it
        if (AudioTask) {
          AudioStop(); AudioTask = 0;           // stop anything that is playing
          if (GunMode > 1) {SetGunMode(1);}     // rest Gun if moving
          if (HeadMode > 1) {SetHeadMode(1);}   // rest Head if moving
        }
        SetMainMode(5); sw0Wup = true; return;
      }
      else if (MainMode == 50) {
        // Audio mode selection screem.
        // Toggle audio mode selection options due to <NO> option
        ModeSel++; if (ModeSel > 10) {ModeSel = 0;}
        sw0Cnt = 0; DispDel = 0; DispCnt = 0;
      }
      else if (MainMode == 99) {
        // toggle MainMode selection options due to < NO >
        ModeSel++; if (ModeSel > 6) {ModeSel = 0;}
      }
    } else {
      // whilst the button is down adjust the timer at 20ms steps
      // if Wii is not connected test for a long press to invoke demo mode
      sw0DwnTime++; // track button pressed time
      if (TEST) {
        // In TEST mode
        // look for long press >= 1 sec in TEST mode
        if (sw0Timer == 100) {
          // 2 second timeout
          sw0Cnt = 0; sw0Timer = 0;
        }
      } else {
        // Not in TEST mode
        if (sw0DwnTime == 25) {
          // button SW0 held down for > 0.5 second
          if (WiFiEn) {sw1Cnt = 0; SetMainMode(0); return;}   // change  to Sleep Mode
          // switch into mode selection if not already there
          if (MainMode != 99) {
            // coming out of sleep mode
            if (MainMode == 0) {
              switch (random(2)) {
                case 0: TalkDel = 10; TalkAdd("/P/WA0000.WAV"); break;  // say "Waking up."
                case 1: TalkDel = 10; TalkAdd("/P/HE0000.WAV"); break;  // say "Hello."
              }
            }
            // say "Select a mode."
            else {TalkDel = 10; TalkAdd("/P/SE0020.WAV");}
            SetMainMode(99);  // switch to mode select
            DispDel = 0; DispCnt = 0;
          }
        }
        else if (sw0DwnTime == 50) {
          // button SW0 held down for > 1 second
          // if in mode selection, ensure we are looking at 'sleep' option
          if ((MainMode == 99) && (ModeSel != 0)) {
            ModeSel = 0;    // switch back to sleep mode selection
            DispDel = 0; DispCnt = 0;
          }
        }
        else if (sw0DwnTime >= 150) {
          // button SW0 held down for >= 3 seconds, so reboot
          AudioIsrSet(20000000);      // kill any audio ISR tasks, set to 10 sec interval
          DisplayText1S24("REBOOT");
          delay(2000); esp_restart();
        }
      }
    }
  } else {
    //##############################################################################
    //
    // SW0 button is released
    //
    //##############################################################################
    if (sw0Wup) {
      // waited for button release
      sw0Wup = false; sw0Cnt = 0; sw0Timer = 0; sw0LastState = sw0State; return;
    } else {
      if (sw0LastState == LOW) {
        // SW0 has just been released
        // Serial.println("SW0 Lo-Hi");
        if (TEST) {Serial.println("SW0 Lo-Hi");}
        // SW0 display functions are dependant on MainMode value. The change is performed
        // in a separate function, so that button 'L' on the Wii Classic Pro can
        // also toggle display settings.
        Change_DispMode();
      }
      if (sw0Timer > 50) {
        // button released for 1 sec so assume valid button counts
      //    Serial.print(F("swCnt = ")); Serial.println(swCnt);
        if (TEST && (sw0Cnt > 0)) {
          // single button press during test mode
        }
        sw0Cnt = 0; sw0Timer = 0;
      }
      sw0DwnTime = 0;
    }
  }
  sw0LastState = sw0State; // record current state
  if (sw0Cnt > 0) {sw0Timer++;}
}

// ---------------------------------------------------------------------------------

void readSW1() {
  // read the right button switch and respond accordingly, pressed == LOW
  // a button press will automatical drop the WiFi mode
  // SW1 is read every 20ms (50Hz) to debounce
  sw1State = digitalRead(sw1Pin); // record button state
  if (sw1_Nop) {return;}          // block this function whilst == true
  
  if (!sw1State) {
    //##############################################################################
    //
    // SW1 button is pressed down
    //
    //##############################################################################
    if (sw1Wup) {return;}
    
    if (sw1LastState == HIGH) {
      // SW1 has just been pressed down
      // Serial.println("SW1 Hi-LO");
      if (TEST) {Serial.println("SW1 Hi-LO");}
      sw1DwnTime = 0; // restart button down time counter
      sw1Cnt++; // count on the falling edge
      sw1Timer = 0; // reset the timer
      if (WiFiEn) {sw1Cnt = 0; SetMainMode(0); return;}
      if (TEST) {
        // put TEST code here
      } else {
        // not in TEST mode
        if (MainMode == 50) {
          // if in audio select mode 50 then YES is selected
          // go to MainMode = 5 and initiate player task using ModeSel pointer
          MainMode = 5; AudioTask = -1; sw1Wup = true;
          sw1Cnt = 0; sw1Timer = 0; return;
        } else if (MainMode == 99) {
          // if in MainMode 99 then YES is selected
          SetMainMode(ModeSel); sw1Wup = true;
          sw1Cnt = 0; sw1Timer = 0; return;
        } else if (MainMode > 0) {
          // not in MainMode == 99 or sleep so show count on display
          if (MainMode == 1) {
            // Sonar mode, fixed head, counting button clicks
            if (MainTask > 0) {SuspendMainTask();}  // stop anything that is happening
            if (sw1Cnt > 3) {sw1Cnt = 1;}
            switch (sw1Cnt) {
              case 1: DisplayText2S24("SF" + String(sw1Cnt),"Sonar Range"); break;
              case 2: DisplayText2S24("SF" + String(sw1Cnt),"Back Away"); break;
              case 3: DisplayText2S24("SF" + String(sw1Cnt),"Track"); break;
            }
          }
          else if (MainMode == 2) {
            // Sonar mode, moving head, counting button clicks
            if (MainTask > 0) {SuspendMainTask();}  // stop anything that is happening
            if (sw1Cnt > 5) {sw1Cnt = 1;}
            switch (sw1Cnt) {
              case 1: DisplayText2S24("SA" + String(sw1Cnt),"Sonar Range"); break;
              case 2: DisplayText2S24("SA" + String(sw1Cnt),"Back Away"); break;
              case 3: DisplayText2S24("SA" + String(sw1Cnt),"Track"); break;
              case 4: DisplayText2S24("SA" + String(sw1Cnt),"Sonar Scan"); break;
              case 5: DisplayText2S24("SA" + String(sw1Cnt),"Autonomous"); break;
            }
          }
          else if (MainMode == 3) {
            // LTOF mode, fixed head, counting button clicks
            if (MainTask > 0) {SuspendMainTask();}  // stop anything that is happening
            if (sw1Cnt > 3) {sw1Cnt = 1;}
            switch (sw1Cnt) {
              case 1: DisplayText2S24("LF" + String(sw1Cnt),"LTOF Range"); break;
              case 2: DisplayText2S24("LF" + String(sw1Cnt),"Back Away"); break;
              case 3: DisplayText2S24("LF" + String(sw1Cnt),"Track"); break;
            }
          }
          else if (MainMode == 4) {
            // LTOF mode, moving head, counting button clicks
            if (MainTask > 0) {SuspendMainTask();}  // stop anything that is happening
            if (sw1Cnt > 5) {sw1Cnt = 1;}
            switch (sw1Cnt) {
              case 1: DisplayText2S24("LA" + String(sw1Cnt),"LTOF Range"); break;
              case 2: DisplayText2S24("LA" + String(sw1Cnt),"Back Away"); break;
              case 3: DisplayText2S24("LA" + String(sw1Cnt),"Track"); break;
              case 4: DisplayText2S24("LA" + String(sw1Cnt),"LTOF Scan"); break;
              case 5: DisplayText2S24("LA" + String(sw1Cnt),"Autonomous"); break;
            }
          }
          else if (MainMode == 5) {
            // Audio mode, restart tune
            if (AudioTask) {
              AudioStop(); AudioTask = 0;           // stop anything that is playing
              if (GunMode > 1) {SetGunMode(1);}     // rest Gun if moving
              if (HeadMode > 1) {SetHeadMode(1);}   // rest Head if moving
            }
            SetMainMode(5); sw1Wup = true; sw1Cnt = 0; sw1Timer = 0; return;
          }
          else if (MainMode == 6) {
            // Drive mode, counting button clicks
            if (MainTask > 0) {SuspendMainTask();}  // stop anything that is happening
            if (sw1Cnt > 2) {sw1Cnt = 1;}
            switch (sw1Cnt) {
              case 1: DisplayText2S24(String(sw1Cnt),"Inactive"); break;
              case 2: DisplayText2S24(String(sw1Cnt),"Demo"); DispDel = 50; break;
            }
          }
       }
      }
    } else {
      sw1DwnTime++; // track button pressed time
      if(sw1Timer >= 50) {
        // button held down for >= 1 second
        sw1Cnt = 0; sw1Timer = 0;
      }
    }
  } else {
    //##############################################################################
    //
    // sw1State == HIGH as SW1 button is not pressed
    //
    //##############################################################################
    if (sw1Wup) {
      // release locked-out state
      sw1Wup = false;
      sw1Cnt = 0; sw1Timer = 0;
    } else {
      // normal SW1 release
      if (sw1LastState == LOW) {
        // SW1 has just been released
        // Serial.println("SW1 Lo-Hi");
        if (TEST) {Serial.println("SW1 Lo-Hi");}
      }
      if (!TEST) {
        // not in TEST mode so set task based on count value
        if ((sw1Timer > 50) && (sw1Cnt > 0)) {
          // 1 sec timeout + count > 0
           switch (MainMode) {
            case 1: // Sonar fixed mode, tasks 11 - 14
              sw1Cnt = constrain(sw1Cnt,1,4); SetMainTask(10 + sw1Cnt);
              break;
            case 2: // Sonar moving mode, tasks 21 - 25
              sw1Cnt = constrain(sw1Cnt,1,4); SetMainTask(20 + sw1Cnt);
              break;
            case 3: // LTOF fixed mode, tasks 31 - 34
              sw1Cnt = constrain(sw1Cnt,1,4); SetMainTask(30 + sw1Cnt);
              break;
            case 4: // LTOF moving mode, tasks 41 - 45
              sw1Cnt = constrain(sw1Cnt,1,4); SetMainTask(40 + sw1Cnt);
              break;
            case 5: // Audio mode, tasks 51 - 51
              sw1Cnt = constrain(sw1Cnt,0,1); SetMainTask(50 + sw1Cnt);
              break;
            case 6: // Drive mode, tasks 61 - 62
              sw1Cnt = constrain(sw1Cnt,0,2); SetMainTask(60 + sw1Cnt);
              break;
           }
         // task select will depend on MainMode
          DispDel = 0; DispCnt = 0; // update display immediately
          sw1Cnt = 0; sw1Timer = 0; // clear events
        }
      }
    }
  }
  sw1LastState = sw1State; // record current state
  if (sw1Cnt > 0) {sw1Timer++;}
}

// ---------------------------------------------------------------------------------

void readWiFiRx() {
  // called from the main loop every cycle to check for ESP-NOW data  
  // a state machine is used to separate the data blocks by header type
  switch(Rx_Task) {
    case 0: // determine the type of data to handle
           if (Rx_Buff.ESPdata[Rx_Pnt] == 'B') {Rx_Task = 3; break;}
      else if (Rx_Buff.ESPdata[Rx_Pnt] == 'C') {WiiType = 'C'; Rx_Task = 1; break;}
      else if (Rx_Buff.ESPdata[Rx_Pnt] == 'P') {WiiType = 'P'; Rx_Task = 1; break;} // Classic Pro
      else if (Rx_Buff.ESPdata[Rx_Pnt] == 'N') {WiiType = 'N'; Rx_Task = 1; break;}
      else if (Rx_Buff.ESPdata[Rx_Pnt] == '-') {WiiType = '-'; Rx_Task = 1; break;}
      else if (Rx_Buff.ESPdata[Rx_Pnt] == '$') {Rx_Task = 2; break;}
      // oh dear! block header not recognised so discard the block and flag error
      else {WiFiRxErr++; WiFiRx = false;}
      break;
      
    case 1: // load Wii I2C data
      // after the header byte there are 6 data bytes + checksum
      // perform XOR on 6 bytes to check for errors
      if (Rx_Buff.ESPdata[7] == (Rx_Buff.ESPdata[1] ^ Rx_Buff.ESPdata[2] ^ Rx_Buff.ESPdata[3] ^ Rx_Buff.ESPdata[4] ^ Rx_Buff.ESPdata[5] ^ Rx_Buff.ESPdata[6])) {
        // data has passed the checksum test
        RxWiFi[0] = Rx_Buff.ESPdata[1];
        RxWiFi[1] = Rx_Buff.ESPdata[2];
        RxWiFi[2] = Rx_Buff.ESPdata[3];
        RxWiFi[3] = Rx_Buff.ESPdata[4];
        RxWiFi[4] = Rx_Buff.ESPdata[5];
        RxWiFi[5] = Rx_Buff.ESPdata[6];

        RxRec = true;     // indicate a valid frame
        if (WiiType == 'N') {           // Wii Nunchuk
          JoyX = RxWiFi[0];             // joystick X 0-255
          JoyY = RxWiFi[1];             // joystick Y 0-255
          CZ = RxWiFi[5] & 3;           // CZ buttons, C = 2/0, Z = 1/0, active low
          RxNunch = true; RxClass = false;
        } else if (WiiType == 'C') {    // Wii Classic
          // if Wii Classic data strip off the JLX,JLY,JRX,JRY and CZ values
          // the left joystick is used for head/gun control
          // the right joystick is used for track drive control
          // Nunchuk 'C' and 'Z' buttons are mapped to BRT and BLT respectively here
          // the right hand X axis is 5 bits, 0 - 31, centred on 16
          // here the bits are extracted and shifted, to centre X on 128
          JoyX = WiiRightStickX() * 8;  // joystick X 0-255
          JoyY = WiiRightStickY() * 8;  // joystick Y 0-255
          CZ = ((RxWiFi[4] & 0b100000)>>5) + (RxWiFi[4] & 0b10); // read LT and RT buttons as C,Z
          RxClass = true; RxNunch = false;
        } else if (WiiType == 'P') {    // Wii Classic Pro
          // if Wii Classic pro data strip off the JLX,JLY,JRX,JRY and CZ values
          // the left joystick is used for head/gun control
          // the right joystick is used for track drive control
          // Nunchuk 'C' and 'Z' buttons are mapped to BRT and BZR respectively here
          // the right hand X axis is 5 bits, 0 - 31, centred on 16
          // here the bits are extracted and shifted, to centre X on 128
          JoyX = WiiRightStickX() * 8;  // joystick X 0-255
          JoyY = WiiRightStickY() * 8;  // joystick Y 0-255
          CZ = (RxWiFi[4] & 0b10) + ((RxWiFi[5] & 0b100)>2); // read RT and ZR buttons as C,Z
          RxClass = true; RxNunch = false;
        } else {
          // no Wii controller so set defaults
          JoyX  = 128; JoyY  = 128; CZ = 3;
          JoyLX = 128; JoyLY = 128;
        }
      } else {
        // received data failed the checksum test
        WiFiRxErr++; RxRec = false;
      }
      Rx_Task = 0;  // reset the task pointer to lok at another block if needed
      Rx_Pnt += 8;  // increase the data pointer beyond this block
      if (Rx_Pnt >= Rx_len) {WiFiRx = false; Rx_len = 0;} // reached end of buffer
      break;

    case 2: // load text data as if from a serial port
      // read characters up to the end of the buffer
      Rx_Pnt++;
      if (Rx_Pnt >= Rx_len) {WiFiRx = false; Rx_len = 0; break;} // reached end of buffer
      keyVal = Rx_Buff.ESPdata[Rx_Pnt]; PrintTgt = 1; decodeKey(keyVal);
      // Serial.write(keyVal);
      break;

    case 3: // load binary data block
      // data length is specified in second byte
      Rx_Pnt++;
      // at the moment just jump over it, binary transfer is not needed
      Rx_Pnt += Rx_Buff.ESPdata[Rx_Pnt] + 1;
      if (Rx_Pnt >= Rx_len) {WiFiRx = false; break;} // reached end of buffer
      break;
  }
}

// ---------------------------------------------------------------------------------

void readWii() {
  // called every 20ms, but wireless transceiver only transmits every 40ms
  // considers data received from the Wii Nunchuk controller over WiFi and 
  // manages all movements demanded by the controller
  if (readWiiCall) {return;}  // avoid stack overflow
  
  readWiiCall = true; // prevent re-entry of this function
  
  if (RxRec) {
  //##############################################################################
  //
  //  WiFi Nunchuk data received
  //
  //##############################################################################
    // Wii data received but we may not have enabled WiFi mode yet
    RxRec = false; RTxTimeout = 25; // set timeout to approx 500ms
    // PrintTx += "JX" + String(JoyX) + " JY" + String(JoyY) + " CZ" + String(CZ) + "\n";
    // Serial.print("CZ "); Serial.println(CZ);
    if (!WiFiEn) {
  //##############################################################################
  //
  //  WiFi is currently disabled, listening
  //
  //##############################################################################
      // we have not received enough 'C' buttons to make the system active
      // the 'C' button alone must be held in to activate the Wii WiFi link
      if (CZ == 1) {
        // C button only is being pressed
        if (AudioTask) {AudioStop(); SetMainMode(0);}
        if (WiFiCntC < 1) {DisplayText2("Waking","Up!");}
        WiFiCntC += 2;
        // Serial.println("WiFiCnt = " + String(WiFiCntC));
        if (WiFiCntC > 60) {
          // going active, user has held in 'C' button for sufficient time
          // Serial.println("WiFiEn = true");
          SetMainMode(7); PwmEn = true; // go to Wi-Fi mode
          SetLedMode(2);
          BotActive = true; WiFiEn = true; C_Dn = 8;
          // say "Wii controller enabled." + "Let's go sir!"
          TalkDel = 20; TalkAdd("/P/WI0001.WAV");  TalkAdd("/P/LE0000.WAV");
          // Set defaults for Wi-Fi enabled here:
          SetGunTo(Gun0);   // centre Gun
          SetHeadTo(Sen0);  // centre head
          Gear = 1;
        } else {
          // still counting C buttons
          LEDVal = WiFiCntC/10; SetLedMode(10);
        }
      } else {
        // C button not pressed or released early so check for a inadequate count
        if (WiFiCntC > 0) {
          // reduce the C-button counter, which has to be sustained to enable WiFi mode
          WiFiCntC--; LEDVal = 1 + (WiFiCntC/10);
          if (WiFiCntC < 1) {
            SetLedMode(0); DisplayText2("Wakeup","Cancelled");
            SetMainMode(0);
          } else {SetLedMode(10);}
        }
      }
    } else {
      
  //##############################################################################
  //
  //  WiFi is enabled
  //
  //##############################################################################
      // WiFi enabled so check for power down
      // CZ button states are active LOW
      if (CZ == 0) {
        // both C and Z buttons are being pressed so move towards powering down
        if (WiFiCntC > 0) {
          if (WiFiCntC == 64) {DisplayText2("Going To","Sleep..."); DispMode = 0;}
          WiFiCntC -= 2;
          // Serial.println("WiFiCnt = " + String(WiFiCntC));
          if (WiFiCntC <= 0) {
            // power-down condition satisfied, so go to rest
            // Serial.println("WiFi mode disabled!");
            WiFiCntC = 0; WiFiDisable();
            GoToSleep(); // go to the resting state
            // say "Wii controller disabled."
            TalkDel = 20; TalkAdd("/P/WI0000.WAV");
            // set defaults here for sleep mode
             BotActive = false; SetLedMode(0);
             SetMainMode(0);
          } else {
            // still counting down CZ buttons
            SetLedMode(10);
          }
        }
      } else {
        // Check CZ buttons to see if a speed change is wanted
        if ((CZ & 2) == 0) {
          // C button is pressed, assume a speed change is needed
          C_Dn++;
          if (C_Dn == 2) {
            C_Dn = 8;
            if (Gear < 5) {
              Gear++; SetMaxSpeed(); SetLedMode(20);
              // if (!IsrRun) {
                     if (Gear == 2) {TalkAdd("/P/GE0001.WAV");}
                else if (Gear == 3) {TalkAdd("/P/GE0002.WAV");}
                else if (Gear == 4) {TalkAdd("/P/GE0003.WAV");}
                else if (Gear == 5) {TalkAdd("/P/GE0004.WAV");}
                else {TalkAdd("/P/YO0001.WAV");}
              TalkDel = 10;
              // }
            }
            if (DispMode != 15) {DisplayText2S24(String(Gear),"Gear");}

          }
          // Serial.println("Gear =" + String(Gear));
        } else {if (C_Dn > 0) {C_Dn--;}} // C button released
        // Check Z button. It has two functions. Short press change speed, but if
        // held in it changes the mode of the joysticks
        if ((CZ & 1) == 0) {
          // Z button is pressed
          Z_Dn++; if (Z_Dn >= 12) {
            if (Z_Dn == 12) {
              Z_Mode = !Z_Mode; // toggle joystick motion mode flag
              Border = true; // turn on boarder
              if (Z_Mode) {DisplayText2("Slide","Drive");}
              else {DisplayText2("Normal","Drive");} DispDel = 12;        // short display 480ms
              Border = false; // thick boarder
            } Z_Dn = 50;        // Z_Dn capped at 50, held for >= 2 seconds
          }
          // Serial.print("Z_Dn "); Serial.println(Z_Dn);
        } else {
          // Z button is not pressed
          if ((Z_Dn > 1) && (Z_Dn <= 10)) {
            // held down for less than 400 ms @ 40ms Rx cycle
            if (Gear > 1) {
              Gear--; SetMaxSpeed(); SetLedMode(20);
              // if (!IsrRun) {
                     if (Gear == 1) {TalkAdd("/P/GE0000.WAV");}
                else if (Gear == 2) {TalkAdd("/P/GE0001.WAV");}
                else if (Gear == 3) {TalkAdd("/P/GE0002.WAV");}
                else if (Gear == 4) {TalkAdd("/P/GE0003.WAV");}
                else {TalkAdd("/P/YO0000.WAV");}
                TalkDel = 10;
              // }
            }
            if (DispMode != 15) {DisplayText2S24(String(Gear),"Gear");}
          } Z_Dn = 0; // Z button released so clear down counter
        }
        // Serial.print("Z_Dn "); Serial.println(Z_Dn);

        if (WiFiCntC < 60) {
          // C-button counter is not at full strength, assume WiFi off released prematurely
          WiFiCntC++; LEDVal = 1 + (WiFiCntC/10);
          if (WiFiCntC == 60) {LED_Task = -1;} else {LED_Task = -10;}
        }
      }
    }
      
  //##############################################################################
  //
  //  Wii joystick demands
  //
  //##############################################################################
    // Wii joystick controller demands are accepted if:
    //  * TankBot is active
    //  * Wii controller has sent new data
    //  * MainTask is running at 71
    if (BotActive && WiFiEn && JoyActive) {
      if (MainTask == 71) {
        // read the X,Y joysticks and drive if demanded
        JoyActive = false; // prevent stack overflow during moves that call loop()
        // respond to joystick demands every 40ms (25Hz)
        // note direction of travel will only change once stick has been centred
        if ((JoyX >= DbLLX) && (JoyX <= DbULX) && (JoyY >= DbLLY) && (JoyY <= DbULY)) {
          // joystick is in centre deadband position
          JoyMode = 0; // reset the direction of travel mode
            // Serial.print(F("#"));
          if (Drive != 0) {
            // Serial.println(F("Stopping"));
            DithON = false; SetLedMode(2);
            // stop driving if active, but remember direction
            DriveLast = Drive; Drive = 0;
            // Serial.println("MotorPWM (0,0,0,0)");
            MotorPWM (0,0); Steer = 0;
          }
        } else {
          // not in centre deadband position
          if (JoyMode == 0) {
            // in normal mode a joystick selection locks us into that mode, until released
            autoRest = 0; // reset user time-out
            // we apply a deadband to the joystick before triggering movement
            // there are potentially 8 directions of travel
            if (!Z_Mode) {
              // Normal drive mode
                  if (JoyY > DbULY) {JoyMode = 1;} // drive forward
              else if (JoyY < DbLLY) {JoyMode = 5;} // drive backwards
              else if (JoyX > DbULX) {JoyMode = 3;} // neutral turn right
              else if (JoyX < DbLLX) {JoyMode = 7;} // neutral turn left
            }
          }
          if (Z_Mode) {
            // Slide drive mode, joystick can change direction of travel at any time
            // JoyModes range from 10 to 18 in this active Z_Mode
            // priority testing goes to forward/reverse and left/right directions
            if (JoyY > DbULY) {
                  // joystick pushed forward
                  if (JoyX < DbLLX) {JoyMode = 18;}  // slide to the NW
              else if (JoyX > DbULX) {JoyMode = 12;}  // slide to the NE
              else {JoyMode = 11;}                    // drive forward
            }
            else if (JoyY < DbLLY) {
                  // joystick pulled backwards
                  if (JoyX < DbLLX) {JoyMode = 16;}  // slide to the SW
              else if (JoyX > DbULX) {JoyMode = 14;}  // slide to the SE
              else {JoyMode = 15;}                    // drive backwards
            }
            else {
                  if (JoyX > DbULX) {JoyMode = 13;}       // slide right
              else if (JoyX < DbLLX) {JoyMode = 17;}       // slide left
            }
          }
          autoRest = 0;     // reset user time-out
          switch (JoyMode) {
          case 1: JoyMoveFwd(); break;
          case 3: JoyTurnRgt(); break;
          case 5: JoyMoveBwd(); break;
          case 7: JoyTurnLft(); break;
          }
        } JoyActive = true; // re-enable this code block
      }
    } else {
      //##############################################################################
      //
      //  Wii controller demands
      //
      //##############################################################################
      // Wii controller demands are used by other code functions if:
      //  * TankBot is active
      //  * Wii controller has sent new data
      //  * Wii controller is a Classic or Classic Pro
      // otherwise all Rx registers are cleared here
      if (!RxClass) {for (int zR = 0;zR < 6;zR++) {RxWiFi[zR] = 255;}}
    }
  } else {
  //##############################################################################
  //
  //  No WiFi Nunchuk received recently
  //
  //##############################################################################
    if (WiFiEn) {
      // HexBot is enabled for Wii WiFi control
      // maintain Wii enabled counter
      if ((WiFiCntC < 64) && (CZ != 0)) {
        WiFiCntC++; LEDVal = WiFiCntC/10;
        if (WiFiCntC == 64) {LED_Task = -1;} else {LED_Task = -10;}
      }
    }
  }

  if (WiFiEn) {
  //##############################################################################
  //
  //  WiFi background tasks when WiFi is enabled
  //
  //##############################################################################
    // only do these functions if WiFi is enabled
    if (MoveState == 20) {
      // long un-demanded moves like bowing are watched until they complete
      MoveState = 0; LED_Task = -1;
    }
    
    if (MoveState == -1) {
      // at the end of a joystick move we want to set things back to normal
      LED_Task = -1;
      // SetSpeedDefaults();
      MoveState = 0;
    }
  }
  
  readWiiCall = false; // re-allow calls to this function
  // Serial.print("CntZ "); Serial.println(WiFiCntZ);
  //   Serial.println(MoveState);
}

// --------------------------------------------------------------------------------

void Reset_Slots() {
  // called before using the slot sensors to count pulses
 // FL sensor:
  IntP34State = digitalRead(INT_P34); IntP34Ch = false; IntPeriods[0] = 0;
  IntMicros[0] = micros(); IntP34Cnt = 0; IntLast40[0] = 0; Int34Rev = 0; Int34RPM = 0;
  AutoStopFL = 0;
  // FR sensor:
  IntP39State = digitalRead(INT_P39); IntP39Ch = false; IntPeriods[1] = 0;
  IntMicros[1] = micros(); IntP39Cnt = 0; IntLast40[1] = 0; Int39Rev = 0; Int39RPM = 0;
  AutoStopFR = 0;
}

// --------------------------------------------------------------------------------

void RxGetChecksum(int zlen) {
  // performs an XOR checksum calc on the Rx buffer of length zlen
  Rx_Chk = 0x55;  // define checksum seed as 01010101
  for (int zP = 0;zP < zlen;zP++) {
    Rx_Chk = Rx_Chk ^ Rx_Buff.ESPdata[zP];
  }
}

// --------------------------------------------------------------------------------

void SetLedMode(int16_t zM) {
  // Sets the LED mode and clears the LED variables
  // if zM matches current LedMode then do nothing
  if (zM == LedMode) {return;}
  // if LedMode == 6 (speach pk tracking) then record the desired mode as LedLast
  // if (LedMode == 6) {LedLast = zM; return;}  // currently talking
  
  LedLast = LedMode;  // remember current mode in case we want to return to it
  // if zM is -ve then reset that mode
  LedMode = abs(zM); LED_Cnt = 0; LED_Inc = 1;
  LED_Task = 0; LED_Period0 = 20; LED_Del0 = 0; LED_Pnt = 0;
  LEDnow0 = false; LED_Run0 = true; LEDshow0 = false;
  switch (Gear) {
    case 1: Gear_LEDs[0].setRGB( 0, 8, 0); break;
    case 2: Gear_LEDs[0].setRGB( 4,10, 0); break;
    case 3: Gear_LEDs[0].setRGB(10,10, 0); break;
    case 4: Gear_LEDs[0].setRGB(20, 6, 0); break;
    case 5: Gear_LEDs[0].setRGB(32, 0, 0); break;
  }
  // Serial.println("SetLedMode" + String(LedMode));
}

// --------------------------------------------------------------------------------

void SetMainMode(int16_t zM) {
  // Sets the default conditions for a new mode
  // MainMode affects display functions and MainTask settings
  //  0 = Sleep mode, default
  //  1 = Sonar Fixed head mode
  //  2 = Sonar auto head mode
  //  3 = LTOF fixed head mode
  //  4 = LTOF auto head mode
  //  5 = Audio selection mode
  //  6 = Drive mode demo
  //  7 = Wi-Fi Wii controller mode
  // 99 = mode select
  // now set mode specific items
  ModeSel = MainMode; ModeWas = MainMode; MainMode = zM;
  Brightness = 0;   // force Brightness to be set in display update 
  switch (zM) {
    case 0: // sleep mode
      DispMode = 0; DispNxtCnt = 0;
      BotActive = false; WiFiEn = false;
      if (GunMode > 1) {SetGunMode(1);}
      if (HeadMode > 1) {SetHeadMode(1);}
      SetMainTask(0); SetLedMode(0);
      // say "Going to sleep." + "Good night."
      if (ModeWas != MainMode) {TalkDel = 20; TalkAdd("/P/GO0000.WAV"); TalkAdd("/P/GO0001.WAV");}
      break;
    case 1: // sonar, head fixed mode
      SetDispMode(10); BotActive = true; WiFiEn = false;
      SetMainTask(11); SetLedMode(5);
      break;
    case 2: // sonar, head moving mode
      SetDispMode(20); BotActive = true; WiFiEn = false;
      SetMainTask(21); SetLedMode(5);
      break;
    case 3: // LTOF, head fixed mode
      SetDispMode(30); BotActive = true; WiFiEn = false;
      SetMainTask(31); SetLedMode(5);
      break;
    case 4: // LTOF, head moving mode
      SetDispMode(40); BotActive = true; WiFiEn = false;
      SetMainTask(41); SetLedMode(5); 
      break;
    case 5: // switch to audio selection mode 50
      MainMode = 50; ModeSel = 0;
      SetDispMode(50); BotActive = true; WiFiEn = false;
      SetMainTask(50); SetLedMode(0);
      // say "Audio mode." if this is a new mode
      if ((ModeWas != 5) && (ModeWas != 50)) {TalkDel = 20; TalkAdd("/P/AU0010.WAV");}
      break;
    case 6: // Drive mode
      SetDispMode(60); BotActive = true;
      SetMainTask(61); SlotEn = true; SetLedMode(2); break;
    case 7: // WiFi Wii controller mode
      SetDispMode(80); BotActive = true;
      SetMainTask(71); SlotEn = true; SetLedMode(2); break;

    case 99:  // new mode selection
      ModeSel= 0; DispMode = 99; SetMainTask(0); break;
  } DispDel = 0;  DispCnt = 0; DispNxtCnt = 0;
}

// --------------------------------------------------------------------------------

void SetMainTask(int16_t zMT) {
  // sets the main task and associated flags
  // immediately stop any movement
  AudioPkEn = false;    // if set == true a peak scan will be performed when playing audio
  CalcCnt = 0;          // reset head calculation flag
  DispNOP = false;      // if == true then don't update the display functions
  Drive = 0;            // reset drive direction
  DriveLast = 0;        // reset previous driving direction
  ESC = false;          // clear the ESCape flag
  Gear = 1;             // start in lowest speed range
  GunAirEn = false;     // enables Gun movement in air defence mode
  HCSR04 = false;       // if == true then run sonar range measurement task
  HeadAirEn = false;    // enables head movement in air defence mode
  HeadAngle = 0;        // head angle in degrees, 0 centre
  HeadInc = 2;          // head angle increment in degrees, 2 default
  LedGunMode = 0;       // gun LED mode
  LTOFcalc = false;     // if == true then calculate speed of ranged object in m/s
  MainRun = false;      // clear MainTask inh
  MainTask = zMT;       // set MainTask
  MainType = 0;         // a number representing the type of task, default = 0
  MotorPWM(0,0);        // ensure motors are off
  PwmEn = false;        // if == true motor PWM is enabled
  PwmInt = 0;           // integrator used in motor control
  PWM_Start = PWM_StartMax; // default start value
  Range = LtofMax;      // set LTOF range to max
  RangeDataDPL = 20;    // centre of RangeData[] array
  RangeFps = false;     // == true if LTOF/Sonar fps is to be displayed
  RangeMax = LtofLimit; // the current limited to Range measurements
  RangeMin = LtofMin;   // the current lower limited to Range measurements
  RangeRate = 64;       // max rate of inter-measurement Range change, default = 64
  Reset_Slots();        // reset slot counters
  SetLedMode(0);        // remove any LED flashing
  SlotEn = false;       // turn OFF slot sensor reading
  Steer = 0;            // zero steering
  SubCnt = 0;           // sub task general counter
  SubDel = 0;           // subtask delay counter
  SubTask = 0;          // reset sub task pointer
  SubTask1 = 0;         // level 1 sub task pointer
  sw0_Reset();          // reset SW0 scan variables
  sw1_Reset();          // reset SW1 scan variables
  Turn = false;         // default = false; if true turns continuously until = false
  if (VL53L1X_Task > 0) {VL53L1X_OFF();}  // laser disabled by default
  Z_Mode = false;       // joystick motion flag, normally false, if == true then slide mode

  // give VL53L1X 1ms to reset
  delay(1);
  synchLoopTimers();
  
  switch(MainTask) {
    case  1:  // intro task, called at Boot, no setup needed
      break;
    case 11:  // Sonar fixed head ranging display
      DispMode = 31;              // Sonar range
      RangeFps = true;            // fps is to be displayed
      clearRangeData(RangeMin);   // reset range data to minimum values
      HCSR04 = true;              // run sonar range measurement task
      SetHeadMode(1);             // centre head
      SetLedMode(5);              // LEDs set to ranging
      // say "Sonar, range."
      TalkDel = 10; TalkAdd("/P/SO0050.WAV");
      break;
    case 12:  // Sonar fixed backaway task
      DispMode = 31;              // Sonar range
      MainType = 2;               // 'Back Away' displayed
      clearRangeData(RangeMin);   // reset range data to minimum values
      SetHeadMode(1);             // centre head
      HCSR04 = true;              // run sonar range measurement task
      SetLedMode(5);              // LEDs set to ranging
      PwmEn = true;               // enable motor PWM
      // say "Sonar, back away."
      TalkDel = 10; TalkAdd("/P/SO0001.WAV");
      break;
    case 13:  // Sonar fixed head target tracking task, forwards/backwards
      DispMode = 31;              // Sonar range
      MainType = 3;               // 'Track Mode' displayed
      clearRangeData(RangeMin);   // reset range data to minimum values
      SetHeadMode(1);             // centre head
      HCSR04 = true;              // run sonar range measurement task
      SetLedMode(5);              // LEDs set to ranging
      PwmEn = true;               // enable motor PWM
      // say "Sonar, follow you."
      TalkDel = 10; TalkAdd("/P/SO0010.WAV");
      break;
    case 14:  // Sonar fixed head autonomous task - not supported here
      break;

    case 21:  // Sonar Auto head ranging display
      DispMode = 31;              // Sonar range
      RangeFps = true;            // Range fps is to be displayed
      clearRangeData(RangeMin);   // reset range data to minimum values
      SetHeadMode(1);             // centre head
      HCSR04 = true;              // run sonar range measurement task
      SetLedMode(5);              // LEDs set to ranging
      // say "Sonar, range."
      TalkDel = 10; TalkAdd("/P/SO0050.WAV");
      break;
    case 22:  // Sonar Auto head backaway task
      // say "Sonar, back away." + "Not yet coded!"
      TalkDel = 10; TalkAdd("/P/SO0001.WAV");  TalkAdd("/P/NO0050.WAV");
      break;
    case 23:  // Sonar Auto head target tracking task, forwards/backwards
      // say "Sonar, follow you." + "Not yet coded!"
      TalkDel = 10; TalkAdd("/P/SO0010.WAV");  TalkAdd("/P/NO0050.WAV");
      break;
    case 24:  // Sonar Auto head air defence task
      DispMode = 31;              // Sonar range
      RangeFps = true;            // Range fps is to be displayed
      clearRangeData(RangeMin);   // reset range data to minimum values
      SetHeadMode(3);             // air defence scanning mode
      SetGunMode(4);              // air defence scanning mode
      SetLedMode(5);              // LEDs set to ranging
      if (!App) {
        // not in air defence app mode
        GunAirEn = true;            // enable Gun movement, can be controlled remotely
        HeadAirEn = true;           // enable Head movement, can be controlled remotely
        HCSR04 = true;              // run sonar range measurement task
      }
      break;
    case 25:  // Sonar auto head autonomous task
      // say "Sonar, autonomous mode." + "Not yet coded!"
      TalkDel = 10; TalkAdd("/P/SO0002.WAV");  TalkAdd("/P/NO0050.WAV");
      break;

    case 31:  // LTOF fixed head ranging display
      DispMode = 31;              // LTOF range
      RangeFps = true;            // Range fps is to be displayed
      clearRangeData(RangeMin);   // reset range data to minimum values
      VL53L1X_ON();               // enable laser ranging task
      SetHeadMode(1);             // centre head
      SetLedMode(5);              // LEDs set to ranging
      // say "Laser, range."
      TalkDel = 10; TalkAdd("/P/LA0050.WAV");
      break;
    case 32:  // LTOF fixed head backaway task
      DispMode = 31;              // LTOF range
      MainType = 2;               // 'Back Away' displayed
      clearRangeData(RangeMin);   // reset range data to minimum values
      VL53L1X_ON();               // enable back away task
      SetHeadMode(1);             // centre head
      SetLedMode(5);              // LEDs set to ranging
      PwmEn = true;               // enable motor PWM
      // say "Laser, back away."
      TalkDel = 10; TalkAdd("/P/LA0001.WAV");
      break;
    case 33:  // LTOF fixed head target tracking task, forwards/backwards
      DispMode = 31;              // LTOF range
      MainType = 3;               // 'Track Mode' displayed
      clearRangeData(RangeMin);   // reset range data to minimum values
      VL53L1X_ON();               // enable target tracking task
      SetHeadMode(1);             // centre head
      SetLedMode(5);              // LEDs set to ranging
      PwmEn = true;               // enable motor PWM
      // say "Laser, follow you."
      TalkDel = 10; TalkAdd("/P/LA0010.WAV");
      break;
      
    case 41:  // LTOF auto head ranging display
      DispMode = 41;               // LTOF range
      RangeFps = true;            // Range fps is to be displayed
      clearRangeData(RangeMin);    // reset range data to minimum values
      VL53L1X_ON();                // enable laser ranging task
      SetLedMode(5);               // LEDs set to ranging
      // say "Laser, range."
      TalkDel = 10; TalkAdd("/P/LA0050.WAV");
      break;
    case 42:  // LTOF auto head backaway task
      DispMode = 41;               // LTOF range
      clearRangeData(RangeMin);    // reset range data to minimum values
      VL53L1X_ON();                // enable back away task
      SetLedMode(5);               // LEDs set to ranging
      PwmEn = true;                // enable motor PWM
      // say "Laser, back away."
      TalkDel = 10; TalkAdd("/P/LA0001.WAV");
      break;
    case 43:  // LTOF auto head target tracking task, forwards/backwards
      DispMode = 41;               // LTOF range
      clearRangeData(RangeMin);    // reset range data to minimum values
      VL53L1X_ON();                // enable target tracking task
      SetLedMode(5);               // LEDs set to ranging
      PwmEn = true;                // enable motor PWM
      // say "Laser, follow you."
      TalkDel = 10; TalkAdd("/P/LA0010.WAV");
      break;
    case 44:  // LTOF auto head air defence task
      DispMode = 41;               // LTOF range
      clearRangeData(RangeMin);    // reset range data to minimum values
      SetHeadMode(3);              // air defence scanning mode
      SetGunMode(4);               // air defence scanning mode
      SetLedMode(5);               // LEDs set to ranging
      if (!App) {
        // not in air defence app mode
        VL53L1X_ON();              // enable back away task
        GunAirEn = true;           // enable Gun movement, can be controlled remotely
        HeadAirEn = true;          // enable Head movement, can be controlled remotely
      } 
      break;
    case 45:  // LTOF auto head autonomous task
      break;

    case 50:  // play audio track
      DispMode = 50;               // Audio select mode
      MainMode = 50;               // set for audio list selection
      break;
    case 51:  // play audio track
      break;

    case 61:  // Drive Demo 1
      // say "Drive mode."
      TalkDel = 10; TalkAdd("/P/DR0000.WAV");
      break;

    case 71:  // WiFi mode
      break;
   }
  // Serial.println("MainTask = " + String(MainTask));
}

// --------------------------------------------------------------------------------

void SetMaxSpeed() {
  // called when changing 'Gear' to set drive limitations
}

// ---------------------------------------------------------------------------------

void SetServoNow(int16_t zP,int16_t zV) {
  // sets either the Gun or Head servo to zV, also sets the target value
  if (zP == 0) {
    // set Gun servo
    servoVal[0] = zV; servoTgt[0] = zV;
    // if audio is playing we do this through the ISR
    if (IsrRun || Talk) {
      // playing audio
      ServoMask |= 0b000000001;
    } else {
      // not playing audio
      if (!servoAtt[0]) {attachServoN(0);}
      else {servoInst[0].writeMicroseconds(servoVal[0]);}
    }
  }
  if (zP == 1) {
    // set Head servo
    servoVal[1] = zV; servoTgt[1] = zV;
    // if audio is playing we do this through the ISR
    if (IsrRun || Talk) {
      // playing audio
      ServoMask |= 0b000000010;
    } else {
      // not playing audio
      if (!servoAtt[1]) {attachServoN(1);}
      else {servoInst[1].writeMicroseconds(servoVal[1]);}
    }
  }
}

// ---------------------------------------------------------------------------------

void shiftBatData() {
  // shift battery data so that it is a rolling average
  for (int zB = 0; zB < 59; zB++) {BatData[zB] = BatData[zB + 1];}
}

// --------------------------------------------------------------------------------

void Slots_OFF() {
  // turn OFF slot sensor readings and reset counters
  Reset_Slots(); SlotEn = false;
}

// --------------------------------------------------------------------------------

void Slots_ON() {
  // turn ON slot sensor readings and reset counters
  Reset_Slots(); SlotEn = true;
}

// --------------------------------------------------------------------------------

void sw0_Reset() {
  // reset SW0 scan variables
  sw0Cnt = 0;             // button switch counter
  sw0DwnTime = 0;         // button pressed down time
  sw0LastState = HIGH;    // previous state of button switch, HIGH/LOW
  sw0_Nop = false;        // if == true don't perform switch functions
  sw0State = HIGH;        // state of read button switch pin
  sw0Timer = 0;           // timer used to detemine button sequences
  sw0Wup = false;         // set == true for SW0 to wait for button release
}

// --------------------------------------------------------------------------------

void sw1_Reset() {
  // reset SW1 scan variables
  sw1Cnt = 0;             // button switch counter
  sw1DwnTime = 0;         // button pressed down time
  sw1LastState = HIGH;    // previous state of button switch, HIGH/LOW
  sw1_Nop = false;        // if == true don't perform switch functions
  sw1State = HIGH;        // state of read button switch pin
  sw1Timer = 0;           // timer used to detemine button sequences
  sw1Wup = false;         // set == true for SW0 to wait for button release
}

// ---------------------------------------------------------------------------------

void TEST_Init() {
  // called when entering TEST mode
  Bright = 8; FastLED.setBrightness(Bright);  // don't have the LEDs too bright
  if (I2C_LTOF) {
    DispMode = 2;
    VL53L1X_ON();   // turn on laser
  } else {DispMode = 4;}
}

// --------------------------------------------------------------------------------

void VL53L1X_OFF() {
  // switches OFF the VL53L1X laser ranging device
  if (!VL53L1X_Task) {return;}  // not running

  digitalWrite(XSHUT_PIN,LOW);  // shut down VL53L1X sensor
  // Serial.println("VL53L1X OFF");
  RangeEn = false; VL53L1X_Task = 0;
}

// --------------------------------------------------------------------------------

void VL53L1X_ON() {
  // switches ON the VL53L1X laser ranging device
  // if it was already ON then switch it OFF then ON again
  if (RangeEn) {VL53L1X_OFF(); delay(1);}
  // synchLoopTimers(1);}
  
  digitalWrite(XSHUT_PIN,HIGH);  // enable VL53L1X sensor
  if (VL53L1X.init() == false) {
    // ***WARNING*** you can't allow the audio ISR to run whilst using I2C
    // so here we temporarily disable it, to prevent the system from crashing.
    // We store the IsrRun flag, and this must be replaced before leaving this function.
    // So if you add to this code, ensure that you respect that process.
    IsrRunF = IsrRun; IsrRun = false; // temporarily block the audio ISR
    Serial.println("VL53L1X sensor detected!"); I2C_LTOF = true;
    VL53L1X.setDistanceModeShort();         // Sets to 1.3M range
    VL53L1X.setTimingBudgetInMs(33);        // Set timing budget to 33 ms
    VL53L1X.setIntermeasurementPeriod(33);  // Set measurement period in ms
    VL53L1X.setROI(VL53L1X_ROIX,VL53L1X_ROIY,VL53L1X_OC); // Set SPAD ROI
    VL53L1X.startRanging();                 // Starts taking measurements
    Serial.println("VL53L1X ROI SPAD W= " + String(VL53L1X.getROIX()));
    Serial.println("VL53L1X ROI SPAD H= " + String(VL53L1X.getROIY()));
    RangeEn = true; VL53L1X_Task = 1;
    Range = LtofLimit; RangeLast = LtofLimit;
    IsrRun = IsrRunF; // return IsrRun to its previous value
  } else { I2C_LTOF = false; Serial.println("VL53L1X sensor failed!"); RangeEn = false;}
}

// --------------------------------------------------------------------------------

void VL53L1X_Run() {
  // control the VL53L1X sensor using a series of tasks
  // this code gets timing information, for using the sensor more efficiently
  // once measurements start a skip timer is used to avoid unnecessary readings
  if (millis() < VL53L1X_Skip) {return;}  // allowing for reading delay 32ms
  

  // ***WARNING*** you can't allow the audio ISR to run whilst using I2C
  // so here we temporarily disable it, to prevent the system from crashing.
  // We store the IsrRun flag, and this must be replaced before leaving this function.
  // So if you add to this code, ensure that you respect that process.
  IsrRunF = IsrRun; IsrRun = false; // temporarily block the audio ISR
  switch(VL53L1X_Task) {
    // case 8 is placed at the front of the list for speed
    case 8: // wait for measurement to complete
      // this case is placed at the head of the list as it will be used most often
      // if data is not ready we keep coming to this task
      // record previous range just before taking a new measurement
      RangeLast = Range;
      if (VL53L1X.checkForDataReady()) {
        // t1 = millis() - t1; // how long did the measurement take?
        // Serial.println("VL53L1X.checkForDataReady() in " + String(t1) + "ms");
        // t1 = millis();
        VL53L1X_Skip = millis() + VL53L1X_SkipDel; // set the next measurement delay
        VL53L1X_Status = VL53L1X.getRangeStatus();
        // Serial.println(VL53L1X_Status);
        if (VL53L1X_Status == 0) {
          // no ranging errors, valid measurement
          // t0 = micros();
          RangeRaw = VL53L1X.getDistance();
          // t0 = micros() - t0;
          // Serial.println("VL53L1X.getDistance() in " + String(t0) + "µs");
        } else {
          // if an error occurs we lok at the error
          //  1 - Sigma estimator, uncertain measurement, above the internal threshold
          //  2 - Signal value is below the internal defined threshold
          //  4 - Raised when phase is out of bounds
          //  5 - Raised in case of HW or VCSEL failure
          //  7 - Wrapped target, not matching phases
          //  8 - Internal algorithm underflow or overflow
          // 14 -  The reported range is invalid
          // we reject a range if the error exceeds 4
          if (VL53L1X_Status < 5) {
            RangeRaw = VL53L1X.getDistance();
          } else {RangeRaw = RangeMax;}
        }
        LTOFt1 = millis();
        // Serial.println(RangeRaw);
        // t0 = micros();
        VL53L1X.clearInterrupt(); // 444µs clears the interrupt and data ready flag
        // t0 = micros() - t0;
        // Serial.println("VL53L1X.clearInterrupt() in " + String(t0) + "µs");
        // Serial.println("");
        RangeNew = true;
        // sensor reading RangeRaw is rate limited to remove transient noise
        // if change is less then Range is averaged over two measurements to reduce noise
        if (RangeRaw > RangeRawF) {
          if ((RangeRaw - RangeRawF) > RangeRate){RangeRawF+= RangeRate;} else {RangeRawF = (RangeRaw + RangeRawF)/2;}
        } else if (RangeRaw < RangeRawF) {
          if ((RangeRawF - RangeRaw) > RangeRate){RangeRawF-= RangeRate;} else {RangeRawF = (RangeRaw + RangeRawF)/2;}
        } Range = RangeRawF; 
      //  Serial.println(String(Range) + ",0,1000"); // print range for serial monitor/plotter
        // limit the range to avoid erroneous values
        if (Range >= LtofLimit) {Range = LtofLimit; RangeUL = true;} else {RangeUL = false;}
        if (Range <= LtofMin) {Range = LtofMin; RangeLL = true;} else {RangeLL = false;}
        // Serial.println(String(RangeRawF) + "," + String(Range) + ",0,1000"); // print range for serial monitor/plotter
        // Serial.println("Range = " + String(Range) + "mm");
        // Serial.println(String(Range) + "," + String(servoVal[0]) + "," + String(SteerAng));
        // Store the range at the current angle 30 - 150 == 0 - 40 in RangeData[]
        RangeDataDP = (getPanAngle() - 30)/3;
        RangeData[RangeDataDP] = Range;
        // extrapolate missing values from previous angle
        if (RangeDataDP > RangeDataDPL+1) {
          // there is a gap in the range data, going up the array, so fill in missing data
          // the value used is the intermediate value
          int16_t zDiff2 = (RangeData[RangeDataDP] - RangeData[RangeDataDPL])/2;
          for (int zP = RangeDataDPL+1;zP < RangeDataDP;zP++) {
            RangeData[zP] = RangeData[RangeDataDPL] + zDiff2;
          }
        } else if (RangeDataDP < RangeDataDPL-1) {
          // there is a gap in the range data, going down the array, so fill in missing data
          // the value used is the intermediate value
          int16_t zDiff2 = (RangeData[RangeDataDPL] - RangeData[RangeDataDP])/2;
          for (int zP = RangeDataDP+1;zP < RangeDataDPL;zP++) {
            RangeData[zP] = RangeData[RangeDataDP] + zDiff2;
          }
        } RangeDataDPL = RangeDataDP; // remember the latest array angle
        // calculate the intermeasurement period
        LTOFperiod = LTOFt1 - LTOFt0; LTOFt0 = LTOFt1;
        // calculate the fps frequency
        LTOFfps = 1000/LTOFperiod;
        VL53L1X_Task = 8; // look for another measurement
        if (LTOFcalc) {VL53L1X_Task = 9;}
        // else {Serial.println("0,330," + String(RangeRawF) + "," + String(Range));}
      } break;
    case 9: // speed calculation is enabled
      // due to noise on the sensor we cannot measure low speed values, and therefore
      // set s threshold of 10mm which is equivalent to 300mm/s minimum
      RangeDiff = abs(RangeRaw - RangeLast); // get the difference
      if (RangeDiff > 10) {
        // movement is > 10mm so calculate speed
        // we apply a peak detector, with 1 sec sustain window
        LTOFspd10 = (RangeDiff * 10)/LTOFperiod;
        if (LTOFspd10 > LTOFspd10L) {LTOFspd10L = LTOFspd10; LTOFspdCnt = 30;}
        else {LTOFspd10 = LTOFspd10L;}
      }
      if (LTOFspdCnt > 0) {
        LTOFspdCnt--;
        if (LTOFspdCnt < 1) {LTOFspd10 = 0; LTOFspd10L = 0;}
      }
      // Serial.println("0,1000," + String(Range) + "," + String(LTOFspd10));
      VL53L1X_Task = 8; // look for another measurement
      break;

    case 1: // switch on sensor
      digitalWrite(XSHUT_PIN,HIGH);  // enable VL53L1X sensor
      VL53L1X_Timer = micros(); 
      // Serial.println("VL53L1X XSHUT HIGH");
      VL53L1X_Task++; break;
    case 2: // check for boot, will time-out after 10ms if sensor does not respond
      // t0 = micros();
      if (VL53L1X.checkBootState()) {
        // t0 = micros() - t0;
        VL53L1X_Timer = micros() - VL53L1X_Timer;
        // Serial.println("VL53L1X.checkBootState() in " + String(t0) + "µs");
        // 825µs needed to boot the device from XSHUT going high
        // Serial.println("VL53L1X Booted! in " + String(VL53L1X_Timer) + "µs");
        VL53L1X_Task++;
      }
      else if (micros() >= (VL53L1X_Timer + 10000)) {VL53L1X_Task = 99;} // time-out
      break;
    case 3: // device booted, so initialise
      // t0 = micros();
      if (VL53L1X.init() == false) {
        // t0 = micros() - t0;
        // Serial.println("VL53L1X.init() in " + String(t0) + "µs"); // 151ms
        VL53L1X_Task++;
      } else {VL53L1X_Task = 99;} // failed to initialise, so turn sensor OFF
      break;
    case 4: // set the distance mode
      // t0 = micros();
      VL53L1X.setDistanceModeShort();         // Sets to 1.3M range
      // t0 = micros() - t0;
      // Serial.println("VL53L1X.setDistanceModeShort() in " + String(t0) + "µs");
      VL53L1X_Task++; break;
    case 5: // set the timing budget as 33ms
      // t0 = micros();
      VL53L1X.setTimingBudgetInMs(33);        // Set timing budget to 33 ms
      // t0 = micros() - t0;
      // Serial.println("VL53L1X.setTimingBudgetInMs(33) in " + String(t0) + "µs");
      VL53L1X_Task++; break;
    case 6: // set the distance mode
      // t0 = micros();
      VL53L1X.setIntermeasurementPeriod(33);  // Set measurement period in ms
      // t0 = micros() - t0;
      // Serial.println("VL53L1X.setIntermeasurementPeriod(33) in " + String(t0) + "µs");
      RangeEn = true; VL53L1X_Task++; break;
    case 7: // initiate ranging
      // t0 = micros();
      VL53L1X.startRanging();                 // 446µs Starts taking measurements
      // t0 = micros() - t0;
      // Serial.println("VL53L1X.startRanging() in " + String(t0) + "µs");
      // t1 = millis();
      VL53L1X_Skip = millis() + VL53L1X_SkipDel; // set the initial delay
      LTOFt0 = millis(); VL53L1X_Task++; break;  // task 8 is earlier in this code
      
    case 99: // a time-out has occured or we want to turn the sensor OFF
      digitalWrite(XSHUT_PIN,LOW);  // disable VL53L1X sensor
      // Serial.println("VL53L1X XSHUT LOW");
      RangeEn = false; VL53L1X_Task = 0; break;
  }
  IsrRun = IsrRunF;
}

// ---------------------------------------------------------------------------------



  //###############################################################################
  //
  //  WiFi Code
  //
  //###############################################################################

void WiFiClearRxBuff(int zNum) {
  // clears the contents of the receive buffer
  for (int zP = 0; zP < zNum;zP++) {Rx_Buff.ESPdata[zP] = 0;}
}

// --------------------------------------------------------------------------------

void WiFiClearTxBuff(int zNum) {
  // clears the contents of the transmit buffer
  for (int zP = 0; zP < zNum;zP++) {Tx_Buff.ESPdata[zP] = 0;}
}

// ---------------------------------------------------------------------------------

void WiFiDisable() {
  // when either a switch is pressed or WiFi disable is required
  WiFiEn = false; WiFiCntC = 0; WiFiRestCnt = 0; C_Dn = 8; Z_Dn = 8;
}

// --------------------------------------------------------------------------------

void WiFiDisconnect() {
  // enter the WiFi disconnected state
  WiFiConnected = false;
  WiFiClearRxBuff(WiFiTx_len);
  WiFiClearTxBuff(WiFiTx_len);
  WiFiTryCnt = 0;     // reset the connection retry counter
  WiFiTx_CB = 1;      // set ready to send flag
  WiFiRxRec = false;  // clear the data received flag
  // Serial.println("WiFiDisconnected!");
}

// --------------------------------------------------------------------------------

void WiFiTryToConnect() {
  // try to connect with the Wii Transceiver by sending devices name
  // initialise ESP-NOW link first
  Init_ESP_NOW();

  Tx_Buff.ESPdata[ 0] = 'T';
  Tx_Buff.ESPdata[ 1] = 'a';
  Tx_Buff.ESPdata[ 2] = 'n';
  Tx_Buff.ESPdata[ 3] = 'k';
  Tx_Buff.ESPdata[ 4] = 'B';
  Tx_Buff.ESPdata[ 5] = 'o';
  Tx_Buff.ESPdata[ 6] = 't';
  Tx_Buff.ESPdata[ 7] = ' ';
  Tx_Buff.ESPdata[ 8] = 'E';
  Tx_Buff.ESPdata[ 9] = 'S';
  Tx_Buff.ESPdata[10] = 'P';
  Tx_Buff.ESPdata[11] = '3';
  Tx_Buff.ESPdata[12] = '2';
  WiFiTx_len = 13;
  // t0 = micros();
  esp_err_t result = esp_now_send(broadcastAddress, (uint8_t *) &Tx_Buff, WiFiTx_len);
  if (result == ESP_OK) {
    // Serial.println("Sent with success");
  } else {
    // Serial.println("Error sending the data");
  } 

  WiFiTryNum++; // count the total number of attempts
  // Serial.println("WiFiTryToConnect...");
}

// --------------------------------------------------------------------------------

void WiFiTxGetChecksum(int zlen) {
  // performs an XOR checksum calc on the Tx buffer of length zlen
  WiFiTx_Chk = 0x55;  // define checksum seed as 01010101
  for (int zP = 0;zP < zlen;zP++) {
    WiFiTx_Chk = WiFiTx_Chk ^ Tx_Buff.ESPdata[zP];
  }
}

// ----------------------------------------------------------------------

int WiiRightStickX() {
  // returns a Wii Classic RX value 0/16/31
  return ((RxWiFi[0] & (byte)0xc0) >> 3) + ((RxWiFi[1] & (byte)0xc0) >> 5) +  ((RxWiFi[2] & (byte)0x80) >> 7);
}

// ----------------------------------------------------------------------

int WiiRightStickY() {
  // returns a Wii Classic RY value 0/16/31
  return RxWiFi[2] & (byte)0x1f;    
}

// ---------------------------------------------------------------------------------
