// ######################################################################
//
//  Robot Hand Release v0.1
//
//  Released:  09/03/2017
//
//  Author: TechKnowTone
//
// ######################################################################
/*
    This software is furnished "as is", without technical support, and
    with no warranty, expressed or implied, as to its usefulness for any
    purpose.

    Elements of this software were taken from the public domain. It uses
    libraries which must be installed on your system.

    This program moves a robot hand to demonstrate articulation using
    servo motors. The RESET switch is used in conjunction with EEPROM 
    memory to determine user selectable modes.

    Commands:
    !       - forces a 'soft' RESET
    ~       - link tick indicates Windows app isactive
    MMnn.   - set MoveMode to nn (1-3) and reset sequence
    MS.     - stop move modes
    SAnn.   - set servo angle in degrees 0 - 180
    SD.     - detach the active servo pin
    SLnn.   - set attached servo lower limit in microseconds
    SMnn.   - set servo angle in microseconds servoLL - servoUL
    SPnn.   - set the active servo pin number
    SUnn.   - set attached servo upper limit in microseconds

*/
// Declare objects
//#include <Adafruit_NeoPixel.h>
//#include "pitches.h"
#include <Servo.h>
#include <EEPROM.h>

// define labels and constants
#define LEDPin 13 // LED output pin
#define modeSwitch 10 //mode switch i/p assignment
#define tonePin 2 // audio pin assignment

// define arrays
//                Thmb Indx Midl Frth Lttl ---- ----
int servoMax[] = {1767,2088,2083,2035,1978,2000,2000};  // servo max pulse
int servoMin[] = { 994, 1057, 923, 808, 900, 400, 400};  // servo max pulse
int servoPins[] = {  2,   8,   5,   4,   6,   3,   7};  // servo output pins
int servoTrgt[7]; // target values for servos
int servoVal[7]; // value sent to servos
Servo servoMain; // define temp Servo case
Servo servoInst[7]; // define hand servos

// Declare and initialise global variables
int Angle;  // used by control app
char cmdMode; // command mode
int cmdRec; // > 0 if a '~' has been received
char cmdType; // command type
int cmdVal; // value associated with a cmdType
unsigned long interval; // main loop interval in microseconds
unsigned long intMaster; // main loop Master interval in microseconds
char keyChar; // any keyboard character
int keyVal; // any keyboard value
int Move; // move mode
int MoveCnt; // any counter used in a move sequence
int MoveLast; // last move before being stopped
int MoveMode; // 1 - 3, determines speed of movement
int moveTimeout; // timeout counter for move changes
int MoveSub; // move sub task mode, starts at 0
unsigned long nextMicros; // main loop interval in microseconds
int servoLL = 544; // servo min time setting
int servoPin;  // servo output pin
int servoUL = 2400; // servo max time setting
int TrgtAny; // > 0 if any target is reached
int TrgtFlag; // > 0 if target value reached in a move

void setup() {
  // put your setup code here, to run once:
  pinMode(LEDPin, OUTPUT);
  Serial.begin(19200); // high baud rate for sweeping functions
  runPOST();
  delay(1000);          // wait 1 second
}

void loop() {
  // put your main code here, to run repeatedly:
  keyVal = 0; while (keyVal != -1) {readKey();} // empty Rx buffer
  if (micros() >= nextMicros) {
    // run the move engine every 10ms
    nextMicros = micros() + interval;
    if (Move >= 0) {moveServos();}
  }
}

// ----------------------------------------------------------------------

