
// ----------------------------------------------------------------------

void moveServos() {
  // called from main loop every 10 ms
  switch (Move) {
    case 0:
      // random movement sequence
      moveDoRnd(); break;
    case 1:
      // go high, go low wave
      moveDoHiLo(); break;
    case 2:
      // random movement sequence
      moveDoRnd(); break;
    case 3:
      // go high, go low wave
      moveDoHiLoHi(); break;
    case 4:
      // random movement sequence
      moveDoRnd(); break;
    case 5:
      // go high, go low wave
      moveDoHLHLH(); break;
    case 99:
      // do nothing, waiting for timeout
      break;
  }
  // change move mode after timeout
  moveTimeout--;
  if (moveTimeout == 0) {
    // time to change move mode
    Move++; // do next move sequence
    if (Move > 99) {Move = 0; attachServos();} // reset Move after long wait
    if (Move > 5) {
      // restart cycle
      Move = 0;
      intMaster = (intMaster * 8)/10; // reduce by 20%
      if (MoveMode == 2) {intMaster = 10000;} // force slow speed
      if (MoveMode == 3) {intMaster = 3000;} // force quick speed
      if (intMaster < 2000) {
        // reached maximum speed for random movements so sleep
        intMaster = 10000; interval = intMaster;
        Move = 99; moveTimeout = 30000;
        setAllServosTo(0); delay(1500); detachServos();
      }
    }
    setMove(Move); MoveSub = 0;
  }
}

// ----------------------------------------------------------------------

void moveDoHiLo() {
  // go high, go low wave
  int zS;
  switch (MoveSub) {
    case 0:
      // set all targets to 0
      for (zS = 0; zS < 5; zS++) {servoTrgt[zS] = 0;}
      MoveSub = 1; break;
    case 1:
      // move all fingers
      TrgtAny = 0;
      for (zS = 0; zS < 5; zS++) {
        moveToTrgt(zS);
        if (TrgtFlag > 0) {TrgtAny++;}
      } if (TrgtAny > 4) {servoTrgt[0] = 180; MoveSub = 2;}
      break;
    case 2:
      // move thumb up
      moveToTrgt(0); if (TrgtFlag > 0) {servoTrgt[1] = 180; MoveSub++;}
      break;
    case 3:
      // move index up
      moveToTrgt(1); if (TrgtFlag > 0) {servoTrgt[2] = 180; MoveSub++;}
      break;
    case 4:
      // move middle up
      moveToTrgt(2); if (TrgtFlag > 0) {servoTrgt[3] = 180; MoveSub++;}
      break;
    case 5:
      // move fourth up
      moveToTrgt(3); if (TrgtFlag > 0) {servoTrgt[4] = 180; MoveSub++;}
      break;
    case 6:
      // move little up
      moveToTrgt(4); if (TrgtFlag > 0) {servoTrgt[0] = 0; MoveSub++;}
      break;
    case 7:
      // move thumb down
      moveToTrgt(0); if (TrgtFlag > 0) {servoTrgt[1] = 0; MoveSub++;}
      break;
    case 8:
      // move index down
      moveToTrgt(1); if (TrgtFlag > 0) {servoTrgt[2] = 0; MoveSub++;}
      break;
    case 9:
      // move middle down
      moveToTrgt(2); if (TrgtFlag > 0) {servoTrgt[3] = 0; MoveSub++;}
      break;
    case 10:
      // move fourth down
      moveToTrgt(3); if (TrgtFlag > 0) {servoTrgt[4] = 0; MoveSub++;}
      break;
    case 11:
      // move little down
      moveToTrgt(4); if (TrgtFlag > 0) {moveTimeout = 1;} // for move change
      break;
  }
}

// ----------------------------------------------------------------------

void moveDoHiLoHi() {
  // go high, go low little then Hi wave
  int zS;
  switch (MoveSub) {
    case 0:
      // set all targets to 180
      for (zS = 0; zS < 5; zS++) {servoTrgt[zS] = 180;}
      MoveSub++; break;
    case 1:
      // move all fingers
      TrgtAny = 0;
      for (zS = 0; zS < 5; zS++) {
        moveToTrgt(zS);
        if (TrgtFlag > 0) {TrgtAny++;}
      } if (TrgtAny > 4) {servoTrgt[4] = 0; MoveSub++;}
      break;
    case 2:
      // move little down
      moveToTrgt(4); if (TrgtFlag > 0) {servoTrgt[3] = 0; MoveSub++;}
      break;
    case 3:
      // move fourth down
      moveToTrgt(3); if (TrgtFlag > 0) {servoTrgt[2] = 0; MoveSub++;}
      break;
    case 4:
      // move middle down
      moveToTrgt(2); if (TrgtFlag > 0) {servoTrgt[1] = 0; MoveSub++;}
      break;
    case 5:
      // move index down
      moveToTrgt(1); if (TrgtFlag > 0) {servoTrgt[0] = 0; MoveSub++;}
      break;
    case 6:
      // move thumb down
      moveToTrgt(0); if (TrgtFlag > 0) {servoTrgt[0] = 180; MoveSub++;}
      break;
    case 7:
      // move thumb up
      moveToTrgt(0); if (TrgtFlag > 0) {servoTrgt[1] = 180; MoveSub++;}
      break;
    case 8:
      // move index up
      moveToTrgt(1); if (TrgtFlag > 0) {servoTrgt[2] = 180; MoveSub++;}
      break;
    case 9:
      // move middle up
      moveToTrgt(2); if (TrgtFlag > 0) {servoTrgt[3] = 180; MoveSub++;}
      break;
    case 10:
      // move fourth up
      moveToTrgt(3); if (TrgtFlag > 0) {servoTrgt[4] = 180; MoveSub++;}
      break;
    case 11:
      // move little up
      moveToTrgt(4); if (TrgtFlag > 0) {moveTimeout = 1;} // for move change
      break;
  }
}

// ----------------------------------------------------------------------

void moveDoHLHLH() {
  // go 3 high, 2 low, then swap several times
  int zS;
  switch (MoveSub) {
    case 0:
      // set all targets
      servoTrgt[0] = 170; servoTrgt[1] = 0; servoTrgt[2] = 180;
      servoTrgt[3] = 0; servoTrgt[4] = 180;
      MoveSub++; break;
    case 1:
      // move all fingers
      TrgtAny = 0;
      for (zS = 0; zS < 5; zS++) {
        moveToTrgt(zS);
        if (TrgtFlag > 0) {TrgtAny++;}
      } if (TrgtAny > 4) {servoTrgt[4] = 0; MoveSub++;}
      break;
    case 2:
      // set all targets
      servoTrgt[0] = 0; servoTrgt[1] = 180; servoTrgt[2] = 0;
      servoTrgt[3] = 180; servoTrgt[4] = 0;
      MoveSub++; break;
    case 3:
      // move all fingers
      TrgtAny = 0;
      for (zS = 0; zS < 5; zS++) {
        moveToTrgt(zS);
        if (TrgtFlag > 0) {TrgtAny++;}
      } if (TrgtAny > 4) {servoTrgt[4] = 0; MoveSub++;}
      break;
    case 4:
      // repeat?
      MoveCnt--;
      if (MoveCnt > 0) {MoveSub = 0;}
      else {moveTimeout = 1;} // for a move change
      break;
  }
}

// ----------------------------------------------------------------------

void moveDoRnd() {
  // random movement sequence
  for (int zS = 0; zS < 5; zS++) {
    moveToTrgt(zS);
    if (TrgtFlag > 0) {primeTrgtRnd(zS);}
  }
}

// ----------------------------------------------------------------------

void moveToTrgt(int zS) {
  // move a specified servo angle towards its target value
  TrgtFlag = 0; // set target reached flag to default
  if (servoTrgt[zS] > servoVal[zS]) {
    // target is greater so increment
    servoVal[zS]++; setServoTo(zS, servoVal[zS]);
  } else if (servoTrgt[zS] < servoVal[zS]) {
    // target is lower so decrement
    servoVal[zS]--; setServoTo(zS, servoVal[zS]);
  } else {
    // reached target so raise flag
    TrgtFlag = 1;
  }
}

// ----------------------------------------------------------------------

void setMove(int zM) {
  // set the initial conditions for a 'Move' function
  switch (zM) {
    case 0:
      // random movement sequence
      primeTargets(0); // set a range of random target values
      Move = zM; // set random move as default
      if (MoveMode == 3) {intMaster = 3000;} // force quick speed
      interval = intMaster;
      moveTimeout = 8000000/interval;
      break;
    case 1:
      // go high, go low wave
      Move = zM; // set move
      interval = 2000;
      if (MoveMode == 2) {interval = 8000;}
      moveTimeout = -1;
      break;
    case 2:
      // random movement sequence
      primeTargets(0); // set a range of random target values
      Move = zM; // set random move as default
      if (MoveMode == 3) {intMaster = 3000;} // force quick speed
      interval = intMaster;
      moveTimeout = 8000000/interval;
      break;
    case 3:
      // go high, go low wave
      Move = zM; // set move
      interval = 2000;
      if (MoveMode == 2) {interval = 8000;}
      moveTimeout = -1;
      break;
    case 4:
      // random movement sequence
      primeTargets(0); // set a range of random target values
      Move = zM; // set random move as default
      if (MoveMode == 3) {intMaster = 3000;} // force quick speed
      interval = intMaster;
      moveTimeout = 8000000/interval;
      break;
    case 5:
      // go high, go low wave
      Move = zM; // set move
      interval = 2000;
      if (MoveMode == 2) {interval = 8000;}
      moveTimeout = -1; MoveCnt = 5; // repeat 5 times
      break;
  }
}

// ----------------------------------------------------------------------


