
// ----------------------------------------------------------------------

void attachServos() {
  // create 7 servos and attach them to pins
  servoInst[0].attach(servoPins[0]);
  servoInst[1].attach(servoPins[1]);
  servoInst[2].attach(servoPins[2]);
  servoInst[3].attach(servoPins[3]);
  servoInst[4].attach(servoPins[4]);
//  servoInst[0].attach(servoPins[0],servoMin[0],servoMax[0]);
//  servoInst[1].attach(servoPins[1],servoMin[1],servoMax[1]);
//  servoInst[2].attach(servoPins[2],servoMin[2],servoMax[2]);
//  servoInst[3].attach(servoPins[3],servoMin[3],servoMax[3]);
//  servoInst[4].attach(servoPins[4],servoMin[4],servoMax[4]);
  //servoInst[5].attach(servoPins[5],servoMin[5],servoMax[5]);
  //servoInst[6].attach(servoPins[6],servoMin[6],servoMax[6]);
  
}

// ----------------------------------------------------------------------

void detachServos() {
  // detach all servos
  servoInst[0].detach();
  servoInst[1].detach();
  servoInst[2].detach();
  servoInst[3].detach();
  servoInst[4].detach();
  //servoInst[5].detach();
  //servoInst[6].detach();
}

// ----------------------------------------------------------------------

void doCmd() {
  // a '.' has been received so execute command if valid
  int zPrint = 1;
  switch (cmdMode) {
    case ' ': break;
    case 'M':
      switch (cmdType) {
        case 'M':
          MoveMode = 0; intMaster = 10000; // deafult speed
          switch (cmdVal) {
            case 2:
              // slow speed
              MoveMode = 2; break;
            case 3:
              // quick speed  
              MoveMode = 3; break;
          }
          setMove(0); break;
        case 'S':
          if (Move == -1) {
            Move = MoveLast;
          } else {
            MoveLast = Move; Move = -1;
          } break;
      }
      break;
    case 'S':
      switch (cmdType) {
        case ' ': break;
        case 'A':
          Angle = cmdVal; servoMain.write(Angle);
          // report the angle in microseconds
          Serial.print("SM=");
          Serial.print(servoMain.readMicroseconds());
          Serial.println("."); zPrint = 0;
          break;
        case 'D': servoPin = -1; servoMain.detach(); break;
        case 'L':
          servoLL = cmdVal;
          if (servoPin > -1) {
            servoMain.detach();
            servoMain.attach(servoPin,servoLL,servoUL);
          } break;
        case 'M':
          Angle = cmdVal; servoMain.writeMicroseconds(Angle);
          // report the angle in degrees
          Serial.print("SA=");
          Serial.print(servoMain.read());
          Serial.println("."); zPrint = 0;
          break;
        case 'P':
          servoMain.detach();
          servoPin = cmdVal; servoMain.attach(servoPin,servoLL,servoUL);
          break;
        case 'U':
          servoUL = cmdVal;
          if (servoPin > -1) {
            servoMain.detach();
            servoMain.attach(servoPin,servoLL,servoUL);
          } break;
      } break;
  }
  if (zPrint > 0) {
    // is not a reporting function, echo the received command
    Serial.print(cmdMode); Serial.print(cmdType); Serial.print(cmdVal); Serial.println('.');
  }
  // now reset the variables
  cmdMode = ' '; cmdType = ' '; cmdVal = 0;
}

// ----------------------------------------------------------------------

void emptySerial() {
  // empty the serial input buffer
  keyVal = 0;
  while (keyVal != -1) {
    keyVal = Serial.read();
  }
}

// ----------------------------------------------------------------------

void extendCmdVal(int zVal) {
  // adds a new digit to the right-hand end of cmdVal
  cmdVal = (cmdVal * 10) + zVal;  
}

// ----------------------------------------------------------------------

void primeTargets(int zM) {
  // set target values for all servos
  int zS;
  switch (zM) {
    case 0:
      // set random target values
      for (zS = 0; zS < 5; zS++) {
        servoTrgt[zS] = random(181);
      }
  }
}

// ----------------------------------------------------------------------

void primeTrgtRnd(int zS) {
  // generate a random target value for a given servo
  servoTrgt[zS] = random(181);
}

// ----------------------------------------------------------------------

void readKey() {
  // reads a key from the keyboard annd reacts accordingly
  keyVal = Serial.read();
  if (keyVal != -1) {
    keyChar = char(keyVal); cmdRec = 1; // value received
//      Serial.print("keyVal=");
//      Serial.print(keyChar);
//      Serial.print("   ASCII=");
//      Serial.println(keyVal);
    int zNF = 0;
    switch (keyChar) {
      case '.': doCmd(); zNF = 1; break;
      case '!': runPOST(); zNF = 1; break;
      case '~': zNF = 1; break; // null tick received
      case '0': extendCmdVal(0); zNF = 1; break;
      case '1': extendCmdVal(1); zNF = 1; break;
      case '2': extendCmdVal(2); zNF = 1; break;
      case '3': extendCmdVal(3); zNF = 1; break;
      case '4': extendCmdVal(4); zNF = 1; break;
      case '5': extendCmdVal(5); zNF = 1; break;
      case '6': extendCmdVal(6); zNF = 1; break;
      case '7': extendCmdVal(7); zNF = 1; break;
      case '8': extendCmdVal(8); zNF = 1; break;
      case '9': extendCmdVal(9); zNF = 1; break;
    }
    if (zNF == 0) {
      if (cmdMode == ' ') {
        // test for new Command Mode char?
        switch (keyChar) {
          case 'm': cmdMode = 'M'; break;
          case 'M': cmdMode = 'M'; break;
          case 's': cmdMode = 'S'; break;
          case 'S': cmdMode = 'S'; break;
        } cmdType = ' '; cmdVal = 0;
      } else {
        // test for Command Type char?
        switch (keyChar) {
          case 'a': cmdType = 'A'; break;
          case 'A': cmdType = 'A'; break;
          case 'd': cmdType = 'D'; break;
          case 'D': cmdType = 'D'; break;
          case 'l': cmdType = 'L'; break;
          case 'L': cmdType = 'L'; break;
          case 'm': cmdType = 'M'; break;
          case 'M': cmdType = 'M'; break;
          case 'p': cmdType = 'P'; break;
          case 'P': cmdType = 'P'; break;
          case 's': cmdType = 'S'; break;
          case 'S': cmdType = 'S'; break;
          case 'u': cmdType = 'U'; break;
          case 'U': cmdType = 'U'; break;
        }
      }
    }
  }
}

// ----------------------------------------------------------------------

void RESET() {
  // perform a soft RESET
  servoMain.detach();
  detachServos();
  setDefaults();
}

// ----------------------------------------------------------------------

void runPOST() {
  // run once POST routines
  Serial.print("\n\n\n\n\n\n\n\n\n\n");
  Serial.println("Robot Hand v0.04");
  Serial.println("Starting POST...");
  RESET();
  emptySerial();
  Serial.println("Zeroing Servos...");
  attachServos(); setAllServosTo(0); // clasp fingers
  Serial.println("Pause 2s before RESET test...");
  digitalWrite(LEDPin, HIGH); delay(2000);
  testResetState(); // read EEPROM and count RESETs
  testCtrlApp(); // see if connected to Windows app?
  if (cmdRec < 1) {
    // no serial link so enter a demo mode
    for (int zA = 0; zA < 181; zA++) {
      setAllServosTo(zA); delay(5);
    }
    // read the move mode then reset it to zero
    MoveMode = EEPROM.read(3); EEPROM.update(3, 0);
    Serial.print("Demo mode "); Serial.print(MoveMode);
    Serial.println(" initiated!");
    if (MoveMode < 4) {
      setMove(0); // start in Move = 0
      Serial.println("Demo mode initiated!");
      delay(2000);
    } else {
      // user wants unit to be in standby
      setAllServosTo(0); delay(1500); // move to centre position
      detachServos(); Move = -1;
    }
  } else {
    // connected to Windows app
    setAllServosTo(90); delay(1500); // move to centre position
    detachServos(); Move = -1;
  }
  Serial.println("POST complete!");
}

// ----------------------------------------------------------------------

void  setAllServosTo(long zA) {
  // set all servos to 'A' degrees by converting to microseconds
  long zM;
  zM = servoMin[0]+(((servoMax[0] - servoMin[0])*zA)/180);
  servoInst[0].writeMicroseconds(zM); servoVal[0] = zA;
  zM = servoMin[1]+(((servoMax[1] - servoMin[1])*zA)/180);
  servoInst[1].writeMicroseconds(zM); servoVal[1] = zA;
  zM = servoMin[2]+(((servoMax[2] - servoMin[2])*zA)/180);
  servoInst[2].writeMicroseconds(zM); servoVal[2] = zA;
  zM = servoMin[3]+(((servoMax[3] - servoMin[3])*zA)/180);
  servoInst[3].writeMicroseconds(zM); servoVal[3] = zA;
  zM = servoMin[4]+(((servoMax[4] - servoMin[4])*zA)/180);
  servoInst[4].writeMicroseconds(zM); servoVal[4] = zA;
}

// ----------------------------------------------------------------------

void setDefaults() {
  // load default values
  Angle  = 90;  // start with servo in the centre pos
  cmdMode = ' '; // command mode
  cmdRec = 0; // > 0 if a '~' has been received
  cmdType = ' '; // command type
  cmdVal = 0; // value associated with a cmdType
  interval = 10000; // main loop interval in microseconds
  intMaster = 10000; // main loop Master interval in microseconds
  keyVal = -1; // any keyboard value
  Move = -1; // move mode default = -1, OFF
  MoveLast = -1; // last move before being stopped
  MoveMode = 1; // 1 - 3, determines speed of movement
  MoveSub = 0; // move sub task mode, starts at 0
  moveTimeout = 500; // timeout counter for move changes
  nextMicros = micros() + interval; // main loop interval in microseconds
  servoPin = -1;  // servo output pin is undefined
  TrgtFlag = 0; // > 0 if target value reached in a move
}

// ----------------------------------------------------------------------

void  setServoTo(int zS,long zA) {
  // set servo zS to 'A' degrees by converting to microseconds
  long zM;
  zM = servoMin[zS]+(((servoMax[zS] - servoMin[zS])*zA)/180);
  servoInst[zS].writeMicroseconds(zM); servoVal[zS] = zA;
}

// ----------------------------------------------------------------------

void testCtrlApp() {
  // listens to serial port for '.' command to set initial mode
  for (int zL = 10; zL > 0; zL--) { 
    readKey();
    delay(100);
  }
}

// ----------------------------------------------------------------------

void testResetState() {
  // check EEPROM and count RESETs
  byte zV0,zV1,zV2; // EEPROM read values 
  zV0 = EEPROM.read(0); zV1 = EEPROM.read(1); zV2 = EEPROM.read(2);
  if ((zV0 != 85) || (zV1 != 170) || (zV2 != 15)) {
      // failed 3 byte test so rewrite values
      Serial.println("Initialising EEPROM...");
      EEPROM.update(0, 85);
      EEPROM.update(1, 170);
      EEPROM.update(2, 15);
      EEPROM.update(3, 0); // reset 'mode' value to zero
  }  else {
    // EEPROM contnets is assumed valid
    zV0 = EEPROM.read(3) + 1; // increment 'mode' count
    EEPROM.update(3, zV0);
    Serial.print("Mode = "); Serial.println(zV0);
  }
  // now wait in case of another RESET button press
  for (zV0 = 0; zV0 < 15; zV0++) {
    digitalWrite(LEDPin, HIGH); delay(100);
    digitalWrite(LEDPin, LOW); delay(100);
  }
  // if we return after this then no further RESETs have occured
}

// ----------------------------------------------------------------------


