/************************************************************************
 Public Constants
************************************************************************/

//      Command        Code      Cnt  Description
#define cmdClap0        19    // [2]  clap n times ending closed
#define cmdClap1        20    // [2]  clap n times ending open
#define cmdEnd          -1    // [1]  end of command sequence, power off after 2 seconds
#define cmdEndOn        -2    // [1]  end of command sequence, leave power ON
#define cmdFor          12    // [2]  start of For[n]..Loop, can't be nested
#define cmdGoV0         16    // [2]  go to V0 - rotation, others constant
#define cmdGoV1         17    // [2]  go to V1 - forward arm, others constant
#define cmdGoV2         18    // [2]  go to V2 - vertical arm, others constant
#define cmdGoTo         0     // [4]  goto a specific location, moving grippers
#define cmdGoNG         8     // [3]  goto a specific location, not moving grippers
#define cmdGoPos        21    // [2]  goto a previously stored location RFV
#define cmdGoPosRnd     23    // [3]  goto a random n-m previously stored location FRV
#define cmdGosub_A      120   // [1]  store next line number before branching to line after Label_A
#define cmdGosub_B      121   // [1]  store next line number before branching to line after Label_A
#define cmdGosub_C      122   // [1]  store next line number before branching to line after Label_A
#define cmdGosub_D      123   // [1]  store next line number before branching to line after Label_A
#define cmdGosub_E      124   // [1]  store next line number before branching to line after Label_A
#define cmdGosub_F      125   // [1]  store next line number before branching to line after Label_A
#define cmdGosub_G      126   // [1]  store next line number before branching to line after Label_A
#define cmdGosub_H      127   // [1]  store next line number before branching to line after Label_A
#define cmdGosub_I      128   // [1]  store next line number before branching to line after Label_A
#define cmdGosub_J      129   // [1]  store next line number before branching to line after Label_A
#define cmdGrip         6     // [1]  close the grippers
#define cmdHome         11    // [1]  goto the home position
#define cmdJumpTo_A     110   // [1]  branch move play to line after Label_A
#define cmdJumpTo_B     111   // [1]  branch move play to line after Label_B
#define cmdJumpTo_C     112   // [1]  branch move play to line after Label_C
#define cmdJumpTo_D     113   // [1]  branch move play to line after Label_D
#define cmdJumpTo_E     114   // [1]  branch move play to line after Label_A
#define cmdJumpTo_F     115   // [1]  branch move play to line after Label_B
#define cmdJumpTo_G     116   // [1]  branch move play to line after Label_C
#define cmdJumpTo_H     117   // [1]  branch move play to line after Label_D
#define cmdJumpTo_I     118   // [1]  branch move play to line after Label_A
#define cmdJumpTo_J     119   // [1]  branch move play to line after Label_B
#define cmdLabel_A     -100   // [1]  a label pointer in move play sequence
#define cmdLabel_B     -101   // [1]  a label pointer in move play sequence
#define cmdLabel_C     -102   // [1]  a label pointer in move play sequence
#define cmdLabel_D     -103   // [1]  a label pointer in move play sequence
#define cmdLabel_E     -104   // [1]  a label pointer in move play sequence
#define cmdLabel_F     -105   // [1]  a label pointer in move play sequence
#define cmdLabel_G     -106   // [1]  a label pointer in move play sequence
#define cmdLabel_H     -107   // [1]  a label pointer in move play sequence
#define cmdLabel_I     -108   // [1]  a label pointer in move play sequence
#define cmdLabel_J     -109   // [1]  a label pointer in move play sequence
#define cmdNext         13    // [1]  closes a For...Next loop
#define cmdOpen         7     // [1]  open the grippers to gripOpen
#define cmdPop          9     // [1]  pop 3 target value from temp memory
#define cmdPush         10    // [1]  push 3 target value into temp memory
#define cmdReplay       1     // [1]  restart the command sequence from the beginning
#define cmdReset        22    // [1]  goto the RESET position
#define cmdReturn       25    // [1]  return to line store in Gosub call
#define cmdSet0         2     // [2]  set servo[0] to a value
#define cmdSet1         3     // [2]  set servo[1] to a value
#define cmdSet2         4     // [2]  set servo[2] to a value
#define cmdSet3         5     // [2]  set servo[3] to a value
#define cmdSetPause     26    // [2]  set the after move delay, in loop cycles
#define cmdSetPos       27    // [2]  go immediately to a previously stored location RFV
#define cmdSetSpeed     15    // [2]  set the lood delay, default = 10000 (10ms)
#define cmdSleep        14    // [1]  turn off servo motors
#define cmdWaitRnd      98    // [3]  wait for a random number of cycles
#define cmdWait         99    // [2]  wait for a specified number of cycles
#define cmdWide         24    // [1]  open the grippers to gripWide

// last cmd was 27

