
// ----------------------------------------------------------------------

void moveEngine() {
  // main move engine rountines
  int zAny; // temp variable
  int zContinue = 1; // temp continuation flag, run by default
  switch (moveTask) {
    case 0:
      // read a command from the array and act accordingly
      moveLast = movePnt; // record current pointer
      if (moveRun > -1) {
        // in single step mode
        if (moveRun > 0) {moveRun--;
        } else {
          // stop reading commands
          zContinue = 0;
          if (moveRpt > 0) {moveRpt = 0; reportValues();}
        }
      }
      if (zContinue == 1) {
        // run as normal interpreting next command
        moveCmd = moves[movePnt];
        switch (moveCmd) {
          case cmdClap0:
            // initiate clapping n times ending closed
            moveCnt = moves[movePnt + 1]; moveSubTask = 0;
            movePnt = movePnt + 2; moveTask = 3; moveInc = 0; break;
          case cmdClap1:
            // initiate clapping n times ending open
            moveCnt = moves[movePnt + 1]; moveSubTask = 0;
            movePnt = movePnt + 2; moveTask = 3; moveInc = 1; break;
          case cmdEnd:
            // end of move commands so switch off engine, power-OFF after 2 seconds
            movePnt = -1; PWR_timeout = 200; break;
          case cmdEndOn:
            // end of move commands so switch off engine, but leave power ON
            movePnt = -1; PWR_timeout = 0; break;
          case cmdFor:
            // record pointer and count for For...Loop
            moveForLp = moves[movePnt + 1];
            movePnt = movePnt + 2; moveForPnt = movePnt; break;
          case cmdGoNG:
            // load the target values and initiate a move without claw
            if (servoEn < 1) {attachServos(0);}
            servoTgt[0] = moves[movePnt + 1];
            servoTgt[1] = moves[movePnt + 2];
            servoTgt[2] = moves[movePnt + 3];
            movePnt = movePnt + 4; moveCnt = 50;
            moveTask = 2; break;
          case cmdGoPos:
            // move to a previously stored location, without claw movement
            zAny = moves[movePnt + 1];
            servoTgt[0] = movePosR[zAny];
            servoTgt[1] = movePosF[zAny];
            servoTgt[2] = movePosV[zAny];
            movePnt = movePnt + 2; moveCnt = 50;
            moveTask = 2; break;
          case cmdGoPosRnd:
            // move to a random n-m inclusive previously stored location
            // without claw movement
            zAny = random(moves[movePnt + 1], 1 + moves[movePnt + 2]);
            servoTgt[0] = movePosR[zAny];
            servoTgt[1] = movePosF[zAny];
            servoTgt[2] = movePosV[zAny];
            movePnt = movePnt + 3; moveCnt = 50;
            moveTask = 2; break;
          case cmdGosub_A:
            // branch to Label pointer, having first stored return address
            moveReturn = movePnt + 1; movePnt = moveLabels[0]; break;
          case cmdGosub_B:
            // branch to Label pointer, having first stored return address
            moveReturn = movePnt + 1; movePnt = moveLabels[1]; break;
          case cmdGosub_C:
            // branch to Label pointer, having first stored return address
            moveReturn = movePnt + 1; movePnt = moveLabels[2]; break;
          case cmdGosub_D:
            // branch to Label pointer, having first stored return address
            moveReturn = movePnt + 1; movePnt = moveLabels[3]; break;
          case cmdGosub_E:
            // branch to Label pointer, having first stored return address
            moveReturn = movePnt + 1; movePnt = moveLabels[4]; break;
          case cmdGosub_F:
            // branch to Label pointer, having first stored return address
            moveReturn = movePnt + 1; movePnt = moveLabels[5]; break;
          case cmdGosub_G:
            // branch to Label pointer, having first stored return address
            moveReturn = movePnt + 1; movePnt = moveLabels[6]; break;
          case cmdGosub_H:
            // branch to Label pointer, having first stored return address
            moveReturn = movePnt + 1; movePnt = moveLabels[7]; break;
          case cmdGosub_I:
            // branch to Label pointer, having first stored return address
            moveReturn = movePnt + 1; movePnt = moveLabels[8]; break;
          case cmdGosub_J:
            // branch to Label pointer, having first stored return address
            moveReturn = movePnt + 1; movePnt = moveLabels[9]; break;
          case cmdGoTo:
            // load the target values and initiate a move with claw
            if (servoAtt < 1) {attachServos(0);}
            servoTgt[0] = moves[movePnt + 1];
            servoTgt[1] = moves[movePnt + 2];
            servoTgt[2] = moves[movePnt + 3];
            servoTgt[3] = moves[movePnt + 4];
            movePnt = movePnt + 5; moveCnt = 50;
            moveTask = 1; break;
          case cmdGoV0:
            // load the target value into V0 and initiate a move
            // claw value is not affected
            if (servoAtt < 1) {attachServos(0);}
            servoTgt[0] = moves[movePnt + 1];
            servoTgt[1] = servoVal[1];
            servoTgt[2] = servoVal[2];
            movePnt = movePnt + 2; moveCnt = 50;
            moveTask = 2; break;
          case cmdGoV1:
            // load the target value into V1 and initiate a move
            // claw value is not affected
            if (servoAtt < 1) {attachServos(0);}
            servoTgt[0] = servoVal[0];
            servoTgt[1] = moves[movePnt + 1];
            servoTgt[2] = servoVal[2];
            movePnt = movePnt + 2; moveCnt = 50;
            moveTask = 2; break;
          case cmdGoV2:
            // load the target value into V2 and initiate a move
            // claw value is not affected
            if (servoAtt < 1) {attachServos(0);}
            servoTgt[0] = servoVal[0];
            servoTgt[1] = servoVal[1];
            servoTgt[2] = moves[movePnt + 1];
            movePnt = movePnt + 2; moveCnt = 50;
            moveTask = 2; break;
          case cmdGrip:
            // close the grippers
            if (servoAtt < 1) {attachServos(0);}
            servoVal[3] = gripClose;  movePnt++;
            servoInst[3].writeMicroseconds(servoVal[3]);
            Serial.print(F("SV3=")); Serial.println(servoVal[3]);
            if (movePause > 0) {moveWait = movePause; moveTask = 99;}
            break;
          case cmdHome:
            // move to the Home position
            if (servoAtt < 1) {attachServos(0);}
            servoTgt[0] = Home0; servoTgt[1] = Home1;
            servoTgt[2] = Home2; servoTgt[3] = Home3; 
            movePnt++; moveCnt = 50; moveTask = 1; break;
          case cmdJumpTo_A:
            // branch to Label_A pointer
            movePnt = moveLabels[0]; break;
          case cmdJumpTo_B:
            // branch to Label_A pointer
            movePnt = moveLabels[1]; break;
          case cmdJumpTo_C:
            // branch to Label_A pointer
            movePnt = moveLabels[2]; break;
          case cmdJumpTo_D:
            // branch to Label_A pointer
            movePnt = moveLabels[3]; break;
          case cmdJumpTo_E:
            // branch to Label_A pointer
            movePnt = moveLabels[4]; break;
          case cmdJumpTo_F:
            // branch to Label_A pointer
            movePnt = moveLabels[5]; break;
          case cmdJumpTo_G:
            // branch to Label_A pointer
            movePnt = moveLabels[6]; break;
          case cmdJumpTo_H:
            // branch to Label_A pointer
            movePnt = moveLabels[7]; break;
          case cmdJumpTo_I:
            // branch to Label_A pointer
            movePnt = moveLabels[8]; break;
          case cmdJumpTo_J:
            // branch to Label_A pointer
            movePnt = moveLabels[9]; break;
          case cmdLabel_A:
            // store a dynamic label pointer
            moveLabels[0] = movePnt + 1; movePnt++; break;
          case cmdLabel_B:
            // store a dynamic label pointer
            moveLabels[1] = movePnt + 1; movePnt++; break;
          case cmdLabel_C:
            // store a dynamic label pointer
            moveLabels[2] = movePnt + 1; movePnt++; break;
          case cmdLabel_D:
            // store a dynamic label pointer
            moveLabels[3] = movePnt + 1; movePnt++; break;
          case cmdLabel_E:
            // store a dynamic label pointer
            moveLabels[4] = movePnt + 1; movePnt++; break;
          case cmdLabel_F:
            // store a dynamic label pointer
            moveLabels[5] = movePnt + 1; movePnt++; break;
          case cmdLabel_G:
            // store a dynamic label pointer
            moveLabels[6] = movePnt + 1; movePnt++; break;
          case cmdLabel_H:
            // store a dynamic label pointer
            moveLabels[7] = movePnt + 1; movePnt++; break;
          case cmdLabel_I:
            // store a dynamic label pointer
            moveLabels[8] = movePnt + 1; movePnt++; break;
          case cmdLabel_J:
            // store a dynamic label pointer
            moveLabels[9] = movePnt + 1; movePnt++; break;
          case cmdNext:
            // if count not expired repeat For...Next loop
            moveForLp--; movePnt++;
            if (moveForLp > 0) {movePnt = moveForPnt;}
            break;
          case cmdOpen:
            // open the grippers
            if (servoAtt < 1) {attachServos(0);}
            servoVal[3] = gripOpen; movePnt++;
            servoInst[3].writeMicroseconds(servoVal[3]);
            Serial.print(F("SV3=")); Serial.println(servoVal[3]);
            if (movePause > 0) {moveWait = movePause; moveTask = 99;}
            break;
          case cmdPop:
            // move to remembered position
            servoTgt[0] = moveMem0; servoTgt[1] = moveMem1;
            servoTgt[2] = moveMem2; movePnt++; moveCnt = 50;
            moveTask = 2; break;
          case cmdPush:
            // remember current position
            moveMem0 = servoVal[0]; moveMem1 = servoVal[1];
            moveMem2 = servoVal[2]; movePnt++; break;
          case cmdReplay:
            // replay the sequence from the beginning
            movePnt = 0; break;
          case cmdReset:
            // move to the RESET position
            if (servoAtt < 1) {attachServos(0);}
            servoTgt[0] = Reset0; servoTgt[1] = Reset1;
            servoTgt[2] = Reset2; servoTgt[3] = Reset3; 
            movePnt++; moveCnt = 50; moveTask = 1; break;
          case cmdReturn:
            // return program control to a previously store line
            movePnt = moveReturn; break;
          case cmdSet0:
            // set a servo 0 value immediately
            if (servoAtt < 1) {attachServos(0);}
            servoVal[0] = moves[movePnt + 1];
            servoInst[0].writeMicroseconds(servoVal[0] + servoOff0);
            Serial.print(F("SV0=")); Serial.println(servoVal[0]);
            movePnt = movePnt + 2; break;
          case cmdSet1:
            // set a servo 1 value immediately
            if (servoAtt < 1) {attachServos(0);}
            servoVal[1] = moves[movePnt + 1];
            servoInst[1].writeMicroseconds(servoVal[1]);
            Serial.print(F("SV1=")); Serial.println(servoVal[1]);
            movePnt = movePnt + 2; break;
          case cmdSet2:
            // set a servo 2 value immediately
            if (servoAtt < 1) {attachServos(0);}
            servoVal[2] = moves[movePnt + 1];
            setVertMinMax(); // ensure vertical channel is within limits
            servoInst[2].writeMicroseconds(servoVal[2]);
            Serial.print(F("SV2=")); Serial.println(servoVal[2]);
            movePnt = movePnt + 2; break;
          case cmdSet3:
            // set a servo 3 value immediately
            if (servoAtt < 1) {attachServos(0);}
            servoVal[3] = moves[movePnt + 1];
            servoInst[3].writeMicroseconds(servoVal[3]);
            Serial.print(F("SV3=")); Serial.println(servoVal[3]);
            movePnt = movePnt + 2; break;
          case cmdSetPause:
            // set the delay after each move, default = 0
            movePause = moves[movePnt + 1]; movePnt = movePnt + 2; break;
          case cmdSetPos:
            // load servo values from a previously stored location
            if (servoAtt < 1) {attachServos(0);}
            zAny = moves[movePnt + 1];
            servoVal[0] = movePosR[zAny];
            servoInst[0].writeMicroseconds(servoVal[0] + servoOff0);
            Serial.print(F("SV0=")); Serial.println(servoVal[0]);
            servoVal[1] = movePosF[zAny];
            servoInst[1].writeMicroseconds(servoVal[1]);
            Serial.print(F("SV1=")); Serial.println(servoVal[1]);
            servoVal[2] = movePosV[zAny];
            setVertMinMax(); // ensure vertical channel is within limits
            servoInst[2].writeMicroseconds(servoVal[2]);
            Serial.print(F("SV2=")); Serial.println(servoVal[2]);
            movePnt = movePnt + 2; break;
          case cmdSetSpeed:
            // change the move loop period, default = 10000 (10ms)
            // max value is 32,767 as cmd array are intgers
            moveInterval = moves[movePnt + 1];
            movePnt = movePnt + 2; break;
          case cmdSleep:
            // turn off servo motors
            detachServos(); movePnt++; break;
          case cmdWait:
            // load the waiting time and start a wait task
            moveWait = moves[movePnt + 1];
            if (moveInterval != moveDefInterval) {
              // loop speed has changed so set delay count accordingly
              moveWait = (moveWait * moveDefInterval)/moveInterval;
            }
            movePnt = movePnt + 2; moveTask = 99; break;
          case cmdWaitRnd:
            // wait for a random number of loops
            moveWait = random(moves[movePnt + 1],moves[movePnt + 2]);
            movePnt = movePnt + 3; moveTask = 99;
            break;
          case cmdWide:
            // open the grippers
            if (servoAtt < 1) {attachServos(0);}
            servoVal[3] = gripWide; movePnt++;
            servoInst[3].writeMicroseconds(servoVal[3]);
            Serial.print(F("SV3=")); Serial.println(servoVal[3]);
            if (movePause > 0) {moveWait = movePause; moveTask = 99;}
            break;
        } break;
   
      
      case 1:
        // move towards target values, whilst moving grippers
        if (servoEn < 1) {attachServos(0);}
        if (moveCnt > 1) {
          for (int zP = 0; zP < 4; zP++) {
            moveInc = (servoTgt[zP] - servoVal[zP])/moveCnt;
            if (zP > 0) {
              servoVal[zP] = servoVal[zP] + moveInc;
            } else {
              // rotate 50% quicker
              moveInc = (moveInc * 3) / 2;
              servoVal[zP] = servoVal[zP] + moveInc;
            }
          }
        } else {
          // moveCnt = 1 so move to target values
          servoVal[0] = servoTgt[0]; servoVal[1] = servoTgt[1];
          servoVal[2] = servoTgt[2]; servoVal[3] = servoTgt[3];
        }
        if (servoVal[0] != servoTgt[0]) {incOffset = 10;}
        servoInst[0].writeMicroseconds(servoVal[0] + servoOff0);
        Serial.print(F("SV0=")); Serial.println(servoVal[0]);
        servoInst[1].writeMicroseconds(servoVal[1]);
        Serial.print(F("SV1=")); Serial.println(servoVal[1]);
        setVertMinMax(); // ensure vertical channel is within limits
        servoInst[2].writeMicroseconds(servoVal[2]);
        Serial.print(F("SV2=")); Serial.println(servoVal[2]);
        servoInst[3].writeMicroseconds(servoVal[3]);
        Serial.print(F("SV3=")); Serial.println(servoVal[3]);
        moveCnt--; if (moveCnt < 1) {
          moveTask = 0; if (movePause > 0) {moveWait = movePause; moveTask = 99;}
        } break;

      case 2:
        // move towards target values, whilst not moving grippers
        if (servoEn < 1) {attachServos(0);}
        if (moveCnt > 1) {
          for (int zP = 0; zP < 3; zP++) {
            moveInc = (servoTgt[zP] - servoVal[zP])/moveCnt;
            if (zP > 0) {
              servoVal[zP] = servoVal[zP] + moveInc;
            } else {
              // rotate 50% quicker
              moveInc = (moveInc * 3) / 2;
              servoVal[zP] = servoVal[zP] + moveInc;
            }
          }
        } else {
          // moveCnt = 1 so move to target values
          servoVal[0] = servoTgt[0]; servoVal[1] = servoTgt[1];
          servoVal[2] = servoTgt[2];
        }
        if (servoVal[0] != servoTgt[0]) {incOffset = 10;}
        servoInst[0].writeMicroseconds(servoVal[0] + servoOff0);
        Serial.print(F("SV0=")); Serial.println(servoVal[0]);
        servoInst[1].writeMicroseconds(servoVal[1]);
        Serial.print(F("SV1=")); Serial.println(servoVal[1]);
        setVertMinMax(); // ensure vertical channel is within limits
        servoInst[2].writeMicroseconds(servoVal[2]);
        Serial.print(F("SV2=")); Serial.println(servoVal[2]);
        moveCnt--; if (moveCnt < 1) {
          moveTask = 0; if (movePause > 0) {moveWait = movePause; moveTask = 99;}
        } break;

      case 3:
        // perform clapping actions
        if (servoEn < 1) {attachServos(0);}
        switch (moveSubTask) {
          case 0:
            // move jaw gripper
            if (moveInc < 1) {servoVal[3] = gripOpen;}
            else {servoVal[3] = gripClose;}
            servoInst[3].writeMicroseconds(servoVal[3]);
            moveWait = 10; moveSubTask++; break;
          case 1:
            // wait for 90ms
            moveWait--; if (moveWait < 1) {moveSubTask++;}
            break;
          case 2:
            // move jaw gripper and test for last time?
            if (moveInc < 1) {servoVal[3] = gripClose;}
            else {servoVal[3] = gripOpen;}
            servoInst[3].writeMicroseconds(servoVal[3]);
            Serial.print(F("SV3=")); Serial.println(servoVal[3]);
            moveCnt--; if (moveCnt > 0) {
              moveWait = 10; moveSubTask++;
            } else {
                moveTask = 0; if (movePause > 0) {moveWait = movePause; moveTask = 99;}
            } break;
          case 3:
            // wait for 90ms
            moveWait--; if (moveWait < 1) {moveSubTask = 0;}
            break;
        } break;

      case 99:
        // wait for a predefined number of cycles
        moveWait--; if (moveWait < 1) {
          // end of timeout so set task to read next command
          moveTask = 0;
        } break;
    }
  }
}

// ----------------------------------------------------------------------

void moveInit() {
  // called before loading and running the Move Engine
  // Initialises all variables to correct default state
  movePnt = 0; // reset the move pointer
  movePause = 0; // zero delay between moves as default
  moveReturn = moveArraySize -1; // store last line as default return line

  // clear the move array
  for (anyVal = 0; anyVal < moveArraySize; anyVal++) {moves[anyVal] = cmdEnd;}
  
  // clear the position arrays
  for (anyVal = 0; anyVal < posMax; anyVal++) {
    movePosR[anyVal] = Home0; movePosF[anyVal] = Home1; movePosV[anyVal] = Home2;}
}

// ----------------------------------------------------------------------

void moveLoad1(int zCmd) {
  // loads one value into the move engine array and increments pointer
  moves[movePnt] = zCmd; movePnt++;  moves[movePnt] = cmdEnd;
}

// ----------------------------------------------------------------------

void moveLoad2(int zCmd, int zV0) {
  // loads two values into the move engine array and increments pointer
  moves[movePnt] = zCmd; movePnt++;
  moves[movePnt] = zV0; movePnt++; moves[movePnt] = cmdEnd;
}

// ----------------------------------------------------------------------

void moveLoad3(int zCmd, int zV0, int zV1) {
  // loads three values into the move engine array and increments pointer
  moves[movePnt] = zCmd; movePnt++;
  moves[movePnt] = zV0; movePnt++;
  moves[movePnt] = zV1; movePnt++; moves[movePnt] = cmdEnd;
}

// ----------------------------------------------------------------------

void moveLoad4(int zCmd, int zV0, int zV1, int zV2) {
  // loads four values into the move engine array and increments pointer
  moves[movePnt] = zCmd; movePnt++;
  moves[movePnt] = zV0; movePnt++;
  moves[movePnt] = zV1; movePnt++;
  moves[movePnt] = zV2; movePnt++; moves[movePnt] = cmdEnd;
}

// ----------------------------------------------------------------------

void moveLoad5(int zCmd, int zV0, int zV1, int zV2, int zV3) {
  // loads five values into the move engine array and increments pointer
  moves[movePnt] = zCmd; movePnt++;
  moves[movePnt] = zV0; movePnt++;
  moves[movePnt] = zV1; movePnt++;
  moves[movePnt] = zV2; movePnt++;
  moves[movePnt] = zV3; movePnt++; moves[movePnt] = cmdEnd;
}

// ----------------------------------------------------------------------

void moveLoadPosRFV (int zA, int zV0, int zV1, int zV2) {
  // load servo co-ordinates into storage array
  movePosR[zA] = zV0; movePosF[zA] = zV1;  movePosV[zA] = zV2;
}

// ----------------------------------------------------------------------

void moveStart() {
  // initiates playing a move command sequence if valid
  if (moves[0] != cmdEnd) {
    // set initial conditions for move engine
    moveInterval = 10000; // default speed 10 ms loop
    movePnt = 0; moveRun = -1; moveTask = 0; attachServos(10);
    // search for labels and store them for forward branch jumps/gosubs
    for (anyVal = 0; anyVal < moveArraySize; anyVal++) {
      anyAny = moves[anyVal];
      // look for -ve values -100 to -109
      if ((anyAny <= cmdLabel_A) && (anyAny >= cmdLabel_J)) {
        moveLabels[cmdLabel_A - anyAny] = anyVal + 1; // store next line number
      }
    }
  } else {
    // move cmd array does not look valid so stop engine
    movePnt = -1;
  }
}

// ----------------------------------------------------------------------

void moveToHome() {
  // move immediately to the HOME position
  movePnt = -1; // switch of move engine
  servoVal[0] = Home0; servoVal[1] = Home1;
  servoVal[2] = Home2; servoVal[3] = Home3;
  attachServos(100); delay(200); // note servos remain attached
}

// ----------------------------------------------------------------------

void moveToResetPos() {
  // move immediately to the RESET position
  movePnt = -1; // switch of move engine
  servoVal[0] = Reset0; servoVal[1] = Reset1;
  servoVal[2] = Reset2; servoVal[3] = Reset3;
  attachServos(100); // note servos turn OFF automatically
}

// ----------------------------------------------------------------------

void moveToTest00 () {
  // a move to test sequence with....
  Serial.println(F("Loading moveToTest00..."));
  moveInit(); // always Initialise Move Engine before loading arrays!
  
  // load target positions
  moveLoadPosRFV(0, Home0-403, Home1+731, Home2-835); // loading bay, backed off
  moveLoadPosRFV(1, Home0, Home1, Home2); // TBD
  
  // load move sequence
  moveLoad1(cmdHome); // start at home position
  moveLoad2(cmdGoPos, 0); // loading bay, backed off

  moveLoad2(cmdClap1, 5); // clap 5 times to get attention!
  moveLoad2(cmdWait, 450); // wait for 5 seconds to load object
  moveLoad1(cmdGrip); // close jaws to collect object

  moveLoad1(cmdHome); // start at home position
  moveLoad1(cmdReset); // goto reset position

  // report the amount of program space used
  Serial.print(F("Loaded ")); Serial.print(movePnt);
  Serial.print(F(" commands. ")); Serial.print((movePnt * 100)/moveArraySize);
  Serial.print(F("% Max total = ")); Serial.println(moveArraySize);
}

// ----------------------------------------------------------------------


