
// ----------------------------------------------------------------------

void attachServos(int zDel) {
  // create 4 servos and attach them to pins
  // delay used during power-up reset, otherwiswe set to 0
  servoAtt = 1; // flag servos are attached
  servoInst[0].attach(servoPins[0]);
  servoInst[0].writeMicroseconds(servoVal[0] + servoOff0);
  delay(zDel);
  servoInst[1].attach(servoPins[1]);
  servoInst[1].writeMicroseconds(servoVal[1]);
  delay(zDel);
  if (Calibrated) {setVertMinMax();} // ensure vertical channel is within limits
  servoInst[2].attach(servoPins[2]);
  servoInst[2].writeMicroseconds(servoVal[2]);
  delay(zDel);
  servoInst[3].attach(servoPins[3]);
  servoInst[3].writeMicroseconds(servoVal[3]);
}

// ----------------------------------------------------------------------

void decMoveOffset() {
  // called every cycle to reduce servo 0 offset to zero
  if (servoOffMax != 0) {
    // a thermal offset has been defined by the user
    if (servoOff0 != 0) {
      servoOffDec--;
      if (servoOffDec < 1) {
        servoOffDec = servoOffDecT;
        if (servoOffMax > 0) {servoOff0--;} // increment offset towards zero
        else {servoOff0++;} // increment offset towards zero
//        Serial.print(F("Offset = ")); Serial.println(servoOff0);
      }
    }
  }
}

// ----------------------------------------------------------------------

void detachServos() {
  // detach all servos
  servoAtt = 0; // flag servos are detached
  servoInst[0].detach();
  servoInst[1].detach();
  servoInst[2].detach();
  servoInst[3].detach();
}

// ----------------------------------------------------------------------

void incMoveOffset() {
  // called when servo[0] is being driven, to change an offset
  incOffset--; // reduce this flag so that auto-decrement can occur
  servoOffDec = servoOffDecT; // keep decrement counter at max
  if (servoOffMax != 0) {
    // a thermal offset has been defined by the user
    if (servoOff0 != servoOffMax) {
      servoOffInc++; 
      if (servoOffInc > servoOffIncT) {
        servoOffInc = 0;
        if (servoOffMax > 0) {servoOff0++;} // increment offset towards the maximum offset value
        else {servoOff0--;} // deccrement offset towards the maximum -ve offset value
//        Serial.print(F("Offset = ")); Serial.println(servoOff0);
      }
    }
  }
}

// ----------------------------------------------------------------------

void keyBdArmBck() {
  // keyboard move arm backward received 
  PWR_timeout = 3000; // preset timer for auto servo power removal
  if (servoVal[1] > servoMin[1]) {
    if (servoAtt < 1) {attachServos(0); movePnt = -1;}
    servoVal[1] = servoVal[1] - incS1; incS1++; incS1 = min(incS1, 24); 
    servoVal[1] = max(servoMin[1], servoVal[1]);
    servoInst[1].writeMicroseconds(servoVal[1]);
    if (Calibrated) {
      setVertMinMax(); servoInst[2].writeMicroseconds(servoVal[2]);
      Serial.print(F("SV2=")); Serial.println(servoVal[2]);
    } 
    servoInst[1].writeMicroseconds(servoVal[1]);
    Serial.print(F("SV1=")); Serial.println(servoVal[1]);
  } keyPnt = 1;
}

// ----------------------------------------------------------------------

void keyBdArmFwd() {
  // keyboard move arm forward received 
  PWR_timeout = 3000; // preset timer for auto servo power removal
  if (servoVal[1] < servoMax[1]) {
    if (servoAtt < 1) {attachServos(0); movePnt = -1;}
    servoVal[1] = servoVal[1] + incS1; incS1++; incS1 = min(incS1, 24); 
    servoVal[1] = min(servoMax[1], servoVal[1]);
    servoInst[1].writeMicroseconds(servoVal[1]);
    if (Calibrated) {
      setVertMinMax(); servoInst[2].writeMicroseconds(servoVal[2]);
      Serial.print(F("SV2=")); Serial.println(servoVal[2]);
    } 
    servoInst[1].writeMicroseconds(servoVal[1]);
    Serial.print(F("SV1=")); Serial.println(servoVal[1]);
  } keyPnt = 1;
}

// ----------------------------------------------------------------------

void keyBdDither() {
  // dither the last value to see if it is central
  if (keyPnt >= 0) {
    // previous key demand has occured
    Serial.println(F("KZ = Dither"));
    moveInc = 5;
    for (int zP = 0; zP < 20; zP++) {
      servoInst[keyPnt].writeMicroseconds(servoVal[keyPnt] + moveInc);
      Serial.print(F("KZ = ")); Serial.println(servoVal[keyPnt] + moveInc);
      delay(250);
      servoInst[keyPnt].writeMicroseconds(servoVal[keyPnt]);
      Serial.print(F("KZ = ")); Serial.println(servoVal[keyPnt]);
      delay(250);
      servoInst[keyPnt].writeMicroseconds(servoVal[keyPnt] - moveInc);
      Serial.print(F("KZ = ")); Serial.println(servoVal[keyPnt] - moveInc);
      delay(250);
      servoInst[keyPnt].writeMicroseconds(servoVal[keyPnt]);
      Serial.print(F("KZ = ")); Serial.println(servoVal[keyPnt]);
      delay(250); moveInc++;
    }
  }
}

// ----------------------------------------------------------------------

void keyBdJawClose() {
  // keyboard close jaws received 
  PWR_timeout = 3000; // preset timer for auto servo power removal
  if (servoVal[3] > servoMin[3]) {
    if (servoAtt < 1) {attachServos(0); movePnt = -1;}
    servoVal[3] = servoVal[3] - incS3; incS3 = incS3 + 2; incS3 = min(incS3, 48); 
    servoVal[3] = max(servoMin[3], servoVal[3]);
    servoInst[3].writeMicroseconds(servoVal[3]);
    Serial.print(F("SV3=")); Serial.println(servoVal[3]);
  } keyPnt = 3;
}

// ----------------------------------------------------------------------

void keyBdJawOpen() {
  // keyboard open jaws received 
  PWR_timeout = 3000; // preset timer for auto servo power removal
  if (servoVal[3] < servoMax[3]) {
    if (servoAtt < 1) {attachServos(0); movePnt = -1;}
    servoVal[3] = servoVal[3] + incS3; incS3 = incS3 + 2; incS3 = min(incS3, 48); 
    servoVal[3] = min(servoMax[3], servoVal[3]);
    servoInst[3].writeMicroseconds(servoVal[3]);
    Serial.print(F("SV3=")); Serial.println(servoVal[3]);
  } keyPnt = 3;
}

// ----------------------------------------------------------------------

void keyBdTurnLeft() {
  // keyboard left received
  PWR_timeout = 3000; // preset timer for auto servo power removal
  if (servoVal[0] < servoMax[0]) {
    if (servoAtt < 1) {attachServos(0); movePnt = -1;}
    incOffset = 10; // turn demand so increment thermal offset counter
    servoVal[0] = servoVal[0] + incS0; incS0++; incS0 = min(incS0, 24); 
    servoVal[0] = min(servoMax[0], servoVal[0]);
    servoInst[0].writeMicroseconds(servoVal[0] + servoOff0);
    Serial.print(F("SV0=")); Serial.println(servoVal[0]);
  } keyPnt = 0;
}

// ----------------------------------------------------------------------

void keyBdTurnRight() {
  // keyboard right received  
  PWR_timeout = 3000; // preset timer for auto servo power removal
  if (servoVal[0] > servoMin[0]) {
    if (servoAtt < 1) {attachServos(0); movePnt = -1;}
    incOffset = 10; // turn demand so increment thermal offset counter
    servoVal[0] = servoVal[0] - incS0; incS0++; incS0 = min(incS0, 24); 
    servoVal[0] = max(servoMin[0], servoVal[0]);
    servoInst[0].writeMicroseconds(servoVal[0] + servoOff0);
    Serial.print(F("SV0=")); Serial.println(servoVal[0]);
  } keyPnt = 0;
}

// ----------------------------------------------------------------------

void keyBdVertDwn() {
  // keyboard move head up
  if (Calibrated) {setVertMinMax();} // ensure limits are correct with respect to arm position
  PWR_timeout = 3000; // preset timer for auto servo power removal
  if (servoVal[2] < servoMax[2]) {
    if (servoAtt < 1) {attachServos(0); movePnt = -1;}
    servoVal[2] = servoVal[2] + incS2; incS2++; incS2 = min(incS2, 24); 
    servoVal[2] = min(servoMax[2], servoVal[2]);
    servoInst[2].writeMicroseconds(servoVal[2]);
    Serial.print(F("SV2=")); Serial.println(servoVal[2]);
  } keyPnt = 2;
}

// ----------------------------------------------------------------------

void keyBdVertUp() {
  // keyboard move head down
  if (Calibrated) {setVertMinMax();} // ensure limits are correct with respect to arm position
  PWR_timeout = 3000; // preset timer for auto servo power removal
  if (servoVal[2] > servoMin[2]) {
    if (servoAtt < 1) {attachServos(0); movePnt = -1;}
    servoVal[2] = servoVal[2] - incS2; incS2++; incS2 = min(incS2, 24); 
    servoVal[2] = max(servoMin[2], servoVal[2]);
    servoInst[2].writeMicroseconds(servoVal[2]);
    Serial.print(F("SV2=")); Serial.println(servoVal[2]);
  } keyPnt = 2;
}

// ----------------------------------------------------------------------

void reportEachValue() {
  // called to report indiviual servo values over USB
  Serial.print(F("SV0=")); Serial.println(servoVal[0]);
  Serial.print(F("SV1=")); Serial.println(servoVal[1]);
  Serial.print(F("SV2=")); Serial.println(servoVal[2]);
  Serial.print(F("SV3=")); Serial.println(servoVal[3]);
}

// ----------------------------------------------------------------------

void reportHomeValues() {
  // called to report indiviual HomeN values over USB
  Serial.print(F("H0=")); Serial.println(Home0);
  Serial.print(F("H1=")); Serial.println(Home1);
  Serial.print(F("H2=")); Serial.println(Home2);
  Serial.print(F("H3=")); Serial.println(Home3);
}

// ----------------------------------------------------------------------

void reportMoveData() {
  // called to report servo value offsets relative to Home over USB
  Serial.print(F("moveLoadPosRFV(0, Home0"));
  anyVal =servoVal[0] - Home0;
  if (anyVal > 0) {Serial.print(F("+"));}
  if (anyVal != 0) {Serial.print(anyVal);}
  Serial.print(F(", Home1"));
  anyVal =servoVal[1] - Home1;
  if (anyVal > 0) {Serial.print(F("+"));}
  if (anyVal != 0) {Serial.print(anyVal);}
  Serial.print(F(", Home2"));
  anyVal =servoVal[2] - Home2;
  if (anyVal > 0) {Serial.print(F("+"));}
  if (anyVal != 0) {Serial.print(anyVal);}
  Serial.println(F("); // "));
}

// ----------------------------------------------------------------------

void reportOffsets() {
  // called to report servo value offsets relative to Home over USB
  Serial.print(F("SH0= ")); Serial.print(servoVal[0] - Home0); Serial.print(", ");
  Serial.print(F("SH1= ")); Serial.print(servoVal[1] - Home1); Serial.print(", ");
  Serial.print(F("SH2= ")); Serial.print(servoVal[2] - Home2); Serial.print(", ");
  Serial.print(F("SH3= ")); Serial.print(servoVal[3] - Home3); Serial.print("\n");
}

// ----------------------------------------------------------------------

void reportValues() {
  // called to report servo values over USB
  Serial.print(F("S0=")); Serial.print(servoVal[0]); Serial.print(", ");
  Serial.print(F("S1=")); Serial.print(servoVal[1]); Serial.print(", ");
  Serial.print(F("S2=")); Serial.print(servoVal[2]); Serial.print(", ");
  Serial.print(F("S3=")); Serial.print(servoVal[3]); Serial.print("\n");
}

// ----------------------------------------------------------------------

void setDefaults() {
  // load default values, at start and after a RESET
  Angle  = 90;  // start with servo in the centre pos
  cmdMode = ' '; // command mode
  cmdRec = 0; // > 0 if a '~' or any data has been received
  cmdType = ' '; // command type
  cmdVal = 0; // value associated with a cmdType
  incOffset = 0; // > 0 flag which controls thermal offset increments
  interval = 10000; // main loop interval in microseconds
  PWR_timeout = 0; // disables servos after a time-out, when no code received
  keyPnt = -1; // pointer to last servo affected by keyboard demand
  keyVal = -1; // any keyboard value
  moveInterval = moveDefInterval; // move engine interval nominally 10ms
  moveLast = -1; // previous movePnt value
  moveMicros = micros() + moveInterval; // move engine interval timer in microseconds
  movePnt = -1; // movement array pointer, default is -1
  for (int zP; zP < posMax; zP++) {
    moveLoadPosRFV(zP, Home0, Home1, Home2);
  }
  // calculate thermal offset counter values
  servoOffDecT = 0;
  if (servoOffMax != 0) {
    // a thermal offset has been defined so calculate timer values
    servoOffIncT = servoOffRmpUp / (10 * abs(servoOffMax));
    servoOffDecT = servoOffRmpDwn / (10 * abs(servoOffMax));
  }
  
  moveTask = 0; // main task pointer in movement engineges
  nextMicros = micros() + interval; // main loop interval in microseconds
  servoNum = 0; // target servo number 0 - 3 for setting LL/UL limits, default = 0
  servoOff0 = 0; // offset for servo 0
  servoOffDec = 10000; // offset decrement counter
  servoOffInc = 0; // offset increment counter
  servoPin = -1;  // servo output pin is undefined
  servoCtr[0] = Reset0;
  servoCtr[1] = Reset1;
  servoCtr[2] = Reset2;
  servoCtr[3] = Reset3;
  servoMax[0] = turntableMax;
  servoMax[1] = fwdArmMax;
  servoMax[2] = vertArmMaxB,gripWide;
  servoMax[3] = gripWide;
  servoMin[0] = turntableMin;
  servoMin[1] = fwdArmMin;
  servoMin[2] = vertArmMinA;
  servoMin[3] = gripClose;
  servoTrg[0] = 0;
  servoTrg[1] = 0;
  servoTrg[2] = 0;
  servoTrg[3] = 0;
  servoVal[0] = Reset0;
  servoVal[1] = Reset1;
  servoVal[2] = Reset2;
  servoVal[3] = Reset3;
}

// ----------------------------------------------------------------------

void setVertMinMax() {
  // sets the min/max limits for the vertical arm based on the 
  // angular position of the forward arm
  long zVal;
  if (servoVal[1] > fwdArmVert) {
    // determine max limit in forward leaning posture
    zVal = servoVal[1] - fwdArmVert;
    zVal = zVal * (vertArmMaxB - vertArmMaxA);
    zVal = zVal/(servoMax[1] - fwdArmVert);
    servoMax[2] = vertArmMaxB - zVal;
    // determine min limit
    zVal = servoVal[1] - fwdArmVert;
    zVal = zVal * (vertArmMinB - vertArmMinA);
    zVal = zVal/(servoMax[1] - fwdArmVert);
    servoMin[2] = vertArmMinB - zVal;
  } else {
    servoMax[2] = vertArmMaxB; // this is abs max figure for vertical arm
    // determine min limit
    zVal = servoVal[1] - servoMin[1];
    zVal = zVal * (vertArmMinC - vertArmMinB);
    zVal = zVal/(fwdArmVert - servoMin[1]);
    servoMin[2] = vertArmMinC - zVal;
  }
  // force value to be within limits
  servoVal[2] = max(servoVal[2],servoMin[2]);
  servoVal[2] = min(servoVal[2],servoMax[2]);
}

// ----------------------------------------------------------------------

void testCtrlApp() {
  // listens to serial port for '~' command to set initial mode
  // test waits for 1 second
  for (int zL = 100; zL > 0; zL--) { 
    readKey();
    delay(10);
  }
}

// ----------------------------------------------------------------------

void testResetState() {
  // check EEPROM and count RESETs
  byte zV0,zV1,zV2; // EEPROM read values 
  zV0 = EEPROM.read(0); zV1 = EEPROM.read(1); zV2 = EEPROM.read(2);
  if ((zV0 != 85) || (zV1 != 170) || (zV2 != 15)) {
      // failed 3 byte test so rewrite values
      Serial.println(F("Initialising EEPROM..."));
      EEPROM.update(0, 85);
      EEPROM.update(1, 170);
      EEPROM.update(2, 15);
      EEPROM.update(3, 0); // reset 'mode' value to zero
  }  else {
    // EEPROM contnets is assumed valid
    zV0 = EEPROM.read(3) + 1; // increment 'mode' count
    EEPROM.update(3, zV0);
    Serial.print(F("Mode = ")); Serial.println(zV0);
  }
  // now wait in case of another RESET button press
  // flash LED whilst waiting
  for (zV0 = 0; zV0 < 15; zV0++) {
    digitalWrite(LEDPin, HIGH); delay(100);
    digitalWrite(LEDPin, LOW); delay(100);
  }
  // if we return after this then no further RESETs have occured
}

// ----------------------------------------------------------------------

void translateIR_Samsung_0111(int zCode) {
  // takes action based on IR code received
  // describing Samsung 0111 Remote IR codes 
//  Serial.print(results.value, HEX);  // print raw values
  if (cmdRec > 0) {return;}
  zCode = zCode & 0xFF;
  switch(zCode) {
    case 0x01:
      // " 1"
      setDefaults(); attachServos(100); delay(200); detachServos();
      delay(1000); MasterMode = 2; moveToTest00 (); moveStart();
      break;
    case 0x02:
      // " 2"
      setDefaults(); attachServos(100); delay(200); detachServos();
      delay(1000); MasterMode = 2; moveToTest00 (); movePause = 20; moveStart();
      break;
//    case 0x03: Serial.println(" 3"); break;
//    case 0x04: Serial.println(" 4"); break;
//    case 0x05: Serial.println(" 5"); break;
//    case 0x06: Serial.println(" 6"); break;
//    case 0x07: Serial.println(" 7"); break;
//    case 0x08: Serial.println(" 8"); break;
//    case 0x09: Serial.println(" 9"); break;
    case 0x0C:
      // perform a soft RESET
      runPOST(); break; // PWR button
//    case 0x0D: Serial.println(" MUTE"); break;
//    case 0x0E: Serial.println(" PLAY"); break;
    case 0x10:
      // Turn to the left
      keyBdTurnLeft(); break; // V+ button
    case 0x11:
      // Turn to the right
      keyBdTurnRight(); break; // V- button
    case 0x12:
      // Move vertical arm up which lowers the robot head
      keyBdVertUp(); break; // MENU button
    case 0x1C:
      // Move arm forward
      keyBdArmFwd(); break; // P+ button
    case 0x1D:
      // Move arm backward
      keyBdArmBck(); break; // P- button
//    case 0x1F: Serial.println(" PAUSE"); break;
    case 0x20:
      // Close jaws
      keyBdJawClose(); break; // UP button
    case 0x21:
      // Open jaws
      keyBdJawOpen(); break; // DOWN button
//    case 0x23: Serial.println(" <<"); break;
//    case 0x24: Serial.println(" REC"); break;
    case 0x26:
      // Move vertical arm down which raises the robot head
      keyBdVertDwn(); break; // SLEEP button
//    case 0x27: Serial.println(" SUB-T"); break;
//    case 0x2C: Serial.println(" =?"); break;
//    case 0x2D: Serial.println(" =X"); break;
//    case 0x36: Serial.println(" STOP"); break;
    case 0x3B:
      // Report current servo values
      reportValues(); break; // OK button
  }
}

// ----------------------------------------------------------------------

void translateIR_Samsung_0111_PWR(int zCode) {
  // Look only for PWR reset IR code and reset if pressed
  if (cmdRec > 0) {return;}
  zCode = zCode & 0xFF;
  if (zCode == 0x0C) {
      // perform a soft RESET
      runPOST(); // PWR button
  }
}

// ----------------------------------------------------------------------

