
// ----------------------------------------------------------------------

void AddToAngles(int zA1,int zA2,int zA3,int zA4,int zA5,int zA6,int zA7,int zA8, int zCnt) {
  // Add a +/-90 angle to the current servo angles, or 0 means no change.
  // Number of 20ms steps in movement set by zCnt
  if (ESC) return; // exit if this flag is set
  if (!servoEn) {attachServos(0);}
  if (zA1 != 0) {anyVal = map(zA1,0,90,Ang1_45,Ang1_135); servoTgt[0] = servoVal[0] + anyVal;}
  if (zA2 != 0) {anyVal = map(zA1,0,90,Ang1_45,Ang1_135); servoTgt[1] = servoVal[1] + anyVal;}
  if (zA3 != 0) {anyVal = map(zA1,0,90,Ang1_45,Ang1_135); servoTgt[2] = servoVal[2] + anyVal;}
  if (zA4 != 0) {anyVal = map(zA1,0,90,Ang1_45,Ang1_135); servoTgt[3] = servoVal[3] + anyVal;}
  if (zA5 != 0) {anyVal = map(zA1,0,90,Ang1_45,Ang1_135); servoTgt[4] = servoVal[4] + anyVal;}
  if (zA6 != 0) {anyVal = map(zA1,0,90,Ang1_45,Ang1_135); servoTgt[5] = servoVal[5] + anyVal;}
  if (zA7 != 0) {anyVal = map(zA1,0,90,Ang1_45,Ang1_135); servoTgt[6] = servoVal[6] + anyVal;}
  if (zA8 != 0) {anyVal = map(zA1,0,90,Ang1_45,Ang1_135); servoTgt[7] = servoVal[7] + anyVal;}
  checkTgts(); // ensure target values are within limits
  tgtCnt = zCnt;
//  Serial.println(F("AddToAngles Set"));
}

// ----------------------------------------------------------------------

void DemoMove_Bow() {
  // Bow movement used to introduce demo move.
  IrEn = false; SetLedMode(1);
  GoToAngles(45,120,45,120,90,90,90,90,50); loopWhiletgtCnt();
  GoToAngles(90,173,90,173,-1,-1,-1,-1,60); loopWhiletgtCnt();
  delayLoop(1000); // pause
  GoToAngles(45,120,45,120,-1,-1,-1,-1,30); loopWhiletgtCnt();
  GoToAngles(90,90,90,90,-1,-1,-1,-1,30); loopWhiletgtCnt();
  SetLedMode(0); IrEn = IrEnM;
}

// ----------------------------------------------------------------------

void DemoMove_PressUps() {
  // Do five pressups, then return to standing position.
  IrEn = false; SetLedMode(1); anyFor = 120;
  GoToAngles(135,90,135,90,45,160,45,160,20); loopWhiletgtCnt();
  delayLoop(1000); // pause
  while (anyFor < 130) {
    GoToAngles(-1,anyFor,-1,anyFor,-1,-1,-1,-1,20); loopWhiletgtCnt();
    delayLoop(100); // pause
    GoToAngles(-1,90,-1,90,-1,-1,-1,-1,20); loopWhiletgtCnt();
    delayLoop(100); anyFor += 2; // pause
  }
  GoToStand(25); loopWhiletgtCnt();
  SetLedMode(0); IrEn = IrEnM;
}

// ----------------------------------------------------------------------

void DemoMove_SitNWave() {
  // Sit and wave the right hand twice.
  IrEn = false; SetLedMode(1);
  GoToAngles(90,90,90,90,145,145,145,145,50); loopWhiletgtCnt();
  LedMode = 0; delayLoop(1000); // pause
  LedMode = 1; GoToAngles(90,90,80,160,145,145,145,145,20); loopWhiletgtCnt();
  LedMode = 0; delayLoop(200); SetLedMode(4); // pause
  for (anyFor=0; anyFor<2; anyFor++) {
    GoToAngles(90,90,60,180,145,145,145,145,3); loopWhiletgtCnt();
    GoToAngles(90,90,40,150,145,145,145,145,3); loopWhiletgtCnt();
    delayLoop(100); // pause
    GoToAngles(90,90,60,180,145,145,145,145,3); loopWhiletgtCnt();
    GoToAngles(90,90,80,150,145,145,145,145,3); loopWhiletgtCnt();
    delayLoop(100); // pause
  }
  LedMode = 0; delayLoop(1000); // pause
  SetLedMode(3); GoToAngles(90,90,90,90,145,145,145,145,50); loopWhiletgtCnt();
  LedMode = 0; delayLoop(1000); // pause
  SetLedMode(3);GoToStand(50); loopWhiletgtCnt();
  LedMode = 0; IrEn = IrEnM;}

// ----------------------------------------------------------------------

void DemoMove_TurnRight(int zAng,int zStep1,int zStep2,int zSpeed) {
  // Performs a demo turn to the right, then returns at twice the speed.
  IrEn = false; SetLedMode(2);
  TurnRight(zAng,zStep1,zSpeed); loopWhiletgtCnt();
  LedMode = 0; delayLoop(100 + random(900)); // pause
  SetLedMode(4); TurnLeft(zAng,zStep2,zSpeed/2); loopWhiletgtCnt();
  LedMode = 0; IrEn = IrEnM;
}

// ----------------------------------------------------------------------

void DemoMove_TurnLeft(int zAng,int zStep1,int zStep2,int zSpeed) {
  // Performs a demo turn to the left, then returns at twice the speed.
  IrEn = false; SetLedMode(4);
  TurnLeft(zAng,zStep1,zSpeed); loopWhiletgtCnt();
  LedMode = 0; delayLoop(100 + random(900)); // pause
  SetLedMode(2); TurnRight(zAng,zStep2,zSpeed/2); loopWhiletgtCnt();
  LedMode = 0; IrEn = IrEnM;
}

// ----------------------------------------------------------------------

void DemoMove_Twist() {
  // Twist side to side, with increasing speed.
  IrEn = false; SetLedMode(1); anyFor = 60;
  GoToAngles(135,90,45,90,135,90,45,90,50); loopWhiletgtCnt();
  while (anyFor >= 10) {
    SetLedMode(2); GoToAngles(45,-1,135,-1,45,-1,135,-1,anyFor); loopWhiletgtCnt();
    delayLoop(100); anyFor -= 5; // pause
    SetLedMode(4); GoToAngles(135,90,45,90,135,90,45,90,anyFor); loopWhiletgtCnt();
    delayLoop(100); anyFor -= 5; // pause
  }
  SetLedMode(2); GoToAngles(45,-1,135,-1,45,-1,135,-1,20); loopWhiletgtCnt();
  delayLoop(100); // pause
  SetLedMode(4); GoToAngles(135,90,45,90,135,90,45,90,35); loopWhiletgtCnt();
  delayLoop(100);// pause
  SetLedMode(1); GoToAngles(90,-1,90,-1,90,-1,90,-1,25); loopWhiletgtCnt();
  LedMode = 0; IrEn = IrEnM;
}

// ----------------------------------------------------------------------

void DemoMove_Walk(int zWalk, int zSteps, int zSpeed) {
  // Perform a demo walk in direction zWalk (1-4), returning at twice the speed.
  // If zWalk is -ve don't do the returning part.
  // Note there are 88 steps in a walk cycle.
  // zSpeed is the period, normally 20000, suggest 5000(fast) - 60000(slow) range.
  IrEn = false; SetLedMode(zWalk);
  walkInterval = zSpeed; StartWalk(abs(zWalk)); // initiate the walk
  loopWhileWalk(zSteps); Walk = 0; // wait then stop
  LedMode = 0; delayLoop(100);// pause
  if (zWalk > 0) {
    // Now reverse the direction.
    switch (zWalk) {
      case 1: zWalk = 3; break;
      case 2: zWalk = 4; break;
      case 3: zWalk = 1; break;
      case 4: zWalk = 2; break;
    } walkInterval = zSpeed/2; StartWalk(zWalk);
     SetLedMode(zWalk); loopWhileWalk(zSteps); Walk = 0; 
  } walkInterval = 20000; // set speed at default
  LedMode = 0; IrEn = IrEnM;
}

// ----------------------------------------------------------------------

void dodgeHand() {
  // User hand has been detected by the ultrasonic sensor.
  // THis is enabled in MainTask == 2.
  IrEn = false; SetLedMode(2);
  GoToFloor(20); loopWhiletgtCnt(); // Quickly drop to the floor.
  anyMilli = millis();
  // Now raise/lower rear legs frantically, up to a maximum period.
  while ((distance >= 310) && (distance <= 900)) { // wait for hand to be removed
    for (anyFor = 0; anyFor < 5; anyFor++) {
      GoToAngles(-1,-1,-1,-1,-1,190,-1,-1,4); loopWhiletgtCnt(); // raise rear right leg
      GoToAngles(-1,-1,-1,-1,-1,150,-1,-1,3); loopWhiletgtCnt(); // lower rear right leg
      GoToAngles(-1,-1,-1,-1,-1,-1,-1,190,4); loopWhiletgtCnt(); // raise rear right leg
      GoToAngles(-1,-1,-1,-1,-1,-1,-1,150,3); loopWhiletgtCnt(); // lower rear right leg
    }
    if ((millis() - anyMilli) > 3000) {break;}
  }
  SetLedMode(1);
  GoToAngles(-1,130,-1,130,-1,-1,-1,-1,20); loopWhiletgtCnt(); // raise head slightly
  LedMode = 0;
  while ((distance >= 310) && (distance <= 900)) {loop();} // wait for hand to be removed
  anyMilli = millis() - anyMilli; // record overall hand over time
  
  HandTask = 4; // Re-enable hand monitoring, so you cacn really any him!
  delayLoop(500); // A pause before we move off.
  SetLedMode(1);
  GoToAngles(-1,-1,-1,-1,100,-1,100,-1,20); loopWhiletgtCnt(); // widen rear legs
  GoToAngles(45,90,45,90,-1,-1,-1,-1,50); loopWhiletgtCnt(); // lower front legs
  anyRnd = random(2);
  if (anyMilli < 3000) {
    // A swift hand movement, so perform one of several demo move sequences.
    if (anyRnd > 0) {
      // Wave front left leg.
      GoToAngles(-1,190,-1,-1,-1,-1,-1,-1,50); loopWhiletgtCnt(); // raise front left leg
      for (anyFor=0; anyFor<2; anyFor++){
        delayLoop(50); // a pause between moves
        GoToAngles(70,-1,-1,-1,-1,-1,-1,-1,5); loopWhiletgtCnt(); // wag front left leg left
        delayLoop(50); // a pause between moves
        GoToAngles(30,-1,-1,-1,-1,-1,-1,-1,5); loopWhiletgtCnt(); // wag front left leg right
      }
    } else {
      // Wave front right leg.
      GoToAngles(-1,-1,-1,190,-1,-1,-1,-1,50); loopWhiletgtCnt(); // raise front right leg
      for (anyFor=0; anyFor<2; anyFor++){
        delayLoop(50); // a pause between moves
        GoToAngles(-1,-1,70,-1,-1,-1,-1,-1,5); loopWhiletgtCnt(); // wag front right leg left
        delayLoop(50); // a pause between moves
        GoToAngles(-1,-1,30,-1,-1,-1,-1,-1,5); loopWhiletgtCnt(); // wag front right leg right
      }
    }
  } else {
    // Hand held over robot for a time, so put up a finger/stamp leg and do nothing.
    if (anyRnd > 0) {
      anyRnd = random(2);
      if (anyRnd > 0) {
        // Raise front left leg.
        GoToAngles(-1,160,-1,-1,-1,-1,-1,-1,50); loopWhiletgtCnt(); // raise front left leg
        delayLoop(500); // a pause between moves
        GoToAngles(-1,190,-1,-1,-1,-1,-1,-1,1); loopWhiletgtCnt(); // raise front left leg higher
      } else {
        // Raise front rightt leg.
        GoToAngles(-1,-1,-1,160,-1,-1,-1,-1,50); loopWhiletgtCnt(); // raise front left leg
        delayLoop(500); // a pause between moves
        GoToAngles(-1,-1,-1,190,-1,-1,-1,-1,1); loopWhiletgtCnt(); // raise front left leg higher
      }
    } else {
      anyRnd = random(2);
      if (anyRnd > 0) {
        // Stamp front left leg.
        for (anyFor=0; anyFor<3; anyFor++){
          GoToAngles(-1,LegUp,-1,-1,-1,-1,-1,-1,20); loopWhiletgtCnt(); // raise front left leg
          GoToAngles(-1,75,-1,-1,-1,-1,-1,-1,1); loopWhiletgtCnt(); // drop front left leg
        }
      } else {
        // Stamp front right leg.
        for (anyFor=0; anyFor<2; anyFor++){
          GoToAngles(-1,-1,-1,LegUp,-1,-1,-1,-1,20); loopWhiletgtCnt(); // raise front right leg
          GoToAngles(-1,-1,-1,75,-1,-1,-1,-1,1); loopWhiletgtCnt(); // drop front right leg
        }
      }
    }
  }
  LedMode = 0; delayLoop(500); // a pause before we move
  SetLedMode(1);
  GoToAngles(45,90,45,90,-1,-1,-1,-1,20); loopWhiletgtCnt(); // lower front legs
  GoToStand(50); loopWhiletgtCnt();
  if (ESC) {HandTask = 1;} // hand re-detected
  else {
    SetMainTask(2);
    if (anyMilli < 3000) {SubTask = 2;} // perform a move demo
    else {SubTask = 1;} // Reset hand monitoring and do nothing.
  } IrEn = IrEnM; LedMode = 0;
}

// ----------------------------------------------------------------------

void Fidget() {
  // Short random movements that always return to the original position.
  // Not currently used in this version.
  MemStore(); // save current values
  anyRnd = random(1);
  switch (anyRnd) {
    case 0: // turn to the right
      anyRnd = 5 + random(10); AddToAngles(anyRnd,0,-anyRnd,0,anyRnd,0,-anyRnd,0,100); break;
  } 
  loopWhiletgtCnt();
  MemRead(); tgtCnt = 5; loopWhiletgtCnt(); // return legs to previous positions
}

// ----------------------------------------------------------------------

void GoToAngles(int zA1,int zA2,int zA3,int zA4,int zA5,int zA6,int zA7,int zA8, int zCnt) {
  // Move to specific servo angles, or -1 means no change.
  // Number of 20ms steps in movement set by zCnt.
  if (ESC) return; // Exit if this flag is set.
  if (!servoEn) {attachServos(0);}
  if (zA1 >= 0) {servoTgt[0] = map(zA1,45,135,Ang1_45,Ang1_135);}
  if (zA2 >= 0) {servoTgt[1] = map(zA2,65,153,Ang2_65,Ang2_153);}
  if (zA3 >= 0) {servoTgt[2] = map(zA3,45,135,Ang3_45,Ang3_135);}
  if (zA4 >= 0) {servoTgt[3] = map(zA4,65,153,Ang4_65,Ang4_153);}
  if (zA5 >= 0) {servoTgt[4] = map(zA5,45,135,Ang5_45,Ang5_135);}
  if (zA6 >= 0) {servoTgt[5] = map(zA6,65,153,Ang6_65,Ang6_153);}
  if (zA7 >= 0) {servoTgt[6] = map(zA7,45,135,Ang7_45,Ang7_135);}
  if (zA8 >= 0) {servoTgt[7] = map(zA8,65,153,Ang8_65,Ang8_153);}
  checkTgts(); // Ensure target values are within servo min/max limits.
  tgtCnt = zCnt;
//  Serial.println(F("GoToAngles Set"));
}

// ----------------------------------------------------------------------

void GoToFloor(int zCnt) {
  // Move to the floor lying position.
  // Number of 20ms steps in movement set by zCnt.
  if (ESC) return;
//  Serial.println(F("> GoToFloor()"));
  GoToAngles(90,153,90,153,90,153,90,153,zCnt); // go to the resting position
}

// ----------------------------------------------------------------------

void GoToRest(int zCnt) {
  // Move to the resting position.
  // Number of 20ms steps in movement set by zCnt.
  if (ESC) return;
//  Serial.println(F("> GoToRest()"));
  GoToAngles(65,65,65,65,65,65,65,65,zCnt); // go to the resting position
}

// ----------------------------------------------------------------------

void GoToStand(int zCnt) {
  // Move to the normal standing position.
  // Number of 20ms steps in movement set by zCnt.
  if (ESC) return;
//  Serial.println(F("> GoToStand()"));
  GoToAngles(90,90,90,90,90,90,90,90,zCnt); // go to the resting position
}

// ----------------------------------------------------------------------

void GoToStandAndWait() {
  // Move to normal standing position, then wait between 300ms - 1s.
  // Created a function as this code is used several times.
  GoToStand(50); loopWhiletgtCnt();
  delayLoop(300 + random(700)); // pause
}

// ----------------------------------------------------------------------

void MainTask_BackAway() {
  // Backs away from an approaching wall, stays in this mode until reset.
  // If wall gets too close it will slow down and stop.
  // If wall is removed it will return to its starting position.
  if (MainRun) {return;}
  MainRun = true; // Prevent re-entry of task and stack overflow.
  switch (SubTask) {
    case 0: // Initialise state machine.
      Serial.println(F("> MainTask_BackAway()")); 
      SubTask = 1; break;
    case 1: // Prepare leg positions for walking backwards.
      Walk = 0; walkInterval = 60000; StartWalk(-3); SubTask = 2; break;
    case 2: // Wait for a wall to appear, or stop walking after a time.
      if ((distance >= 310) && (distance <= 1800)) {SubTask = 3;}
      else {IrEn = IrEnM;}
      break;
    case 3: // Scan for wall range and respond.
      if (distance >= 310) {
        // Wall detected, so backaway speed depends on how close and where it is.
        if ((distance >= 690) && (distance <= 1800)) {
          // Distant wall so backaway to avoid it.
          // A small deadband is used near the max range point to prevent stop/start.
          // Full speed is acheived at <= 1000 up until >=690.
          walkInterval = map(distance, 1800,1000,1,12);
          walkInterval = 60000/walkInterval;
          if (distance <= 1000) {walkInterval = 5000;}// Cap minimum interval.
          Walk = 3; LedMode = 3; IrEn = false;
        } else if ((distance < 690) && (distance > 310)) {
          // Wall is getting too close, so slow down as it gets closer.
          walkInterval = map(distance, 690,310,12,1);
          walkInterval = 60000/walkInterval;
          walkInterval = min(walkInterval,60000); // Cap maximum interval.
          Walk = 3; LedMode = 3; IrEn = false;
        } else {
          // Wall detected in the 1800-1855 max range.
          SubTask = 4;}
      } else {
        // Wall is no longer detected.
        SubTask = 4;}
       break;
    case 4: // Stop moving and put feet down and wait.
      Walk = 0; walkInterval = 60000; LedMode = 0; IrEn = IrEnM;
      MemStore(); // Store current values, before putting all feet down.
      GoToAngles(-1,LegDn,-1,LegDn,-1,LegDn,-1,LegDn,1); // put all feet down immediately
      SubTask++; anyMilli = millis(); break;
    case 5: // Wait for a valid range then return to previous movement.
      if ((distance >= 310) && (distance <= 1800)) {
        // Valid range detected, so return legs to raised positions.
        MemRead(); tgtCnt = 1; SubTask = 3;
      } 
      if ((millis() - anyMilli) >= 10000) { // Check after a delay to see if return movemnent is needed.
        if (Walked < -88) {SubTask++;}
        else {anyMilli = millis();}
      } break;
    case 6: // Start walking back to beginning, with slowly increasing speed.
      walkInterval = 40000; StartWalk(1); LedMode = 1; SubTask++; IrEn = false; break;
    case 7: // Reached the beginning or seen another wall.
//      Serial.print(F("Walked = ")); Serial.println(Walked);
      if (((distance >= 310) && (distance <= 1800)) || (Walked >= -1)) {
        Walk = 0; SubTask = 1; LedMode = 0;
        GoToAngles(-1,LegDn,-1,LegDn,-1,LegDn,-1,LegDn,1);
      }
      if (Walked > -100) {walkInterval -= 30;}
      else if (walkInterval > 10000) {walkInterval -= 30;}
      break;
  } MainRun = false;
}

// ----------------------------------------------------------------------

void MainTask_OnTheSpot() {
  // On the spot demo when triggered by hand.
  // Triggering can occur at any time, so it is not included in subtasks.
  // It is detected in the main loop() calls.
  if (MainRun) {return;}
  MainRun = true; // Prevent re-entry of task and stack overflow.
  switch (SubTask) {
    case 0: // initialise
      Serial.println(F("> MainTask_OnTheSpot()"));
      SubTask = 1; break;
    case 1: // Wait to be triggered.
      break;
    case 2: // Perform a demo sequence.
      delayLoop(1000); // pause
      GoToStandAndWait();
      DemoMove_Bow();  GoToStandAndWait();
      switch (Once) {
        case 0: // First demo sequence, turns and walks.
          DemoMove_TurnRight(45+random(135),10,5,10); GoToStandAndWait();
          DemoMove_Walk(1,176,20000); GoToStandAndWait();
          DemoMove_TurnLeft(45+random(135),10,5,10); GoToStandAndWait();
          DemoMove_Walk(3,176,20000); GoToStandAndWait();
          break;
        case 1: // Second demo sequence, walks in a square.
          DemoMove_Walk(-2,264,20000); // walk sideways right
          DemoMove_Walk(-3,264,20000); // walk backward
          DemoMove_Walk(-4,264,20000); // walk sideways left
          DemoMove_Walk(-1,264,20000); // walk forward
          GoToStandAndWait(); break;
      } Once++; if (Once > 1) {Once = 0;} // Increment and reset counter.
      DemoMove_Bow();  GoToStandAndWait();
      SubTask = 1; break;
  }
  MainRun = false;
}

// ----------------------------------------------------------------------

void MainTask_StandAndStretch(int zCnt) {
  // Move to the normal standing position.
  // Normally called during power-up demand.
  // Number of 20ms steps in movement set by zCnt
  if (MainRun) {return;}
  MainRun = true; // Prevent re-entry of task and stack overflow.
  Serial.println(F("> MainTask_StandAndStretch()"));
  IrEn = false; SetLedMode(1);
  GoToStand(zCnt); loopWhiletgtCnt(); // stand up
  LedMode = 0; delayLoop(500); // pause before stretching
  SetLedMode(3); GoToAngles(-1,120,-1,120,-1,153,-1,153,zCnt); loopWhiletgtCnt(); // stretch out
  LedMode = 0; delayLoop(500); // pause before stretching
  SetLedMode(3); GoToAngles(-1,90,-1,90,-1,-1,-1,-1,zCnt); loopWhiletgtCnt(); // pull back front legs
  LedMode = 0; delayLoop(500); // pause before stretching
  SetLedMode(2); GoToAngles(135,-1,45,-1,135,-1,45,-1,zCnt); loopWhiletgtCnt(); // turn full right
  LedMode = 0; delayLoop(500); // pause before stretching
  SetLedMode(4); GoToAngles(45,-1,135,-1,45,-1,135,-1,zCnt); loopWhiletgtCnt(); // turn full left
  LedMode = 0; delayLoop(500); // pause before stretching
  SetLedMode(2); GoToAngles(90,-1,90,-1,90,-1,90,-1,zCnt); loopWhiletgtCnt(); // turn to centre
  LedMode = 0; delayLoop(500); // pause before stretching
  SetLedMode(1); GoToAngles(-1,-1,-1,-1,-1,90,-1,90,zCnt); loopWhiletgtCnt(); // pull back
  LedMode = 0; autoOFF = 5; IrEn = IrEnM;
  MainRun = false;
}

// ----------------------------------------------------------------------

void MainTask_Test(int zCnt) {
  // Put test code here.
  // This is an early random turning test.
  if (MainRun) {return;}
  MainRun = true; // Prevent re-entry of task and stack overflow.
  Serial.println(F("> MainTask_Test()"));
  MainRun = false;
}

// ----------------------------------------------------------------------

void MainTask_TrackWall() {
  // Maintains a fixed distance from a wall, stays in this mode until reset.
  if (MainRun) {return;}
  MainRun = true; // Prevent re-entry of task and stack overflow.
  switch (SubTask) {
    case 0: // Initialise
      Serial.println(F("> MainTask_TrackWall()"));
      SubTask = 1; break;
    case 1: // Start expecting to go forward, but may not be the case.
      walkInterval = 20000; StartWalk(-1); SubTask = 2; break;
    case 2: // wait for a wall to appear
      if ((distance >= 310) && (distance <= 1050)) {SubTask = 3;  StartWalk(-3);}
      else if ((distance >= 1250) && (distance <= 1800)) {SubTask = 3;  StartWalk(-1);}
      else {IrEn = IrEnM;}
      break;
    case 3: // Scan for wall and respond.
      if (distance >= 310) {
        if (distance > 1800) {
          // If walking forward let it continue, but if not start; both moderately.
          if (abs(Walk) == 1) {Walk = 1;}
          else {StartWalk(1);} walkInterval = 20000; LedMode = 1; IrEn = false;
        } else if ((distance >= 1250) && (distance <=1800)) {
          // Far wall detected so walking speed depends on how close it is.
          walkInterval = map(distance, 1250,1650,1,12);
          walkInterval = 60000/walkInterval;
          if (distance >= 1650) {walkInterval = 5000;} // Cap minimum interval.
          Walk = 1; LedMode = 1; IrEn = false;
        } else if ((distance <= 1050) && (distance >= 500)) {
          // Close wall detected, so backaway speed depends on how close it is.
          walkInterval = map(distance, 1050,650,1,12);
          walkInterval = 60000/walkInterval;
          if (distance <= 650) {walkInterval = 5000;} // Cap minimum interval.
          Walk = 3; LedMode = 3; IrEn = false;
        } else if ((distance < 500) && (distance >= 310)) {
          // Too close wall detected, so slow down backaway speed.
          walkInterval = map(distance, 310,500,1,12);
          walkInterval = 60000/walkInterval;
          Walk = 3; LedMode = 3; IrEn = false;
        } else {
          // In centre deadband, so stop.
          SubTask = 4;}
      } else {
        // No wall detected, but one had been previously.
        SubTask = 4;
      } break;
    case 4: // Stop moving and put feet down and wait.
      Walk = -abs(Walk); walkInterval = 20000; LedMode = 0; IrEn = IrEnM;
      MemStore(); // store current values
      GoToAngles(-1,LegDn,-1,LegDn,-1,LegDn,-1,LegDn,1); // put all feet down immediately
      SubTask++; break;
    case 5: // Wait for a valid range then return to previous movement
      if ((distance >= 310) && (distance <= 1050)) {
        // valid reverse range
        if (Walk = -3) {
          // Previously walking backwards, so raise lowered legs and continue.
          MemRead(); tgtCnt = 1; SubTask = 3;
        } else {SubTask = 2;} // Walking direction changing.
      } else if ((distance >= 1250) && (distance <= 1800)) {
        // Valid forward range.
        if (Walk = -1) {
          // Previously walking forwards, so lower legs and continue.
          MemRead(); tgtCnt = 1; SubTask = 3;
        } else {SubTask = 2;} // Walking direction is changing.
      } break;
  } MainRun = false;
}

// ----------------------------------------------------------------------

void MoveToAngles(int zA1,int zA2,int zA3,int zA4,int zA5,int zA6,int zA7,int zA8) {
  // Move to specific servo angles by raising and lowering legs.
  // This prevents dragging of feet, but can take slightly longer.
  // Number of 20ms steps in movement set by zCnt.
  if (ESC) return; // exit if this flag is set
  if (!servoEn) {attachServos(0);}
  anyDel = 120;
  GoToAngles(-1,LegDn,-1,LegDn,-1,LegDn,-1,LegDn,3); loopWhiletgtCnt();
  SetAngle(10,zA1); // Get the target angle in microseconds, but don't move the servo.
  if (servoVal[0] != servoTgt[0]) {
    SetAngle(1,LegUp); delayLoop(anyDel); SetAngle(0,zA1); delayLoop(anyDel);
  } SetAngle(1,zA2);
  SetAngle(12,zA3); // Get the target angle in microseconds, but don't move the servo.
  if (servoVal[2] != servoTgt[2]) {
    SetAngle(3,LegUp); delayLoop(anyDel); SetAngle(2,zA3); delayLoop(anyDel);
  } SetAngle(3,zA4);
  SetAngle(14,zA5); // Get the target angle in microseconds, but don't move the servo.
  if (servoVal[4] != servoTgt[4]) {
    SetAngle(5,LegUp); delayLoop(anyDel); SetAngle(4,zA5); delayLoop(anyDel);
  } SetAngle(5,zA6);
  SetAngle(16,zA7); // Get the target angle in microseconds, but don't move the servo.
  if (servoVal[6] != servoTgt[6]) {
    SetAngle(7,LegUp); delayLoop(anyDel); SetAngle(6,zA7); delayLoop(anyDel);
  } SetAngle(7,zA8);  delayLoop(anyDel);
  if (autoOFF >= 0) {autoOFF = 5;} // Set servo auto-OFF timeout.
}

// ----------------------------------------------------------------------

void StartWalk(int zWalk) {
  // Initiates one of four walk directions by getting the legs in the correct position.
  // If zWalk is -ve then position feet but don't initiate a walk.
  // 0 - stationary
  // 1 - walk forward
  // 2 - walk to the right
  // 3 - walk backwards
  // 4 - walk to the left
  Walk = 0; WalkCnt = 21; // Stop walking and set start points based on direction.
  switch (abs(zWalk)) {
    case 0: MoveToAngles(111,LegDn,112,LegDn,114,LegDn,113,LegDn); break;
    case 1: MoveToAngles(111,LegDn,112,LegDn,114,LegDn,113,LegDn); break;
    case 2: MoveToAngles(69,LegDn,68,LegDn,66,LegDn,67,LegDn); break;
    case 3: MoveToAngles(111,LegDn,112,LegDn,114,LegDn,113,LegDn); break;
    case 4: MoveToAngles(69,LegDn,68,LegDn,66,LegDn,67,LegDn); break;
  }
  Walk = zWalk; // Start walking if Walk > 0.
  if (zWalk >= 0) {
    SetLedMode(Walk);
  }
}

// ----------------------------------------------------------------------

void TurnLeft(int zAng, int zStep, int zCnt) {
  // Neutral turn to the left by a given angle, step size and speed.
  // Note that speed can also be set by walkInterval loop period.
  // zStep should be >= 1 and <= 45
  int zSwg; zStep = max(zStep,1); zStep = min(zStep,45); // Ensure zStep is in range.
//  Serial.print(F("> TurnRight(")); Serial.print(zAng); Serial.println(F(")"));
  MoveToAngles(90,LegDn,90,LegDn,90,LegDn,90,LegDn); loopWhiletgtCnt(); // Drop to move angle.
  SetLedMode(4);
  while (zAng > 0) {
    // Move a max of zStep degrees on each opposite leg set at a time.
    // FL and RR legs first
    if (Turn) {zSwg = zStep; zAng = zStep;}
    else {zSwg = min(zAng,zStep); zAng = zAng - zSwg;}
    GoToAngles(-1,LegUp,-1,-1,-1,LegUp,-1,-1,3); loopWhiletgtCnt(); // raise FL RR legs quickly
    delayLoop(2);
    GoToAngles(90+zSwg,-1,-1,-1,90+zSwg,-1,-1,-1,zCnt); loopWhiletgtCnt(); // swing legs quickly
    delayLoop(2);
    GoToAngles(-1,LegDn,-1,-1,-1,LegDn,-1,-1,3); loopWhiletgtCnt(); // drop legs quickly
    delayLoop(2);
    GoToAngles(-1,-1,-1,LegUp,-1,-1,-1,LegUp,3); loopWhiletgtCnt(); // raise legs quickly
    delayLoop(2);
    GoToAngles(90,-1,-1,-1,90,-1,-1,-1,zCnt); loopWhiletgtCnt(); // swing legs quickly
    delayLoop(2);
    if (zAng < 1) {GoToAngles(-1,-1,-1,LegDn,-1,-1,-1,LegDn,3); loopWhiletgtCnt(); // drop legs quickly
      delayLoop(2);}
    else {
      if (Turn) {zSwg = zStep; zAng = zStep;}
      else {zSwg = min(zAng,zStep); zAng = zAng - zSwg;}
      // FR and RL legs
      GoToAngles(-1,-1,-1,LegUp,-1,-1,-1,LegUp,3); loopWhiletgtCnt(); // raise FR RL legs quickly
      delayLoop(2);
      GoToAngles(-1,-1,90-zSwg,-1,-1,-1,90-zSwg,-1,zCnt); loopWhiletgtCnt(); // swing legs quickly
      delayLoop(2);
      GoToAngles(-1,-1,-1,LegDn,-1,-1,-1,LegDn,3); loopWhiletgtCnt(); // drop legs quickly
      delayLoop(2);
      GoToAngles(-1,LegUp,-1,-1,-1,LegUp,-1,-1,3); loopWhiletgtCnt(); // raise legs quickly
      delayLoop(2);
      GoToAngles(-1,-1,90,-1,-1,-1,90,-1,zCnt); loopWhiletgtCnt(); // swing legs quickly
      delayLoop(2);
      if (zAng < 1) {GoToAngles(-1,LegDn,-1,-1,-1,LegDn,-1,-1,3); loopWhiletgtCnt(); // drop legs quickly
        delayLoop(2);}
    }
  } SetLedMode(0);
}

// ----------------------------------------------------------------------

void TurnRight(int zAng, int zStep, int zCnt) {
  // Neutral turn to the right by a given angle, step size and speed.
  // Note that speed can also be set by walkInterval loop period.
  // zStep should be >= 1 and <= 45
  int zSwg; zStep = max(zStep,1); zStep = min(zStep,45); // Ensure zStep is in range.
//  Serial.print(F("> TurnRight(")); Serial.print(zAng); Serial.println(F(")"));
  MoveToAngles(90,LegDn,90,LegDn,90,LegDn,90,LegDn); loopWhiletgtCnt(); // Drop to move angle.
  SetLedMode(2);
  while (zAng > 0) {
    // Move a max of 10 degrees on each opposite leg set at a time.
    // FR and RL legs first
    if (Turn) {zSwg = zStep; zAng = zStep;}
    else {zSwg = min(zAng,zStep); zAng = zAng - zSwg;}
    GoToAngles(-1,-1,-1,LegUp,-1,-1,-1,LegUp,3); loopWhiletgtCnt(); // raise FR RL legs quickly
    delayLoop(2);
    GoToAngles(-1,-1,90+zSwg,-1,-1,-1,90+zSwg,-1,zCnt); loopWhiletgtCnt(); // swing legs quickly
    delayLoop(2);
    GoToAngles(-1,-1,-1,LegDn,-1,-1,-1,LegDn,3); loopWhiletgtCnt(); // drop legs quickly
    delayLoop(2);
    GoToAngles(-1,LegUp,-1,-1,-1,LegUp,-1,-1,3); loopWhiletgtCnt(); // raise legs quickly
    delayLoop(2);
    GoToAngles(-1,-1,90,-1,-1,-1,90,-1,zCnt); loopWhiletgtCnt(); // swing legs quickly
    delayLoop(2);
    if (zAng < 1) {GoToAngles(-1,LegDn,-1,-1,-1,LegDn,-1,-1,3); loopWhiletgtCnt(); // drop legs quickly
      delayLoop(2);}
    else {
      if (Turn) {zSwg = zStep; zAng = zStep;}
      else {zSwg = min(zAng,zStep); zAng = zAng - zSwg;}
      // FL and RR legs
      GoToAngles(-1,LegUp,-1,-1,-1,LegUp,-1,-1,3); loopWhiletgtCnt(); // raise FL RR legs quickly
      delayLoop(2);
      GoToAngles(90-zSwg,-1,-1,-1,90-zSwg,-1,-1,-1,zCnt); loopWhiletgtCnt(); // swing legs quickly
      delayLoop(2);
      GoToAngles(-1,LegDn,-1,-1,-1,LegDn,-1,-1,3); loopWhiletgtCnt(); // drop legs quickly
      delayLoop(2);
      GoToAngles(-1,-1,-1,LegUp,-1,-1,-1,LegUp,3); loopWhiletgtCnt(); // raise legs quickly
      delayLoop(2);
      GoToAngles(90,-1,-1,-1,90,-1,-1,-1,zCnt); loopWhiletgtCnt(); // swing legs quickly
      delayLoop(2);
      if (zAng < 1) {GoToAngles(-1,-1,-1,LegDn,-1,-1,-1,LegDn,3); loopWhiletgtCnt(); // drop legs quickly
        delayLoop(2);}
    }
  } SetLedMode(0);
}

// ----------------------------------------------------------------------


