
// ----------------------------------------------------------------------

void arrest(int zMT) {
  // Called on the button count == 1 to ensure it is arrested from any movement.
  MainTask = -1; SubTask = 10; ESC = true; walkInterval = 20000;
  MainTaskNext = zMT;
}

// ----------------------------------------------------------------------

void attachServos(int zDel) {
  // Create 8 servos and attach them to pins defined in an array.
  // Delay used during power-up reset, otherwise set to 0.
  if (ESC) return; // If interrupting tasks we don't want to attach them
  servoEn = true;
  for (int zP = 0; zP < 8;zP++) {
    servoInst[zP].attach(servoPins[zP]);
    servoInst[zP].writeMicroseconds(servoVal[zP]); delay(zDel);
    servoTgt[zP] = servoVal[zP]; // correct target positions
  }
}

// ----------------------------------------------------------------------

void BatteryFailed() {
  // If battery voltage drops below trigger level for more than 1 second.
  // Once called the code stays here blinking the left LED until reset.
  // You should immediately disconnect your batteries and recharge them.
  detachServos();
  digitalWrite(LEDLft, HIGH); digitalWrite(LEDRht, HIGH);
  // Flash left LED for 30 seconds to give a warning
  for (int zL = 0; zL < 30; zL++) {
    digitalWrite(LEDLft, LOW); delay(20);
    digitalWrite(LEDLft, HIGH); delay(980);
  }
  while (true) {} // Do nothing forever!
}

// ----------------------------------------------------------------------

void checkTgts() {
  // Ensure that set targets are within servo min/max limits
  servoTgt[0] = min(servoTgt[0],Max1); servoTgt[0] = max(servoTgt[0],Min1);
  servoTgt[1] = min(servoTgt[1],Max2); servoTgt[1] = max(servoTgt[1],Min2);
  servoTgt[2] = min(servoTgt[2],Max3); servoTgt[2] = max(servoTgt[2],Min3);
  servoTgt[3] = min(servoTgt[3],Max4); servoTgt[3] = max(servoTgt[3],Min4);
  servoTgt[4] = min(servoTgt[4],Max5); servoTgt[4] = max(servoTgt[4],Min5);
  servoTgt[5] = min(servoTgt[5],Max6); servoTgt[5] = max(servoTgt[5],Min6);
  servoTgt[6] = min(servoTgt[6],Max7); servoTgt[6] = max(servoTgt[6],Min7);
  servoTgt[7] = min(servoTgt[7],Max8); servoTgt[7] = max(servoTgt[7],Min8);
}

// ----------------------------------------------------------------------

void decodeIrFunction() {
  // Decodes a valid IR code.
  // The PWR button must be long pressed first to initiate further decoding.
  if (IrCode == 0x0C) {
    // PWR code received
    if (IrCodeLast == IrCode) {IrPWR++;} // A series of PWR codes being received
    else {
      if (IrPWR >= 5) {SetLedMode(5); LedCnt = 25;} // IR codes enabled.
      IrPWR = 0; // Reseting counter after first receipt of IR PWR only.
    }
    if (IrPWR >= 5) { // Entering IR mode or exiting MainTasks other than 1.
      // Holding down the PWR button on the IR remote will exit MainTasks.
      SetLedMode(5);
      if (MainTask != 0) {delayLoop(1000); arrest(1);} // Exit current MainTask.
    }
    IrCodeLast = IrCode; return; // Keep a record of the latest code received.
  }
  if (IrPWR < 5) {return;} // Not yet in IR receive mode, so stay SAFE.

  // Check for changing modes?
  // This only occures in MainTask 1 as PWR will exit all other MainTasks.
  switch(IrCode) {
    case 0x24: // RECORD button
      arrest(1); IrCode = -1; return; // Exit current mode and goto MainTask 1.
    case 0x36: // STOP button
      arrest(2); IrCode = -1; return; // Exit current mode and goto MainTask 2.
    case 0x0E: // PLAY button
      arrest(3); IrCode = -1; return; // Exit current mode and goto MainTask 3.
    case 0x1F: // PAUSE button
      arrest(4); IrCode = -1; return; // Exit current mode and goto MainTask 4.
  }

  // Ensure we are in MainTask 0 before decoding further IR codes.
  if (MainTask != 0) {return;} // Not in MainTask == 1, so exit.
  switch(IrCode) {
    case 0x01: // "1" - Bow
      DemoMove_Bow(); IrCode = -1; break;
    case 0x02: // "2" - Twist
      DemoMove_Twist(); IrCode = -1; break;
    case 0x03: // "3" - Press-ups
      DemoMove_PressUps(); IrCode = -1; break;
    case 0x04: // "4" - Sit-n-wave
      DemoMove_SitNWave(); IrCode = -1; break;
    case 0x05: // "5"
      break;
//    case 0x06: Serial.println(" 6"); break;
//    case 0x07: Serial.println(" 7"); break;
//    case 0x08: Serial.println(" 8"); break;
//    case 0x09: Serial.println(" 9"); break;
    case 0x10: // V+ button - walk to the left
      if (abs(Walk) != 4) {// not walking or walking in a different direction
        walkInterval = 20000; StartWalk(4); LedMode = 4;
      } else if (Walk == -4) {// restart walking process
        MemRead(); tgtCnt = 1; loopWhiletgtCnt(); Walk = 4; LedMode = 4;
      } else {// increase speed
        walkInterval -= 200; walkInterval = max(walkInterval,4000);
      } break;
    case 0x11: // V- button - walk to the right
      if (abs(Walk) != 2) {// not walking or walking in a different direction
        walkInterval = 20000; StartWalk(2); LedMode = 2;
      } else if (Walk == -2) {// restart walking process
        MemRead(); tgtCnt = 1; loopWhiletgtCnt(); Walk = 2; LedMode = 2;
      } else {// increase speed
        walkInterval -= 200; walkInterval = max(walkInterval,4000);
      } break;
//    case 0x12: // MENU button
//      break;
    case 0x1C: // P+ button - walk forward
      if (abs(Walk) != 1) {// not walking or walking in a different direction
        walkInterval = 20000; StartWalk(1); LedMode = 1;
      } else if (Walk == -1) {// restart walking process
        MemRead(); tgtCnt = 1; loopWhiletgtCnt(); Walk = 1; LedMode = 1;
      } else {// increase speed
        walkInterval -= 200; walkInterval = max(walkInterval,4000);
      } break;
    case 0x1D: // P- button - walk backward
      if (abs(Walk) != 3) {// not walking or walking in a different direction
        walkInterval = 20000; StartWalk(3); LedMode = 3;
      } else if (Walk == -3) {// restart walking process
        MemRead(); tgtCnt = 1; loopWhiletgtCnt(); Walk = 3; LedMode = 3; 
      } else {// increase speed
        walkInterval -= 200; walkInterval = max(walkInterval,4000);
      } break;
//    case 0x1F: Serial.println(" PAUSE"); break;
    case 0x20: // UP button - turn left
      if (!Turn) {Turn = true; IrEn = true; TurnLeft(20,10,5);} // continuous turn until IR button released
      break;
    case 0x21: // DOWN button - turn right
      if (!Turn) {Turn = true; IrEn = true; TurnRight(20,10,5);} // continuous turn until IR button released
      break;
//    case 0x23: Serial.println(" <<"); break;
//    case 0x24: Serial.println(" REC"); break;
//    case 0x26: // SLEEP button
//      break;
//    case 0x27: Serial.println(" SUB-T"); break;
//    case 0x2C: Serial.println(" =?"); break;
//    case 0x2D: Serial.println(" =X"); break;
//    case 0x36: Serial.println(" STOP"); break;
//    case 0x3B: Serial.println(" OK"); break;
  default: break;
  } IrCodeLast = IrCode; // Keep a record of the latest code received.
}

// ----------------------------------------------------------------------

void detachServos() {
  // Detach all servos. Used to conserve battery power.
  servoEn = false;
  for (int zP = 0; zP < 8;zP++) {servoInst[zP].detach();}
}

// ----------------------------------------------------------------------

void detectHand() {
  // If this feature is enabled, detect the presence of a hand.
  // Uses a state machine to sequence through events and responses
  switch (HandTask) {
    case 0:
      if ((distance >= 310) && (distance <= 900)) {
        // something detected by ultrasonics
        HandCnt++; if (HandCnt >= 2) {HandTask++;}
      } else {HandCnt = 0;} break;
    case 1:
//      Serial.println(F("Hand detected!"));
      if (MainRun) {ESC = true; return;} // ensure you are not in a task, if so kill it
      ESC = false; HandTask++; break;
    case 2: // Initiate dodge hand sequence
      HandTask++; dodgeHand(); break;
    case 3: // Comes here during dodgeHand() function, which then moves it on.
      break;
    case 4: // Comes here in the later part of the dodgeHand() function.
      // Triggers an ESC if the hand is placed back over the robot.
      if ((distance >= 310) && (distance <= 900)) {
        // something detected by ultrasonics
        HandCnt++; if (HandCnt >= 3) {HandTask++;}
      } else {HandCnt = 0;} break;
    case 5: // Comes here if hand retriggers during later part of dodgeHand().
      ESC = true; break;
  }
}

// ----------------------------------------------------------------------

void doCmd() {
  // Perform a keyboard action. Uncomment if you need servo values
//  for (int zP = 0; zP < 8;zP++) {
//    Serial.print(F("S1=")); Serial.println(servoVal[zP]);
//  }
}

// ----------------------------------------------------------------------

void flashLEDs(int zCnt) {
  // Flash the left and right LEDs zCnt times using a delay().
  // Used to give feedback on selected MainTask.
  // Loop timers will need to be re-synchronised after this function.
  for (int zP = 0; zP < zCnt;zP++) {
    digitalWrite(LEDLft, LOW); digitalWrite(LEDRht, LOW); delay(30);
    digitalWrite(LEDLft, HIGH); digitalWrite(LEDRht, HIGH); delay(270);
  }
}

// ----------------------------------------------------------------------

void flashWhilstDown(int zON,int zOFF) {
  // Flash LEDs whilst waiting for button switch to be released.
  while (digitalRead(SwPin) == LOW) {
    digitalWrite(LEDLft, LOW); digitalWrite(LEDRht, LOW);
    delay(zON);
    digitalWrite(LEDLft, HIGH); digitalWrite(LEDRht, HIGH);
    if (digitalRead(SwPin) == HIGH) {break;}
    delay(zOFF);
  }
}

// ----------------------------------------------------------------------

void MemRead() {
  // Reads the stored servo values into target values.
  // Used to recall stored leg positions.
  for (anyFor = 0;anyFor < 8;anyFor++) {servoTgt[anyFor] = servoMem[anyFor];}
}

// ----------------------------------------------------------------------

void MemStore() {
  // Stores the current servo values in a memory store.
  // Used to store leg positions prior to putting raised ones down.
  for (anyFor = 0;anyFor < 8;anyFor++) {servoMem[anyFor] = servoVal[anyFor];}
}

// ----------------------------------------------------------------------

void readKey() {
  // Reads a key from the keyboard annd reacts accordingly.
  // This code is left in but commented out. It may be useful to you.
  keyVal = Serial.read();
  if (keyVal != -1) {
    keyChar = char(keyVal);
//      Serial.print("keyVal=");
//      Serial.print(keyChar);
//      Serial.print("   ASCII=");
//      Serial.println(keyVal);
    int zNF = 0;
//    switch (keyChar) {
//      case '!': RESET(); zNF = 1;break;
//      case '0': extendCmdVal(0); zNF = 1;break;
//      case '1': extendCmdVal(1); zNF = 1;break;
//      case '2': extendCmdVal(2); zNF = 1;break;
//      case '3': extendCmdVal(3); zNF = 1;break;
//      case '4': extendCmdVal(4); zNF = 1;break;
//      case '5': extendCmdVal(5); zNF = 1;break;
//      case '6': extendCmdVal(6); zNF = 1;break;
//      case '7': extendCmdVal(7); zNF = 1;break;
//      case '8': extendCmdVal(8); zNF = 1;break;
//      case '9': extendCmdVal(9); zNF = 1;break;
//    }
    if (zNF == 0) {
      if (cmdMode == ' ') {
        // test for new Command Mode char?
//        switch (keyChar) {
//          case 's': cmdMode = 'S'; break;
//          case 'S': cmdMode = 'S'; break;
//        } 
        cmdType = ' '; cmdVal = 0;
      } else {
        // test for Command Type char?
        switch (keyChar) {
//          case 'a': cmdType = 'A'; break;
//          case 'A': cmdType = 'A'; break;
//          case 'd': cmdType = 'D'; break;
//          case 'D': cmdType = 'D'; break;
//          case 'l': cmdType = 'L'; break;
//          case 'L': cmdType = 'L'; break;
//          case 'm': cmdType = 'M'; break;
//          case 'M': cmdType = 'M'; break;
//          case 'p': cmdType = 'P'; break;
//          case 'P': cmdType = 'P'; break;
//          case 'u': cmdType = 'U'; break;
//          case 'U': cmdType = 'U'; break;
          case '.': doCmd(); break;
        }
      }
    } else if (keyChar == '.') {doCmd();}
  }
}

// ----------------------------------------------------------------------

void readSwitch() {
  // Read the button switch and respond accordingly, pressed == LOW.
  // A button press will automatically drop the current MainTask stopping any
  // movement that may be in progress.
  // A long press is used in power-up/down features.
  swState = digitalRead(SwPin); LEDLftSt = swState;
  if ((swLastState == HIGH) && (swState == LOW)) {
    swCnt++; // count on the falling edge
    swTimer = 0; // reset the timer
    LedMode = 0;
    if (swCnt == 1) {arrest(0);} // ensure that if it was moving stop it!
  }
  swLastState = swState; // record current state
  if (swCnt > 0) {swTimer++;}
  if ((swTimer >= 50) && (swState == HIGH)) {
    // Button released for 1 sec so assume valid button count
//    Serial.print(F("swCnt = ")); Serial.println(swCnt);
    flashLEDs(swCnt); // indicate count by flashing
    if (swCnt == 1) {SetMainTask(1); QuadActive = true;} // goto default state
    else if (QuadActive) {
      // only respond to these counts if stood up and active
      SubTask = 0;
      if (swCnt == 2) {SetMainTask(2);}; // on the spot demo
      if (swCnt == 3) {SetMainTask(3);}; // backaway from target mode
      if (swCnt == 4) {SetMainTask(4);}; // track wall target mode
    }
    swCnt = 0; swTimer = 0; synchLoopTimers();
  } else if((swTimer >= 100) && (swState == LOW)) {
    // button held down for 2 seconds
    if (!QuadActive) {
      // Robot was inactive so stand it up.
      // This is normally the long press after reset to wake it up.
      flashWhilstDown(20,150);
      SetMainTask(99); // go to the standing position via a routine
//      Serial.println(F("Standing Up!"));
      QuadActive = true; synchLoopTimers();
    } else {
      // Robot was active so return it to the reset state.
      // Long press renders the robot inactive with its legs pulled together.
      flashWhilstDown(150,20);
      GoToRest(50); // go to the resting position within 1 second
//      Serial.println(F("Going To Rest..."));
      QuadActive = false;  synchLoopTimers(); autoOFF = 10;
    }
    swCnt = 0; swTimer = 0;
  }
}

// ----------------------------------------------------------------------

void SetAngle(int zS, int zA) {
  // Sets a specific servo zS to an angle zA immediately.
  // If zS >= 10 then set target only and don't move the servo.
  // Note servo array elements are numbered 0 - 7, not 1 - 8 like physical servos
  if (ESC) return;
  if (!servoEn) {attachServos(0);}
  anyVal = 0; if (zS >= 10) {zS = zS - 10; anyVal = 1;}
  if (zA >= 0) {
    // We convert servo angles in degrees to microseconds here.
    // So we only need to think in degrees and not worry about the actual values.
    switch (zS) {
      case 0: servoTgt[0] = map(zA,45,135,Ang1_45,Ang1_135); break;
      case 1: servoTgt[1] = map(zA,65,153,Ang2_65,Ang2_153); break;
      case 2: servoTgt[2] = map(zA,45,135,Ang3_45,Ang3_135); break;
      case 3: servoTgt[3] = map(zA,65,153,Ang4_65,Ang4_153); break;
      case 4: servoTgt[4] = map(zA,45,135,Ang5_45,Ang5_135); break;
      case 5: servoTgt[5] = map(zA,65,153,Ang6_65,Ang6_153); break;
      case 6: servoTgt[6] = map(zA,45,135,Ang7_45,Ang7_135); break;
      case 7: servoTgt[7] = map(zA,65,153,Ang8_65,Ang8_153); break;
    }
    if (anyVal < 1) {
      // zS is not >= 10 so set servo immediately
      if (servoVal[zS] != servoTgt[zS]) {
        servoVal[zS] = servoTgt[zS]; servoInst[zS].writeMicroseconds(servoVal[zS]);
      }
    }
  }
}

// ----------------------------------------------------------------------

void SetLedMode(int zM) {
  // Sets the LED sequence mode and clears the counter.
  LedMode = zM; LedCnt = 0;
}

// ----------------------------------------------------------------------

void SetMainTask(int zMT) {
  // Sets the main task and associated default values and flags.
  autoOFF = 5;
  ESC = false;
  HandCnt = 0;
  HandEn = false;
  HandTask = 0;
  IrEnM = true; IrEn = IrEnM; irrecv.enableIRIn(); // IR enable, default false, mode 1 = true
  IrPWR = 0; // timer used to enable IR modes
  IrRxTimer = 0; // counter used to detect end of received IR codes
  MainRun = false;
  MainTask = zMT;
  SubTask = 0;
  tgtCnt = 0;
  Turn = false; // default = false; if true turns continuously until = false
  Walk = 0;
  Walked = 0; // counter used to return robot to a given position
  walkInterval = 20000; synchLoopTimers();

  // Set special options depending on the MainTask number.
  switch(zMT) {
    case 2: HandEn = true; break;
  }
  Serial.print(F("MainTask = ")); Serial.println(MainTask);
}

// ----------------------------------------------------------------------

void translateIR_Samsung_0111(int zCode) {
  // Describing Samsung 0111 Remote IR codes on a Poundland TV remote control.
  // If a rogue code is received then IrCode will not be changed.
  // I have included commented-out codes you may find useful.
//  Serial.println(zCode, HEX);  // print raw values
  if ((zCode < 1) || (zCode > 0x8FF)) {return;} // Ignore rogue codes.
  zCode = zCode & 0xFF;
  switch(zCode) {
    case 0x01: // "1"
      IrCode = zCode; break;
    case 0x02: // "2"
      IrCode = zCode; break;
    case 0x03: // "3"
      IrCode = zCode; break;
    case 0x04: // "4"
      IrCode = zCode; break;
    case 0x05: // "5"
      IrCode = zCode; break;
//    case 0x06: Serial.println(" 6"); break;
//    case 0x07: Serial.println(" 7"); break;
//    case 0x08: Serial.println(" 8"); break;
//    case 0x09: Serial.println(" 9"); break;
    case 0x0C: // PWR button
      IrCode = zCode; break;
    case 0x0E: // PLAY button
      IrCode = zCode; break;
    case 0x10: // V+ button - walk to the left
      IrCode = zCode; break;
    case 0x11: // V- button - walk to the right
      IrCode = zCode; break;
//    case 0x12: Serial.println(" MENU"); break;
    case 0x1C: // P+ button - walk forward
      IrCode = zCode; break;
    case 0x1D: // P- button - walk backward
      IrCode = zCode; break;
    case 0x1F: // PAUSE button
      IrCode = zCode; break;
    case 0x20: // UP button - turn left
      IrCode = zCode; break;
    case 0x21: // DOWN button - turn right
      IrCode = zCode; break;
//    case 0x23: Serial.println(" <<"); break;
    case 0x24: //  REC button
      IrCode = zCode; break;
//    case 0x26: Serial.println(" SLEEP"); break;
//    case 0x27: Serial.println(" SUB-T"); break;
//    case 0x2C: Serial.println(" =?"); break;
//    case 0x2D: Serial.println(" =X"); break;
    case 0x36: // STOP button
      IrCode = zCode; break;
//    case 0x3B: Serial.println(" OK"); break;
  default: break;
  }
}

// ----------------------------------------------------------------------

void trigRadar() {
  // Performs an ultrasonic measurement.
  // The ultrasonic PING is triggered by a HIGH pulse of 2 or more microseconds.
  int zState = 0;
  digitalWrite(trigPin, LOW);
  delayMicroseconds(2); // normally 2us
  if (digitalRead(echoPin) == HIGH) {
    // Ultrasonic receiver is not ready, so don't read it.
    zState = echoMax;
    echoTO = 0;
  } else {
    digitalWrite(trigPin, HIGH);
    delayMicroseconds(10); // normally 10us
    digitalWrite(trigPin, LOW);
    // A HIGH pulse of duration in microseconds from the sending
    // of the ping to the return of its echo from something.
    duration = pulseIn(echoPin, HIGH, echoMax);
    if ((duration > 0) && (duration < echoMax)) {
      // valid reading, so normally convert it to distance.
      // Here I am using the raw value for ranging targets.
      distance = duration; echoTO = 0;
    } else {
      // Invalid reading so sustain distance for a period of time.
      // This prevents glitches from resulting in stop/start movements.
      // It effective sustains the last valid reading for about 100ms.
      echoTO++; if (echoTO >= 15) {distance = 0;}
    }
  }
//  Serial.println(distance);// Serial.print(",");Serial.println(zState);
}

// ----------------------------------------------------------------------



