/*
 * Decompiled with CFR 0.152.
 */
import processing.core.PApplet;
import processing.core.PImage;
import processing.serial.Serial;

public class Proc_Servo_Ctrl_05
extends PApplet {
    Serial usbPort;
    int angleMode;
    int comFlag = 0;
    int comListLength = 0;
    String comName = "";
    int comPnt = 0;
    int ctrlMode;
    int cycles;
    String data = "";
    int drawFlag = 1;
    float zF;
    PImage img;
    int index = 0;
    int interval = 10;
    int JoyX0 = 170;
    int JoyX1 = 630;
    int JoyXval;
    int keyDwn = 0;
    int LF = 10;
    int mDown;
    int mON;
    int mTO;
    int mX;
    int mY;
    String msgCh;
    String msgCOM = "None";
    String msgRx = "";
    String msgTx = "";
    int nextMillis = 0;
    int period;
    int phase;
    int pingON = 1;
    int qPhase;
    int quiverFlag;
    int qVal;
    int refreshFlag = 1;
    int servoMin;
    int servoMax;
    int servoMMD;
    int servoPin;
    int servoLast = 0;
    int servoSwp;
    int servoVal;
    int servoVLL;
    int servoVUL;
    int sliderDwn;
    int TB = 0;
    int TG = 0;
    int tick = 0;
    int timeCnt;
    int TMC;
    int TR = 0;
    int upDwnFlg = 0;

    public void setup() {
        this.mON = 0;
        this.resetFlags();
        this.loadScrn(0);
        this.getCOMPort();
        this.delay(100);
        this.centreJoyX();
        Proc_Servo_Ctrl_05.println((String)"Ready!");
    }

    public void draw() {
        --this.TMC;
        if (this.TMC < 1) {
            this.TMC = 2;
            switch (this.ctrlMode) {
                case 0: {
                    if (this.quiverFlag > 0) {
                        this.doQuiver();
                        break;
                    }
                    if (this.quiverFlag >= 0) break;
                    this.setQuiverOFF();
                    break;
                }
                case 1: {
                    this.doSquare();
                    break;
                }
                case 2: {
                    this.doTriangle();
                    break;
                }
                case 3: {
                    this.doSine();
                    break;
                }
                case 4: {
                    this.doSwing();
                }
            }
        }
        if (this.mDown > 0) {
            --this.mTO;
            if (this.mTO < 1) {
                this.mouseRepeat();
                this.mTO = 4;
            }
        }
        if (this.mON > 0) {
            this.drawMouseXY();
        }
        if (this.drawFlag > 0) {
            this.background(this.img);
            this.drawChMsg();
            this.drawServoVal();
            this.drawLamps();
            this.drawLLMsg();
            this.drawULMsg();
            this.drawJoyX();
            this.drawCOMMsg();
            this.drawRxMsg();
            this.drawTxMsg();
            this.drawFreq();
            this.drawCycles();
            this.drawFlag = 0;
        }
        while (this.millis() < this.nextMillis) {
        }
        this.nextMillis = this.millis() + this.interval;
        if (this.pingON > 0) {
            --this.tick;
            if (this.tick < 1) {
                this.tick = 50;
                this.usbPortWrite("~");
            }
        }
    }

    public void keyPressed() {
        this.keyDwn = 1;
    }

    public void keyReleased() {
        this.keyDwn = 0;
    }

    public void mouseDragged() {
        this.mX = this.mouseX;
        this.mY = this.mouseY;
        if (this.sliderDwn > 0 && this.mX >= 150 && this.mX <= 650) {
            this.readXSlider();
        }
    }

    public void mouseMoved() {
        this.mX = this.mouseX;
        this.mY = this.mouseY;
    }

    public void mousePressed() {
        this.mDown = 1;
        this.mTO = 30;
        if (this.mX < 26 && this.mY < 26) {
            this.toggleMouseON();
        }
        if (this.mX > 198 && this.mX < 552 && this.mY > 63 && this.mY < 144) {
            this.sendPin();
        }
        if (this.mX > 575 && this.mX < 664) {
            if (this.mY > 63 && this.mY < 104) {
                this.setAngleMode(0);
            }
            if (this.mY > 103 && this.mY < 144) {
                this.setAngleMode(1);
            }
        }
        if (this.mX > 672 && this.mX < 760 && this.mY > 103 && this.mY < 144) {
            this.togglePing();
        }
        if (this.mX >= 136 && this.mX < 155 && this.mY >= 162 && this.mY <= 196) {
            this.decXSlider();
        }
        if (this.mX > 645 && this.mX <= 663 && this.mY >= 162 && this.mY <= 196) {
            this.incXSlider();
        }
        if (this.mX >= 155 && this.mX <= 645 && this.mY >= 162 && this.mY <= 196) {
            this.sliderDwn = 1;
            this.readXSlider();
        }
        if (this.mY > 163 && this.mY < 195) {
            if (this.mX > 34 && this.mX < 52) {
                this.setLLValDwn();
            }
            if (this.mX > 112 && this.mX < 129) {
                this.setLLValUp();
            }
            if (this.mX > 669 && this.mX < 686) {
                this.setULValDwn();
            }
            if (this.mX > 749 && this.mX < 764) {
                this.setULValUp();
            }
        }
        if (this.mY > 167 && this.mY <= 190) {
            if (this.mX >= 53 && this.mX <= 112) {
                this.setLL();
            }
            if (this.mX >= 686 && this.mX <= 746) {
                this.setUL();
            }
        }
        if (this.mX > 34 && this.mX < 115 && this.mY > 62 && this.mY < 144) {
            this.sendRESET();
        }
        if (this.mX > 384 && this.mX < 415 && this.mY > 198 && this.mY < 222) {
            this.centreServo();
        }
        if (this.mX > 88 && this.mX < 176 && this.mY > 231 && this.mY < 256) {
            this.getCOMPort();
        }
        if (this.mY > 277 && this.mY < 375) {
            if (this.mX > 34 && this.mX < 133) {
                this.setMode(0);
            }
            if (this.mX > 135 && this.mX < 233) {
                this.setQuiver();
            }
            if (this.mX > 235 && this.mX < 334) {
                this.setMode(1);
            }
            if (this.mX > 336 && this.mX < 435) {
                this.setMode(2);
            }
            if (this.mX > 437 && this.mX < 536) {
                this.setMode(3);
            }
            if (this.mX > 537 && this.mX < 636) {
                this.setMode(4);
            }
        }
        if (this.mY > 295 && this.mY < 328) {
            if (this.mX > 669 && this.mX < 686) {
                this.decPeriod();
            }
            if (this.mX > 685 && this.mX < 748) {
                this.period = 20;
                this.drawFlag = 1;
            }
            if (this.mX > 747 && this.mX < 764) {
                this.incPeriod();
            }
        }
        if (this.mX > 669 && this.mX < 764 && this.mY > 333 && this.mY < 359) {
            this.cycles = 0;
            this.drawFlag = 0;
        }
    }

    public void mouseReleased() {
        this.mX = this.mouseX;
        this.mY = this.mouseY;
        this.mDown = 0;
        this.sliderDwn = 0;
    }

    public void mouseRepeat() {
        this.mX = this.mouseX;
        this.mY = this.mouseY;
        if (this.sliderDwn < 1) {
            if (this.mX >= 136 && this.mX < 155 && this.mY >= 162 && this.mY <= 196) {
                this.decXSlider();
            }
            if (this.mX > 645 && this.mX <= 663 && this.mY >= 162 && this.mY <= 196) {
                this.incXSlider();
            }
            if (this.mY > 163 && this.mY < 195) {
                if (this.mX > 34 && this.mX < 52) {
                    this.setLLValDwn();
                }
                if (this.mX > 112 && this.mX < 129) {
                    this.setLLValUp();
                }
                if (this.mX > 669 && this.mX < 686) {
                    this.setULValDwn();
                }
                if (this.mX > 749 && this.mX < 764) {
                    this.setULValUp();
                }
            }
        }
        if (this.mY > 295 && this.mY < 328) {
            if (this.mX > 669 && this.mX < 686) {
                this.decPeriod();
            }
            if (this.mX > 747 && this.mX < 764) {
                this.incPeriod();
            }
        }
    }

    public void serialEvent(Serial usbPort) {
        this.data = usbPort.readStringUntil(this.LF);
        this.msgRx = Proc_Servo_Ctrl_05.trim((String)this.data);
        this.data = "";
        Proc_Servo_Ctrl_05.println((String)this.msgRx);
        this.drawFlag = 1;
    }

    public void calcQV() {
        this.qVal = (this.servoVUL - this.servoVLL) / 45;
    }

    public void centreJoyX() {
        this.servoVal = this.servoVLL + (this.servoVUL - this.servoVLL) / 2;
        this.setXSlider();
        this.drawFlag = 1;
    }

    public void centreServo() {
        this.centreJoyX();
        this.servoLast = this.servoVal;
        this.sendAngle();
    }

    public void decPeriod() {
        if (this.period > 10) {
            --this.period;
            this.drawFlag = 1;
        }
    }

    public void decXSlider() {
        if (this.servoVal > this.servoVLL) {
            this.servoLast = this.servoVal--;
            if (this.angleMode <= 0) {
                this.zF = this.servoVal;
                this.zF = 0.27f + (this.zF - 1000.0f) * 180.0f / 1000.0f;
                this.zF -= 1.0f;
                this.servoVal = PApplet.parseInt((float)(this.zF * 1000.0f / 180.0f)) + 1000;
                this.servoVal = Proc_Servo_Ctrl_05.max((int)this.servoVal, (int)this.servoVLL);
            }
            this.setXSlider();
            this.sendAngle();
        }
    }

    public void doQuiver() {
        --this.quiverFlag;
        if (this.quiverFlag < 1) {
            this.quiverFlag = 5;
            if (this.qPhase < 1) {
                this.qPhase = 1;
                this.msgTx = "SM" + Proc_Servo_Ctrl_05.str((int)(this.servoVal + this.qVal)) + ".";
            } else {
                this.qPhase = 0;
                this.msgTx = "SM" + Proc_Servo_Ctrl_05.str((int)(this.servoVal - this.qVal)) + ".";
            }
            this.usbPortWrite(this.msgTx);
            this.drawFlag = 1;
        }
    }

    public void doSine() {
        float zHA = (float)(this.servoVUL - this.servoVLL) / 2.0f;
        float zMP = zHA + (float)this.servoVLL;
        --this.timeCnt;
        if (this.timeCnt < 1) {
            this.timeCnt = this.period;
            if (this.phase < 1) {
                this.phase = 1;
            } else {
                this.phase = 0;
                ++this.cycles;
            }
        }
        this.zF = this.phase < 1 ? zMP + zHA * Proc_Servo_Ctrl_05.sin((float)((float)(this.period - this.timeCnt) * 3.14f / (float)this.period)) : zMP - zHA * Proc_Servo_Ctrl_05.sin((float)((float)this.timeCnt * 3.14f / (float)this.period));
        this.servoVal = PApplet.parseInt((float)this.zF);
        this.setXSlider();
        this.sendAngle();
        this.drawFlag = 1;
    }

    public void doSquare() {
        --this.timeCnt;
        if (this.timeCnt < 1) {
            this.timeCnt = this.period;
            if (this.phase < 1) {
                this.phase = 1;
                this.servoVal = this.servoVUL;
            } else {
                this.phase = 0;
                this.servoVal = this.servoVLL;
                ++this.cycles;
            }
            this.setXSlider();
            this.sendAngle();
            this.drawFlag = 1;
        }
    }

    public void doSwing() {
        --this.timeCnt;
        if (this.timeCnt == this.period / 2) {
            this.servoVal = this.servoVLL + (this.servoVUL - this.servoVLL) / 2;
            this.setXSlider();
            this.sendAngle();
            this.drawFlag = 1;
        }
        if (this.timeCnt < 1) {
            this.timeCnt = this.period;
            if (this.phase < 1) {
                this.phase = 1;
                this.servoVal = this.servoVUL;
            } else {
                this.phase = 0;
                this.servoVal = this.servoVLL;
                ++this.cycles;
            }
            this.setXSlider();
            this.sendAngle();
            this.drawFlag = 1;
        }
    }

    public void doTriangle() {
        --this.timeCnt;
        if (this.timeCnt < 1) {
            this.timeCnt = this.period;
            if (this.phase < 1) {
                this.phase = 1;
            } else {
                this.phase = 0;
                ++this.cycles;
            }
        }
        this.servoVal = this.phase < 1 ? (this.servoVUL - this.servoVLL) * (this.period - this.timeCnt) / this.period + this.servoVLL : (this.servoVUL - this.servoVLL) * this.timeCnt / this.period + this.servoVLL;
        this.setXSlider();
        this.sendAngle();
        this.drawFlag = 1;
    }

    public void drawChMsg() {
        if (this.servoPin < 0) {
            this.TR = 255;
        }
        this.drawTxtField("    ", 462, 34);
        this.drawTxtField(this.msgCh, 462, 34);
        this.TR = 0;
    }

    public void drawCOMMsg() {
        if (this.comFlag < 1) {
            this.TR = 255;
        }
        this.drawTxtField(this.msgCOM, 95, 237);
        this.TR = 0;
    }

    public void drawCycles() {
        if (this.ctrlMode < 1) {
            this.TR = 255;
        }
        this.drawTxtField("              ", 676, 339);
        this.drawTxtField(Proc_Servo_Ctrl_05.str((int)this.cycles), 676, 339);
        this.TR = 0;
    }

    public void drawFreq() {
        if (this.ctrlMode < 1) {
            this.TR = 255;
        }
        this.drawTxtField(Proc_Servo_Ctrl_05.str((int)this.period), 695, 305);
        this.TR = 0;
    }

    public void drawJoyX() {
        int zXw = 20;
        this.stroke(0.0f, 0.0f, 0.0f);
        this.strokeWeight(2.0f);
        this.fill(255.0f, 255.0f, 255.0f);
        this.rect(this.JoyXval - zXw, 159.0f, zXw + zXw, 40.0f);
    }

    public void drawLamps() {
        this.fill(20.0f, 210.0f, 0.0f);
        this.stroke(0.0f, 0.0f, 0.0f);
        this.strokeWeight(1.0f);
        if (this.angleMode < 1) {
            this.rect(649.0f, 69.0f, 9.0f, 29.0f);
        } else {
            this.rect(649.0f, 109.0f, 9.0f, 29.0f);
        }
        if (this.pingON > 0) {
            this.rect(745.0f, 109.0f, 9.0f, 29.0f);
        }
        this.fill(255.0f, 50.0f, 0.0f);
        switch (this.ctrlMode) {
            case 0: {
                this.ellipse(116.0f, 296.0f, 21.0f, 21.0f);
                if (this.quiverFlag <= 0 || this.qPhase <= 0) break;
                this.fill(0.0f, 100.0f, 255.0f);
                this.ellipse(216.0f, 296.0f, 21.0f, 21.0f);
                break;
            }
            case 1: {
                this.ellipse(317.0f, 296.0f, 21.0f, 21.0f);
                break;
            }
            case 2: {
                this.ellipse(418.0f, 296.0f, 21.0f, 21.0f);
                break;
            }
            case 3: {
                this.ellipse(518.0f, 296.0f, 21.0f, 21.0f);
                break;
            }
            case 4: {
                this.ellipse(619.0f, 296.0f, 21.0f, 21.0f);
            }
        }
    }

    public void drawLLMsg() {
        if (this.angleMode < 1) {
            this.TR = 255;
        }
        this.drawTxtField("    ", 66, 172);
        if (this.angleMode > 0) {
            this.drawTxtField(Proc_Servo_Ctrl_05.str((int)this.servoVLL), 66, 172);
            this.TR = 0;
        } else {
            this.drawTxtField(Proc_Servo_Ctrl_05.str((int)(PApplet.parseInt((float)((this.servoVLL - this.servoVLL) * 180)) / (this.servoVUL - this.servoVLL))), 66, 172);
            this.TR = 0;
        }
        this.TR = 0;
    }

    public void drawMouseXY() {
        this.mX = this.mouseX;
        this.mY = this.mouseY;
        this.fill(200.0f, 200.0f, 200.0f);
        this.rect(10.0f, 8.0f, 50.0f, 30.0f);
        this.fill(0.0f, 0.0f, 0.0f);
        this.text("X=" + this.mX, 12.0f, 20.0f);
        this.text("Y=" + this.mY, 12.0f, 34.0f);
    }

    public void drawRxMsg() {
        this.drawTxtField("                                                       ", 246, 237);
        this.drawTxtField(this.msgRx, 246, 237);
    }

    public void drawServoVal() {
        this.drawTxtField("         ", 561, 34);
        if (this.angleMode > 0) {
            this.drawTxtField(Proc_Servo_Ctrl_05.str((int)this.servoVal), 561, 34);
        } else {
            this.drawTxtField(Proc_Servo_Ctrl_05.str((int)(PApplet.parseInt((float)((this.servoVal - this.servoVLL) * 180)) / (this.servoVUL - this.servoVLL))), 561, 34);
        }
    }

    public void drawTxMsg() {
        this.drawTxtField("                                                      ", 540, 237);
        this.drawTxtField(this.msgTx, 540, 237);
    }

    public void drawTxtField(String zM, int zX, int zY) {
        this.stroke(242.0f, 242.0f, 242.0f);
        this.fill(242.0f, 242.0f, 242.0f);
        this.rect(zX, zY, 8.0f + this.textWidth(zM), 14.0f);
        this.fill(this.TR, this.TG, this.TB);
        this.text(zM, zX + 4, zY + 12);
    }

    public void drawULMsg() {
        if (this.angleMode < 1) {
            this.TR = 255;
        }
        this.drawTxtField("    ", 701, 172);
        if (this.angleMode > 0) {
            this.drawTxtField(Proc_Servo_Ctrl_05.str((int)this.servoVUL), 701, 172);
            this.TR = 0;
        } else {
            this.drawTxtField(Proc_Servo_Ctrl_05.str((int)(PApplet.parseInt((float)((this.servoVUL - this.servoVLL) * 180)) / (this.servoVUL - this.servoVLL))), 701, 172);
            this.TR = 0;
        }
        this.TR = 0;
    }

    public void exit() {
        this.usbPortWrite("!");
        this.delay(20);
        super.exit();
    }

    public void getCOMPort() {
        if (this.comFlag > 0) {
            this.usbPort.stop();
            this.comFlag = 0;
            this.msgCOM = "----";
            this.delay(100);
        }
        this.comListLength = Serial.list().length;
        if (this.comListLength > 0) {
            ++this.comPnt;
            if (this.comPnt >= this.comListLength) {
                this.comPnt = 0;
            }
            this.comName = Serial.list()[this.comPnt];
            Proc_Servo_Ctrl_05.println((String)this.comName);
            try {
                this.usbPort = new Serial((PApplet)this, this.comName, 19200);
                this.usbPort.bufferUntil(this.LF);
                this.comFlag = 1;
                this.msgCOM = this.comName;
            }
            catch (Exception exception) {
                this.comFlag = 0;
                this.msgCOM = "-Error-";
            }
        } else {
            this.comFlag = 0;
            this.msgCOM = "-NA-";
        }
        this.refreshFlag = 1;
    }

    public void incPeriod() {
        ++this.period;
        this.drawFlag = 1;
    }

    public void incXSlider() {
        if (this.servoVal < this.servoVUL) {
            this.servoLast = this.servoVal++;
            if (this.angleMode <= 0) {
                this.zF = this.servoVal;
                this.zF = 0.27f + (this.zF - 1000.0f) * 180.0f / 1000.0f;
                this.zF += 1.0f;
                this.servoVal = PApplet.parseInt((float)(this.zF * 1000.0f / 180.0f)) + 1000;
                this.servoVal = Proc_Servo_Ctrl_05.min((int)this.servoVal, (int)this.servoVUL);
            }
            this.setXSlider();
            this.sendAngle();
        }
    }

    public void loadScrn(int zMode) {
        if (zMode == 0) {
            this.img = this.loadImage("Control Pad.png");
        }
        this.drawFlag = 1;
    }

    public void readXSlider() {
        this.JoyXval = this.mX;
        this.JoyXval = Proc_Servo_Ctrl_05.max((int)this.JoyXval, (int)this.JoyX0);
        this.JoyXval = Proc_Servo_Ctrl_05.min((int)this.JoyXval, (int)this.JoyX1);
        this.servoVal = this.servoVLL + (this.JoyXval - this.JoyX0) * (this.servoVUL - this.servoVLL) / (this.JoyX1 - this.JoyX0);
        this.servoVal = Proc_Servo_Ctrl_05.max((int)this.servoVal, (int)this.servoVLL);
        this.servoVal = Proc_Servo_Ctrl_05.min((int)this.servoVal, (int)this.servoVUL);
        if (this.servoLast != this.servoVal) {
            this.servoLast = this.servoVal;
            this.sendAngle();
        }
        this.servoLast = this.servoVal;
    }

    public void resetFlags() {
        this.angleMode = 1;
        this.ctrlMode = 0;
        this.cycles = 0;
        this.msgCh = "---";
        this.mTO = 0;
        this.period = 60;
        this.phase = 0;
        this.qPhase = 0;
        this.quiverFlag = 0;
        this.qVal = 100;
        this.servoMin = 400;
        this.servoMax = 2600;
        this.servoMMD = this.servoMax - this.servoMin;
        this.servoPin = -1;
        this.servoSwp = 0;
        this.servoVal = 1472;
        this.servoVLL = 400;
        this.servoVUL = 2600;
        this.sliderDwn = 0;
        this.timeCnt = 0;
        this.TMC = 0;
        this.centreJoyX();
    }

    public void sendAngle() {
        this.msgTx = this.angleMode > 0 ? "SM" + Proc_Servo_Ctrl_05.str((int)this.servoVal) + "." : "SA" + Proc_Servo_Ctrl_05.str((int)(PApplet.parseInt((float)((this.servoVal - this.servoVLL) * 180)) / (this.servoVUL - this.servoVLL))) + ".";
        this.usbPortWrite(this.msgTx);
        this.drawFlag = 1;
    }

    public void sendButton(String zS) {
        this.msgTx = zS;
        this.usbPortWrite(this.msgTx);
        this.drawFlag = 1;
    }

    public void sendLL() {
        this.msgTx = "SL" + Proc_Servo_Ctrl_05.str((int)this.servoVLL) + ".";
        this.usbPortWrite(this.msgTx);
        this.drawFlag = 1;
    }

    public void sendPin() {
        int zPin = (this.mX - 199) / 50;
        if (this.mY > 104) {
            zPin += 7;
        }
        if (this.servoPin != zPin) {
            this.sendLL();
            this.sendUL();
            this.msgCh = Proc_Servo_Ctrl_05.str((int)zPin);
            this.sendButton("SP" + Proc_Servo_Ctrl_05.str((int)zPin) + ".");
            this.servoPin = zPin;
        } else {
            this.msgCh = "---";
            this.sendButton("SD.");
            this.servoPin = -1;
        }
        this.drawFlag = 1;
    }

    public void sendRESET() {
        this.msgTx = "!";
        this.usbPortWrite(this.msgTx);
        this.resetFlags();
        this.drawFlag = 1;
    }

    public void sendUL() {
        this.msgTx = "SU" + Proc_Servo_Ctrl_05.str((int)this.servoVUL) + ".";
        this.usbPortWrite(this.msgTx);
        this.drawFlag = 1;
    }

    public void setAngleMode(int zA) {
        this.angleMode = zA;
        this.drawFlag = 1;
    }

    public void setLL() {
        this.servoVLL = this.servoVal;
        this.setXSlider();
        this.sendLL();
        this.calcQV();
    }

    public void setLLValDwn() {
        if (this.angleMode > 0) {
            --this.servoVLL;
            this.servoVLL = Proc_Servo_Ctrl_05.max((int)this.servoMin, (int)this.servoVLL);
            this.setXSlider();
            this.sendLL();
            this.calcQV();
        }
    }

    public void setLLValUp() {
        if (this.angleMode > 0) {
            ++this.servoVLL;
            if (this.servoVLL > this.servoVUL) {
                this.servoVUL = this.servoVLL;
            }
            this.servoVLL = Proc_Servo_Ctrl_05.min((int)this.servoMax, (int)this.servoVLL);
            this.servoVUL = Proc_Servo_Ctrl_05.min((int)this.servoMax, (int)this.servoVUL);
            this.setXSlider();
            this.sendLL();
            this.calcQV();
        }
    }

    public void setMode(int zM) {
        this.phase = 0;
        this.period = 60;
        switch (zM) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
        }
        this.ctrlMode = zM;
        this.drawFlag = 1;
    }

    public void setQuiver() {
        if (this.ctrlMode == 0) {
            if (this.quiverFlag < 1) {
                this.quiverFlag = 1;
                this.qPhase = 0;
                this.calcQV();
            } else {
                this.quiverFlag = -1;
                this.msgTx = "SM" + Proc_Servo_Ctrl_05.str((int)this.servoVal) + ".";
            }
        }
        this.drawFlag = 1;
    }

    public void setQuiverOFF() {
        this.quiverFlag = 0;
        this.msgTx = "SM" + Proc_Servo_Ctrl_05.str((int)this.servoVal) + ".";
        this.usbPortWrite(this.msgTx);
        this.drawFlag = 1;
    }

    public void setUL() {
        this.servoVUL = this.servoVal;
        this.setXSlider();
        this.sendUL();
        this.calcQV();
    }

    public void setULValDwn() {
        if (this.angleMode > 0) {
            --this.servoVUL;
            if (this.servoVUL < this.servoVLL) {
                this.servoVLL = this.servoVUL;
            }
            this.servoVLL = Proc_Servo_Ctrl_05.max((int)this.servoVLL, (int)this.servoMin);
            this.servoVUL = Proc_Servo_Ctrl_05.max((int)this.servoVUL, (int)this.servoMin);
            this.setXSlider();
            this.sendUL();
            this.calcQV();
        }
    }

    public void setULValUp() {
        if (this.angleMode > 0) {
            ++this.servoVUL;
            this.servoVUL = Proc_Servo_Ctrl_05.min((int)this.servoMax, (int)this.servoVUL);
            this.setXSlider();
            this.sendUL();
            this.calcQV();
        }
    }

    public void setXSlider() {
        int zVal = this.servoVal;
        this.servoVal = Proc_Servo_Ctrl_05.min((int)this.servoVal, (int)this.servoVUL);
        this.servoVal = Proc_Servo_Ctrl_05.max((int)this.servoVal, (int)this.servoVLL);
        if (this.servoVUL > this.servoVLL) {
            this.JoyXval = 170 + (this.servoVal - this.servoVLL) * 460 / (this.servoVUL - this.servoVLL);
        }
        this.JoyXval = Proc_Servo_Ctrl_05.max((int)170, (int)this.JoyXval);
        this.JoyXval = Proc_Servo_Ctrl_05.min((int)630, (int)this.JoyXval);
        if (zVal != this.servoVal) {
            this.servoLast = this.servoVal;
            this.sendAngle();
        }
        this.drawFlag = 1;
    }

    public void toggleMouseON() {
        this.mON = this.mON > 0 ? 0 : 1;
        this.drawFlag = 1;
    }

    public void togglePing() {
        this.pingON = this.pingON > 0 ? 0 : 1;
        this.drawFlag = 1;
    }

    public void usbPortWrite(String zmsg) {
        if (this.comFlag > 0) {
            this.usbPort.write(zmsg);
        }
    }

    public void settings() {
        this.size(800, 408);
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"Proc_Servo_Ctrl_05"};
        if (passedArgs != null) {
            PApplet.main((String[])Proc_Servo_Ctrl_05.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }
}

