
// ----------------------------------------------------------------------

//void AddToAngles(int zA1,int zA2,int zA3,int zA4,int zA5,int zA6,int zA7,int zA8, int zCnt) {
//  // add a +/-90 angle to current servo angles, or 0 means no change
//  // number of 20ms steps in movement set by zCnt
//  if (ESC) return; // exit if this flag is set
//  if (!servoEn) {attachServos(0);}
//  if (zA1 != 0) {anyVal = map(zA1,0,90,Ang1_45,Ang1_135); servoTgt[0] = servoVal[0] + anyVal;}
//  if (zA2 != 0) {anyVal = map(zA1,0,90,Ang1_45,Ang1_135); servoTgt[1] = servoVal[1] + anyVal;}
//  if (zA3 != 0) {anyVal = map(zA1,0,90,Ang1_45,Ang1_135); servoTgt[2] = servoVal[2] + anyVal;}
//  if (zA4 != 0) {anyVal = map(zA1,0,90,Ang1_45,Ang1_135); servoTgt[3] = servoVal[3] + anyVal;}
//  if (zA5 != 0) {anyVal = map(zA1,0,90,Ang1_45,Ang1_135); servoTgt[4] = servoVal[4] + anyVal;}
//  if (zA6 != 0) {anyVal = map(zA1,0,90,Ang1_45,Ang1_135); servoTgt[5] = servoVal[5] + anyVal;}
//  if (zA7 != 0) {anyVal = map(zA1,0,90,Ang1_45,Ang1_135); servoTgt[6] = servoVal[6] + anyVal;}
//  if (zA8 != 0) {anyVal = map(zA1,0,90,Ang1_45,Ang1_135); servoTgt[7] = servoVal[7] + anyVal;}
//  checkTgts(); // ensure target values are within limits
//  tgtCnt = zCnt;
////  Serial.println(F("AddToAngles Set"));
//}

// ----------------------------------------------------------------------

void DemoMove_Bow() {
  // bow movement used to introduce demo move
  SetLedMode(1);
  MoveToAngles(90,LegDn,90,LegDn,90,LegDn,90,LegDn);
  GoToAngles(45,120,45,120,90,90,90,90,50); loopWhiletgtCnt();
  GoToAngles(90,173,90,173,-1,-1,-1,-1,60); loopWhiletgtCnt();
  delayLoop(1000); // pause
  GoToAngles(45,120,45,120,-1,-1,-1,-1,30); loopWhiletgtCnt();
  GoToAngles(90,90,90,90,-1,-1,-1,-1,30); loopWhiletgtCnt();
  SetLedMode(0);
}

// ----------------------------------------------------------------------

//void DemoMove_PressUps() {
//  // do five pressups
//  SetLedMode(1); anyFor = 120;
//  MoveToAngles(90,LegDn,90,LegDn,90,LegDn,90,LegDn);
//  GoToAngles(135,90,135,90,45,160,45,160,20); loopWhiletgtCnt();
//  delayLoop(1000); // pause
//  while (anyFor < 130) {
//    GoToAngles(-1,anyFor,-1,anyFor,-1,-1,-1,-1,20); loopWhiletgtCnt();
//    delayLoop(100); // pause
//    GoToAngles(-1,90,-1,90,-1,-1,-1,-1,20); loopWhiletgtCnt();
//    delayLoop(100); anyFor += 2; // pause
//  }
//  GoToStand(25); loopWhiletgtCnt();
//  SetLedMode(0);
//}

// ----------------------------------------------------------------------

void DemoMove_SitNWave() {
  // sit and wave the right hand
  SetLedMode(1);
  MoveToAngles(90,LegDn,90,LegDn,90,LegDn,90,LegDn);
  GoToAngles(90,90,90,90,145,145,145,145,50); loopWhiletgtCnt();
  LedMode = 0; delayLoop(1000); // pause
  LedMode = 1; GoToAngles(90,90,80,160,145,145,145,145,20); loopWhiletgtCnt();
  LedMode = 0; delayLoop(200); SetLedMode(4); // pause
  for (anyFor=0; anyFor<2; anyFor++) {
    GoToAngles(90,90,60,180,145,145,145,145,3); loopWhiletgtCnt();
    GoToAngles(90,90,40,150,145,145,145,145,3); loopWhiletgtCnt();
    delayLoop(100); // pause
    GoToAngles(90,90,60,180,145,145,145,145,3); loopWhiletgtCnt();
    GoToAngles(90,90,80,150,145,145,145,145,3); loopWhiletgtCnt();
    delayLoop(100); // pause
  }
  LedMode = 0; delayLoop(1000); // pause
   SetLedMode(3); GoToAngles(90,90,90,90,145,145,145,145,50); loopWhiletgtCnt();
  LedMode = 0; delayLoop(1000); // pause
   SetLedMode(3);GoToStand(50); loopWhiletgtCnt();
  LedMode = 0;
}

// ----------------------------------------------------------------------

//void DemoMove_TurnRight(int zAng,int zStep1,int zStep2,int zSpeed) {
//  // performs a demo turn to the right, returning at twice the speed
//  SetLedMode(2);
//  TurnRight(zAng,zStep1,zSpeed); loopWhiletgtCnt();
//  LedMode = 0; delayLoop(100 + random(900)); // pause
//  SetLedMode(4); TurnLeft(zAng,zStep2,zSpeed/2); loopWhiletgtCnt();
//  LedMode = 0;
//}

// ----------------------------------------------------------------------

//void DemoMove_TurnLeft(int zAng,int zStep1,int zStep2,int zSpeed) {
//  // performs a demo turn to the right, returning at twice the speed
//  SetLedMode(4);
//  TurnLeft(zAng,zStep1,zSpeed); loopWhiletgtCnt();
//  LedMode = 0; delayLoop(100 + random(900)); // pause
//  SetLedMode(2); TurnRight(zAng,zStep2,zSpeed/2); loopWhiletgtCnt();
//  LedMode = 0;
//}

// ----------------------------------------------------------------------

//void DemoMove_Twist() {
//  // twist side to side
//  SetLedMode(1); anyFor = 60;
//  MoveToAngles(90,LegDn,90,LegDn,90,LegDn,90,LegDn);
//  GoToAngles(135,90,45,90,135,90,45,90,50); loopWhiletgtCnt();
//  while (anyFor >= 10) {
//    SetLedMode(2); GoToAngles(45,-1,135,-1,45,-1,135,-1,anyFor); loopWhiletgtCnt();
//    delayLoop(100); anyFor -= 5; // pause
//    SetLedMode(4); GoToAngles(135,90,45,90,135,90,45,90,anyFor); loopWhiletgtCnt();
//    delayLoop(100); anyFor -= 5; // pause
//  }
//  SetLedMode(2); GoToAngles(45,-1,135,-1,45,-1,135,-1,20); loopWhiletgtCnt();
//  delayLoop(100); // pause
//  SetLedMode(4); GoToAngles(135,90,45,90,135,90,45,90,35); loopWhiletgtCnt();
//  delayLoop(100);// pause
//  SetLedMode(1); GoToAngles(90,-1,90,-1,90,-1,90,-1,25); loopWhiletgtCnt();
//  LedMode = 0;
//}

// ----------------------------------------------------------------------

//void DemoMove_Walk(int zWalk, int zSteps, int zSpeed) {
//  // perform a demo walk in direction zWalk (1-4), returning at twice the speed
//  // if zWalk is -ve don't do the returning part
//  // note there are 88 steps in a walk cycle
//  // zSpeed is the period, normally 20000, suggest 10000 - 60000 range
//  SetLedMode(zWalk);
//  walkInterval = zSpeed; StartWalk(abs(zWalk)); // initiate the walk
//  loopWhileWalk(zSteps); Walk = 0; // wait then stop
//  LedMode = 0; delayLoop(100);// pause
//  if (zWalk > 0) {
//    // reverse direction
//    switch (zWalk) {
//      case 1: zWalk = 3; break;
//      case 2: zWalk = 4; break;
//      case 3: zWalk = 1; break;
//      case 4: zWalk = 2; break;
//    } walkInterval = zSpeed/2; StartWalk(zWalk);
//     SetLedMode(zWalk); loopWhileWalk(zSteps); Walk = 0; 
//  } walkInterval = 20000; // set speed at default
//  LedMode = 0;
//}

// ----------------------------------------------------------------------

void GoToAngles(int zA1,int zA2,int zA3,int zA4,int zA5,int zA6,int zA7,int zA8, int zCnt) {
  // move to specific servo angles, or -1 means no change
  // number of 20ms steps in movement set by zCnt
  if (ESC) return; // exit if this flag is set
  if (!servoEn) {attachServos(0);}
  if (zA1 >= 0) {servoTgt[0] = map(zA1,45,135,Ang1_45,Ang1_135);}
  if (zA2 >= 0) {servoTgt[1] = map(zA2,65,153,Ang2_65,Ang2_153);}
  if (zA3 >= 0) {servoTgt[2] = map(zA3,45,135,Ang3_45,Ang3_135);}
  if (zA4 >= 0) {servoTgt[3] = map(zA4,65,153,Ang4_65,Ang4_153);}
  if (zA5 >= 0) {servoTgt[4] = map(zA5,45,135,Ang5_45,Ang5_135);}
  if (zA6 >= 0) {servoTgt[5] = map(zA6,65,153,Ang6_65,Ang6_153);}
  if (zA7 >= 0) {servoTgt[6] = map(zA7,45,135,Ang7_45,Ang7_135);}
  if (zA8 >= 0) {servoTgt[7] = map(zA8,65,153,Ang8_65,Ang8_153);}
  checkTgts(); // ensure target values are within limits
  tgtCnt = zCnt;
//  Serial.println(F("GoToAngles Set"));
}

// ----------------------------------------------------------------------

//void GoToFloor(int zCnt) {
//  // move to the floor lying position
//  // number of 20ms steps in movement set by zCnt
//  if (ESC) return;
////  Serial.println(F("> GoToFloor()"));
//  GoToAngles(90,153,90,153,90,153,90,153,zCnt); // go to the resting position
//}

// ----------------------------------------------------------------------

void GoToRest(int zCnt) {
  // move to the resting position
  // number of 20ms steps in movement set by zCnt
  if (ESC) return;
//  Serial.println(F("> GoToRest()"));
  GoToAngles(65,65,65,65,65,65,65,65,zCnt); // go to the resting position
}

// ----------------------------------------------------------------------

void GoToStand(int zCnt) {
  // move to the normal standing position
  // number of 20ms steps in movement set by zCnt
  if (ESC) return;
//  Serial.println(F("> GoToStand()"));
  GoToAngles(90,90,90,90,90,90,90,90,zCnt); // go to the resting position
}

// ----------------------------------------------------------------------

//void GoToStandAndWait() {
//  // move to normal standing position, then wait between 300ms - 1s
//  GoToStand(50); loopWhiletgtCnt();
//  delayLoop(300 + random(700)); // pause
//}

// ----------------------------------------------------------------------

void JoyMoveBwd() {
  // called from main loop to respond to joystick demands
  // this function walks and steers in a backwards direction
  WalkLftDrive = 128; WalkRgtDrive = 128;
  if (Walk == 0) {
    // the start of a new walk movement
    if (WalkLast != 3) {
      // previously walking in a different direction
      Serial.println(F("Walking Backwards"));
      walkInterval = 60000; StartWalk(3);
    } else {
      // continue walking in same direction
      SetLegsPrevious(); Walk = WalkLast;
    } JoyYi = 0; JoyYT = true; SetLedMode(3);
  } else {
    // ensure joystick values are in the required range
    if (JoyX < 127) {JoyXV = 128 - JoyX;} // convert -ve vector to +ve
    else {JoyXV = JoyX - 127;} // ensure JoyX = 0 - 128
    if (JoyY < 128) {JoyYV = 128 - JoyY;} // convert -ve vector to +ve
    else {JoyYV = JoyY - 127;} // ensure JoyY = 0 - 128
    JoySpd = JoyYV; if (JoyXV > JoyYV) {JoySpd = JoyXV;}
    // we use the larger of the two joystick values to set the speed
    // JoyYi is a tracking filter to slug the initial joystick response
    if (JoyYT) {
      // initially slug the response until it catches up
      if (JoyYi < (JoySpd-2)) {JoyYi += 2;}
      else if (JoyYi > (JoySpd+2)) {JoyYi -= 2;}
      else {JoyYi = JoySpd; JoyYT = false;}
    } else {JoyYi = JoySpd;}
    walkInterval = map((unsigned long)JoyYi,0,128,1,WalkMax);
    walkInterval = 60000/walkInterval;
    // now apply steering
    if (JoyX <= 127) {WalkLftDrive = JoyX + 1;}
    if (JoyX > 127) {WalkRgtDrive = 127-(JoyX-128);}
  }
}

// ----------------------------------------------------------------------

void JoyMoveFwd() {
  // called from main loop to respond to joystick demands
  // this function walks and steers in a backwards direction
  WalkLftDrive = 128; WalkRgtDrive = 128;
  if (Walk == 0) {
    // the start of a new walk movement
    if (WalkLast != 1) {
      // previously walking in a different direction
      Serial.println(F("Walking Forwards"));
      walkInterval = 60000; StartWalk(1);
    } else {
      // continue walking in same direction
      SetLegsPrevious(); Walk = WalkLast;
    } JoyYi = 0; JoyYT = true; SetLedMode(1);
  } else {
    // ensure joystick values are in the required range
    if (JoyX < 127) {JoyXV = 128 - JoyX;} // convert -ve vector to +ve
    else {JoyXV = JoyX - 127;} // ensure JoyX = 0 - 128
    if (JoyY < 128) {JoyYV = 128 - JoyY;} // convert -ve vector to +ve
    else {JoyYV = JoyY - 127;} // ensure JoyY = 0 - 128
    JoySpd = JoyYV; if (JoyXV > JoyYV) {JoySpd = JoyXV;}
    // we use the larger of the two joystick values to set the speed
    // JoyYi is a tracking filter to slug the initial joystick response
    if (JoyYT) {
      // initially slug the response until it catches up
      if (JoyYi < (JoySpd-2)) {JoyYi += 2;}
      else if (JoyYi > (JoySpd+2)) {JoyYi -= 2;}
      else {JoyYi = JoySpd; JoyYT = false;}
    } else {JoyYi = JoySpd;}
    walkInterval = map((unsigned long)JoyYi,0,128,1,WalkMax);
    walkInterval = 60000/walkInterval;
    // now apply steering
    if (JoyX < 127) {WalkLftDrive = JoyX;}
    if (JoyX > 127) {WalkRgtDrive = 127-(JoyX-128);}
  }
}

// ----------------------------------------------------------------------

void JoyMoveLft() {
  // called from main loop to respond to joystick demands
  // this function walks and steers in a leftwards direction
  WalkLftDrive = 128; WalkRgtDrive = 128;
  if (Walk == 0) {
    // the start of a new walk movement
    if (WalkLast != 4) {
      // previously walking in a different direction
      Serial.println(F("Walking Leftwards"));
      walkInterval = 60000; StartWalk(4);
    } else {
      // continue walking in same direction
      SetLegsPrevious(); Walk = WalkLast;
    } JoyYi = 0; JoyYT = true; SetLedMode(2);
  } else {
    // ensure joystick values are in the required range
    if (JoyX < 127) {JoyXV = 128 - JoyX;} // convert -ve vector to +ve
    else {JoyXV = JoyX - 127;} // ensure JoyX = 0 - 128
    if (JoyY < 128) {JoyYV = 128 - JoyY;} // convert -ve vector to +ve
    else {JoyYV = JoyY - 127;} // ensure JoyY = 0 - 128
    JoySpd = JoyYV; if (JoyXV > JoyYV) {JoySpd = JoyXV;}
    // we use the larger of the two joystick values to set the speed
    // JoyYi is a tracking filter to slug the initial joystick response
    if (JoyYT) {
      // initially slug the response until it catches up
      if (JoyYi < (JoySpd-2)) {JoyYi += 2;}
      else if (JoyYi > (JoySpd+2)) {JoyYi -= 2;}
      else {JoyYi = JoySpd; JoyYT = false;}
    } else {JoyYi = JoySpd;}
    walkInterval = map((unsigned long)JoyYi,0,128,1,WalkMax);
    walkInterval = 60000/walkInterval;
    // now apply steering set by y-axis
    if (JoyY < 127) {WalkLftDrive = JoyY;}
    if (JoyY > 127) {WalkRgtDrive = 127-(JoyY-128);}
  }
}

// ----------------------------------------------------------------------

void JoyMoveRgt() {
  // called from main loop to respond to joystick demands
  // this function walks and steers in a rightwards direction
  WalkLftDrive = 128; WalkRgtDrive = 128;
  if (Walk == 0) {
    // the start of a new walk movement
    if (WalkLast != 2) {
      // previously walking in a different direction
      Serial.println(F("Walking Rightwards"));
      walkInterval = 60000; StartWalk(2);
    } else {
      // continue walking in same direction
      SetLegsPrevious(); Walk = WalkLast;
    } JoyYi = 0; JoyYT = true; SetLedMode(4);
  } else {
    // ensure joystick values are in the required range
    if (JoyX < 127) {JoyXV = 128 - JoyX;} // convert -ve vector to +ve
    else {JoyXV = JoyX - 127;} // ensure JoyX = 0 - 128
    if (JoyY < 128) {JoyYV = 128 - JoyY;} // convert -ve vector to +ve
    else {JoyYV = JoyY - 127;} // ensure JoyY = 0 - 128
    // we use the larger of the two joystick values to set the speed
    JoySpd = JoyYV; if (JoyXV > JoyYV) {JoySpd = JoyXV;}
    // JoyYi is a tracking filter to slug the initial joystick response
    if (JoyYT) {
      // initially slug the response until it catches up
      if (JoyYi < (JoySpd-2)) {JoyYi += 2;}
      else if (JoyYi > (JoySpd+2)) {JoyYi -= 2;}
      else {JoyYi = JoySpd; JoyYT = false;}
    } else {JoyYi = JoySpd;}
    walkInterval = map((unsigned long)JoyYi,0,128,1,WalkMax);
    walkInterval = 60000/walkInterval;
    // now apply steering set by y-axis
    if (JoyY < 127) {WalkRgtDrive = JoyY;}
    if (JoyY > 127) {WalkLftDrive = 127-(JoyY-128);}
  }
}

// ----------------------------------------------------------------------

void JoyTurnLft() {
  // called from main loop to respond to joystick demands
  // this function turns in a leftwards direction
  if (Walk == 0) {
    // the start of a new walk movement
    if (WalkLast != 5) {
      // previously walking in a different direction
      Serial.println(F("Turning Left"));
      walkInterval = 60000; StartWalk(5);
    } else {
      // continue walking in same direction
      SetLegsPrevious(); Walk = WalkLast;
    } JoyYi = 0; JoyYT = true; SetLedMode(2);
  } else {
    // ensure joystick values are in the required range
    if (JoyX < 127) {JoyXV = 128 - JoyX;} // convert -ve vector to +ve
    else {JoyXV = JoyX - 127;} // ensure JoyXV = 0 - 128
    // we use the joystick value to set the speed
    JoySpd = JoyXV;
    // JoyYi is a tracking filter to slug the initial joystick response
    if (JoyYT) {
      // initially slug the response until it catches up
      if (JoyYi < (JoySpd-2)) {JoyYi += 2;}
      else if (JoyYi > (JoySpd+2)) {JoyYi -= 2;}
      else {JoyYi = JoySpd; JoyYT = false;}
    } else {JoyYi = JoySpd;}
    walkInterval = map((unsigned long)JoyYi,0,128,1,WalkMax);
    walkInterval = 60000/walkInterval;
  }
}

// ----------------------------------------------------------------------

void JoyTurnRgt() {
  // called from main loop to respond to joystick demands
  // this function turns in a rightwards direction
  if (Walk == 0) {
    // the start of a new walk movement
    if (WalkLast != 6) {
      // previously walking in a different direction
      Serial.println(F("Turning Right"));
      walkInterval = 60000; StartWalk(6);
    } else {
      // continue walking in same direction
      SetLegsPrevious(); Walk = WalkLast;
    } JoyYi = 0; JoyYT = true; SetLedMode(4);
  } else {
    // ensure joystick values are in the required range
    if (JoyX < 127) {JoyXV = 128 - JoyX;} // convert -ve vector to +ve
    else {JoyXV = JoyX - 127;} // ensure JoyXV = 0 - 128
    // we use the joystick value to set the speed
    JoySpd = JoyXV;
    // JoyYi is a tracking filter to slug the initial joystick response
    if (JoyYT) {
      // initially slug the response until it catches up
      if (JoyYi < (JoySpd-2)) {JoyYi += 2;}
      else if (JoyYi > (JoySpd+2)) {JoyYi -= 2;}
      else {JoyYi = JoySpd; JoyYT = false;}
    } else {JoyYi = JoySpd;}
    walkInterval = map((unsigned long)JoyYi,0,128,1,WalkMax);
    walkInterval = 60000/walkInterval;
  }
}

// ----------------------------------------------------------------------

//void MainTask_StandAndStretch(int zCnt) {
//  // move to the normal standing position
//  // number of 20ms steps in movement set by zCnt
//  if (MainRun) {return;}
//  MainRun = true; // prevent re-entry of task
//  Serial.println(F("> MainTask_StandAndStretch()"));
//  GoToStand(zCnt); loopWhiletgtCnt(); // stand up
//  LedMode = 0; delayLoop(500); // pause before stretching
//  SetLedMode(3); GoToAngles(-1,120,-1,120,-1,153,-1,153,zCnt); loopWhiletgtCnt(); // stretch out
//  LedMode = 0; delayLoop(500); // pause before stretching
//  SetLedMode(3); GoToAngles(-1,90,-1,90,-1,-1,-1,-1,zCnt); loopWhiletgtCnt(); // pull back front legs
//  LedMode = 0; delayLoop(500); // pause before stretching
//  SetLedMode(2); GoToAngles(135,-1,45,-1,135,-1,45,-1,zCnt); loopWhiletgtCnt(); // turn full right
//  LedMode = 0; delayLoop(500); // pause before stretching
//  SetLedMode(4); GoToAngles(45,-1,135,-1,45,-1,135,-1,zCnt); loopWhiletgtCnt(); // turn full left
//  LedMode = 0; delayLoop(500); // pause before stretching
//  SetLedMode(2); GoToAngles(90,-1,90,-1,90,-1,90,-1,zCnt); loopWhiletgtCnt(); // turn to centre
//  LedMode = 0; delayLoop(500); // pause before stretching
//  SetLedMode(1); GoToAngles(-1,-1,-1,-1,-1,90,-1,90,zCnt); loopWhiletgtCnt(); // pull back
//  LedMode = 0; autoOFF = 5;
//  MainRun = false;
//}

// ----------------------------------------------------------------------

//void MainTask_Test(int zCnt) {
//  // put test code here
//  // this is a random turning test
//  if (MainRun) {return;}
//  MainRun = true; // prevent re-entry of task
//  Serial.println(F("> MainTask_Test()"));
//  MainRun = false;
//}

// ----------------------------------------------------------------------

void MoveToAngles(int zA1,int zA2,int zA3,int zA4,int zA5,int zA6,int zA7,int zA8) {
  // move to specific servo angles by raising and lowering legs
  // number of 20ms steps in movement set by zCnt
  if (ESC) return; // exit if this flag is set
  if (!servoEn) {attachServos(0);}
  anyDel = 120;
  GoToAngles(-1,LegDn,-1,LegDn,-1,LegDn,-1,LegDn,3); loopWhiletgtCnt();
  SetAngle(10,zA1); // get the target angle in microseconds, but don't move the servo
  if (servoVal[0] != servoTgt[0]) {
    SetAngle(1,LegUp); delayLoop(anyDel); SetAngle(0,zA1); delayLoop(anyDel);
  } SetAngle(1,zA2);
  SetAngle(12,zA3); // get the target angle in microseconds, but don't move the servo
  if (servoVal[2] != servoTgt[2]) {
    SetAngle(3,LegUp); delayLoop(anyDel); SetAngle(2,zA3); delayLoop(anyDel);
  } SetAngle(3,zA4);
  SetAngle(14,zA5); // get the target angle in microseconds, but don't move the servo
  if (servoVal[4] != servoTgt[4]) {
    SetAngle(5,LegUp); delayLoop(anyDel); SetAngle(4,zA5); delayLoop(anyDel);
  } SetAngle(5,zA6);
  SetAngle(16,zA7); // get the target angle in microseconds, but don't move the servo
  if (servoVal[6] != servoTgt[6]) {
    SetAngle(7,LegUp); delayLoop(anyDel); SetAngle(6,zA7); delayLoop(anyDel);
  } SetAngle(7,zA8);  delayLoop(anyDel);
  if (autoOFF >= 0) {autoOFF = 5;} // set auto-OFF timeout
}

// ----------------------------------------------------------------------

void SetLegsDown() {
  // stores the leg positions then puts them all down on the floor
  MemStore();
  SetAngle(1,LegDn); SetAngle(3,LegDn); SetAngle(5,LegDn); SetAngle(7,LegDn);
}

// ----------------------------------------------------------------------

void SetLegsPrevious() {
  // recover stored leg positions
  MemRead(); SetToTgtNow();
}

// ----------------------------------------------------------------------

void StartWalk(int zWalk) {
  // initiates one of four walk directions
  // if zWalk is -ve then position feet but don't walk
  // 0 - stationary
  // 1 - walk forward
  // 2 - walk to the right
  // 3 - walk backwards
  // 4 - walk to the left
  // 5 - turn to the left
  // 6 - turn to the right
  Walk = 0; WalkCnt = 21; // stop walking and set start points
  switch (abs(zWalk)) {
    case 0: MoveToAngles(111,LegDn,112,LegDn,114,LegDn,113,LegDn); break;
    case 1: MoveToAngles(111,LegDn,112,LegDn,114,LegDn,113,LegDn); break;
    case 2: MoveToAngles(67,LegDn,69,LegDn,68,LegDn,66,LegDn); break;
    case 3: MoveToAngles(114,LegDn,113,LegDn,111,LegDn,112,LegDn); break;
    case 4: MoveToAngles(68,LegDn,66,LegDn,67,LegDn,69,LegDn); break;
    case 5: MoveToAngles(69,LegDn,67,LegDn,69,LegDn,67,LegDn); break;
    case 6: MoveToAngles(67,LegDn,69,LegDn,67,LegDn,69,LegDn); break;
  }
  Walk = zWalk; // start walking if Walk > 0
  if (zWalk >= 0) {
    SetLedMode(Walk);
  }
}

// ----------------------------------------------------------------------

//void TurnLeft(int zAng, int zStep, int zCnt) {
//  // neutral turn to the left by a given angle, step and speed
//  // note that speed can also be set by walkInterval loop period
//  // zStep should be >= 1 and <= 45
//  int zSwg; zStep = max(zStep,1); zStep = min(zStep,45); // ensure zStep is in range
////  Serial.print(F("> TurnRight(")); Serial.print(zAng); Serial.println(F(")"));
////  GoToAngles(90,LegDn,90,LegDn,90,LegDn,90,LegDn,zCnt); loopWhiletgtCnt(); // drop to move angle
//  MoveToAngles(90,LegDn,90,LegDn,90,LegDn,90,LegDn); loopWhiletgtCnt(); // drop to move angle
//  SetLedMode(4);
//  while (zAng > 0) {
//    // move a max of 10 degrees on each opposite leg set at a time
//    // FL and RR legs first
//    if (Turn) {zSwg = zStep; zAng = zStep;}
//    else {zSwg = min(zAng,zStep); zAng = zAng - zSwg;}
//    GoToAngles(-1,LegUp,-1,-1,-1,LegUp,-1,-1,3); loopWhiletgtCnt(); // raise FL RR legs quickly
//    delayLoop(2);
//    GoToAngles(90+zSwg,-1,-1,-1,90+zSwg,-1,-1,-1,zCnt); loopWhiletgtCnt(); // swing legs quickly
//    delayLoop(2);
//    GoToAngles(-1,LegDn,-1,-1,-1,LegDn,-1,-1,3); loopWhiletgtCnt(); // drop legs quickly
//    delayLoop(2);
//    GoToAngles(-1,-1,-1,LegUp,-1,-1,-1,LegUp,3); loopWhiletgtCnt(); // raise legs quickly
//    delayLoop(2);
//    GoToAngles(90,-1,-1,-1,90,-1,-1,-1,zCnt); loopWhiletgtCnt(); // swing legs quickly
//    delayLoop(2);
//    if (zAng < 1) {GoToAngles(-1,-1,-1,LegDn,-1,-1,-1,LegDn,3); loopWhiletgtCnt(); // drop legs quickly
//      delayLoop(2);}
//    else {
//      if (Turn) {zSwg = zStep; zAng = zStep;}
//      else {zSwg = min(zAng,zStep); zAng = zAng - zSwg;}
//      // FR and RL legs
//      GoToAngles(-1,-1,-1,LegUp,-1,-1,-1,LegUp,3); loopWhiletgtCnt(); // raise FR RL legs quickly
//      delayLoop(2);
//      GoToAngles(-1,-1,90-zSwg,-1,-1,-1,90-zSwg,-1,zCnt); loopWhiletgtCnt(); // swing legs quickly
//      delayLoop(2);
//      GoToAngles(-1,-1,-1,LegDn,-1,-1,-1,LegDn,3); loopWhiletgtCnt(); // drop legs quickly
//      delayLoop(2);
//      GoToAngles(-1,LegUp,-1,-1,-1,LegUp,-1,-1,3); loopWhiletgtCnt(); // raise legs quickly
//      delayLoop(2);
//      GoToAngles(-1,-1,90,-1,-1,-1,90,-1,zCnt); loopWhiletgtCnt(); // swing legs quickly
//      delayLoop(2);
//      if (zAng < 1) {GoToAngles(-1,LegDn,-1,-1,-1,LegDn,-1,-1,3); loopWhiletgtCnt(); // drop legs quickly
//        delayLoop(2);}
//    }
//  } SetLedMode(0);
//}

// ----------------------------------------------------------------------

//void TurnRight(int zAng, int zStep, int zCnt) {
//  // neutral turn to the right by a given angle, step and speed
//  // note that speed can also be set by walkInterval loop period
//  // zStep should be >= 1 and <= 45
//  // if zAng < 0 then don't move legs to the drop position, assume already there
//  int zSwg; zStep = max(zStep,1); zStep = min(zStep,45); // ensure zStep is in range
////  Serial.print(F("> TurnRight(")); Serial.print(zAng); Serial.println(F(")"));
////  GoToAngles(90,LegDn,90,LegDn,90,LegDn,90,LegDn,zCnt); loopWhiletgtCnt(); // drop to move angle
//  MoveToAngles(90,LegDn,90,LegDn,90,LegDn,90,LegDn); loopWhiletgtCnt(); // drop to move angle
//  SetLedMode(2);
//  while (zAng > 0) {
//    // move a max of 10 degrees on each opposite leg set at a time
//    // FR and RL legs first
//    if (Turn) {zSwg = zStep; zAng = zStep;}
//    else {zSwg = min(zAng,zStep); zAng = zAng - zSwg;}
//    GoToAngles(-1,-1,-1,LegUp,-1,-1,-1,LegUp,3); loopWhiletgtCnt(); // raise FR RL legs quickly
//    delayLoop(2);
//    GoToAngles(-1,-1,90+zSwg,-1,-1,-1,90+zSwg,-1,zCnt); loopWhiletgtCnt(); // swing legs quickly
//    delayLoop(2);
//    GoToAngles(-1,-1,-1,LegDn,-1,-1,-1,LegDn,3); loopWhiletgtCnt(); // drop legs quickly
//    delayLoop(2);
//    GoToAngles(-1,LegUp,-1,-1,-1,LegUp,-1,-1,3); loopWhiletgtCnt(); // raise legs quickly
//    delayLoop(2);
//    GoToAngles(-1,-1,90,-1,-1,-1,90,-1,zCnt); loopWhiletgtCnt(); // swing legs quickly
//    delayLoop(2);
//    if (zAng < 1) {GoToAngles(-1,LegDn,-1,-1,-1,LegDn,-1,-1,3); loopWhiletgtCnt(); // drop legs quickly
//      delayLoop(2);}
//    else {
//      if (Turn) {zSwg = zStep; zAng = zStep;}
//      else {zSwg = min(zAng,zStep); zAng = zAng - zSwg;}
//      // FL and RR legs
//      GoToAngles(-1,LegUp,-1,-1,-1,LegUp,-1,-1,3); loopWhiletgtCnt(); // raise FL RR legs quickly
//      delayLoop(2);
//      GoToAngles(90-zSwg,-1,-1,-1,90-zSwg,-1,-1,-1,zCnt); loopWhiletgtCnt(); // swing legs quickly
//      delayLoop(2);
//      GoToAngles(-1,LegDn,-1,-1,-1,LegDn,-1,-1,3); loopWhiletgtCnt(); // drop legs quickly
//      delayLoop(2);
//      GoToAngles(-1,-1,-1,LegUp,-1,-1,-1,LegUp,3); loopWhiletgtCnt(); // raise legs quickly
//      delayLoop(2);
//      GoToAngles(90,-1,-1,-1,90,-1,-1,-1,zCnt); loopWhiletgtCnt(); // swing legs quickly
//      delayLoop(2);
//      if (zAng < 1) {GoToAngles(-1,-1,-1,LegDn,-1,-1,-1,LegDn,3); loopWhiletgtCnt(); // drop legs quickly
//        delayLoop(2);}
//    }
//  } SetLedMode(0);
//}

// ----------------------------------------------------------------------



