
// ----------------------------------------------------------------------

void attachServos(int zDel) {
  // create 8 servos and attach them to pins
  // delay used during power-up reset, otherwiswe set to 0
  if (ESC) return;
  servoEn = true;
  for (int zP = 0; zP < 8;zP++) {
    servoInst[zP].attach(servoPins[zP]);
    servoInst[zP].writeMicroseconds(servoVal[zP]); delay(zDel);
    servoTgt[zP] = servoVal[zP]; // correct target positions
  }
}

// ----------------------------------------------------------------------

void BatteryFailed() {
  // if battery voltage drops below trigger level for more than 1 second
  detachServos();
  digitalWrite(LED0, HIGH); digitalWrite(LED1, HIGH); digitalWrite(LED2, HIGH);
  digitalWrite(LED3, HIGH); digitalWrite(LED4, HIGH);
  // flash left LED for a short while
  for (int zL = 0; zL < 30; zL++) {
    digitalWrite(LED2, LOW); delay(20);
    digitalWrite(LED2, HIGH); delay(980);
  }
  while (true) {} // do nothing forever
}

// ----------------------------------------------------------------------

void checkTgts() {
  // ensure that set targets are within servo min/max limits
  servoTgt[0] = min(servoTgt[0],Max1); servoTgt[0] = max(servoTgt[0],Min1);
  servoTgt[1] = min(servoTgt[1],Max2); servoTgt[1] = max(servoTgt[1],Min2);
  servoTgt[2] = min(servoTgt[2],Max3); servoTgt[2] = max(servoTgt[2],Min3);
  servoTgt[3] = min(servoTgt[3],Max4); servoTgt[3] = max(servoTgt[3],Min4);
  servoTgt[4] = min(servoTgt[4],Max5); servoTgt[4] = max(servoTgt[4],Min5);
  servoTgt[5] = min(servoTgt[5],Max6); servoTgt[5] = max(servoTgt[5],Min6);
  servoTgt[6] = min(servoTgt[6],Max7); servoTgt[6] = max(servoTgt[6],Min7);
  servoTgt[7] = min(servoTgt[7],Max8); servoTgt[7] = max(servoTgt[7],Min8);
}

// ----------------------------------------------------------------------

void decodeCZ() {
  // called whenever Rx data has been received (25Hz) to track button presses
  if ((CZ != 3) && (CZ_Wait)) {autoRest = 0; return;}
  CZ_Wait = false; // clear the wait for buttons release flag
  
  if ((CZ & 1) == 0) {
    // check 'Z' button which is active LOW
    Z_Dn++; Z_Up = 0; autoRest = 0;
    if (Z_Dn >= 50) {Z_Dn = 50;} // limit 'Z' down count to 2 seconds
  } else {
    // 'Z' button is released or not pressed
    if (Z_Up < 50) {Z_Up++;}
    if ((Z_Up == 25) && (Z_Cnt > 0)) {
      // button released for 1 second and presses were counted
      // so increase speed limit
      WalkSpeed -= Z_Cnt; WalkSpeed = max(WalkSpeed,1);
      switch(WalkSpeed) {
        case 1: WalkMax = 4; break;
        case 2: WalkMax = 7; break;
        case 3: WalkMax = 10; break;
        case 4: WalkMax = 13; break;
        case 5: WalkMax = 15; break;
      } Z_Cnt = 0; Z_Up = 50;
      Serial.print(F("WalkSpeed=")); Serial.println(WalkSpeed);
    }
    if ((QuadActive) && (Z_Dn > 0) && (Z_Dn < 25)) {
      // 'Z' button was pressed for less than 1 second
      Z_Cnt++;
      Serial.print(F("Z_Cnt=")); Serial.println(Z_Cnt);
    } Z_Dn = 0;
  }
  if ((CZ & 2) == 0) {
    // check 'C' button which is active LOW
    C_Dn++; C_Up = 0; autoRest = 0;
    if (C_Dn >= 25) {
      C_Dn = 25;
      // go active if inactive and only 'C' is pressed > 1 seconds
      if ((!QuadActive) && (Z_Dn == 0)) {
        Serial.println(F("Going to QuadActive!"));
        GoToStand(20); QuadActive = true; CZ_Wait = true;
        C_Dn = 0; // clear the down counter to ignore the count
      }
      // go inactive if 'C' and 'Z' pressed > 1.5 seconds
      if ((QuadActive) && (Z_Dn >= 36)) {
        // both 'C' and 'Z' held in for > 1.5 sec so goto rest position
        setDefaults(); // clear the down counters to ignore the counts
        Serial.println(F("Sleeping..."));
        GoToRest(50); CZ_Wait = true;
      }
    }
  } else {
    // 'C' button is released or not pressed
    if (C_Up < 50) {C_Up++;}
    if ((QuadActive) && (C_Up == 25) && (C_Cnt > 0)) {
      // button released for 1 second and presses were counted
      // so increase speed limit
      WalkSpeed += C_Cnt; WalkSpeed = min(WalkSpeed,5);
      switch(WalkSpeed) {
        case 1: WalkMax = 4; break;
        case 2: WalkMax = 7; break;
        case 3: WalkMax = 10; break;
        case 4: WalkMax = 13; break;
        case 5: WalkMax = 15; break;
      } C_Cnt = 0; C_Up = 50;
      Serial.print(F("WalkSpeed=")); Serial.println(WalkSpeed);
    }
    if ((QuadActive) && (C_Dn > 0) && (C_Dn < 25)) {
      // 'C' button was pressed for less than 1 second so count it
      C_Cnt++;
      Serial.print(F("C_Cnt=")); Serial.println(C_Cnt);
    } C_Dn = 0;
  }
}

// ----------------------------------------------------------------------

void detachServos() {
  // detach all servos
  servoEn = false;
  for (int zP = 0; zP < 8;zP++) {servoInst[zP].detach();}
}

// ----------------------------------------------------------------------

void MemRead() {
  // reads the stored servo values into target values
  for (anyFor = 0;anyFor < 8;anyFor++) {servoTgt[anyFor] = servoMem[anyFor];}
}

// ----------------------------------------------------------------------

void MemStore() {
  // stores the current servo values in a memory store
  for (anyFor = 0;anyFor < 8;anyFor++) {servoMem[anyFor] = servoVal[anyFor];}
}

// ----------------------------------------------------------------------

void PrintBinary(int zB) {
  // print a byte value in binary
  if (zB < 128) {Serial.print("0");}
  if (zB < 64) {Serial.print("0");}
  if (zB < 32) {Serial.print("0");}
  if (zB < 16) {Serial.print("0");}
  if (zB < 8) {Serial.print("0");}
  if (zB < 4) {Serial.print("0");}
  if (zB < 2) {Serial.print("0");}
  Serial.print(zB,BIN);
  Serial.print("  ");
  Serial.println(zB);
}

// ----------------------------------------------------------------------

void ReadRx() {
  // reads the serial receive buffer and responds accordingly
  // we expect to receive a 6 byte frame with a 2 byte key and 1 byte checksum
  // the checksum is for detecting edge of range data corruption
  RxVal = Serial.read();
  if (RxVal != -1) {
    // receiver contains a data byte
    switch (RxState) {
      case 0: // check for first key value
        if (RxVal == 0x0AA) {
          checksum = 0x0AA; RxState++;
//          Serial.println("\n");
//          Serial.println("K0");
        } break;
      case 1: // check for second key value
        if (RxVal == 0x055) {
          checksum = checksum ^ RxVal; RxState++;
//          Serial.println("K1");
        } else {
          RxState = 0;
          Serial.println("Invalid K1");
        } break;
      case 2: // receive JoyX value, centre value = 127
        checksum = checksum ^ RxVal;
        JoyX = RxVal; RxState++;
//        PrintBinary(JoyX);
        break;
      case 3: // receive JoyY value, centre value = 128
        checksum = checksum ^ RxVal;
        JoyY = RxVal; RxState++;
//        PrintBinary(JoyY);
        break;
      case 4: // receive CZ value
        checksum = checksum ^ RxVal;
        CZ = RxVal; RxState++;
//        PrintBinary(CZ);
        break;
      case 5: // receive checksum value and confirm it is valid
        if (checksum == RxVal) {
          // frame checksum byte is confirmed as valid
          RxRec = true;
        } else {
          // frame checksum byte is invalid
//          Serial.println("Invalid checksum");
//          PrintBinary(RxVal);
        }
        RxState = 0; // reset state machine
//        Serial.println(".");
//        PrintBinary(checksum);
        break;
    }
  }
}

// ----------------------------------------------------------------------

void SetAngle(int zS, int zA) {
  // sets a specific servo zS to an angle zA immediately
  // if zS >= 10 then set target only and don't move the servo
  // note servos are numbered 0 - 7, not 1 - 8
  if (ESC) return;
  if (!servoEn) {attachServos(0);}
  anyVal = 0; if (zS >= 10) {zS = zS - 10; anyVal = 1;}
  if (zA >= 0) {
    switch (zS) {
      case 0: servoTgt[0] = map(zA,45,135,Ang1_45,Ang1_135); break;
      case 1: servoTgt[1] = map(zA,65,153,Ang2_65,Ang2_153); break;
      case 2: servoTgt[2] = map(zA,45,135,Ang3_45,Ang3_135); break;
      case 3: servoTgt[3] = map(zA,65,153,Ang4_65,Ang4_153); break;
      case 4: servoTgt[4] = map(zA,45,135,Ang5_45,Ang5_135); break;
      case 5: servoTgt[5] = map(zA,65,153,Ang6_65,Ang6_153); break;
      case 6: servoTgt[6] = map(zA,45,135,Ang7_45,Ang7_135); break;
      case 7: servoTgt[7] = map(zA,65,153,Ang8_65,Ang8_153); break;
    }
    if (anyVal < 1) {
      // zS is not >= 10 so set servo immediately
      if (servoVal[zS] != servoTgt[zS]) {
        servoVal[zS] = servoTgt[zS]; servoInst[zS].writeMicroseconds(servoVal[zS]);
      }
    }
  }
}

// ----------------------------------------------------------------------

void SetLedMode(int zM) {
  // sets the mode and clears the counter
  LedMode = zM; LedCnt = 0;
}

// ----------------------------------------------------------------------

void SetToTgtNow() {
  // set servos to target values immediately, if not at targets
  for (anyFor = 0;anyFor < 8;anyFor++) {
    if (servoVal[anyFor] != servoTgt[anyFor]) {
      servoVal[anyFor] = servoTgt[anyFor]; servoInst[anyFor].writeMicroseconds(servoVal[anyFor]);
    }
  }
}

// ----------------------------------------------------------------------



