
// ----------------------------------------------------------------------

void anyLongDamp() {
  // called after setting anyLong to a value based on the following:
  // anyLong = map(RangeCentreTracker,RM,R5,1,12);
  anyLong = 60000/anyLong;
  anyLong = long(walkInterval) + ((anyLong - long(walkInterval)) / SpdRmp);
  walkInterval = anyLong;
}

// ----------------------------------------------------------------------

void CalcHeadAng() {
  // something detected so calculate a steering angle, which is used by
  // the autonomous code
  anyLong = (512 * (RangeIntR - RangeIntL)) / (RangeIntR + RangeIntL);
  RangeAng = map(anyLong,128,-128,Head_65P,Head_65N);
  // now set variables for next half-cycle
  CalcCnt++; // track the number of calculation modes performed
}

// ----------------------------------------------------------------------

void CheckMinRange() {
  // used in autonomous mode to keep an eye on a target appearing during a
  // half sweep, so this is called at the extremes of the sweep
  if (RangeMin <= LtofDet) {
    // something has been detected
    TrgtDet = true;
    // new steering angle is only calculated when something is within range
  } else {
    TrgtDet = false; // nothing has been detected
  }
  if ((Turning) && (RangeMin >= LtofStop)) {ESC = true;} // if turning then stop turning
  RangeMinMem = RangeMin; RangeMin = LtofMax; // store & reset the minimum range
}

// ----------------------------------------------------------------------

void CheckWalkDir(int zW) {
  // ensure walk is set for the right direction
  if (abs(Walk) == zW) {Walk = zW;} else {StartWalk(zW);}
  LedMode = zW; // set the associated LED mode sequence
}

// ----------------------------------------------------------------------

void DoHeadTasks() {
  // perform a range of head movement tasks depending on the MainTask
  // in non-autonomous mode the head will look for targets and track them
  // in autonomous mode th head does not seek to find/track a target, it simply
  // scans over a given range to provide steering information
  if (HeadTaskRun) return;
  if (HeadTask < 1) {RangeCentreTracker = Range; return;}

  HeadTaskRun = true; // prevent stack overflow due to nesting
  switch(HeadTask) {
    // in this range of cases the head scans randomly left to right looking
    // if a target is detected by HeadMode code then do different actions
    case 1:
      // set random first head movement and head mode
      RangeCentre = LtofMax; RangeCentreTracker = RangeCentre;
      autoHeadOFF = -1; if (!servoHeadEn) {attachHeadServo();}
      HeadAdj = false; // disable calculations for 1st half sweep
      if (MainTask < 4) {
        // target scanning & tracking mode
        HeadDir = random(2); HeadCyc = 4; HeadMode = 0; HeadTask++;
      } else {
        // autonomous scanning mode
        TrgtDet = false; CalcCnt = 0; HeadMode = 3; HeadTask = 30;
      } break;
    case 2:
      // toggle head direction and target angle
      if (HeadDir > 0) {
        // look to the right
        HeadDir = -1;
        HeadTgt = (((Head_65P - Head_65N) * (7 + random(4)))/10) + Head_65N;
        if (HeadCyc > 0) {HeadTgt = Head_65N;}
      } else {
        // look to the left
        HeadDir = 1;
        HeadTgt =  Head_65P - (((Head_65P - Head_65N) * (7 + random(4)))/10);
        if (HeadCyc > 0) {HeadTgt = Head_65P;}
      } 
      if (HeadCyc > 0) {HeadCyc--;} // if full-cycling reduce counter
      headTgtCnt = abs(((HeadTgt - HeadVal) * 50)/(Head_65P - Head_65N));
      HeadTask++; break;
    case 3:
      // wait for head to reach end of movement
      if (headTgtCnt < 1) {
        HeadCnt = 20 + random(40); HeadTask++;
        if (HeadCyc > 0) {HeadCnt = 10;}
      } break;
    case 4:
      // pause temporarily at this angle whilst HeadCnt > 0
      HeadCnt--; if (HeadCnt < 1) {HeadTask = 2;}
      break;


    case 10:
      // scan a detected target whilst it remains in range, centred on the detected
      // angle as the starting point. Immediately stop the random sweep. Set the
      // sweep range to max.
      HeadMode = 1; headTgtCnt = 0; RangeAng = HeadVal;
      AngDif = AngDifMax; HeadAdj = false; HeadErrSt = false;
      HeadTask++; break;
    case 11:
      // this is a centre scan point, prior to sweeping right
      RangeCentre = min(int(Range),RangeMin); // use the closest range
      RangePnt = true; // flag used by tracker function
      HeadTgt = min(Head_90P, RangeAng + AngDif); // define sweep to right range
      headTgtCnt = 4; if (HeadAdj) {SetheadTgtCnt(AngDif);} // set sweep speed
      HeadTask++; break;
    case 12:
      // wait for the rightmost target angle to be reached
      if (headTgtCnt < 1) {
        // rightmost point has been reached
        if ((HeadCnt > 0) && (RangeMin < LtofMax)) {RangeAng = RangeMinAng;}
        if (HeadAdj) {HeadMode = 2;} // adjust only if full sweep has been completed
        HeadTask++; // move on once target is reached
      } RangeIntR += long(Range); // integrate the right-hand range values
      break;
    case 13:
      // adjustment may have moved the rightmost point, so move there before
      // starting a new sweep
      HeadTgt = min(Head_90P, RangeAng + AngDif); // define sweep to right range
      headTgtCnt = 2;
      HeadTask++; break;
    case 14:
      // wait for new rightmost end point to be reached  
      if (headTgtCnt < 1) {HeadTask++;} // rightmost point reached
      break;
    case 15:
      // now turn left towards the centre point
      RangePnt = true; // flag used by tracker function
      HeadTgt = RangeAng; SetheadTgtCnt(AngDif); // set the centre target
      RangeIntR = 0; RangeIntL = 0; // clear the integrators
      RangeMin = LtofMax; // reset minimum range tracker
      HeadTask++; break;
    case 16:
      // wait until the centre point has been reached
      if (headTgtCnt < 1) {HeadTask++;} // centre point achieved
      RangeIntR += long(Range); // integrate the right-hand range values
      break;
    case 17:
      // this is a centre scan point, prior to sweeping left
      RangeCentre = min(int(Range),RangeMin); // use the closest range
      RangePnt = true; // flag used by tracker function
      HeadTgt = max(Head_90N, RangeAng - AngDif); // define sweep to left range
      SetheadTgtCnt(AngDif);
      HeadTask++; break;
    case 18:
      // wait for the leftmost target angle to be reached
      if (headTgtCnt < 1) {
        // leftmost point has been reached
        HeadAdj = true; // a full sweep has now been completed
        if ((HeadCnt > 0) && (RangeMin < LtofMax)) {RangeAng = RangeMinAng;}
        HeadMode = 2; // calculate centre adjustments based on this full sweep
        HeadTask++; // move on once target is reached
      } RangeIntL += long(Range); // integrate the left-hand range values
      break;
    case 19:
      // adjustment may have moved the leftmost point, so move there before
      // starting a new sweep
      HeadTgt = max(Head_90N, RangeAng - AngDif); // define sweep to right range
      headTgtCnt = 2;
      HeadTask++; break;
    case 20:
      // wait for new leftmost end point to be reached  
      if (headTgtCnt < 1) {HeadTask++;} // rightmost point reached
      break;
    case 21:
      // now turn right towards the centre point
      RangePnt = true; // flag used by tracker function
      HeadTgt = RangeAng; SetheadTgtCnt(AngDif); // set the centre target
      RangeIntR = 0; RangeIntL = 0; // clear the integrators
      RangeMin = LtofMax; // reset minimum range tracker
      HeadTask++; break;
    case 22:
      // wait until the centre point has been reached
      if (headTgtCnt < 1) {HeadTask = 11;} // centre point achieved
      RangeIntL += long(Range); // integrate the left-hand range values
      break;


    case 30:
      // these set of cases perform simple left to right scanning for autonomous
      // target detection.
      // centre point continue towards left-most point
      if (HeadAdj) {CalcHeadAng();} // calculate adjustments based on this half sweep
      RangeIntL = 0; // clear right-hand integrator
      HeadTgt = Head_65N; headTgtCnt = HeadSpd; HeadTask++; break;
    case 31:
      // wait for new leftmost end point to be reached  
      if (headTgtCnt < 1) {HeadTask++;} // left-most point reached
      RangeIntL += long(Range); // integrate the left-hand range values
      break;
    case 32:
      // left-most point reached
      // turn right towards centre position
      CheckMinRange();
      HeadTgt = Head_0; headTgtCnt = HeadSpd; HeadTask++; break;
    case 33:
      // wait for centre point to be reached  
      if (headTgtCnt < 1) {HeadTask++;} // centre point reached
      RangeIntL += long(Range); // integrate the left-hand range values
      break;
    case 34:
      // centre point continue right towards right-most position
      CalcHeadAng(); // calculate adjustments based on this half sweep
      RangeIntR = 0; // clear right-hand integrator
      HeadTgt = Head_65P; headTgtCnt = HeadSpd; HeadTask++; break;
    case 35:
      // wait for right-most point to be reached  
      if (headTgtCnt < 1) {HeadTask++;} // right-most point reached
      RangeIntR += long(Range); // integrate the right-hand range values
      break;
    case 36:
      // right-most point reached
      // turn towards centre position
      CheckMinRange();
      HeadAdj = true; // full half sweeps can now be integrated
      HeadTgt = Head_0; headTgtCnt = HeadSpd; HeadTask++; break;
    case 37:
      // wait for centre point to be reached  
      if (headTgtCnt < 1) {HeadTask = 30;} // right-most point reached
      RangeIntR += long(Range); // integrate the right-hand range values
      break;
  }

  switch(HeadMode) {
    // here we use Range values to switch between different head scanning tasks
    case 0:
      RangeCentre = int(Range); RangeMin= RangeCentre; // track the range
      if (Range <= LtofDet) {HeadTask = 10;} // switch to close range scanning
      break;
    case 1:
      // only record minimum during full sweep
      if (Range < RangeMin) {RangeMin = Range; RangeMinAng = HeadVal;}
      break;
    case 2:
      // recalculate centre angle at both sweep end points
      HeadErr = ((RangeIntR - RangeIntL) * 300)/(RangeIntR + RangeIntL);
      RangeAng = RangeAng - int(HeadErr);
      if (abs(HeadErr) > HeadErrTrk) {HeadErrTrk++;} else {HeadErrTrk--;}
      HeadErrTrip = abs(abs(HeadErr) - HeadErrTrk);
//      Serial.print(RangeIntL); Serial.print("\t"); Serial.println(RangeIntR);
//      Serial.print(HeadErrTrip); Serial.print("\t"); Serial.println(AngDif);
      // adjust sweep width depending on angle adjustment needed
      if ((HeadErrTrip > 10) && (HeadErrSt)) {
        // significant head angle adjustment so increase sweep angle
        AngDif = AngDifMax; // increase the sweep angle if target is moving
        HeadErrSt = false;
      } else {
        // decrease the sweep angle progressively to reduce the error
        AngDif = AngDif - ((AngDif - 30)/4);
        if ((AngDif < 40) && (HeadErrTrip < 4)) {HeadErrSt = true;}
      }
      // check for lost target in either phase
      if (RangeMin >= LtofMax) {
        // nothing detected in this half cycle
        HeadCnt++;
        // could be slightly off centre so nudge centre point
        if (HeadCnt == 2) {AngDif = AngDifMax + 200;}; // no target detected in either phase
        if (HeadCnt > 4) {HeadTask = 1;} // 2 dead cycles, target has been lost
      } else {HeadCnt = 0;}
      RangeAng = min(RangeAng,Head_90P); RangeAng = max(RangeAng,Head_90N);
      HeadMode = 1; break;

    
    
    
    case 3:
      // mode used for autonomous
      if (Range < RangeMin) {
        RangeMin = Range;
        // check to see if something has been detected
        if (RangeMin <= LtofDet) {TrgtDet = true;}
      } break;
      
  }
  // before leaving track the centre positions
  if (RangePnt) {
    RangePnt = false; // reset the point flag
    anyInt = (RangeCentre - RangeCentreTracker)/2; RangeCentreTracker += anyInt;
//  RangeCentreTracker = RangeCentreTracker + ((RangeCentre - RangeCentreTracker)/8);
  }

  HeadTaskRun = false;
}

// ----------------------------------------------------------------------

void GetSteeringDrive(int zDir) {
  // calculates steering angle when head is active
  // zDir defines direction, 1 == forward, -1 == backwards
  // at centre RangeAng == Head_0, full left == Head_65N, full right == 65P
  WalkLftDrive = 128; WalkRgtDrive = 128; // set drive factors to max as default
  if (!HeadActive) {return;} // head is not active so no steering needed
  if (zDir == 0) {return;} // set drives equal
  if (zDir > 0) {
    // walking forwards
    if (RangeAng >= Head_0) {
      // target is on the right-hand side
      WalkRgtDrive = map(RangeAng,Head_65P,Head_0,0,128);
    } else {
      // target is on the left-hand side
      WalkLftDrive = map(RangeAng,Head_65N,Head_0,0,128);
    }
  } else {
    // walking backwards
    if (RangeAng >= Head_0) {
      // target is on the right-hand side
      WalkLftDrive = map(RangeAng,Head_65P,Head_0,0,128);
    } else {
      // target is on the left-hand side
      WalkRgtDrive = map(RangeAng,Head_65N,Head_0,0,128);
    }
  }
  WalkLftDrive = max(WalkLftDrive,0); WalkLftDrive = min(WalkLftDrive,128);
  WalkRgtDrive = max(WalkRgtDrive,0); WalkRgtDrive = min(WalkRgtDrive,128);
}


// ----------------------------------------------------------------------

void GoToAngles(int zA1,int zA2,int zA3,int zA4,int zA5,int zA6,int zA7,int zA8, int zCnt) {
  // move to specific servo angles, or -1 means no change
  // number of 20ms steps in movement set by zCnt
  if (ESC) return; // exit if this flag is set
  if (!servoEn) {attachServos(0);}
  if (zA1 >= 0) {servoTgt[0] = map(zA1,45,135,Ang1_45,Ang1_135);}
  if (zA2 >= 0) {servoTgt[1] = map(zA2,65,153,Ang2_65,Ang2_153);}
  if (zA3 >= 0) {servoTgt[2] = map(zA3,45,135,Ang3_45,Ang3_135);}
  if (zA4 >= 0) {servoTgt[3] = map(zA4,65,153,Ang4_65,Ang4_153);}
  if (zA5 >= 0) {servoTgt[4] = map(zA5,45,135,Ang5_45,Ang5_135);}
  if (zA6 >= 0) {servoTgt[5] = map(zA6,65,153,Ang6_65,Ang6_153);}
  if (zA7 >= 0) {servoTgt[6] = map(zA7,45,135,Ang7_45,Ang7_135);}
  if (zA8 >= 0) {servoTgt[7] = map(zA8,65,153,Ang8_65,Ang8_153);}
  checkTgts(); // ensure target values are within limits
  tgtCnt = abs(zCnt);
  if (zCnt > 0) {loopWhiletgtCnt();} // included here for code efficiency
//  Serial.println(F("GoToAngles Set"));
//  Serial.println(tgtCnt);
}

// ----------------------------------------------------------------------

void GoToRest(int zCnt) {
  // move to the resting position
  // number of 20ms steps in movement set by zCnt
  if (ESC) return;
//  Serial.println(F("> GoToRest()"));
  GoToAngles(65,65,65,65,65,65,65,65,-zCnt); // go to the resting position
  autoRest = autoRestMax; // no need to rest from this position
}

// ----------------------------------------------------------------------

void GoToStand(int zCnt) {
  // move to the normal standing position
  // number of 20ms steps in movement set by zCnt
  if (ESC) return;
//  Serial.println(F("> GoToStand()"));
  GoToAngles(90,90,90,90,90,90,90,90,-zCnt); // go to the resting position
  autoRest = autoRestMax; // no need to rest from this position
}

// ----------------------------------------------------------------------

void HeadToAngle(int zA, int zCnt) {
  // move to specific servo angle
  // number of steps in head movement set by zCnt
  if (ESC) return; // exit if this flag is set
  if (!servoHeadEn) {attachHeadServo();}
  // assume non-linearity and map angle into the correct quadrant for best
  // accuracy
  if (zA >= 0) {
    HeadTgt = map(zA,0,90,Head_0,Head_90P);
  } else {
    HeadTgt = map(zA,-90,0,Head_90N,Head_0);
  }
//  checkTgts(); // ensure target values are within limits
  headTgtCnt = zCnt;
//  Serial.println(F("HeadToAngles Set"));
//  Serial.println(headTgtCnt);
}

// ----------------------------------------------------------------------

void HeadToRest() {
  // move the head to the straight forward rest position
  HeadToAngle(0,10); autoHeadOFF = 5; // centre head servo
}

// ----------------------------------------------------------------------

void MainTask_Autonomous() {
  // autonomous discovery mode, stays in this mode until reset
  // starts with looking in front of itself
  // if clear, then move forward, a random distance if fixed head
  // if not clear, rotate and look again
  if (MainRun) {return;}
  MainRun = true; // prevent re-entry of task
  switch (SubTask) {
    case 0: // initialise
      Serial.println(F("> MainTask_Autonomous()")); 
      automRnd = 1; SubTask++; break;
    case 1:
      // set legs for going forward, prior to radar scanning
      automTurn = 0; Walk = 0; walkInterval = 18000; StartWalk(-1); 
      if (HeadActive) {
        SubTask = 50; LedMode = 5; // autonomous with rotating head
      } else {
        SubTask = 2; // autonomous with fixed head, twisting body
      }
      break;
    case 2:
      // twist scan and turning code
      RangeCentre = LtofMax;  RangeLeft = LtofMax; RangeRight = LtofMax;
      SetLedMode(5);
      if (random(2) < 1) {
        // twist left, then right, taking radar readings
        // twist to the left
//        Serial.println(F("Looking left...")); 
        GoToAngles(45,-1,135,-1,45,-1,135,-1,30);
        delayLoop(150); if (Range <= LtofDet) {RangeLeft = Range;}
//        Serial.println(Range); 
        // twist to the right
//        Serial.println(F("Looking right...")); 
        GoToAngles(135,-1,45,-1,135,-1,45,-1,60);
        delayLoop(150); if (Range <= LtofDet) {RangeRight = Range;}
//        Serial.println(Range); 
      } else {
        // twist right, then left, taking radar readings
        // twist to the right
//        Serial.println(F("Looking right...")); 
        GoToAngles(135,-1,45,-1,135,-1,45,-1,30);
        delayLoop(150); if (Range <= LtofDet) {RangeRight = Range;}
//        Serial.println(Range); 
        // twist to the left
//        Serial.println(F("Looking left...")); 
        GoToAngles(45,-1,135,-1,45,-1,135,-1,60);
        delayLoop(150); if (Range <= LtofDet) {RangeLeft = Range;}
//        Serial.println(Range); 
      }
      // back to centre
//      Serial.println(F("Looking forward...")); 
      GoToAngles(90,-1,90,-1,90,-1,90,-1,30);
      delayLoop(150); if (Range <= LtofDet) {RangeCentre = Range;}
//      Serial.println(Range); 
      // now check range readings and respond
      if (automTurn == 0) {
        // haven't just turned, so determine direction
        if (RangeLeft <= 325) {
          // something is to my left so turn right and repeat process measurements
          automRnd = 1; // reset walking to short distance at first
          if (RangeRight > RangeLeft) {
            // object on the left is closer
            SetLedMode(2);
            // TurnRight(zAng,zStep1,zSpeed)
  //          Serial.println(F("Turning Right...")); 
            TurnRight(60,10,8); automTurn = 1; loopWhiletgtCnt();
          } else {
            // object on the right is closer
            SetLedMode(4);
            // TurnLeft(zAng,zStep1,zSpeed)
  //          Serial.println(F("Turning Left...")); 
            TurnLeft(60,10,8); automTurn = -1; loopWhiletgtCnt();
          } break;
        }
        else if (RangeRight <= 325) {
          // something is to my right so turn left and repeat process measurements
          automRnd = 1; // reset walking to short distance at first
          if (RangeLeft > RangeRight) {
            // object on the right is closer
            SetLedMode(4);
            // TurnLeft(zAng,zStep1,zSpeed)
  //          Serial.println(F("Turning Left...")); 
            TurnLeft(60,10,8); automTurn = -1; loopWhiletgtCnt();
          } else {
            // object on the left is closer
            SetLedMode(2);
            // TurnRight(zAng,zStep1,zSpeed)
  //          Serial.println(F("Turning Right...")); 
            TurnRight(60,10,8); automTurn = 1; loopWhiletgtCnt();
          } break;
        }
        else if (RangeCentre <= 325) {
          // something is in front of me, but sides are clear
          // so turn randomly left/right
  //        Serial.println(F("Object ahead...")); 
          automRnd = 1; // reset walking to short distance at first
          if (random(2) > 0) {
  //          Serial.println(F("Turning Left...")); 
            SetLedMode(4);
            TurnLeft(90,10,8); automTurn = -1; loopWhiletgtCnt(); break;
          } else {
  //          Serial.println(F("Turning Right...")); 
            SetLedMode(2);
            TurnRight(90,10,8); automTurn = 1; loopWhiletgtCnt(); break;
          }
        } 
        else {SubTask = 3; break;}
      }
      else if ((RangeCentre <= 325) || (RangeLeft <= 325) || (RangeRight <= 325)) {
        // despite turning an object has still been detected
        // so we continue turning in the same direction
        automRnd = 1; // reset walking to short distance at first
        if  (automTurn > 0) {
          // just turned to the right, so continue turning if object is present
          SetLedMode(2);
          TurnRight(60,10,6); loopWhiletgtCnt();
        } else {
          // just turned to the left, so continue turning if object is present
          SetLedMode(4);
          TurnLeft(60,10,6); loopWhiletgtCnt();
        }
      }
      else {SubTask = 3;}
      break;
    case 3:
      // all is clear so walk for a random distance, then re-measure
      // random distance increases provided nothing is detected along the way
//        Serial.println(F("Walking forward..."));
      walkInterval = 15000 + (1000 * random(7)); // vary walking speed
      StartWalk(1); SetLedMode(1);
//        loopWhileWalkEcho(88 * (1 + random(automRnd)));
      loopWhileWalkEcho(88 * automRnd);
      if (automRnd < 10) {automRnd++;} // increase walking range
      delayLoop(200); // short pause before range scanning
      SubTask = 1; // restart scanning process
      break;


















    case 50:
      // autonomouse with moving head
      // at this point the robot is stationary and checking for a wall
      if (CalcCnt > 3) {
        // head has performed at least 4 half-sweeps
        CalcCnt = 0;
        if ((TrgtDet) && (RangeMinMem <= LtofStop)) {
          // if wall or target is close go into 360 turning mode
          // whilst in this mode move the head more rapidly
          headInterval = 10000;
          if (RangeAng >= Head_0) {
            // wall is closer on the left
            TurnRight(660,20,8); // turn 360 degrees right
          } else {
            // wall is closer on the right
            TurnLeft(660,20,8); // turn 360 degrees left
          } if (!ESC) {SubTask = 100;} // no way out found
          ESC = false; headInterval = 20000;
        } else {
          // no target or wall was detected so start walking
          StartWalk(1); LedMode = 1; SubTask++;
        }
      } break;
    case 51:
      // walking whilst looking for targets/walls
      if (CalcCnt > 0) {
        // a new sweep has been completed so recalculate steering
        CalcCnt = 0;
        GetSteeringDrive(1); // get steering in forward direction
      }
      // whilst walking constrantly look for a close wall or target
      if (RangeMin <= LtofStop) {
        // a target or wall was detected close range so stop
        Walk = 0; LedMode = 5;
        GoToAngles(-1,LegDn,-1,LegDn,-1,LegDn,-1,LegDn,-1); // put all feet down immediately
        SubTask = 50; // go back to start point
      }
      break;



    case 100:
      // here because turning 360 did not find a way out
      HeadTask = 0; HeadToRest();
      automCnt = 500 + random(1000); // create a delay for a minimum of 10 seconds
      break;
    case 101:
      // wait here then restart
      automCnt--; if (automCnt < 1) {SubTask = 0;}
      break;
















  } MainRun = false;
}

// ----------------------------------------------------------------------

void MainTask_TrackWall(int zMode) {
  // dual function depending on zMode value
  // zMode = 0 backs away from an approaching target
  // zMode = 1 maintains a fixed distance from a wall, stays in this mode until reset
  if (MainRun) {return;}
  MainRun = true; // prevent re-entry of task
  // use a tracking filter on teh range to prevent sudden movements during tracking
  switch (SubTask) {
    case 0: // initialise
      R0 = 55; RM = 335; Walked = 0;
      if (zMode == 0) {
        Serial.println(F("> MainTask_BackAway()"));
        R1 = 125; R2 = 160; R3 = 325;
      } else {
        Serial.println(F("> MainTask_TrackWall()"));
        R1 = 80; R2 = 130; R3 = 170; R4 = 200; R5 = 230; R6 = 305;
      } SubTask = 1; break;
    case 1:
      // depending on zMode set a walk direction
      if (zMode == 0) {
        // start expecting to go backward
        StartWalk(-3);
      } else {
        // start expecting to go forward
        StartWalk(-1);
      }
      SubTask = 2; break;
    case 2: // wait for a wall to appear and if necessary change direction
      // only move onto SubTask 3 when a wall appears
      walkInterval = 60000; 
//      Serial.println(Walk);
      if ((RangeCentreTracker >= R0) && (RangeCentreTracker <= R3)) {
        SubTask = 3; Walk= abs(Walk);
        if (Walk != 3) {
          // change walk direction from forwards to backwards
          Walk = 0; WalkCnt += 44; if (WalkCnt > 87) {WalkCnt -= 88;}
          WalkNext = 3; SetLegStates(); // set leg heights
          SubTask = 99;
        }
      } else if ((RangeCentreTracker >= R4) && (RangeCentreTracker <= RM)) {
        SubTask = 3; Walk= abs(Walk);
        if (Walk != 1) {
          // change walk direction from backards to forwards
          Walk = 0; WalkCnt -= 44; if (WalkCnt < 0) {WalkCnt += 88;}
          WalkNext = 1; SetLegStates(); // set leg heights
          SubTask = 99;
        }
      } break;
    case 3: // scan for wall and respond
      if (RangeCentreTracker >= R0) {
        anyLong = RangeCentreTracker - 10; // introduce 10mm of hysteresis
        if (RangeCentreTracker > RM) {
          // target moved out of range so stop
          SubTask = 4;
        } else if ((zMode > 0) && (anyLong >= R6)) {
          // if walking forward let it continue, but if not start moderately
          CheckWalkDir(1); // ensure we are going to walk forward
          GetSteeringDrive(1);
          anyLong = map(anyLong,RM,R5,1,12);
          anyLongDamp();
        } else if ((zMode > 0) && (anyLong >= R5)) {
          // if walking forward let it continue, but if not start moderately
          CheckWalkDir(1); // ensure we are going to walk forward
          GetSteeringDrive(1);
          anyLong = 12; // set to max speed
          anyLongDamp();
        } else if ((zMode > 0) && (anyLong >= R4)) {
          // far wall detected so walking speed depends on how close it is
          CheckWalkDir(1); // ensure we are going to walk forward
          GetSteeringDrive(1);
          anyLong = map(anyLong, R4,R5,1,12);
          anyLongDamp();
        } else if ((anyLong <= R3) && (anyLong >= R1)) {
          // close wall detected so backaway speed depends on how close it is
          CheckWalkDir(3); // ensure we are going to walk backward
          GetSteeringDrive(-1);
          anyLong = map(anyLong,R3,R2,1,12);
          anyLong = min(anyLong,12); // set max speed
          anyLongDamp();
        } else if ((anyLong <= R1) && (anyLong >= R0)) {
          // too close wall detected so slow down backaway speed
          CheckWalkDir(3); // ensure we are going to walk backward
          GetSteeringDrive(-1);
          anyLong = map(anyLong, R0,R1,1,12);
          anyLongDamp();
        } else {
          // in centre deadband so stop
          SubTask = 4;}
      } else {
        // no wall detected but one had been previously
        SubTask = 4;
      } break;
    case 4: // stop moving and put feet down and wait
      Walk = -abs(Walk); walkInterval = 60000; LedMode = 0;
      MemStore(); // store current values
      GoToAngles(-1,LegDn,-1,LegDn,-1,LegDn,-1,LegDn,-1); // put all feet down immediately
      SubTask++; anyMilli = millis(); break;
    case 5: // wait for a valid range then return to previous movement
      if ((RangeCentreTracker >= R0) && (RangeCentreTracker <= R3)) {
        // valid reverse range
        if (Walk == -3) {
          // previously walking backwards so raise lowered legs and continue
          MemRead(); tgtCnt = 1; SubTask = 3; Walk = 3;
        } else {SubTask = 2;} // walking direction changing
      } else if ((zMode > 0) && (RangeCentreTracker >= R4) && (RangeCentreTracker <= RM)) {
        // valid forward range
        if (Walk == -1) {
          // previously walking forwards so lower legs and continue
          MemRead(); tgtCnt = 1; SubTask = 3; Walk = 1;
        } else {SubTask = 2;} // walking direction changing
      }
      if ((zMode == 0) && (!HeadActive)) {
        // check after a delay to see if a return to start movemnent is needed
        // this feature does not work in head active mode, which incorporates steering
        if ((millis() - anyMilli) >= 5000) {
          if (Walked < -44) {SubTask++;} // at least half a stride backwards
          else {anyMilli = millis();}
        }
      } break;
    case 6:
      walkInterval = 60000;
      Walk = 0; WalkCnt -= 44; if (WalkCnt < 0) {WalkCnt += 88;}
      SetLegStates(); // set leg heights
      LedMode = 1; SubTask++; break;
    case 7:
      // prepare to walk back to the start point
      // change direction of walk movement to forward
      walkInterval = 40000; Walk = 1;
      SubTask++; break;
    case 8: // reached beginning or seen another wall
//      Serial.print(F("Walked = ")); Serial.println(Walked);
      if (((RangeCentreTracker >= R0) && (RangeCentreTracker <= R3)) || (Walked >= -1)) {
        Walk = 0; SubTask = 1; LedMode = 0;
        GoToAngles(-1,LegDn,-1,LegDn,-1,LegDn,-1,LegDn,-1);
      }
      // if approaching start point slow down
      if (Walked > -100) {if (walkInterval < 40000) {walkInterval += 200;}}
      else if (walkInterval > 10000) {walkInterval -= 100;}
      break;
    case 99:
      // one cycle to allow leg heights to be set before moving
      Walk = WalkNext; SubTask = 3; break;
  } MainRun = false;
//  Serial.print("0"); Serial.print("\t"); Serial.println(RangeCentreTracker);
}

// ----------------------------------------------------------------------

void MoveToAngles(int zA1,int zA2,int zA3,int zA4,int zA5,int zA6,int zA7,int zA8) {
  // move to specific servo angles by raising and lowering legs
  // number of 20ms steps in movement set by zCnt
  if (ESC) return; // exit if this flag is set
  if (!servoEn) {attachServos(0);}
  anyDel = 120;
  GoToAngles(-1,LegDn,-1,LegDn,-1,LegDn,-1,LegDn,3);
  SetAngle(10,zA1); // get the target angle in microseconds, but don't move the servo
  if (servoVal[0] != servoTgt[0]) {
    SetAngle(1,LegUp); delayLoop(anyDel); SetAngle(0,zA1); delayLoop(anyDel);
  } SetAngle(1,zA2);
  SetAngle(12,zA3); // get the target angle in microseconds, but don't move the servo
  if (servoVal[2] != servoTgt[2]) {
    SetAngle(3,LegUp); delayLoop(anyDel); SetAngle(2,zA3); delayLoop(anyDel);
  } SetAngle(3,zA4);
  SetAngle(14,zA5); // get the target angle in microseconds, but don't move the servo
  if (servoVal[4] != servoTgt[4]) {
    SetAngle(5,LegUp); delayLoop(anyDel); SetAngle(4,zA5); delayLoop(anyDel);
  } SetAngle(5,zA6);
  SetAngle(16,zA7); // get the target angle in microseconds, but don't move the servo
  if (servoVal[6] != servoTgt[6]) {
    SetAngle(7,LegUp); delayLoop(anyDel); SetAngle(6,zA7); delayLoop(anyDel);
  } SetAngle(7,zA8);  delayLoop(anyDel);
  if (autoOFF >= 0) {autoOFF = 5;} // set auto-OFF timeout
}

// ----------------------------------------------------------------------

void SetheadTgtCnt(int zAngDif) {
    // sets the movement count value based on the displacement AngDif
    headTgtCnt = (12 * zAngDif)/AngDifMax;
    if (headTgtCnt < 1) {headTgtCnt = 1;}
}

// ----------------------------------------------------------------------

void SetLegStates() {
  // set leg heights depending on WalkCnt, used when reversing direction
  LegSt1 = LegDn; LegSt3 = LegDn; LegSt5 = LegDn; LegSt7 = LegDn;
  if ((WalkCnt > 1) && (WalkCnt < 44)) {LegSt3 = LegUp; LegSt7 = LegUp;}
  else if (WalkCnt > 45) {LegSt1 = LegUp; LegSt5 = LegUp;}
  GoToAngles(-1,LegSt1,-1,LegSt3,-1,LegSt5,-1,LegSt7,-1);
}

// ----------------------------------------------------------------------

void SetLegsDown() {
  // stores the leg positions then puts them all down on the floor
  MemStore();
  SetAngle(1,LegDn); SetAngle(3,LegDn); SetAngle(5,LegDn); SetAngle(7,LegDn);
}

// ----------------------------------------------------------------------

void SetLegsPrevious() {
  // recover stored leg positions
  MemRead(); SetToTgtNow();
}

// ----------------------------------------------------------------------

void StartWalk(int zWalk) {
  // initiates one of four walk directions
  // if zWalk is -ve then position feet but don't walk
  // 0 - stationary
  // 1 - walk forward
  // 2 - walk to the right
  // 3 - walk backwards
  // 4 - walk to the left
  // 5 - turn to the left
  // 6 - turn to the right
  Walk = 0; WalkCnt = 21; // stop walking and set start points
  switch (abs(zWalk)) {
    case 0: MoveToAngles(111,LegDn,112,LegDn,114,LegDn,113,LegDn); break;
    case 1: MoveToAngles(111,LegDn,112,LegDn,114,LegDn,113,LegDn); break;
    case 2: MoveToAngles(67,LegDn,69,LegDn,68,LegDn,66,LegDn); break;
    case 3: MoveToAngles(114,LegDn,113,LegDn,111,LegDn,112,LegDn); break;
    case 4: MoveToAngles(68,LegDn,66,LegDn,67,LegDn,69,LegDn); break;
    case 5: MoveToAngles(69,LegDn,67,LegDn,69,LegDn,67,LegDn); break;
    case 6: MoveToAngles(67,LegDn,69,LegDn,67,LegDn,69,LegDn); break;
  }
  Walk = zWalk; // start walking if Walk > 0
  if (zWalk >= 0) {
    SetLedMode(Walk);
  }
}
// ----------------------------------------------------------------------

void TurnLeft(int zAng, int zStep, int zCnt) {
  // neutral turn to the left by a given angle, step and speed
  // note that speed can also be set by walkInterval loop period
  // zStep should be >= 1 and <= 45
  // the actual angle turned is approximately (zAng * 28)/45
  // if zAng < 0 then don't move legs to the drop position, assume already there
  int zSwg; zStep = max(zStep,1); zStep = min(zStep,45); // ensure zStep is in range
//  Serial.print(F("> TurnRight(")); Serial.print(zAng); Serial.println(F(")"));
  MoveToAngles(90,LegDn,90,LegDn,90,LegDn,90,LegDn); loopWhiletgtCnt(); // drop to move angle
  SetLedMode(4); TurnCnt = zCnt;
  while (zAng > 0) {
    // move a max of 10 degrees on each opposite leg set at a time
    // FL and RR legs first
    if (Turn) {zSwg = zStep; zAng = zStep;} // turning continuously
    else {zSwg = min(zAng,zStep); zAng = zAng - zSwg;} // turning through an angle
    GoToAngles(-1,LegUp,-1,-1,-1,LegUp,-1,-1,3); // raise FL RR legs quickly
//    delayLoop(2);
    GoToAngles(90+zSwg,-1,-1,-1,90+zSwg,-1,-1,-1,TurnCnt); // swing legs quickly
//    delayLoop(2);
    GoToAngles(-1,LegDn,-1,-1,-1,LegDn,-1,-1,3); // drop legs quickly
//    delayLoop(2);
    GoToAngles(-1,-1,-1,LegUp,-1,-1,-1,LegUp,3); // raise legs quickly
//    delayLoop(2);
    GoToAngles(90,-1,-1,-1,90,-1,-1,-1,TurnCnt); // swing legs quickly
//    delayLoop(2);
    if (zAng < 1) {
      GoToAngles(-1,-1,-1,LegDn,-1,-1,-1,LegDn,3); // drop legs quickly
    } else {
      Turning = true; // set turning flag once I've turned one step of the angle
      TurnCnt++; // slowly decrease the speed
      if (Turn) {zSwg = zStep; zAng = zStep;} // turning continuously
      else {zSwg = min(zAng,zStep); zAng = zAng - zSwg;} // turning through an angle
      // FR and RL legs
      GoToAngles(-1,-1,-1,LegUp,-1,-1,-1,LegUp,3); // raise FR RL legs quickly
//      delayLoop(2);
      GoToAngles(-1,-1,90-zSwg,-1,-1,-1,90-zSwg,-1,TurnCnt); // swing legs quickly
//      delayLoop(2);
      GoToAngles(-1,-1,-1,LegDn,-1,-1,-1,LegDn,3); // drop legs quickly
//      delayLoop(2);
      GoToAngles(-1,LegUp,-1,-1,-1,LegUp,-1,-1,3); // raise legs quickly
//      delayLoop(2);
      GoToAngles(-1,-1,90,-1,-1,-1,90,-1,TurnCnt); // swing legs quickly
//      delayLoop(2);
      if (zAng < 1) {
        GoToAngles(-1,LegDn,-1,-1,-1,LegDn,-1,-1,3); // drop legs quickly
//        delayLoop(2);
      }
    } TurnCnt++; // slowly decrease the speed
  } SetLedMode(0); Turning = false;
}

// ----------------------------------------------------------------------

void TurnRight(int zAng, int zStep, int zCnt) {
  // neutral turn to the right by a given angle, step and speed
  // note that speed can also be set by walkInterval loop period
  // zStep should be >= 1 and <= 45
  // the actual angle turned is approximately (zAng * 28)/45
  // if zAng < 0 then don't move legs to the drop position, assume already there
  int zSwg; zStep = max(zStep,1); zStep = min(zStep,45); // ensure zStep is in range
//  Serial.print(F("> TurnRight(")); Serial.print(zAng); Serial.println(F(")"));
  MoveToAngles(90,LegDn,90,LegDn,90,LegDn,90,LegDn); loopWhiletgtCnt(); // drop to move angle
  SetLedMode(2); TurnCnt = zCnt;
  while (zAng > 0) {
    // move a max of 10 degrees on each opposite leg set at a time
    // FR and RL legs first
    if (Turn) {zSwg = zStep; zAng = zStep;} // turning continuously
    else {zSwg = min(zAng,zStep); zAng = zAng - zSwg;} // turning through an angle
    GoToAngles(-1,-1,-1,LegUp,-1,-1,-1,LegUp,3); // raise FR RL legs quickly
//    delayLoop(2);
    GoToAngles(-1,-1,90+zSwg,-1,-1,-1,90+zSwg,-1,TurnCnt); // swing legs quickly
//    delayLoop(2);
    GoToAngles(-1,-1,-1,LegDn,-1,-1,-1,LegDn,3); // drop legs quickly
//    delayLoop(2);
    GoToAngles(-1,LegUp,-1,-1,-1,LegUp,-1,-1,3); // raise legs quickly
//    delayLoop(2);
    GoToAngles(-1,-1,90,-1,-1,-1,90,-1,TurnCnt); // swing legs quickly
//    delayLoop(2);
    if (zAng < 1) {
      GoToAngles(-1,LegDn,-1,-1,-1,LegDn,-1,-1,3); // drop legs quickly
//      delayLoop(2);
    } else {
      Turning = true; // set turning flag once I've turned one step of the angle
      TurnCnt++; // slowly decrease the speed
      if (Turn) {zSwg = zStep; zAng = zStep;} // turning continuously
      else {zSwg = min(zAng,zStep); zAng = zAng - zSwg;} // turning through an angle
      // FL and RR legs
      GoToAngles(-1,LegUp,-1,-1,-1,LegUp,-1,-1,3); // raise FL RR legs quickly
//      delayLoop(2);
      GoToAngles(90-zSwg,-1,-1,-1,90-zSwg,-1,-1,-1,TurnCnt); // swing legs quickly
//      delayLoop(2);
      GoToAngles(-1,LegDn,-1,-1,-1,LegDn,-1,-1,3); // drop legs quickly
//      delayLoop(2);
      GoToAngles(-1,-1,-1,LegUp,-1,-1,-1,LegUp,3); // raise legs quickly
//      delayLoop(2);
      GoToAngles(90,-1,-1,-1,90,-1,-1,-1,TurnCnt); // swing legs quickly
//      delayLoop(2);
      if (zAng < 1) {
        GoToAngles(-1,-1,-1,LegDn,-1,-1,-1,LegDn,3); // drop legs quickly
//        delayLoop(2);
      }
    } TurnCnt++; // slowly decrease the speed
  } SetLedMode(0); Turning = false;
}

// ----------------------------------------------------------------------



