
// ----------------------------------------------------------------------

void arrest(int zMT) {
  // called on the button count == 1 to ensure it is arrested from any movement
  MainTask = -1; SubTask = 0; ESC = true; walkInterval = 20000;
  if (HeadActive) {HeadTask = 0; HeadTgt = Head_0; headTgtCnt= 10;} // centre head
  MainTaskNext = zMT;
}

// ----------------------------------------------------------------------

void attachHeadServo() {
  // create head servo and attach it to pin 2
  if (ESC) return;
  servoHeadEn = true;
  servoHead.attach(servoHeadPin);
  servoHead.writeMicroseconds(HeadVal);
  HeadTgt = HeadVal; // correct target positions
}

// ----------------------------------------------------------------------

void attachServos(int zDel) {
  // create 8 servos and attach them to pins
  // delay used during power-up reset, otherwiswe set to 0
  if (ESC) return;
  servoEn = true;
  for (int zP = 0; zP < 8;zP++) {
    servoInst[zP].attach(servoPins[zP]);
    servoInst[zP].writeMicroseconds(servoVal[zP]); delay(zDel);
    servoTgt[zP] = servoVal[zP]; // correct target positions
  }
}

// ----------------------------------------------------------------------

void BatteryFailed() {
  // if battery voltage drops below trigger level for more than 1 second
  detachServos();
  Serial.println(F("Battery Voltage LOW!"));
  digitalWrite(LED0, HIGH); digitalWrite(LED1, HIGH); digitalWrite(LED2, HIGH);
  digitalWrite(LED3, HIGH); digitalWrite(LED4, HIGH);
  // flash centre LED for a short while
  for (int zL = 0; zL < 30; zL++) {
    digitalWrite(LED2, LOW); delay(20);
    digitalWrite(LED2, HIGH); delay(980);
  }
  Serial.println(F("Entering lockdown...."));
  while (true) {} // do nothing forever
}

// ----------------------------------------------------------------------

void checkTgts() {
  // ensure that set targets are within servo min/max limits
  servoTgt[0] = min(servoTgt[0],Max1); servoTgt[0] = max(servoTgt[0],Min1);
  servoTgt[1] = min(servoTgt[1],Max2); servoTgt[1] = max(servoTgt[1],Min2);
  servoTgt[2] = min(servoTgt[2],Max3); servoTgt[2] = max(servoTgt[2],Min3);
  servoTgt[3] = min(servoTgt[3],Max4); servoTgt[3] = max(servoTgt[3],Min4);
  servoTgt[4] = min(servoTgt[4],Max5); servoTgt[4] = max(servoTgt[4],Min5);
  servoTgt[5] = min(servoTgt[5],Max6); servoTgt[5] = max(servoTgt[5],Min6);
  servoTgt[6] = min(servoTgt[6],Max7); servoTgt[6] = max(servoTgt[6],Min7);
  servoTgt[7] = min(servoTgt[7],Max8); servoTgt[7] = max(servoTgt[7],Min8);
}

// ----------------------------------------------------------------------

void detachHeadServo() {
  // detach head servo
  servoHeadEn = false;
  servoHead.detach();
}

// ----------------------------------------------------------------------

void detachServos() {
  // detach all servos
  servoEn = false;
  for (int zP = 0; zP < 8;zP++) {servoInst[zP].detach();}
}

// ----------------------------------------------------------------------

void flashLEDs(int zCnt) {
  // flash the left and right LED swCnt times  
  for (int zP = 0; zP < zCnt; zP++) {
    digitalWrite(LED0, LOW); digitalWrite(LED4, LOW); delay(30);
    digitalWrite(LED0, HIGH); digitalWrite(LED4, HIGH); delay(270);
  }
}

// ----------------------------------------------------------------------

void flashWhilstDown(int zON,int zOFF) {
  // flash LEDs whilst waiting for button switch to be released
  while (analogRead(A6) <= 16) {
    digitalWrite(LED0, LOW); digitalWrite(LED4, LOW);
    delay(zON);
    digitalWrite(LED0, HIGH); digitalWrite(LED4, HIGH);
    if (analogRead(A6) > 16) {break;}
    delay(zOFF);
  }
}

// ----------------------------------------------------------------------

void MemRead() {
  // reads the stored servo values into target values
  for (anyFor = 0;anyFor < 8;anyFor++) {servoTgt[anyFor] = servoMem[anyFor];}
}

// ----------------------------------------------------------------------

void MemStore() {
  // stores the current servo values in a memory store
  for (anyFor = 0;anyFor < 8;anyFor++) {servoMem[anyFor] = servoVal[anyFor];}
}

// ----------------------------------------------------------------------

//void PrintBinary(int zB) {
//  // print a byte value in binary
//  if (zB < 128) {Serial.print("0");}
//  if (zB < 64) {Serial.print("0");}
//  if (zB < 32) {Serial.print("0");}
//  if (zB < 16) {Serial.print("0");}
//  if (zB < 8) {Serial.print("0");}
//  if (zB < 4) {Serial.print("0");}
//  if (zB < 2) {Serial.print("0");}
//  Serial.print(zB,BIN);
//  Serial.print("  ");
//  Serial.println(zB);
//}

// ----------------------------------------------------------------------

//void PrintWalkSpeed() {
//  // call by functions changing walk speed  
//  Serial.print(F("WalkSpeed=")); Serial.println(WalkSpeed);
//}

// ----------------------------------------------------------------------

void readSwitch() {
  // read the button switch and respond accordingly, pressed == LOW
  // a button press will automatical drop the current task
  swState = HIGH;
  // check for low voltage on the switch pin for button press
  if (BattVol <= 16) {swState = LOW; LedMode = 99; LedCnt = 150;} 
  LED0St = swState;
  if ((swLastState == HIGH) && (swState == LOW)) {
    swCnt++; // count on the falling edge
    swTimer = 0; // reset the timer
//    LedMode = 0;
//    if (swCnt == 1) {arrest(0);} // ensure that if it was moving stop it!
    if (swCnt == 1) {SetMainTask(99);} // ensure that if it was moving stop it!
  }
  swLastState = swState; // record current state
  if (swCnt > 0) {swTimer++;}
  if (swTimer == 10) {ESC = false;} // reset ESC flag after 200 ms
  if ((swTimer >= 50) && (swState == HIGH)) {
    // button released for 1 sec so assume valid button count
//    Serial.print(F("swCnt = ")); Serial.println(swCnt);
    flashLEDs(swCnt); // indicate count by flashing
    if (swCnt == 1) {SetMainTask(1); QuadActive = true;} // goto default state
    else if (QuadActive) {
      // only respond to these counts if stood up and active
      // swCnt == 2 backaway from target mode
      // swCnt == 3 track wall target mode
      // swCnt == 4 autonomous discovery mode
      SetMainTask(swCnt);
    }
    swCnt = 0; swTimer = 0; synchLoopTimers();
  } else if((swTimer >= 100) && (swState == LOW)) {
    // button held down for >=2 seconds
    swCnt = 0; swTimer = 0; LedMode = 0;
    if (!QuadActive) {
      // robot was inactive so stand it up and enable head scanning
      HeadActive = true; flashWhilstDown(20,150);
      SetMainTask(1); // go to default state
//      Serial.println(F("Standing Up!"));
      QuadActive = true; synchLoopTimers(); autoOFF = 10;
    } else {
      // robot was active so return it to the reset state
      flashWhilstDown(20,300);
      synchLoopTimers();
      GoToRest(50); // go to the resting position within 1 second
//      Serial.println(F("Going To Rest..."));
//      loopWhiletgtCnt();
      QuadActive = false; VL53L0X_Disable(); HeadActive = false;
    }
  }
}

// ----------------------------------------------------------------------

void SetAngle(int zS, int zA) {
  // sets a specific servo zS to an angle zA immediately
  // if zS >= 10 then set target only and don't move the servo
  // note servos are numbered 0 - 7, not 1 - 8
  if (ESC) return;
  if (!servoEn) {attachServos(0);}
  anyVal = 0; if (zS >= 10) {zS = zS - 10; anyVal = 1;}
  if (zA >= 0) {
    switch (zS) {
      case 0: servoTgt[0] = map(zA,45,135,Ang1_45,Ang1_135); break;
      case 1: servoTgt[1] = map(zA,65,153,Ang2_65,Ang2_153); break;
      case 2: servoTgt[2] = map(zA,45,135,Ang3_45,Ang3_135); break;
      case 3: servoTgt[3] = map(zA,65,153,Ang4_65,Ang4_153); break;
      case 4: servoTgt[4] = map(zA,45,135,Ang5_45,Ang5_135); break;
      case 5: servoTgt[5] = map(zA,65,153,Ang6_65,Ang6_153); break;
      case 6: servoTgt[6] = map(zA,45,135,Ang7_45,Ang7_135); break;
      case 7: servoTgt[7] = map(zA,65,153,Ang8_65,Ang8_153); break;
    }
    if (anyVal < 1) {
      // zS is not >= 10 so set servo immediately
      if (servoVal[zS] != servoTgt[zS]) {
        servoVal[zS] = servoTgt[zS]; servoInst[zS].writeMicroseconds(servoVal[zS]);
      }
    }
  }
}

// ----------------------------------------------------------------------

void SetAngle45To90(int zS, int zA) {
  // this is called to correct leg swing non-linearity, which occurs near
  // the 90 degree angle range. Angles near 45 degrees are not affected.
  if (zA >= 74) {zA++;
    if (zA >= 80) {zA++;
      if (zA >= 84) {zA++;
        if (zA >= 87) {zA++;
          if (zA >= 90) {zA++;
          }
        }
      }
    }
  }
  // now set the angle as if normal
  SetAngle(zS,zA);
}

// ----------------------------------------------------------------------

void SetAngle90To135(int zS, int zA) {
  // this is called to correct leg swing non-linearity, which occurs near
  // the 90 degree angle range. Angles near 135 degrees are not affected.
  if (zA <= 106) {zA--;
    if (zA <= 100) {zA--;
      if (zA <= 96) {zA--;
        if (zA <= 93) {zA--;
          if (zA <= 90) {zA--;
          }
        }
      }
    }
  }
  // now set the angle as if normal
  SetAngle(zS,zA);
}

// ----------------------------------------------------------------------

void SetLedMode(int zM) {
  // sets the mode and clears the counter
  LedMode = zM; LedCnt = 0;
}

// ----------------------------------------------------------------------

void SetMainTask(int zMT) {
  // sets the main task and associated flags
  // immediately stop any movement
  tgtCnt = 0;
  Walk = 0;
  if (zMT < 99) {
    // 2 second pause before head becomes active in all active modes
    HeadPause = 100;
  } else {
    // user has pressed the button
    // mode 99 returns all to the standing mode of MainTask 1
    HeadPause = 0; zMT = 0;
    if (QuadActive) {GoToStand(50);} else {GoToRest(50);}
    autoOFF = 5;
  }
  autoOFF = 5;
  ESC = false;
  HeadTask = 0; // effectively turn off head movement tasks
  headInterval = 20000; // main loop head movement interval in microseconds
  VL53L0X_Disable(); // laser ranging task disabled by default
  MainRun = false;
  MainTask = zMT;
  Range = LtofMax;
  SetLedMode(0); // remove any LED flashing
  SubTask = 0;
  Turn = false; // default = false; if true turns continuously until = false
  Walked = 0; // counter used to return robot to a given position
  walkInterval = 20000; synchLoopTimers();
  WalkLftDrive = 128; // drive factor for left-hand side, 128 = max, 0 = min
  WalkRgtDrive = 128; // drive factor for right-hand side, 128 = max, 0 = min
  if (HeadActive) {HeadToRest();}
  switch(MainTask) {
    case 1:
      VL53L0X_Enable(); // enable laser ranging task
      if (HeadActive) {HeadTask = 1;} // activate scanning
      SetLedMode(5); break;
    case 2:
      VL53L0X_Enable(); // enable back away task
      if (HeadActive) {HeadTask = 1;} // activate scanning
      break;
    case 3:
      VL53L0X_Enable(); // enable target tracking task
      if (HeadActive) {HeadTask = 1;} // activate scanning
      break;
    case 4:
      VL53L0X_Enable(); // enable autonomous task
      if (HeadActive) {HeadTask = 1;} // activate scanning
      break;
  }
  Serial.print(F("MainTask = ")); Serial.println(MainTask);
}

// ----------------------------------------------------------------------

void SetToTgtNow() {
  // set servos to target values immediately, if not at targets
  for (anyFor = 0;anyFor < 8;anyFor++) {
    if (servoVal[anyFor] != servoTgt[anyFor]) {
      servoVal[anyFor] = servoTgt[anyFor]; servoInst[anyFor].writeMicroseconds(servoVal[anyFor]);
    }
  }
}

// ----------------------------------------------------------------------

void VL53L0X_Disable() {
  // switches OFF the VL53L0X device inhibiting the laser
  digitalWrite(XSHUT,LOW); // disable the VL53L0X
  LTOF_On = 0; // reset the measurement statemachine
}

// ----------------------------------------------------------------------

void VL53L0X_Enable() {
  // switches ON and initialises the VL53L0X device
  digitalWrite(XSHUT,HIGH); // enable the VL53L0X
  VL53L0X_init(true); delay(10);
  VL53L0X_setTimeout(500);

  // Start continuous back-to-back mode (take readings as
  // fast as possible).  To use continuous timed mode
  // instead, provide a desired inter-measurement period in
  // ms (e.g. sensor.startContinuous(100)).
  VL53L0X_startContinuous(); delay(10);
  LTOF_On = 1; // restart the measurement statemachine
}

// ----------------------------------------------------------------------


