
// Called from a mouse move this presents help messages for areas under
// the mouse pointer.

void Help_Message() {
  Help$ = "-";
  // top row
  if ((mY >= 12) && (mY <= 37) && (AppMode == 0)) {
    // frequency field
    if ((mX > 454) && (mX < 469)) {Help$ = "Click to decrement PWM frequency.";}
    if ((mX > 469) && (mX < 511)) {Help$ = "PCA9685 PWM frequency (Hz).  Click to reset.";}
    if ((mX > 511) && (mX < 525)) {Help$ = "Click to increment PWM frequency.";}

    // dither field
    if ((mX > 552) && (mX < 567)) {Help$ = "Click to decrement dither offset.";}
    if ((mX > 567) && (mX < 610)) {
      Help$ = "Dither offset. ";  
      if (Dither) {Help$ += "Click to DISABLE dither signal.";}
      else {Help$ += "Click to ENABLE dither signal.";}
    }
    if ((mX > 610) && (mX < 623)) {Help$ = "Click to increment dither offset.";}
  }
  if ((mY >= 8) && (mY <= 42)) {
    // OE and RESET buttons
    //if  (AppMode == 0) {
    //  if ((mX > 631) && (mX < 677)) {
    //    if (servoOE > 0) {
    //      Help$ = "PCA9685 OE = HIGH disabled. Click to enable.";
    //    } else {
    //      Help$ = "PCA9685 OE = LOW enabled. Click to disable.";
    //    }
    //  }
    //}
    if ((mX > 701) && (mX < 772)) {Help$ = "Click to send RESET to Arduino.";}
  }

  // channel region?
  if ((mY >= 46) && (mY <= 658)) {
    // clicked somewhere in the channel region, so determine the channel
    int zCh = ((mY-46) * 16)/(658-46); if (zCh > 15) {zCh = 15;}
    
    if ((zCh > 0) || (AppMode < 3)) {
      // in AppMode 3 we do not display help for channel 0
      // channel buttons
      if (mX < 61) {Help$ = "Click to toggle channel " + str(zCh) + " enable.";}
  
      // channel value field
      if ((mX >= 65) && (mX <= 132)) {Help$ = "Channel " + str(zCh) + " slider value.";}
  
      // adjust slider lower limits
      if ((mX > 139) && (mX < 155)) {Help$ = "Click to reduce channel " + str(zCh) + " lower limit.";}
      if ((mX > 207) && (mX < 223)) {Help$ = "Click to increase channel " + str(zCh) + " lower limit.";}
  
      // slider region
      if ((mX >=226) && (mX <243)) {Help$ = "Click to reduce channel " + str(zCh) + " value.";}
      if ((mX >672) && (mX <=687)) {Help$ = "Click to increase channel " + str(zCh) + " value.";}
      if ((mX >=243) && (mX <=672)) {
        // mouse in X-slider region
        Help$ = "Click and drag slider to adjust channel " + str(zCh) + " value.";
      }
  
      // adjust slider upper limits
      if ((mX > 693) && (mX < 709)) {Help$ = "Click to reduce channel " + str(zCh) + " upper limit.";}
      if ((mX > 761) && (mX < 777)) {Help$ = "Click to increase channel " + str(zCh) + " upper limit.";}
  
      // store upper and lower limits
      if ((mX > 154) && (mX < 208)) {Help$ = "Channel " + str(zCh) + " lower limit. Click to set from slider.";}
      if ((mX > 708) && (mX < 762)) {Help$ = "Channel " + str(zCh) + " upper limit. Click to set from slider.";}
      
      // clicked on Mem lamp?
      if ((mX > 784) && (mX < 810) && (AppMode == 0)) {Help$ = "Channel " + str(zCh) + " memory lamp. Click to recall. Hold to store.";}
    }  
  }

  if ((mY >= 666) && (mY <= 691)) {
    // Com, RX, Tx fields
    if ((mX >= 105) && (mX <= 180)) {
      if (comFlag < 1) {Help$ = "USB port is disconnected. Click-left to connect.";}
      else {Help$ = "USB port is connected. Click-right to disconnect.";}
    }
    if ((mX >= 235) && (mX <= 439)) {Help$ = "Messages received from USB port.";}
    if ((mX >= 494) && (mX <= 682)) {Help$ = "Messages sent to the USB port.";}
    if ((mX >= 704) && (mX <= 773) && (AppMode == 0)) {Help$ = "Click to copy stored values to clipboard.";}
    if ((mX >= 696) && (mX <= 779) && (AppMode == 3)) {
      if (msRun) {
        Help$ = "Click to Stop millisecond timer.";
      } else {
        if (msTimer == 0) {
          // timer has not yet run
          Help$ = "Click to Start millisecond timer.";
        } else {
          // display rpm result
          Help$ = str(msTimer) + "ms = " + nf(60000.0/float(msTimer),0,2) + "rpm. Click to restart timer.";
        }
      }
    }
  }

  if ((mY >= 696) && (mY <= 722)) {
    // Help field & TechKnowTone
    if ((mX >= 105) && (mX <= 705)) {Help$ = "Hello";}
    if ((mX >= 710) && (mX <= 806)) {Help$ = "Author: TechKnowTone     Released: " + Released$;}
  }
  
  //if ((mX >= 12) && (mX <= 51) && (mY >= 683) && (mY <= 722)) {Help$ = "Click to change App mode.";}
  
  if (!Help$.equals(HelpLast$)) {
    // string is new so display it and remember it
    HelpLast$ = Help$; drawFlag = 1;
  }
  
}
// ----------------------------------------------------------------------
