
// ----------------------------------------------------------------------

void drawBlankouts() {
  // in angle mode so blank out certain form functions
  stroke(255,255,255); strokeWeight(1);
  fill(255,255,255);    // set fill colour
  rect(276,7,423,38);   // hide top controls
  rect(781,31,32,636);  // hide side lamps
  rect(700,658,78,36);  // Copy button
  
  TR=0; TG=0; TB=0;
  if (AppMode == 1) {drawTxtField("- Angle Mode",278,17);}
  if (AppMode == 2) {drawTxtField("- PWM Mode",278,17);}
  if (AppMode == 3) {
    drawTxtField("- LX-16A Servo Mode",278,17);
    TB=255;  // revert to blue text
    // draw timer field
    stroke(0,0,0); strokeWeight(1);
    fill(255,255,255);    // set fill colour white
    rect(696,665,83,26);   // draw field window
    if (msRun) {
      // msTimer is running so display current time difference
      drawTxtCtrField(str(millis() - msTimer),737, 670);
    } else {
      // msTimer n ot running so display timer value
      drawTxtCtrField(str(msTimer),737, 670);
    }
  } TB=255;  // revert to blue text
}

// ----------------------------------------------------------------------

void drawCOMMsg() {
  // put text in COM value field
  if (comFlag < 1) {TR = 255;}  // show text in red if disconnected
  drawTxtCtrField(msgCOM, 147, 672); TR = 0;
}

// ----------------------------------------------------------------------

void drawDither() {
  // put text in the dither field
  if (AppMode > 0) {return;}  // don't draw if not in default mode

  if (comFlag < 1) {TR = 255; TG = 0; TB = 0;}
  else {
    if (Dither){TR = 0; TG = 0; TB = 255; BR = 255; BG = 255; BB = 0;}
    else {TR = 150; TG = 150; TB = 150; BR = 255; BG = 255; BB = 255;}
  }
  if ((comFlag > 0) && Dither) {
    // dither is active so display the changing offset value
    String zTx$ = "  ";
    if (DitherCnt > 25) {
      zTx$ += str(DitherVal);
    } else {
      if (DitherOffset > 0) {zTx$ = " +";}
      zTx$ += str(DitherOffset);
    }
    zTx$ += " "; drawTxtCtrField(zTx$, 588, 18);
  } else {
    // either no COM or Dither active so display value
    drawTxtCtrField("  " + str(DitherVal) +  "  ", 588, 18);
  } TR = 0; TG = 0; TB = 255; BR = 255; BG = 255; BB = 255;
}

// ----------------------------------------------------------------------

void drawFreqMsg() {
  // put text in the Frequency field
  if (AppMode > 0) {return;}  // don't draw if not in default mode

  if (comFlag < 1) {TR = 255; TG = 0; TB = 0;}
  drawTxtCtrField(str(Freq), 490, 18); TR = 0;
}

// ----------------------------------------------------------------------

void drawHelp() {
  // display help messages
  TR = 0; TG = 0; TB = 255;
  drawTxtCtrField(Help$, 408, 702);
}

// ----------------------------------------------------------------------

void drawJoyX() {
  // draw the X joystick slider
  if (comFlag < 1) {return;}  // don't draw if not connected
  if (!data_loaded && (AppMode == 0)) {return;}  // don't draw if no data loaded
  
  int zXw = 16; stroke(0,0,0); 
  strokeWeight(2);
  if (AppMode < 3) {  
    if (Ch_En[0]) {fill(255,100,100);} else {fill(255,255,255);}
    rect(JoyXval[0]-zXw,49,zXw+zXw,30);
  }
  
  if (Ch_En[1]) {fill(255,100,100);} else {fill(255,255,255);}
  rect(JoyXval[1]-zXw,87,zXw+zXw,30);
  if (Ch_En[2]) {fill(255,100,100);} else {fill(255,255,255);}
  rect(JoyXval[2]-zXw,125,zXw+zXw,31);
  if (Ch_En[3]) {fill(255,100,100);} else {fill(255,255,255);}
  rect(JoyXval[3]-zXw,164,zXw+zXw,31);
  
  if (Ch_En[4]) {fill(255,100,100);} else {fill(255,255,255);}
  rect(JoyXval[4]-zXw,202,zXw+zXw,31);
  if (Ch_En[5]) {fill(255,100,100);} else {fill(255,255,255);}
  rect(JoyXval[5]-zXw,240,zXw+zXw,31);
  if (Ch_En[6]) {fill(255,100,100);} else {fill(255,255,255);}
  rect(JoyXval[6]-zXw,279,zXw+zXw,31);
  if (Ch_En[7]) {fill(255,100,100);} else {fill(255,255,255);}
  rect(JoyXval[7]-zXw,317,zXw+zXw,31);
  
  if (Ch_En[8]) {fill(255,100,100);} else {fill(255,255,255);}
  rect(JoyXval[8]-zXw,356,zXw+zXw,31);
  if (Ch_En[9]) {fill(255,100,100);} else {fill(255,255,255);}
  rect(JoyXval[9]-zXw,394,zXw+zXw,31);
  if (Ch_En[10]) {fill(255,100,100);} else {fill(255,255,255);}
  rect(JoyXval[10]-zXw,432,zXw+zXw,31);
  if (Ch_En[11]) {fill(255,100,100);} else {fill(255,255,255);}
  rect(JoyXval[11]-zXw,471,zXw+zXw,31);
  
  if (Ch_En[12]) {fill(255,100,100);} else {fill(255,255,255);}
  rect(JoyXval[12]-zXw,509,zXw+zXw,31);
  if (Ch_En[13]) {fill(255,100,100);} else {fill(255,255,255);}
  rect(JoyXval[13]-zXw,547,zXw+zXw,31);
  if (Ch_En[14]) {fill(255,100,100);} else {fill(255,255,255);}
  rect(JoyXval[14]-zXw,586,zXw+zXw,31);
  if (Ch_En[15]) {fill(255,100,100);} else {fill(255,255,255);}
  rect(JoyXval[15]-zXw,625,zXw+zXw,31);
}

// ----------------------------------------------------------------------

void drawLLMsg() {
  // put text in LL value field
  if (comFlag < 1) {return;}  // don't draw if not connected
  int zX = 182;
  if (AppMode < 3) {drawTxtCtrField("       ", zX, 57); drawTxtCtrField(str(servoVLL[0]), zX, 57);}    // Ch0
  drawTxtCtrField("       ", zX, 95); drawTxtCtrField(str(servoVLL[1]), zX, 95);    // Ch1
  drawTxtCtrField("       ", zX, 134); drawTxtCtrField(str(servoVLL[2]), zX, 134);  // Ch2
  drawTxtCtrField("       ", zX, 172); drawTxtCtrField(str(servoVLL[3]), zX, 172);  // Ch3

  drawTxtCtrField("       ", zX, 211); drawTxtCtrField(str(servoVLL[4]), zX, 211);  // Ch4
  drawTxtCtrField("       ", zX, 249); drawTxtCtrField(str(servoVLL[5]), zX, 249);  // Ch5
  drawTxtCtrField("       ", zX, 288); drawTxtCtrField(str(servoVLL[6]), zX, 288);  // Ch6
  drawTxtCtrField("       ", zX, 326); drawTxtCtrField(str(servoVLL[7]), zX, 326);  // Ch7

  drawTxtCtrField("       ", zX, 364); drawTxtCtrField(str(servoVLL[8]), zX, 364);  // Ch8
  drawTxtCtrField("       ", zX, 402); drawTxtCtrField(str(servoVLL[9]), zX, 402);  // Ch9
  drawTxtCtrField("       ", zX, 440); drawTxtCtrField(str(servoVLL[10]), zX, 440); // Ch10
  drawTxtCtrField("       ", zX, 479); drawTxtCtrField(str(servoVLL[11]), zX, 479); // Ch11

  drawTxtCtrField("       ", zX, 518); drawTxtCtrField(str(servoVLL[12]), zX, 518);  // Ch12
  drawTxtCtrField("       ", zX, 556); drawTxtCtrField(str(servoVLL[13]), zX, 556);  // Ch13
  drawTxtCtrField("       ", zX, 594); drawTxtCtrField(str(servoVLL[14]), zX, 594);  // Ch14
  drawTxtCtrField("       ", zX, 632); drawTxtCtrField(str(servoVLL[15]), zX, 632);  // Ch15
}

// ----------------------------------------------------------------------

void drawMemlamps() {
  // draw Memory status lamps
  if (comFlag < 1) {return;}   // don't draw if not connected
  if (AppMode > 0) {return;}       // don't draw if in angle mode
  
  stroke(255,255,255); strokeWeight(1);
  for (int zS = 0; zS < 16; zS++) {
    switch(memLamp[zS]) {
      case 0: fill(128,128,128); break; // grey
      case 1: fill(40,210,0); break;    // green - reset value
      case 2: fill(220,220,40); break;  // yellow - modified from reset
      case 3: fill(64,64,255); break;   // blue - stored value
      case 4: fill(210,64,210); break;   // purple - modified from stored value
    }
    switch(zS) {
      case 0: rect(787,53,20,20); break;
      case 1: rect(787,92,20,20); break;
      case 2: rect(787,130,20,20); break;
      case 3: rect(787,168,20,20); break;
      case 4: rect(787,207,20,20); break;
      case 5: rect(787,246,20,20); break;
      case 6: rect(787,284,20,20); break;
      case 7: rect(787,322,20,20); break;
      case 8: rect(787,360,20,20); break;
      case 9: rect(787,399,20,20); break;
      case 10: rect(787,437,20,20); break;
      case 11: rect(787,475,20,20); break;
      case 12: rect(787,514,20,20); break;
      case 13: rect(787,552,20,20); break;
      case 14: rect(787,591,20,20); break;
      case 15: rect(787,629,20,20); break;
    }
  }
}

// ----------------------------------------------------------------------

void drawMouseXY() {
  // draws the value of mouse x,y top left
  // draws a full X/Y axis on the form
  if ((mX != mXL) || (mY != mYL)) {
    // draw full X/Y axis
    stroke(255,0,0,128); strokeWeight(1);
    line(0,mY,823,mY); line(mX,0,mX,731);

    int zX,zY;
    if (mX > 412) {zX = mX - 58;} else {zX = mX + 8;}
    if (mY > 380) {zY = mY - 38;} else {zY = mY + 8;}
    stroke(0,0,0); fill(255,255,255); rect(zX,zY,50,30);
    fill(0,0,0); text("X=" + mX, zX + 4, zY + 13); text("Y=" + mY, zX + 4, zY + 27);
    mXL = mX; mYL = mY;
  }
}

// ----------------------------------------------------------------------

void drawOElamp() {
  // draw OE lamp if active
  if (comFlag < 1) {return;}  // don't draw if not connected
  if (AppMode > 0) {return;}  // don't draw if in angle mode

  if (servoOE > 0) {
    // GREEN off
    fill(20,210,0); 
  } else {
    // RED active
    fill(255,20,0); 
  } stroke(255,255,255); strokeWeight(1); rect(682,10,11,30);
}

// ----------------------------------------------------------------------

void drawRxMsg() {
  // put text in the Rx field
  drawTxtField("                                             ", 242, 672);
  drawTxtField(msgRx, 242, 672);
}

// ----------------------------------------------------------------------

void drawServoVal() {
  // put text in Val field
  if (comFlag < 1) {return;}  // don't draw if not connected
  
  int zX = 82; String zSV$ = ""; int zSD;
  if (mDwn > 0) {DitherOffset = 0;}
  
  if (AppMode < 3) {
    zSV$ = str(servoVal[0]); if (servoTgt == 0) {if (Dither && Ch_En[0]) {
        zSD = servoVal[0] + DitherOffset;
        zSD = max(zSD,servoVLL[0]); zSD = min(zSD,servoVUL[0]);
        zSV$ = str(zSD);
      }
    }
    drawTxtField("       ", zX, 57); drawTxtField(zSV$, zX, 57);    // Ch0
  }
  
  zSV$ = str(servoVal[1]); if (servoTgt == 1) {if (Dither && Ch_En[1]) {
      zSD = servoVal[1] + DitherOffset;
      zSD = max(zSD,servoVLL[1]); zSD = min(zSD,servoVUL[1]);
      zSV$ = str(zSD);
    }
  }
  drawTxtField("       ", zX, 95); drawTxtField(zSV$, zX, 95);    // Ch1

  zSV$ = str(servoVal[2]); if (servoTgt == 2) {if (Dither && Ch_En[2]) {
      zSD = servoVal[2] + DitherOffset;
      zSD = max(zSD,servoVLL[2]); zSD = min(zSD,servoVUL[2]);
      zSV$ = str(zSD);
    }
  }
  drawTxtField("       ", zX, 134); drawTxtField(zSV$, zX, 134);  // Ch2

  zSV$ = str(servoVal[3]); if (servoTgt == 3) {if (Dither && Ch_En[3]) {
      zSD = servoVal[3] + DitherOffset;
      zSD = max(zSD,servoVLL[3]); zSD = min(zSD,servoVUL[3]);
      zSV$ = str(zSD);
    }
  }
  drawTxtField("       ", zX, 172); drawTxtField(zSV$, zX, 172);  // Ch3

  zSV$ = str(servoVal[4]); if (servoTgt == 4) {if (Dither && Ch_En[4]) {
      zSD = servoVal[4] + DitherOffset;
      zSD = max(zSD,servoVLL[4]); zSD = min(zSD,servoVUL[4]);
      zSV$ = str(zSD);
    }
  }
  drawTxtField("       ", zX, 211); drawTxtField(zSV$, zX, 211);  // Ch4

  zSV$ = str(servoVal[5]); if (servoTgt == 5) {if (Dither && Ch_En[5]) {
      zSD = servoVal[0] + DitherOffset;
      zSD = max(zSD,servoVLL[0]); zSD = min(zSD,servoVUL[0]);
      zSV$ = str(zSD);
    }
  }
  drawTxtField("       ", zX, 249); drawTxtField(zSV$, zX, 249);  // Ch5

  zSV$ = str(servoVal[6]); if (servoTgt == 6) {if (Dither && Ch_En[6]) {
      zSD = servoVal[6] + DitherOffset;
      zSD = max(zSD,servoVLL[6]); zSD = min(zSD,servoVUL[6]);
      zSV$ = str(zSD);
    }
  }
  drawTxtField("       ", zX, 288); drawTxtField(zSV$, zX, 288);  // Ch6

  zSV$ = str(servoVal[7]); if (servoTgt == 7) {if (Dither && Ch_En[7]) {
      zSD = servoVal[7] + DitherOffset;
      zSD = max(zSD,servoVLL[7]); zSD = min(zSD,servoVUL[7]);
      zSV$ = str(zSD);
    }
  }
  drawTxtField("       ", zX, 326); drawTxtField(zSV$, zX, 326);  // Ch7

  zSV$ = str(servoVal[8]); if (servoTgt == 8) {if (Dither && Ch_En[8]) {
      zSD = servoVal[8] + DitherOffset;
      zSD = max(zSD,servoVLL[8]); zSD = min(zSD,servoVUL[8]);
      zSV$ = str(zSD);
    }
  }
  drawTxtField("       ", zX, 364); drawTxtField(zSV$, zX, 364);  // Ch8

  zSV$ = str(servoVal[9]); if (servoTgt == 9) {if (Dither && Ch_En[9]) {
      zSD = servoVal[9] + DitherOffset;
      zSD = max(zSD,servoVLL[9]); zSD = min(zSD,servoVUL[9]);
      zSV$ = str(zSD);
    }
  }
  drawTxtField("       ", zX, 402); drawTxtField(zSV$, zX, 402);  // Ch9

  zSV$ = str(servoVal[10]); if (servoTgt == 10) {if (Dither && Ch_En[10]) {
      zSD = servoVal[10] + DitherOffset;
      zSD = max(zSD,servoVLL[10]); zSD = min(zSD,servoVUL[10]);
      zSV$ = str(zSD);
    }
  }
  drawTxtField("       ", zX, 440); drawTxtField(zSV$, zX, 440); // Ch10

  zSV$ = str(servoVal[11]); if (servoTgt == 11) {if (Dither && Ch_En[11]) {
      zSD = servoVal[11] + DitherOffset;
      zSD = max(zSD,servoVLL[11]); zSD = min(zSD,servoVUL[11]);
      zSV$ = str(zSD);
    }
  }
  drawTxtField("       ", zX, 479); drawTxtField(zSV$, zX, 479); // Ch11

  zSV$ = str(servoVal[12]); if (servoTgt == 12) {if (Dither && Ch_En[12]) {
      zSD = servoVal[12] + DitherOffset;
      zSD = max(zSD,servoVLL[12]); zSD = min(zSD,servoVUL[12]);
      zSV$ = str(zSD);
    }
  }
  drawTxtField("       ", zX, 518); drawTxtField(zSV$, zX, 518); // Ch12

  zSV$ = str(servoVal[13]); if (servoTgt == 13) {if (Dither && Ch_En[13]) {
      zSD = servoVal[13] + DitherOffset;
      zSD = max(zSD,servoVLL[13]); zSD = min(zSD,servoVUL[13]);
      zSV$ = str(zSD);
    }
  }
  drawTxtField("       ", zX, 556); drawTxtField(zSV$, zX, 556); // Ch13

  zSV$ = str(servoVal[14]); if (servoTgt == 14) {if (Dither && Ch_En[14]) {
      zSD = servoVal[14] + DitherOffset;
      zSD = max(zSD,servoVLL[14]); zSD = min(zSD,servoVUL[14]);
      zSV$ = str(zSD);
    }
  }
  drawTxtField("       ", zX, 594); drawTxtField(zSV$, zX, 594); // Ch14

  zSV$ = str(servoVal[15]); if (servoTgt == 15) {if (Dither && Ch_En[15]) {
      zSD = servoVal[15] + DitherOffset;
      zSD = max(zSD,servoVLL[15]); zSD = min(zSD,servoVUL[15]);
      zSV$ = str(zSD);
    }
  }
  drawTxtField("       ", zX, 632); drawTxtField(zSV$, zX, 632); // Ch15
}

// ----------------------------------------------------------------------

void drawTxtCtrField(String zM,int zX, int zY) {
  // called by other draw text functions. This centres the text around zX
  zX = zX - (int)(textWidth(zM)/2.0);
  stroke(BR,BG,BB); fill(BR,BG,BB); 
  rect(zX, zY, textWidth(zM), 15);
  fill(TR,TG,TB); text(zM, zX, zY+12);
}

// ----------------------------------------------------------------------

void drawTxMsg() {
  // put text in Tx field
  drawTxtField("                                       ", 498, 672);
  drawTxtField(msgTx, 498, 672);
}

// ----------------------------------------------------------------------

void drawTxtField(String zM,int zX, int zY) {
  // called by other draw text functions
  stroke(242,242,242); fill(242,242,242); 
  rect(zX, zY, 8+textWidth(zM), 14);
  fill(TR,TG,TB); text(zM, zX+4, zY+12);
}

// ----------------------------------------------------------------------

void drawULMsg() {
  // put text in UL value field
  if (comFlag < 1) {return;}  // don't draw if not connected
  int zX = 738;
  if (AppMode < 3) {drawTxtCtrField("       ", zX, 57); drawTxtCtrField(str(servoVUL[0]), zX, 57);}    // Ch0
  drawTxtCtrField("       ", zX, 95); drawTxtCtrField(str(servoVUL[1]), zX, 95);    // Ch1
  drawTxtCtrField("       ", zX, 134); drawTxtCtrField(str(servoVUL[2]), zX, 134);  // Ch2
  drawTxtCtrField("       ", zX, 172); drawTxtCtrField(str(servoVUL[3]), zX, 172);  // Ch3

  drawTxtCtrField("       ", zX, 211); drawTxtCtrField(str(servoVUL[4]), zX, 211);  // Ch4
  drawTxtCtrField("       ", zX, 249); drawTxtCtrField(str(servoVUL[5]), zX, 249);  // Ch5
  drawTxtCtrField("       ", zX, 288); drawTxtCtrField(str(servoVUL[6]), zX, 288);  // Ch6
  drawTxtCtrField("       ", zX, 326); drawTxtCtrField(str(servoVUL[7]), zX, 326);  // Ch7

  drawTxtCtrField("       ", zX, 364); drawTxtCtrField(str(servoVUL[8]), zX, 364);  // Ch8
  drawTxtCtrField("       ", zX, 402); drawTxtCtrField(str(servoVUL[9]), zX, 402);  // Ch9
  drawTxtCtrField("       ", zX, 440); drawTxtCtrField(str(servoVUL[10]), zX, 440); // Ch10
  drawTxtCtrField("       ", zX, 479); drawTxtCtrField(str(servoVUL[11]), zX, 479); // Ch11

  drawTxtCtrField("       ", zX, 518); drawTxtCtrField(str(servoVUL[12]), zX, 518); // Ch12
  drawTxtCtrField("       ", zX, 556); drawTxtCtrField(str(servoVUL[13]), zX, 556); // Ch13
  drawTxtCtrField("       ", zX, 594); drawTxtCtrField(str(servoVUL[14]), zX, 594); // Ch14
  drawTxtCtrField("       ", zX, 632); drawTxtCtrField(str(servoVUL[15]), zX, 632); // Ch15
}
