
// --------------------------------------------------------------------------------

void CheckDispTx() {
  // Called every 40ms to check Monitor+ auto time-out.
  // When count reaches zero, DispMon is set to false
  if (DispTx > 0) {DispTx--; if (DispTx == 0) {DispMon = false;}}
}

// --------------------------------------------------------------------------------

void CheckWiFiConnected() {
  // If connected to WiFi do the following data reads
  if (WiFiConnected) {
    readWii(); // if connected to WiFi read Wii data and respond
    if ((WiiType == 'C') || (WiiType == 'P')) {ReadWiiClassic();}
  }
}

// --------------------------------------------------------------------------------

void CheckWiFiFailed() {
  // If WiFi fails stop movement and trigger autoRest
  // if readWiiCall == true then we are currently locked in a movement, so ignore timeout
  if (BotActive && (RTxTimeout > 0) & !readWiiCall) {
    RTxTimeout--;
    if (RTxTimeout == 1) {
      Serial.println("WiFi failed!...");
      SetMainMode(0);
    }
  }
}

// --------------------------------------------------------------------------------

void CheckWiFiPing() {
  // This function detects the loss of a WiFi connection to a transcevier, by counting
  // down the time since receiving the last data.
  if (WiFiPing > 0) {
    WiFiPing--;
    if (WiFiPing < 1) {
        // we have stopped receiving, so disconnect WiFi
      WiFiDisconnect();
      ESP_NOW_BA = -1;
      WiFiTryOnce = true;
    //  Serial.println("WiFiPing == 0");
    }
  }
}

// --------------------------------------------------------------------------------

void CheckWiFiReconnect() {
  // If not connected to WiFi, then try to connect every second
  if (!WiFiConnected) {
    // Only try to connect WiFi if no 'Pings' are being received
    if (Ping == 0) {
      WiFiConCnt--; if (WiFiConCnt < 1) {
        WiFiConCnt = 10; WiFiTryToConnect();
      // if (WiFiTryOnce) {Serial.println("Trying to connect: " + getBAhex());}
      // Serial.println("Trying to connect: " + getBAhex());
      // Serial.println("Trying to connect WiFi");
      }
    }
  }
}

// --------------------------------------------------------------------------------

void MainTask_Auton_Moves() {
  // Loads a move sequence into the Move[] arrays and initiates a movement.
  switch (MainSub) {
    case  0: // Initialise
      MoveCnt = 0;                        // Always reset the load pointer
      // Load a series of moves into the memory array
      //        FL, FR, RC, Ctrl
      MoveLoad(  0,  0,  0, 62,  0);      // Pause before start
      MoveLoad( 60, 60, 60, 62,  0);      // neutral turn right
      MoveLoad(  0,  0,  0, 62,  0);      // STOP
      MoveLoad(-60,-60,-60,124,  0);      // neutral turn left, double distance
      MoveLoad(  0,  0,  0, 62,  0);      // STOP
      MoveLoad( 60, 60, 60, 62,  0);      // neutral turn right
      MoveLoad(  0,  0,  0, 62,  0);      // STOP
      MoveLoad( 60,-60, 0, 62,  0);       // drive forwards
      MoveLoad(  0,  0,  0, 62,  0);      // STOP
      MoveLoad( 35, 35,-70, 62,  0);      // slide drive right
      MoveLoad(  0,  0,  0, 62,  0);      // STOP
      MoveLoad(-60, 60,  0, 62,  0);      // drive backwards
      MoveLoad(  0,  0,  0, 62,  0);      // STOP
      MoveLoad(-35,-35, 70, 62,  0);      // slide drive left
      MoveLoad(  0,  0,  0, 62,  0);      // STOP
      SetLedMode(12);                     // Pulsing red ring
      MainCnt = 5;
      MainDel = 125; MainSub++; break;    // delay start by 2 seconds
    case 1: // Perform count down
      OLED_Text1S24(String(MainCnt)); // display countdown
      MainCnt--; MainDel = 63;        // count down in seconds
      if (MainCnt < 0) {
        MainSub++;                    // switch to next subtask
        OLED_Del = 5;
        SetLedMode(20);               // set LEDs to auton driving mode
        LedNext = -1;                 // set flag to reset on 1st LED pattern
        MovePnt = 0;                  // start the Move Engine
      } break;
    case 2: // Wait for end of movements
      if (MovePnt < 0) {NewTask = 0; SetMainMode(3);} // Exit
      break;
  }
}

// --------------------------------------------------------------------------------

void MainTask_LDR_Sense() {
  // This task sits whilst the user observes LDR values.
  switch (MainSub) {
    case  0: // Initialise
      AtState = At_LDR;       // Set state for display
      SetLedMode(2);
      MainDel = 125; MainSub++; break;  // delay start by 2 seconds
    case  1: // wait state
      break;
  }
}

// --------------------------------------------------------------------------------

void MainTask_LDR_Turn() {
  // This task turns the Omni-Bot left/right in response to light shining on it.
  // It will turn towards the brightest light source in the room.
  // If a torch is shon onto it, it will also turn towards that.
  // This task runs every 16ms.
  switch (MainSub) {
    case  0: // Initialise
      AtState = At_LDR;       // Set state for display
      PwmEn = true;           // enable motor drive
      TuneRef[0] = "Db:"; TuneInt[0] = 10;
      TuneRef[1] = "ErrDiv:"; TuneInt[1] = 7;
      TuneRef[2] = "Drive_P:"; TuneInt[2] = 0;
      TuneRef[3] = "Drive_I:"; TuneInt[3] = 0;
      SetLedMode(13); LedNext = 2;    // flash red LEDs
      MainDel = 125; MainSub++; break;  // delay start by 2 seconds
    case  1:
      // Tracking function
      int16_t zErr = LDR0 - LDR1;
      int16_t zDrv;
      if (abs(zErr) > TuneInt[0]) {
        // Error exceeds deadband limit
        if (zErr > 0) {
          // Light is strongest on the left
          TuneInt[2] = zErr/TuneInt[1];
          TuneInt[3]+= 1; if (TuneInt[3] > 10) TuneInt[3] = PWM_StartMin;
          zDrv = TuneInt[2] + TuneInt[3];
          if (zDrv > 255) {zDrv = 255;}
          MotorPWM(zDrv,zDrv,zDrv);
        } else {
          // Light is strongest on the right
          TuneInt[2] = zErr/TuneInt[1];
          TuneInt[3]-= 1; if (TuneInt[3] < -10) TuneInt[3] = -PWM_StartMin;
          zDrv = TuneInt[2] + TuneInt[3];
          if (zDrv < -255) {zDrv = -255;}
          MotorPWM(zDrv,zDrv,zDrv);
        }
      } else {
        // Within deadband, so stop
        PWM_OFF(); TuneInt[2] = 0; TuneInt[3] = 0;
      }
      break;
  }
}

// --------------------------------------------------------------------------------

void MainTask_LDR_Follow() {
  // This tasks causes the Omni-Bot to follow a light source
  switch (MainSub) {
    case  0: // Initialise
      AtState = At_LDR;       // Set state for display
      SetLedMode(2);
      MainDel = 125; MainSub++; break;  // delay start by 2 seconds
    case  1: // wait state
      break;
  }
}

// --------------------------------------------------------------------------------

void MainTask_Sonar_Backaway() {
  // This tasks causes the Omni-Bot to backaway from approaching objects.
  // It also turns when it sees side objects.
  bool zSTOP = false;   // clear the STOP flag
  switch (MainSub) {
    case  0: // Initialise
      AtState = At_SONAR;       // Set state for display
      DispMode = DM_Auton;      // set Monitor+ display to Auton
      TaskMsg = "Ready";
      Rng0 = 260; Rng1 = 160; Rng2 = 95; Rng3 = 30;
      TuneInt[0] = 120; TuneRef[0] = "SpdMax:";
      TuneInt[1] = 100; TuneRef[1] = "RetSpd:";
      ClearTachos();
      SetLedMode(13); LedNext = 3;      // flash red LEDs
      MainDel = 125; MainSub++; break;  // delay start by 2 seconds
    case  1: // stop state
      TaskMsg = "Ready";
      MainTime = 0;
      // Check for range within sensor region?
      if ((RangeVal[0] <= Rng0) || (RangeVal[0] >= Rng3)) {MainSub = 10; break;}
      // Check for out of sense region
      if (RangeVal[0] > Rng0) {MainSub = 20; break;}
      // Stop motors and wait
      zSTOP = true; break;
    
    case 10: // Backaway
      if (RangeVal[0] > Rng0) {MainSub = 20; break;} // Target lost
      TaskMsg = "Backaway";
      if ((RangeVal[0] <= Rng0) && (RangeVal[0] >= Rng1)) {
        // In speed up region
        MainPWM = true; PwmEn = true;
        PWM_Start = map(RangeVal[0],Rng1,Rng0,TuneInt[0],PWM_StartMin);
        DriveBck = 0; DriveLft = PWM_Start;  DriveRht = -PWM_Start;
        MotorPWM (DriveLft,DriveRht,DriveBck);
        break;
      }
      if ((RangeVal[0] < Rng1) && (RangeVal[0] >= Rng2)) {
        // In constant speed region
        MainPWM = true; PwmEn = true;
        PWM_Start = TuneInt[0];
        DriveBck = 0; DriveLft = PWM_Start;  DriveRht = -PWM_Start;
        MotorPWM (DriveLft,DriveRht,DriveBck);
        break;
      }
      if ((RangeVal[0] < Rng2) && (RangeVal[0] >= Rng3)) {
        // In slow down region
        MainPWM = true; PwmEn = true;
        PWM_Start = map(RangeVal[0],Rng3,Rng2,PWM_StartMin,TuneInt[0]);
        DriveBck = 0; DriveLft = PWM_Start;  DriveRht = -PWM_Start;
        MotorPWM (DriveLft,DriveRht,DriveBck);
        break;
      }
      else {zSTOP = true; MainSub = 30;}  // Target is close to Omni-Bot
      break;
    
    case 20: // Target lost, time to return
      // Use the front tacho counts as a movement reference
      zSTOP = true;
      // Check for range within sensor region?
      if (RangeVal[0] <= Rng0) {MainSub = 1; break;}
      // Check tachos for movement
      if ((TachoC != 0) || (TachoA != 0)) {
        // Some movement has occured.
        // Run timer for 5 seconds, whilst scanning sonar
        MainTime++;
        TaskMsg = "No Threat " + String((float)MainTime/62.5,1) + "s";
        if (MainTime >= 312) {MainSub = 22;}  // 5 sec timeout
      } else {MainSub = 1;} 
      break;
    case 22: // Drive back to start
      // Check for range within sensor region?
      if (RangeVal[0] <= Rng0) {MainSub = 1; break;}
      TaskMsg = "Returning";
      if (((TachoC < 0) && (TachoA > 0))) {
        // Moving towards start
        MainPWM = true; PwmEn = true; PWM_Start = TuneInt[1];
        DriveBck = 0; DriveLft = -PWM_Start;  DriveRht = +PWM_Start;
        MotorPWM (DriveLft,DriveRht,DriveBck);
      } else {zSTOP = true; ClearTachos(); MainSub = 1;}
      break;
    
    case 30: // At stop, target too close to Omni-Bot, so waiting for range to increase
      TaskMsg = "Too Close";
      if (RangeVal[0] > Rng3) {MainSub = 10;}
      break;
  }
  if (zSTOP) {
    // The STOP flag has been set by a target angle being reached
    if (MainPWM) {
      // We have been turning, so stop
      PWM_OFF(); MainPWM = false;  PwmEn = false; PWM_Start = PWM_StartMax;
    }
  }
}

// --------------------------------------------------------------------------------

void MainTask_Sonar_Sense() {
  // This tasks causes the Omni-Bot to map its LEDs onto the sonar ranges.
  // Wheel motors remain stationary.
  switch (MainSub) {
    case  0: // Initialise
      AtState = At_SONAR;                 // Set state for display
      Col_R = 0; Col_G = 24; Col_B = 0;   // set colours to green
      SetLedMode(5); LedNext = 3;         // green ring
      MainDel = 125; MainSub++; break;    // delay start by 2 seconds
    case  1: // wait state
      break;
  }
}

// --------------------------------------------------------------------------------

void MainTask_Sonar_Track() {
  // This tasks causes the Omni-Bot to track objects in front of it
  switch (MainSub) {
    case  0: // Initialise
      AtState = At_SONAR;                 // Set state for display
      SetLedMode(13); LedNext = 3;        // green ring
      MainDel = 125; MainSub++; break;    // delay start by 2 seconds
    case  1: // wait state
      break;
  }
}

// --------------------------------------------------------------------------------

void MainTask_Sonar_Turn() {
  // This tasks causes the Omni-Bot to turn towards approaching objects.
  bool zSTOP = false;   // clear the STOP flag
  switch (MainSub) {
    case  0: // Initialise
      AtState = At_SONAR;       // Set state for display
      MainPWM = false; PWM_Start = PWM_StartMax;
      TuneInt[0] = 120; TuneRef[0] = "Spd:";
      TuneInt[1] =  50; TuneRef[1] = "DelCnt:";
      TuneInt[2] = 120; TuneRef[2] = "YawTgt:";
      YawGyr = 0.0; YawGyrInt = 0; YawTgt = 0.0;
      SetLedMode(13); LedNext = 3;      // flash red LEDs
      MainDel = 125; MainSub++; break;  // delay start by 2 seconds
    case  1: // wait state, reading right and left sensors
      // The front sensor is ignored
      MainCnt = 0;  // reset the turn counter
      // Look at the side sensors
      if (RangeVal[1] <= 250) {MainSub = 10; return;}   // turn right
      if (RangeVal[2] <= 250) {MainSub = 20; return;}   // turn left
      break;

    case 10: // turn right
      MainPWM = true; PwmEn = true;
      DriveBck = -PWM_Start; DriveLft = -PWM_Start;  DriveRht = -PWM_Start;
      MotorPWM (DriveLft,DriveRht,DriveBck);
      YawGyr = 0.0; YawTgt = (float)TuneInt[2];    // set target angle
      MainSub++; break;
    case 11: // continue turning
      if (PWM_Start < TuneInt[0]) {
        PWM_Start += 4;
        DriveBck = -PWM_Start; DriveLft = -PWM_Start;  DriveRht = -PWM_Start;
        MotorPWM (DriveLft,DriveRht,DriveBck);
      }
      if (YawGyr >= YawTgt) {zSTOP = true; break;}    // test target angle
      // Not yet at full delay count
      MainCnt++;
      if ((MainCnt > TuneInt[1]) && (RangeVal[1] > 250)) {MainSub++;}   // approaching object lost, slow down
      break;
    case 12: // slow down
      if (YawGyr >= YawTgt) {zSTOP = true; break;}    // test target angle
      // Not yet at target angle
      if (PWM_Start > PWM_StartMin) {
        PWM_Start -= 4;
        DriveBck = -PWM_Start; DriveLft = -PWM_Start;  DriveRht = -PWM_Start;
        MotorPWM (DriveLft,DriveRht,DriveBck);
      } else {zSTOP = true;}   // return to stopping
      break;

    case 20: // turn left
      MainPWM = true; PwmEn = true;
      DriveBck = PWM_Start; DriveLft = PWM_Start;  DriveRht = PWM_Start;
      MotorPWM (DriveLft,DriveRht,DriveBck);
      YawGyr = 0.0; YawTgt = -(float)TuneInt[2];    // set target angle
      MainSub++; break;
    case 21: // continue turning
      if (PWM_Start < TuneInt[0]) {
        PWM_Start += 4;
        DriveBck = PWM_Start; DriveLft = PWM_Start;  DriveRht = PWM_Start;
        MotorPWM (DriveLft,DriveRht,DriveBck);
      }
      if (YawGyr <= YawTgt) {zSTOP = true; break;};    // test target angle
      // Not yet at full delay count
      MainCnt++;
      if ((MainCnt > TuneInt[1]) && (RangeVal[2] > 250)) {MainSub++;}   // approaching object lost, slow down
      break;
    case 22: // slow down
      if (YawGyr <= YawTgt) {zSTOP = true; break;};    // test target angle
      // Not yet at target angle
      if (PWM_Start > PWM_StartMin) {
        PWM_Start -= 4;
        DriveBck = PWM_Start; DriveLft = PWM_Start;  DriveRht = PWM_Start;
        MotorPWM (DriveLft,DriveRht,DriveBck);
      } else {zSTOP = true;}   // return to stopping
      break;
  }
  if (zSTOP) {
    // The STOP flag has been set by a target angle being reached
    if (MainPWM) {
      // We have been turning, so stop
      PWM_OFF(); MainPWM = false;  PwmEn = false; PWM_Start = PWM_StartMax;
    }
    zSTOP = false; MainSub = 1;
  }
}

// --------------------------------------------------------------------------------

void MotorDriveTask() {
  // Called at 62.5Hz from the main task loop(), to control motor PWMs and dither.
  // Control variables are set through the Motor(,,) function.
  // If connected to Windows app, then abort
  if (AppCnt > 0) {return;}
  
  // Now create PWM counter signals for each motor.
  // Front left wheel motor 'C'
  int16_t zPWM = PWM_C; //int16_t zStart = PWM_Start + 25;
  TachoC += PWM_C;  // add energy to the tacho counter
  if (zPWM >  0) {
    analogWrite(Pin_C0, 255); analogWrite(Pin_C1, 255 - zPWM); DIR_FL = 1;
  } else if (PWM_C == 0) {analogWrite(Pin_C0, 0); analogWrite(Pin_C1, 0); DIR_FL = 0;
  } else {
    analogWrite(Pin_C0, 255 + zPWM); analogWrite(Pin_C1, 255); DIR_FL = -1;
  }
  
  // Front right wheel motor 'A'
  zPWM = PWM_A; 
  TachoA += PWM_A;  // add energy to the tacho counter
  if (zPWM >  0) {
    analogWrite(Pin_A0, 255); analogWrite(Pin_A1, 255 - zPWM); DIR_FR = 1;
  } else if (PWM_A == 0) {analogWrite(Pin_A0, 0); analogWrite(Pin_A1, 0); DIR_FR = 0;
  } else {
    analogWrite(Pin_A0, 255 + zPWM); analogWrite(Pin_A1, 255); DIR_FR = -1;
  }
  
  // Rear wheel motor 'B'
  zPWM = PWM_B;
  TachoB += PWM_B;  // add energy to the tacho counter
  if (zPWM >  0) {
    analogWrite(Pin_B0, 255); analogWrite(Pin_B1, 255 - zPWM); DIR_RR = 1;
  } else if (PWM_B == 0) {analogWrite(Pin_B0, 0); analogWrite(Pin_B1, 0); DIR_RR = 0;
  } else {
    analogWrite(Pin_B0, 255 + zPWM); analogWrite(Pin_B1, 255); DIR_RR = -1;
  }
}

// --------------------------------------------------------------------------------

void RGB_RunTask() {
  // The LED task is called from the main loop() every 4ms.
  // The LED update perioed runs at a variable rate, depending on drive activities.
  // At 800 kHz it will take 450 µs to update 15 LEDs.
  if (LED_Run) {LED_Main();}
  else if ((millis() - LED_Timer) >= LED_Period) {
    LED_Timer = millis();
    if (LEDshow) {
      // update LEDs if LEDshow == true
      FastLED.show();
      LEDshow = false;
      delayMicroseconds(450);
    }
    LED_Run = true;                                 // initiate the next LED_Task process
  }

}

// --------------------------------------------------------------------------------

void RCWL_Tasks() {
  // Called from the main loop() every 16ms to perform RCWL range measurements
  // The order in which sensors are read is determined by RCWL_Mode:
  // 0        - read front sensor only
  // 1        - read right-hand sensor only
  // 2        - read left-hand sensor only
  // 3/4/5    - read sensors in sequence, front, right, left, front,...
  // 6/7/8/9  -  read sensors in sequence, front, right, left, front,...
  // Variables are held in arrays so we can use pointers
  switch(RCWL) {
    case 1:
      //############################################
      // RCWL_Mode sets pins & pointers
      //############################################
      RCWL_Mask = 0b111;  // default display mask, all sensors ON
      switch (RCWL_Mode) {
        case 0: RangePnt = 0; TrigPin = 18; EchoPin = 16; RCWL_Mask = 0b001; break; // Front sensor
        case 1: RangePnt = 1; TrigPin = 17; EchoPin =  4; RCWL_Mask = 0b010; break; // Right-hand sensor
        case 2: RangePnt = 2; TrigPin = 14; EchoPin =  2; RCWL_Mask = 0b100; break; // Left-hand sensor

        case 3: RangePnt = 0; TrigPin = 18; EchoPin = 16; RCWL_Mode++; break;       // Front sensor
        case 4: RangePnt = 1; TrigPin = 17; EchoPin =  4; RCWL_Mode++; break;       // Right-hand sensor
        case 5: RangePnt = 2; TrigPin = 14; EchoPin =  2; RCWL_Mode = 3; break;     // Left-hand sensor

        case 6: RangePnt = 0; TrigPin = 18; EchoPin = 16; RCWL_Mode++; break;       // Front sensor
        case 7: RangePnt = 1; TrigPin = 17; EchoPin =  4; RCWL_Mode++; break;       // Right-hand sensor
        case 8: RangePnt = 0; TrigPin = 18; EchoPin = 16; RCWL_Mode++; break;       // Front sensor
        case 9: RangePnt = 2; TrigPin = 14; EchoPin =  2; RCWL_Mode = 6; break;     // Left-hand sensor
      }
      //############################################
      // Trigger
      //############################################
      // Trigger RCWL-1601 device
      // Serial.println(millis() - t0[2]);
      // t0[2] = millis();
      // Serial.println("Trig=" + String(TrigPin));
      digitalWrite(TrigPin,HIGH);
      delayMicroseconds(TrigDel);
      digitalWrite(TrigPin,LOW);
      // Measure duration
      PulseWidth = pulseIn(EchoPin,HIGH,echoLimit);
      RCWL++; break;
    case 2:
      //############################################
      // Range
      //############################################
      // If PulseWidth == 0 then out of range, or bad measurement.
      // Serial.println("Rng[" + String(RangePnt) + "]");
      RangeOld[RangePnt] = Range[RangePnt];
      Range[RangePnt] = 0.1715 * PulseWidth;
      if (Range[RangePnt] == 0) {
        // Range is out of bounds == 0, so set it to max
        Range[RangePnt] = RangeMax;
        if (RangeVal[RangePnt] < RangeUL) {
          // Previous value was in range, so use discriminator
          RangeCnt[RangePnt]++;
          if (RangeCnt[RangePnt] > RangeEx) {RangeAvg[RangePnt] = RangeMax;}
        }
      } else {
        // Valid range measured
        RangeCnt[RangePnt] = 0;   // reset the exclusion discriminator
        if (RangeOld[RangePnt] >= RangeUL) {
          // Previous range was out of range, so bring in averages
          RangeAvg[RangePnt] = Range[RangePnt];
          RangeSum[RangePnt] = Range[RangePnt] * RangeDiv;
        } else {
          RangeSum[RangePnt] += (Range[RangePnt] - RangeAvg[RangePnt]);
          RangeAvg[RangePnt] = RangeSum[RangePnt]/RangeDiv;
        }
      }
      RangeVal[RangePnt] = RangeAvg[RangePnt];
      // The array pointer counts from 0 - 3
      // RcwlPnt++; if (RcwlPnt > 3) {RcwlPnt = 0;}
      // Resete the RCWL flag
      RCWL = 0; break;
  }
}

// --------------------------------------------------------------------------------

void runMainTasks() {
  // Called from the main loop() every 16ms to perform Main tasks
  if (MainDel > 0) {MainDel--; return;}   // exit if MainDel is > 0

  switch (MainTask) {
    case  0: break; // default null task
    case 10: MainTask_LDR_Sense(); break;
    case 11: MainTask_LDR_Turn(); break;
    case 12: MainTask_LDR_Follow(); break;

    case 20: MainTask_Sonar_Sense(); break;
    case 21: MainTask_Sonar_Turn(); break;
    case 22: MainTask_Sonar_Backaway(); break;
    case 23: MainTask_Sonar_Track(); break;

    case 30: break;
    case 31: MainTask_Auton_Moves(); break;
  }
}

// --------------------------------------------------------------------------------

