///////////////////////////////////////////////////////////////////////////////////
//
// Functions mainly used for development and debugging
//
///////////////////////////////////////////////////////////////////////////////////

void ScopeReport(int zGPnn ) {
  ///////////////////////////////////////////////////////////////////////
  // A choice of PrintTx statements to inspect variables dynamically
  ///////////////////////////////////////////////////////////////////////
  // Note at 4ms cycle and 115200 baud string length is limited to 46 chars
  // max in a 4ms period, otherwise blocking will occur. If used over WiFi then
  // link corruption may occur; so to prevent rogue values we send data twice and
  // checked on receive as a valid pair of duplicate values, otherwise disgard it.
  // Adjust the following three values to match the switch() list below, so that
  // title reports the extent of the GPnn list to the Monitor+ app, whenever a
  // new GPnn us called for.
  GPmin = 0; GPmax = 6; String zGM = "GM" + String(GPmax) + "\n";

  switch (zGPnn) {
    case 0:
      if (GP_Title) {PrintTx += "#AccRawX,AccRawY,GyrRawZ,0\n" + zGM; GP_Title = false;}
      PrintTx += String(AccRawX) + ",";
      PrintTx += String(AccRawY) + ",";
      PrintTx += String(GyrRawZ) + ",";
      PrintTx += "0\n";
      break;

    case 1:
      if (GP_Title) {PrintTx += "#AcX,AcY,GyZ,0\n" + zGM; GP_Title = false;}
      PrintTx += String(AcX) + ",";
      PrintTx += String(AcY) + ",";
      PrintTx += String(GyZ) + ",";
      PrintTx += "0\n";
      break;

    case 2:
      if (GP_Title) {PrintTx += "#LDR0,Avg0,LDR1,Avg1\n" + zGM; GP_Title = false;}
      PrintTx += String(LDR0) + ",";
      PrintTx += String(LDR0_Avg) + ",";
      PrintTx += String(LDR1) + ",";
      PrintTx += String(LDR1_Avg) + "\n";
      break;

    case 3:
      if (GP_Title) {PrintTx += "#Range[0],Range1,Range2,0\n" + zGM; GP_Title = false;}
      PrintTx += String(Range[0]) + ",";
      PrintTx += String(Range[1]) + ",";
      PrintTx += String(Range[2]) + ",";
      PrintTx += "0\n";
      break;

    case 4:
      if (GP_Title) {PrintTx += "#Range0,RangeAvg0,RangeCnt0,0\n" + zGM; GP_Title = false;}
      PrintTx += String(Range[0]) + ",";
      PrintTx += String(RangeVal[0]) + ",";
      PrintTx += String(RangeCnt[0]) + ",";
      PrintTx += "0\n";
      break;

    case 5:
      if (GP_Title) {PrintTx += "#Range1,RangeAvg1,RangeCnt1,0\n" + zGM; GP_Title = false;}
      PrintTx += String(Range[1]) + ",";
      PrintTx += String(RangeVal[1]) + ",";
      PrintTx += String(RangeCnt[1]) + ",";
      PrintTx += "0\n";
      break;

    case 6:
      if (GP_Title) {PrintTx += "#Range2,RangeAvg2,RangeCnt2,0\n" + zGM; GP_Title = false;}
      PrintTx += String(Range[2]) + ",";
      PrintTx += String(RangeVal[2]) + ",";
      PrintTx += String(RangeCnt[2]) + ",";
      PrintTx += "0\n";
      break;

    default:
      // zRPnn was out of range so reset the reporting pointer and send commands
      // to set RP = 0 and RMax to the highest number in your case list. ie. 7
      GPnn = GPmin; PrintTx += "GP" + String(GPmin) + "\n";
      PrintTx += "GM" + String(GPmax) + "\n"; break;
  }
}

// --------------------------------------------------------------------------------

