
// --------------------------------------------------------------------------------

void JoyMoveBwd() {
  // called from main loop to respond to joystick demands
  // this function drives and steers in a backwards direction
  if (MovePnt >= 0) {return;}       // MoveEngine blocks joystic use

  // Serial.println("JoyMoveBwd");
  DriveTxt = "Backwards";           // indicates drive mode
  if (Drive == 0) {
    // the start of a new movement
    Drive = JoyMode; SetLedMode(25); PWM_Start = PWM_StartMax;
  }
  // ensure joystick values are in the required range
  if (JoyX < 128) {JoyXV = 127 - JoyX;} // convert -ve vector to +ve
  else {JoyXV = JoyX - 128;} // ensure JoyX = 0 - 128
  if (JoyY < 128) {JoyYV = 127 - JoyY;} // convert -ve vector to +ve
  else {JoyYV = JoyY - 128;} // ensure JoyY = 0 - 128
  JoySpd = JoyYV; if (JoyXV > JoyYV) {JoySpd = JoyXV;}
  if (Gear == 1) {JoySpd = PWM_Start + ((JoySpd *  3)/10);}  // 1st gear demand
  if (Gear == 2) {JoySpd = PWM_Start + ((JoySpd *  6)/10);}  // 2nd gear demand
  if (Gear == 3) {JoySpd = PWM_Start + ((JoySpd * 10)/10);}  // 3rd gear demand
  if (Gear == 4) {JoySpd = PWM_Start + ((JoySpd * 14)/10);}  // 4th gear demand
  if (Gear == 5) {JoySpd = PWM_Start + ((JoySpd * 18)/10);}  // 5th gear demand
  LedSpd = JoySpd;  // grab speed for LED animation

    // now apply steering
  if (JoyX < DbLLX) {
      // turning to the left in reverse
    Steer = -((JoySpd * (DbLLX - JoyX))/192); // -ve number
    // Apply brake function for JoyY forwards
    if (JoyY > 192) {JoySpd = (JoySpd * (255 - JoyY))/64; Steer = (Steer * (255 - JoyY))/64;}
    DriveLft = JoySpd + Steer; DriveRht = -JoySpd + Steer;
    DriveBck= Steer; 
  } else if (JoyX > DbULX) {
      // turning to the right
    Steer = ((JoySpd * (JoyX - DbULX))/192);  // +ve number
    // Apply brake function for JoyY forwards
    if (JoyY > 192) {JoySpd = (JoySpd * (255 - JoyY))/64; Steer = (Steer * (255 - JoyY))/64;}
    DriveLft = JoySpd + Steer; DriveRht = -JoySpd + Steer;
    DriveBck= Steer; 
  } else if (JoyY < DbLLY) {
    // Driving forwards, no steering
    Steer = 0; DriveBck = 0; DriveLft = JoySpd; DriveRht = -JoySpd;
  } else {Steer = 0; DriveBck = 0; DriveLft = 0; DriveRht = 0;}
  
  // now apply demand
  DriveBck = constrain(DriveBck,-255,255);
  DriveLft = constrain(DriveLft,-255,255);
  DriveRht = constrain(DriveRht,-255,255);
  // Serial.println("MotorPWM (" + String(DriveLft) + "," + String(DriveRht) + "," + String(DriveLft) + "," + String(DriveRht) + ")");
  MotorPWM (DriveLft,DriveRht,DriveBck);
  if (PWM_Start > PWM_StartMin) {PWM_Start = PWM_StartMin + ((PWM_Start - PWM_StartMin)/2);}
}

// --------------------------------------------------------------------------------

void JoyMoveFwd() {
  // called from main loop to respond to joystick demands
  // this function drives and steers in a forwards direction
  if (MovePnt >= 0) {return;}       // MoveEngine blocks joystic use

  // Serial.println("JoyMoveFwd");
  DriveTxt = "Forwards";          // indicates drive mode
  if (Drive == 0) {
    // the start of a new movement
    Drive = JoyMode; SetLedMode(21); PWM_Start = PWM_StartMax;
  }
  // ensure joystick values are in the required range
  if (JoyX < 128) {JoyXV = 127 - JoyX;} // convert -ve vector to +ve
  else {JoyXV = JoyX - 128;}            // ensure JoyX = 0 - 128
  if (JoyY < 128) {JoyYV = 127 - JoyY;} // convert -ve vector to +ve
  else {JoyYV = JoyY - 128;}            // ensure JoyY = 0 - 128
  JoySpd = JoyYV; if (JoyXV > JoyYV) {JoySpd = JoyXV;}
  if (Gear == 1) {JoySpd = PWM_Start + ((JoySpd *  3)/10);}  // 1st gear demand
  if (Gear == 2) {JoySpd = PWM_Start + ((JoySpd *  6)/10);}  // 2nd gear demand
  if (Gear == 3) {JoySpd = PWM_Start + ((JoySpd * 10)/10);}  // 3rd gear demand
  if (Gear == 4) {JoySpd = PWM_Start + ((JoySpd * 14)/10);}  // 4th gear demand
  if (Gear == 5) {JoySpd = PWM_Start + ((JoySpd * 18)/10);}  // 5th gear demand
  LedSpd = JoySpd;  // grab speed for LED animation

  Steer = 0;
  // now apply steering
  if (JoyX < DbLLX) {
    // turning to the left going forward
    Steer = -((JoySpd * (DbLLX - JoyX))/192); // -ve number
    // Apply brake function for JoyY backwards
    if (JoyY < 64) {JoySpd = (JoySpd * JoyY)/64; Steer = (Steer * JoyY)/64;}
    DriveLft = -JoySpd - Steer; DriveRht = JoySpd - Steer;
    DriveBck = -Steer; 
  } else if (JoyX > DbULX) {
    // turning to the right going forward
    Steer = ((JoySpd * (JoyX - DbULX))/192);  // +ve number
    // Apply brake function for JoyY backwards
    if (JoyY < 64) {JoySpd = (JoySpd * JoyY)/64; Steer = (Steer * JoyY)/64;}
    DriveLft = -JoySpd - Steer; DriveRht = JoySpd - Steer;
    DriveBck = -Steer; 
  } else if (JoyY > DbULY) {
    // Driving forwards, no steering
    Steer = 0; DriveBck = 0; DriveLft = -JoySpd; DriveRht = JoySpd;}
  else {Steer = 0; DriveBck = 0; DriveLft = 0; DriveRht = 0;}   // Stop!
  
  // now apply constraints and demand
  DriveBck = constrain(DriveBck,-255,255);
  DriveLft = constrain(DriveLft,-255,255);
  DriveRht = constrain(DriveRht,-255,255);
  // Serial.println("MotorPWM (" + String(DriveLft) + "," + String(DriveRht) + "," + String(DriveLft) + "," + String(DriveRht) + ")");
  MotorPWM (DriveLft,DriveRht,DriveBck);
  if (PWM_Start > PWM_StartMin) {PWM_Start = PWM_StartMin + ((PWM_Start - PWM_StartMin)/2);}
}

// --------------------------------------------------------------------------------

void JoyOmniMove(int16_t zJX, int16_t zJY) {
  // Called when either in nunchuk is in Omni mode, or when the left joystick
  // is moved from a Classic or Classic Pro.
  if (MovePnt >= 0) {return;}       // MoveEngine blocks joystic use

  AtState = At_OMNI;
  if (Drive == 0) {
    // the start of a new movement
    PWM_Start = PWM_StartMax;
  }
  // ensure joystick values are in the required range
  if (zJX < 128) {JoyXV = 127 - zJX;}   // convert -ve vector to +ve
  else {JoyXV = zJX - 128;}             // ensure JoyX = 0 - 128
  if (zJY < 128) {JoyYV = 127 - zJY;}   // convert -ve vector to +ve
  else {JoyYV = zJY - 128;}             // ensure JoyY = 0 - 128
  JoySpd = JoyYV; if (JoyXV > JoyYV) {JoySpd = JoyXV;}
  if (Gear == 1) {JoySpd = PWM_Start + ((JoySpd *  3)/10);}  // 1st gear demand
  if (Gear == 2) {JoySpd = PWM_Start + ((JoySpd *  6)/10);}  // 2nd gear demand
  if (Gear == 3) {JoySpd = PWM_Start + ((JoySpd * 10)/10);}  // 3rd gear demand
  if (Gear == 4) {JoySpd = PWM_Start + ((JoySpd * 14)/10);}  // 4th gear demand
  if (Gear == 5) {JoySpd = PWM_Start + ((JoySpd * 18)/10);}  // 5th gear demand
  LedSpd = JoySpd;  // grab speed for LED animation

  zJX = zJX - 128; zJY = zJY - 128;
  JoyMode = 99;
  SpdAdj = (((JoySpd/3) * (JoyY - 128))/128);
  if (zJX == 0) {
    // Demand is forwards or backwards
    if (zJY > 0) {JoyAng = 90.0; DriveLft = -0.866*JoySpd; DriveRht = 0.866*JoySpd; DriveBck = 0; JoyMode = 11; DriveTxt = "Omni Fwd";}       // forwards
    else {JoyAng = 90.0; DriveLft = 0.866*JoySpd; DriveRht = -0.866*JoySpd; DriveBck = 0; JoyMode = 17; DriveTxt = "Omni Back";}             // backwards
  } else {
    JoyAng = (int)(57.2958 * atan((float)zJY/(float)zJX));
    if (zJX > 0) {
      // Joystick is to the right
           if ((JoyAng >  75) && (JoyAng <=  90)) {DriveLft = -0.866*JoySpd; DriveRht = 0.866*JoySpd; DriveBck = 0; JoyMode = 11; DriveTxt = "Omni Fwd";}   // Forwards
      else if ((JoyAng >  45) && (JoyAng <=  75)) {DriveLft = -JoySpd; DriveRht = 0.5*JoySpd; DriveBck = 0.5*JoySpd; JoyMode = 12; DriveTxt = "Omni NNE";}  // NNE
      else if ((JoyAng >  15) && (JoyAng <=  45)) {DriveLft = -0.866*JoySpd; DriveRht = 0; DriveBck = 0.866*JoySpd; JoyMode = 13; DriveTxt = "Omni ENE";}   // ENE
      else if ((JoyAng > -15) && (JoyAng <=  15)) {
        // In this mode we can use the right-hand joystick Y value for steering
        if (JoyY == 128) {DriveLft = -0.5*JoySpd; DriveRht = -0.5*JoySpd; DriveBck = JoySpd;}
        else {DriveLft = -(0.5*JoySpd) + SpdAdj; DriveRht = -(0.5*JoySpd) + SpdAdj; DriveBck = JoySpd + SpdAdj;}
        JoyMode = 14; DriveTxt = "Omni Rht";} // Right
      else if ((JoyAng > -45) && (JoyAng <= -15)) {DriveLft = 0; DriveRht = -0.866*JoySpd; DriveBck = 0.866*JoySpd; JoyMode = 15; DriveTxt = "Omni ESE";}   // ESE
      else if ((JoyAng > -75) && (JoyAng <= -45)) {DriveLft = 0.5*JoySpd; DriveRht = -JoySpd; DriveBck = 0.5*JoySpd; JoyMode = 16; DriveTxt = "Omni SSE";}  // SSE
      else if ((JoyAng > -90) && (JoyAng <= -75)) {DriveLft = 0.866*JoySpd; DriveRht = -0.866*JoySpd; DriveBck = 0; JoyMode = 17; DriveTxt = "Omni Back";}  // Backwards
    } else {
      // Joystick is to the left
           if ((JoyAng >  75) && (JoyAng <=  90)) {DriveLft = 0.866*JoySpd; DriveRht = -0.866*JoySpd; DriveBck = 0; JoyMode = 17; DriveTxt = "Omni Back";}  // Backwards
      else if ((JoyAng >  45) && (JoyAng <=  75)) {DriveLft = JoySpd; DriveRht = -0.5*JoySpd; DriveBck = -0.5*JoySpd; JoyMode = 18; DriveTxt = "Omni SSW";} // SSW
      else if ((JoyAng >  15) && (JoyAng <=  45)) {DriveLft = 0.866*JoySpd; DriveRht = 0; DriveBck = -0.866*JoySpd; JoyMode = 19; DriveTxt = "Omni WSW";}   // WSW
      else if ((JoyAng > -15) && (JoyAng <=  15)) {
        // In this mode we can use the right-hand joystick Y value for steering
        if (JoyY == 128) {DriveLft = 0.5*JoySpd; DriveRht = 0.5*JoySpd; DriveBck = -JoySpd;}
        else {DriveLft = (0.5*JoySpd) - SpdAdj; DriveRht = (0.5*JoySpd) - SpdAdj; DriveBck = -JoySpd - SpdAdj;}
        JoyMode = 20; DriveTxt = "Omni Lft";}  // Left
      else if ((JoyAng > -45) && (JoyAng <= -15)) {DriveLft = 0; DriveRht = 0.866*JoySpd; DriveBck = -0.866*JoySpd; JoyMode = 21; DriveTxt = "Omni WNW";}   // WNW
      else if ((JoyAng > -75) && (JoyAng <= -45)) {DriveLft = -0.5*JoySpd; DriveRht = JoySpd; DriveBck = -0.5*JoySpd; JoyMode = 22; DriveTxt = "Omni NNW";} // NNW
      else if ((JoyAng > -90) && (JoyAng <= -75)) {DriveLft = -0.866*JoySpd; DriveRht = 0.866*JoySpd; DriveBck = 0; JoyMode = 11; DriveTxt = "Omni Fwd";}   // Forwards
    }
  }
  // Serial.println(String(zJX) + "\t" + String(zJY) + "\t" + String(JoyAng));
  Drive = JoyMode; SetLedMode(20 + JoyMode);
  
  // now apply constraints and demand
  DriveBck = constrain(DriveBck,-255,255);
  DriveLft = constrain(DriveLft,-255,255);
  DriveRht = constrain(DriveRht,-255,255);
  // Serial.println("MotorPWM (" + String(DriveLft) + "," + String(DriveRht) + "," + String(DriveLft) + "," + String(DriveRht) + ")");
  MotorPWM (DriveLft,DriveRht,DriveBck);
  if (PWM_Start > PWM_StartMin) {PWM_Start = PWM_StartMin + ((PWM_Start - PWM_StartMin)/2);}
}

// --------------------------------------------------------------------------------

void JoyTurnLft() {
  // called from main loop to respond to joystick demands
  // this function neutral turns in a leftwards direction
  if (MovePnt >= 0) {return;}       // MoveEngine blocks joystic use

  // Serial.println("JoyTurnLft");
  DriveTxt = "Neutral Lft";          // indicates drive mode
  if (Drive == 0) {
    // the start of a new movement
    Drive = JoyMode; SetLedMode(27); PWM_Start = PWM_StartMax;
  }
  // ensure joystick values are in the required range
  if (JoyX < 128) {JoyXV = 127 - JoyX;} // convert -ve vector to +ve
  else {JoyXV = JoyX - 128;} // ensure JoyX = 0 - 128
  JoySpd = JoyXV;
  if (Gear == 1) {JoySpd = PWM_Start + ((JoySpd *  3)/10);}  // 1st gear demand
  if (Gear == 2) {JoySpd = PWM_Start + ((JoySpd *  6)/10);}  // 2nd gear demand
  if (Gear == 3) {JoySpd = PWM_Start + ((JoySpd * 10)/10);}  // 3rd gear demand
  if (Gear == 4) {JoySpd = PWM_Start + ((JoySpd * 14)/10);}  // 4th gear demand
  if (Gear == 5) {JoySpd = PWM_Start + ((JoySpd * 18)/10);}  // 5th gear demand
  LedSpd = JoySpd;  // grab speed for LED animation

  // now apply steering
  Steer = -JoySpd; DriveLft = JoySpd; DriveRht = JoySpd; DriveBck = JoySpd;
  // now apply demand
  DriveBck = constrain(DriveBck,   0,255);
  DriveLft = constrain(DriveLft,   0,255);
  DriveRht = constrain(DriveRht,   0,255);
  // Serial.println("MotorPWM (" + String(DriveLft) + "," + String(DriveRht) + "," + String(DriveLft) + "," + String(DriveRht) + ")");
  MotorPWM (DriveLft,DriveRht,DriveBck);
  if (PWM_Start > PWM_StartMin) {PWM_Start = PWM_StartMin + ((PWM_Start - PWM_StartMin)/2);}
}

// --------------------------------------------------------------------------------

void JoyTurnRgt() {
  // called from main loop to respond to joystick demands
  // this function turns in a rightwards direction
  if (MovePnt >= 0) {return;}       // MoveEngine blocks joystic use

  // Serial.println("JoyTurnRgt");
  DriveTxt = "Neutral Rht";          // indicates drive mode
  if (Drive == 0) {
    // the start of a new movement
    Drive = JoyMode; SetLedMode(23); PWM_Start = PWM_StartMax;
  }
  // ensure joystick values are in the required range
  if (JoyX < 128) {JoyXV = 127 - JoyX;} // convert -ve vector to +ve
  else {JoyXV = JoyX - 128;} // ensure JoyX = 0 - 128
  JoySpd = JoyXV;
  if (Gear == 1) {JoySpd = PWM_Start + ((JoySpd *  3)/10);}  // 1st gear demand
  if (Gear == 2) {JoySpd = PWM_Start + ((JoySpd *  6)/10);}  // 2nd gear demand
  if (Gear == 3) {JoySpd = PWM_Start + ((JoySpd * 10)/10);}  // 3rd gear demand
  if (Gear == 4) {JoySpd = PWM_Start + ((JoySpd * 14)/10);}  // 4th gear demand
  if (Gear == 5) {JoySpd = PWM_Start + ((JoySpd * 18)/10);}  // 5th gear demand
  LedSpd = JoySpd;  // grab speed for LED animation

  // now apply steering
  Steer = JoySpd; DriveLft = -JoySpd; DriveRht = -JoySpd; DriveBck = -JoySpd;
  // now apply demand
  DriveBck = constrain(DriveBck,-255,  0);
  DriveLft = constrain(DriveLft,-255,  0);
  DriveRht = constrain(DriveRht,-255,  0);
  // Serial.println("MotorPWM (" + String(DriveLft) + "," + String(DriveRht) + "," + String(DriveLft) + "," + String(DriveRht) + ")");
  MotorPWM (DriveLft,DriveRht,DriveBck);
  if (PWM_Start > PWM_StartMin) {PWM_Start = PWM_StartMin + ((PWM_Start - PWM_StartMin)/2);}
}

// --------------------------------------------------------------------------------

void Move_BDD() {
  // Digital pad down special movement
  if (BDD_) {return;} // prevent reuse of this function until button released

  // OmniBot slides left, then forwards, slides right, then backwards, then slides left
  int16_t zS = 70; int16_t zS2 = zS/2; int16_t zT = 62; int16_t zT2 = zT/2;
  BDD_ = true;                      // prevent function being called again
  MoveCnt = 0;                      // reset the array pointer
  MoveState = 0;                    // reset the MoveEngine state machine
  //         FL,  FR, RC, T ,Ctrl
  MoveLoad( zS2, zS2,-zS,zT2,0);    // move sideways right
  MoveLoad(   0,   0,  0,  7,0);    // stop for 112ms
  MoveLoad( -zS,  zS,  0, zT,0);    // move backwards
  MoveLoad(   0,   0,  0,  7,0);    // stop for 112ms
  MoveLoad(-zS2,-zS2, zS, zT,0);    // move sideways left
  MoveLoad(   0,   0,  0,  7,0);    // stop for 112ms
  MoveLoad(  zS, -zS,  0, zT,0);    // move forwards
  MoveLoad(   0,   0,  0,  7,0);    // stop for 112ms
  MoveLoad( zS2, zS2,-zS,zT2,0);    // move sideways right
  MovePnt = 0;                      // set MovePnt = 0 to start the sequence
  // The motors are stopped automatically at the end of the sequence
}

// --------------------------------------------------------------------------------

void Move_BDL() {
  // Digital pad left special movement
  if (BDL_) {return;} // prevent reuse of this function until button released

  // OmniBot turns to the left, then back again, random speed and time
  int16_t zS = 70 + random(90); int16_t zT = 32 + random(126);
  BDL_ = true;                    // prevent function being called again
  MoveCnt = 0;                    // reset the array pointer
  MoveState = 0;                  // reset the MoveEngine state machine
  //         FL,  FR, RC, T ,Ctrl
  MoveLoad( -zS, -zS,-zS, zT,0);  // Neutral turn left
  MoveLoad(   0,   0,  0,  7,0);  // stop for 112ms
  MoveLoad(  zS,  zS, zS, zT,0);  // Neutral turn right
  MovePnt = 0;                    // set MovePnt = 0 to start the sequence
  // The motors are stopped automatically at the end of the sequence
}

// --------------------------------------------------------------------------------

void Move_BDR() {
  // Digital pad right special movement
  if (BDR_) {return;} // prevent reuse of this function until button released

  // OmniBot turns to the right, then back again, random speed and time
  int16_t zS = 70 + random(90); int16_t zT = 32 + random(126);
  BDR_ = true;                    // prevent function being called again
  MoveCnt = 0;                    // reset the array pointer
  MoveState = 0;                  // reset the MoveEngine state machine
  //         FL,  FR, RC, T ,Ctrl
  MoveLoad(  zS,  zS, zS, zT,0);  // Neutral turn right
  MoveLoad(   0,   0,  0,  7,0);  // stop for 112ms
  MoveLoad( -zS, -zS,-zS, zT,0);  // Neutral turn left
  MovePnt = 0;                    // set MovePnt = 0 to start the sequence
  // The motors are stopped automatically at the end of the sequence
}

// --------------------------------------------------------------------------------

void Move_BDU() {
  // Digital pad up special movement
  if (BDU_) {return;} // prevent reuse of this function until button released

  // OmniBot slides left, then forwards, slides right, then backwards, then slides left
  int16_t zS = 70; int16_t zS2 = zS/2; int16_t zT = 62; int16_t zT2 = zT/2;
  BDU_ = true;                      // prevent function being called again
  MoveCnt = 0;                      // reset the array pointer
  MoveState = 0;                    // reset the MoveEngine state machine
  //         FL,  FR, RC, T ,Ctrl
  MoveLoad(-zS2,-zS2, zS,zT2,0);    // move sideways left for 1 second
  MoveLoad(   0,   0,  0,  7,0);    // stop for 112ms
  MoveLoad(  zS, -zS,  0, zT,0);    // move forwards for 2 seconds
  MoveLoad(   0,   0,  0,  7,0);    // stop for 112ms
  MoveLoad( zS2, zS2,-zS, zT,0);    // move sideways right for 1 second
  MoveLoad(   0,   0,  0,  7,0);    // stop for 112ms
  MoveLoad( -zS,  zS,  0, zT,0);    // move backwards for 2 seconds
  MoveLoad(   0,   0,  0,  7,0);    // stop for 112ms
  MoveLoad(-zS2,-zS2, zS,zT2,0);    // move sideways left for 1 second
  MovePnt = 0;                      // set MovePnt = 0 to start the sequence
  // The motors are stopped automatically at the end of the sequence
}

// --------------------------------------------------------------------------------

void MoveEngine() {
  // Called from the main loop() to perform autonomous movements, loaded into arrays.
  // A state machine controls the loading and execuition of moves
  switch (MoveState) {
    case 0: // initiate a move
      PWM_C = MoveFL[MovePnt];            // load motor C PWM value
      PWM_A = MoveFR[MovePnt];            // load motor A PWM value
      PWM_B = MoveRC[MovePnt];            // load motor B PWM value
      MoveStp = MoveTime[MovePnt];        // load the count-down 16ms steps value
      PwmEn = true;                       // enable PWM drive
      MoveState++; break;
    case 1: // count out the movement
      MoveStp--; if (MoveStp == 0) {      // count down the 16ms time steps
        MoveState = 0;                    // reset state machine
        MovePnt++;                        // point at next movement
        if (MovePnt >= MoveCnt) {
          MovePnt = -1;                   // End of movements
          PWM_OFF();                      // turn off motors
        }
      } break;
  }
}

// --------------------------------------------------------------------------------

void MoveLoad(int16_t zFL, int16_t zFR, int16_t zRC, uint16_t zTime, uint16_t zCtrl) {
  // Loads a moves values into the Move[] arrays, and increments the pointer.
  // Normally called several times in succession to create a sequence.
  // The 1st value is stored at MoveCnt = 0, then +1,+2,etc.
  MoveFL[MoveCnt] = zFL;      // front left motor PWM value, +/-255
  MoveFR[MoveCnt] = zFR;      // front right motor PWM value, +/-255
  MoveRC[MoveCnt] = zRC;      // rear centre motor PWM value, +/-255
  MoveTime[MoveCnt] = zTime;  // movement time, in units of 16ms
  MoveCtrl[MoveCnt] = zCtrl;  // control variable
  if (MoveCnt < (MoveNum - 1)) {MoveCnt++;} // change pointer, if within array depth
}

// --------------------------------------------------------------------------------

