/*
 * Decompiled with CFR 0.152.
 */
import processing.core.PApplet;
import processing.core.PImage;
import processing.serial.Serial;

public class Proc_8Ch_Controller
extends PApplet {
    Serial usbPort;
    boolean AngMode = false;
    int BB = 255;
    int BG = 255;
    int BR = 255;
    int Ch_Cnt = 0;
    int comFlag = 0;
    int comListLength = 0;
    String comName = "";
    int comPnt = 0;
    String CopyData = "";
    String CR = "\r\n";
    String data = "";
    boolean data_loaded = false;
    int drawFlag = 1;
    int Freq = 50;
    String Help$ = "";
    String HelpLast$ = "";
    PImage img;
    int index = 0;
    int interval = 20;
    int JoyX0 = 316;
    int JoyX1 = 812;
    int keyDwn = 0;
    boolean keySHIFT = false;
    int LastVal;
    int LF = 10;
    int mDwn = 0;
    int mB;
    int mON;
    int mX;
    int mXD;
    int mY;
    int memState;
    String msgCh = "0";
    String msgCOM = "None";
    String msgRx = ".";
    String msgTx = ".";
    int mXL;
    int mYL;
    int nextWiFims = 0;
    int nextMillis = 0;
    int Ping = 0;
    String Released$ = "10/02/2025";
    String Rx$ = "";
    int servoLast = 0;
    int servoLL = 0;
    int servoTgt = 0;
    int servoUL = 255;
    int sliderDwn = 0;
    int speedTQ = 0;
    int TB = 0;
    int TG = 0;
    int TR = 0;
    String usbBuff = "";
    int usbLen = 0;
    String usbMsg = "";
    int WiFiInt = 90;
    int WiFiPW = 64;
    boolean[] Ch_En = new boolean[10];
    int[] JoyXval = new int[10];
    int[] servoVal = new int[10];
    int[] servoVLL = new int[10];
    int[] servoVUL = new int[10];

    public void setup() {
        this.mON = 0;
        this.LoadDefArrays();
        this.ClearChEn();
        this.img = this.loadImage("8-Channel Controller.png");
        this.textSize(15.0f);
        this.getCOMPort();
        Proc_8Ch_Controller.println((String)"Ready!");
        this.sendExpRq();
        this.setXSlider();
    }

    public void draw() {
        if (this.drawFlag > 0) {
            this.background(this.img);
            this.drawChEn();
            this.drawServoVal();
            this.drawLLMsg();
            this.drawULMsg();
            this.drawJoyX();
            this.drawCOMMsg();
            this.drawRxMsg();
            this.drawTxMsg();
            this.drawHelp();
            this.drawFlag = 0;
        }
        if (this.mON > 0) {
            this.drawMouseXY();
        }
        if (this.millis() >= this.nextWiFims) {
            this.nextWiFims += this.WiFiInt;
            if (this.nextWiFims < this.millis()) {
                this.nextWiFims = this.millis() + this.WiFiInt;
            }
            if (this.comFlag > 0) {
                this.usbPortOp();
            } else {
                this.usbBuff = "";
            }
        }
        if (this.millis() >= this.nextMillis) {
            this.nextMillis += this.interval;
            if (this.nextMillis < this.millis()) {
                this.nextMillis = this.millis() + this.interval;
            }
            if (this.mDwn > 0) {
                --this.mDwn;
                if (this.mDwn < 1) {
                    this.mDwn = 5;
                    this.mouseDown();
                }
            }
            --this.Ping;
            if (this.Ping < 1) {
                this.Ping = 50;
                if (this.comFlag > 0) {
                    this.usbPort.write("#");
                }
            }
        }
    }

    public void keyPressed() {
        this.keyDwn = 1;
        if (this.keyCode == 16) {
            this.keySHIFT = true;
        }
    }

    public void keyReleased() {
        this.keyDwn = 0;
        this.keySHIFT = false;
    }

    public void mouseDragged() {
        this.mX = this.mouseX;
        this.mY = this.mouseY;
        if (this.sliderDwn > 0) {
            this.readXSlider(this.servoTgt);
        }
    }

    public void mouseDown() {
        if (this.sliderDwn == 1) {
            return;
        }
        if (this.mY >= 96 && this.mY <= 470 || this.mY >= 521 && this.mY <= 612) {
            if (this.mX <= 74) {
                this.SetChEn();
                this.mDwn = 0;
            }
            if (this.mX >= 279 && this.mX <= 299) {
                this.decXSlider();
            }
            if (this.mX >= 828 && this.mX <= 849) {
                this.incXSlider();
            }
            if (this.mX >= 172 && this.mX <= 190) {
                this.setLLValDwn();
            }
            if (this.mX >= 255 && this.mX <= 273) {
                this.setLLValUp();
            }
            if (this.mX >= 856 && this.mX <= 874) {
                this.setULValDwn();
            }
            if (this.mX >= 940 && this.mX <= 957) {
                this.setULValUp();
            }
        }
    }

    public void mouseMoved() {
        this.mX = this.mouseX;
        this.mY = this.mouseY;
        this.Help_Message();
        if (this.mON > 0) {
            this.drawFlag = 1;
        }
        if (this.mY >= 96 && this.mY <= 470) {
            this.servoTgt = (this.mY - 96) * 8 / 374;
            if (this.servoTgt < 0) {
                this.servoTgt = 0;
            }
            if (this.servoTgt > 7) {
                this.servoTgt = 7;
            }
        }
    }

    public void mousePressed() {
        this.mX = this.mouseX;
        this.mY = this.mouseY;
        this.mB = this.mouseButton;
        this.mDwn = 25;
        this.cursor(12);
        if (this.mX < 18 && this.mY < 18) {
            if (this.mON < 1) {
                this.mON = 1;
            } else {
                this.mON = 0;
                this.drawFlag = 1;
            }
        }
        if (this.mY >= 25 && this.mY <= 66 && this.mX >= 954 && this.mX <= 1040) {
            this.sendRESET();
        }
        if (this.mY >= 96 && this.mY <= 470) {
            if (this.mX <= 73) {
                this.toggleChEn();
                this.mDwn = 50;
            }
            if (this.mX >= 173 && this.mX <= 190) {
                this.setLLValDwn();
            }
            if (this.mX >= 256 && this.mX <= 273) {
                this.setLLValUp();
            }
            if (this.mX >= 278 && this.mX <= 298) {
                this.decXSlider();
            }
            if (this.mX >= 829 && this.mX <= 849) {
                this.incXSlider();
            }
            if (this.mX > 298 && this.mX < 829) {
                this.sliderDwn = 1;
                this.mXD = this.mX - this.JoyXval[this.servoTgt];
                this.readXSlider(this.servoTgt);
            }
            if (this.mX >= 856 && this.mX <= 873) {
                this.setULValDwn();
            }
            if (this.mX >= 940 && this.mX <= 956) {
                this.setULValUp();
            }
            if (this.mX > 190 && this.mX < 256) {
                this.setLL();
            }
            if (this.mX > 873 && this.mX < 940) {
                this.setUL();
            }
        }
        if (this.mX >= 131 && this.mX <= 222 && this.mY >= 492 && this.mY <= 524) {
            if (this.mouseButton == 37) {
                this.getCOMPort();
            } else if (this.mouseButton == 39) {
                this.closeCOMPort();
            }
        }
    }

    public void mouseReleased() {
        this.mX = this.mouseX;
        this.mY = this.mouseY;
        this.cursor(0);
        this.mDwn = 0;
        this.sliderDwn = 0;
    }

    public void serialEvent(Serial usbPort) {
        this.nextWiFims = this.millis() + 10;
        this.Rx$ = usbPort.readString();
        Proc_8Ch_Controller.print((String)this.Rx$);
        this.data = String.valueOf(this.data) + this.Rx$;
        int RxLF = this.data.indexOf(this.LF);
        if (RxLF >= 0) {
            if (this.data.indexOf("#") == 0) {
                this.data = Proc_8Ch_Controller.trim((String)this.data);
                if (this.data.indexOf("F") != 1) {
                    this.data.indexOf("L");
                }
            } else if (this.data.indexOf("R") != 1 && this.data.indexOf("U") != 1) {
                this.msgRx = this.data;
                if (this.data.length() > 20) {
                    this.msgRx = this.data.substring(0, 20);
                }
            }
            this.data = "";
            this.drawFlag = 1;
        }
    }

    public void drawBlankouts() {
        this.stroke(255.0f, 255.0f, 255.0f);
        this.strokeWeight(1.0f);
        this.fill(255.0f, 255.0f, 255.0f);
        this.rect(438.0f, 7.0f, 336.0f, 38.0f);
    }

    public void drawChEn() {
        this.strokeWeight(3.0f);
        if (this.Ch_En[0] || this.Ch_En[1]) {
            this.noFill();
            this.stroke(255.0f, 0.0f, 0.0f);
            this.rect(19.0f, 97.0f, 54.0f, 89.0f);
            this.rect(970.0f, 100.0f, 18.0f, 32.0f);
        }
        if (this.Ch_En[2] || this.Ch_En[3]) {
            this.noFill();
            this.stroke(255.0f, 0.0f, 0.0f);
            this.rect(19.0f, 191.0f, 54.0f, 89.0f);
            this.rect(1024.0f, 195.0f, 18.0f, 32.0f);
        }
        if (this.Ch_En[4] || this.Ch_En[5]) {
            this.noFill();
            this.stroke(255.0f, 0.0f, 0.0f);
            this.rect(19.0f, 286.0f, 54.0f, 89.0f);
            this.rect(970.0f, 338.0f, 18.0f, 32.0f);
        }
        if (this.Ch_En[6] || this.Ch_En[7]) {
            this.noFill();
            this.stroke(255.0f, 0.0f, 0.0f);
            this.rect(19.0f, 380.0f, 54.0f, 89.0f);
            this.rect(1024.0f, 433.0f, 18.0f, 32.0f);
        }
        this.stroke(0.0f, 0.0f, 0.0f);
        this.strokeWeight(1.0f);
    }

    public void drawCOMMsg() {
        if (this.comFlag < 1) {
            this.TR = 255;
        }
        this.drawTxtCtrField(this.msgCOM, 176, 502);
        this.TR = 0;
    }

    public void drawHelp() {
        this.TR = 0;
        this.TG = 0;
        this.TB = 255;
        this.drawTxtCtrField(this.Help$, 482, 540);
    }

    public void drawJoyX() {
        if (this.comFlag < 1) {
            return;
        }
        int zXw = 16;
        this.stroke(0.0f, 0.0f, 0.0f);
        this.strokeWeight(2.0f);
        if (this.Ch_En[0]) {
            this.fill(255.0f, 100.0f, 100.0f);
        } else {
            this.fill(255.0f, 255.0f, 255.0f);
        }
        this.rect(this.JoyXval[0] - zXw, 100.0f, zXw + zXw, 36.0f);
        if (this.Ch_En[1]) {
            this.fill(255.0f, 100.0f, 100.0f);
        } else {
            this.fill(255.0f, 255.0f, 255.0f);
        }
        this.rect(this.JoyXval[1] - zXw, 147.0f, zXw + zXw, 36.0f);
        if (this.Ch_En[2]) {
            this.fill(255.0f, 100.0f, 100.0f);
        } else {
            this.fill(255.0f, 255.0f, 255.0f);
        }
        this.rect(this.JoyXval[2] - zXw, 195.0f, zXw + zXw, 36.0f);
        if (this.Ch_En[3]) {
            this.fill(255.0f, 100.0f, 100.0f);
        } else {
            this.fill(255.0f, 255.0f, 255.0f);
        }
        this.rect(this.JoyXval[3] - zXw, 242.0f, zXw + zXw, 36.0f);
        if (this.Ch_En[4]) {
            this.fill(255.0f, 100.0f, 100.0f);
        } else {
            this.fill(255.0f, 255.0f, 255.0f);
        }
        this.rect(this.JoyXval[4] - zXw, 289.0f, zXw + zXw, 36.0f);
        if (this.Ch_En[5]) {
            this.fill(255.0f, 100.0f, 100.0f);
        } else {
            this.fill(255.0f, 255.0f, 255.0f);
        }
        this.rect(this.JoyXval[5] - zXw, 337.0f, zXw + zXw, 36.0f);
        if (this.Ch_En[6]) {
            this.fill(255.0f, 100.0f, 100.0f);
        } else {
            this.fill(255.0f, 255.0f, 255.0f);
        }
        this.rect(this.JoyXval[6] - zXw, 383.0f, zXw + zXw, 36.0f);
        if (this.Ch_En[7]) {
            this.fill(255.0f, 100.0f, 100.0f);
        } else {
            this.fill(255.0f, 255.0f, 255.0f);
        }
        this.rect(this.JoyXval[7] - zXw, 431.0f, zXw + zXw, 36.0f);
    }

    public void drawLLMsg() {
        if (this.comFlag < 1) {
            return;
        }
        int zX = 222;
        this.drawTxtCtrField(Proc_8Ch_Controller.str((int)this.servoVLL[0]), zX, 111);
        this.drawTxtCtrField(Proc_8Ch_Controller.str((int)this.servoVLL[1]), zX, 159);
        this.drawTxtCtrField(Proc_8Ch_Controller.str((int)this.servoVLL[2]), zX, 206);
        this.drawTxtCtrField(Proc_8Ch_Controller.str((int)this.servoVLL[3]), zX, 254);
        this.drawTxtCtrField(Proc_8Ch_Controller.str((int)this.servoVLL[4]), zX, 300);
        this.drawTxtCtrField(Proc_8Ch_Controller.str((int)this.servoVLL[5]), zX, 348);
        this.drawTxtCtrField(Proc_8Ch_Controller.str((int)this.servoVLL[6]), zX, 394);
        this.drawTxtCtrField(Proc_8Ch_Controller.str((int)this.servoVLL[7]), zX, 442);
    }

    public void drawMouseXY() {
        if (this.mX != this.mXL || this.mY != this.mYL) {
            this.stroke(255.0f, 0.0f, 0.0f, 128.0f);
            this.strokeWeight(1.0f);
            this.line(0.0f, this.mY, 1069.0f, this.mY);
            this.line(this.mX, 0.0f, this.mX, 719.0f);
            int zX = this.mX > 535 ? this.mX - 70 : this.mX + 6;
            int zY = this.mY > 360 ? this.mY - 38 : this.mY + 8;
            this.stroke(0.0f, 0.0f, 0.0f);
            this.fill(255.0f, 255.0f, 255.0f);
            this.rect(zX, zY, 64.0f, 30.0f);
            this.fill(0.0f, 0.0f, 0.0f);
            this.text("X=" + this.mX, zX + 4, zY + 14);
            this.text("Y=" + this.mY, zX + 4, zY + 28);
            this.mXL = this.mX;
            this.mYL = this.mY;
        }
    }

    public void drawRxMsg() {
        this.drawTxtField("                                                 ", 294, 637);
        this.drawTxtField(this.msgRx, 294, 502);
    }

    public void drawServoVal() {
        if (this.comFlag < 1) {
            return;
        }
        int zX = 120;
        String zSV$ = "";
        zSV$ = Proc_8Ch_Controller.str((int)this.servoVal[0]);
        this.drawTxtCtrField(zSV$, zX, 111);
        zSV$ = Proc_8Ch_Controller.str((int)this.servoVal[1]);
        this.drawTxtCtrField(zSV$, zX, 159);
        zSV$ = Proc_8Ch_Controller.str((int)this.servoVal[2]);
        this.drawTxtCtrField(zSV$, zX, 206);
        zSV$ = Proc_8Ch_Controller.str((int)this.servoVal[3]);
        this.drawTxtCtrField(zSV$, zX, 254);
        zSV$ = Proc_8Ch_Controller.str((int)this.servoVal[4]);
        this.drawTxtCtrField(zSV$, zX, 300);
        zSV$ = Proc_8Ch_Controller.str((int)this.servoVal[5]);
        this.drawTxtCtrField(zSV$, zX, 348);
        zSV$ = Proc_8Ch_Controller.str((int)this.servoVal[6]);
        this.drawTxtCtrField(zSV$, zX, 394);
        zSV$ = Proc_8Ch_Controller.str((int)this.servoVal[7]);
        this.drawTxtCtrField(zSV$, zX, 442);
    }

    public void drawTxtCtrField(String zM, int zX, int zY) {
        this.stroke(this.BR, this.BG, this.BB);
        this.fill(this.BR, this.BG, this.BB);
        this.rect(zX -= (int)(this.textWidth(zM) / 2.0f), zY, this.textWidth(zM), 15.0f);
        this.fill(this.TR, this.TG, this.TB);
        this.text(zM, zX, zY + 12);
    }

    public void drawTxMsg() {
        this.drawTxtField("                                             ", 613, 637);
        this.drawTxtField(this.msgTx, 613, 502);
    }

    public void drawTxtField(String zM, int zX, int zY) {
        this.stroke(242.0f, 242.0f, 242.0f);
        this.fill(242.0f, 242.0f, 242.0f);
        this.rect(zX, zY, 8.0f + this.textWidth(zM), 14.0f);
        this.fill(this.TR, this.TG, this.TB);
        this.text(zM, zX + 4, zY + 12);
    }

    public void drawULMsg() {
        if (this.comFlag < 1) {
            return;
        }
        int zX = 907;
        this.drawTxtCtrField(Proc_8Ch_Controller.str((int)this.servoVUL[0]), zX, 111);
        this.drawTxtCtrField(Proc_8Ch_Controller.str((int)this.servoVUL[1]), zX, 159);
        this.drawTxtCtrField(Proc_8Ch_Controller.str((int)this.servoVUL[2]), zX, 206);
        this.drawTxtCtrField(Proc_8Ch_Controller.str((int)this.servoVUL[3]), zX, 254);
        this.drawTxtCtrField(Proc_8Ch_Controller.str((int)this.servoVUL[4]), zX, 300);
        this.drawTxtCtrField(Proc_8Ch_Controller.str((int)this.servoVUL[5]), zX, 348);
        this.drawTxtCtrField(Proc_8Ch_Controller.str((int)this.servoVUL[6]), zX, 394);
        this.drawTxtCtrField(Proc_8Ch_Controller.str((int)this.servoVUL[7]), zX, 442);
    }

    public void centreJoyX() {
        this.servoVal[this.servoTgt] = this.servoVLL[this.servoTgt] + (this.servoVUL[this.servoTgt] - this.servoVLL[this.servoTgt]) / 2;
        this.setSliderX();
        this.drawFlag = 1;
    }

    public void centreServo() {
        this.centreJoyX();
        this.servoLast = this.servoVal[this.servoTgt];
        this.msgTx = "PV" + Proc_8Ch_Controller.str((int)this.servoVal[this.servoTgt]) + ".";
        this.usbPortWrite(this.msgTx);
    }

    public void ClearChEn() {
        int zC = 0;
        while (zC < 8) {
            this.Ch_En[zC] = false;
            ++zC;
        }
        this.Ch_Cnt = 0;
    }

    public void closeCOMPort() {
        if (this.comFlag > 0) {
            this.usbPort.clear();
            this.usbPort.stop();
            this.comFlag = 0;
            this.msgCOM = "----";
            this.drawFlag = 1;
            this.msgTx = "COM Port Closed";
            Proc_8Ch_Controller.println((String)this.msgTx);
            this.ClearChEn();
        }
    }

    public void countChannels() {
        this.Ch_Cnt = 0;
        int zC = 0;
        while (zC < 8) {
            if (this.Ch_En[zC]) {
                ++this.Ch_Cnt;
            }
            ++zC;
        }
    }

    public void decXSlider() {
        if (this.comFlag < 1) {
            return;
        }
        if (this.servoVal[this.servoTgt] > this.servoVLL[this.servoTgt]) {
            this.servoLast = this.servoVal[this.servoTgt];
            if (this.keySHIFT) {
                int n = this.servoTgt;
                this.servoVal[n] = this.servoVal[n] - 5;
            } else {
                int n = this.servoTgt;
                this.servoVal[n] = this.servoVal[n] - 1;
            }
            if (this.servoVal[this.servoTgt] < this.servoVLL[this.servoTgt]) {
                this.servoVal[this.servoTgt] = this.servoVLL[this.servoTgt];
            }
            this.setXSlider();
            this.msgTx = this.Ch_En[this.servoTgt] ? "PT" + Proc_8Ch_Controller.str((int)this.servoTgt) + "." + "PV" + Proc_8Ch_Controller.str((int)this.servoVal[this.servoTgt]) + "." : "PT" + Proc_8Ch_Controller.str((int)this.servoTgt) + "." + "PV0.";
            if (this.Ch_En[this.servoTgt]) {
                this.usbPortWrite(this.msgTx);
                this.msgTx = ">" + this.msgTx;
            }
            this.drawFlag = 1;
        }
    }

    public void exit() {
        this.usbPortWrite("XX.");
        this.delay(20);
        super.exit();
    }

    public void getCOMPort() {
        if (this.comFlag > 0) {
            this.closeCOMPort();
            this.delay(100);
        }
        this.comListLength = Serial.list().length;
        if (this.comListLength > 0) {
            ++this.comPnt;
            if (this.comPnt >= this.comListLength) {
                this.comPnt = 0;
            }
            this.comName = Serial.list()[this.comPnt];
            Proc_8Ch_Controller.println((String)this.comName);
            try {
                this.usbPort = new Serial((PApplet)this, this.comName, 115200);
                this.comFlag = 1;
                this.msgCOM = this.comName;
                this.msgTx = "USB Connected";
                Proc_8Ch_Controller.println((String)this.msgTx);
            }
            catch (Exception exception) {
                this.comFlag = 0;
                this.msgCOM = "-Error-";
            }
        } else {
            this.comFlag = 0;
            this.msgCOM = "- NA -";
        }
        this.drawFlag = 1;
    }

    public void incXSlider() {
        if (this.comFlag < 1) {
            return;
        }
        if (this.servoVal[this.servoTgt] < this.servoVUL[this.servoTgt]) {
            this.servoLast = this.servoVal[this.servoTgt];
            if (this.keySHIFT) {
                int n = this.servoTgt;
                this.servoVal[n] = this.servoVal[n] + 5;
            } else {
                int n = this.servoTgt;
                this.servoVal[n] = this.servoVal[n] + 1;
            }
            if (this.servoVal[this.servoTgt] > this.servoVUL[this.servoTgt]) {
                this.servoVal[this.servoTgt] = this.servoVUL[this.servoTgt];
            }
            this.setXSlider();
            this.msgTx = this.Ch_En[this.servoTgt] ? "PT" + Proc_8Ch_Controller.str((int)this.servoTgt) + "." + "PV" + Proc_8Ch_Controller.str((int)this.servoVal[this.servoTgt]) + "." : "PT" + Proc_8Ch_Controller.str((int)this.servoTgt) + "." + "PV0.";
            if (this.Ch_En[this.servoTgt]) {
                this.usbPortWrite(this.msgTx);
                this.msgTx = ">" + this.msgTx;
            }
            this.drawFlag = 1;
        }
    }

    public void LoadDefArrays() {
        int zS = 0;
        while (zS < 8) {
            this.servoVal[zS] = 255;
            this.servoVLL[zS] = 0;
            this.servoVUL[zS] = 255;
            ++zS;
        }
    }

    public void readXSlider(int zS) {
        if (this.comFlag < 1) {
            return;
        }
        this.servoLast = this.servoVal[zS];
        this.JoyXval[zS] = this.mX - this.mXD;
        this.JoyXval[zS] = Proc_8Ch_Controller.max((int)this.JoyXval[zS], (int)this.JoyX0);
        this.JoyXval[zS] = Proc_8Ch_Controller.min((int)this.JoyXval[zS], (int)this.JoyX1);
        this.servoVal[zS] = this.servoVLL[zS] + (this.JoyXval[zS] - this.JoyX0) * (this.servoVUL[this.servoTgt] - this.servoVLL[this.servoTgt]) / (this.JoyX1 - this.JoyX0);
        this.servoVal[zS] = Proc_8Ch_Controller.max((int)this.servoVal[zS], (int)this.servoVLL[zS]);
        this.servoVal[zS] = Proc_8Ch_Controller.min((int)this.servoVal[zS], (int)this.servoVUL[zS]);
        if (this.servoLast != this.servoVal[zS]) {
            if (zS == 0 && this.servoVal[1] > 0 && this.servoVal[1] < 255) {
                if (this.servoVal[zS] >= 127) {
                    this.servoVal[zS] = 255;
                    this.JoyXval[zS] = this.JoyX1;
                }
                if (this.servoVal[zS] < 127) {
                    this.servoVal[zS] = 0;
                    this.JoyXval[zS] = this.JoyX0;
                }
            }
            if (zS == 1 && this.servoVal[0] > 0 && this.servoVal[0] < 255) {
                if (this.servoVal[zS] >= 127) {
                    this.servoVal[zS] = 255;
                    this.JoyXval[zS] = this.JoyX1;
                }
                if (this.servoVal[zS] < 127) {
                    this.servoVal[zS] = 0;
                    this.JoyXval[zS] = this.JoyX0;
                }
            }
            if (zS == 2 && this.servoVal[3] > 0 && this.servoVal[3] < 255) {
                if (this.servoVal[zS] >= 127) {
                    this.servoVal[zS] = 255;
                    this.JoyXval[zS] = this.JoyX1;
                }
                if (this.servoVal[zS] < 127) {
                    this.servoVal[zS] = 0;
                    this.JoyXval[zS] = this.JoyX0;
                }
            }
            if (zS == 3 && this.servoVal[2] > 0 && this.servoVal[2] < 255) {
                if (this.servoVal[zS] >= 127) {
                    this.servoVal[zS] = 255;
                    this.JoyXval[zS] = this.JoyX1;
                }
                if (this.servoVal[zS] < 127) {
                    this.servoVal[zS] = 0;
                    this.JoyXval[zS] = this.JoyX0;
                }
            }
            if (zS == 4 && this.servoVal[5] > 0 && this.servoVal[5] < 255) {
                if (this.servoVal[zS] >= 127) {
                    this.servoVal[zS] = 255;
                    this.JoyXval[zS] = this.JoyX1;
                }
                if (this.servoVal[zS] < 127) {
                    this.servoVal[zS] = 0;
                    this.JoyXval[zS] = this.JoyX0;
                }
            }
            if (zS == 5 && this.servoVal[4] > 0 && this.servoVal[4] < 255) {
                if (this.servoVal[zS] >= 127) {
                    this.servoVal[zS] = 255;
                    this.JoyXval[zS] = this.JoyX1;
                }
                if (this.servoVal[zS] < 127) {
                    this.servoVal[zS] = 0;
                    this.JoyXval[zS] = this.JoyX0;
                }
            }
            if (zS == 6 && this.servoVal[7] > 0 && this.servoVal[7] < 255) {
                if (this.servoVal[zS] >= 127) {
                    this.servoVal[zS] = 255;
                    this.JoyXval[zS] = this.JoyX1;
                }
                if (this.servoVal[zS] < 127) {
                    this.servoVal[zS] = 0;
                    this.JoyXval[zS] = this.JoyX0;
                }
            }
            if (zS == 7 && this.servoVal[6] > 0 && this.servoVal[6] < 255) {
                if (this.servoVal[zS] >= 127) {
                    this.servoVal[zS] = 255;
                    this.JoyXval[zS] = this.JoyX1;
                }
                if (this.servoVal[zS] < 127) {
                    this.servoVal[zS] = 0;
                    this.JoyXval[zS] = this.JoyX0;
                }
            }
            if (this.servoLast == this.servoVal[zS]) {
                return;
            }
            this.msgTx = "PT" + Proc_8Ch_Controller.str((int)zS) + "." + "PV" + Proc_8Ch_Controller.str((int)this.servoVal[zS]) + ".";
            this.servoLast = this.servoVal[zS];
            if (this.Ch_En[zS]) {
                this.usbPortWrite(this.msgTx);
                this.msgTx = ">" + this.msgTx;
            }
            this.drawFlag = 1;
        }
    }

    public void sendButton(String zS) {
        if (this.comFlag < 1) {
            return;
        }
        this.msgTx = zS;
        this.usbPortWrite(this.msgTx);
        this.drawFlag = 1;
    }

    public void sendExpRq() {
        this.msgTx = "SE.";
        this.usbPortWrite(this.msgTx);
        this.drawFlag = 1;
    }

    public void sendRESET() {
        this.ClearChEn();
        this.LoadDefArrays();
        this.setXSlider();
        this.msgTx = "!";
        this.usbPortWrite(this.msgTx);
        this.drawFlag = 1;
    }

    public void sendServoVal() {
        this.servoLast = this.servoVal[this.servoTgt];
        int zTgt = 0;
        if (this.servoTgt == 0) {
            zTgt = 1;
        }
        if (this.servoTgt == 1) {
            zTgt = 0;
        }
        if (this.servoTgt == 2) {
            zTgt = 3;
        }
        if (this.servoTgt == 3) {
            zTgt = 2;
        }
        if (this.servoTgt == 4) {
            zTgt = 5;
        }
        if (this.servoTgt == 5) {
            zTgt = 4;
        }
        if (this.servoTgt == 6) {
            zTgt = 7;
        }
        if (this.servoTgt == 7) {
            zTgt = 6;
        }
        this.msgTx = "PT" + Proc_8Ch_Controller.str((int)this.servoTgt) + "." + "PV" + Proc_8Ch_Controller.str((int)this.servoVal[this.servoTgt]) + ".";
        this.msgTx = String.valueOf(this.msgTx) + "PT" + Proc_8Ch_Controller.str((int)zTgt) + "." + "PV" + Proc_8Ch_Controller.str((int)this.servoVal[zTgt]) + ".";
        if (this.Ch_En[this.servoTgt]) {
            this.usbPortWrite(this.msgTx);
            this.msgTx = ">" + this.msgTx;
        }
        this.drawFlag = 1;
    }

    public void SetChEn() {
        if (this.comFlag < 1) {
            return;
        }
        int zS = this.servoTgt;
        this.servoTgt = 0;
        while (this.servoTgt < 8) {
            this.Ch_En[this.servoTgt] = this.Ch_En[zS];
            this.sendServoVal();
            ++this.servoTgt;
        }
        this.servoTgt = zS;
        this.drawFlag = 1;
        this.countChannels();
    }

    public void setLL() {
        if (this.comFlag < 1) {
            return;
        }
        this.LastVal = this.servoVLL[this.servoTgt];
        if (this.mB == 37) {
            this.servoVLL[this.servoTgt] = this.servoVal[this.servoTgt];
            if (this.servoVLL[this.servoTgt] >= this.servoVUL[this.servoTgt]) {
                int n = this.servoTgt;
                this.servoVLL[n] = this.servoVLL[n] - 1;
            }
        } else {
            this.servoVLL[this.servoTgt] = this.servoLL;
        }
        this.setXSlider();
        this.drawFlag = 1;
        this.msgTx = "PT";
        this.msgTx = String.valueOf(this.msgTx) + Proc_8Ch_Controller.str((int)this.servoTgt) + ".";
        this.msgTx = String.valueOf(this.msgTx) + "SL" + Proc_8Ch_Controller.str((int)this.servoVLL[this.servoTgt]) + ".";
        if (this.Ch_En[this.servoTgt]) {
            this.usbPortWrite(this.msgTx);
            this.msgTx = ">" + this.msgTx;
        }
    }

    public void setLLValDwn() {
        if (this.comFlag < 1) {
            return;
        }
        if (this.servoVLL[this.servoTgt] > this.servoLL) {
            int n = this.servoTgt;
            this.servoVLL[n] = this.servoVLL[n] - 1;
            if (this.keySHIFT) {
                int n2 = this.servoTgt;
                this.servoVLL[n2] = this.servoVLL[n2] - 5;
            } else {
                int n3 = this.servoTgt;
                this.servoVLL[n3] = this.servoVLL[n3] - 1;
            }
            if (this.servoVLL[this.servoTgt] < 0) {
                this.servoVLL[this.servoTgt] = 0;
            }
            this.setXSlider();
            this.drawFlag = 1;
            this.msgTx = "PT";
            this.msgTx = String.valueOf(this.msgTx) + Proc_8Ch_Controller.str((int)this.servoTgt) + ".";
            this.msgTx = String.valueOf(this.msgTx) + "SL" + Proc_8Ch_Controller.str((int)this.servoVLL[this.servoTgt]) + ".";
            if (this.Ch_En[this.servoTgt]) {
                this.usbPortWrite(this.msgTx);
                this.msgTx = ">" + this.msgTx;
            }
        }
    }

    public void setLLValUp() {
        if (this.comFlag < 1) {
            return;
        }
        if (this.servoVLL[this.servoTgt] < this.servoUL) {
            if (this.keySHIFT) {
                int n = this.servoTgt;
                this.servoVLL[n] = this.servoVLL[n] + 5;
            } else {
                int n = this.servoTgt;
                this.servoVLL[n] = this.servoVLL[n] + 1;
            }
            if (this.servoVLL[this.servoTgt] > 254) {
                this.servoVLL[this.servoTgt] = 254;
            }
            if (this.servoVLL[this.servoTgt] >= this.servoVUL[this.servoTgt]) {
                this.servoVUL[this.servoTgt] = this.servoVLL[this.servoTgt] + 1;
            }
            if (this.servoVal[this.servoTgt] < this.servoVLL[this.servoTgt]) {
                this.servoVal[this.servoTgt] = this.servoVLL[this.servoTgt];
            }
            this.setXSlider();
            this.drawFlag = 1;
            this.msgTx = "PT";
            this.msgTx = String.valueOf(this.msgTx) + Proc_8Ch_Controller.str((int)this.servoTgt) + ".";
            this.msgTx = String.valueOf(this.msgTx) + "SL" + Proc_8Ch_Controller.str((int)this.servoVLL[this.servoTgt]) + ".";
            if (this.Ch_En[this.servoTgt]) {
                this.usbPortWrite(this.msgTx);
                this.msgTx = ">" + this.msgTx;
            }
        }
    }

    public void setSliderX() {
        if (this.comFlag < 1) {
            return;
        }
        int zX0 = 259;
        int zX1 = 655;
        int zSV = this.servoVal[this.servoTgt];
        this.JoyXval[this.servoTgt] = zX0 + (zSV - this.servoVLL[this.servoTgt]) * (zX1 - zX0) / (this.servoVUL[this.servoTgt] - this.servoVLL[this.servoTgt]);
        this.drawFlag = 1;
    }

    public void setUL() {
        if (this.comFlag < 1) {
            return;
        }
        this.LastVal = this.servoVUL[this.servoTgt];
        if (this.mB == 37) {
            this.servoVUL[this.servoTgt] = this.servoVal[this.servoTgt];
            if (this.servoVUL[this.servoTgt] <= this.servoVLL[this.servoTgt]) {
                this.servoVUL[this.servoTgt] = this.servoVLL[this.servoTgt] + 1;
            }
        } else {
            this.servoVUL[this.servoTgt] = this.servoUL;
        }
        this.setXSlider();
        this.drawFlag = 1;
        this.msgTx = "PT";
        this.msgTx = String.valueOf(this.msgTx) + Proc_8Ch_Controller.str((int)this.servoTgt) + ".";
        this.msgTx = String.valueOf(this.msgTx) + "SU" + Proc_8Ch_Controller.str((int)this.servoVLL[this.servoTgt]) + ".";
        if (this.Ch_En[this.servoTgt]) {
            this.usbPortWrite(this.msgTx);
            this.msgTx = ">" + this.msgTx;
        }
    }

    public void setULValDwn() {
        if (this.comFlag < 1) {
            return;
        }
        if (this.servoVUL[this.servoTgt] > 1) {
            if (this.keySHIFT) {
                int n = this.servoTgt;
                this.servoVUL[n] = this.servoVUL[n] - 5;
            } else {
                int n = this.servoTgt;
                this.servoVUL[n] = this.servoVUL[n] - 1;
            }
            if (this.servoVUL[this.servoTgt] < 2) {
                this.servoVLL[this.servoTgt] = 1;
            }
            if (this.servoVUL[this.servoTgt] <= this.servoVLL[this.servoTgt]) {
                this.servoVLL[this.servoTgt] = this.servoVUL[this.servoTgt] - 1;
            }
            if (this.servoVal[this.servoTgt] > this.servoVUL[this.servoTgt]) {
                this.servoVal[this.servoTgt] = this.servoVUL[this.servoTgt];
            }
            this.setXSlider();
            this.drawFlag = 1;
            this.msgTx = "PT";
            this.msgTx = String.valueOf(this.msgTx) + Proc_8Ch_Controller.str((int)this.servoTgt) + ".";
            this.msgTx = String.valueOf(this.msgTx) + "SU" + Proc_8Ch_Controller.str((int)this.servoVUL[this.servoTgt]) + ".";
            if (this.Ch_En[this.servoTgt]) {
                this.usbPortWrite(this.msgTx);
                this.msgTx = ">" + this.msgTx;
            }
        }
    }

    public void setULValUp() {
        if (this.comFlag < 1) {
            return;
        }
        int zUL = 255;
        if (this.servoTgt > 7) {
            zUL = 1000;
        }
        if (this.servoVUL[this.servoTgt] < zUL) {
            if (this.keySHIFT) {
                int n = this.servoTgt;
                this.servoVUL[n] = this.servoVUL[n] + 5;
            } else {
                int n = this.servoTgt;
                this.servoVUL[n] = this.servoVUL[n] + 1;
            }
            if (this.servoVUL[this.servoTgt] > zUL) {
                this.servoVUL[this.servoTgt] = zUL;
            }
            this.setXSlider();
            this.drawFlag = 1;
            this.msgTx = "PT";
            this.msgTx = String.valueOf(this.msgTx) + Proc_8Ch_Controller.str((int)this.servoTgt) + ".";
            this.msgTx = String.valueOf(this.msgTx) + "SU" + Proc_8Ch_Controller.str((int)this.servoVUL[this.servoTgt]) + ".";
            if (this.Ch_En[this.servoTgt]) {
                this.usbPortWrite(this.msgTx);
                this.msgTx = ">" + this.msgTx;
            }
        }
    }

    public void setXSlider() {
        int zX0 = this.JoyX0;
        int zX1 = this.JoyX1;
        int zS = 0;
        while (zS < 8) {
            this.JoyXval[zS] = zX0 + (this.servoVal[zS] - this.servoVLL[zS]) * (zX1 - zX0) / (this.servoVUL[zS] - this.servoVLL[zS]);
            ++zS;
        }
        this.drawFlag = 1;
    }

    public void toggleChEn() {
        if (this.comFlag < 1) {
            return;
        }
        boolean bl = this.Ch_En[this.servoTgt] = !this.Ch_En[this.servoTgt];
        if (this.servoTgt == 0) {
            this.Ch_En[1] = this.Ch_En[0];
        }
        if (this.servoTgt == 1) {
            this.Ch_En[0] = this.Ch_En[1];
        }
        if (this.servoTgt == 2) {
            this.Ch_En[3] = this.Ch_En[2];
        }
        if (this.servoTgt == 3) {
            this.Ch_En[2] = this.Ch_En[3];
        }
        if (this.servoTgt == 4) {
            this.Ch_En[5] = this.Ch_En[4];
        }
        if (this.servoTgt == 5) {
            this.Ch_En[4] = this.Ch_En[5];
        }
        if (this.servoTgt == 6) {
            this.Ch_En[7] = this.Ch_En[6];
        }
        if (this.servoTgt == 7) {
            this.Ch_En[6] = this.Ch_En[7];
        }
        this.sendServoVal();
        this.countChannels();
        this.drawFlag = 1;
    }

    public void usbPortOp() {
        this.usbLen = this.usbBuff.length();
        if (this.usbLen < 1) {
            return;
        }
        if (this.usbLen <= this.WiFiPW) {
            this.usbPort.write(this.usbBuff);
            this.usbBuff = "";
            this.usbLen = 0;
        } else {
            this.usbPort.write(this.usbBuff.substring(0, this.WiFiPW));
            this.usbBuff = this.usbBuff.substring(this.WiFiPW, this.usbBuff.length());
            this.usbLen = this.usbBuff.length();
        }
    }

    public void usbPortWrite(String zmsg) {
        this.usbBuff = this.comFlag > 0 ? zmsg : "";
    }

    public void Help_Message() {
        this.Help$ = "-";
        if (this.mX >= 954 && this.mX < 1040 && this.mY >= 25 && this.mY <= 66) {
            this.Help$ = "Click to send RESET command.";
        }
        if (this.mY >= 46 && this.mY <= 471) {
            int zCh = this.servoTgt;
            if (this.mX < 74) {
                this.Help$ = "Click to toggle channel " + Proc_8Ch_Controller.str((int)zCh) + " enable.";
            }
            if (this.mX >= 79 && this.mX <= 162) {
                this.Help$ = "Channel " + Proc_8Ch_Controller.str((int)zCh) + " slider value.";
            }
            if (this.mX >= 173 && this.mX <= 190) {
                this.Help$ = "Click to reduce channel " + Proc_8Ch_Controller.str((int)zCh) + " lower limit.";
            }
            if (this.mX >= 257 && this.mX <= 272) {
                this.Help$ = "Click to increase channel " + Proc_8Ch_Controller.str((int)zCh) + " lower limit.";
            }
            if (this.mX >= 279 && this.mX <= 300) {
                this.Help$ = "Click to reduce channel " + Proc_8Ch_Controller.str((int)zCh) + " value.";
            }
            if (this.mX >= 829 && this.mX <= 849) {
                this.Help$ = "Click to increase channel " + Proc_8Ch_Controller.str((int)zCh) + " value.";
            }
            if (this.mX >= 301 && this.mX <= 828) {
                this.Help$ = "Click and drag slider to adjust channel " + Proc_8Ch_Controller.str((int)zCh) + " value.";
            }
            if (this.mX >= 856 && this.mX <= 874) {
                this.Help$ = "Click to reduce channel " + Proc_8Ch_Controller.str((int)zCh) + " upper limit.";
            }
            if (this.mX >= 940 && this.mX <= 957) {
                this.Help$ = "Click to increase channel " + Proc_8Ch_Controller.str((int)zCh) + " upper limit.";
            }
            if (this.mX >= 191 && this.mX <= 256) {
                this.Help$ = "Channel " + Proc_8Ch_Controller.str((int)zCh) + " lower limit. Click to set from slider.";
            }
            if (this.mX >= 875 && this.mX <= 939) {
                this.Help$ = "Channel " + Proc_8Ch_Controller.str((int)zCh) + " upper limit. Click to set from slider.";
            }
        }
        if (this.mY >= 491 && this.mY <= 524) {
            if (this.mX >= 129 && this.mX <= 222) {
                this.Help$ = this.comFlag < 1 ? "USB port is disconnected. Click-left to connect." : "USB port is connected. Click-right to disconnect.";
            }
            if (this.mX >= 290 && this.mX <= 540) {
                this.Help$ = "Messages received from USB port.";
            }
            if (this.mX >= 608 && this.mX <= 839) {
                this.Help$ = "Messages sent to the USB port.";
            }
        }
        if (this.mX >= 14 && this.mX <= 63 && this.mY >= 513 && this.mY <= 561) {
            this.Help$ = "App written in Processing.   https://processing.org/";
        }
        if (this.mX >= 130 && this.mX <= 838 && this.mY >= 530 && this.mY <= 562) {
            this.Help$ = "Hello";
        }
        if (this.mX >= 923 && this.mX <= 1040 && this.mY >= 540 && this.mY <= 555) {
            this.Help$ = "Author: TechKnowTone     Released: " + this.Released$;
        }
        if (!this.Help$.equals(this.HelpLast$)) {
            this.HelpLast$ = this.Help$;
            this.drawFlag = 1;
        }
    }

    public void settings() {
        this.size(1070, 592);
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"Proc_8Ch_Controller"};
        if (passedArgs != null) {
            PApplet.main((String[])Proc_8Ch_Controller.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }
}

