
// ---------------------------------------------------------------------------------

void doModeTask() {
  // main task routine
  // Serial.println(mainMode);
  switch(mainMode) {
    case 0:
      // Mode 0 - default random pattern
      doModeTask0(); break;
    
    case 1: // Mode 1 - fixed pattern sequence
      doModeTask1(); break;

    case 2: // Mode 2 - random patterns and speeds
      doModeTask2(); break;

    case 3: // Mode 3 - accelerometer bars X,Y,Z
      doModeTask3(); break;

    case 4: // Mode 4 - accelerometer moving stripes
      doModeTask4(); break;

    case 5: // Mode 5
      doModeTask5(); break;

    case 6: // Mode 6
      doModeTask6(); break;

    case 7: // Mode 7 - test tasks
      doModeTask7(); break;

    case 80: // sleep mode
      doTdmTask0(); break;
      
    case 99:
      break; // null task called when the Mode switch is pressed
  }
}

// ---------------------------------------------------------------------------------

void doModeTask0() {
  // Mode 0 - default random pattern
  // random twinkle of LED colours in default condition
  switch(subTask) {
    case 0:
      doPatternRnd(); subTask++; taskCnt0 = 18 - taskSpeed; break;
    case 1:
      taskCnt0--; if(taskCnt0 < 1) {
        // timeout so change pattern and return to subTask 0
        subTask = 0; taskCnt1 = taskCnt1 + taskInc0;
        if (taskCnt1 > 140) {taskInc0 = -20;}
        if (taskCnt1 < 20) {taskInc0 = 10;}
        maxBright = taskCnt1; maxBright2 = maxBright/2; maxBright3 = maxBright/3;
      } break;
  } 
}

// ---------------------------------------------------------------------------------

void doModeTask1() {
  // Mode 1 - fixed pattern sequence
  getRndCol();
  switch(subTask) {
    case 0: doPattern0(); break;
    case 1: doPattern1(); break;
    case 2: doPattern2(); break;
    case 3: doPattern3(); break;
    case 4: doPattern4(); break;
    case 5: doPattern5(); break;
    case 6: doStripRnd(); break;
    case 99:
      // come here when a pattern task has completed
      subTaskNxt++; if (subTaskNxt > 6) {subTaskNxt = 0;} // test end of sequence
      subTask = subTaskNxt; patTask = 0; break;
  }
  if (subTask != 99) {subTaskNxt = subTask;} // make a note of current task
}

// ---------------------------------------------------------------------------------

void doModeTask2() {
  // Mode 2 - random patterns and speeds
  getRndCol();
  if (subTask == 0) {subTask = 1 + random(7); patTask = 0;}
  switch(subTask) {
    case 1: doPattern0(); break;
    case 2: doPattern1(); break;
    case 3: doPattern2(); break;
    case 4: doPattern3(); break;
    case 5: doPattern4(); break;
    case 6: doPattern5(); break;
    case 7: doStripRnd(); break;
    case 99:
      // come here when a pattern task has completed
      subTask = 0; break;
  }
}

// ---------------------------------------------------------------------------------

void doModeTask3() {
  // lights length of blade depending on angle of rotation
  // AcX =   Yaw +ve to right, -ve to left
  // AcY = Pitch +ve nose up, -ve nose down
  // AcX = Up/Dwn +ve upside down, -ve normal way up
  // blade is normally horizontal (Y) for rotation demonstration X,Z

  int zP;
  switch(subTask) {
    case 0:
      calAccVals();
      if (AcYV >= 0) {AcXV = -1; AcZV = -1;}  // blade pitch dominates, notmally horizontal
      if (AcXV >= 0) {AcYV = -1; AcZV = -1;}  // blade horizontal dominates
      if (AcZV >= 0) {AcXV = -1; AcYV = -1;}  // blade turned from horizontal
      for (zP = 0;zP < NumLEDs_1;zP++) {
        if (AcXV >= zP) {colGrn[zP] = (zP + 1) * 6;} else {colGrn[zP] = 0;}
        if (AcZV >= zP) {colBlu[zP] = (zP + 1) * 6;} else {colBlu[zP] = 0;}
        if (AcYV >= zP) {colRed[zP] = (zP + 1) * 6;} else {colRed[zP] = 0;}
      }
      showColArray(0); subTask = 99; subTaskNxt = 0; taskDel0 = 5;
      break;
    case 99:
      // delay task, counts down then goes to next subTask
      taskDel0--; if (taskDel0 < 1) {
        subTask = subTaskNxt; taskDel0 = 16 - taskSpeed;
      } break;
  }
}

// ---------------------------------------------------------------------------------

void doModeTask4() {
  // Mode 4 - accelerometer moving stripes
  switch(subTask) {
    case 0:
      // Serial.print("AcX= "); Serial.print(AcX);
      // Serial.print("  |  AcY= "); Serial.print(AcY);
      // Serial.print("  |  AcZ= "); Serial.print(AcZ);
      // Serial.print("\n");
           if (AcY > 6192 || AcY < -6192) {doStrip1(); subTask = 1;}
      else if (AcX > -4000 && AcX < 4000) {doStrip0(); subTask = 1;}
      else if (AcZ > -4000 && AcZ < 4000) {doStrip2(); subTask = 1;}
      break;
    case 1: 
      if (PlayEn < 1) {subTask = 0;}
      break;
  }
}

// ---------------------------------------------------------------------------------

void doModeTask5() {
  // Mode 5 - random pattern if moving
  int zEn = 5;
  switch(subTask) {
    case 0:
      if (abs(AcX - AcXL) > zEn) {zEn = 0;}
      else if (abs(AcY - AcYL) > zEn) {zEn = 0;}
      else if (abs(AcZ - AcZL) > zEn) {zEn = 0;}
      if (zEn < 1) {
        getRndCol(); subTask = 1 + random(7); patTask = 0; taskCnt1 = 2;
      } else {
        taskCnt1--;
        if (taskCnt1 >= 0) {getRndCol(); subTask = 1 + random(4);}
        if (taskCnt1 < 1) {taskCnt1 = 0;}
      }
      break;
    case 1: doPattern0(); break;
    case 2: doPattern1(); break;
    case 3: doPattern2(); break;
    case 4: doPattern3(); break;
    case 5: doPattern4(); break;
    case 6: doPattern5(); break;
    case 7: doStripRnd(); break;
    case 99:
      // come here when a pattern task has completed
      cls(); subTask = 0; break;
  } AcXL = AcX; AcYL = AcY; AcZL = AcZ; // record current acceleromter values
}

// ---------------------------------------------------------------------------------

void doModeTask6() {
  // Mode 6 - faster random colours if moving
  int zEn = 5;
  switch(subTask) {
    case 0:
      // test for movement and change speed accordingly
      if (abs(AcX - AcXL) > zEn) {zEn = 0;}
      else if (abs(AcY - AcYL) > zEn) {zEn = 0;}
      else if (abs(AcZ - AcZL) > zEn) {zEn = 0;}
      if (zEn < 1) {taskSpeed = 14; maxBright = 128; taskCnt1 = 10;}
      else {
        taskCnt1--;
        if (taskCnt1 >= 0) {maxBright = 5 + (10 * taskCnt1);}
        if (taskCnt1 < 1) {taskCnt1 = 0; taskSpeed = 1;}
      }
      maxBright2 = maxBright/2; maxBright3 = maxBright/3;
      subTask = 1; taskCnt0 = 25 - taskSpeed;
      doPatternRnd(); subTask = 99; break;
    case 99:
      // come here when a pattern task has completed
      taskCnt0--; if (taskCnt0 < 1) {subTask = 0;}
      break;
  } AcXL = AcX; AcYL = AcY; AcZL = AcZ; // record current acceleromter values
}

// ---------------------------------------------------------------------------------

void doModeTask7() {
  // test task for various functions
  switch(subTask) {
    case 0:
    //  Serial.print("AX="); Serial.print(AcX);
    //  Serial.print("  |  AY="); Serial.print(AcY);
    //  Serial.print("  |  AZ="); Serial.print(AcZ);
    //  Serial.print("\n");
      setColVal(0,0x000088); setColVal(1,0x000088); setColVal(2,0x000088);
      showColArray(0); subTask = 99; subTaskNxt = 1; taskDel0 = 10;
      break;
    case 1:
      setPixelOFF(); subTask = 99; subTaskNxt = 0; taskDel0 = 5; break;
    case 99:
      // delay task, counts down then goes to next subTask
      taskDel0--; if (taskDel0 < 1) {subTask = subTaskNxt;}
      break;
  }
}

// ---------------------------------------------------------------------------------

void doPattern0() {
  // move a dot left/right towards the centre
  patTaskFlg = 0; //reset temporary flag
  // Serial.println(patTask);
  switch(patTask) {
    case 0: clrArray(); setColVal(0,patCol0); patTaskPnt = 0; showColArray(patTaskPnt); break;
    case 1: patTaskPnt--; showColArray(patTaskPnt); break;
    case 2: patTaskPnt--; showColArray(patTaskPnt); break;
    case 3: patTaskPnt--; showColArray(patTaskPnt); break;
    case 4: patTaskPnt--; showColArray(patTaskPnt); break;
    case 5: patTaskPnt--; showColArray(patTaskPnt); break;
    case 6: patTaskPnt--; showColArray(patTaskPnt); break;
    case 7: patTaskPnt--; showColArray(patTaskPnt); break;
    case 8: patTaskPnt--; showColArray(patTaskPnt); break;
    case 9: patTaskPnt--; showColArray(patTaskPnt); break;
    case 10: patTaskPnt--; showColArray(patTaskPnt); break;
    case 11: patTaskPnt--; showColArray(patTaskPnt); break;
    case 12: patTaskPnt--; showColArray(patTaskPnt); break;
    case 13: patTaskPnt--; showColArray(patTaskPnt); break;
    case 14: patTaskPnt--; showColArray(patTaskPnt); break;
    case 15: patTaskPnt++; showColArray(patTaskPnt); break;
    case 16: patTaskPnt++; showColArray(patTaskPnt); break;
    case 17: patTaskPnt++; showColArray(patTaskPnt); break;
    case 18: patTaskPnt++; showColArray(patTaskPnt); break;
    case 19: patTaskPnt++; showColArray(patTaskPnt); break;
    case 20: patTaskPnt++; showColArray(patTaskPnt); break;
    case 21: patTaskPnt++; showColArray(patTaskPnt); break;
    case 22: patTaskPnt++; showColArray(patTaskPnt); break;
    case 23: patTaskPnt++; showColArray(patTaskPnt); break;
    case 24: patTaskPnt++; showColArray(patTaskPnt); break;
    case 25: patTaskPnt++; showColArray(patTaskPnt); break;
    case 26: patTaskPnt++; showColArray(patTaskPnt); break;
    case 27: patTaskPnt++; showColArray(patTaskPnt); break;
    case 28: patTaskPnt--; showColArray(patTaskPnt); break;
    case 29: patTaskPnt--; showColArray(patTaskPnt); break;
    case 30: patTaskPnt--; showColArray(patTaskPnt); break;
    case 31: patTaskPnt--; showColArray(patTaskPnt); break;
    case 32: patTaskPnt--; showColArray(patTaskPnt); break;
    case 33: patTaskPnt--; showColArray(patTaskPnt); break;
    case 34: patTaskPnt--; showColArray(patTaskPnt); break;
    case 35: patTaskPnt--; showColArray(patTaskPnt); break;
    case 36: patTaskPnt--; showColArray(patTaskPnt); break;
    case 37: patTaskPnt--; showColArray(patTaskPnt); break;
    case 38: patTaskPnt--; showColArray(patTaskPnt); break;
    case 39: patTaskPnt--; showColArray(patTaskPnt); break;
    case 40: patTaskPnt++; showColArray(patTaskPnt); break;
    case 41: patTaskPnt++; showColArray(patTaskPnt); break;
    case 42: patTaskPnt++; showColArray(patTaskPnt); break;
    case 43: patTaskPnt++; showColArray(patTaskPnt); break;
    case 44: patTaskPnt++; showColArray(patTaskPnt); break;
    case 45: patTaskPnt++; showColArray(patTaskPnt); break;
    case 46: patTaskPnt++; showColArray(patTaskPnt); break;
    case 47: patTaskPnt++; showColArray(patTaskPnt); break;
    case 48: patTaskPnt++; showColArray(patTaskPnt); break;
    case 49: patTaskPnt++; showColArray(patTaskPnt); break;
    case 50: patTaskPnt++; showColArray(patTaskPnt); break;
    case 51: patTaskPnt--; showColArray(patTaskPnt); break;
    case 52: patTaskPnt--; showColArray(patTaskPnt); break;
    case 53: patTaskPnt--; showColArray(patTaskPnt); break;
    case 54: patTaskPnt--; showColArray(patTaskPnt); break;
    case 55: patTaskPnt--; showColArray(patTaskPnt); break;
    case 56: patTaskPnt--; showColArray(patTaskPnt); break;
    case 57: patTaskPnt--; showColArray(patTaskPnt); break;
    case 58: patTaskPnt--; showColArray(patTaskPnt); break;
    case 59: patTaskPnt--; showColArray(patTaskPnt); break;
    case 60: patTaskPnt--; showColArray(patTaskPnt); break;
    case 61: patTaskPnt++; showColArray(patTaskPnt); break;
    case 62: patTaskPnt++; showColArray(patTaskPnt); break;
    case 63: patTaskPnt++; showColArray(patTaskPnt); break;
    case 64: patTaskPnt++; showColArray(patTaskPnt); break;
    case 65: patTaskPnt++; showColArray(patTaskPnt); break;
    case 66: patTaskPnt++; showColArray(patTaskPnt); break;
    case 67: patTaskPnt++; showColArray(patTaskPnt); break;
    case 68: patTaskPnt++; showColArray(patTaskPnt); break;
    case 69: patTaskPnt++; showColArray(patTaskPnt); break;
    case 70: patTaskPnt--; showColArray(patTaskPnt); break;
    case 71: patTaskPnt--; showColArray(patTaskPnt); break;
    case 72: patTaskPnt--; showColArray(patTaskPnt); break;
    case 73: patTaskPnt--; showColArray(patTaskPnt); break;
    case 74: patTaskPnt--; showColArray(patTaskPnt); break;
    case 75: patTaskPnt--; showColArray(patTaskPnt); break;
    case 76: patTaskPnt--; showColArray(patTaskPnt); break;
    case 77: patTaskPnt--; showColArray(patTaskPnt); break;
    case 78: patTaskPnt++; showColArray(patTaskPnt); break;
    case 79: patTaskPnt++; showColArray(patTaskPnt); break;
    case 80: patTaskPnt++; showColArray(patTaskPnt); break;
    case 81: patTaskPnt++; showColArray(patTaskPnt); break;
    case 82: patTaskPnt++; showColArray(patTaskPnt); break;
    case 83: patTaskPnt++; showColArray(patTaskPnt); break;
    case 84: patTaskPnt++; showColArray(patTaskPnt); break;
    case 85: patTaskPnt--; showColArray(patTaskPnt); break;
    case 86: patTaskPnt--; showColArray(patTaskPnt); break;
    case 87: patTaskPnt--; showColArray(patTaskPnt); break;
    case 88: patTaskPnt--; showColArray(patTaskPnt); break;
    case 89: patTaskPnt--; showColArray(patTaskPnt); break;
    case 90: patTaskPnt--; showColArray(patTaskPnt); break;
    case 91: patTaskPnt++; showColArray(patTaskPnt); break;
    case 92: patTaskPnt++; showColArray(patTaskPnt); break;
    case 93: patTaskPnt++; showColArray(patTaskPnt); break;
    case 94: patTaskPnt++; showColArray(patTaskPnt); break;
    case 95: patTaskPnt++; showColArray(patTaskPnt); break;
    case 96: patTaskPnt--; showColArray(patTaskPnt); break;
    case 97: patTaskPnt--; showColArray(patTaskPnt); break;
    case 98: patTaskPnt--; showColArray(patTaskPnt); break;
    case 99: patTaskPnt--; showColArray(patTaskPnt); break;
    case 100: patTaskPnt++; showColArray(patTaskPnt); break;
    case 101: patTaskPnt++; showColArray(patTaskPnt); break;
    case 102: patTaskPnt++; showColArray(patTaskPnt); break;
    case 103: patTaskPnt--; showColArray(patTaskPnt); break;
    case 104: setColVal(0,0xAAAAAA); showColArray(patTaskPnt); patTaskFlg = -1; break;
    case 999:
      // delay task, counts down then goes to next patTask
      patTaskFlg = 1; // effectively stall task switching
      taskDel0--; if (taskDel0 < 1) {patTask = patTaskNxt + 1; patTaskFlg = 2;}
      break;
  }
  switch(patTaskFlg) {
    // normal sequence is (n),0,(999),2,(n),0,(999),2,...-1,(999),2, end
    case -1: patTaskNxt = patTask; patTask = 999; taskDel0 = 10; break; // lonmg pause on last task
    case 0: patTaskNxt = patTask; patTask = 999; taskDel0 = 16 - taskSpeed; break; //
    case 2: if (patTask > 104) {patTask = 0; subTask = 99;}  // test for end of pattern sequence
      break;
  }
}

// ---------------------------------------------------------------------------------

void doPattern1() {
  // move a 3 dot paterns left
  patTaskFlg = 0; //reset temporary flag
  // Serial.println(patTask);
  switch(patTask) {
    case 0:
      loadColArray(patCol0,patCol0,patCol0,      0,      0,      0,patCol0,patCol0,patCol0,      0,      0,      0,      0,      0,      0,      0);
      break;
    case  1: RotColArrLft(); break;
    case  2: RotColArrLft(); break;
    case  3: RotColArrLft(); break;
    case  4: RotColArrLft(); break;
    case  5: RotColArrLft(); break;
    case  6: RotColArrLft(); break;
    case  7: RotColArrLft(); break;
    case  8: RotColArrLft(); break;
    case  9: RotColArrLft(); break;
    case 10: RotColArrLft(); break;
    case 11: RotColArrLft(); break;
    case 12: RotColArrLft(); break;
    case 13: RotColArrLft(); break;
    case 14: RotColArrLft(); break;
    case 15: RotColArrLft(); break;
    case 999:
      // delay task, counts down then goes to next patTask
      patTaskFlg = 1; // effectively stall task switching
      taskDel0--; if (taskDel0 < 1) {patTask = patTaskNxt + 1; patTaskFlg = 2;}
      break;
  }
  switch(patTaskFlg) {
    // normal sequence is (n),0,(999),2,(n),0,(999),2,...0,(999),2, end
    case 0:
      showColArray(0); // update LEDs
      patTaskNxt = patTask; patTask = 999; taskDel0 = 20 - taskSpeed; break;
    case 2: if (patTask > NumLEDs_2) {patTask = 0; subTask = 99;}  // end of pattern sequence
      break;
  }
}

// ---------------------------------------------------------------------------------

void doPattern2() {
  // move a dot patern towards the handle
  patTaskFlg = 0; //reset temporary flag
  // Serial.println(patTask);
  switch(patTask) {
    case 0:
      loadColArray(      0,      0,      0,patCol0,      0,      0,      0,patCol0,      0,      0,      0,patCol0,      0,      0,      0,patCol0);
      break;
    case  1: RotColArrRht(); break;
    case  2: RotColArrRht(); break;
    case  3: RotColArrRht(); break;
    case  4: RotColArrRht(); break;
    case  5: RotColArrRht(); break;
    case  6: RotColArrRht(); break;
    case  7: RotColArrRht(); break;
    case  8: RotColArrRht(); break;
    case  9: RotColArrRht(); break;
    case 10: RotColArrRht(); break;
    case 11: RotColArrRht(); break;
    case 12: RotColArrRht(); break;
    case 13: RotColArrRht(); break;
    case 14: RotColArrRht(); break;
    case 999:
      // delay task, counts down then goes to next patTask
      patTaskFlg = 1; // effectively stall task switching
      taskDel0--; if (taskDel0 < 1) {patTask = patTaskNxt + 1; patTaskFlg = 2;}
      break;
  }
  switch(patTaskFlg) {
    case 0:
      showColArray(0); // update LEDs
      patTaskNxt = patTask; patTask = 999; taskDel0 = 20 - taskSpeed; break;
    case 2: if (patTask > NumLEDs_2) {patTask = 0; subTask = 99;}  // end of pattern sequence
      break;
  }
}

// ---------------------------------------------------------------------------------

void doPattern3() {
  // dots emerge from centre and move outwards
  patTaskFlg = 0; //reset temporary flag
  // Serial.println(patTask);
  switch(patTask) {
    case  0: loadColArray(      0,      0,      0,      0,      0,      0,      0,patCol0,      0,      0,      0,      0,      0,      0,      0,      0); break;
    case  1: loadColArray(      0,      0,      0,      0,      0,      0,patCol0,patCol0,patCol0,      0,      0,      0,      0,      0,      0,      0); break;
    case  2: loadColArray(      0,      0,      0,      0,      0,patCol0,patCol0,      0,patCol0,patCol0,      0,      0,      0,      0,      0,      0); break;
    case  3: loadColArray(      0,      0,      0,      0,patCol0,patCol0,      0,patCol0,      0,patCol0,patCol0,      0,      0,      0,      0,      0); break;
    case  4: loadColArray(      0,      0,      0,patCol0,patCol0,      0,patCol0,patCol0,patCol0,      0,patCol0,patCol0,      0,      0,      0,      0); break;
    case  5: loadColArray(      0,      0,patCol0,patCol0,      0,patCol0,patCol0,      0,patCol0,patCol0,      0,patCol0,patCol0,      0,      0,      0); break;
    case  6: loadColArray(      0,patCol0,patCol0,      0,patCol0,patCol0,      0,patCol0,      0,patCol0,patCol0,      0,patCol0,patCol0,      0,      0); break;
    case  7: loadColArray(patCol0,patCol0,      0,patCol0,patCol0,      0,patCol0,patCol0,patCol0,      0,patCol0,patCol0,      0,patCol0,patCol0,      0); break;
    case  8: loadColArray(patCol0,      0,patCol0,patCol0,      0,patCol0,patCol0,      0,patCol0,patCol0,      0,patCol0,patCol0,      0,patCol0,      0); break;
    case  9: loadColArray(      0,patCol0,patCol0,      0,patCol0,patCol0,      0,      0,      0,patCol0,patCol0,      0,patCol0,patCol0,      0,      0); break;
    case 10: loadColArray(patCol0,patCol0,      0,patCol0,patCol0,      0,      0,      0,      0,      0,patCol0,patCol0,      0,patCol0,patCol0,      0); break;
    case 11: loadColArray(patCol0,      0,patCol0,patCol0,      0,      0,      0,      0,      0,      0,      0,patCol0,patCol0,      0,patCol0,      0); break;
    case 12: loadColArray(      0,patCol0,patCol0,      0,      0,      0,      0,      0,      0,      0,      0,      0,patCol0,patCol0,      0,      0); break;
    case 13: loadColArray(patCol0,patCol0,      0,      0,      0,      0,      0,      0,      0,      0,      0,      0,      0,patCol0,patCol0,      0); break;
    case 14: loadColArray(patCol0,      0,      0,      0,      0,      0,      0,      0,      0,      0,      0,      0,      0,      0,patCol0,      0); break;
    case 15: loadColArray(      0,      0,      0,      0,      0,      0,      0,      0,      0,      0,      0,      0,      0,      0,      0,      0); break;
    case 999:
      // delay task, counts down then goes to next patTask
      patTaskFlg = 1; // effectively stall task switching
      taskDel0--; if (taskDel0 < 1) {patTask = patTaskNxt + 1; patTaskFlg = 2;}
      break;
  }
  switch(patTaskFlg) {
    case 0:
      showColArray(0); // update LEDs
      patTaskNxt = patTask; patTask = 999; taskDel0 = 20 - taskSpeed; break;
    case 2: if (patTask > 15) {patTask = 0; subTask = 99;}  // end of pattern sequence
      break;
  }
}

// ---------------------------------------------------------------------------------

void doPattern4() {
  // dots emerge from edges and move inwards
  patTaskFlg = 0; //reset temporary flag
  // Serial.println(patTask);
  switch(patTask) {
    case  0: loadColArray(patCol0,      0,      0,      0,      0,      0,      0,      0,      0,      0,      0,      0,      0,      0,      0,patCol0); break;
    case  1: loadColArray(patCol0,patCol0,      0,      0,      0,      0,      0,      0,      0,      0,      0,      0,      0,      0,patCol0,patCol0); break;
    case  2: loadColArray(      0,patCol0,patCol0,      0,      0,      0,      0,      0,      0,      0,      0,      0,      0,patCol0,patCol0,      0); break;
    case  3: loadColArray(patCol0,      0,patCol0,patCol0,      0,      0,      0,      0,      0,      0,      0,      0,patCol0,patCol0,      0,patCol0); break;
    case  4: loadColArray(patCol0,patCol0,      0,patCol0,patCol0,      0,      0,      0,      0,      0,      0,patCol0,patCol0,      0,patCol0,patCol0); break;
    case  5: loadColArray(      0,patCol0,patCol0,      0,patCol0,patCol0,      0,      0,      0,      0,patCol0,patCol0,      0,patCol0,patCol0,      0); break;
    case  6: loadColArray(patCol0,      0,patCol0,patCol0,      0,patCol0,patCol0,      0,      0,patCol0,patCol0,      0,patCol0,patCol0,      0,patCol0); break;
    case  8: loadColArray(patCol0,patCol0,      0,patCol0,patCol0,      0,patCol0,patCol0,patCol0,patCol0,      0,patCol0,patCol0,      0,patCol0,patCol0); break;
    case  9: loadColArray(      0,patCol0,patCol0,      0,patCol0,patCol0,      0,patCol0,patCol0,      0,patCol0,patCol0,      0,patCol0,patCol0,      0); break;
    case 10: loadColArray(      0,      0,patCol0,patCol0,      0,patCol0,patCol0,      0,      0,patCol0,patCol0,      0,patCol0,patCol0,      0,      0); break;
    case 11: loadColArray(      0,      0,      0,patCol0,patCol0,      0,patCol0,patCol0,patCol0,patCol0,      0,patCol0,patCol0,      0,      0,      0); break;
    case 12: loadColArray(      0,      0,      0,      0,patCol0,patCol0,      0,patCol0,patCol0,      0,patCol0,patCol0,      0,      0,      0,      0); break;
    case 13: loadColArray(      0,      0,      0,      0,      0,patCol0,patCol0,      0,      0,patCol0,patCol0,      0,      0,      0,      0,      0); break;
    case 14: loadColArray(      0,      0,      0,      0,      0,      0,patCol0,patCol0,patCol0,patCol0,      0,      0,      0,      0,      0,      0); break;
    case 15: loadColArray(      0,      0,      0,      0,      0,      0,      0,patCol0,patCol0,      0,      0,      0,      0,      0,      0,      0); break;
    case 16: loadColArray(      0,      0,      0,      0,      0,      0,      0,      0,      0,      0,      0,      0,      0,      0,      0,      0); break;
    case 999:
      // delay task, counts down then goes to next patTask
      patTaskFlg = 1; // effectively stall task switching
      taskDel0--; if (taskDel0 < 1) {patTask = patTaskNxt + 1; patTaskFlg = 2;}
      break;
  }
  switch(patTaskFlg) {
    case 0:
      showColArray(0); // update LEDs
      patTaskNxt = patTask; patTask = 999; taskDel0 = 20 - taskSpeed; break;
    case 2: if (patTask > NumLEDs-1) {patTask = 0; subTask = 99;}  // end of pattern sequence
      break;
  }
}

// ---------------------------------------------------------------------------------

void doPattern5() {
  // dots emerge from handle and stack at end
  patTaskFlg = 0; //reset temporary flag
  // Serial.println(patTask);
  switch(patTask) {
    case 0:
      // initialise and plot 1st dot
      patTaskPnt = 0; clrArray(); patTask = 1; setColVal(patTaskPnt,patCol0);
      patTaskEnd = 15; break;
    case 1:
      // loop to move dot to end
      setColVal(patTaskPnt,0); patTaskPnt++;
      if (patTaskPnt <= patTaskEnd) {setColVal(patTaskPnt,patCol0);} 
      if (patTaskPnt == patTaskEnd) {patTaskEnd--; patTask = 2;} 
      break;
    case 2:
      // start next run or end
      if (patTaskEnd < 3) {
        // end point reached so force exit
        patTaskEnd = -1;
      } else {
        // end point not yet reached
        patTaskPnt = 0; patTask = 1; setColVal(patTaskPnt,patCol0);
      }
      break;
    case 999:
      // delay task, counts down then goes to next patTask
      patTaskFlg = 1; // effectively stall task switching
      taskDel0--; if (taskDel0 < 1) {patTask = patTaskNxt; patTaskFlg = 2;}
      break;
  }
  switch(patTaskFlg) {
    case 0:
      showColArray(0); // update LEDs
      patTaskNxt = patTask; patTask = 999; taskDel0 = 16 - taskSpeed; break;
    case 2:
      // return to pattern sequence
      patTaskFlg = 0; if (patTaskEnd < 0) {patTask = 0; subTask = 99;}  // end of pattern sequence
      break;
  }
}

// ---------------------------------------------------------------------------------

void doPatternRnd() {
  // set all 16 LEDs to a random colour
  int zLED; // choose LED at random
  int zCol; // choose colour at random
  for (zLED = 1; zLED < NumLEDs; zLED++) {
    zCol = random(8); // choose colour at random
    switch(zCol) {
      case 0: LED[zLED].setRGB(0,0,0); break;
      case 1: LED[zLED].setRGB(maxBright,0,0); break;
      case 2: LED[zLED].setRGB(maxBright2,maxBright2,0); break;
      case 3: LED[zLED].setRGB(0,maxBright,0); break;
      case 4: LED[zLED].setRGB(0,maxBright2,maxBright2); break;
      case 5: LED[zLED].setRGB(0,0,maxBright); break;
      case 6: LED[zLED].setRGB(maxBright2,0,maxBright2); break;
      case 7: LED[zLED].setRGB(maxBright3,maxBright3,maxBright3); break;
    }
  } 
  FastLED.show();
}

// ---------------------------------------------------------------------------------

void doStrip0() {
  // build a Red strip and Play it 
  switch(patTask) {
    case 0:
      loadColArray(0x110000,0x220000,0x330000,0x440000,0x550000,0x660000,0x880000,0xAA0000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000);
      PlayS = 8; PlayF = -17; PlayI = -1; PlayDel = 1; PlayEn = 1; patTask = 1; break;
    case 1:
      if (PlayEn < 1) {patTask = 0; subTask = 99;}
      break;
  }
}

// ---------------------------------------------------------------------------------

void doStrip1() {
  // build a Green strip and Play it 
  switch(patTask) {
    case 0:
      loadColArray(0x001100,0x002200,0x003300,0x004400,0x005500,0x006600,0x008800,0x00AA00,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000);
      PlayS = 8; PlayF = -17; PlayI = -1; PlayDel = 1; PlayEn = 1; patTask = 1; break;
    case 1:
      if (PlayEn < 1) {patTask = 0; subTask = 99;}
      break;
  }
}

// ---------------------------------------------------------------------------------

void doStrip2() {
  // build a Blue strip and Play it 
  switch(patTask) {
    case 0:
      loadColArray(0x000011,0x000022,0x000033,0x000044,0x000055,0x000066,0x000088,0x0000AA,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000);
      PlayS = 8; PlayF = -17; PlayI = -1; PlayDel = 1; PlayEn = 1; patTask = 1; break;
    case 1:
      if (PlayEn < 1) {patTask = 0; subTask = 99;}
      break;
  }
}

// ---------------------------------------------------------------------------------

void doStripRnd() {
  // build a coloured strip, based on a random colour and Play it 
  int zRnd = random(6);
  switch(patTask) {
    case 0:
      switch(zRnd) {
        case 0: loadColArray(0x110000,0x220000,0x330000,0x440000,0x550000,0x660000,0x880000,0xAA0000,0,0,0,0,0,0,0,0); break;
        case 1: loadColArray(0x001100,0x002200,0x003300,0x004400,0x005500,0x006600,0x008800,0x00AA00,0,0,0,0,0,0,0,0); break;
        case 2: loadColArray(0x000011,0x000022,0x000033,0x000044,0x000055,0x000066,0x000088,0x0000AA,0,0,0,0,0,0,0,0); break;
        case 3: loadColArray(0x060600,0x111100,0x161600,0x222200,0x282800,0x333300,0x444400,0x555500,0,0,0,0,0,0,0,0); break;
        case 4: loadColArray(0x000606,0x001111,0x001616,0x002222,0x002828,0x003333,0x004444,0x005555,0,0,0,0,0,0,0,0); break;
        case 5: loadColArray(0x060006,0x110011,0x160016,0x220022,0x280028,0x330033,0x440044,0x550055,0,0,0,0,0,0,0,0); break;
      }
      PlayS = 8; PlayF = -17; PlayI = -1; PlayDel = 1; PlayEn = 1; patTask = 1; break;
    case 1:
      if (PlayEn < 1) {patTask = 0; subTask = 99;}
      break;
  }
}

// ---------------------------------------------------------------------------------

void doTdmTask() {
  // called every 20ms when running in TDM mode  
 switch(mainMode) {
    case 0:
      // Mode 0 - default red handle beat
      doTdmTask0(); break;
 }
}

// ---------------------------------------------------------------------------------

void doTdmTask0() {
  // red handle beat using LED 0
  if (TDMcnt > 0) {TDMcnt--; TdmBeat = 0; TdmInc = 1; return;}
  
  TdmBeat+= TdmInc;
       if (TdmBeat < -10) {TdmInc= 5;}
  else if (TdmBeat >= 255) {TdmBeat = 255; TdmInc = -5;}
  FastLED.clear(); if (TdmBeat > 0) {LED[0].setRGB(TdmBeat,0,0);}
  FastLED.show();
}

// ---------------------------------------------------------------------------------

void playTask() {
  // play a moving sequence until end is reached
  switch(PlayEn) {
    case 1:
      // show and inc/dec pointer
      showColArray(PlayS); PlayS = PlayS + PlayI; PlayCnt = PlayDel; PlayEn = 2;
      break;
    case 2:
      PlayCnt--; if (PlayCnt < 1) {
        // delay timed out so check for end, repeat or exit
        PlayEn = 1; if (PlayS == PlayF) {PlayEn = 0;}
      } break;
  }
}

// ---------------------------------------------------------------------------------
