
// --------------------------------------------------------------------------------

void addFRAME(int16_t zP,int L0,int L1,int L2,int L3,int L4,int L5,int L6,int L7,int L8,int L9,int LA,int LB,int LC,int LD,int LE,int LF) {
  // loads the 16 LED rgb values into strip FRAME[zP], starting at zP
  FRAME[zP] = L0; zP++; FRAME[zP] = L1; zP++; FRAME[zP] = L2; zP++; FRAME[zP] = L3; zP++;
  FRAME[zP] = L4; zP++; FRAME[zP] = L5; zP++; FRAME[zP] = L6; zP++; FRAME[zP] = L7; zP++;
  FRAME[zP] = L8; zP++; FRAME[zP] = L9; zP++; FRAME[zP] = LA; zP++; FRAME[zP] = LB; zP++;
  FRAME[zP] = LC; zP++; FRAME[zP] = LD; zP++; FRAME[zP] = LE; zP++; FRAME[zP] = LF;
}

// --------------------------------------------------------------------------------

void calAccVals() {
  // converts the raw accelerometer values as -1 to 15  
  // AcX =   Yaw +ve to right, -ve to left
  // AcY = Pitch +ve nose up, -ve nose down
  // AcZ = Up/Dwn +ve upside down, -ve normal way up
  // Serial.print("\n");
  // reverse magnitudes and reduce readings to 128 max
  AcXV = abs((acc_1g - abs(AcX))/64);  // condition AcX
  AcYV = abs(AcY/64);  // condition AcY
  AcZV = abs((acc_1g - abs(AcZ))/64);  // condition AcZ
  // Serial.print("AcXV= "); Serial.print(AcXV);
  // Serial.print("  |  AcYV= "); Serial.print(AcYV);
  // Serial.print("  |  AcZV= "); Serial.print(AcZV);
  // Serial.print("\n");
  AcXV = 16 - ((abs(AcXV - 128) * 5)/27);
  AcZV = 16 - ((abs(AcZV - 128) * 5)/27);
  // factor in a reduction if tilting upwards significantly
  if (AcYV >= 24) {
    AcXV -= (((AcYV - 24) * 16)/40);
    AcZV -= (((AcYV - 24) * 16)/40);
  }
  if (AcXV < -1) {AcXV = -1;} else if (AcXV > 15) {AcXV = 15;} // constrain AcX
  if (AcZV < -1) {AcZV = -1;} else if (AcZV > 15) {AcZV = 15;} // constrain AcZ
  AcYV = 16 - ((abs(AcYV - 128) * 5)/20);
  if (AcYV < -1) {AcYV = -1;} else if (AcYV > 15) {AcYV = 15;} // constrain AcY
  // Serial.print("AcXV= "); Serial.print(AcXV);
  // Serial.print("  |  AcYV= "); Serial.print(AcYV);
  // Serial.print("  |  AcZV= "); Serial.print(AcZV);
  // Serial.print("\n");
}

// --------------------------------------------------------------------------------

void calcAngle() {
  // calculate the angle of rotation on the Z-axis using the Z gyro and either the
  // X-axis (if vertical) or Y-axis (if horizontal) accelerometers
  // accelerometer angle in TDM mode
  float zAng; // temporary accelerometer angle value
  if (Vertical) {
    // calculate angle for X axis using accelerometer value
         if (AcX > acc_1gF) {AcX = acc_1gF;}
    else if (AcX < -acc_1gF) {AcX = -acc_1gF;}
    if (AcY > 0) {
      // sword is pointing upwards
      zAng = asin((float)AcX/acc_1gF)* 57.296;
    } else {
      // sword is pointing downwards
      zAng = -asin((float)AcX/acc_1gF)* 57.296;
    }
  } else {
    // sword is horizontal
    // calculate angle for Y axis using accelerometer value
         if (AcY > acc_1gF) {AcY = acc_1gF;}
    else if (AcY < -acc_1gF) {AcY = -acc_1gF;}
    if (AcX < 0) {
       // Sword is pointing to the left (quarter too)
      zAng = asin((float)AcY/acc_1gF)* 57.296;
    } else {
       // Sword is pointing to the right (quarter past)
      zAng = -asin((float)AcY/acc_1gF)* 57.296;
    }
  }

  // determine Z gyro angle based on gyro rate o/p and sampling time
  // gyros are set at +/-250 deg/sec for 16-bit ADC = 32,767 FSD
  // to convert gyro value to deg/sec we divide reading by 131.068 (ie. 32,767/250)
  // gyros are set at +/-500 deg/sec for 16-bit ADC = 32,767 FSD
  // to convert gyro value to deg/sec we divide reading by 65.534 (ie. 32,767/500)
  // we have recorded time period in GyTD in microseconds, between readings
  // so angle is = GyAng * (GyTD/1000000)/65.534
  // in this case GyTD is nominally 5000 microseconds (ie. 5ms loop)
  // Serial.println(GyTD);
  float zDiv = (float)GyTD/65534000;      // nominally 0.0000305 at 5ms
  AngZ += ((float)GyZ * zDiv);            // Calculate the angle travelled during this 10ms loop and add this to the angle_gyro variable
  if (AngZ > 90.0) {AngZ = 90.0;}         // limit gyro swing
  else if (AngZ < -90.0) {AngZ = -90.0;}  // limit gyro swing
  // check for switching from one quadrant to the next
  if (VertLast != Vertical) {
    // quadrant transition
    AngZ = zAng;
    if (Vertical) {
      if (AcY > 0) {fillFRAME0();} else {fillFRAME4();}
    } else {
      if (AcX < 0) {fillFRAME1();} else {fillFRAME2();}
    }
  }
  VertLast = Vertical;

  // use a small amount of AngX to compensate for gyro Z drift errors
  AngZ -= ((AngZ - zAng) * 0.01);
  AngZI = (int)AngZ;

  // Serial.println(String(AcX) + "," + String(AcY));
  // Serial.println(String(AngX) + "," + String(AngZ));
  // Serial.println(String((int)zAng) + "," + String((int)AngZ));
}

// --------------------------------------------------------------------------------

void clrArray(){
  // sets all array colour values to 0
  for (int zP = 0; zP < NumLEDs; zP++) {colRed[zP] = 0; colGrn[zP] = 0; colBlu[zP] = 0;}
}

// --------------------------------------------------------------------------------

void cls(){
  // sets all array colour values to 0 and clear the display
  clrArray(); showColArray(0);
}

// ---------------------------------------------------------------------------------

void decodeKey(int zkeyVal) {
  // decodes zkeyVal and excutes commands on '.'
  // every time we receive a character set response to 10ms later, just in case
  // there is another packet behind it coming from the controller
  next40ms = millis() + 10;
  if (zkeyVal == 10) {return;}
  if (zkeyVal == 13) {return;}
  keyChar = char(zkeyVal);
  switch (keyChar) {
    case '.': doCmd(); return;                        // command terminator
    case '-': cmdSgn = -1; return;                    // numeric sign
    case '*': cmdMode = ' '; cmdType = ' '; cmdVal = 0; cmdSgn = 1; return; // ESC abort command
    case '0': extendCmdVal(0); return;
    case '1': extendCmdVal(1); return;
    case '2': extendCmdVal(2); return;
    case '3': extendCmdVal(3); return;
    case '4': extendCmdVal(4); return;
    case '5': extendCmdVal(5); return;
    case '6': extendCmdVal(6); return;
    case '7': extendCmdVal(7); return;
    case '8': extendCmdVal(8); return;
    case '9': extendCmdVal(9); return;
  }
  if (cmdMode == ' ') {
    // test for new Command Mode char?
    // only accept certain characters as valid commands, or ignore them
    // delay battery update by 10 seconds whilst receiving commands
    cmdMode = keyChar;
    switch (keyChar) {
      // check for valid mode and convert upper-case
      case 'j': cmdMode = 'J'; break;
    } cmdType = ' '; cmdVal = 0;
  } else {
    // test for Command Type char?
    cmdType = keyChar;
    switch (keyChar) {
      // check for lower-case and convert to upper-case
      case 'x': cmdType = 'X'; break;
      case 'y': cmdType = 'Y'; break;
    }
  }
}

// ---------------------------------------------------------------------------------

void doCmd() {
  // a '.' has been received on the serial port so execute command if valid
  // Commands:
  // JXnn.  - set global variable JX to nn
  // JYnn.  - set global variable JY to nn

  cmdVal*= cmdSgn;  // correct cmdVal with the sign value
  
  switch (cmdMode) {
    case ' ': break;
    case 'J':
      // commands used to set global variables in association with Joystick app
      switch (cmdType) {
        case 'X': // set global variable JX to cmdVal
          JX = cmdVal; //Serial.println("JX=" + String(JX));
          break;
        case 'Y': // set global variable JY to cmdVal
          JY = cmdVal; //Serial.println("JY=" + String(JY));
          break;
      } break;
    default:
      PrintTx += "Unknown cmd: " + cmdMode + cmdType + String(cmdVal) + "\n";
      break;
  }
  // now reset the variables
  cmdMode = ' '; cmdType = ' '; cmdVal = 0; cmdSgn = 1;
}

// ---------------------------------------------------------------------------------

void extendCmdVal(int zVal) {
  // adds a new digit to the right-hand end of cmdVal
  cmdVal = abs(cmdVal * 10) + zVal;
}

// --------------------------------------------------------------------------------

void fillFRAME0() {
  // loads a 16x16 image into the FRAME[] buffer
  Red = 0xFF0000; Blu = 0x0000FF;
  //            L0  L1  L2  L3  L4  L5  L6  L7  L8  L9 L10 L11 L12 L13 L14 L15
  addFRAME(  0,  0,  0,  0,  0,  0,  0,  0,  0,Red,  0,  0,  0,  0,  0,  0,  0);   
  addFRAME( 16,  0,  0,  0,  0,  0,  0,  0,Red,  0,Red,  0,  0,  0,  0,  0,  0);   
  addFRAME( 32,  0,  0,  0,  0,  0,  0,Red,  0,  0,  0,Red,  0,  0,  0,  0,  0);   
  addFRAME( 48,  0,  0,  0,  0,  0,Red,  0,  0,  0,  0,  0,Red,  0,  0,  0,  0);   
  addFRAME( 64,  0,  0,  0,  0,Red,  0,  0,  0,  0,  0,  0,  0,Red,  0,  0,  0);   
  addFRAME( 80,  0,  0,  0,Red,  0,  0,  0,  0,  0,  0,  0,  0,  0,Red,  0,  0);   
  addFRAME( 96,  0,  0,Red,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,Red,  0);   
  addFRAME(112,  0,Red,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,Red);   
  addFRAME(128,  0,Red,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,Red);   
  addFRAME(144,  0,  0,Red,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,Red,  0);   
  addFRAME(160,  0,  0,  0,Red,  0,  0,  0,  0,  0,  0,  0,  0,  0,Red,  0,  0);   
  addFRAME(176,  0,  0,  0,  0,Red,  0,  0,  0,  0,  0,  0,  0,Red,  0,  0,  0);   
  addFRAME(192,  0,  0,  0,  0,  0,Red,  0,  0,  0,  0,  0,Red,  0,  0,  0,  0);   
  addFRAME(208,  0,  0,  0,  0,  0,  0,Red,  0,  0,  0,Red,  0,  0,  0,  0,  0);   
  addFRAME(224,  0,  0,  0,  0,  0,  0,  0,Red,  0,Red,  0,  0,  0,  0,  0,  0);   
  addFRAME(240,  0,  0,  0,  0,  0,  0,  0,  0,Red,  0,  0,  0,  0,  0,  0,  0);   

  // addFRAME(  0,  0,  0,  0,  0,  0,  0,  0,  0,Red,  0,  0,  0,  0,  0,  0,  0);   
  // addFRAME( 16,  0,  0,  0,  0,  0,  0,  0,Red,  0,Red,  0,  0,  0,  0,  0,  0);   
  // addFRAME( 32,  0,  0,  0,  0,  0,  0,Red,  0,  0,  0,Red,  0,  0,  0,  0,  0);   
  // addFRAME( 48,  0,  0,  0,  0,  0,Red,  0,  0,Blu,  0,  0,Red,  0,  0,  0,  0);   
  // addFRAME( 64,  0,  0,  0,  0,Red,  0,  0,Blu,  0,Blu,  0,  0,Red,  0,  0,  0);   
  // addFRAME( 80,  0,  0,  0,Red,  0,  0,Blu,  0,  0,  0,Blu,  0,  0,Red,  0,  0);   
  // addFRAME( 96,  0,  0,Red,  0,  0,Blu,  0,  0,  0,  0,  0,Blu,  0,  0,Red,  0);   
  // addFRAME(112,  0,Red,  0,  0,Blu,  0,  0,  0,  0,  0,  0,  0,Blu,  0,  0,Red);   
  // addFRAME(128,  0,Blu,  0,  0,Red,  0,  0,  0,  0,  0,  0,  0,Red,  0,  0,Blu);   
  // addFRAME(144,  0,  0,Blu,  0,  0,Red,  0,  0,  0,  0,  0,Red,  0,  0,Blu,  0);   
  // addFRAME(160,  0,  0,  0,Blu,  0,  0,Red,  0,  0,  0,Red,  0,  0,Blu,  0,  0);   
  // addFRAME(176,  0,  0,  0,  0,Blu,  0,  0,Red,  0,Red,  0,  0,Blu,  0,  0,  0);   
  // addFRAME(192,  0,  0,  0,  0,  0,Blu,  0,  0,Red,  0,  0,Blu,  0,  0,  0,  0);   
  // addFRAME(208,  0,  0,  0,  0,  0,  0,Blu,  0,  0,  0,Blu,  0,  0,  0,  0,  0);   
  // addFRAME(224,  0,  0,  0,  0,  0,  0,  0,Blu,  0,Blu,  0,  0,  0,  0,  0,  0);   
  // addFRAME(240,  0,  0,  0,  0,  0,  0,  0,  0,Blu,  0,  0,  0,  0,  0,  0,  0);   
}

// --------------------------------------------------------------------------------

void fillFRAME1() {
  // loads a 16x16 image into the FRAME[] buffer
  Grn = 0x00FF00; Ylw = 0x888800;
  //            L0  L1  L2  L3  L4  L5  L6  L7  L8  L9 L10 L11 L12 L13 L14 L15
  addFRAME(  0,  0,  0,  0,  0,  0,  0,  0,  0,Grn,  0,  0,  0,  0,  0,  0,  0);   
  addFRAME( 16,  0,  0,  0,  0,  0,  0,  0,Grn,  0,Grn,  0,  0,  0,  0,  0,  0);   
  addFRAME( 32,  0,  0,  0,  0,  0,  0,Grn,  0,  0,  0,Grn,  0,  0,  0,  0,  0);   
  addFRAME( 48,  0,  0,  0,  0,  0,Grn,  0,  0,Ylw,  0,  0,Grn,  0,  0,  0,  0);   
  addFRAME( 64,  0,  0,  0,  0,Grn,  0,  0,  0,  0,  0,  0,  0,Grn,  0,  0,  0);   
  addFRAME( 80,  0,  0,  0,Grn,  0,  0,  0,  0,  0,  0,  0,  0,  0,Grn,  0,  0);   
  addFRAME( 96,  0,  0,Grn,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,Grn,  0);   
  addFRAME(112,  0,Grn,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,Grn);   
  addFRAME(128,  0,Grn,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,Grn);   
  addFRAME(144,  0,  0,Grn,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,Grn,  0);   
  addFRAME(160,  0,  0,  0,Grn,  0,  0,  0,  0,  0,  0,  0,  0,  0,Grn,  0,  0);   
  addFRAME(176,  0,  0,  0,  0,Grn,  0,  0,  0,  0,  0,  0,  0,Grn,  0,  0,  0);   
  addFRAME(192,  0,  0,  0,  0,  0,Grn,  0,  0,  0,  0,  0,Grn,  0,  0,  0,  0);   
  addFRAME(208,  0,  0,  0,  0,  0,  0,Grn,  0,  0,  0,Grn,  0,  0,  0,  0,  0);   
  addFRAME(224,  0,  0,  0,  0,  0,  0,  0,Grn,  0,Grn,  0,  0,  0,  0,  0,  0);   
  addFRAME(240,  0,  0,  0,  0,  0,  0,  0,  0,Grn,  0,  0,  0,  0,  0,  0,  0);   
}

// --------------------------------------------------------------------------------

void fillFRAME2() {
  // loads a 16x16 image into the FRAME[] buffer
  Cyn = 0x008888; Prl = 0x880088;
  //            L0  L1  L2  L3  L4  L5  L6  L7  L8  L9 L10 L11 L12 L13 L14 L15
  addFRAME(  0,  0,  0,  0,  0,  0,  0,  0,  0,Cyn,  0,  0,  0,  0,  0,  0,  0);   
  addFRAME( 16,  0,  0,  0,  0,  0,  0,  0,Cyn,  0,Cyn,  0,  0,  0,  0,  0,  0);   
  addFRAME( 32,  0,  0,  0,  0,  0,  0,Cyn,  0,  0,  0,Cyn,  0,  0,  0,  0,  0);   
  addFRAME( 48,  0,  0,  0,  0,  0,Cyn,  0,  0,  0,  0,  0,Cyn,  0,  0,  0,  0);   
  addFRAME( 64,  0,  0,  0,  0,Cyn,  0,  0,  0,  0,  0,  0,  0,Cyn,  0,  0,  0);   
  addFRAME( 80,  0,  0,  0,Cyn,  0,  0,  0,  0,  0,  0,  0,  0,  0,Cyn,  0,  0);   
  addFRAME( 96,  0,  0,Cyn,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,Cyn,  0);   
  addFRAME(112,  0,Cyn,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,Cyn);   
  addFRAME(128,  0,Cyn,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,Cyn);   
  addFRAME(144,  0,  0,Cyn,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,Cyn,  0);   
  addFRAME(160,  0,  0,  0,Cyn,  0,  0,  0,  0,  0,  0,  0,  0,  0,Cyn,  0,  0);   
  addFRAME(176,  0,  0,  0,  0,Cyn,  0,  0,  0,  0,  0,  0,  0,Cyn,  0,  0,  0);   
  addFRAME(192,  0,  0,  0,  0,  0,Cyn,  0,  0,  0,  0,  0,Cyn,  0,  0,  0,  0);   
  addFRAME(208,  0,  0,  0,  0,  0,  0,Cyn,  0,  0,  0,Cyn,  0,  0,  0,  0,  0);   
  addFRAME(224,  0,  0,  0,  0,  0,  0,  0,Cyn,  0,Cyn,  0,  0,  0,  0,  0,  0);   
  addFRAME(240,  0,  0,  0,  0,  0,  0,  0,  0,Cyn,  0,  0,  0,  0,  0,  0,  0);   
}

// --------------------------------------------------------------------------------

void fillFRAME4() {
  // loads a 16x16 image into the FRAME[] buffer
  Red = 0xFF0000; Blu = 0x0000FF;
  Grn = 0x00FF00; Ylw = 0x888800;
  Cyn = 0x008888; Prl = 0x880088;
  //            L0  L1  L2  L3  L4  L5  L6  L7  L8  L9 L10 L11 L12 L13 L14 L15
  addFRAME(  0,  0,  0,  0,  0,  0,  0,  0,  0,Blu,  0,  0,  0,  0,  0,  0,  0);   
  addFRAME( 16,  0,  0,  0,  0,  0,  0,  0,Blu,  0,Blu,  0,  0,  0,  0,  0,  0);   
  addFRAME( 32,  0,  0,  0,  0,  0,  0,Blu,  0,  0,  0,Blu,  0,  0,  0,  0,  0);   
  addFRAME( 48,  0,  0,  0,  0,  0,Blu,  0,  0,  0,  0,  0,Blu,  0,  0,  0,  0);   
  addFRAME( 64,  0,  0,  0,  0,Blu,  0,  0,  0,  0,  0,  0,  0,Blu,  0,  0,  0);   
  addFRAME( 80,  0,  0,  0,Blu,  0,  0,  0,  0,  0,  0,  0,  0,  0,Blu,  0,  0);   
  addFRAME( 96,  0,  0,Blu,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,Blu,  0);   
  addFRAME(112,  0,Blu,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,Blu);   
  addFRAME(128,  0,Blu,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,Blu);   
  addFRAME(144,  0,  0,Blu,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,Blu,  0);   
  addFRAME(160,  0,  0,  0,Blu,  0,  0,  0,  0,  0,  0,  0,  0,  0,Blu,  0,  0);   
  addFRAME(176,  0,  0,  0,  0,Blu,  0,  0,  0,  0,  0,  0,  0,Blu,  0,  0,  0);   
  addFRAME(192,  0,  0,  0,  0,  0,Blu,  0,  0,  0,  0,  0,Blu,  0,  0,  0,  0);   
  addFRAME(208,  0,  0,  0,  0,  0,  0,Blu,  0,  0,  0,Blu,  0,  0,  0,  0,  0);   
  addFRAME(224,  0,  0,  0,  0,  0,  0,  0,Blu,  0,Blu,  0,  0,  0,  0,  0,  0);   
  addFRAME(240,  0,  0,  0,  0,  0,  0,  0,  0,Blu,  0,  0,  0,  0,  0,  0,  0);   
}

// --------------------------------------------------------------------------------

void getRndCol() {
  // generate a random colour for patCol0
  int zCol = random(7); // choose colour at random
  long zmaxBright = maxBright;
  long zmaxBright2 = maxBright2;
  long zmaxBright3 = maxBright3;
  switch(zCol) {
    case 0: patCol0 = zmaxBright<<16; break;
    case 1: patCol0 = (zmaxBright2<<16) + (zmaxBright2<<8); break;
    case 2: patCol0 = (zmaxBright<<8); break;
    case 3: patCol0 = (zmaxBright2<<8) + zmaxBright2; break;
    case 4: patCol0 = zmaxBright; break;
    case 5: patCol0 = (zmaxBright2<<16) + zmaxBright2; break;
    case 6: patCol0 = (zmaxBright3<<16) + (zmaxBright3<<8) + zmaxBright3; break;
  }
}

// --------------------------------------------------------------------------------

void loadColArray(long zC0,long zC1,long zC2,long zC3,long zC4,long zC5,long zC6,long zC7,long zC8,long zC9,long zC10,long zC11,long zC12,long zC13,long zC14,long zC15) {
  // loads 16 hexadecimal colours into the colour array
  colBlu[0] = zC0 & 0xFF; colGrn[0] = (zC0>>8) & 0xFF; colRed[0] = (zC0>>16) & 0xFF;
  colBlu[1] = zC1 & 0xFF; colGrn[1] = (zC1>>8) & 0xFF; colRed[1] = (zC1>>16) & 0xFF;
  colBlu[2] = zC2 & 0xFF; colGrn[2] = (zC2>>8) & 0xFF; colRed[2] = (zC2>>16) & 0xFF;
  colBlu[3] = zC3 & 0xFF; colGrn[3] = (zC3>>8) & 0xFF; colRed[3] = (zC3>>16) & 0xFF;
  colBlu[4] = zC4 & 0xFF; colGrn[4] = (zC4>>8) & 0xFF; colRed[4] = (zC4>>16) & 0xFF;
  colBlu[5] = zC5 & 0xFF; colGrn[5] = (zC5>>8) & 0xFF; colRed[5] = (zC5>>16) & 0xFF;
  colBlu[6] = zC6 & 0xFF; colGrn[6] = (zC6>>8) & 0xFF; colRed[6] = (zC6>>16) & 0xFF;
  colBlu[7] = zC7 & 0xFF; colGrn[7] = (zC7>>8) & 0xFF; colRed[7] = (zC7>>16) & 0xFF;
  colBlu[8] = zC8 & 0xFF; colGrn[8] = (zC8>>8) & 0xFF; colRed[8] = (zC8>>16) & 0xFF;
  colBlu[9] = zC9 & 0xFF; colGrn[9] = (zC9>>8) & 0xFF; colRed[9] = (zC9>>16) & 0xFF;
  colBlu[10] = zC10 & 0xFF; colGrn[10] = (zC10>>8) & 0xFF; colRed[10] = (zC10>>16) & 0xFF;
  colBlu[11] = zC11 & 0xFF; colGrn[11] = (zC11>>8) & 0xFF; colRed[11] = (zC11>>16) & 0xFF;
  colBlu[12] = zC12 & 0xFF; colGrn[12] = (zC12>>8) & 0xFF; colRed[12] = (zC12>>16) & 0xFF;
  colBlu[13] = zC13 & 0xFF; colGrn[13] = (zC13>>8) & 0xFF; colRed[13] = (zC13>>16) & 0xFF;
  colBlu[14] = zC14 & 0xFF; colGrn[14] = (zC14>>8) & 0xFF; colRed[14] = (zC14>>16) & 0xFF;
  colBlu[15] = zC15 & 0xFF; colGrn[15] = (zC15>>8) & 0xFF; colRed[15] = (zC15>>16) & 0xFF;
}

// --------------------------------------------------------------------------------

void loadFRAME() {
  // loads a strip from the FRAME[] buffer into LED[] when the angle changes
  // the FRAME[] buffer is 16 pixels wide, centre angle 0 degrees is column 8
  // spread a pixel over 3 degrees of movement
  if (AngZI == AngL) {return;}
  
  int zAngZ = (AngZI/3) + 7;
  if (LEDclr) {FastLED.clear(); LEDclr = false; LEDshw = true;}
  if ((zAngZ >= 0) && (zAngZ <= 15)) {
    // we are in the correct range so copy in the 16 LEDs
    // patterns are stored as strips of 16 LEDs in FRAME{}
    int zP = zAngZ * 16;  // points to the correct strip
    // the LEDs range from 1 - 16, as LED 0 is the level shifter
    // copy the strip into the output buffer
    for (Any = 1;Any <= 16;Any++) {
      LED[Any] = FRAME[zP]; zP++;
    } LEDshw = true; LEDclr = true;
  }
  if (LEDshw) {FastLED.show(); LEDshw = false; TDMcnt = 50;}
}

// --------------------------------------------------------------------------------

void MPU_6050_Initialise() {
  // set up gyro hardware
  // By default the MPU-6050 sleeps. So we have to wake it up.
  Wire.beginTransmission(MPU_address);  // Start communication with the address found during search.
  Wire.write(0x6B);                     // We want to write to the PWR_MGMT_1 register (6B hex)
  Wire.write(0x00);                     // Set the register bits as 00000000 to activate the gyro
  I2CErr = Wire.endTransmission();      // End the transmission with the MPU.
  if (I2CErr != 0) {return;}
  delayMicroseconds(I2Cdel);                // Allow MPU time to respond

  //Set the full scale of the gyro to +/- 250 degrees per second
  Wire.beginTransmission(MPU_address);  // Start communication with the address found during search.
  Wire.write(0x1B);                     // We want to write to the GYRO_CONFIG register (1B hex)
  Wire.write(0x00);                     // Set the register bits as 00000000 (250dps full scale)
  I2CErr = Wire.endTransmission();      // End the transmission with the MPU.
  if (I2CErr != 0) {return;}
  delayMicroseconds(I2Cdel);                // Allow MPU time to respond

  //Set the full scale of the accelerometer to +/- 4g.
  Wire.beginTransmission(MPU_address);  // Start communication with the address found during search.
  Wire.write(0x1C);                     // We want to write to the ACCEL_CONFIG register (1A hex)
  //  Wire.write(0x00);                 // Set the register bits as 00000000 (+/- 2g full scale range)
  Wire.write(0x08);                     // Set the register bits as 00001000 (+/- 4g full scale range)
  I2CErr = Wire.endTransmission();      // End the transmission with the MPU.
  if (I2CErr != 0) {return;}
  delayMicroseconds(I2Cdel);                // Allow MPU time to respond

  //Set some filtering to improve the raw data.
  Wire.beginTransmission(MPU_address);  // Start communication with the address found during search
  Wire.write(0x1A);                     // We want to write to the CONFIG register (1A hex)
  Wire.write(0x03);                     // Set the register bits as 00000011 (Set Digital Low Pass Filter to ~43Hz)
  I2CErr = Wire.endTransmission();      // End the transmission with the MPU.
  if (I2CErr != 0) {return;}
  delayMicroseconds(I2Cdel);                // Allow MPU time to respond
}

// --------------------------------------------------------------------------------

void readAccelAll() {
  // read the X,Y,Z-axis acceleration values from the MPU
  // AcX =   Yaw +ve to right, -ve to left
  // AcY = Pitch +ve nose up, -ve nose down
  // AcX = Up/Dwn +ve upside down, -ve normal way up
  Wire.beginTransmission(MPU_address);
  Wire.write(0x3B);  // starting with register 0x3B (ACCEL_XOUT_H)
  I2CErr = Wire.endTransmission();    // End the transmission with the MPU.
  if (I2CErr != 0) {return;}          // abort on errors
  delayMicroseconds(I2Cdel);          // Allow MPU time to respond

  Wire.requestFrom(MPU_address,6);  // request 6 register read
  AcX = Wire.read()<<8|Wire.read();  // 0x3B (ACCEL_XOUT_H) & 0x3C (ACCEL_XOUT_L)
  AcY = Wire.read()<<8|Wire.read();  // 0x3D (ACCEL_YOUT_H) & 0x3E (ACCEL_YOUT_L)
  AcZ = Wire.read()<<8|Wire.read();  // 0x3F (ACCEL_ZOUT_H) & 0x40 (ACCEL_ZOUT_L)

  if (!TEST) {
    // in normal mode we subtract the offsets determined in TEST = true mode
    AcX-= AcXOff; AcY-= AcYOff; AcZ-= AcZOff;
  }
  // set vertical flag if sword is > 60 degrees
  // clear vertical flag if sword is < 30 degrees
  // Serial.print("AcY= "); Serial.println(AcY);
  if (!Vertical) {if (abs(AcY) > 6900) {Vertical = true;}}
  else if (abs(AcY) < 3600) {Vertical = false;}
  // Serial.print("AX="); Serial.print(AcX);
  // Serial.print("  |  AY="); Serial.print(AcY);
  // Serial.print("  |  AZ="); Serial.println(AcZ);
}

// --------------------------------------------------------------------------------

void readAccelX() {
  // read the X-axis acceleration value from the MPU
  Wire.beginTransmission(MPU_address);
  Wire.write(0x3B);                   // starting with register 0x3B (ACCEL_XOUT_H)
  I2CErr = Wire.endTransmission();    // End the transmission with the MPU.
  if (I2CErr != 0) {return;}          // abort on errors
  delayMicroseconds(I2Cdel);          // Allow MPU time to respond

  Wire.requestFrom(MPU_address,2);       // request 1 register read
  AcX=Wire.read()<<8|Wire.read();     // 0x3B (ACCEL_XOUT_H) & 0x3C (ACCEL_XOUT_L)
  AcX=abs((16384 - AcX)/128);         // condition AcX
}

// --------------------------------------------------------------------------------

void readAccelY() {
  // read the Y-axis acceleration value from the MPU
  Wire.beginTransmission(MPU_address);
  Wire.write(0x3D);  // starting with register 0x3D (ACCEL_YOUT_H)
  I2CErr = Wire.endTransmission();    // End the transmission with the MPU.
  if (I2CErr != 0) {return;}          // abort on errors
  delayMicroseconds(I2Cdel);          // Allow MPU time to respond

  Wire.requestFrom(MPU_address,2);  // request 1 register read
  AcY=Wire.read()<<8|Wire.read();  // 0x3D (ACCEL_YOUT_H) & 0x3E (ACCEL_YOUT_L)
  AcY=abs((16384 - AcY)/128);  // condition AcY
}

// --------------------------------------------------------------------------------

void readAccelZ() {
  // read the Z-axis acceleration value from the MPU
  Wire.beginTransmission(MPU_address);
  Wire.write(0x3F);  // starting with register 0x3F (ACCEL_ZOUT_H)
  I2CErr = Wire.endTransmission();    // End the transmission with the MPU.
  if (I2CErr != 0) {return;}          // abort on errors
  delayMicroseconds(I2Cdel);          // Allow MPU time to respond

  Wire.requestFrom(MPU_address,2);  // request 1 register read
  AcZ=Wire.read()<<8|Wire.read();  // 0x3F (ACCEL_ZOUT_H) & 0x40 (ACCEL_ZOUT_L)
  AcZ=abs((16384 - AcZ)/128);  // condition AcZ
}

// --------------------------------------------------------------------------------

void readGyroZ() {
  // read the Z-axis gyro to determine rotation of vertical sword  
  Wire.beginTransmission(MPU_address);     //Start communication with the gyro
  Wire.write(0x47);                     //Start reading the register GYRO_XOUT_H
  I2CErr = Wire.endTransmission();    // End the transmission with the MPU.
  if (I2CErr != 0) {return;}          // abort on errors
  delayMicroseconds(I2Cdel);          // Allow MPU time to respond

  Wire.requestFrom(MPU_address, 2);   // Request 2 bytes from the MPU
  
  GyZ = Wire.read()<<8|Wire.read();     //Combine the two bytes to make one integer

  // determine intermeasurement time for increased precision
  if (GyT > 0) {
    GyTD = micros() - GyT;  // get the differential time between readings
    GyT = GyTD + GyT;       // set the timer for the next reading
  } else {
    // 1st reading after reset
    GyT = micros();
    GyTD = 4000;
  }

  if (!TEST) {
    // in normal mode we subtract the offsets determined in TEST = true mode
    GyZ-= GyZOff;
  }
}

// --------------------------------------------------------------------------------

void readSerial() {
  // reads characters from the serial port and responds to commands
  // set PrintTgt to indicate source as serial port for responses
  keyVal = Serial.read();
  if (keyVal != -1) {SerialRx = true; PrintTgt = 0; decodeKey(keyVal);}
}

// ---------------------------------------------------------------------------------

void readSW0() {
  // read the left button switch and respond accordingly, pressed == LOW
  // a button press will automatical drop the current task
  // SW0 is read every 10ms (100Hz) to debounce
  // SW0 was known as the UpSwitch in the earlier wooden version
  sw0State = digitalRead(sw0Pin); // record button state
  if (sw0_Nop) {return;}          // block this function whilst == true
  
  if (sw0State == LOW) {
    //##############################################################################
    //
    // SW0 button is pressed down
    //
    //##############################################################################
    if (sw0Wup) {return;}
    
    if (sw0LastState == HIGH) {
      // SW0 has just been pressed down
      // Serial.println("SW0 Hi-LO");
      if (TEST) {Serial.println("SW0 Hi-LO");}
      sw0DwnTime = 0; // restart button down time counter
      sw0Cnt++;       // count on the falling edge
      sw0Timer = 0;   // reset the timer
      // indicate current speed as an LED bar graph
      if (TDM) {setMainMode(0);}  // drop out of TDM mode
      ModeEn = false; setPixelOFF(); clrArray();
      if (taskSpeed < 16) {taskSpeed++;}
      for (int zP=1; zP<=taskSpeed; zP++) {setPixiCol(zP,150,0,0);}
    } else {
      // whilst the button is down adjust the timer at 10ms steps
      // if Wii is not connected test for a long press to invoke demo mode
      sw0DwnTime++; // track button pressed time
      if (sw0Timer > 50) {
        // button SW0 held down for > 0.5 second
        // block further actions until released
        sw0Cnt = 0; sw0Timer = 0; sw0Wup = true;
      }
    }
  } else {
    //##############################################################################
    //
    // SW0 button is released
    //
    //##############################################################################
    if (sw0Wup) {
      // waited for button release
      sw0Wup = false; sw0Cnt = 0; sw0Timer = 0;
    } else {
      if (sw0LastState == LOW) {
        // SW0 has just been released
        // Serial.println("SW0 Lo-Hi");
        if (TEST) {Serial.println("SW0 Lo-Hi");}
      } else {
        if (sw0Timer > 50) {
          // button released for 1 sec so assume valid button counts
        //    Serial.print(F("swCnt = ")); Serial.println(swCnt);
          setPixelOFF(); ModeEn = true;
          sw0Cnt = 0; sw0Timer = 0;
        }
        sw0DwnTime = 0;
      }
    }
  }
  sw0LastState = sw0State; // record current state
  if (sw0Cnt > 0) {sw0Timer++;}
}

// ---------------------------------------------------------------------------------

void readSW1() {
  // read the middle button switch and respond accordingly, pressed == LOW
  // a button press will automatical drop the current task
  // SW1 is read every 10ms (100Hz) to debounce
  sw1State = digitalRead(sw1Pin); // record button state
  if (sw1_Nop) {return;}          // block this function whilst == true
  
  if (sw1State == LOW) {
    //##############################################################################
    //
    // SW0 button is pressed down
    //
    //##############################################################################
    if (sw1Wup) {return;}
    
    if (sw1LastState == HIGH) {
      // SW0 has just been pressed down
      // Serial.println("SW1 Hi-LO");
      if (TEST) {Serial.println("SW1 Hi-LO");}
      sw1DwnTime = 0; // restart button down time counter
      sw1Cnt++;       // count on the falling edge
      sw1Timer = 0;   // reset the timer
      ModeEn = false; TDM = false; setPixelOFF(); clrArray(); // stop other tasks
      // display count in binary
      // note that LED 1 is LSB, level shifter is ignored
           if (sw1Cnt == 1) {setPixiCol(1,80,0,0); setPixiCol(2, 0,0,0); setPixiCol(3, 0,0,0);}
      else if (sw1Cnt == 2) {setPixiCol(1, 0,0,0); setPixiCol(2,80,0,0); setPixiCol(3, 0,0,0);}
      else if (sw1Cnt == 3) {setPixiCol(1,80,0,0); setPixiCol(2,80,0,0); setPixiCol(3, 0,0,0);}
      else if (sw1Cnt == 4) {setPixiCol(1, 0,0,0); setPixiCol(2, 0,0,0); setPixiCol(3,80,0,0);}
      else if (sw1Cnt == 5) {setPixiCol(1,80,0,0); setPixiCol(2, 0,0,0); setPixiCol(3,80,0,0);}
      else if (sw1Cnt == 6) {setPixiCol(1, 0,0,0); setPixiCol(2,80,0,0); setPixiCol(3,80,0,0);}
      else if (sw1Cnt == 7) {setPixiCol(1,80,0,0); setPixiCol(2,80,0,0); setPixiCol(3,80,0,0);}
      else if (sw1Cnt >  7) {setPixelOFF(); sw1Cnt = 0;}
    } else {
      // whilst the button is down adjust the timer at 10ms steps
      // if Wii is not connected test for a long press to invoke demo mode
      sw1DwnTime++; // track button pressed time
      if (sw1Timer >= 150) {
        // button SW1 held down for > 1.5 second, so switch off LED activity for now
        setMainMode(80); setPixelOFF();
        // block further actions until released
        sw1Cnt = 0; sw1Timer = 0; sw1Wup = true;
      }
    }
  } else {
    //##############################################################################
    //
    // SW1 button is released
    //
    //##############################################################################
    if (sw1Wup) {
      // waited for button release
      sw1Wup = false; sw1Cnt = 0; sw1Timer = 0;
    } else {
      if (sw1LastState == LOW) {
        // SW1 has just been released
        // Serial.println("SW1 Lo-Hi");
        if (TEST) {Serial.println("SW1 Lo-Hi");}
      } else {
        if (sw1Timer > 100) {
          // button released for 1.5 sec so assume valid button counts
        //    Serial.print(F("swCnt = ")); Serial.println(swCnt);
          if (Vertical) {SetTdmMode(0);}  // set TDM mode
          else {setMainMode(sw1Cnt);}     // set normal mode task
          setPixelOFF();
          sw1Cnt = 0; sw1Timer = 0;
        }
        sw1DwnTime = 0;
      }
    }
  }
  sw1LastState = sw1State; // record current state
  if (sw1Cnt > 0) {sw1Timer++;}
}

// ---------------------------------------------------------------------------------

void readSW2() {
  // read the right button switch and respond accordingly, pressed == LOW
  // a button press will automatical drop the current task
  // SW2 is read every 10ms (100Hz) to debounce
  // SW2 was known as the DwnSwitch in the earlier wooden version
  sw2State = digitalRead(sw2Pin); // record button state
  if (sw2_Nop) {return;}          // block this function whilst == true
  
  if (sw2State == LOW) {
    //##############################################################################
    //
    // SW2 button is pressed down
    //
    //##############################################################################
    if (sw2Wup) {return;}
    
    if (sw2LastState == HIGH) {
      // SW2 has just been pressed down
      // Serial.println("SW2 Hi-LO");
      if (TEST) {Serial.println("SW2 Hi-LO");}
      sw2DwnTime = 0; // restart button down time counter
      sw2Cnt++;       // count on the falling edge
      sw2Timer = 0;   // reset the timer
      // indicate current speed as an LED bar graph
      if (TDM) {setMainMode(0);}  // drop out of TDM mode
      ModeEn = false; setPixelOFF(); clrArray();
      if (taskSpeed > 1) {taskSpeed--;}
      for (int zP=1; zP<=taskSpeed; zP++) {setPixiCol(zP,150,0,0);}
    } else {
      // whilst the button is down adjust the timer at 10ms steps
      // if Wii is not connected test for a long press to invoke demo mode
      sw2DwnTime++; // track button pressed time
      if (sw2Timer > 50) {
        // button SW2 held down for > 0.5 second
        sw2Cnt = 0; sw2Timer = 0; sw2Wup = true;
      }
    }
  } else {
    //##############################################################################
    //
    // SW2 button is released
    //
    //##############################################################################
    if (sw2Wup) {
      // waited for button release
      sw2Wup = false; sw2Cnt = 0; sw2Timer = 0;
    } else {
      if (sw2LastState == LOW) {
        // SW2 has just been released
        // Serial.println("SW2 Lo-Hi");
        if (TEST) {Serial.println("SW2 Lo-Hi");}
      } else {
        if (sw2Timer > 50) {
          // button released for 1 sec so assume valid button counts
        //    Serial.print(F("swCnt = ")); Serial.println(swCnt);
          if (TEST && (sw2Cnt > 0)) {
            // single button press during test mode
          }
          setPixelOFF(); ModeEn = true;
          sw2Cnt = 0; sw2Timer = 0;
        }
        sw2DwnTime = 0;
      }
    }
  }
  sw2LastState = sw2State; // record current state
  if (sw2Cnt > 0) {sw2Timer++;}
}

// ---------------------------------------------------------------------------------

void RotColArrLft() {
  // rotate the contents of the colour array towards the sword point
  int zPP;
  uint8_t zR = colRed[NumLEDs_2]; uint8_t zG = colGrn[NumLEDs_2]; uint8_t zB = colBlu[NumLEDs_2];
  for (int zP = NumLEDs_2; zP > 0; zP--) {
    zPP = zP-1; colRed[zP] = colRed[zPP]; colGrn[zP] = colGrn[zPP]; colBlu[zP] = colBlu[zPP];
  } colRed[0] = zR; colGrn[0] = zG; colBlu[0] = zB;
}

// ---------------------------------------------------------------------------------

void RotColArrRht() {
  // rotate the contents of the colour array towards the sword handle
  int zPP;
  uint8_t zR = colRed[0]; uint8_t zG = colGrn[0]; uint8_t zB = colBlu[0];
  for (int zP = 0; zP < NumLEDs_2; zP++) {
    zPP = zP+1; colRed[zP] = colRed[zPP]; colGrn[zP] = colGrn[zPP]; colBlu[zP] = colBlu[zPP];
  } colRed[NumLEDs_2] = zR; colGrn[NumLEDs_2] = zG; colBlu[NumLEDs_2] = zB;
}

// ---------------------------------------------------------------------------------

void setColVal(int zP,long zC) {
  // set an array point zP to a specific Hex value zC
  colBlu[zP] = zC & 0xFF; colGrn[zP] = (zC>>8) & 0xFF; colRed[zP] = (zC>>16) & 0xFF;
}

// ---------------------------------------------------------------------------------

void setMainMode(int zMode) {
  // called to set starting conditions for a specific mode
  patTask = 0;  // any pattern task pointer
  PlayEn = 0;   // turn off play mode
  subTask = 0;  // sub task pointer used in everey mode
  TdmBeat = 0;  // TDM mode LED[0] red value
  TdmInc = 1;   // increment used in TDM tasks
  TDM = false;  // set TDM flag OFF
  
  switch(zMode) {
    case 0:
      // Mode 0 - default random pattern
      maxBright = 10; maxBright2 = maxBright/2; maxBright3 = maxBright/3;
      swEn = 1; taskCnt1 = 1; taskInc0 = 10; taskSpeed = 1;
      break;
    case 1:
      // Mode 1 - fixed pattern sequnce
      maxBright = 128; maxBright2 = maxBright/2; maxBright3 = maxBright/3;
      swEn = 1; taskSpeed = 15;
      break;
    case 2:
      // Mode 2 - random patterns and speeds
      maxBright = 128; maxBright2 = maxBright/2; maxBright3 = maxBright/3;
      swEn = 1; taskSpeed = 15;
      break;
    case 3:
      // Mode 3 - accelerometer bars X,Y,Z
      maxBright = 128; maxBright2 = maxBright/2; maxBright3 = maxBright/3;
      swEn = 0; taskCnt1 = 1; taskInc0 = 10; taskSpeed = 1;
      break;
    case 4:
      // Mode 4 - accelerometer moving stripes
      maxBright = 10; maxBright2 = maxBright/2; maxBright3 = maxBright/3;
      swEn = 1; taskCnt1 = 1; taskInc0 = 10; taskSpeed = 15;
      break;
    case 5:
      // Mode 5 - random fixed pattern if moving
      maxBright = 128; maxBright2 = maxBright/2; maxBright3 = maxBright/3;
      swEn = 1; taskSpeed = 15;
      break;
    case 6:
      // Mode 6 - faster random colours if moving
      maxBright = 10; maxBright2 = maxBright/2; maxBright3 = maxBright/3;
      subTask = 99; swEn = 1; taskCnt0 = 50; taskSpeed = 15;
      break;
    case 7:
      // Mode 7 - test tasks
      subTask = 0; break;
  }
  mainMode = zMode; subTask = 0; ModeEn = true;
  Serial.println("setMainMode(" + String(mainMode) + ")");
}

// ---------------------------------------------------------------------------------

void setPixelBlu(int zP,uint8_t zVal) {
  // set the pixel zP Blue colour to zVal
  colRed[zP] = 0; colGrn[zP] = 0; colBlu[zP] = zVal;
  LED[zP].setRGB(colRed[zP], colGrn[zP], colBlu[zP]);
  FastLED.show();
}

// ---------------------------------------------------------------------------------

void setPixelGrn(int zP,uint8_t zVal) {
  // set the pixel zP Green colour to zVal
  colRed[zP] = 0; colGrn[zP] = zVal; colBlu[zP] = 0;
  LED[zP].setRGB(colRed[zP], colGrn[zP], colBlu[zP]);
  FastLED.show();
}

// ---------------------------------------------------------------------------------

void setPixelOFF(){
  // turns OFF all LED values
  for (int zP = 0; zP < NumLEDs; zP++) {LED[zP].setRGB(0,0,0);}
  FastLED.show();
}

// ---------------------------------------------------------------------------------

void setPixelRed(int zP,uint8_t zVal) {
  // set the pixel zP Red colour to zVal
  colRed[zP] = zVal; colGrn[zP] = 0; colBlu[zP] = 0;
  LED[zP].setRGB(colRed[zP], colGrn[zP], colBlu[zP]);
  FastLED.show();
}

// ---------------------------------------------------------------------------------

void setPixiCol(int zP, uint8_t zRed, uint8_t zGrn, uint8_t zBlu) {
  // set the pixel zP colour values and the array
  colRed[zP] = zRed; colGrn[zP] = zGrn; colBlu[zP] = zBlu;
  LED[zP].setRGB(colRed[zP], colGrn[zP], colBlu[zP]);
  FastLED.show();
}

// ---------------------------------------------------------------------------------

void SetTdmMode(int zMode) {
  // sets TDM main task and flags
  ModeEn  = false;  // disable normal modes
  PlayEn = 0;       // turn off play mode
  TdmBeat = 0;      // TDM mode LED[0] red value
  TdmInc = 1;       // increment used in TDM tasks
  TDM = true;       // set TDM flag
  switch(zMode) {
    case 0: // defauly TDM mode, beating red handle
      TdmInc = 5; fillFRAME0(); break;
  }
  mainMode = zMode; next5ms = millis(); Task5ms= 0;
}

// ---------------------------------------------------------------------------------

void showColArray(int zOff) {
  // loads the colour array values into the strip and shows it, with an
  // offset zOff
  for (int zP = 1; zP < NumLEDs; zP++) {
    int zAdd = zP + zOff - 1;
    if (zAdd >= 0 && zAdd <= NumLEDs_2) {
      LED[zP].setRGB(colRed[zAdd], colGrn[zAdd], colBlu[zAdd]);
    } else {
      LED[zP].setRGB(0,0,0);
    }
  } FastLED.show();
}

// ---------------------------------------------------------------------------------
