/*
  A library of drawing functions. Use with the scale function:
  
  A - Z                 Characters
  
*/

// ----------------------------------------------------------------------

void DrawLibChar_A(int zF) {
  // character A, 28mm hight, 20mm wide
  TurnLeft(90,0); DrawLine(20);
  TurnRight(45,1); DrawLine(11.3137);
  TurnRight(45,1); DrawLine(4);
  TurnRight(45,1); DrawLine(11.3137);
  TurnRight(45,1); DrawLine(20);
  TurnRight(90,0); GoForward(20);
  TurnRight(90,0); GoForward(12);
  TurnRight(90,0); DrawLine(20);
  TurnRight(90,0); GoForward(12);
  TurnLeft(90,0);
  if (zF > 0) DrawLib_IntChar();
}

// ----------------------------------------------------------------------

void DrawLibChar_B(int zF) {
  // character B, 28mm hight, 20mm wide
  DrawLine(16); TurnLeft(45,1);
  DrawLine(5.65685); TurnLeft(45,1);
  DrawLine(6); TurnLeft(45,1);
  DrawLine(5.65685); TurnRight(90,1);
  DrawLine(5.65685); TurnLeft(45,1);
  DrawLine(6); TurnLeft(45,1);
  DrawLine(5.65685); TurnLeft(45,1);
  DrawLine(16); TurnLeft(90,1);
  DrawLine(28); TurnRight(180,0);
  GoForward(14); TurnRight(90,0);
  DrawLine(16); TurnRight(90,0);
  GoForward(14); TurnLeft(90,0);
  GoForward(4);
  if (zF > 0) DrawLib_IntChar();
}

// ----------------------------------------------------------------------

void DrawLibChar_C(int zF) {
  // character C, 28mm hight, 20mm wide
  GoForward(20); TurnLeft(90,0);
  GoForward(20); DrawLine(4);
  TurnLeft(45,1); DrawLine(5.65685);
  TurnLeft(45,1); DrawLine(12);
  TurnLeft(45,1); DrawLine(5.65685);
  TurnLeft(45,1); DrawLine(20);
  TurnLeft(45,1); DrawLine(5.65685);
  TurnLeft(45,1); DrawLine(12);
  TurnLeft(45,1); DrawLine(5.65685);
  TurnLeft(45,1); DrawLine(4);
  TurnRight(180,0); GoForward(8);
  TurnLeft(90,0);
  if (zF > 0) DrawLib_IntChar();
}

// ----------------------------------------------------------------------

void DrawLibChar_D(int zF) {
  // character D, 28mm hight, 20mm wide
  DrawLine(14); TurnLeft(45,1);
  DrawLine(8.48528); TurnLeft(45,1);
  DrawLine(16); TurnLeft(45,1);
  DrawLine(8.48528); TurnLeft(45,1);
  DrawLine(14); TurnLeft(90,1);
  DrawLine(28); TurnLeft(90,0);
  GoForward(20);
  if (zF > 0) DrawLib_IntChar();
}

// ----------------------------------------------------------------------

void DrawLibChar_E(int zF) {
  // character E, 28mm hight, 20mm wide
  TurnLeft(90,0); DrawLine(28);
  TurnRight(90,1); DrawLine(20);
  TurnRight(90,0); GoForward(14);
  TurnRight(90,0); DrawLine(20);
  TurnLeft(90,0); GoForward(14);
  TurnLeft(90,0); DrawLine(20); PenUp();
  if (zF > 0) DrawLib_IntChar();
}

// ----------------------------------------------------------------------

void DrawLibChar_F(int zF) {
  // character F, 28mm hight, 20mm wide
  TurnLeft(90,0); DrawLine(28);
  TurnRight(90,1); DrawLine(20);
  TurnRight(90,0); GoForward(14);
  TurnRight(90,0); DrawLine(20);
  TurnLeft(90,0); GoForward(14);
  TurnLeft(90,0); GoForward(20);
  if (zF > 0) DrawLib_IntChar();
}

// ----------------------------------------------------------------------

void DrawLibChar_G(int zF) {
  // character G, 28mm hight, 20mm wide
  GoForward(20); TurnLeft(90,0);
  GoForward(20); DrawLine(4);
  TurnLeft(45,1); DrawLine(5.65685);
  TurnLeft(45,1); DrawLine(12);
  TurnLeft(45,1); DrawLine(5.65685);
  TurnLeft(45,1); DrawLine(20);
  TurnLeft(45,1); DrawLine(5.65685);
  TurnLeft(45,1); DrawLine(12);
  TurnLeft(45,1); DrawLine(5.65685);
  TurnLeft(45,1); DrawLine(8);
  TurnLeft(90,1); DrawLine(12);
  TurnLeft(90,0); GoForward(12);
  TurnLeft(90,0); GoForward(12);
  if (zF > 0) DrawLib_IntChar();
}

// ----------------------------------------------------------------------

void DrawLibChar_H(int zF) {
  // character H, 28mm hight, 20mm wide
  TurnLeft(90,0); DrawLine(28);
  TurnRight(180,0); GoForward(14);
  TurnLeft(90,0); DrawLine(20);
  TurnLeft(90,0); GoForward(14);
  TurnRight(180,0); DrawLine(28);
  TurnLeft(90,0);
  if (zF > 0) DrawLib_IntChar();
}

// ----------------------------------------------------------------------

void DrawLibChar_I(int zF) {
  // character I, 28mm hight, 20mm wide
  DrawLine(20); TurnLeft(90,0);
  GoForward(28); TurnLeft(90,0);
  DrawLine(20); TurnRight(180,0);
  GoForward(10); TurnRight(90,0);
  DrawLine(28); TurnLeft(90,0);
  GoForward(10);
  if (zF > 0) DrawLib_IntChar();
}

// ----------------------------------------------------------------------

void DrawLibChar_J(int zF) {
  // character J, 28mm hight, 20mm wide
  TurnLeft(90,0); GoForward(4);
  TurnRight(135,0); DrawLine(5.65685);
  TurnLeft(45,1); DrawLine(4);
  TurnLeft(45,1); DrawLine(5.65685);
  TurnLeft(45,1); DrawLine(24);
  TurnLeft(90,0); GoForward(8);
  TurnRight(180,0); DrawLine(16);
  TurnRight(90,0); GoForward(28);
  TurnLeft(90,0);
  if (zF > 0) DrawLib_IntChar();
}

// ----------------------------------------------------------------------

void DrawLibChar_K(int zF) {
  // character K, 28mm hight, 20mm wide
  TurnLeft(90,0); DrawLine(28);
  TurnRight(180,0); GoForward(14);
  TurnLeft(90,0); DrawLine(8);
  TurnLeft(49.3987,1); DrawLine(18.4391);
  TurnRight(180,0); GoForward(18.4391);
  TurnLeft(81.2026,0); DrawLine(18.4391);
  TurnLeft(49.3987,0);
  if (zF > 0) DrawLib_IntChar();
}

// ----------------------------------------------------------------------

void DrawLibChar_L(int zF) {
  // character L, 28mm hight, 20mm wide
  TurnLeft(90,0); GoForward(28);
  TurnRight(180,0); DrawLine(28);
  TurnLeft(90,1); DrawLine(20); PenUp();
  if (zF > 0) DrawLib_IntChar();
}

// ----------------------------------------------------------------------

void DrawLibChar_M(int zF) {
  // character M, 28mm hight, 20mm wide
  TurnLeft(90,0); DrawLine(28);
  TurnRight(153.435,1); DrawLine(22.3607);
  TurnLeft(126.870,1); DrawLine(22.3607);
  TurnRight(153.435,1); DrawLine(28);
  TurnLeft(90,0);
  if (zF > 0) DrawLib_IntChar();
}

// ----------------------------------------------------------------------

void DrawLibChar_N(int zF) {
  // character N, 28mm hight, 20mm wide
  TurnLeft(90,0); DrawLine(28);
  TurnRight(144.462,1); DrawLine(34.4093);
  TurnLeft(144.462,1); DrawLine(28);
  TurnRight(180,0); GoForward(28);
  TurnLeft(90,0);
  if (zF > 0) DrawLib_IntChar();
}

// ----------------------------------------------------------------------

void DrawLibChar_O(int zF) {
  // character O, 28mm hight, 20mm wide
  GoForward(6); DrawLine(8);
  TurnLeft(45,1); DrawLine(8.48528);
  TurnLeft(45,1); DrawLine(16);
  TurnLeft(45,1); DrawLine(8.48528);
  TurnLeft(45,1); DrawLine(8);
  TurnLeft(45,1); DrawLine(8.48528);
  TurnLeft(45,1); DrawLine(16);
  TurnLeft(45,1); DrawLine(8.48528);
  TurnLeft(45,0); GoForward(14);
  if (zF > 0) DrawLib_IntChar();
}

// ----------------------------------------------------------------------

void DrawLibChar_P(int zF) {
  // character P, 28mm hight, 20mm wide
  TurnLeft(90,0); DrawLine(28);
  TurnRight(90,1); DrawLine(16);
  TurnRight(45,1); DrawLine(5.65685);
  TurnRight(45,1); DrawLine(6);
  TurnRight(45,1); DrawLine(5.65685);
  TurnRight(45,1); DrawLine(16);
  TurnLeft(90,0); GoForward(14);
  TurnLeft(90,0); GoForward(20);
  if (zF > 0) DrawLib_IntChar();
}

// ----------------------------------------------------------------------

void DrawLibChar_Q(int zF) {
  // character Q, 28mm hight, 20mm wide
  DrawLibChar_O(0);
  TurnLeft(135,0); DrawLine(8.48528);
  TurnLeft(45,1); DrawLine(4);
  TurnLeft(90,0); GoForward(6);
  TurnLeft(90,0); GoForward(10);
  if (zF > 0) DrawLib_IntChar();
}

// ----------------------------------------------------------------------

void DrawLibChar_R(int zF) {
  // character R, 28mm hight, 20mm wide
  TurnLeft(90,0); DrawLine(28);
  TurnRight(90,1); DrawLine(16);
  TurnRight(45,1); DrawLine(5.65685);
  TurnRight(45,1); DrawLine(6);
  TurnRight(45,1); DrawLine(5.65685);
  TurnRight(45,1); DrawLine(16);
  TurnLeft(180,0); GoForward(12);
  TurnRight(60.2551,0); DrawLine(16.1245);
  TurnLeft(60.2551,0);
  if (zF > 0) DrawLib_IntChar();
}

// ----------------------------------------------------------------------

void DrawLibChar_S(int zF) {
  // character S, 28mm hight, 20mm wide
  TurnLeft(90,0); GoForward(8);
  TurnRight(180,0); DrawLine(4);
  TurnLeft(45,1); DrawLine(5.65685);
  TurnLeft(45,1); DrawLine(12);
  TurnLeft(45,1); DrawLine(5.65685);
  TurnLeft(45,1); DrawLine(6);
  TurnLeft(45,1); DrawLine(5.65685);
  TurnLeft(45,1); DrawLine(12);
  TurnRight(45,1); DrawLine(5.65685);
  TurnRight(45,1); DrawLine(6);
  TurnRight(45,1); DrawLine(5.65685);
  TurnRight(45,1); DrawLine(12);
  TurnRight(45,1); DrawLine(5.65685);
  TurnRight(45,1); DrawLine(4);
  GoForward(20); TurnLeft(90,0);
  if (zF > 0) DrawLib_IntChar();
}

// ----------------------------------------------------------------------

void DrawLibChar_Space(int zF) {
  // character ' ', 28mm hight, 20mm wide
  GoForward(20);
  if (zF > 0) DrawLib_IntChar();
}

// ----------------------------------------------------------------------

void DrawLibChar_T(int zF) {
  // character T, 28mm hight, 20mm wide
  TurnLeft(90,0); GoForward(28);
  TurnRight(90,0); DrawLine(20);
  TurnRight(180,0); GoForward(10);
  TurnLeft(90,0); DrawLine(28);
  TurnLeft(90,0); GoForward(10);
  if (zF > 0) DrawLib_IntChar();
}

// ----------------------------------------------------------------------

void DrawLibChar_U(int zF) {
  // character U, 28mm hight, 20mm wide
  TurnLeft(90,0); GoForward(28);
  TurnRight(180,0); DrawLine(24);
  TurnLeft(45,1); DrawLine(5.65685);
  TurnLeft(45,1); DrawLine(12);
  TurnLeft(45,1); DrawLine(5.65685);
  TurnLeft(45,1); DrawLine(24);
  TurnRight(180,0); GoForward(28);
  TurnLeft(90,0);
  if (zF > 0) DrawLib_IntChar();
}

// ----------------------------------------------------------------------

void DrawLibChar_V(int zF) {
  // character V, 28mm hight, 20mm wide
  TurnLeft(90,0); GoForward(28);
  TurnRight(160.346,0); DrawLine(29.7321);
  TurnLeft(140.692,1); DrawLine(29.7321);
  TurnRight(160.346,0); GoForward(28);
  TurnLeft(90,0);
  if (zF > 0) DrawLib_IntChar();
}

// ----------------------------------------------------------------------

void DrawLibChar_W(int zF) {
  // character W, 28mm hight, 20mm wide
  TurnLeft(90,0); GoForward(28);
  TurnRight(180,0); DrawLine(28);
  TurnLeft(153.435,1); DrawLine(22.3607);
  TurnRight(126.869,1); DrawLine(22.3607);
  TurnLeft(153.435,1); DrawLine(28);
  TurnRight(180,0); GoForward(28);
  TurnLeft(90,0);
  if (zF > 0) DrawLib_IntChar();
}

// ----------------------------------------------------------------------

void DrawLibChar_X(int zF) {
  // character X, 28mm hight, 20mm wide
  TurnLeft(90,0); GoForward(28);
  TurnRight(144.462,0); DrawLine(34.4093);
  TurnLeft(144.462,0); GoForward(28);
  TurnLeft(144.462,0); DrawLine(34.4093);
  TurnLeft(125.538,0); GoForward(20);
  if (zF > 0) DrawLib_IntChar();
}

// ----------------------------------------------------------------------

void DrawLibChar_Y(int zF) {
  // character Y, 28mm hight, 20mm wide
  TurnLeft(90,0); GoForward(28);
  TurnRight(135,0); DrawLine(14.1421);
  TurnRight(45,1); DrawLine(18);
  TurnLeft(180,0); GoForward(18);
  TurnRight(45,0); DrawLine(14.1421);
  TurnRight(135,0); GoForward(28);
  TurnLeft(90,0);
  if (zF > 0) DrawLib_IntChar();
}

// ----------------------------------------------------------------------

void DrawLibChar_Z(int zF) {
  // character Z, 28mm hight, 20mm wide
  TurnLeft(90,0); GoForward(28);
  TurnRight(90,0); DrawLine(20);
  TurnRight(125.538,1); DrawLine(34.4093);
  TurnLeft(125.538,1); DrawLine(20); PenUp();
  if (zF > 0) DrawLib_IntChar();
}

// ----------------------------------------------------------------------

void DrawLib_CRLF(float zChars, float zSpc) {
  // perform carriage return line feed based on printed no. chars
  // zSpc is normally == zChars - 1
  zChars = (zChars * 20.0) + (zSpc * intCharSpc);  // assumes 6mm intercharacter spacing
  TurnRight(180,0); GoForward(zChars);
  TurnLeft(90,0); GoForward(36); TurnLeft(90,0);  // assumes 8mm interline spacing
}

// ----------------------------------------------------------------------

void DrawLib_GestampTallent() {
  // draw text "GESTAMP TALLENT"
  DrawLibChar_G(1);
  DrawLibChar_E(1);
  DrawLibChar_S(1);
  DrawLibChar_T(1);
  DrawLibChar_A(1);
  DrawLibChar_M(1);
  DrawLibChar_P(0); DrawLib_CRLF(7.0,6.0); // goto start of next line

  DrawLibChar_T(1);
  DrawLibChar_A(1);
  DrawLibChar_L(1);
  DrawLibChar_L(1);
  DrawLibChar_E(1);
  DrawLibChar_N(1);
  DrawLibChar_T(0);
}

// ----------------------------------------------------------------------

void DrawLib_HitachiRail() {
  // draw text "HITACHI RAIL"
  DrawLibChar_H(1);
  DrawLibChar_I(1);
  DrawLibChar_T(1);
  DrawLibChar_A(1);
  DrawLibChar_C(1);
  DrawLibChar_H(1);
  DrawLibChar_I(1);
  DrawLibChar_Space(1);
  DrawLibChar_R(1);
  DrawLibChar_A(1);
  DrawLibChar_I(1);
  DrawLibChar_L(0);
}

// ----------------------------------------------------------------------

void DrawLib_IntChar() {
  // move an intercharacter space
  GoForward(intCharSpc);
}

// ----------------------------------------------------------------------

void DrawLib_A_to_Z() {
  // draw text "A - Z"
  DrawLibChar_A(1);
  DrawLibChar_B(1);
  DrawLibChar_C(1);
  DrawLibChar_D(1);
  DrawLibChar_E(1);
  DrawLibChar_F(1);
  DrawLibChar_G(1);
  DrawLibChar_H(1);
  DrawLibChar_I(0); DrawLib_CRLF(9,8); // goto start of next line

  DrawLibChar_J(1);
  DrawLibChar_K(1);
  DrawLibChar_L(1);
  DrawLibChar_M(1);
  DrawLibChar_N(1);
  DrawLibChar_O(1);
  DrawLibChar_P(1);
  DrawLibChar_Q(1);
  DrawLibChar_R(0); DrawLib_CRLF(9,8); // goto start of next line

  DrawLibChar_S(1);
  DrawLibChar_T(1);
  DrawLibChar_U(1);
  DrawLibChar_V(1);
  DrawLibChar_W(1);
  DrawLibChar_X(1);
  DrawLibChar_Y(1);
  DrawLibChar_Z(0);
}

// ----------------------------------------------------------------------

void DrawLib_UTCRobotsRock() {
  // draw text "UTC ROBOTS ROCK"
  DrawLibChar_U(1);
  DrawLibChar_T(1);
  DrawLibChar_C(0); DrawLib_CRLF(4.5,3.5); // goto start of next line

  DrawLibChar_R(1);
  DrawLibChar_O(1);
  DrawLibChar_B(1);
  DrawLibChar_O(1);
  DrawLibChar_T(1);
  DrawLibChar_S(0); DrawLib_CRLF(5.5,4.5); // goto start of next line

  DrawLibChar_R(1);
  DrawLibChar_O(1);
  DrawLibChar_C(1);
  DrawLibChar_K(0);
}

// ----------------------------------------------------------------------

void DrawLib_Robot0() {
  // draw a rocking robot. Use ScaleXY and SetOrigin before this function.
  // left leg
  GoToPoint(2.0,0.0);
  DrawToPoint5(10.0,0.0, 19.0,2.5, 22.2,6.0, 12.3,11.5, 3.5,10.0);
  DrawToPoint2(0.0,5.0, 2.0,0.0);
  GoToPoint(12.3,11.5);
  DrawToPoint5(13.0,19.0, 16.5,22.0, 21.0,22.0, 21.5,15.0, 23.3,8.0);
  DrawToPoint(22.0,6.0);
  GoToPoint(13.0,19.0);
  DrawToPoint5(10.5,21.3, 9.5,24.5, 13.0,27.5, 17.5,28.2, 21.5,26.5);
  DrawToPoint(21.5,22.0);
  GoToPoint(12.5,27.5);
  DrawToPoint4(21.5,35.0, 25.3,36.0, 26.6,33.8, 21.0,27.0);
  // right leg
  GoToPoint(48.0,3.0);
  DrawToPoint5(53.0,1.5, 64.5,1.0, 70.0,4.5, 70.0,10.3, 63.3,13.6);
  DrawToPoint3(51.5,10.8, 46.0,6.0, 48.0,3.0);
  GoToPoint(47.0,7.3);
  DrawToPoint5(46.0,14.0, 44.0,21.5, 47.6,22.5, 51.5,22.0, 54.5,19.5);
  DrawToPoint(57.0,12.2);
  GoToPoint(54.5,20.0);
  DrawToPoint5(56.0,22.0, 55.6,25.5, 50.6,28.5, 44.0,28.5, 42.2,26.5);
  DrawToPoint2(42.0,23.5, 43.5,21.5);
  GoToPoint(44.0,28.5);
  DrawToPoint5(40.3,33.0, 37.0,35.5, 40.5,38.5, 44.0,38, 50.5,28.6);
  // body
  GoToPoint(24.0,31.0); DrawToPoint(40.0,33.0);
  GoToPoint(47.0,34.0);
  DrawToPoint5(56.0,35.6, 39.5,43.5, 27.5,41.0, 14.3,36.0, 19.0,33.0);
  GoToPoint(14.3,36.0);
  DrawToPoint5(20.3,51.0, 23.0,67.5, 31.5,70.6, 36.0,73.3, 41.3,74.3);
  DrawToPoint2(41.5,59.0, 39.5,43.5);
  GoToPoint(56.0,36.0);
  DrawToPoint2(53.5,53.0, 54.5,67.0);
  GoToPoint(48.5,70); DrawToPoint(41.3,74.3);
  GoToPoint(37.6,66.6);
  DrawToPoint4(25.0,63.0, 20.4,54.0, 36.6,57.0, 37.6,66.6);
  // left arm
  GoToPoint(22.6,64.6);
  DrawToPoint5(15.0,60.0, 12.0,66.0, 9.3,64.5, 8.0,65.5, 0.5,60.5);
  DrawToPoint5(2.0,57.8, 1.3,55.0, 3.5,54.5, 3.0,52.0, 5.5,52.0);
  DrawToPoint5(5.0,50.0, 7.5,47.6, 15.3,52.0, 12.8,56.0, 13.6,56.5);
  DrawToPoint3(12.0,59.8, 10.4,63.0, 9.0,64.2);
  GoToPoint(8.8,57.5); DrawToPoint(12.0,60.0);
  GoToPoint(11.2,54.8); DrawToPoint(14.0,56.5);
  GoToPoint(14.3,53.5); DrawToPoint(21.0,57.5);
  // right arm
  GoToPoint(54.0,76.5);
  DrawToPoint5(59.5,73.5, 56.5,69.5, 52.0,65.5, 48.0,65.5, 47.5,67.6);
  DrawToPoint(54.0,76.5);
  DrawToPoint5(53.5,79.0, 55.0,81.0, 59.0,79.0, 62.0,79.5, 62.0,75.3);
  DrawToPoint(59.5,73.5);
  GoToPoint(56.0,80.5);
  DrawToPoint5(55.0,89.0, 51.5,94.0, 53.3,96.5, 56.6,96.0, 60.0,93.0);
  DrawToPoint2(64.0,92.3, 62.3,79.5);
  GoToPoint(51.5,94.0);
  DrawToPoint3(54.0,92.8, 57.6,91.5, 58.5,94.0);
  GoToPoint(64.0,92.3);
  DrawToPoint5(66.5,99.3, 60.5,103.5, 57.6,102.6, 56.0,104.0, 51.5,98.6);
  DrawToPoint(63.3,96.5);
  GoToPoint(56.5,101.3); DrawToPoint2(54.6,99.0, 55.6,96.0);
  GoToPoint(60.6,99.5); DrawToPoint2(58.3,97.3, 58.5,93.6);
  GoToPoint(62.6,98.0); DrawToPoint2(60.8,96.0, 61.0,92.8);
  // neck & head
  GoToPoint(31.5,71.6);
  DrawToPoint4(28.6,77.8, 31.5,79.5, 34.5,78.5, 36.3,73.3);
  GoToPoint(30.5,73.5);
  DrawToPoint5(18.0,74.5, 26.3,80.8, 36.3,85.0, 48.0,82.0, 35.6,75.5);
  GoToPoint(18.0,74.5);
  DrawToPoint5(14.3,82.0, 11.6,92.2, 20.3,99.0, 25.0,101.5, 33.0,105.5);
  DrawToPoint3(46.5,100.0, 47.0,90.3, 48.0,82.0);
  GoToPoint(36.3,85.0); DrawToPoint2(33.9,95.8, 33.0,105.5);
  GoToPoint(17.3,82.4);
  DrawToPoint3(22.3,86.2, 27.3,89.2, 32.0,91.0);
  GoToPoint(19.0,88.6);
  DrawToPoint4(17.3,87.6, 16.3,91.5, 18.0,92.3, 19.0,88.6);
  GoToPoint(26.3,93.0);
  DrawToPoint4(25.5,96.6, 27.0,97.4, 28.0,94.0, 26.3,93.0);
  GoToPoint(41.0,93.5);
  DrawToPoint5(43.0,94.6, 43.0,96.5, 42.5,99.0, 40.0,99.0, 39.5,96.5);
  DrawToPoint(41.0,93.5);
  GoToPoint(43.0,94.6);
  DrawToPoint2(41.3,97.4, 42.5,99.0);
  // antenna
  GoToPoint(25.0,101.4);
  DrawToPoint5(24.8,107.8, 23.3,110.6, 19.3,110.6, 19.0,109.0, 17.0,109.0);
  DrawToPoint3(17.5,112.0, 19.3,112.0, 19.3,110.6);
}

// ----------------------------------------------------------------------

void DrawLib_RobotArm() {
  // draw a simple robot arm  
  // Use ScaleXY and SetOrigin before this function.
  GoToPoint(5.0,0.0);
  DrawToPoint5(43.5,0.0, 43.5,11.0, 41.0,14.0, 8.0,14.0, 5.0,11.0);
  DrawToPoint(5.0,0.0);
  GoToPoint(17.3,14.0); DrawToPoint(5.0,47.0);
  GoToPoint(17.5,48.5); DrawToPoint(31.5,14.0);
  GoToPoint(0.0,45.0); GoToPoint(0.0,55.0);
  CurveRight(10.0,360.0);
  GoToPoint(4.0,55.0); TurnTo(0.0);
  CurveRight(6.0,360.0);
  GoToPoint(19.0,60.5); DrawToPoint(29.0,60.5);
  GoToPoint(19.0,50.5); DrawToPoint(29.0,50.5);
  DrawToPoint5(29.0,62.0, 31.0,65.0, 36.5,65.0, 38.0,62.0, 38.0,48.5);
  DrawToPoint4(36.6,46.0, 31.0,46.0, 29.0,48.5, 29.0,50.5);
  GoToPoint(38.0,62.0); DrawToPoint2(43.0,68.0, 53.5,60.0);
  GoToPoint(38.0,48.5); DrawToPoint2(43.0,42.0, 53.5,50.0);
}

// ----------------------------------------------------------------------

void DrawLib_Star_5() {
  // draw a 5-pointed star shape.
  // Use ScaleXY and SetOrigin before this function.
  GoToPoint(13.5,0.0);
  DrawToPoint5(21.8,27.0, 0.0,43.4, 27.0,43.4, 35.0,70.0, 43.3,43.4);
  DrawToPoint5(70.0,43.4, 48.5,27.0, 56.8,0, 35.0,16.8, 13.5,0.0);
  GoToPoint(0.0,0.0); TurnTo(90);
}

// ----------------------------------------------------------------------

void DrawLib_Train() {
  // draw an outline of an Hitachi train
  // Use ScaleXY and SetOrigin before this function.
  GoToPoint(152.5,10.0);
  DrawToPoint4(32.0,1.0, 23.5,0.0, 16.0,0.6, 14.0,1.5);
  DrawToPoint5(15.0,3.5, 14.5,6.0, 6.3,10.0, 2.5,13.0, 0.3,18.5);
  DrawToPoint5(1.3,25.0, 5.0,30.0, 20.5,46.0, 46.5,64.0, 53.0,67.5);
  DrawToPoint4(62.5,70.0, 71.5,70.0, 83.5,67.5, 154.0,36.0);
  GoToPoint(76.6,68.6);
  DrawToPoint5(64.5,64.0, 43.3,49.0, 21.5,27.5, 18.5,23.5, 17.5,17.5);
  DrawToPoint3(19.5,12.0, 23.3,8.3, 27.6, 6.0);
  GoToPoint(20.5,46.0);
  DrawToPoint(42.5,49.0);
  GoToPoint(55.5,48.0);
  DrawToPoint5(46.5,40.0, 41.5,38.5, 31.6,36.6, 41.5,46.0, 55.5,48.0);
  GoToPoint(61.5,51.5);
  DrawToPoint5(70.5,57.5, 81.0,61.0, 86.5,62.0, 84.0,54.0, 82.5,52.5);
  DrawToPoint(61.5,51.5);
}

// ----------------------------------------------------------------------




