
// ----------------------------------------------------------------------

void CheckCartAng() {
  // ensure that CartAng is within limits
  if (CartAng > 180.0) {CartAng = CartAng - 360.0;}
  if (CartAng < -180.0) {CartAng = CartAng + 360.0;}
}

// ----------------------------------------------------------------------

void decPhaseL() {
  // decrement the left stepper phase
  if (PhaseDirL >= 0) {
    // change of phase direction so remove slack
    if (PhaseSEn > 0) {
      for (int zL = 0; zL < PhaseLSlack; zL++) {
        PhaseL--; if (PhaseL < 0) {PhaseL = 7;} 
        SetPhaseLeft(); delayStep();
      } interval = intervalMax;
    }
  } PhaseDirL = -1; // set phase direction
  PhaseL--; if (PhaseL < 0) {PhaseL = 7;}
}

// ----------------------------------------------------------------------

void decPhaseR() {
  // decrement the right stepper phase
  if (PhaseDirR >= 0) {
    // change of phase direction so remove slack
    if (PhaseSEn > 0) {
        for (int zL = 0; zL < PhaseRSlack; zL++) {
        PhaseR--; if (PhaseR < 0) {PhaseR = 7;} 
        SetPhaseRight(); delayStep();
      } interval = intervalMax;
    }
  } PhaseDirR = -1; // set phase direction
  PhaseR--; if (PhaseR < 0) {PhaseR = 7;}
}

// ----------------------------------------------------------------------

void delayStep() {
  // interstep delay called by move functions
  int zTask = 0;
  while (micros() < nextMicros) {
    // whilst waiting read ports
    switch(zTask) {
      case 0: readSerial(); zTask++; break;
      case 1: readIR(); zTask++; break;
      default: zTask = 0;
    }
  }
  nextMicros = micros() + interval;
  if (Brake < 1) {
    if (interval > intervalMin) {interval = interval - intervalDec;}
  } else {
    if (interval < intervalMax) {interval = interval + intervalInc;}
  }
}

// ----------------------------------------------------------------------

void Draw1() {
  // draw a demo pattern UTC Robots Rock
  Serial.println("Task = Draw1");
  DrawDefaults();
  TurnLeft(90,0); GoForward(53); TurnRight(90,0);  GoForward(18);
  TurnLeft(90,0); CurveRight(60,360);
  GoForward(13); TurnRight(90,0); GoForward(39);
  ScaleXY = 0.542 * ScaleAn;
  DrawLib_UTCRobotsRock();
  ScaleXY = 1.0 * ScaleAn;
  GoForward(36); TurnLeft(90,0); GoForward(32); TurnLeft(90,0);
  GoBackward(15);
  DrawEnd();
}

// ----------------------------------------------------------------------

void Draw2() {
  // draw a demo pattern Hitachi Rail
  Serial.println("Task = Draw2");
  DrawDefaults();
  TurnLeft(90,0); GoForward(18); TurnRight(90,0);
  SetOrigin(0.0,0.0,90.0);
  DrawLib_Train();
  GoToPoint(30.0,23.0); GoToPoint(36.5,23.0);
  ScaleXY = 0.35 * ScaleAn;
  DrawLib_HitachiRail();
  ScaleXY = 1.0 * ScaleAn; SetOrigin(80.0,19.0,90.0);
  DrawLib_Train();
  GoToPoint(155.0,70.0); GoToPoint(150.0,65.0);
  DrawEnd();
}

// ----------------------------------------------------------------------

void Draw3() {
  // draw a demo pattern GESTAMP TALLENT
  Serial.println("Task = Draw3");
  DrawDefaults();
  TurnLeft(90,0); GoForward(37); TurnRight(90,0);
  ScaleXY = 0.4285 * ScaleAn;
  DrawLib_GestampTallent();
  ScaleXY = 1.0 * ScaleAn; SetOrigin(80.0,19.0,90.0);
  GoToPoint(85.0,0.0); GoToPoint(90.0,0.0); SetOrigin(0.0,0.0,90.0);
  DrawLib_RobotArm();
  GoToPoint(60.0,0.0); GoToPoint(60.0,5.0);
  DrawEnd();
}

// ----------------------------------------------------------------------

void Draw4() {
  // draw a demo pattern star & circle patterns
  Serial.println("Task = Draw4");
  DrawDefaults();
  randomSeed(micros()); // seed random function
  TurnLeft(90,0); GoForward(88); SetOrigin(0.0,0.0,-90.0);
  for (int zL = 0; zL < 10; zL++) {
    long zX = random(0,36); long zY = random(0,77);
    GoToPoint(zX,zY);
    PushOrigin();
    ScaleXY = random(50,101); ScaleXY = ScaleXY / 100.0; // 50-100%
    ScaleXY = ScaleXY * ScaleAn; SetOrigin(0.0,0.0,0.0);
    DrawLib_Star_5();
    ScaleXY = 1.0 * ScaleAn; PopOrigin();
    zX = random(35,71); zY = random(76,156);
    GoToPoint(zX,zY);
    PushOrigin();
    ScaleXY = random(50,101); ScaleXY = ScaleXY / 100.0;
    ScaleXY = ScaleXY * ScaleAn; SetOrigin(0.0,0.0,0.0);
    DrawLib_Star_5();
    ScaleXY = 1.0 * ScaleAn; PopOrigin();
    zX = random(0,36); zY = random(76,156);
    GoToPoint(zX,zY);
    PushOrigin();
    ScaleXY = random(50,101); ScaleXY = ScaleXY / 100.0;
    ScaleXY = ScaleXY * ScaleAn; SetOrigin(0.0,0.0,0.0);
    DrawLib_Star_5();
    ScaleXY = 1.0 * ScaleAn; PopOrigin();
    zX = random(35,71); zY = random(0,77);
    GoToPoint(zX,zY);
    PushOrigin();
    ScaleXY = random(50,101); ScaleXY = ScaleXY / 100.0;
    ScaleXY = ScaleXY * ScaleAn; SetOrigin(0.0,0.0,0.0);
    DrawLib_Star_5();
    ScaleXY = 1.0 * ScaleAn; PopOrigin();
  }
  GoToPoint(88.0,-5.0); GoToPoint(88.0,0.0); // go back to origin
  DrawEnd();
}

// ----------------------------------------------------------------------

void Draw5() {
  // draw a demo pattern Rocking Robot
  Serial.println("Task = Draw5");
  DrawDefaults();
  TurnLeft(90,0); GoForward(88); SetOrigin(0.0,0.0,-90.0);
  DrawLib_Robot0();
  DrawEnd();
}

// ----------------------------------------------------------------------

void Draw6() {
  // draw a demo pattern
}

// ----------------------------------------------------------------------

void Draw7() {
  // draw a demo pattern
}

// ----------------------------------------------------------------------

void Draw8() {
  // draw a demo pattern
}

// ----------------------------------------------------------------------

void Draw9() {
  // draw a demo pattern
}

// ----------------------------------------------------------------------

void Draw0() {
  // draw a demo pattern
  Serial.println("Task = Draw0");
  DrawDefaults();
  TurnLeft(90,0); GoForward(65); TurnRight(90,0);
  ScaleXY = 0.682 * ScaleAn;
  DrawLib_A_to_Z();
  ScaleXY = 1.0 * ScaleAn;
  GoForward(23); TurnLeft(90,0);
  GoForward(34); TurnLeft(90,0);
  DrawEnd();
}

// ----------------------------------------------------------------------

void DrawDefaults() {
  // set up standard settings before drawing  
  ScaleXY = 1.0 * ScaleAn; PhaseSEn = 1;
  stepperON(); penDrawMode = 1; interval = intervalMax; drawEn = 1;
}

// ----------------------------------------------------------------------

void DrawEnd() {
  // perform standard steps at end of drawing
  stepperOFF(); PenMax(); ServoOFF();
  MainTask = -1; // reset main task to no action
  interval = 1000; nextMicros = micros() + MainInterval;
}

// ----------------------------------------------------------------------

void DrawShapes() {
  // special mode in which user can draw shapes of size set by keypad
  // entered numbers. The first number selects the shape, The following
  // numbers define the length of the side. The joystick arrow keys
  // determine where the shape is drawn.
  Serial.println("Task = DrawShapes");
  waitIRx(); // empty IR Rx buffer
  int zState = 0; // initialise a state
  drawDir = 0; drawLen = 0.0;
  while (zState == 0) {
    // loop until an IR remote button is pressed
    if (irrecv.decode(&results)) {
      // we have received an IR signal
      irResult = results.value;
      irrecv.resume(); // ready to receive the next value
      translateIRNum(); zState = 1; // exit this state
    } else {delay(150);} // wait before trying to read IR again
  }
  if (keyNum < 0) {keyNum = 999;} // test for -1 error
  if (keyNum == 999) {setDefaults(); runPOST();}
  else {
    // define mode with first key number then get distance/direction
    drawMode = keyNum; zState = 1;
    Serial.print("drawMode = "); Serial.println(drawMode);
    waitIRx();
    while (zState == 1) {
      if (irrecv.decode(&results)) {
        // we have received an IR signal
        irResult = results.value;
        irrecv.resume(); // ready to receive the next value
        translateIRNum();
        if ((keyNum >= 0) & (keyNum <= 9)) {
          // a number has been received
          drawLen = (drawLen * 10.0) + float(keyNum);
        Serial.print("drawLen = "); Serial.println(drawLen);
        } else if (keyNum == -1) {
          // decimal point recieved
        } else {
          // non-numeric button pressed
          irResult = irResult & 0xFF;
          switch(irResult) {
            // "POWER"
            case 0x4C: keyNum = 999; zState = 999; break;
            // "FORWARD"
            case 0x54: drawDir = 0; zState = 2; break;
            // "< LEFT"
            case 0x55: drawDir = 3; zState = 2; break;
            // "RIGHT >"
            case 0x56: drawDir = 1; zState = 2; break;
            // "REVERSE"
            case 0x53: drawDir = 2; zState = 2; break;
          }
        }
        waitIRx();
      } else {delay(150);} // wait before trying to read IR again
    }
    if (drawLen < 1.0) {drawLen = 10.0;} // force min length
    if (zState == 999) {setDefaults(); runPOST();}
    else {
      // set direction then draw shape
      Serial.print("drawLen = "); Serial.println(drawLen);
      DrawDefaults();
      if (drawMode < 1) {drawMode = 10;}
      switch (drawDir) {
        case 0:
          // direction is forward
          if (drawMode > 1) {
            // not a line
            TurnLeft(90.0, 0); drawDir = 1; // set drawing to the right
          }
          if (drawMode > 2) {
            // not a line or circle so backup 1/2 distance
            GoBackward(drawLen / 2.0);
          } break;
        case 1:
          // direction is to the right, if a line turn right
          if (drawMode < 2) {TurnRight(90.0, 0);} break;
        case 2:
          // direction is behind
          if (drawMode < 2) {
            // a line
            TurnRight(180.0, 0);
          } else if (drawMode > 2) {
            // not a line or circle
            TurnRight(90.0, 0); GoBackward(drawLen / 2.0);
            drawDir = 1; // set drawing to the right
          } else {
            // a circle
            TurnRight(90.0, 0); drawDir = 1;
          } break;
        case 3:
          // direction is to the left
          if (drawMode < 2) {
            TurnLeft(90.0, 0);
          } break;
      }
      switch (drawMode) {
        // now draw the shape
        case 1:
          Serial.println("Drawing A Line");
          DrawLine(drawLen); break;
        case 2:
          // draw a circle
          Serial.println("Drawing A Circle");
          if (drawDir == 1) {
            CurveRight(drawLen, 360.0);
          } else {
            CurveLeft(drawLen, 360.0);
          } break;
        case 3:
          // draw a 3 sided shape
          Serial.println("Drawing A Triangle");
          if (drawDir == 1) {
            PolyRight(3.0, drawLen);
          } else {
            PolyLeft(3.0, drawLen);
          } break;
        case 4:
          // draw a square
          Serial.println("Drawing A Square");
          if (drawDir == 1) {
            RectRight(drawLen, drawLen);
          } else {
            RectLeft(drawLen, drawLen);
          } break;
        case 5:
          // draw a 5 sided shape
          Serial.println("Drawing A 5 Sided Polygon");
          if (drawDir == 1) {
            PolyRight(5.0, drawLen);
          } else {
            PolyLeft(5.0, drawLen);
          } break;
        case 6:
          // draw a 6 sided shape
          Serial.println("Drawing A 6 Sided Polygon");
          if (drawDir == 1) {
            PolyRight(6.0, drawLen);
          } else {
            PolyLeft(5.0, drawLen);
          } break;
        case 7:
          // draw a 7 sided shape
          Serial.println("Drawing A 7 Sided Polygon");
          if (drawDir == 1) {
            PolyRight(7.0, drawLen);
          } else {
            PolyLeft(7.0, drawLen);
          } break;
        case 8:
          // draw a 8 sided shape
          Serial.println("Drawing A 8 Sided Polygon");
          if (drawDir == 1) {
            PolyRight(8.0, drawLen);
          } else {
            PolyLeft(8.0, drawLen);
          } break;
        case 9:
          // draw a 9 sided shape
          Serial.println("Drawing A 9 Sided Polygon");
          if (drawDir == 1) {
            PolyRight(9.0, drawLen);
          } else {
            PolyLeft(9.0, drawLen);
          } break;
        case 10:
          // draw a 10 sided shape
          Serial.println("Drawing A 10 Sided Polygon");
          if (drawDir == 1) {
            PolyRight(10.0, drawLen);
          } else {
            PolyLeft(10.0, drawLen);
          } break;
      }
    }
  }
  Serial.println("Exit DrawShapes");
  DrawEnd(); waitIRx();
}

// ----------------------------------------------------------------------

void emptyIRBuffer() {
  // read the IR sensor buffer until it is empty
  while (irrecv.decode(&results)) {
    // we have received an IR signal
    irResult = 0;
    irrecv.resume(); // ready to receive the next value
    delay(irDel);
  }
}

// ----------------------------------------------------------------------

void incPhaseL() {
  // increment the left stepper phase
  if (PhaseDirL < 1) {
    // change of phase direction so remove slack
    if (PhaseSEn > 0) {
      for (int zL = 0; zL < PhaseLSlack; zL++) {
        PhaseL++; if (PhaseL > 7) {PhaseL = 0;} 
        SetPhaseLeft(); delayStep();
      } interval = intervalMax;
    }
  } PhaseDirL = 1; // set phase direction
  PhaseL++; if (PhaseL > 7) {PhaseL = 0;}
}

// ----------------------------------------------------------------------

void incPhaseR() {
  // increment the right stepper phase
  if (PhaseDirR < 1) {
    // change of phase direction so remove slack
    if (PhaseSEn > 0) {
      for (int zL = 0; zL < PhaseRSlack; zL++) {
        PhaseR++; if (PhaseR > 7) {PhaseR = 0;} 
        SetPhaseRight(); delayStep();
      } interval = intervalMax;
    }
  } PhaseDirR = 1; // set phase direction
  PhaseR++; if (PhaseR > 7) {PhaseR = 0;}
}

// ----------------------------------------------------------------------

void joyTask() {
  // perform joystick driven move tasks
  while (MainTask == 50) {
    // change step values every cycle
    readMicros = micros();
    if (readMicros >= nextJLMicros) {
      // do left stepper movement
      nextJLMicros = readMicros + intervalJL;
      if (PhaseDirL > 0) {PhaseL++; if (PhaseL > 7) {PhaseL = 0;}}
      if (PhaseDirL < 0) {PhaseL--; if (PhaseL < 0) {PhaseL = 7;}}
      SetPhaseLeft();
    }
    readMicros = micros();
    if (readMicros >= nextJRMicros) {
      // do right stepper movement
      nextJRMicros = readMicros + intervalJR;
      if (PhaseDirR > 0) {PhaseR--; if (PhaseR < 0) {PhaseR = 7;}}
      if (PhaseDirR < 0) {PhaseR++; if (PhaseR > 7) {PhaseR = 0;}}
      SetPhaseRight();
    }
    // check IR receiver
    if (micros() >= nextMicros) {
      // read IR receiver every 20ms
      nextMicros = micros() + interval;
      readIR();
      // check for steering and reduce progressively
      if (PhaseDirL == PhaseDirR) {
        // going forward or backwards so check for steering bias
        if (joyKey > 0) {
          joyKey--; // reduce delay
        }
        else {
          if (intervalJL < intervalJR) {
            // turning right
            intervalJR = (intervalJR * 7)/8; // increase speed
            intervalJR = max(intervalJC, intervalJR);
            intervalJL = (intervalJL * 9)/8; // decrease speed
            intervalJL = min(intervalJC, intervalJL);
          } 
          else if (intervalJR < intervalJL) {
            // turning left
            intervalJL = (intervalJL * 7)/8; // increase speed
            intervalJL = max(intervalJC, intervalJL);
            intervalJR = (intervalJR * 9)/8; // decrease speed
            intervalJR = min(intervalJC, intervalJR);
          }
        }
      } else {
        // neutral turning so reduce both progressively
        if (joyKey > 0) {
          joyKey--; // reduce delay
        }
        else {
          if (intervalJL < 40000) {
            intervalJL = (intervalJL * 9)/8;
          } else {intervalJL = 40000; PhaseDirL = 0;}
          if (intervalJR < 40000) {
            intervalJR = (intervalJR *9)/8;
          } else {intervalJR = 40000; PhaseDirR = 0;}
        }
      }
    }
  }
}

// ----------------------------------------------------------------------

void keyAction() {
  // called when an IR remote key has been pressed to perform an action
  switch (keyVal) {
    case 35:
      // key "#" pressed
      break;
    case 42:
      // key "*" pressed
      break;
    case 49:
      // key "1" pressed
      MainTask = MainMode + 1; break;
    case 50:
      // key "2" pressed
      MainTask = MainMode + 2; break;
    case 51:
      // key "3" pressed
      MainTask = MainMode + 3; break;
    case 52:
      // key "4" pressed
      MainTask = MainMode + 4; break;
    case 53:
      // key "5" pressed
      MainTask = MainMode + 5; break;
    case 54:
      // key "6" pressed
      MainTask = MainMode + 6; break;
    case 55:
      // key "7" pressed
      MainTask = MainMode + 7; break;
    case 56:
      // key "8" pressed
      MainTask = MainMode + 8; break;
    case 57:
      // key "9" pressed
      MainTask = MainMode + 9; break;
    case 58:
      // key "0" pressed
      MainTask = MainMode + 0; break;
    case 60:
      // key "<" pressed
      break;
    case 62:
      // key ">" pressed
      break;
    case 999:
      // key "PWR" pressed
      setDefaults(); runPOST(); break;
  }
}

// ----------------------------------------------------------------------

void PopOrigin() {
  // recover the pushed cartesian values
  CartAng = CartAngRef; CartX = CartXRef; CartY = CartYRef;
}

// ----------------------------------------------------------------------

void PushOrigin() {
  // save the current cartesian values
  CartAngRef = CartAng; CartXRef = CartX; CartYRef = CartY;
}

// ----------------------------------------------------------------------

void readIR() {
  // read the IR sensor every 200ms
  if (irrecv.decode(&results)) {
    // we have received an IR signal
    irResult = results.value;
    irrecv.resume(); // ready to receive the next value
    if (irEn > 0) {
      translateIR();
      if (keyVal > 0) {
        Serial.print("keyVal: ");
        Serial.println(keyVal);
        keyAction();
      }
    }
  }
}

// ----------------------------------------------------------------------

void readSerial() {
  // read a key from the serial port and react to it
  keyDel = 100; // come here every 100ms
  keyVal = Serial.read();
  if (keyVal != -1) {
    Serial.print("keyVal: ");
    Serial.println(keyVal);
    keyAction();
  }
}

// ----------------------------------------------------------------------

void RP() {
  // report backlash values
  Serial.print("PhaseLSlack = "); Serial.println(PhaseLSlack);
  Serial.print("PhaseRSlack = "); Serial.println(PhaseRSlack);
}

// ----------------------------------------------------------------------

void runPOST() {
  // run initialisation routines once
  Serial.println("\n\n\n\nA4 DrawBot");
  Serial.println("Starting POST...");
  // lift pen to max height
  ServoON(); PenMax();
  // light driver lams and pause
  PhaseL = 7; PhaseR = 7;
  SetPhaseLeft(); SetPhaseRight(); delay(2000);
  // do some moves
//  interval = 10000; // set slow step delay
//  drawEn = 1; // temporarily enable drawing
//  interval = intervalMax; nextMicros = micros() + interval;
//  GoBackward(10);
//  GoForward(10);
  PhaseL = -1; PhaseR = -1;
  SetPhaseLeft(); SetPhaseRight();
  // lower and raise pen a couple of times, not touching paper
  for (anyV = 0; anyV < 2; anyV++) {
    servoLift.writeMicroseconds(liftMax + 100); delay(200);
    servoLift.writeMicroseconds(liftMax); delay(200);
  } ServoOFF();
  // set up default main task
  MainTask = -1; interval = 1000;
  nextMicros = micros() + MainInterval;
  emptyIRBuffer(); irEn = 1; drawEn = 0;
  Serial.println("POST Complete!\n");
}

// ----------------------------------------------------------------------

void ServoOFF() {
  // turn servo OFF and set a flag
  delay(200); // allow movement to complete it moving
  servoLift.detach(); servoEn = 0;
}

// ----------------------------------------------------------------------

void ServoON() {
  // turn servo ON and set a flag
  servoLift.attach(servoPin); servoEn = 1;
}

// ----------------------------------------------------------------------

void setDefaults() {
  // set variable default values
  anyD = 0; // any temp value
  anyF = 0.0; // any temp value
  anyV = 0; // any temp value
  drawDir = 0; // direction to draw in direct draw mode
  drawEn = 0; // must be 1 for draw action to occur
  drawLen = 0.0; // distance to draw in direct draw mode
  drawMode = 0; // direct drawing mode
  interval = 1000; // step interval in micros
  intervalJC = 10000; // combined average step interval in micros
  intervalJL = 10000; // joy left step interval in micros
  intervalJR = 10000; // joy right step interval in micros
  irEn = 0; // IR read enable, 0 = OFF, 1 = ON
  irResult = 0; // IR value received
  keyDel = 0; // delay between reading keyboard in miliseconds
  keyVal = -1; // input value read from serial port or IR translation
  MainMode = 0; // main loop task grouping 0, 10, 20, 30
  MainTask = -1; // main loop task pointer
  MinTask = 0; // main loop background task pointer
  nextMicros = micros() + interval; // target step delay in micros
  penDrawMode = 1; // pen drawing mode
  PhaseDirL = 0; // phase direction, -1, 0, 1
  PhaseDirR = 0; // phase direction, -1, 0, 1
  PhaseL = -1; // left phase value 0 - 7
  PhaseLOff = PhaseL; // left phase at Stepper OFF
  PhaseLSlack = 25; // left wheel gearbox slack in steps
  PhaseR = -1; // right phase value 0 - 7
  PhaseROff = PhaseR; // right phase at Stepper OFF
  PhaseRSlack = 54; // right wheel gearbox slack in steps
  PhaseSEn = 1; // backlash removal, 1 = ON, 0 - OFF
  ScaleXY = 1.0; // scale factor for all linear movements
  servoEn = 0; // servo ON/OFF flag, 0 = OFF, 1 = ON
  servoVal = 0; // value sent to the servo
}

// ----------------------------------------------------------------------

void SetPhaseLeft(){
  // set the left phase driver
  switch(PhaseL){
     case 0:
       digitalWrite(IN1L, LOW); digitalWrite(IN2L, LOW);
       digitalWrite(IN3L, LOW); digitalWrite(IN4L, HIGH);
     break; 
     case 1:
       digitalWrite(IN1L, LOW); digitalWrite(IN2L, LOW);
       digitalWrite(IN3L, HIGH); digitalWrite(IN4L, HIGH);
     break; 
     case 2:
       digitalWrite(IN1L, LOW); digitalWrite(IN2L, LOW);
       digitalWrite(IN3L, HIGH); digitalWrite(IN4L, LOW);
     break; 
     case 3:
       digitalWrite(IN1L, LOW); digitalWrite(IN2L, HIGH);
       digitalWrite(IN3L, HIGH); digitalWrite(IN4L, LOW);
     break; 
     case 4:
       digitalWrite(IN1L, LOW); digitalWrite(IN2L, HIGH);
       digitalWrite(IN3L, LOW); digitalWrite(IN4L, LOW);
     break; 
     case 5:
       digitalWrite(IN1L, HIGH); digitalWrite(IN2L, HIGH);
       digitalWrite(IN3L, LOW); digitalWrite(IN4L, LOW);
     break; 
     case 6:
       digitalWrite(IN1L, HIGH); digitalWrite(IN2L, LOW);
       digitalWrite(IN3L, LOW); digitalWrite(IN4L, LOW);
     break; 
     case 7:
       digitalWrite(IN1L, HIGH); digitalWrite(IN2L, LOW);
       digitalWrite(IN3L, LOW); digitalWrite(IN4L, HIGH);
     break; 
     default:
       // normally PhaseL = -1
       digitalWrite(IN1L, LOW); digitalWrite(IN2L, LOW);
       digitalWrite(IN3L, LOW); digitalWrite(IN4L, LOW);
     break; 
  }
} 

// ----------------------------------------------------------------------

void SetPhaseRight(){
  // set the right phase driver
  switch(PhaseR){
     case 0:
       digitalWrite(IN1R, LOW); digitalWrite(IN2R, LOW);
       digitalWrite(IN3R, LOW); digitalWrite(IN4R, HIGH);
     break; 
     case 1:
       digitalWrite(IN1R, LOW); digitalWrite(IN2R, LOW);
       digitalWrite(IN3R, HIGH); digitalWrite(IN4R, HIGH);
     break; 
     case 2:
       digitalWrite(IN1R, LOW); digitalWrite(IN2R, LOW);
       digitalWrite(IN3R, HIGH); digitalWrite(IN4R, LOW);
     break; 
     case 3:
       digitalWrite(IN1R, LOW); digitalWrite(IN2R, HIGH);
       digitalWrite(IN3R, HIGH); digitalWrite(IN4R, LOW);
     break; 
     case 4:
       digitalWrite(IN1R, LOW); digitalWrite(IN2R, HIGH);
       digitalWrite(IN3R, LOW); digitalWrite(IN4R, LOW);
     break; 
     case 5:
       digitalWrite(IN1R, HIGH); digitalWrite(IN2R, HIGH);
       digitalWrite(IN3R, LOW); digitalWrite(IN4R, LOW);
     break; 
     case 6:
       digitalWrite(IN1R, HIGH); digitalWrite(IN2R, LOW);
       digitalWrite(IN3R, LOW); digitalWrite(IN4R, LOW);
     break; 
     case 7:
       digitalWrite(IN1R, HIGH); digitalWrite(IN2R, LOW);
       digitalWrite(IN3R, LOW); digitalWrite(IN4R, HIGH);
     break; 
     default:
       // normally PhaseR = -1
       digitalWrite(IN1R, LOW); digitalWrite(IN2R, LOW);
       digitalWrite(IN3R, LOW); digitalWrite(IN4R, LOW);
     break; 
  }
} 

// ----------------------------------------------------------------------

void stepperOFF() {
  // stores phase as a negative number then removes power
  delay(10); // allow motor to settle before turning power OFF
  PhaseLOff = PhaseL; PhaseROff = PhaseR;
  PhaseL = -1; PhaseR = -1;
  SetPhaseLeft(); SetPhaseRight();
}

// ----------------------------------------------------------------------

void stepperON() {
  // sets phase as a positive number then applies power
  PhaseL = PhaseLOff; PhaseR = PhaseROff;
  SetPhaseLeft(); SetPhaseRight();
}

// ----------------------------------------------------------------------

void TestBackLash_0() {
  // cycle a wheel through a quarter turn and vary the applied power
  // using PWM controlled from a pot input
  // this code works, but the method is ineffective due to stiction.
  Serial.println("Task = TestBackLash_0");
  int zCnt = 0; int zDir = 1; intervalJL = 2000;
  int zPL = 0; int zPR = 0; unsigned int zPM = 0;
  nextJLMicros = micros() + intervalJL;
  while (MainTask == 31) {
    // perform the test repeated until the mode is changed
    if (zDir > 0) {
      // counting up
      zPL++;  if (zPL > 7) {zPL = 0;}
      zPR++;  if (zPR > 7) {zPR = 0;}
      zCnt++; if (zCnt > 1000) {zDir = -1;}
    } else {
      // counting down
      zPL--;  if (zPL < 0) {zPL = 7;}
      zPR--;  if (zPR < 0) {zPR = 7;}
      zCnt--; if (zCnt < 1) {zDir = 1;}
    }
    // turn drivers ON
    PhaseL = zPL; PhaseR = zPR;
    while (micros() < nextJLMicros) {} // sync mark pulse
    nextJLMicros = micros() + intervalJL;
    SetPhaseLeft(); SetPhaseRight();
    delayMicroseconds(PWMmark);
    // turn drivers OFF
    PhaseL = -1; PhaseR = -1;
    SetPhaseLeft(); SetPhaseRight();
    // check IR receiver
    if (micros() >= nextMicros) {
      // read IR receiver and pot every 20ms
      nextMicros = micros() + interval;
      switch(MinTask) {
        case 0:
          PWMmark = 100 + (2 * analogRead(potPin));
          if (zPM != PWMmark) {
            zPM = PWMmark; Serial.print("PWMmark = "); Serial.println(PWMmark);
          } MinTask++; break;
        case 1: readIR(); MinTask++; break;
        default: MinTask = 0;
      }
    }
  }
}

// ----------------------------------------------------------------------

void TestBackLash_1() {
  // cycle the drive back and forth through 'n' counts until wheel is
  // just seen to move. The pot input determines the value of 'n'
  // it is best to do one side at a time. Use // to disable a phase.
  Serial.println("Task = TestBackLash_1");
  int zCnt = 0; int zDir = 1; int zPM = 10; int zPMO = 0;
  PhaseL = 0; PhaseR = 0;
  intervalJL = 2000; // set drive rate to 2ms = 500Hz
  nextJLMicros = micros() + intervalJL;
  while (MainTask == 31) {
    // perform the test repeated until the mode is changed
    if (zDir > 0) {
      // counting up
      PhaseL++;  if (PhaseL > 7) {PhaseL = 0;}
      PhaseR++;  if (PhaseR > 7) {PhaseR = 0;}
      zCnt++; if (zCnt >= zPM) {zDir = -1;}
    } else {
      // counting down
      PhaseL--;  if (PhaseL < 0) {PhaseL = 7;}
      PhaseR--;  if (PhaseR < 0) {PhaseR = 7;}
      zCnt--; if (zCnt <= 1) {zDir = 1;}
    }
    // wait for sync timing
    while (micros() < nextJLMicros) {}
    nextJLMicros = micros() + intervalJL;
    SetPhaseLeft(); SetPhaseRight();
    // check IR receiver
    if (micros() >= nextMicros) {
      // read IR receiver and pot every 20ms
      nextMicros = micros() + interval;
      switch(MinTask) {
        case 0:
          zPM = 10 + (analogRead(potPin)/10);
          if (zPMO != zPM) {
            zPMO = zPM; Serial.print("PM = "); Serial.println(zPM);
          } MinTask++; break;
        case 1: readIR(); MinTask++; break;
        default: MinTask = 0;
      }
    }
  }
}

// ----------------------------------------------------------------------

void TestBackLash_2() {
  // use the IR remote to change the backlash figures to see if an optimum
  // value(s) can be determined emperically
  Serial.println("Task = TestBackLash_2");
  DrawDefaults();
  TurnLeft(90,0); GoForward(53); DrawLine(8);
  for (int zL = 0; zL < 5; zL++) {
    TurnRight(45,1);  DrawLine(8.48528);
    TurnRight(45,1);  DrawLine(4);
    TurnRight(45,1);  DrawLine(8.48528);
    TurnRight(45,1);  DrawLine(16);
    TurnLeft(45,1);  DrawLine(8.48528);
    TurnLeft(45,1);  DrawLine(4);
    TurnLeft(45,1);  DrawLine(8.48528);
    TurnLeft(45,1);  DrawLine(16);
  }
  DrawEnd();
}

// ----------------------------------------------------------------------

void TestCalAngle() {
  // draw calibration lines at +/- 360 degrees  
  Serial.println("Task = TestCalAngle");
  DrawDefaults();
  GoForward(4); // remove any backlash
  DrawLine(35); GoBackward(35);
  TurnLeft(360,0);
  DrawLine(30); GoBackward(30);
  TurnRight(720,0);
  DrawLine(30); GoBackward(30);
  DrawEnd();
}

// ----------------------------------------------------------------------

void TestCalLine() {
  // draw a calibrated line 20cm in length  
  Serial.println("Task = TestCalLine");
  DrawDefaults();
  GoForward(4); // remove any backlash
  DrawLine(200);
  DrawEnd();
}

// ----------------------------------------------------------------------

void TestCurves() {
  // draw a series of test curves
  Serial.println("Task = TestCurves");
  DrawDefaults();
  GoForward(4); // remove any backlash
  float zRad = 10.0;
  for (int zL = 0; zL < 8; zL++) {
    CurveLeft(zRad,360); CurveRight(zRad,360);
    zRad = zRad + 2.5;
  }
  DrawEnd();
}

// ----------------------------------------------------------------------

void TestDragWheel() {
  // tries to determine the tangental effect of the drag wheel when
  // turning left and right
  Serial.println("Task = TestDragWheel");
  DrawDefaults();
  GoForward(4); // remove any backlash
  DrawLine(35); GoBackward(35);
  for (int zL = 0; zL < 5; zL++) {
    TurnLeft(360,0);
    DrawLine(35); GoBackward(35);
  }
  TurnRight(90,0); GoForward(20); TurnLeft(90,0); 
  DrawLine(35); GoBackward(35);
  for (int zL = 0; zL < 5; zL++) {
    TurnRight(360,0);
    DrawLine(35); GoBackward(35);
  }
  DrawEnd();
}

// ----------------------------------------------------------------------

void TestPhaseSEn() {
  // observe the affects of auto PhaseSen by drawing AAA with and 
  // without backlash compensation
  Serial.println("Task = TestPhaseSEn");
  DrawDefaults();
  DrawLibChar_A(1);
  DrawLibChar_A(1);
  DrawLibChar_A(1);
  GoForward(20); PhaseSEn = 0; // turn OFF compensation
  DrawLibChar_A(1);
  DrawLibChar_A(1);
  DrawLibChar_A(1);
  DrawEnd();
}

// ----------------------------------------------------------------------

void TestPolygons() {
  // draw a series of polygons  
  Serial.println("Task = TestPolygons");
  DrawDefaults();
  PolyLeft(3,20); PolyRight(3,20);
  PolyLeft(4,22); PolyRight(4,22);
  PolyLeft(5,24); PolyRight(5,24);
  PolyLeft(6,26); PolyRight(6,26);
  PolyLeft(7,28); PolyRight(7,28);
  PolyLeft(8,30); PolyRight(8,30);
  DrawEnd();
}

// ----------------------------------------------------------------------

void translateIR() {
  // takes action based on IR code received
  Serial.print("Rx Val: 0x");
  Serial.println(irResult, HEX);
  irResult = irResult & 0xFF;
  switch(irResult) {
//  "POWER"
    case 0x4C: keyVal = 999; break;

//  "FORWARD"
    case 0x54: joyForward(); break;

//  "< LEFT"
    case 0x55: joyLeft(); break;

//  " -OK-" - duplicate key, see other entry
//    case 0x75: joyStop(); break;

//  "RIGHT >"
    case 0x56: joyRight(); break;

//  "REVERSE"
    case 0x53: joyReverse(); break;

//  "UpVol"
    case 0x50:
      ScaleAn = ScaleAn * 1.149; waitIRx();
      break;

//  "DwnVol"
    case 0x51:
      ScaleAn = ScaleAn / 1.149; waitIRx();
      break;

//  "UpProg"
    case 0x60: PhaseSEn = 1; break;

//  "DwnProg"
    case 0x61: PhaseSEn = 0; break;

//  "Red"
    case 0x77: MainMode = Mode_Red; break;

//  "Green"
    case 0x76: MainMode = Mode_Green; break;

//  "Yellow"
    case 0x72: MainTask = Mode_Yellow; break;

//  "Blue"
    case 0x74: MainMode = Mode_Blue; break;

//  "TText0"
    case 0x7C: ScaleAn = 1.0; break;

//  "TText1"
    case 0x75: if (MainTask == 50) {joyStop();}
      else {ScaleAn = 1.41;} waitIRx(); break;

//  "TText3"
    case 0x4B: ScaleAn = 2.0; break;

//  "TText4"
    case 0x4E: ScaleAn = 2.82; break;
    
//  "1"
    case 0x41: keyVal = 49; break;

//  "2"
    case 0x42: keyVal = 50; break;

//  "3"
    case 0x43: keyVal = 51; break;

//  "4"
    case 0x44: keyVal = 52; break;

//  "5"
    case 0x45: keyVal = 53; break;

//  "6"
    case 0x46: keyVal = 54; break;

//  "7"
    case 0x47: keyVal = 55; break;

//  "8"
    case 0x48: keyVal = 56; break;

//  "9"
    case 0x49: keyVal = 57; break;

//  "-/--"
    case 0x57: keyVal = 42; break;

//  "0"
    case 0x40: keyVal = 58; break;

//  "AV"
    case 0x78: keyVal = 35; break;
  }
}

// ----------------------------------------------------------------------

void translateIRNum() {
  // translate irResult into a numeric value
  irResult = irResult & 0xFF;
  switch(irResult) {
    // "1"
    case 0x41: keyNum = 1; break;
    // "2"
    case 0x42: keyNum = 2; break;
    // "3"
    case 0x43: keyNum = 3; break;
    // "4"
    case 0x44: keyNum = 4; break;
    // "5"
    case 0x45: keyNum = 5; break;
    // "6"
    case 0x46: keyNum = 6; break;
    // "7"
    case 0x47: keyNum = 7; break;
    // "8"
    case 0x48: keyNum = 8; break;
    // "9"
    case 0x49: keyNum = 9; break;
    // "0"
    case 0x40: keyNum = 0; break;
    // "-/--"
    case 0x57: keyNum = -1; break;
    default: keyNum = 999;
  }
}

// ----------------------------------------------------------------------

void waitIRx() {
  // wait until no more IR receive
  // TOTAL Control remote sends characters every 112 ms.
  int zWait = 1;
  while (zWait > 0) {
    delay(150); // allow time for next Rx if one is to occur
    if (irrecv.decode(&results)) {
      // we have received an IR signal
      irResult = results.value;
      irrecv.resume(); // ready to receive the next value
    } else {zWait = 0;}
  } irResult = 0;
}

// ----------------------------------------------------------------------





