// ######################################################################
//
//  A4 DrawBot Sketch File v0.14 Beta
//
//  Released:  08/05/2017
//
//  Author: TechKnowTone
//
// ######################################################################
/*
    This software is furnished "as is", without technical support, and
    with no warranty, expressed or implied, as to its usefulness for any
    purpose.

    Elements of this software were taken from the public domain. It uses
    libraries which must be installed on your system.

    This program controls a DrawBot and has a range of drawings selected
    using an infrared remote control. It can also be driven from the
    remote control. It can now draw n-sided polygons and arcs/circles.
    Cartesian co-ordinate drawing is now included. Direct line/shape
    drawing included under the yellow button.

    This version includes:
      Gestamp Tallent + reach robot outline
      Hitachi Rail + train outline
      UTC Robots Rock + circle outline
*/
// Declare and initialise libraries
#include "IRremote.h"
#include <Servo.h>
Servo servoLift; // Define the pen lifting servo

// Define global constants
#define axleWidth 104.04 // distance between wheels in mm
#define IN1L  6 // left stepper driver IN1 pin
#define IN1R  11 // right stepper driver IN1 pin
#define IN2L  5 // left stepper driver IN2 pin
#define IN2R  10 // right stepper driver IN2 pin
#define IN3L  4 // left stepper driver IN3 pin
#define IN3R  9 // right stepper driver IN3 pin
#define IN4L  3 // left stepper driver IN4 pin
#define IN4R  8 // right stepper driver IN4 pin
#define intCharSpc 6.0 // intercharacter spacing
#define intervalBTT 55 // brake trigger threshold
#define intervalDec 100 // rate of interval accelerate adjustment
#define intervalInc 150 // rate of interval brake adjustment
#define intervalMin 2000 // max rate for steppers
#define intervalMax 10000 // start rate for steppers
#define irDel 200 // delay between IR reads in miliseconds
#define IRPin 7 // IR receiver pin
//#define liftDwn 1781 // lift leaver pen just on paper
#define liftDwn 2418 // lift leaver pen just on paper
#define liftMax 1437 // lift leaver vertical
#define liftMin 2418 // lift leaver horizontal
#define liftUp 1437 // lift leaver pen just off paper
#define Mode_Red 0 // red mode assignment
#define Mode_Green 10 // green mode assignment
#define Mode_Yellow 20 // yellow mode assignment
#define Mode_Blue 30 // blue mode assignment
#define potPin 0 // test pin analogue input
#define servoPin 12 // assign servo pin
#define servoWait 200 // delay allowed for servo movement in milliseconds
#define wheelDia 68.35 // wheel diameter in mm

// Declare and initialise global variables
int anyCnt = 0; // any temp counter value
int anyD = 0; // any temp value
float anyF = 0.0; // any temp value
long anyL = 0; // any temp value
int anyV = 0; // any temp value
int Brake = 0; // if > 0 then slow down drawing
float CartAng  = 0.0; // angle related to the origin
float CartAngRef  = 0.0; // saved angle related to the origin
int CartF = 0;  // origin is set, 0 = NO, 1 = YES
float CartX = 0.0; // distance from X origin
float CartXRef = 0.0; // saved distance from X origin
float CartY = 0.0; // distance from Y origin
float CartYRef = 0.0; // saved distance from Y origin
int drawDir = 0; // direction to draw in direct draw mode
int drawEn = 0; // must be 1 for draw action to occur
float drawLen = 0.0; // distance to draw in direct draw mode
int drawMode = 0; // direct drawing mode
unsigned long interval = 1000; // step interval in micros
unsigned long intervalJC = 10000; // combined average step interval in micros
unsigned long intervalJL = 10000; // joy left step interval in micros
unsigned long intervalJR = 10000; // joy right step interval in micros
int irEn = 0; // IR read enable, 0 = OFF, 1 = ON
long irResult; // IR value received
int joyKey = 0; // value used to delay steering response
int keyDel = 0; // delay between reading keyboard in miliseconds
int keyNum; // numeric value read IR remote
int keyVal; // input value read from serial port or IR translation
int MainCnt = 0; // main loop count down counter
unsigned long MainInterval = 1000; // main loop interval in micros
int MainMode = 0; // main loop task grouping 0, 10, 20, 30
int MainTask = -1; // main loop task pointer
int MinTask = 0; // main loop background task pointer
unsigned long nextJLMicros = micros(); // target joy step delay in micros
unsigned long nextJRMicros = micros(); // target joy step delay in micros
unsigned long nextMicros = micros(); // target step delay in micros
int penDrawMode = 1; // pen drawing mode
int PhaseDirL = 0; // phase direction, -1, 0, 1
int PhaseDirR = 0; // phase direction, -1, 0, 1
int PhaseL = -1; // left phase value 0 - 7
int PhaseLOff = PhaseL; // left phase at Stepper OFF
int PhaseLSlack = 25; // left wheel gearbox slack in steps
int PhaseR = -1; // right phase value 0 - 7
int PhaseROff = PhaseR; // right phase at Stepper OFF
int PhaseRSlack = 54; // right wheel gearbox slack in steps
int PhaseSEn = 1; // backlash removal, 1 = ON, 0 - OFF
unsigned int PWMmark = 500; // backlash pulse width
float ScaleAn = 1.0; // scale factor for A4 - A1 paper sizes
float ScaleXY = 1.0; // scale factor for all linear movements
int servoEn = 0; // servo ON/OFF flag, 0 = OFF, 1 = ON
int servoVal = 0; // value sent to the servo
unsigned long readMicros = micros(); // latest micros read

// Declare objects
IRrecv irrecv(IRPin);  // create instance of 'irrecv'
decode_results results;   // create instance of 'decode_results'

void setup() {
  // put your setup code here, to run once:
  setDefaults();
  pinMode(IN1L, OUTPUT); pinMode(IN1R, OUTPUT);
  pinMode(IN2L, OUTPUT); pinMode(IN2R, OUTPUT);
  pinMode(IN3L, OUTPUT); pinMode(IN3R, OUTPUT);
  pinMode(IN4L, OUTPUT); pinMode(IN4R, OUTPUT);
  SetPhaseLeft(); SetPhaseRight(); // turn drivers OFF
  Serial.begin(9600);
  runPOST();
  irrecv.enableIRIn(); // initialise IR receiver
}

void loop() {
  // the main loop either runs a task or waits for input
  switch(MainTask) {
    case 0: Draw0(); break;
    case 1: Draw1(); break;
    case 2: Draw2(); break;
    case 3: Draw3(); break;
    case 4: Draw4(); break;
    case 5: Draw5(); break;
    case 6: Draw6(); break;
    case 7: Draw7(); break;
    case 8: Draw8(); break;
    case 9: Draw9(); break;
    
    case 20: DrawShapes(); break;

    case 31: TestPhaseSEn(); break;
    case 32: TestCalLine(); break;
    case 33: TestCalAngle(); break;
    case 34: TestPolygons(); break;
    case 35: TestCurves(); break;
    case 36: TestBackLash_2(); break;
    case 37: TestDragWheel(); break;

    case 50: joyTask(); break;
    default:
      MainTask = -1; interval = 1000;
      nextMicros = micros() + MainInterval;
  }
  while (micros() < nextMicros) {
    // whilst waiting for a new task read ports
    switch(MinTask) {
      case 0: readSerial(); MinTask++; break;
      case 1: readIR(); MinTask++; break;
      default: MinTask = 0;
    }
  } nextMicros = nextMicros + MainInterval;
  MainCnt--; if (MainCnt < 1) {MainCnt = 1000; Serial.println("#");}
}

// ----------------------------------------------------------------------





