/*
  This tab contains definitions of all of the characters used in the cube
  Characters are defined by an 8-byte array
  The array reference sets the vertical reference. ie. 0 = top row, Y = 0
  Bits in the byte define whether pixels are 1 = ON, 0 = OFF, X0 = MSB, X7 = LSB
  For each character the width GW and height GH are also specified 
*/

void loadChar(uint8_t zC) {
  // loads 8 bytes into the character array for use in graphics
  switch(zC) {
    case  0:  // < - task selection
      GC[0] = 0b00000000; GC[1] = 0b00010000; GC[2] = 0b00100000; GC[3] = 0b01000000;
      GC[4] = 0b01000000; GC[5] = 0b00100000; GC[6] = 0b00010000; GC[7] = 0b00000000;
      GW = 4; GH = 7; break;
    case  1:  // > - task selection
      GC[0] = 0b00000000; GC[1] = 0b10000000; GC[2] = 0b01000000; GC[3] = 0b00100000;
      GC[4] = 0b00100000; GC[5] = 0b01000000; GC[6] = 0b10000000; GC[7] = 0b00000000;
      GW = 4; GH = 7; break;
    case  2:  // |< - goto first task selection
      GC[0] = 0b00000000; GC[1] = 0b10010000; GC[2] = 0b10100000; GC[3] = 0b11000000;
      GC[4] = 0b11000000; GC[5] = 0b10100000; GC[6] = 0b10010000; GC[7] = 0b00000000;
      GW = 4; GH = 7; break;
    case  3:  // >| - goto last task selection
      GC[0] = 0b00000000; GC[1] = 0b10010000; GC[2] = 0b01010000; GC[3] = 0b00110000;
      GC[4] = 0b00110000; GC[5] = 0b01010000; GC[6] = 0b10010000; GC[7] = 0b00000000;
      GW = 4; GH = 7; break;
    case  4:  // [.]
      GC[0] = 0b00100100;
      GC[1] = 0b01100110;
      GC[2] = 0b11100111;
      GC[3] = 0b00011000;
      GC[4] = 0b00011000;
      GC[5] = 0b11100111;
      GC[6] = 0b01100110;
      GC[7] = 0b00100100;
      GW = 8; GH = 7; break;
    case  5:  // [:]
      GC[0] = 0b11100111;
      GC[1] = 0b11000011;
      GC[2] = 0b10000001;
      GC[3] = 0b00011000;
      GC[4] = 0b00011000;
      GC[5] = 0b10000001;
      GC[6] = 0b11000011;
      GC[7] = 0b11100111;
      GW = 8; GH = 7; break;

    case 32:  // SPACE
      GC[0] = 0b00000000;
      GC[1] = 0b00000000;
      GC[2] = 0b00000000;
      GC[3] = 0b00000000;
      GC[4] = 0b00000000;
      GC[5] = 0b00000000;
      GC[6] = 0b00000000;
      GC[7] = 0b00000000;
      GW = 5; GH = 7; break;
    case 33:  // !
      GC[0] = 0b10000000; GC[1] = 0b10000000; GC[2] = 0b10000000; GC[3] = 0b10000000;
      GC[4] = 0b00000000; GC[5] = 0b00000000; GC[6] = 0b10000000; GC[7] = 0b00000000;
      GW = 1; GH = 7; break;
    case 34:  // "
      GC[0] = 0b10100000; GC[1] = 0b10100000; GC[2] = 0b10100000; GC[3] = 0b00000000;
      GC[4] = 0b00000000; GC[5] = 0b00000000; GC[6] = 0b00000000; GC[7] = 0b00000000;
      GW = 3; GH = 7; break;
    case 35:  // #
      GC[0] = 0b01010000; GC[1] = 0b01010000; GC[2] = 0b11111000; GC[3] = 0b01010000;
      GC[4] = 0b11111000; GC[5] = 0b01010000; GC[6] = 0b01010000; GC[7] = 0b00000000;
      GW = 5; GH = 7; break;
    case 36:  // $
      GC[0] = 0b00100000; GC[1] = 0b01111000; GC[2] = 0b10100000; GC[3] = 0b01110000;
      GC[4] = 0b00101000; GC[5] = 0b11110000; GC[6] = 0b00100000; GC[7] = 0b00000000;
      GW = 5; GH = 7; break;
    case 37:  // %
      GC[0] = 0b11000000; GC[1] = 0b11000100; GC[2] = 0b00001000; GC[3] = 0b00010000;
      GC[4] = 0b00100000; GC[5] = 0b01000000; GC[6] = 0b10011000; GC[7] = 0b00011000;
      GW = 5; GH = 7; break;
    case 38:  // &
      GC[0] = 0b01100000; GC[1] = 0b10010000; GC[2] = 0b10100000; GC[3] = 0b01000000;
      GC[4] = 0b10101000; GC[5] = 0b10010000; GC[6] = 0b01101000; GC[7] = 0b00000000;
      GW = 5; GH = 7; break;
    case 39:  // '
      GC[0] = 0b11000000; GC[1] = 0b01000000; GC[2] = 0b10000000; GC[3] = 0b00000000;
      GC[4] = 0b00000000; GC[5] = 0b00000000; GC[6] = 0b00000000; GC[7] = 0b00000000;
      GW = 2; GH = 7; break;
    case 40:  // (
      GC[0] = 0b00100000; GC[1] = 0b01000000; GC[2] = 0b10000000; GC[3] = 0b10000000;
      GC[4] = 0b10000000; GC[5] = 0b01000000; GC[6] = 0b00100000; GC[7] = 0b00000000;
      GW = 3; GH = 7; break;
    case 41:  // )
      GC[0] = 0b10000000; GC[1] = 0b01000000; GC[2] = 0b00100000; GC[3] = 0b00100000;
      GC[4] = 0b00100000; GC[5] = 0b01000000; GC[6] = 0b10000000; GC[7] = 0b00000000;
      GW = 3; GH = 7; break;
    case 42:  // *
      GC[0] = 0b00000000; GC[1] = 0b00100000; GC[2] = 0b10101000; GC[3] = 0b01110000;
      GC[4] = 0b10101000; GC[5] = 0b00100000; GC[6] = 0b00000000; GC[7] = 0b00000000;
      GW = 5; GH = 7; break;
    case 43:  // +
      GC[0] = 0b00000000; GC[1] = 0b00100000; GC[2] = 0b00100000; GC[3] = 0b11111000;
      GC[4] = 0b00100000; GC[5] = 0b00100000; GC[6] = 0b00000000; GC[7] = 0b00000000;
      GW = 5; GH = 7; break;
    case 44:  // ,
      GC[0] = 0b00000000; GC[1] = 0b00000000; GC[2] = 0b00000000; GC[3] = 0b00000000;
      GC[4] = 0b00000000; GC[5] = 0b11000000; GC[6] = 0b01000000; GC[7] = 0b10000000;
      GW = 2; GH = 7; break;
    case 45:  // -
      GC[0] = 0b00000000; GC[1] = 0b00000000; GC[2] = 0b00000000; GC[3] = 0b11111000;
      GC[4] = 0b00000000; GC[5] = 0b00000000; GC[6] = 0b00000000; GC[7] = 0b00000000;
      GW = 5; GH = 7; break;
    case 46:  // .
      GC[0] = 0b00000000; GC[1] = 0b00000000; GC[2] = 0b00000000; GC[3] = 0b00000000;
      GC[4] = 0b00000000; GC[5] = 0b00000000; GC[6] = 0b11000000; GC[7] = 0b11000000;
      GW = 2; GH = 7; break;
    case 47:  // /
      GC[0] = 0b00000000; GC[1] = 0b00001000; GC[2] = 0b00010000; GC[3] = 0b00100000;
      GC[4] = 0b01000000; GC[5] = 0b10000000; GC[6] = 0b00000000; GC[7] = 0b00000000;
      GW = 5; GH = 7; break;

    case 48:  // 0
      GC[0] = 0b01110000; GC[1] = 0b10001000; GC[2] = 0b10011000; GC[3] = 0b10101000;
      GC[4] = 0b11001000; GC[5] = 0b10001000; GC[6] = 0b01110000; GC[7] = 0b00000000;
      GW = 5; GH = 7; break;
    case 49:  // 1
      GC[0] = 0b00100000; GC[1] = 0b01100000; GC[2] = 0b10100000; GC[3] = 0b00100000;
      GC[4] = 0b00100000; GC[5] = 0b00100000; GC[6] = 0b11111000; GC[7] = 0b00000000;
      GW = 5; GH = 7; break;
    case 50:  // 2
      GC[0] = 0b01110000; GC[1] = 0b10001000; GC[2] = 0b00001000; GC[3] = 0b00110000;
      GC[4] = 0b01000000; GC[5] = 0b10000000; GC[6] = 0b11111000; GC[7] = 0b00000000;
      GW = 5; GH = 7; break;
    case 51:  // 3
      GC[0] = 0b01110000; GC[1] = 0b10001000; GC[2] = 0b00001000; GC[3] = 0b00110000;
      GC[4] = 0b00001000; GC[5] = 0b10001000; GC[6] = 0b01110000; GC[7] = 0b00000000;
      GW = 5; GH = 7; break;
    case 52:  // 4
      GC[0] = 0b00010000; GC[1] = 0b00110000; GC[2] = 0b01010000; GC[3] = 0b10010000;
      GC[4] = 0b11111000; GC[5] = 0b00010000; GC[6] = 0b00010000; GC[7] = 0b00000000;
      GW = 5; GH = 7; break;
    case 53:  // 5
      GC[0] = 0b11111000; GC[1] = 0b10000000; GC[2] = 0b11110000; GC[3] = 0b00001000;
      GC[4] = 0b00001000; GC[5] = 0b10001000; GC[6] = 0b01110000; GC[7] = 0b00000000;
      GW = 5; GH = 7; break;
    case 54:  // 6
      GC[0] = 0b00110000; GC[1] = 0b01000000; GC[2] = 0b10000000; GC[3] = 0b11110000;
      GC[4] = 0b10001000; GC[5] = 0b10001000; GC[6] = 0b01110000; GC[7] = 0b00000000;
      GW = 5; GH = 7; break;
    case 55:  // 7
      GC[0] = 0b11111000; GC[1] = 0b00001000; GC[2] = 0b00010000; GC[3] = 0b00100000;
      GC[4] = 0b01000000; GC[5] = 0b01000000; GC[6] = 0b01000000; GC[7] = 0b00000000;
      GW = 5; GH = 7; break;
    case 56:  // 8
      GC[0] = 0b01110000; GC[1] = 0b10001000; GC[2] = 0b10001000; GC[3] = 0b01110000;
      GC[4] = 0b10001000; GC[5] = 0b10001000; GC[6] = 0b01110000; GC[7] = 0b00000000;
      GW = 5; GH = 7; break;
    case 57:  // 9
      GC[0] = 0b01110000; GC[1] = 0b10001000; GC[2] = 0b10001000; GC[3] = 0b01111000;
      GC[4] = 0b00001000; GC[5] = 0b00010000; GC[6] = 0b01100000; GC[7] = 0b00000000;
      GW = 5; GH = 7; break;
      
    case 58:  // :
      GC[0] = 0b00000000; GC[1] = 0b10000000; GC[2] = 0b10000000; GC[3] = 0b00000000;
      GC[4] = 0b10000000; GC[5] = 0b10000000; GC[6] = 0b00000000; GC[7] = 0b00000000;
      GW = 1; GH = 7; break;
    case 59:  // ;
      GC[0] = 0b00000000; GC[1] = 0b00000000; GC[2] = 0b00000000; GC[3] = 0b01000000;
      GC[4] = 0b00000000; GC[5] = 0b01000000; GC[6] = 0b01000000; GC[7] = 0b10000000;
      GW = 2; GH = 7; break;
    case 60:  // <
      GC[0] = 0b00100000; GC[1] = 0b01000000; GC[2] = 0b10000000; GC[3] = 0b10000000;
      GC[4] = 0b10000000; GC[5] = 0b01000000; GC[6] = 0b00100000; GC[7] = 0b00000000;
      GW = 3; GH = 7; break;
    case 61:  // =
      GC[0] = 0b00000000; GC[1] = 0b00000000; GC[2] = 0b11100000; GC[3] = 0b00000000;
      GC[4] = 0b11100000; GC[5] = 0b00000000; GC[6] = 0b00000000; GC[7] = 0b00000000;
      GW = 3; GH = 7; break;
    case 62:  // >
      GC[0] = 0b10000000; GC[1] = 0b01000000; GC[2] = 0b00100000; GC[3] = 0b00100000;
      GC[4] = 0b00100000; GC[5] = 0b01000000; GC[6] = 0b10000000; GC[7] = 0b00000000;
      GW = 3; GH = 7; break;
    case 63:  // ?
      GC[0] = 0b01110000; GC[1] = 0b10001000; GC[2] = 0b00001000; GC[3] = 0b00010000;
      GC[4] = 0b00100000; GC[5] = 0b00000000; GC[6] = 0b00100000; GC[7] = 0b00000000;
      GW = 5; GH = 7; break;
    case 64:  // @
      GC[0] = 0b01110000; GC[1] = 0b10001000; GC[2] = 0b10111000; GC[3] = 0b10101000;
      GC[4] = 0b10111000; GC[5] = 0b10000000; GC[6] = 0b01110000; GC[7] = 0b00000000;
      GW = 5; GH = 7; break;

    case 65:  // A
      GC[0] = 0b01110000; GC[1] = 0b10001000; GC[2] = 0b10001000; GC[3] = 0b10001000;
      GC[4] = 0b11111000; GC[5] = 0b10001000; GC[6] = 0b10001000; GC[7] = 0b00000000;
      GW = 5; GH = 7; break;
    case 66:  // B
      GC[0] = 0b11110000; GC[1] = 0b10001000; GC[2] = 0b10001000; GC[3] = 0b11110000;
      GC[4] = 0b10001000; GC[5] = 0b10001000; GC[6] = 0b11110000; GC[7] = 0b00000000;
      GW = 5; GH = 7; break;
    case 67:  // C
      GC[0] = 0b01110000; GC[1] = 0b10001000; GC[2] = 0b10000000; GC[3] = 0b10000000;
      GC[4] = 0b10000000; GC[5] = 0b10001000; GC[6] = 0b01110000; GC[7] = 0b00000000;
      GW = 5; GH = 7; break;
    case 68:  // D
      GC[0] = 0b11100000; GC[1] = 0b10010000;
      GC[2] = 0b10001000; GC[3] = 0b10001000;
      GC[4] = 0b10001000; GC[5] = 0b10010000;
      GC[6] = 0b11100000; GC[7] = 0b00000000;
      GW = 5; GH = 7; break;
    case 69:  // E
      GC[0] = 0b11111000; GC[1] = 0b10000000; GC[2] = 0b10000000; GC[3] = 0b11110000;
      GC[4] = 0b10000000; GC[5] = 0b10000000; GC[6] = 0b11111000; GC[7] = 0b00000000;
      GW = 5; GH = 7; break;
    case 70:  // F
      GC[0] = 0b11111000; GC[1] = 0b10000000; GC[2] = 0b10000000; GC[3] = 0b11110000;
      GC[4] = 0b10000000; GC[5] = 0b10000000; GC[6] = 0b10000000; GC[7] = 0b00000000;
      GW = 5; GH = 7; break;
    case 71:  // G
      GC[0] = 0b01110000; GC[1] = 0b10001000; GC[2] = 0b10000000; GC[3] = 0b10111000;
      GC[4] = 0b10001000; GC[5] = 0b10001000; GC[6] = 0b01111000; GC[7] = 0b00000000;
      GW = 5; GH = 7; break;
    case 72:  // H
      GC[0] = 0b10001000; GC[1] = 0b10001000; GC[2] = 0b10001000; GC[3] = 0b11111000;
      GC[4] = 0b10001000; GC[5] = 0b10001000; GC[6] = 0b10001000; GC[7] = 0b00000000;
      GW = 5; GH = 7; break;
    case 73:  // I
      GC[0] = 0b11100000; GC[1] = 0b01000000; GC[2] = 0b01000000; GC[3] = 0b01000000;
      GC[4] = 0b01000000; GC[5] = 0b01000000; GC[6] = 0b11100000; GC[7] = 0b00000000;
      GW = 3; GH = 7; break;
    case 74:  // J
      GC[0] = 0b00111000; GC[1] = 0b00010000; GC[2] = 0b00010000; GC[3] = 0b00010000;
      GC[4] = 0b10010000; GC[5] = 0b10010000; GC[6] = 0b01100000; GC[7] = 0b00000000;
      GW = 5; GH = 7; break;
    case 75:  // K
      GC[0] = 0b10001000; GC[1] = 0b10010000; GC[2] = 0b10100000; GC[3] = 0b11000000;
      GC[4] = 0b10100000; GC[5] = 0b10010000; GC[6] = 0b10001000; GC[7] = 0b00000000;
      GW = 5; GH = 7; break;
    case 76:  // L
      GC[0] = 0b10000000; GC[1] = 0b10000000; GC[2] = 0b10000000; GC[3] = 0b10000000;
      GC[4] = 0b10000000; GC[5] = 0b10000000; GC[6] = 0b11111000; GC[7] = 0b00000000;
      GW = 5; GH = 7; break;
    case 77:  // M
      GC[0] = 0b10001000; GC[1] = 0b11011000; GC[2] = 0b10101000; GC[3] = 0b10001000;
      GC[4] = 0b10001000; GC[5] = 0b10001000; GC[6] = 0b10001000; GC[7] = 0b00000000;
      GW = 5; GH = 7; break;
    case 78:  // N
      GC[0] = 0b10001000; GC[1] = 0b10001000; GC[2] = 0b11001000; GC[3] = 0b10101000;
      GC[4] = 0b10011000; GC[5] = 0b10001000; GC[6] = 0b10001000; GC[7] = 0b00000000;
      GW = 5; GH = 7; break;
    case 79:  // O
      GC[0] = 0b01110000; GC[1] = 0b10001000; GC[2] = 0b10001000; GC[3] = 0b10001000;
      GC[4] = 0b10001000; GC[5] = 0b10001000; GC[6] = 0b01110000; GC[7] = 0b00000000;
      GW = 5; GH = 7; break;
    case 80:  // P
      GC[0] = 0b11110000; GC[1] = 0b10001000; GC[2] = 0b10001000; GC[3] = 0b11110000;
      GC[4] = 0b10000000; GC[5] = 0b10000000; GC[6] = 0b10000000; GC[7] = 0b00000000;
      GW = 5; GH = 7; break;
    case 81:  // Q
      GC[0] = 0b01110000; GC[1] = 0b10001000; GC[2] = 0b10001000; GC[3] = 0b10001000;
      GC[4] = 0b10001000; GC[5] = 0b10101000; GC[6] = 0b01110000; GC[7] = 0b00001000;
      GW = 5; GH = 7; break;
    case 82:  // R
      GC[0] = 0b11110000; GC[1] = 0b10001000; GC[2] = 0b10001000; GC[3] = 0b11110000;
      GC[4] = 0b10100000; GC[5] = 0b10010000; GC[6] = 0b10001000; GC[7] = 0b00000000;
      GW = 5; GH = 7; break;
    case 83:  // S
      GC[0] = 0b01110000; GC[1] = 0b10001000; GC[2] = 0b10000000; GC[3] = 0b01110000;
      GC[4] = 0b00001000; GC[5] = 0b10001000; GC[6] = 0b01110000; GC[7] = 0b00000000;
      GW = 5; GH = 7; break;
    case 84:  // T
      GC[0] = 0b11111000; GC[1] = 0b00100000; GC[2] = 0b00100000; GC[3] = 0b00100000;
      GC[4] = 0b00100000; GC[5] = 0b00100000; GC[6] = 0b00100000; GC[7] = 0b00000000;
      GW = 5; GH = 7; break;
    case 85:  // U
      GC[0] = 0b10001000; GC[1] = 0b10001000; GC[2] = 0b10001000; GC[3] = 0b10001000;
      GC[4] = 0b10001000; GC[5] = 0b10001000; GC[6] = 0b01110000; GC[7] = 0b00000000;
      GW = 5; GH = 7; break;
    case 86:  // V
      GC[0] = 0b10001000; GC[1] = 0b10001000; GC[2] = 0b10001000; GC[3] = 0b10001000;
      GC[4] = 0b10001000; GC[5] = 0b01010000; GC[6] = 0b00100000; GC[7] = 0b00000000;
      GW = 5; GH = 7; break;
    case 87:  // W
      GC[0] = 0b10001000; GC[1] = 0b10001000; GC[2] = 0b10001000; GC[3] = 0b10101000;
      GC[4] = 0b10101000; GC[5] = 0b10101000; GC[6] = 0b01010000; GC[7] = 0b00000000;
      GW = 5; GH = 7; break;
    case 88:  // X
      GC[0] = 0b10001000; GC[1] = 0b10001000; GC[2] = 0b01010000; GC[3] = 0b00100000;
      GC[4] = 0b01010000; GC[5] = 0b10001000; GC[6] = 0b10001000; GC[7] = 0b00000000;
      GW = 5; GH = 7; break;
    case 89:  // Y
      GC[0] = 0b10001000; GC[1] = 0b10001000; GC[2] = 0b01010000; GC[3] = 0b00100000;
      GC[4] = 0b00100000; GC[5] = 0b00100000; GC[6] = 0b00100000; GC[7] = 0b00000000;
      GW = 5; GH = 7; break;
    case 90:  // Z
      GC[0] = 0b11111000; GC[1] = 0b00001000; GC[2] = 0b00010000; GC[3] = 0b00100000;
      GC[4] = 0b01000000; GC[5] = 0b10000000; GC[6] = 0b11111000; GC[7] = 0b00000000;
      GW = 5; GH = 7; break;

    case 91:  // [
      GC[0] = 0b11100000; GC[1] = 0b10000000; GC[2] = 0b10000000; GC[3] = 0b10000000;
      GC[4] = 0b10000000; GC[5] = 0b10000000; GC[6] = 0b11100000; GC[7] = 0b00000000;
      GW = 3; GH = 7; break;
    case 92:  // forward slash
      GC[0] = 0b00000000; GC[1] = 0b10000000; GC[2] = 0b01000000; GC[3] = 0b00100000;
      GC[4] = 0b00010000; GC[5] = 0b00001000; GC[6] = 0b00000000; GC[7] = 0b00000000;
      GW = 5; GH = 7; break;
    case 93:  // ]
      GC[0] = 0b11100000; GC[1] = 0b00100000; GC[2] = 0b00100000; GC[3] = 0b00100000;
      GC[4] = 0b00100000; GC[5] = 0b00100000; GC[6] = 0b11100000; GC[7] = 0b00000000;
      GW = 3; GH = 7; break;
    case 94:  // ^
      GC[0] = 0b00100000; GC[1] = 0b01010000; GC[2] = 0b10001000; GC[3] = 0b00000000;
      GC[4] = 0b00000000; GC[5] = 0b00000000; GC[6] = 0b00000000; GC[7] = 0b00000000;
      GW = 5; GH = 7; break;
    case 95:  // _
      GC[0] = 0b00000000; GC[1] = 0b00000000; GC[2] = 0b00000000; GC[3] = 0b00000000;
      GC[4] = 0b00000000; GC[5] = 0b00000000; GC[6] = 0b11111000; GC[7] = 0b00000000;
      GW = 5; GH = 7; break;
    case 96:  // '
      GC[0] = 0b10000000; GC[1] = 0b01000000; GC[2] = 0b00000000; GC[3] = 0b00000000;
      GC[4] = 0b00000000; GC[5] = 0b00000000; GC[6] = 0b00000000; GC[7] = 0b00000000;
      GW = 2; GH = 7; break;

    case 97:  // a
      GC[0] = 0b00000000; GC[1] = 0b00000000; GC[2] = 0b01110000; GC[3] = 0b00001000;
      GC[4] = 0b01111000; GC[5] = 0b10001000; GC[6] = 0b01111000; GC[7] = 0b00000000;
      GW = 5; GH = 7; break;
    case 98:  // b
      GC[0] = 0b10000000; GC[1] = 0b10000000; GC[2] = 0b11110000; GC[3] = 0b10001000;
      GC[4] = 0b10001000; GC[5] = 0b10001000; GC[6] = 0b11110000; GC[7] = 0b00000000;
      GW = 5; GH = 7; break;
    case 99:  // c
      GC[0] = 0b00000000; GC[1] = 0b00000000; GC[2] = 0b01110000; GC[3] = 0b10001000;
      GC[4] = 0b10000000; GC[5] = 0b10000000; GC[6] = 0b01111000; GC[7] = 0b00000000;
      GW = 5; GH = 7; break;
    case 100:  // d
      GC[0] = 0b00001000; GC[1] = 0b00001000; GC[2] = 0b01111000; GC[3] = 0b10001000;
      GC[4] = 0b10001000; GC[5] = 0b10001000; GC[6] = 0b01111000; GC[7] = 0b00000000;
      GW = 5; GH = 7; break;
    case 101:  // e
      GC[0] = 0b00000000; GC[1] = 0b00000000; GC[2] = 0b01110000; GC[3] = 0b10001000;
      GC[4] = 0b11111000; GC[5] = 0b10000000; GC[6] = 0b01111000; GC[7] = 0b00000000;
      GW = 5; GH = 7; break;
    case 102:  // f
      GC[0] = 0b00110000; GC[1] = 0b01000000; GC[2] = 0b11100000; GC[3] = 0b01000000;
      GC[4] = 0b01000000; GC[5] = 0b01000000; GC[6] = 0b01000000; GC[7] = 0b00000000;
      GW = 4; GH = 7; break;
    case 103:  // g
      GC[0] = 0b00000000; GC[1] = 0b00000000; GC[2] = 0b01110000; GC[3] = 0b10001000;
      GC[4] = 0b10001000; GC[5] = 0b01111000; GC[6] = 0b00001000; GC[7] = 0b11110000;
      GW = 5; GH = 7; break;
    case 104:  // h
      GC[0] = 0b10000000; GC[1] = 0b10000000; GC[2] = 0b11110000; GC[3] = 0b10001000;
      GC[4] = 0b10001000; GC[5] = 0b10001000; GC[6] = 0b10001000; GC[7] = 0b00000000;
      GW = 5; GH = 7; break;
    case 105:  // i
      GC[0] = 0b01000000; GC[1] = 0b00000000; GC[2] = 0b11000000; GC[3] = 0b01000000;
      GC[4] = 0b01000000; GC[5] = 0b01000000; GC[6] = 0b11100000; GC[7] = 0b00000000;
      GW = 3; GH = 7; break;
    case 106:  // j
      GC[0] = 0b00010000; GC[1] = 0b00000000; GC[2] = 0b00110000; GC[3] = 0b00010000;
      GC[4] = 0b00010000; GC[5] = 0b00010000; GC[6] = 0b10010000; GC[7] = 0b01100000;
      GW = 4; GH = 7; break;
    case 107:  // k
      GC[0] = 0b10000000; GC[1] = 0b10000000; GC[2] = 0b10010000; GC[3] = 0b10100000;
      GC[4] = 0b11000000; GC[5] = 0b10100000; GC[6] = 0b10010000; GC[7] = 0b00000000;
      GW = 4; GH = 7; break;
    case 108:  // l
      GC[0] = 0b11000000; GC[1] = 0b01000000; GC[2] = 0b01000000; GC[3] = 0b01000000;
      GC[4] = 0b01000000; GC[5] = 0b01000000; GC[6] = 0b11100000; GC[7] = 0b00000000;
      GW = 3; GH = 7; break;
    case 109:  // m
      GC[0] = 0b00000000; GC[1] = 0b00000000; GC[2] = 0b11110000; GC[3] = 0b10101000;
      GC[4] = 0b10101000; GC[5] = 0b10101000; GC[6] = 0b10101000; GC[7] = 0b00000000;
      GW = 5; GH = 7; break;
    case 110:  // n
      GC[0] = 0b00000000; GC[1] = 0b00000000; GC[2] = 0b11110000; GC[3] = 0b10001000;
      GC[4] = 0b10001000; GC[5] = 0b10001000; GC[6] = 0b10001000; GC[7] = 0b00000000;
      GW = 5; GH = 7; break;
    case 111:  // o
      GC[0] = 0b00000000; GC[1] = 0b00000000; GC[2] = 0b01110000; GC[3] = 0b10001000;
      GC[4] = 0b10001000; GC[5] = 0b10001000; GC[6] = 0b01110000; GC[7] = 0b00000000;
      GW = 5; GH = 7; break;
    case 112:  // p
      GC[0] = 0b00000000; GC[1] = 0b00000000; GC[2] = 0b11110000; GC[3] = 0b10001000;
      GC[4] = 0b10001000; GC[5] = 0b11110000; GC[6] = 0b10000000; GC[7] = 0b10000000;
      GW = 5; GH = 7; break;
    case 113:  // q
      GC[0] = 0b00000000; GC[1] = 0b00000000; GC[2] = 0b00000000; GC[3] = 0b01111000;
      GC[4] = 0b10001000; GC[5] = 0b10001000; GC[6] = 0b01111000; GC[7] = 0b00001000;
      GW = 5; GH = 7; break;
    case 114:  // r
      GC[0] = 0b00000000; GC[1] = 0b00000000; GC[2] = 0b10110000; GC[3] = 0b01001000;
      GC[4] = 0b01000000; GC[5] = 0b01000000; GC[6] = 0b01000000; GC[7] = 0b00000000;
      GW = 5; GH = 7; break;
    case 115:  // s
      GC[0] = 0b00000000; GC[1] = 0b00000000; GC[2] = 0b01111000; GC[3] = 0b10000000;
      GC[4] = 0b01110000; GC[5] = 0b00001000; GC[6] = 0b11110000; GC[7] = 0b00000000;
      GW = 5; GH = 7; break;
    case 116:  // t
      GC[0] = 0b01000000; GC[1] = 0b01000000; GC[2] = 0b11100000; GC[3] = 0b01000000;
      GC[4] = 0b01000000; GC[5] = 0b01000000; GC[6] = 0b00110000; GC[7] = 0b00000000;
      GW = 4; GH = 7; break;
    case 117:  // u
      GC[0] = 0b00000000; GC[1] = 0b00000000; GC[2] = 0b10001000; GC[3] = 0b10001000;
      GC[4] = 0b10001000; GC[5] = 0b10001000; GC[6] = 0b01111000; GC[7] = 0b00000000;
      GW = 5; GH = 7; break;
    case 118:  // v
      GC[0] = 0b00000000; GC[1] = 0b00000000; GC[2] = 0b10001000; GC[3] = 0b10001000;
      GC[4] = 0b01010000; GC[5] = 0b01010000; GC[6] = 0b00100000; GC[7] = 0b00000000;
      GW = 5; GH = 7; break;
    case 119:  // w
      GC[0] = 0b00000000; GC[1] = 0b00000000; GC[2] = 0b10101000; GC[3] = 0b10101000;
      GC[4] = 0b10101000; GC[5] = 0b10101000; GC[6] = 0b01010000; GC[7] = 0b00000000;
      GW = 5; GH = 7; break;
    case 120:  // x
      GC[0] = 0b00000000; GC[1] = 0b00000000; GC[2] = 0b10001000; GC[3] = 0b01010000;
      GC[4] = 0b00100000; GC[5] = 0b01010000; GC[6] = 0b10001000; GC[7] = 0b00000000;
      GW = 5; GH = 7; break;
    case 121:  // y
      GC[0] = 0b00000000; GC[1] = 0b00000000; GC[2] = 0b10001000; GC[3] = 0b10001000;
      GC[4] = 0b10001000; GC[5] = 0b01111000; GC[6] = 0b00001000; GC[7] = 0b01110000;
      GW = 5; GH = 7; break;
    case 122:  // z
      GC[0] = 0b00000000; GC[1] = 0b00000000; GC[2] = 0b11111000; GC[3] = 0b00010000;
      GC[4] = 0b00100000; GC[5] = 0b01000000; GC[6] = 0b11111000; GC[7] = 0b00000000;
      GW = 5; GH = 7; break;
      
    case 123:  // {
      GC[0] = 0b00110000; GC[1] = 0b01000000; GC[2] = 0b01000000; GC[3] = 0b10000000;
      GC[4] = 0b01000000; GC[5] = 0b01000000; GC[6] = 0b00110000; GC[7] = 0b00000000;
      GW = 4; GH = 7; break;
    case 124:  // |
      GC[0] = 0b10000000; GC[1] = 0b10000000; GC[2] = 0b10000000; GC[3] = 0b00000000;
      GC[4] = 0b10000000; GC[5] = 0b10000000; GC[6] = 0b10000000; GC[7] = 0b00000000;
      GW = 1; GH = 7; break;
    case 125:  // }
      GC[0] = 0b11000000; GC[1] = 0b00100000; GC[2] = 0b00100000; GC[3] = 0b00010000;
      GC[4] = 0b00100000; GC[5] = 0b00100000; GC[6] = 0b11000000; GC[7] = 0b00000000;
      GW = 4; GH = 7; break;
    case 126:  // ~
      GC[0] = 0b00001000; GC[1] = 0b01110000; GC[2] = 0b10000000; GC[3] = 0b00000000;
      GC[4] = 0b00000000; GC[5] = 0b00000000; GC[6] = 0b00000000; GC[7] = 0b00000000;
      GW = 5; GH = 7; break;
    case 127:  // []
      GC[0] = 0b11111000; GC[1] = 0b10001000; GC[2] = 0b10001000; GC[3] = 0b10001000;
      GC[4] = 0b10001000; GC[5] = 0b10001000; GC[6] = 0b11111000; GC[7] = 0b00000000;
      GW = 5; GH = 7; break;

    default:  // Filled 8x8
      GC[0] = 0b11111111;
      GC[1] = 0b11111111;
      GC[2] = 0b11111111;
      GC[3] = 0b11111111;
      GC[4] = 0b11111111;
      GC[5] = 0b11111111;
      GC[6] = 0b11111111;
      GC[7] = 0b11111111;
      GW = 8; GH = 8; break;
  }
}

// ---------------------------------------------------------------------------------

void loadGfx(uint8_t zC) {
  // loads 8 bytes into the character array for use in graphics
  switch(zC) {
    case  0:  // Face 0
      GC[0] = 0b01100110; GC[1] = 0b10011001; GC[2] = 0b01100110; GC[3] = 0b00010000;
      GC[4] = 0b00011000; GC[5] = 0b00000000; GC[6] = 0b00111100; GC[7] = 0b00000000;
      GW = 8; GH = 8; break;
    case  1:  // Face 1
      GC[0] = 0b01100110; GC[1] = 0b10010101; GC[2] = 0b01100110; GC[3] = 0b00010000;
      GC[4] = 0b00011000; GC[5] = 0b10000001; GC[6] = 0b01111110; GC[7] = 0b00000000;
      GW = 8; GH = 8; break;
    case  2:  // Face 2
      GC[0] = 0b01100110; GC[1] = 0b10100101; GC[2] = 0b01100110; GC[3] = 0b00010000;
      GC[4] = 0b00011000; GC[5] = 0b10000001; GC[6] = 0b11111111; GC[7] = 0b01111110;
      GW = 8; GH = 8; break;
    case  3:  // Face 3
      GC[0] = 0b01100110; GC[1] = 0b11100111; GC[2] = 0b01010010; GC[3] = 0b00010000;
      GC[4] = 0b00011000; GC[5] = 0b11111111; GC[6] = 0b10000001; GC[7] = 0b01111110;
      GW = 8; GH = 8; break;
    case  4:  // Face 4
      GC[0] = 0b01100110; GC[1] = 0b11100111; GC[2] = 0b00010000; GC[3] = 0b00011000;
      GC[4] = 0b00111100; GC[5] = 0b01000010; GC[6] = 0b10000001; GC[7] = 0b01111110;
      GW = 8; GH = 8; break;
    case  5:  // Face 5
      GC[0] = 0b01100110; GC[1] = 0b11100111; GC[2] = 0b00010000; GC[3] = 0b00011000;
      GC[4] = 0b01111110; GC[5] = 0b10000001; GC[6] = 0b10000001; GC[7] = 0b01111110;
      GW = 8; GH = 8; break;
    case  6:  // Face 6
      GC[0] = 0b01100110; GC[1] = 0b11000011; GC[2] = 0b00010000; GC[3] = 0b00111100;
      GC[4] = 0b01000010; GC[5] = 0b10000001; GC[6] = 0b10000001; GC[7] = 0b01111110;
      GW = 8; GH = 8; break;
    case  7:  // Face 7
      GC[0] = 0b01100110; GC[1] = 0b11000011; GC[2] = 0b00010000; GC[3] = 0b01111110;
      GC[4] = 0b10000001; GC[5] = 0b10000001; GC[6] = 0b10000001; GC[7] = 0b01111110;
      GW = 8; GH = 8; break;
    case  8:  // Face 8
      GC[0] = 0b11000011; GC[1] = 0b10010001; GC[2] = 0b00111100; GC[3] = 0b01000010;
      GC[4] = 0b10010001; GC[5] = 0b10011001; GC[6] = 0b10000001; GC[7] = 0b01111110;
      GW = 8; GH = 8; break;
    default:  // Filled 8x8
      GC[0] = 0b11111111;
      GC[1] = 0b11111111;
      GC[2] = 0b11111111;
      GC[3] = 0b11111111;
      GC[4] = 0b11111111;
      GC[5] = 0b11111111;
      GC[6] = 0b11111111;
      GC[7] = 0b11111111;
      GW = 8; GH = 8; break;
  }
}

// ---------------------------------------------------------------------------------

void loadVector(uint8_t zC) {
  // loads 8 bytes into the character array for use in graphics
  switch(zC) {
    case  0:  // Level 0
      GC[0] = 0b00000000;
      GC[1] = 0b00000000;
      GC[2] = 0b00000000;
      GC[3] = 0b00011000;
      GC[4] = 0b00011000;
      GC[5] = 0b00000000;
      GC[6] = 0b00000000;
      GC[7] = 0b00000000;
      GW = 8; GH = 8; break;
    case  1:  // Level 1
      GC[0] = 0b00000000;
      GC[1] = 0b00000000;
      GC[2] = 0b00001100;
      GC[3] = 0b00010100;
      GC[4] = 0b00010100;
      GC[5] = 0b00001100;
      GC[6] = 0b00000000;
      GC[7] = 0b00000000;
      GW = 8; GH = 8; break;
    case  2:  // Level 2
      GC[0] = 0b00000000;
      GC[1] = 0b00000000;
      GC[2] = 0b00001100;
      GC[3] = 0b00110100;
      GC[4] = 0b00110100;
      GC[5] = 0b00001100;
      GC[6] = 0b00000000;
      GC[7] = 0b00000000;
      GW = 8; GH = 8; break;
    case  3:  // Level 3
      GC[0] = 0b00000000;
      GC[1] = 0b00000110;
      GC[2] = 0b00001010;
      GC[3] = 0b00110010;
      GC[4] = 0b00110010;
      GC[5] = 0b00001010;
      GC[6] = 0b00000110;
      GC[7] = 0b00000000;
      GW = 8; GH = 8; break;
    case  4:  // Level 4
      GC[0] = 0b00000000;
      GC[1] = 0b00000110;
      GC[2] = 0b00011010;
      GC[3] = 0b01100010;
      GC[4] = 0b01100010;
      GC[5] = 0b00011010;
      GC[6] = 0b00000110;
      GC[7] = 0b00000000;
      GW = 8; GH = 8; break;
    case  5:  // Level 5
      GC[0] = 0b00000011;
      GC[1] = 0b00000101;
      GC[2] = 0b00011001;
      GC[3] = 0b01100001;
      GC[4] = 0b01100001;
      GC[5] = 0b00011001;
      GC[6] = 0b00000101;
      GC[7] = 0b00000011;
      GW = 8; GH = 8; break;
    case  6:  // Level 6
      GC[0] = 0b00000011;
      GC[1] = 0b00001101;
      GC[2] = 0b00110001;
      GC[3] = 0b11000001;
      GC[4] = 0b11000001;
      GC[5] = 0b00110001;
      GC[6] = 0b00001101;
      GC[7] = 0b00000011;
      GW = 8; GH = 8; break;
    case  7:  // Level 7
      GC[0] = 0b00000111;
      GC[1] = 0b00011001;
      GC[2] = 0b01100001;
      GC[3] = 0b10000001;
      GC[4] = 0b10000001;
      GC[5] = 0b01100001;
      GC[6] = 0b00011001;
      GC[7] = 0b00000111;
      GW = 8; GH = 8; break;
    default:  // empty 8x8
      GC[0] = 0b00000000;
      GC[1] = 0b00000000;
      GC[2] = 0b00000000;
      GC[3] = 0b00000000;
      GC[4] = 0b00000000;
      GC[5] = 0b00000000;
      GC[6] = 0b00000000;
      GC[7] = 0b00000000;
      GW = 8; GH = 8; break;
  }
}

// ---------------------------------------------------------------------------------
