// ######################################################################
//
//  Christmas Novelty File v1.0
//
//  Released:  25/11/2015
//
//  Author: TechKnowTone
//
// ######################################################################
/*
    This software is furnished "as is", without technical support, and
    with no warranty, expressed or implied, as to its usefulness for any
    purpose.
    
    Elements of this software were taken from the public domain. It uses
    libraries for tone generation and infrared reception which are readily
    available and must be installed on your system. It plays several
    melodies which are selected from a remote control. Updated with latest
    IRremote library codes.

    This version reads 3 switch inputs and drives 6 LEDs. It dos not use
    multiplexed LEDs as in the original design.

   Key  Function:
    1   play melody 0 - Jingle Bells
    2   play melody 1 - God Rest Ye Merry Gentlement
    3   play melody 2 - Hark The Herald Angels Sing
    4   play melody 3 - Old King Cole
    5   play melody 4 - Silent Night
    6   play melody 5 - The First Noel
    *   toggle LED twinkle on/off when silent to save power
    #   STOP the current musical score from playing
    >   next LED pattern
    <   previous LED pattern
*/
// Declare libraries
#include "IRremote.h"
#include <NewTone.h>
#include "pitches.h"

// Declare and initialise global variables
#define arraySize 80 // max no. notes in a tune
#define swB1 13  // B1 switch input
#define swB2 12  // B2 switch input
#define swB4 11  // B4 switch input
#define speakerPin 2 // speaker is connected to digital pin 2

// Define arrays
#define arrayMax 5  // max array element = size -1
int ledPins[arrayMax + 1] = {10,9,8,7,6,5};
int ledVals[arrayMax + 1] = {0,0,0,0,0,0};

int irDel = 200; // delay between IR reads in miliseconds
long irResult; //value received
int keyDel = 0; // delay between reading keyboard in miliseconds
int keyVal; // input value read from serial port
int ledInc =1; // LED brightness increment
int ledOFF = 1;  // LED OFF time for dimming
int ledON = 999; // LED ON time for dimming
int ledPnt = 0; // light show pointer
int lightTask = 0; // light mode task pointer
int lightTaskMax = 5; // max light mode tasks
int loopCnt; // main loop delay counter
int loadPnt = 0; // pointer used to load arrays
int melody[arraySize]; // notes in teh melody
int noteDuration; // duration of a note being played in miliseconds
int noteDurations[arraySize]; // note durations: 4 = quarter note, 8 = eighth note, etc.:
int noteTempo = 1000; // nominal note period, increase to slow tempo
int numNotes = 8;  // number of notes in a melody. Must be less than arraySize
int pauseBetweenNotes = 10; // delay between a note
int playPnt = -1; // set >= 0 to play melody sequence
int receiver = 3; // pin 3 of IR receiver to Arduino digital pin 3
int swDel = 20; // relay between siwtch reads
int swCnt = 0; // number of switch presses
int swRead = HIGH; // latest input value
int swState = HIGH; //previous switch state
int swVal = 0; // temporary switch value or inactivity timer
int twinkleCnt = -1; // twinkle delay
int twinkleON = 1; // set to twinkle in rest state

// Declare objects
IRrecv irrecv(receiver);  // create instance of 'irrecv'
decode_results results;   // create instance of 'decode_results'

// ----------------------------------------------------------------------

void setup() {
  // put your setup code here, to run once:
  pinMode(swB1, INPUT_PULLUP);
  pinMode(swB2, INPUT_PULLUP);
  pinMode(swB4, INPUT_PULLUP);
  pinMode(ledPins[0], OUTPUT);
  pinMode(ledPins[1], OUTPUT);
  pinMode(ledPins[2], OUTPUT);
  pinMode(ledPins[3], OUTPUT);
  pinMode(ledPins[4], OUTPUT);
  pinMode(ledPins[5], OUTPUT);
  pinMode(speakerPin, OUTPUT);
  digitalWrite(speakerPin, LOW);
  Serial.begin(9600);
  irrecv.enableIRIn(); // initialise IR receiver
  runPOST();
}

// ----------------------------------------------------------------------

void loop() {
  // put your main code here, to run repeatedly:
  if (playPnt != -1) {
    // playing a note sequence
    if (playPnt > -1) {
      playANote(); // load the next note
      playLights();// play part of a light sequence for each note
    }
    loopCnt = pauseBetweenNotes;
    while (loopCnt > 0) {
        // this is the main loop with a 1ms loop time
        keyDel--; if (keyDel <1) {readSerial();}
        irDel--; if (irDel <1) {readIR();}
//        swDel--; if (swDel <1) {readSwitch1();} // single switch
        swDel--; if (swDel <1) {readSwitchN();} // multiple switches
        scanLeds();
        loopCnt--;
    }
    if (playPnt == -2) {
      // last note reached so turn off sound
      noNewTone(speakerPin); digitalWrite(speakerPin, LOW);
      lightTask++; ledPnt = 0;
      if (lightTask > lightTaskMax) {lightTask = 0;} // increment light sequence pointer
      clearStore(); // switch OFF LEDS
      playPnt = -1; twinkleCnt = 2000; // pause before twinkling
    }
  }
  else {
    // not playing a note sequence so scan keys
    // twinkle lamps whilst in this mode
    keyDel--; if (keyDel <1) {readSerial();}
    irDel--; if (irDel <1) {readIR();}
//    swDel--; if (swDel <1) {readSwitch1();} // single switch
    swDel--; if (swDel <1) {readSwitchN();} // multiple switches
    scanLeds();
    if (twinkleON == 1) {
      // twinkle LEDs randomly
      if (twinkleCnt < 0) {
        twinkleCnt = 702;
        loadTwinkle(); ledInc = 1; ledON = 10;
      }
      twinkleCnt--;
    }
    // vary brightness of LEDs
    if (ledInc > 0) {
      ledON++; if (ledON > 350) {ledON = 400; ledInc = -1;}
    }
    else {
      ledON--; if (ledON < 1) {ledON = 50; ledInc = 1;}
    } ledOFF = 1000 - ledON; // ensure they add up to 1000
  }
}

// ----------------------------------------------------------------------

void clearStore () {
  // clear the LED array
  for (int zC = 0; zC <= arrayMax; zC++) {
    ledVals[zC] = 0;
  }
}

// ----------------------------------------------------------------------

void fillStore () {
  // clear the LED array
  for (int zC = 0; zC <= arrayMax; zC++) {
    ledVals[zC] = 1;
  }
}

// ----------------------------------------------------------------------

void keyAction() {
  // called when a key has been pressed to perform an action
  // keyVal can come from the serial port, infrared or switches
  switch (keyVal) {
    case 35:
      // key "#" pressed
      if (playPnt > -1) {playPnt = -2;}
      break;
    case 42:
      // key "*" pressed
      if (twinkleON == 1) {twinkleON = 0; clearStore();}
      else {twinkleON = 1;} break;
    case 49:
      // key "1" pressed
      loadMelody0(); break;
    case 50:
      // key "2" pressed
      loadMelody1(); break;
    case 51:
      // key "3" pressed
      loadMelody2(); break;
    case 52:
      // key "4" pressed
      loadMelody3(); break;
    case 53:
      // key "5" pressed
      loadMelody4(); break;
    case 54:
      // key "6" pressed
      loadMelody5(); break;
    case 55:
      // key "7" pressed
      loadMelody6(); break;
    case 56:
      // key "8" pressed
      loadMelody7(); break;
    case 57:
      // key "9" pressed
      loadMelody8(); break;
    case 58:
      // key "0" pressed
      loadMelody9(); break;
    case 60:
      // key "<" pressed
      if (playPnt > -1) {
        // playing music so next pattern
        lightTask--; if (lightTask < 0) {lightTask = lightTaskMax;}
        ledPnt = 0;
      } break;
    case 62:
      // key ">" pressed
      if (playPnt > -1) {
        // playing music so next pattern
        lightTask++; if (lightTask > lightTaskMax) {lightTask = 0;}
        ledPnt = 0;
      } break;
  }
}

// ----------------------------------------------------------------------

void loadArray(int zN, int zD) {
  // load values into arrays at position zP
  melody[loadPnt] = zN;
  noteDurations[loadPnt] = zD;
  loadPnt++;
}

// ----------------------------------------------------------------------

void loadMelody0() {
  // load a melody into the note and duration arrays
  // Jingle Bells
  noNewTone(speakerPin); // stop current melody
  Serial.println("Playing Tune 0: Jingle Bells");
  loadPnt = 0; noteTempo = 900;
  loadArray(NOTE_E5, 4); //Jingle..
  loadArray(NOTE_E5, 4);
  loadArray(NOTE_E5, 2);

  loadArray(NOTE_E5, 4); //Jingle..
  loadArray(NOTE_E5, 4);
  loadArray(NOTE_E5, 2);

  loadArray(NOTE_E5, 4); //Jingle..
  loadArray(NOTE_G5, 4);
  loadArray(NOTE_C5, 4);
  loadArray(NOTE_D5, 4);

  loadArray(NOTE_E5, 1); //way.

  loadArray(NOTE_F5, 4); //Oh..
  loadArray(NOTE_F5, 4);
  loadArray(NOTE_F5, 4);
  loadArray(NOTE_F5, 4);

  loadArray(NOTE_F5, 4); //is..
  loadArray(NOTE_E5, 4);
  loadArray(NOTE_E5, 4);
  loadArray(NOTE_E5, 4);

  loadArray(NOTE_E5, 4); //one..
  loadArray(NOTE_D5, 4);
  loadArray(NOTE_D5, 4);
  loadArray(NOTE_E5, 4);

  loadArray(NOTE_D5, 2); //sley.
  loadArray(NOTE_G5, 2); //Oh

  loadArray(NOTE_E5, 4); //Jingle..
  loadArray(NOTE_E5, 4);
  loadArray(NOTE_E5, 2);

  loadArray(NOTE_E5, 4); //Jingle..
  loadArray(NOTE_E5, 4);
  loadArray(NOTE_E5, 2);

  loadArray(NOTE_E5, 4); //Jingle..
  loadArray(NOTE_G5, 4);
  loadArray(NOTE_C5, 4);
  loadArray(NOTE_D5, 4);

  loadArray(NOTE_E5, 1); //way.

  loadArray(NOTE_F5, 4); //Oh..
  loadArray(NOTE_F5, 4);
  loadArray(NOTE_F5, 4);
  loadArray(NOTE_F5, 4);

  loadArray(NOTE_F5, 4); //is..
  loadArray(NOTE_E5, 4);
  loadArray(NOTE_E5, 4);
  loadArray(NOTE_E5, 4);

  loadArray(NOTE_G5, 4); //one..
  loadArray(NOTE_G5, 4);
  loadArray(NOTE_F5, 4);
  loadArray(NOTE_D5, 4);

  loadArray(NOTE_C5, 2); //sley.

  numNotes = loadPnt; // length of melody addressed, numNotes - 1
  playPnt = 0; // point to first note to start playing melody
  setLedPnt();
  ledON = 999; ledOFF = 1; //LEDs full brightness
}

// ----------------------------------------------------------------------

void loadMelody1() {
  // load a melody into the note and duration arrays
  // God Rest Ye Merry Gentlemen
  noNewTone(speakerPin); // stop current melody
  Serial.println("Playing Tune 1: God Rest Ye Merry Gentlemen");
  loadPnt = 0; noteTempo = 1000;
  loadArray(NOTE_D5, 4); //God..
  
  loadArray(NOTE_D5, 4); //rest..
  loadArray(NOTE_A5, 4);
  loadArray(NOTE_A5, 4);
  loadArray(NOTE_G5, 4);
  
  loadArray(NOTE_F5, 4); //gentlemen..
  loadArray(NOTE_E5, 4);
  loadArray(NOTE_D5, 4);
  loadArray(NOTE_C5, 4);

  loadArray(NOTE_D5, 4); //no-thing..
  loadArray(NOTE_E5, 4);
  loadArray(NOTE_F5, 4);
  loadArray(NOTE_G5, 4);

  loadArray(NOTE_A5, 2); //may..
  loadArray(NOTE_D5, 4);

  loadArray(NOTE_D5, 4); //member..
  loadArray(NOTE_A5, 4);
  loadArray(NOTE_A5, 4);
  loadArray(NOTE_G5, 4);

  loadArray(NOTE_F5, 4); //Saviour..
  loadArray(NOTE_E5, 4);
  loadArray(NOTE_D5, 4);
  loadArray(NOTE_C5, 4);

  loadArray(NOTE_D5, 4); //born..
  loadArray(NOTE_E5, 4);
  loadArray(NOTE_F5, 4);
  loadArray(NOTE_G5, 4);

  loadArray(NOTE_A5, 2); //day..
  loadArray(NOTE_A5, 4);

  loadArray(NOTE_AS5, 4); //save
  loadArray(NOTE_G5, 4);
  loadArray(NOTE_A5, 4);
  loadArray(NOTE_AS5, 4);

  loadArray(NOTE_C6, 4); //Satan's..
  loadArray(NOTE_D6, 4);
  loadArray(NOTE_A5, 4);
  loadArray(NOTE_G5, 4);

  loadArray(NOTE_F5, 4); //we..
  loadArray(NOTE_D5, 4);
  loadArray(NOTE_E5, 4);
  loadArray(NOTE_F5, 4);

  loadArray(NOTE_G5, 2); //stray..
  loadArray(NOTE_F5, 4);
  loadArray(NOTE_G5, 4);

  loadArray(NOTE_A5, 2); //tidings..
  loadArray(NOTE_AS5, 4);
  loadArray(NOTE_A5, 4);

  loadArray(NOTE_A5, 4); //comfort..
  loadArray(NOTE_G5, 4);
  loadArray(NOTE_F5, 4);
  loadArray(NOTE_E5, 4);

  loadArray(NOTE_D5, 2); //joy..
  loadArray(NOTE_F5, 8);
  loadArray(NOTE_E5, 8);
  loadArray(NOTE_D5, 4);

  loadArray(NOTE_G5, 2); //joy..
  loadArray(NOTE_F5, 4);
  loadArray(NOTE_G5, 4);

  loadArray(NOTE_A5, 4); //tidings..
  loadArray(NOTE_AS5, 4);
  loadArray(NOTE_C6, 4);
  loadArray(NOTE_D6, 4);

  loadArray(NOTE_A5, 4); //comfort..
  loadArray(NOTE_G5, 4);
  loadArray(NOTE_F5, 4);
  loadArray(NOTE_E5, 4);

  loadArray(NOTE_D5, 1); //joy.

  numNotes = loadPnt; // length of melody addressed, numNotes - 1
  playPnt = 0; // point to first note to start playing melody
  setLedPnt();
  ledON = 999; ledOFF = 1; //LEDs full brightness
}

// ----------------------------------------------------------------------

void loadMelody2() {
  // load a melody into the note and duration arrays
  // Hark The Herald Angels Sing
  noNewTone(speakerPin); // stop current melody
  Serial.println("Playing Tune 2: Hark The Herald Angels Sing");
  loadPnt = 0; noteTempo = 1000;
  loadArray(NOTE_G4, 4); //Hark..
  loadArray(NOTE_C5, 4);
  loadArray(NOTE_C5, 4);
  loadArray(NOTE_B4, 4);

  loadArray(NOTE_C5, 4); //an-gels..
  loadArray(NOTE_E5, 4);
  loadArray(NOTE_E5, 4);
  loadArray(NOTE_D5, 4);

  loadArray(NOTE_G5, 4); //Glo-ry..
  loadArray(NOTE_G5, 4);
  loadArray(NOTE_G5, 4);
  loadArray(NOTE_F5, 4);

  loadArray(NOTE_E5, 4); //new-born..
  loadArray(NOTE_D5, 4);
  loadArray(NOTE_E5, 2);

  loadArray(NOTE_G4, 4); //Peace..
  loadArray(NOTE_C5, 4);
  loadArray(NOTE_C5, 4);
  loadArray(NOTE_B4, 4);

  loadArray(NOTE_C5, 4); //mer-cy..
  loadArray(NOTE_E5, 4);
  loadArray(NOTE_E5, 4);
  loadArray(NOTE_D5, 4);

  loadArray(NOTE_G5, 4); //God..
  loadArray(NOTE_D5, 4);
  loadArray(NOTE_D5, 4);
  loadArray(NOTE_C5, 4);

  loadArray(NOTE_B4, 4); //re-conciled..
  loadArray(NOTE_A4, 4);
  loadArray(NOTE_G4, 2);

  loadArray(NOTE_G5, 4); //Joy-ful..
  loadArray(NOTE_G5, 4);
  loadArray(NOTE_G5, 4);
  loadArray(NOTE_C5, 4);

  loadArray(NOTE_F5, 4); //nations..
  loadArray(NOTE_E5, 4);
  loadArray(NOTE_E5, 4);
  loadArray(NOTE_D5, 4);

  loadArray(NOTE_G5, 4);  //Join...
  loadArray(NOTE_G5, 4);
  loadArray(NOTE_G5, 4);
  loadArray(NOTE_C5, 4);

  loadArray(NOTE_F5, 4); //of the..
  loadArray(NOTE_E5, 4);
  loadArray(NOTE_E5, 4);
  loadArray(NOTE_D5, 4);

  loadArray(NOTE_A5, 4); //With..
  loadArray(NOTE_A5, 4);
  loadArray(NOTE_A5, 4);
  loadArray(NOTE_G5, 4);

  loadArray(NOTE_F5, 4); //host..
  loadArray(NOTE_E5, 4);
  loadArray(NOTE_F5, 2);

  loadArray(NOTE_D5, 4); //Christ..
  loadArray(NOTE_E5, 8);
  loadArray(NOTE_F5, 8);
  loadArray(NOTE_G5, 4);
  loadArray(NOTE_C5, 4);

  loadArray(NOTE_C5, 4); //Beth-le-hem
  loadArray(NOTE_D5, 4);
  loadArray(NOTE_E5, 2);

  loadArray(NOTE_A5, 4); //Hark..
  loadArray(NOTE_A5, 4);
  loadArray(NOTE_A5, 4);
  loadArray(NOTE_G5, 4);

  loadArray(NOTE_F5, 4); //an-gels..
  loadArray(NOTE_E5, 4);
  loadArray(NOTE_F5, 2);

  loadArray(NOTE_D5, 4); //Glo-ry..
  loadArray(NOTE_E5, 8);
  loadArray(NOTE_F5, 8);
  loadArray(NOTE_G5, 4);
  loadArray(NOTE_C5, 4);

  loadArray(NOTE_C5, 4); //new-born..
  loadArray(NOTE_D5, 4);
  loadArray(NOTE_C5, 2);

  numNotes = loadPnt; // length of melody addressed, numNotes - 1
  playPnt = 0; // point to first note to start playing melody
  setLedPnt();
  ledON = 999; ledOFF = 1; //LEDs full brightness
}

// ----------------------------------------------------------------------

void loadMelody3() {
  // load a melody into the note and duration arrays
  // Old King Cole
  noNewTone(speakerPin); // stop current melody
  Serial.println("Playing Tune 3: Old King Cole");
  loadPnt = 0; noteTempo = 1000;
  loadArray(NOTE_D4, 4); //Old..
  loadArray(NOTE_D4, 4);
  loadArray(NOTE_E4, 4);
  loadArray(NOTE_D4, 8);
  loadArray(NOTE_E4, 8);

  loadArray(NOTE_FS4, 8); //merry..
  loadArray(NOTE_FS4, 8);
  loadArray(NOTE_FS4, 4);
  loadArray(NOTE_G4, 4);
  loadArray(NOTE_FS4, 8);
  loadArray(NOTE_G4, 8);

  loadArray(NOTE_A4, 8); //merry..
  loadArray(NOTE_A4, 8);
  loadArray(NOTE_D4, 4);
  loadArray(NOTE_E4, 4);
  loadArray(NOTE_E4, 4);

  loadArray(NOTE_D4, 2); //he..
  loadArray(0, 4);
  loadArray(NOTE_A3, 4);

  loadArray(NOTE_D4, 4); //called..
  loadArray(NOTE_D4, 8);
  loadArray(NOTE_D4, 8);
  loadArray(NOTE_E4, 4);
  loadArray(NOTE_D4, 8);
  loadArray(NOTE_E4, 8);

  loadArray(NOTE_FS4, 4); //called..
  loadArray(NOTE_FS4, 8);
  loadArray(NOTE_FS4, 8);
  loadArray(NOTE_G4, 4);
  loadArray(NOTE_FS4, 8);
  loadArray(NOTE_G4, 8);

  loadArray(NOTE_A4, 4); //called
  loadArray(NOTE_D4, 8);
  loadArray(NOTE_D4, 8);
  loadArray(NOTE_E4, 4);
  loadArray(NOTE_E4, 4);

  loadArray(NOTE_D4, 1); //three

  numNotes = loadPnt; // length of melody addressed, numNotes - 1
  playPnt = 0; // point to first note to start playing melody
  setLedPnt();
  ledON = 999; ledOFF = 1; //LEDs full brightness
}

// ----------------------------------------------------------------------

void loadMelody4() {
  // load a melody into the note and duration arrays
  // Silent Night
  noNewTone(speakerPin); // stop current melody
  Serial.println("Playing Tune 4: Silent Night");
  loadPnt = 0; noteTempo = 900;
  loadArray(NOTE_G5, 3); //Silent..
  loadArray(NOTE_A5, 8);
  loadArray(NOTE_G5, 4);

  loadArray(NOTE_E5, 1); //night.

  loadArray(NOTE_G5, 3); //Holy..
  loadArray(NOTE_A5, 8);
  loadArray(NOTE_G5, 4);

  loadArray(NOTE_E5, 1); //night.

  loadArray(NOTE_D6, 2); //All..
  loadArray(NOTE_D6, 4);

  loadArray(NOTE_B5, 1); //calm

  loadArray(NOTE_C6, 2); //all..
  loadArray(NOTE_C6, 4);

  loadArray(NOTE_G5, 1); //bright.

  loadArray(NOTE_A5, 2); //Round..
  loadArray(NOTE_A5, 4);

  loadArray(NOTE_C6, 3); //virgin..
  loadArray(NOTE_B5, 8);
  loadArray(NOTE_A5, 4);

  loadArray(NOTE_G5, 3); //Mother..
  loadArray(NOTE_A5, 8);
  loadArray(NOTE_G5, 4);

  loadArray(NOTE_E5, 1); //child.

  loadArray(NOTE_A5, 2); //Holy..
  loadArray(NOTE_A5, 4);

  loadArray(NOTE_C6, 3); //infant
  loadArray(NOTE_B5, 8);
  loadArray(NOTE_A5, 4);

  loadArray(NOTE_G5, 3); //tender...
  loadArray(NOTE_A5, 8);
  loadArray(NOTE_G5, 4);

  loadArray(NOTE_E5, 2); //mild.

  loadArray(NOTE_D6, 2); //Sleep..
  loadArray(NOTE_D6, 4);

  loadArray(NOTE_F6, 3); //heavenly..
  loadArray(NOTE_D6, 8);
  loadArray(NOTE_B5, 4);

  loadArray(NOTE_C6, 1); //pe--

  loadArray(NOTE_E6, 1); //--ace.

  loadArray(NOTE_C6, 4); //Sleep..
  loadArray(NOTE_G5, 4);
  loadArray(NOTE_E5, 4);

  loadArray(NOTE_G5, 3); //heavenly
  loadArray(NOTE_F5, 8);
  loadArray(NOTE_D5, 4);

  loadArray(NOTE_C5, 1);

  loadArray(NOTE_C5, 2);

  numNotes = loadPnt; // length of melody addressed, numNotes - 1
  playPnt = 0; // point to first note to start playing melody
  setLedPnt();
  ledON = 999; ledOFF = 1; //LEDs full brightness
}

// ----------------------------------------------------------------------

void loadMelody5() {
  // load a melody into the note and duration arrays
  // The First Noel
  noNewTone(speakerPin); // stop current melody
  Serial.println("Playing Tune 5: The First Noel");
  loadPnt = 0; noteTempo = 1000;
  loadArray(NOTE_B3, 8); //The
  loadArray(NOTE_A3, 8);

  loadArray(NOTE_G3, 3); //first..
  loadArray(NOTE_A3, 4);
  loadArray(NOTE_B3, 8);
  loadArray(NOTE_C4, 8);

  loadArray(NOTE_D4, 2); //el...
  loadArray(NOTE_E4, 8);
  loadArray(NOTE_FS4, 8);

  loadArray(NOTE_G4, 4); //Angels..
  loadArray(NOTE_FS4, 4);
  loadArray(NOTE_E4, 4);

  loadArray(NOTE_D4, 2); //say..
  loadArray(NOTE_E4, 8);
  loadArray(NOTE_FS4, 8);

  loadArray(NOTE_G4, 4); //certain
  loadArray(NOTE_FS4, 4);
  loadArray(NOTE_E4, 4);

  loadArray(NOTE_D4, 4); //shepherds
  loadArray(NOTE_E4, 4);
  loadArray(NOTE_FS4, 4);

  loadArray(NOTE_G4, 4); //fields..
  loadArray(NOTE_D4, 4);
  loadArray(NOTE_C4, 4);

  loadArray(NOTE_B3, 2); //lay..
  loadArray(NOTE_B3, 8);
  loadArray(NOTE_A3, 8);

  loadArray(NOTE_G3, 3); //fields..
  loadArray(NOTE_A3, 4);
  loadArray(NOTE_B3, 8);
  loadArray(NOTE_C4, 8);

  loadArray(NOTE_D4, 2); //they..
  loadArray(NOTE_E4, 8);
  loadArray(NOTE_FS4, 8);

  loadArray(NOTE_G4, 4); //keeping..
  loadArray(NOTE_F4, 4);
  loadArray(NOTE_E4, 4);

  loadArray(NOTE_D4, 2); //sheep..
  loadArray(NOTE_E4, 8);
  loadArray(NOTE_FS4, 8);

  loadArray(NOTE_G4, 4); //cold..
  loadArray(NOTE_FS4, 4);
  loadArray(NOTE_E4, 4);

  loadArray(NOTE_D4, 4); //night..
  loadArray(NOTE_E4, 4);
  loadArray(NOTE_FS4, 4);

  loadArray(NOTE_G4, 4); //was..
  loadArray(NOTE_D4, 4);
  loadArray(NOTE_C4, 4);

  loadArray(NOTE_B3, 2); //deep..
  loadArray(NOTE_B3, 8);
  loadArray(NOTE_A3, 8);

  loadArray(NOTE_G3, 3); //el..
  loadArray(NOTE_A3, 4);
  loadArray(NOTE_B3, 8);
  loadArray(NOTE_C4, 8);

  loadArray(NOTE_D4, 2); //el..
  loadArray(NOTE_G4, 8);
  loadArray(NOTE_FS4, 8);

  loadArray(NOTE_E4, 2); //el..
  loadArray(NOTE_E4, 4);

  loadArray(NOTE_D4, 2); //el.

  loadArray(NOTE_G4, 4); //Born..
  loadArray(NOTE_FS4, 4);
  loadArray(NOTE_E4, 4);

  loadArray(NOTE_D4, 4); //King..
  loadArray(NOTE_E4, 4);
  loadArray(NOTE_FS4, 4);

  loadArray(NOTE_G4, 4); //Israel.
  loadArray(NOTE_D4, 4);
  loadArray(NOTE_C4, 4);

  loadArray(NOTE_B3, 2);

  numNotes = loadPnt; // length of melody addressed, numNotes - 1
  playPnt = 0; // point to first note to start playing melody
  setLedPnt();
  ledON = 999; ledOFF = 1; //LEDs full brightness
}

// ----------------------------------------------------------------------

void loadMelody6() {
  // load a melody into the note and duration arrays
  // Deck The Halls
  noNewTone(speakerPin); // stop current melody
  Serial.println("Playing Tune 6: Deck The Halls");
  loadPnt = 0; noteTempo = 1000;
  loadArray(NOTE_C6, 3); //
  loadArray(NOTE_AS5, 8);
  loadArray(NOTE_A5, 4);
  loadArray(NOTE_G5, 4);

  loadArray(NOTE_F5, 4); //
  loadArray(NOTE_G5, 4);
  loadArray(NOTE_A5, 4);
  loadArray(NOTE_F5, 4);

  loadArray(NOTE_G5, 8); //
  loadArray(NOTE_A5, 8);
  loadArray(NOTE_AS5, 8);
  loadArray(NOTE_G5, 8);
  loadArray(NOTE_A5, 3);
  loadArray(NOTE_G5, 8);

  loadArray(NOTE_F5, 4); //
  loadArray(NOTE_E5, 4);
  loadArray(NOTE_F5, 2);


  loadArray(NOTE_C6, 3); //
  loadArray(NOTE_AS5, 8);
  loadArray(NOTE_A5, 4);
  loadArray(NOTE_G5, 4);

  loadArray(NOTE_F5, 4); //
  loadArray(NOTE_G5, 4);
  loadArray(NOTE_A5, 4);
  loadArray(NOTE_F5, 4);

  loadArray(NOTE_G5, 8); //
  loadArray(NOTE_A5, 8);
  loadArray(NOTE_AS5, 8);
  loadArray(NOTE_G5, 8);
  loadArray(NOTE_A5, 3);
  loadArray(NOTE_G5, 8);

  loadArray(NOTE_F5, 4); //
  loadArray(NOTE_E5, 4);
  loadArray(NOTE_F5, 2);


  loadArray(NOTE_G5, 3); //
  loadArray(NOTE_A5, 8);
  loadArray(NOTE_AS5, 4);
  loadArray(NOTE_G5, 4);

  loadArray(NOTE_A5, 3); //
  loadArray(NOTE_AS5, 8);
  loadArray(NOTE_C6, 4);
  loadArray(NOTE_G5, 4);

  loadArray(NOTE_A5, 8); //
  loadArray(NOTE_AS5, 8);
  loadArray(NOTE_C6, 4);
  loadArray(NOTE_D6, 8);
  loadArray(NOTE_E6, 8);
  loadArray(NOTE_F6, 4);

  loadArray(NOTE_E6, 4); //
  loadArray(NOTE_D6, 4);
  loadArray(NOTE_C6, 2);


  loadArray(NOTE_C6, 3); //
  loadArray(NOTE_AS5, 8);
  loadArray(NOTE_A5, 4);
  loadArray(NOTE_G5, 4);

  loadArray(NOTE_F5, 4); //
  loadArray(NOTE_G5, 4);
  loadArray(NOTE_A5, 4);
  loadArray(NOTE_F5, 4);

  loadArray(NOTE_G5, 8); //
  loadArray(NOTE_G5, 8);
  loadArray(NOTE_AS5, 8);
  loadArray(NOTE_G5, 8);
  loadArray(NOTE_A5, 3);
  loadArray(NOTE_G5, 8);

  loadArray(NOTE_F5, 4);
  loadArray(NOTE_E5, 4);
  loadArray(NOTE_F5, 4);

  numNotes = loadPnt; // length of melody addressed, numNotes - 1
  playPnt = 0; // point to first note to start playing melody
  setLedPnt();
  ledON = 999; ledOFF = 1; //LEDs full brightness
}

// ----------------------------------------------------------------------

void loadMelody7() {
  // load a melody into the note and duration arrays
  // The Holly And The Ivy
  noNewTone(speakerPin); // stop current melody
  Serial.println("Playing Tune 7: The Holly And The Ivy");
  loadPnt = 0; noteTempo = 1000;
  loadArray(NOTE_F5, 4); //The..
  
  loadArray(NOTE_F5, 8); //holly..
  loadArray(NOTE_F5, 8);
  loadArray(NOTE_F5, 4);
  loadArray(NOTE_D6, 8);

  loadArray(NOTE_C6, 4); //i-vy..
  loadArray(NOTE_A5, 3);
  loadArray(NOTE_F5, 8);

  loadArray(NOTE_F5, 8); //They..
  loadArray(NOTE_F5, 8);
  loadArray(NOTE_F5, 4);
  loadArray(NOTE_D6, 4);
  
  loadArray(NOTE_C6, 2); //grown,
  loadArray(NOTE_C6, 8);
  loadArray(NOTE_AS5, 8);

  loadArray(NOTE_A5, 8); //all..
  loadArray(NOTE_G5, 8);
  loadArray(NOTE_F5, 4);
  loadArray(NOTE_A5, 4);

  loadArray(NOTE_D5, 8); //in..
  loadArray(NOTE_D5, 8);
  loadArray(NOTE_C5, 4);
  loadArray(NOTE_F5, 8);
  loadArray(NOTE_G5, 4);

  loadArray(NOTE_A5, 8); //hol-ly..
  loadArray(NOTE_AS5, 8);
  loadArray(NOTE_A5, 4);
  loadArray(NOTE_G5, 4);

  loadArray(NOTE_F5, 2); //crown.
  loadArray(NOTE_F5, 4);

  loadArray(NOTE_F5, 8); //ris-ing
  loadArray(NOTE_F5, 8);
  loadArray(NOTE_F5, 4);
  loadArray(NOTE_D6, 4);

  loadArray(NOTE_C6, 4); //sun, -
  loadArray(NOTE_A5, 3);
  loadArray(NOTE_F5, 8);

  loadArray(NOTE_F5, 8); //run-ning..
  loadArray(NOTE_F5, 8);
  loadArray(NOTE_F5, 4);
  loadArray(NOTE_D6, 4);

  loadArray(NOTE_C6, 2); //deer, -
  loadArray(NOTE_C6, 8);
  loadArray(NOTE_AS5, 8);

  loadArray(NOTE_A5, 8); //play-ing..
  loadArray(NOTE_G5, 8);
  loadArray(NOTE_F5, 4);
  loadArray(NOTE_A5, 4);

  loadArray(NOTE_D5, 8); //mer=ry..
  loadArray(NOTE_D5, 8);
  loadArray(NOTE_C5, 4);
  loadArray(NOTE_F5, 8);
  loadArray(NOTE_G5, 8);

  loadArray(NOTE_A5, 8); //sing-ing..
  loadArray(NOTE_AS5, 8);
  loadArray(NOTE_A5, 4);
  loadArray(NOTE_G5, 4);

  loadArray(NOTE_F5, 2); //Choir.

  numNotes = loadPnt; // length of melody addressed, numNotes - 1
  playPnt = 0; // point to first note to start playing melody
  setLedPnt();
  ledON = 999; ledOFF = 1; //LEDs full brightness
}

// ----------------------------------------------------------------------

void loadMelody8() {
  // load a melody into the note and duration arrays
  // We Three Kings
  noNewTone(speakerPin); // stop current melody
  Serial.println("Playing Tune 8: We Three Kings");
  loadPnt = 0; noteTempo = 800;
  loadArray(NOTE_E4, 2); // We..
  loadArray(NOTE_D4, 4);

  loadArray(NOTE_C4, 2); //three..
  loadArray(NOTE_A3, 4);

  loadArray(NOTE_B3, 4); //kings..
  loadArray(NOTE_C4, 4);
  loadArray(NOTE_B3, 4);

  loadArray(NOTE_A3, 1); //are.

  loadArray(NOTE_E4, 2); //Bearing..
  loadArray(NOTE_D4, 4);

  loadArray(NOTE_C4, 2); //gifts..
  loadArray(NOTE_A3, 4);

  loadArray(NOTE_B3, 4); //we..
  loadArray(NOTE_C4, 4);
  loadArray(NOTE_B3, 4);

  loadArray(NOTE_A3, 1); //afare.

  loadArray(NOTE_C4, 2); //Field...
  loadArray(NOTE_C4, 4);

  loadArray(NOTE_D4, 2); //fountain..
  loadArray(NOTE_D4, 4);

  loadArray(NOTE_E4, 2); //moor..
  loadArray(NOTE_E4, 4);

  loadArray(NOTE_G4, 4); //mountain..
  loadArray(NOTE_F4, 4);
  loadArray(NOTE_E4, 4);

  loadArray(NOTE_D4, 4); //following..
  loadArray(NOTE_E4, 4);
  loadArray(NOTE_D4, 4);

  loadArray(NOTE_C4, 2); //younder
  loadArray(NOTE_B3, 4);

  loadArray(NOTE_A3, 1); //star.

  numNotes = loadPnt; // length of melody addressed, numNotes - 1
  playPnt = 0; // point to first note to start playing melody
  setLedPnt();
  ledON = 999; ledOFF = 1; //LEDs full brightness
}

// ----------------------------------------------------------------------

void loadMelody9() {
  // load a melody into the note and duration arrays
  // We Wish You A Merry Christmas
  noNewTone(speakerPin); // stop current melody
  Serial.println("Playing Tune 9: We Wish You A Merry Christmas");
  loadPnt = 0; noteTempo = 900;
  loadArray(NOTE_D5, 4); //We..

  loadArray(NOTE_G5, 4); //wish..
  loadArray(NOTE_G5, 8);
  loadArray(NOTE_A5, 8);
  loadArray(NOTE_G5, 8);
  loadArray(NOTE_FS5, 8);

  loadArray(NOTE_E5, 4); //Christmas.
  loadArray(NOTE_E5, 4);
  loadArray(NOTE_E5, 4);

  loadArray(NOTE_A5, 4); //wish..
  loadArray(NOTE_A5, 8);
  loadArray(NOTE_B5, 8);
  loadArray(NOTE_A5, 8);
  loadArray(NOTE_G5, 8);

  loadArray(NOTE_FS5, 4); //Christmas.
  loadArray(NOTE_D5, 4);
  loadArray(NOTE_D5, 4);

  loadArray(NOTE_B5, 4); //We..
  loadArray(NOTE_B5, 8);
  loadArray(NOTE_C6, 8);
  loadArray(NOTE_B5, 8);
  loadArray(NOTE_A5, 8);

  loadArray(NOTE_G5, 4); //Christmas.
  loadArray(NOTE_E5, 4);
  loadArray(NOTE_D5, 8);
  loadArray(NOTE_D5, 8);

  loadArray(NOTE_E5, 4); //And..
  loadArray(NOTE_A5, 4);
  loadArray(NOTE_FS5, 4);

  loadArray(NOTE_G5, 2); //New Year
  loadArray(NOTE_D5, 4);
 
  loadArray(NOTE_G5, 4); //Good...
  loadArray(NOTE_G5, 4);
  loadArray(NOTE_G5, 4);

  loadArray(NOTE_FS5, 2); //we..
  loadArray(NOTE_FS5, 4);

  loadArray(NOTE_G5, 4); //to you..
  loadArray(NOTE_FS5, 4);
  loadArray(NOTE_E5, 4);

  loadArray(NOTE_D5, 2); //your..
  loadArray(NOTE_A5, 4);

  loadArray(NOTE_B5, 4); //wish..
  loadArray(NOTE_A5, 4);
  loadArray(NOTE_G5, 4);

  loadArray(NOTE_D6, 4); //merry..
  loadArray(NOTE_D5, 4);
  loadArray(NOTE_D5, 8);
  loadArray(NOTE_D5, 8);

  loadArray(NOTE_E5, 4); //happy..
  loadArray(NOTE_A5, 4);
  loadArray(NOTE_FS5, 4);

  loadArray(NOTE_G5, 2);

  numNotes = loadPnt; // length of melody addressed, numNotes - 1
  playPnt = 0; // point to first note to start playing melody
  setLedPnt();
  ledON = 999; ledOFF = 1; //LEDs full brightness
}

// ----------------------------------------------------------------------

void loadTwinkle() {
  // load a random pattern into the LED store
  Serial.println("New Twinkle");
  clearStore();
  for (int zC = 0; zC <= arrayMax; zC++) {
    // light random lights
    ledVals[zC] = random(2);
  }
}

// ----------------------------------------------------------------------

void playANote() {
  // play a note at the current pointer then increment pointer
  
  // to calculate the note duration, take one second divided by the note type.
  //e.g. quarter note = 1000 / 4, eighth note = 1000/8, etc.
  noteDuration = noteTempo / noteDurations[playPnt];
  NewTone(speakerPin, melody[playPnt], noteDuration);

  Serial.print("Note: ");
  Serial.print(playPnt);
  Serial.print(", Freq: ");
  Serial.print(melody[playPnt]);
  Serial.print(", Duration: ");
  Serial.print(noteDuration);
  Serial.println("ms");
  
  // to distinguish the notes, set a minimum time between them.
  // the note's duration + 10% seems to work well:
  pauseBetweenNotes = noteDuration * 1.1;
  playPnt++;
  if (playPnt >= numNotes) {playPnt = -2;} // reached final note
}

// ----------------------------------------------------------------------

void playLights() {
  // illuminate a row of lights sequentially
  switch (lightTask) {
    case 0:
      // walking lamps
      switch (ledPnt) {
        case 0: setArray(1,0,0,0,0,0); break;
        case 1: setArray(0,1,0,0,0,0); break;
        case 2: setArray(0,0,1,0,0,0); break;
        case 3: setArray(0,0,0,1,0,0); break;
        case 4: setArray(0,0,0,0,1,0); break;
        case 5: setArray(0,0,0,0,0,1); break;
      } 
      ledPnt++; if (ledPnt > 5) {
      lightTask++; ledPnt = 0;
      if (lightTask > lightTaskMax) {lightTask = 0;}
   } break;
    case 1:
      // just patterns
      switch (ledPnt) {
        case 0: setArray(1,0,1,0,1,0); break;
        case 1: setArray(0,1,0,1,0,1); break;
        case 2: setArray(1,1,1,0,0,0); break;
        case 3: setArray(0,0,0,1,1,1); break;
        case 4: setArray(0,1,0,0,1,0); break;
        case 5: setArray(1,0,1,1,0,1); break;
      } 
      ledPnt++; if (ledPnt > 5) {
      lightTask++; ledPnt = 0;
      if (lightTask > lightTaskMax) {lightTask = 0;}
    } break;
    case 2:
      // walking 2's
      switch (ledPnt) {
        case 0: setArray(1,1,0,0,0,0); break;
        case 1: setArray(0,1,1,0,0,0); break;
        case 2: setArray(0,0,1,1,0,0); break;
        case 3: setArray(0,0,0,1,1,0); break;
        case 4: setArray(0,0,0,0,1,1); break;
      } 
      ledPnt++; if (ledPnt > 4) {
      lightTask++; ledPnt = 0;
      if (lightTask > lightTaskMax) {lightTask = 0;}
    } break;
    case 3:
      // 2 out and in
      switch (ledPnt) {
        case 0: setArray(0,0,1,1,0,0); break;
        case 1: setArray(0,1,0,0,1,0); break;
        case 2: setArray(1,0,0,0,0,1); break;
        case 3: setArray(0,1,0,0,1,0); break;
        case 4: setArray(0,0,1,1,0,0); break;
      } 
      ledPnt++; if (ledPnt > 4) {
      lightTask++; ledPnt = 0;
      if (lightTask > lightTaskMax) {lightTask = 0;}
    } break;
    case 4:
      // random lamps
      setArray(random(2),random(2),random(2),random(2),random(2),random(2));
      ledPnt++; if (ledPnt > 16) {
      lightTask++; ledPnt = 0;
      if (lightTask > lightTaskMax) {lightTask = 0;}
    } break;
    case 5:
      // full to nothing centre
      switch (ledPnt) {
        case 0: setArray(1,1,1,1,1,1); break;
        case 1: setArray(0,1,1,1,1,0); break;
        case 2: setArray(0,0,1,1,0,0); break;
        case 3: setArray(0,0,0,0,0,0); break;
      } 
      ledPnt++; if (ledPnt > 3) {
      lightTask++; ledPnt = 0;
      if (lightTask > lightTaskMax) {lightTask = 0;}
    } break;
  }
}

// ----------------------------------------------------------------------

void readIR() {
  // read the IR sensor every 200ms
  irDel = 200; // come here every 200ms
  if (irrecv.decode(&results)) {
    // we have received an IR signal
    irResult = results.value;
    irrecv.resume(); // ready to receive the next value
    translateIR();
    Serial.print("keyVal: ");
    Serial.println(keyVal);
    keyAction();
  }
}

// ----------------------------------------------------------------------

void readSerial() {
  // read a key from the serial port and react to it
  keyDel = 100; // come here every 100ms
  keyVal = Serial.read();
  if (keyVal != -1) {
    Serial.print("keyVal: ");
    Serial.println(keyVal);
    keyAction();
  }
}

// --------------------------------------------------------------------

void readSwitch1() {
  // reads a single switch and counts the number of presses
  swDel = 20; // come here every 20ms
  swRead = digitalRead(swB1);
  if (swRead != swState) {
    // a transition has occured!
    if (swRead == LOW) {swCnt++; swVal = 0;}

  }
  swState = digitalRead(swB1);
  swVal++; // increment timeout delay
  if (swVal == 100) {
    // no more presses after 2 seconds
    keyVal = 48 + swCnt; swCnt = 0;
    Serial.print("keyVal: ");
    Serial.println(keyVal);
    keyAction();
  }
}

// --------------------------------------------------------------------

void readSwitchN() {
  // reads multiple switches as a binary number
  swDel = 20; // come here every 20ms
  if (digitalRead(swB1) != HIGH || digitalRead(swB2) != HIGH || digitalRead(swB4) != HIGH) {
    // a transition has occured!
    if (swState == LOW) {
      if (digitalRead(swB1) == LOW) {swVal = (swVal | 1); }
      if (digitalRead(swB2) == LOW) {swVal = (swVal | 2); }
      if (digitalRead(swB4) == LOW) {swVal = (swVal | 4); }
    }
    else {swVal = 0;} // clear the previous old value
    swState = LOW;
  }
  else {
    if (swState == LOW) {
      // determine value on switch release
      keyVal = 48 + swVal;
      Serial.print("keyVal: ");
      Serial.println(keyVal);
      keyAction();
    }
  swState = HIGH;
  }
}

// --------------------------------------------------------------------

void runPOST() {
  // called once at power up or reset
  for (int zC = 0; zC < 40; zC++) {Serial.println("");} // CLS
  setLEDs(HIGH);
  delay(2000);
  Serial.println("POST Complete!");
  Serial.println("");
}

// ----------------------------------------------------------------------

void scanLeds() {
  // performs 1 scan of the LED matrix at 1 ms per scan
  // note that ledON + ledOFF must add up to 1000 microseconds
  for (int zL = 0; zL <= arrayMax; zL++) {
    if (ledVals[zL] > 0) {
      digitalWrite(ledPins[zL], HIGH);
    }
    else {digitalWrite(ledPins[zL], LOW);}
  }
  // light LEDs for ledON delay
  delayMicroseconds(ledON);
  // extinguish LEDs for ledOFF delay
  for (int zL = 0; zL <= arrayMax; zL++) {
    digitalWrite(ledPins[zL], LOW);
  }
  delayMicroseconds(ledOFF);
}

// ----------------------------------------------------------------------

void setArray(int zL0,int zL1, int zL2, int zL3, int zL4, int zL5) {
  // set individual array values by calling one function
  ledVals[0] = zL0; ledVals[1] = zL1; ledVals[2] = zL2;
  ledVals[3] = zL3; ledVals[4] = zL4; ledVals[5] = zL5;
}

// ----------------------------------------------------------------------

void setLedPnt() {
  // set ledPnt value to match lightTask
  clearStore();
  switch (lightTask) {
    case 0:
      ledPnt = 0; // set 1st row
      break;
    case 1:
      ledPnt = 0; // set 1st column
      break;
    case 2:
      ledPnt = 3; // set 1st row
      break;
    case 3:
      ledPnt = 3; // set 1st column
      break;
  }
}

// ----------------------------------------------------------------------

void setLEDs(int zState) {
  // set all LEDs to a given state. LOW = OFF, HIGH = ON.
  for (int zL = 0; zL <= arrayMax; zL++) {
    digitalWrite(ledPins[zL],zState);
  }
}

// ----------------------------------------------------------------------

void translateIR() {
  // takes action based on IR code received
  // describing KEYES Remote IR codes in the 1st case line
  // the KEYES remote conrol was now found to be 100% reliable
  // control codes for the main remote are in the 3rd and 4th lines
  // all codes can be re-assigned to suit another IR remote
  Serial.print("Rx Val: 0x");
  Serial.println(irResult, HEX);
  switch(irResult) {
//    case 0x54: Serial.println(" FORWARD"); break;
//    case 0xFF629D: keyVal = 22; break;
//    case 0x511DBB: keyVal = 22; break;
//    case 0x54: keyVal = 22; break;
//    case 0x854: keyVal = 22; break;
//    case 0x52A3D41F: Serial.println("< LEFT"); break;
    case 0xFF22DD: keyVal = 60; break;
    case 0x52A3D41F: keyVal = 60; break;
    case 0x55: keyVal = 60; break;
    case 0x855: keyVal = 60; break;
//    case 0x75: Serial.println(" -OK-"); break;
//    case 0xFF02FD: keyVal = 25; break;
//    case 0xD7E84B1B: keyVal = 25; break;
//    case 0x75: keyVal = 25; break;
//    case 0x875: keyVal = 25; break;
//    case 0x20FE4DBB: Serial.println(" RIGHT >"); break;
    case 0xFFC23D: keyVal = 62; break;
    case 0x20FE4DBB: keyVal = 62; break;
    case 0x56: keyVal = 62; break;
    case 0x856: keyVal = 62; break;
//    case 0x53: Serial.println(" REVERSE"); break;
//    case 0xFFA857: keyVal = 28; break;
//    case 0xA3C8EDDB: keyVal = 28; break;
//    case 0x53: keyVal = 28; break;
//    case 0x853: keyVal = 28; break;
//    case 0x41: Serial.println(" 1"); break;
    case 0xFF6897: keyVal = 49; break;
    case 0xC101E57B: keyVal = 49; break;
    case 0x41: keyVal = 49; break;
    case 0x841: keyVal = 49; break;
//    case 0x42: Serial.println(" 2"); break;
    case 0xFF9867: keyVal = 50; break;
    case 0x97483BFB: keyVal = 50; break;
    case 0x42: keyVal = 50; break;
    case 0x842: keyVal = 50; break;
//    case 0x43: Serial.println(" 3"); break;
    case 0xFFB04F: keyVal = 51; break;
    case 0xF0C41643: keyVal = 51; break;
    case 0x43: keyVal = 51; break;
    case 0x843: keyVal = 51; break;
//    case 0x44: Serial.println(" 4"); break;
    case 0xFF30CF: keyVal = 52; break;
    case 0x9716BE3F: keyVal = 52; break;
    case 0x44: keyVal = 52; break;
    case 0x844: keyVal = 52; break;
//    case 0x45: Serial.println(" 5"); break;
    case 0xFF18E7: keyVal = 53; break;
    case 0x3D9AE3F7: keyVal = 53; break;
    case 0x45: keyVal = 53; break;
    case 0x845: keyVal = 53; break;
//    case 0x46: Serial.println(" 6"); break;
    case 0xFF7A85: keyVal = 54; break;
    case 0x6182021B: keyVal = 54; break;
    case 0x46: keyVal = 54; break;
    case 0x846: keyVal = 54; break;
//    case 0x47: Serial.println(" 7"); break;
    case 0xFF10EF: keyVal = 55; break;
    case 0x8C22657B: keyVal = 55; break;
    case 0x47: keyVal = 55; break;
    case 0x847: keyVal = 55; break;
//    case 0x48: Serial.println(" 8"); break;
    case 0xFF38C7: keyVal = 56; break;
    case 0x488F3CBB: keyVal = 56; break;
    case 0x48: keyVal = 56; break;
    case 0x848: keyVal = 56; break;
//    case 0x49: Serial.println(" 9"); break;
    case 0xFF5AA5: keyVal = 57; break;
    case 0x449E79F: keyVal = 57; break;
    case 0x49: keyVal = 57; break;
    case 0x849: keyVal = 57; break;
//    case 0x57: Serial.println(" *"); break;
    case 0xFF42BD: keyVal = 42; break;
    case 0x32C6FDF7: keyVal = 42; break;
    case 0x57: keyVal = 42; break; // -/-- key
    case 0x857: keyVal = 42; break;
//    case 0x40: Serial.println(" 0"); break;
    case 0xFF4AB5: keyVal = 58; break;
    case 0x1BC0157B: keyVal = 58; break;
    case 0x40: keyVal = 58; break;
    case 0x840: keyVal = 58; break;
//    case 0x78: Serial.println(" #"); break;
    case 0xFF52AD: keyVal = 35; break;
    case 0x3EC3FC1B: keyVal = 35; break;
    case 0x78: keyVal = 35; break; // AV key
    case 0x878: keyVal = 35; break;
  }
}

