// Multiple Melodies

// Declare libraries
#include <NewTone.h>
#include "pitches.h"

// Declare and initialise global variables
#define swB1 13  // B1 switch input
#define speakerPin 2 // speaker is connected to digital pin 2

// Define arrays and variables
#define arrayMax 5  // max LED array element = size -1
#define arraySize 80 // max no. notes in any tune
int melody[arraySize]; // notes in teh melody
int noteDurations[arraySize]; // 4 = quarter, 8 = eighth, etc.:

int keyVal; // input value read from serial port
int loopCnt; // main loop delay counter
int loadPnt = 0; // pointer used to load arrays
int noteDuration = 0; // duration of a note being played in miliseconds
int numNotes = 0;  // number of notes. Must be less than arraySize
int pauseBetweenNotes = 10; // delay between a note
int playPnt = -1; // set >= 0 to play melody sequence
int swDel = 20; // relay between siwtch reads
int swCnt = 0; // number of switch presses
int swRead = HIGH; // latest input value
int swState = HIGH; //previous switch state
int swVal = 0; // temporary switch value or inactivity timer

// ----------------------------------------------------------------------

void setup() {
  // put your setup code here, to run once:
  pinMode(swB1, INPUT_PULLUP);
  pinMode(speakerPin, OUTPUT);
  digitalWrite(speakerPin, LOW);
  Serial.begin(9600);
}

// ----------------------------------------------------------------------

void loop() {
  // put your main code here, to run repeatedly:
  if (playPnt != -1) {
    // playing a note sequence
    if (playPnt > -1) {playANote();} // load the next note
    loopCnt = pauseBetweenNotes;
    while (loopCnt > 0) {
        // this is the main loop with a 1ms loop time
        swDel--; if (swDel <1) {readSwitch1();} // single switch
        loopCnt--; delay(1);
    }
    if (playPnt == -2) {
      // last note reached so turn off sound
      noNewTone(speakerPin); digitalWrite(speakerPin, LOW);
      playPnt = -1;
    }
  }
  else {
    // not playing a note sequence so just scan keys
    swDel--; if (swDel <1) {readSwitch1();} // single switch
    delay(1);
  }
}

// ----------------------------------------------------------------------

void keyAction() {
  // called when a switch has been pressed
  switch (keyVal) {
    case 1: loadMelody0(); break;
    case 2: loadMelody1(); break;
  }
}

// ----------------------------------------------------------------------

void loadArray(int zN, int zD) {
  // load values into arrays at position zP
  melody[loadPnt] = zN;
  noteDurations[loadPnt] = zD;
  loadPnt++;
}

// ----------------------------------------------------------------------

void loadMelody0() {
  // load a 1 note melody
  noNewTone(speakerPin); // stop current melody
  loadPnt = 0;
  loadArray(NOTE_C4, 4); // 1st note..

  numNotes = loadPnt; // length of melody addressed, numNotes - 1
  playPnt = 0; // point to first note to start playing melody
}

// ----------------------------------------------------------------------

void loadMelody1() {
  // load a 2 note melody
  noNewTone(speakerPin); // stop current melody
  loadPnt = 0;
  loadArray(NOTE_C4, 4); // 1st note..
  loadArray(NOTE_C4, 4); // 2nd note..

  numNotes = loadPnt; // length of melody addressed, numNotes - 1
  playPnt = 0; // point to first note to start playing melody
}

// ----------------------------------------------------------------------

void playANote() {
  // play a note at the current pointer then increment pointer
  
  // calculate note duration by taking 1 second divided by note type.
  //e.g. quarter note = 1000 / 4, eighth note = 1000/8, etc.
  noteDuration = 1000 / noteDurations[playPnt];
  NewTone(speakerPin, melody[playPnt], noteDuration);
  // to distinguish the notes, set a minimum time between them.
  // the note's duration + 10% seems to work well:
  pauseBetweenNotes = noteDuration * 1.1;
  playPnt++;
  if (playPnt >= numNotes) {playPnt = -2;} // reached final note
}

// --------------------------------------------------------------------

void readSwitch1() {
  // reads a single switch and counts the number of presses
  swDel = 20; // come here every 20ms
  swRead = digitalRead(swB1);
  if (swRead != swState) {
    // a transition has occured!
    if (swRead == LOW) {swCnt++; swVal = 0;}
  }
  swState = digitalRead(swB1);
  swVal++; // increment timeout delay
  if (swVal == 50) {
    // no more presses after 1 seconds
    keyVal = swCnt; swCnt = 0;
    keyAction();
  }
}

