// LED's

// Define arrays
#define arrayMax 5  // max array element = size -1
int ledPins[arrayMax + 1] = {10,9,8,7,6,5};
int ledVals[arrayMax + 1] = {0,0,0,0,0,0};

// Declare and initialise global variables
int ledPnt = 0; // LED task pointer

void setup() {
  // put your setup code here, to run once:
  pinMode(ledPins[0], OUTPUT);
  pinMode(ledPins[1], OUTPUT);
  pinMode(ledPins[2], OUTPUT);
  pinMode(ledPins[3], OUTPUT);
  pinMode(ledPins[4], OUTPUT);
  pinMode(ledPins[5], OUTPUT);
  Serial.begin(9600);
}

void loop() {
  // put your main code here, to run repeatedly:
  playLights();
  scanLeds();
  delay(500);
}

void playLights() {
  // illuminate a row of lights sequentially
  // walking lamps
  switch (ledPnt) {
    case 0: setArray(1,0,0,0,0,0); break;
    case 1: setArray(0,1,0,0,0,0); break;
    case 2: setArray(0,0,1,0,0,0); break;
    case 3: setArray(0,0,0,1,0,0); break;
    case 4: setArray(0,0,0,0,1,0); break;
    case 5: setArray(0,0,0,0,0,1); break;
  } 
  ledPnt++; if (ledPnt > 5) {ledPnt = 0;}
}

void scanLeds() {
  // performs 1 scan of the LED matrix
  for (int zL = 0; zL <= arrayMax; zL++) {
    if (ledVals[zL] > 0) {digitalWrite(ledPins[zL], HIGH);}
    else {digitalWrite(ledPins[zL], LOW);}
  }
}

void setArray(int zL0,int zL1, int zL2, int zL3, int zL4, int zL5) {
  // set individual array values by calling one function
  ledVals[0] = zL0; ledVals[1] = zL1; ledVals[2] = zL2;
  ledVals[3] = zL3; ledVals[4] = zL4; ledVals[5] = zL5;
}



