// Infrared Receiver

// Read an IR code from the receiver on Pin 3.

// Declare libraries
#include "IRremote.h"
#define receiver 3 // pin 3 of IR receiver to pin 3

// Declare objects
IRrecv irrecv(receiver);  // create instance of 'irrecv'
decode_results results;   // create instance of 'decode_results'

// Declare and initialise global variables
long irResult; //value received

void setup() {
  // put your setup code here, to run once:
  irrecv.enableIRIn(); // initialise IR receiver
  Serial.begin(9600);
}

void loop() {
  // put your main code here, to run repeatedly:
  readIR();
  delay(120);
}

void readIR() {
  // read the IR sensor
  if (irrecv.decode(&results)) {
    // we have received an IR signal
    irResult = results.value;
    Serial.print("Rx Val: 0x");
    Serial.println(irResult, HEX);
    irrecv.resume(); // ready to receive the next value
  }
}


