// Switches

// Read and count switch transitions on Pin 13.
// display count after 2 second pause

#define swB1 13 // declare switch i/p pin
#define swB2 12 // declare switch i/p pin
#define swB4 11 // declare switch i/p pin

int swState = HIGH; //previous switch state
int swVal = 0; // combined value of switches

void setup() {
  // put your setup code here, to run once:
  pinMode(swB1, INPUT_PULLUP);
  pinMode(swB2, INPUT_PULLUP);
  pinMode(swB4, INPUT_PULLUP);
  Serial.begin(9600);
}

void loop() {
  // put your main code here, to run repeatedly:
  if (digitalRead(swB1) != HIGH || digitalRead(swB2) != HIGH || digitalRead(swB4) != HIGH) {
    // a transition has occured!
    if (swState == LOW) {
      if (digitalRead(swB1) == LOW) {swVal = (swVal | 1); }
      if (digitalRead(swB2) == LOW) {swVal = (swVal | 2); }
      if (digitalRead(swB4) == LOW) {swVal = (swVal | 4); }
    }
    else {swVal = 0;} // clear the previous old value
    swState = LOW;
  }
  else {
    if (swState == LOW) {Serial.println(swVal);}
  swState = HIGH;
  }
  delay(20);
}



