// Switches

// Read switch transitions on Pin 13.

#define swPin 13 // declare switch i/p pin

int swCnt = 0; // number of switch presses
int swRead = HIGH; // latest input value
int swState = HIGH; //previous switch state
int timeout = 0; // inactivity timeout timer

void setup() {
  // put your setup code here, to run once:
  pinMode(swPin, INPUT_PULLUP);
  Serial.begin(9600);
}

void loop() {
  // put your main code here, to run repeatedly:
  swRead = digitalRead(swPin);
  if (swRead != swState) {
    // a transition has occured!
    if (swRead == LOW) {swCnt++; timeout = 0;}

  }
  swState = digitalRead(swPin);
  timeout++; // increment timeout delay
  if (timeout == 100) {Serial.println(swCnt); swCnt = 0;}
  delay(20);
}


