//
// Most of these functions are for use in development only. If they are not
// called from the main code it will not be compiled by the IDE.

// ------------------------------------------------------------------------------

void WiFi_Echo() {
  // Echos the response from the Open Smart tranasciver to the USB port.
  // As we are sharing the Rx/Tx pins with the Open Smart transceiver, in AT mode
  // the echo to its own responses means that the receiver is constantly putting
  // out 'N'+CR+LF characters which need to be detected and ignored.
  byte zRx0, zRx1;
  unsigned long zExitTime = millis() + 500;  // allow 1/2 second for a response
  while (millis() < zExitTime) {
    if (SoftSerial.available()) {
      zRx0 = SoftSerial.read();  // get recevied data
      if (zRx0 == 'N') {
        // ignore this if it is followed by a CR
        while (!SoftSerial.available()) {}  // wait for next character
        zRx1 = SoftSerial.read();  // get second recevied data
        if (zRx1 != 13) {
          // if not a CR so echo both values
          Serial.write(zRx0); Serial.write(zRx1);
        } else {
          // if CR then ignore both Rx0 and Rx1 and LF
          while (!SoftSerial.available()) {}  // wait for next character
          zRx0 = SoftSerial.read();  // get recevied data and ignore it
        }
      } else {Serial.write(zRx0);} // not 'N' so echo value
    }
  }
}

// ------------------------------------------------------------------------------

void WiFi_Flash() {
  // call the function to flash your desired settings into the Open Smart
  // transceiver using AT commnds. To observe this action you need to use the
  // IDE serial monitor at 9600 Baud.
  SoftSerial.begin(9600); // baud rate for Rx/Tx comms
  Serial.println(F("\nFlashing Open Smart Transceiver...")); // request firmware values
  Serial.flush();             // empty Tx buffer
  digitalWrite(AT_Cmd, LOW);  // set wireless in transparent mode
  delay(50);                  // allow transceiver time to switch modes
  
  // set Baud rate for transparent non-AT mode to 115200, my default
  // 0 = 2400
  // 1 = 4800
  // 2 = 9600 (factory default)
  // 3 = 14400 (not support by IDE serial monitor)
  // 4 = 19200
  // 5 = 38400
  // 6 = 57600
  // 7 = 115200
  // 8 = 128000 (not support by IDE serial monitor)
  // 9 = 256000 (not support by IDE serial monitor)
  SoftSerial.println(F("\nAT+BAUD=7")); // set Baud rate to 9600
  WiFi_Echo();

  // set frequency to 2478MHz (factory default)
  // Frequenc F = 2400 + **, where ** is in the range of 0x00 to 0x7F
  SoftSerial.println(F("\nAT+FREQ=4E")); // set frequency to 2478MHz
  WiFi_Echo();

  // set the number of retransmissions between 2 and 15, 0x02 - 0x0F
  // if the robot is not reporting data then this can be set low so that it
  // does not hog the control channel at long or very short range
  SoftSerial.println(F("\nAT+RETRY=0A")); // set retry to 10, my default
  WiFi_Echo();

  // set whether to return 'S' and 'F' messages
  SoftSerial.println(F("\nAT+BACK=0")); // set return to OFF, my default
  WiFi_Echo();

  // set TX ID to 0x5555555555, default factory
  SoftSerial.println(F("\nAT+TID=5555555555")); // set TX ID
  WiFi_Echo();

  // set RX ID to 0x5555555555, default factory
  SoftSerial.println(F("\nAT+RID=5555555555")); // set RX ID
  WiFi_Echo();

  // set transmit power to +13dBm (default)
  // 00 = +13dBm
  // 01 = +10dBm
  // 02 =  +8dBm
  // 03 =  +7dBm
  // 04 =  +5dBm
  // 05 =  +4dBm
  // 06 =  +2dBm
  // 07 =   0dBm
  // 08 =  -3dBm
  // 09 =  -6dBm
  // 0A = -10dBm
  // 0B = -18dBm
  // 0C = -30dBm
  SoftSerial.println(F("\nAT+POWER=00")); // set Tx Power = 0dBm
  WiFi_Echo();
  
  Serial.println(F("\nFlashing complete."));
  Serial.flush();     // empty Tx buffer
  digitalWrite(AT_Cmd, HIGH);  // set wireless in transparent mode
}

// ------------------------------------------------------------------------------

void WiFi_Report() {
  // use AT commands to report the current settings in the Open Smart 2.4GHz
  // wireless transciever.
  SoftSerial.begin(9600); // baud rate for Rx/Tx comms
  SoftSerial.flush();     // empty Tx buffer
  digitalWrite(AT_Cmd, LOW);  // set wireless in transparent mode
  delay(50);                  // allow transceiver time to switch modes
  SoftSerial.println(F("\nAT+INF")); // request firmware values
  WiFi_Echo();
  SoftSerial.println(F("\nAT+BAUD?")); // request Baud rate
  WiFi_Echo();
  SoftSerial.println(F("\nAT+FREQ?")); // request Frequency
  WiFi_Echo();
  SoftSerial.println(F("\nAT+RETRY?")); // request number of retries
  WiFi_Echo();
  SoftSerial.println(F("\nAT+BACK?")); // request response value
  WiFi_Echo();
  SoftSerial.println(F("\nAT+TID?")); // request Tx ID value
  WiFi_Echo();
  SoftSerial.println(F("\nAT+RID?")); // request Rx ID value
  WiFi_Echo();
  SoftSerial.println(F("\nAT+POWER?")); // request Tx Power settings
  WiFi_Echo();
  Serial.println(F("\nWiFi Report Ends"));
  Serial.flush();     // empty Tx buffer
  digitalWrite(AT_Cmd, HIGH);  // set wireless in transparent mode
}

// ------------------------------------------------------------------------------

void WiFi_Reset() {
  // use AT commands to Factory RESET the Open Smart transceiver
  SoftSerial.begin(9600); // baud rate for Rx/Tx comms
  SoftSerial.flush();     // empty Tx buffer
  digitalWrite(AT_Cmd, LOW);  // set wireless in transparent mode
  delay(50);                  // allow transceiver time to switch modes
  SoftSerial.println(F("\nAT+RESET")); // request firmware values
  WiFi_Echo();
  SoftSerial.flush();     // empty Tx buffer
  digitalWrite(AT_Cmd, HIGH);  // set wireless in transparent mode
}

// ------------------------------------------------------------------------------
