
// ---------------------------------------------------------------------------------

void Do_Main_Tasks(){
  // called from the main loop to perform high level functions or sequences
  switch(MainTask) {
    case -1: if ((Head < 1) && (Walk < 1)) {SetMainTask(0);} break; // an initiation task was run
    case 0: break;  // default do nothing
    case 1: Main_Toggle_LTOF(); break;
    case 2: Track = false; Main_LTOF_Retreat(); break;
    case 3: Track = true; Main_LTOF_Retreat(); break;
    case 4: Main_LTOF_Scan(); break;
    case 10: Main_Move_Demo(); break;   // demonstrates a range of movements
    case 95: Move_To_Memory(); break;     // run a move from Mem[] using MemRow pointer
    case 96: Move_As_Memory(0,0,Speed); MainTask = -1; break;    // run a move sequence from Mem[] once only
    case 97: Move_As_Memory(0,1,Speed); MainTask = -1; break;    // run a move sequence from Mem[] continuously
    case 98: Move_To_Rest_Task(); break;
    case 99:
      // temporary wait function used by several main tasks
      MainTaskWait--; if (MainTaskWait < 1) {MainTask = MainTaskNext;}
      break;
  }
}

// ---------------------------------------------------------------------------------

void Main_LTOF_Retreat() {
  // droid retreats from an approaching object
  switch(mainSubTask) {
    case 0:
      // turn on LTOF for ranging
      if (LTOF_On < 1) {
        if (AtRest) {
          // at reast so we need to move to ready position
          MoveToReady(0); WaitWhileMove();
        } VL53L0X_ON();
      } 
      MoveHeadTo(90, 50); // centralise head
      eyeB = 0; eyeG = 0; eyeR = 10; LEDTaskPnt = 2; LEDSubTask = 0;
      LEDMthTask = 10; LEDMthVal = 0;
      WalkCnt = 0;  // zero counter on how far it has walked
      MoveState = 0; mainSubCnt = 0; mainSubTask++; break;
    case 1:
      // respond to target
      LEDMthVal = map(RangeFtd, 100,600,5,0);
      if (LEDMthVal > 0) {
        if (HeadTask > 1) {HeadTask = 0;}
        mainHedCnt = 100;
      } else {
        // if nothing about then return to random movement after a delay
        if (mainHedCnt > 0) {
          mainHedCnt--;
          if (mainHedCnt < 1) {HeadTask = 10;}
        }
      }
//      Serial.print("Range "); Serial.println(RangeFtd);
      if (RangeFtd <= 500) {
        if (!Track) {
          // working in 'retreat' mode
          if (MoveState == 1) {MoveToReady(0); WaitWhileMove(); MoveState = 0;}
          // target detected, so start/continue walking backwards
          WalkInc = -1; WalkWait = 250;
          if (Walk < 1) {
            // just starting off
            MoveToSkiBkd(); Speed = 20; MoveState = 5; Trans = !Trans;
          }
          if (RangeFtd >= 200) {SpeedTgt = map(RangeFtd,200,500,45,20);}
          else if (RangeFtd >= 150) {SpeedTgt = 45;}
          else {SpeedTgt = map(RangeFtd,50,150,10,45);}
        } else {
          // working in 'track' mode
          if (RangeFtd >= 350) {
            // advance towards target
            if (Walk < 1) {
              MoveToSkiFwd(); Speed = 20; MoveState = 1; Trans = !Trans;
            } else if (MoveState != 1) {
              MoveToReady(0); WaitWhileMove(); MoveState = 0;}
            if (RangeFtd >= 450) {SpeedTgt = 80;}
            else {SpeedTgt = map(RangeFtd,350,450,10,80);}
          } else if (RangeFtd >= 300) {
            // in centre deadband region. If moving stop
            if (Walk > 0) {
              MoveToReady(0); WaitWhileMove(); MoveState = 0;
            }
          } else {
            // in retreat region
            if (Walk < 1) {
              // just starting off
              MoveToSkiBkd(); Speed = 20; MoveState = 5; Trans = !Trans;
            }
            if (RangeFtd >= 150) {SpeedTgt = map(RangeFtd,150,300,45,20);}
            else if (RangeFtd >= 100) {SpeedTgt = 45;}
            else {SpeedTgt = map(RangeFtd,0,100,10,45);}
          }
        }
        if (SpeedTgt > Speed) {
          // increase speed progressively to avoid sudden changes
          SpeedCnt++; if (SpeedCnt > 3) {SpeedCnt = 0; Speed++;}
        } else {Speed = SpeedTgt;}
        setLegSpeed(Speed); mainSubCnt = 100;  // set speed and over-run delay counter
      } else if (RangeFtd > 500) {
        if (mainSubCnt > 0) {
          // allow some over-run to avoid fits and starts
          mainSubCnt--;
          if (mainSubCnt < 1) {
            MoveToReady(0); WaitWhileMove(); MoveState = 0;
            // compensate for difference in move row counts, Bkd = 14, Fwd = 11
            if (WalkCnt < 0) {WalkCnt = (WalkCnt * 11)/14;}
          }
        } else {
          // finished moving, so walk back after a delay if in retreat mode
          if (!Track) {
            WalkInc = 1;
            if (WalkWait > 0) {WalkWait--;}
            else if (WalkCnt < 0) {
              // droid has moved some distance backwards, so after a delay bring it forward
              if (Walk < 1) {
                // just starting off to return to start
                MoveToSkiFwd(); MoveState = 1; Trans = !Trans;
              } else if (Speed < 45) {
                SpeedCnt++; if (SpeedCnt > 5) {SpeedCnt = 0; Speed++;}
              }
            } else {
               if (MoveState > 0) {MoveToReady(0); WaitWhileMove(); MoveState = 0;}
            }
          }
        }
      }
      break;
  }
}

// ---------------------------------------------------------------------------------

void Main_LTOF_Scan() {
  // move head left to right and report ranges  
  switch(mainSubTask) {
    case 0:
      // turn on LTOF for ranging
      if (AtRest) {
        // at reast so we need to move to ready position
        MoveToReady(0); WaitWhileMove();
      }
      HeadTask = 20;  // set head into scan mode, it will turn ON LTOF
      LEDMthTask = 30; // set mouth LED tasks in ranging mode
      mainSubTask++; break;
    case 1:
      break;
  }
}

// ---------------------------------------------------------------------------------

void Main_Move_Demo() {
  // demonstrates specific moves base on the SW1 button count, all at slow speed
  switch(mainSubTask) {
    case 0:
      // if two many button pressed then abort
      if (mainMode > 4) {SetMainTask(0); return;}

      // if at rest we need to move to ready position
      if (AtRest) {mainEn = false; MoveToReady(1); loopWhileWalk(); mainEn = true;}

      moveCycleCnt = 0; Speed = 40; setLegSpeed(Speed); LEDMthTask = 20;
      if (mainMode == 1) {MoveState = 1; MoveToSkiFwd();}
      if (mainMode == 2) {MoveState = 5; MoveToSkiBkd();}
      if (mainMode == 3) {MoveState = 1; MoveToWalkFwd();}
      if (mainMode == 4) {MoveState = 5; MoveToWalkBkd();}
      
      mainSubTask++; break;

    case 1:
      // here we wait for movements to complete
      if (moveCycleCnt >= 5) {mainSubTask++;}  // wait for move cycles to complete
      break;

    case 2:
      // bring it to Ready
      mainEn = false; MoveToReady(1); loopWhileWalk();
      MoveToAllAtRest(); loopWhileWalk(); mainEn = true;
      LEDMthTask = -1; SetMainTask(0); break;
  }
}

// ---------------------------------------------------------------------------------

void Main_Toggle_LTOF() {
  // user has pressed SW0 so toggle LTOF ON/OFF
  switch (mainSubTask) {
    case 0:
      if (LTOF_On < 1) {
        if (AtRest) {
          // at reast so we need to move to ready position
          MoveToReady(0); WaitWhileMove();
        }
        VL53L0X_ON();
        HeadTask = 10;  // move head randomly
        eyeB = 0; eyeG = 0; eyeR = 10; LEDTaskPnt = 2; LEDSubTask = 0;
        LEDMthTask = 10; LEDMthVal = 0;
        mainSubTask++;
      } else {
        VL53L0X_OFF(); SetMainTask(0); LEDMthTask = -1; LEDTaskPnt = -1;
        MoveToAllAtRest();  WaitWhileMove();
      } break;
    case 1:
      LEDMthVal = map(RangeFtd, 100,600,5,0);
      // if object detected, centre head
      if (LEDMthVal > 0) {
        if (HeadTask > 1) {HeadTask = 13;}
        mainHedCnt = 100;
      } else {
        // if nothing about then return to random movement after a delay
        if (mainHedCnt > 0) {
          mainHedCnt--;
          if (mainHedCnt < 1) {HeadTask = 10;}
        }
      }
//      Serial.print("Range "); Serial.println(Range);
      break;
  }
}

// ---------------------------------------------------------------------------------

void Move_As_Memory(int zRow, byte zMode,int zSpd) {
  // loads target angles stored in Mem[] as a move sequence.
  // zMode == 0 - do this once
  // zMode == 1 - do this continuously
  // this function sets up the move engine to load data automatically
  if (MoveMemTgtLoader(zRow)) {
    // load memory row 0 as angle targets and speed
    WalkMode = zMode;           // set mode as once == 0 or continuous == 1
    SetStartsToPPs();           // reset start positions
    Speed = zSpd;
    setLegSpeed(Speed);          // set walk speed
    Walk = 1;                   // initiate walking
  }
}

// ---------------------------------------------------------------------------------

void Move_To_Memory() {
  // load a move from memory Mem[MemRow] and move to it
  // this is for single stepping, only one row is loaded and run
  PrintTx += "Move_To_Memory\n";
  MTM_Step = true;  // set single step flag
  if (MoveMemTgtLoader(MemRow)) {
    WalkMem = 0; WalkMode = 0;
    SetStartsToPPs();           // reset start positions
    setLegSpeed(Speed);         // set walk speed and rate profile
    Walk = 1;                   // initiate walking
    MainTask = -1;              // don't repeat the current task without resetting things
  } else {
    // either the row is full of zeroes or the LegSteps value == zero
    SetMainTask(0); // return to default condition
  }
  MTM_Step = false;  // reset single step flag
}

// ---------------------------------------------------------------------------------

void Move_To_Rest_Task() {
  // returns the droid to the vertical rest position as a Main Task
  MoveToAllAtRest(); mainEn = false; loopWhileWalk(); mainEn = true;
  LEDMthTask = -1; SetMainTask(0);
}

// ---------------------------------------------------------------------------------
