
// ---------------------------------------------------------------------------------

void ClearPCAop() {
  // sets all 16 PWM channels to zero pulses, effectively OFF
  // even with OE enabled the servos will not receive any pulses
  for (int zC=0; zC < 16; zC++) {
    I2Cpwm.setPWM(zC, 0, 0);  // if OFFtime == ONtime the op never goes HIGH
  }
}

// ---------------------------------------------------------------------------------

void decodeKey(int zkeyVal) {
  // decodes zkeyVal and excutes on '.'
  next40ms = millis() + 10;
  if (zkeyVal == 10) {return;}
  if (zkeyVal == 13) {return;}
  keyChar = char(zkeyVal);
  int zNF = 0;
  switch (keyChar) {
    case '.': doCmd(); zNF = 1; break;
    case '!': Restart_Cmd(); zNF = 3; break;
    case '0': extendCmdVal(0); zNF = 1; break;
    case '1': extendCmdVal(1); zNF = 1; break;
    case '2': extendCmdVal(2); zNF = 1; break;
    case '3': extendCmdVal(3); zNF = 1; break;
    case '4': extendCmdVal(4); zNF = 1; break;
    case '5': extendCmdVal(5); zNF = 1; break;
    case '6': extendCmdVal(6); zNF = 1; break;
    case '7': extendCmdVal(7); zNF = 1; break;
    case '8': extendCmdVal(8); zNF = 1; break;
    case '9': extendCmdVal(9); zNF = 1; break;
  }
  if (zNF == 0) {
    if (cmdMode == ' ') {
      // test for new Command Mode char?
      switch (keyChar) {
        case 'q': cmdMode = 'Q'; break;
        case 'Q': cmdMode = 'Q'; break;
        case 's': cmdMode = 'S'; break;
        case 'S': cmdMode = 'S'; break;
      } cmdType = ' '; cmdVal = 0;
    } else {
      // test for Command Type char?
      switch (keyChar) {
        case 'e': cmdType = 'E'; break;
        case 'E': cmdType = 'E'; break;
        case 'f': cmdType = 'F'; break;
        case 'F': cmdType = 'F'; break;
        case 'l': cmdType = 'L'; break;
        case 'L': cmdType = 'L'; break;
        case 'm': cmdType = 'M'; break;
        case 'M': cmdType = 'M'; break;
        case 'o': cmdType = 'O'; break;
        case 'O': cmdType = 'O'; break;
        case 't': cmdType = 'T'; break;
        case 'T': cmdType = 'T'; break;
        case 'u': cmdType = 'U'; break;
        case 'U': cmdType = 'U'; break;
        case 'v': cmdType = 'V'; break;
        case 'V': cmdType = 'V'; break;
      }
    }
  }
  if (zNF == 3) {
    // clear received data
    cmdMode = ' '; cmdType = ' '; cmdVal = 0;
  }
}

// ---------------------------------------------------------------------------------

void doCmd() {
  // a '.' has been received so execute command if valid
//  Serial.print(cmdMode); Serial.print(cmdType); Serial.print(cmdVal); Serial.println('.');
  switch (cmdMode) {
    case ' ': break;
    case 'Q':
      if (cmdType == 'M') {PrintTx += "MQ2.";}  // respond WiFi mode 2
      break;
    case 'S':
      switch (cmdType) {
        case 'E': {ExportArrays(); break;}
        case 'F': {SetServoFreq(); break;}
        case 'L': {SetServoVLL(); break;}
        case 'O': {SetServoOE(cmdVal); break;}
        case 'T': {SetServoTarget(); break;}
        case 'U': {SetServoVUL(); break;}
        case 'V': {SetServoValue(); break;}
      } break;
  }
  // now reset the variables
  cmdMode = ' '; cmdType = ' '; cmdVal = 0;
}

// ---------------------------------------------------------------------------------

void ExportArrays() {
  // send the contents of the arrays to the serial port for the 16-Ch controller app
  // the general format is:
  // #F n
  // #L n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n
  // #R n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n
  // #U n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n
  int zV; // temporary pointer variable
  PrintTx += "#F " + String(pwmFreq) + "\n";
  PrintTx += "#L ";
  for (zV = 0; zV < 16; zV++) {
    PrintTx += String(SLL[zV]); if (zV < 15) {PrintTx += ",";}
  } PrintTx += "\n"; //PrintTxPacket(); delay(50);
  PrintTx += "#R ";
  for (zV = 0; zV < 16; zV++) {
    PrintTx += String(SRV[zV]); if (zV < 15) {PrintTx += ",";}
  } PrintTx += "\n"; //PrintTxPacket(); delay(50);
  PrintTx += "#U ";
  for (zV = 0; zV < 16; zV++) {
    PrintTx += String(SUL[zV]); if (zV < 15) {PrintTx += ",";}
  } PrintTx += "\n"; //next40ms = millis() + 50;
}

// ---------------------------------------------------------------------------------

void extendCmdVal(int zVal) {
  // adds a new digit to the right-hand end of cmdVal
  cmdVal = (cmdVal * 10) + zVal;  
}

// ---------------------------------------------------------------------------------

void GoToRest() {
  // immediately drives servos to default rest positions
  // waits two second then removes pulse and OE
  for (int zS = 0; zS < 16; zS++) {
    I2Cpwm.setPWM(zS, 0, SRV[zS]);
  }
  digitalWrite(Pin_OE, LOW); // enable all PWM outputs
  delay(2000);
  SetServoOE(1);  // go to power OFF state
}

// --------------------------------------------------------------------------------

void NeoPixel_SetAllMthLEDs(byte zR, byte zG, byte zB) {
  // set all mouth LEDs to one colour
  for (int zP = 0; zP < ledNum0; zP++) {
    strip0.setPixelColor(zP,strip0.Color(zR,zG,zB));
  } strip0.show();
}

// --------------------------------------------------------------------------------

void NeoPixel_SetMthLED(byte zPixNum, byte zR, byte zG, byte zB) {
  // set the colour of mouth LED zPixNum.
  strip0.setPixelColor(zPixNum,strip0.Color(zR,zG,zB));
  strip0.show();
}

// ---------------------------------------------------------------------------------

void PrintTxPacket() {
  // print a packet from the PrintTx buffer if it contains text
  if (PrintTx.length() < 1) {return;}
  // characters in string buffer so send some/all of them
  if (PrintTx.length() <= 32) {
    if (SerialRx) {Serial1.print(PrintTx);} else {Serial.print(PrintTx);}
    PrintTx = "";   // empty the buffer
  } else {
    if (SerialRx) {Serial1.print(PrintTx.substring(0,32));} else {Serial.print(PrintTx.substring(0,32));}
    PrintTx = PrintTx.substring(32);
//    // if sending data we shorten the inter-packet delay as receipt will hold off the app sending more
//    next40ms = millis() + 10;
  }
}

// ---------------------------------------------------------------------------------

void readBattery() {
  // read the voltage on the analog input and average it over ten counts
  // flash mouth LEDs to indicate capacity
  BattVol = analogRead(BattPin);
  BattAv = BattSum / 10; BattSum = BattSum + BattVol - BattAv;

  // display battery health in mouth LEDs
  mouthCnt--;
  if (mouthCnt == 10) {NeoPixel_SetMthLED(map(BattAv,BattMin,1023,0,5), 0, 0, 10);}
  else if (mouthCnt == 8) {NeoPixel_SetAllMthLEDs(0,0,0);}
  else if (mouthCnt < 1) {mouthCnt = 100;} // reset 2 second timer
}

// ---------------------------------------------------------------------------------

void Restart_Cmd() {
  // Restart this code 
  SetServoOE(1);  // disable PCA9685
  resetFunc();    //call reset
}

// ---------------------------------------------------------------------------------

void SetServoFreq() {
  // manually set servo PWM frequency, noiminally 50 Hz (40 - 100Hz)  
  if (cmdVal < 40) cmdVal = 40; // limit range values
  if (cmdVal > 100) cmdVal = 100; // limit range values
  if (cmdVal != pwmFreq) {
    pwmFreq = (float)cmdVal;
    I2Cpwm.setPWMFreq(pwmFreq);  // set PCA9685 PWM frequency
    PrintTx += "PWM Freq = " + String(pwmFreq) + "\n";
  }
}

// ---------------------------------------------------------------------------------

void SetServoOE(int zVal) {
  // manually set the servo board OE to HIGH or LOW
  if (zVal != 1) {
    // enabling PCA9685 outputs
    servoOE = 0;
    digitalWrite(Pin_OE, LOW); // enable all PWM outputs
    PrintTx += "OE=LO [ON]\n";
  } else {
    // disabling PCA9685 outputs. As this is asynchronous there is a risk that this
    // action will shorten one or more PWM pulses, so we remove them first
    servoOE = 1; ClearPCAop();
    delay(10 + (1000/int(pwmFreq)));  // wait longer than one PWM cycle
    digitalWrite(Pin_OE, HIGH); // disable all PWM outputs
    PrintTx += "OE=HI [OFF]\n";
  }
}

// ---------------------------------------------------------------------------------

void SetServoPW(int zCh, int zPWM) {
  // set the pulse width of a specified channel on the PCA9685 board
  // format: setPWM(channel,on,off)
  // setting 'on' = 0 means that the pulse 'off' can be 0 - 4095 (12-bits)
  I2Cpwm.setPWM(zCh, 0, zPWM);
  if (servoOE ==1) {SetServoOE(0);}  // if board is not enabled, enable it
}

// ---------------------------------------------------------------------------------

void SetServoTarget() {
  // set the target servo pointer 0 - 15 and report back
  if (cmdVal < 0) cmdVal = servoTgt;  // block out of range values
  if (cmdVal > 15) cmdVal = servoTgt; // block out of range values
  if (cmdVal != servoTgt) {
    servoTgt = cmdVal;
    PrintTx += "ST=" + String(servoTgt) + "\n";
  }
}

// ---------------------------------------------------------------------------------

void SetServoValue() {
  // set the target servo value LL - UL and report back
  if (cmdVal == 0) {
    // zero value sent from a disabled channel
    SRV[servoTgt] = cmdVal;
  } else if ((cmdVal >= int(SLL[servoTgt])) && (cmdVal <= int(SUL[servoTgt]))) {
    // in range value received
    SRV[servoTgt] = cmdVal;
  }
  I2Cpwm.setPWM(servoTgt, 0, SRV[servoTgt]);
  PrintTx += "SV=" + String(SRV[servoTgt]) + "\n";
}

// ---------------------------------------------------------------------------------

void SetServoVLL() {
  // store the lower limt value sent from the 16 channel servo controller
  SLL[servoTgt] = cmdVal;
}

// ---------------------------------------------------------------------------------

void SetServoVUL() {
  // store the upper limt value sent from the 16 channel servo controller
  SUL[servoTgt] = cmdVal;
}

// ---------------------------------------------------------------------------------
