///////////////////////////////////////////////////////////////////////////////////
//
// Functions mainly used for development and debugging
//
///////////////////////////////////////////////////////////////////////////////////
// In the final version most of this code will be commented out and not compiled

void DebugReport(int zRPnn ) {
  ///////////////////////////////////////////////////////////////////////
  // a choice of print statements to inspect variables dynamically
  ///////////////////////////////////////////////////////////////////////
  // note at 4ms cycle and 115200 baud string length is limited to 46 chars
  // max in a 4ms period, otherwise blocking will occur. If used of WiFi then
  // link corruption may occur; so to prevent rogue values we send data twice and
  // checked on receive as a valid pair of duplicate values, otherwise disgard it.
  switch (zRPnn) {
    case 0:
      if (RP_Title) {Serial.println(F("#AccRawOAX,AccRawOAY,AccRawZ")); RP_Title = false;}
      Serial.print(accelerometer_data_rawX_OA); Serial.print(F(","));
      Serial.print(accelerometer_data_rawY_OA); Serial.print(F(","));
      Serial.println(accelerometer_data_rawZ_i);
      break;
      
    case 1:
      if (RP_Title) {Serial.println(F("#AngAccX,AngAccY,AngGyrX,AngGyrY")); RP_Title = false;}
      Serial.print(angle_accX); Serial.print(F(","));
      Serial.print(angle_accY); Serial.print(F(","));
      Serial.print(angle_gyroX); Serial.print(F(","));
      Serial.println(angle_gyroY);
      break;

    case 2:
      if (RP_Title) {Serial.println(F("#PidErrX,Pid_PX,Pid_IX,Pid_DX")); RP_Title = false;}
      Serial.print(pid_error_tempY); Serial.print(F(","));
      FpSerialPrint(pid_p_ValY); Serial.print(F(","));
      Serial.print(pid_i_memY); Serial.print(F(","));
      Serial.println(pid_d_ValY);
      break;

    case 3:
      if (RP_Title) {Serial.println(F("#PidErrY,Pid_PY,Pid_IY,Pid_DY")); RP_Title = false;}
      Serial.print(pid_error_tempY); Serial.print(F(","));
      FpSerialPrint(pid_p_ValY); Serial.print(F(","));
      Serial.print(pid_i_memY); Serial.print(F(","));
      Serial.println(pid_d_ValY);
      break;

    case 4:
      if (RP_Title) {Serial.println(F("#DriveA,DriveB,DriveC,PIDo/p")); RP_Title = false;}
      Serial.print(MotorDriveA); Serial.print(F(","));
      Serial.print(MotorDriveB); Serial.print(F(","));
      Serial.print(MotorDriveC); Serial.print(F(","));
      Serial.println(pid_output);
      break;

    case 5:
      if (RP_Title) {Serial.println(F("#JoyX,Steer,JoyY,Pid_SpX")); RP_Title = false;}
      Serial.print(received_byte &  3); Serial.print(F(","));
      Serial.print(Steer); Serial.print(F(","));
      Serial.print(received_byte & 12); Serial.print(F(","));
      Serial.println(pid_setpointX);
      break;

    case 6:
      if (RP_Title) {Serial.println(F("#DriveA,DriveB,DriveC,PIDo/p")); RP_Title = false;}
      Serial.print(MotorDriveA); Serial.print(F(","));
      Serial.print(MotorDriveB); Serial.print(F(","));
      Serial.print(MotorDriveC); Serial.print(F(","));
      Serial.println(pid_output);
      break;
  }
}

// --------------------------------------------------------------------------------

void cmdReset() {
  // turn-OFF drive motors in case they were set in motion
//  driveMotors(0.0, 0.0, 0.0, 0.0);

  // recalibrate motor PWM mapping  
  MotorCal = true;    // controls motor PWM calibration, default = true
  motorCal();         // invoke PWM remapping

  // resets DEBUG variables to the default condition  
  cmdMode = ' ';      // command mode
  cmdRec;             // > 0 if a '~' has been received
  cmdSgn = 1;         // value polarity multiplier
  cmdSteer = 0;       // values used in motor steering
  cmdType = ' ';      // command type
  cmdVal = 0;         // value associated with a cmdType
  cmdXDrive = 0;      // values used in motor testing
  cmdYDrive = 0;      // values used in motor testing
  keyChar;            // any keyboard character
  keyVal;             // any keyboard value
  PID_SPJX = false;   // PID setpoint X jolt flag
  PID_SPJY = false;   // PID setpoint Y jolt flag
  RP_ON = false;      // if true then report values in DEBUG mode
  Steer_En = false;   // steering enabled flag
  X_DriveEn = false;  // motor X-drive enabled flag
  Y_DriveEn = false;  // motor Y-drive enabled flag

  Serial.println("!"); // '!' echo
}

// --------------------------------------------------------------------------------

void cmdSetMotors() {
  // called whenever a value is changes or motor drives are enabled/disabled
  // this logic ensures only enabled modes can be activated
  float ST = (float)cmdSteer; if (!Steer_En) {ST = 0.0;}
  float XD = (float)cmdXDrive; if (!X_DriveEn) {XD = 0.0;}
  float YD = (float)cmdYDrive; if (!Y_DriveEn) {YD = 0.0;}
//  driveMotors(XD,YD,sqrt(sq(XD) + sq(YD)),ST);
}

// --------------------------------------------------------------------------------

void doCmd() {
  // a '.' has been received so execute command if valid
  // supported commands are:
  //
  //  AVnn. - set ACM value to nn.
  //  C0.   - disable motor calibration, default is ON
  //  C1.   - enable motor calibration, default
  //  D0.   - disable PID d-gain
  //  D1.   - enable PID d-gain
  //  DD.   - decrease the d-gain by 0.1
  //  DU.   - increase the d-gain by 0.1
  //  DVnn. - set 'D' gain value to nn/10
  //  I0.   - disable PID i-gain
  //  I1.   - enable PID i-gain
  //  ID.   - decrease the i-gain by 0.1
  //  IU.   - increase the i-gain by 0.1
  //  IVnn. - set 'I' gain value to nn/100
  //  PD.   - decrease the P-gain by 1.0
  //  PU.   - increase the P-gain by 1.0
  //  PVnn. - set 'P' gain value to nn/10
  //  QM.   - query robot control mode - essential command for WiFi operation
  //  R.    - report over the serial link
  //  RPnn. - report nn data over the serial link
  //  S0.   - set Steer OFF
  //  S1.   - set Steer ON
  //  SGnn. - set 'S' gain value to nn/10
  //  SSn.  - PID setpoint jolt, 0 = OFF, 1 = X ON, 2 = Y ON, 3 = X & Y ON
  //  SVnn. - set Steer value to nn
  //  X0.   - set X-drive OFF
  //  X1.   - set X-drive ON
  //  XVnn. - set X-drive value to nn
  //  Y0.   - set Y-drive OFF
  //  Y1.   - set Y-drive ON
  //  YVnn. - set Y-drive value to nn
  //  .     - report the P,I,D gains and much more!
  
  bool zPLF = true; // if true at the end a line feed will be printed
  switch (cmdMode) {
    case ' ':
      // recevied a '.' only so report PID gains
      Serial.println(""); printGains(); zPLF = false; break;
    case 'A':
      switch (cmdType) {
        case 'V':
          if (MotorCal) {ACM = cmdVal; motorCal(); cmdSetMotors();} break;
      } break;
    case 'C':
      // toggle motor calibration ON/OFF, default is ON
      if (cmdVal > 0) {MotorCal = true;}
      else {MotorCal = false;} motorCal(); cmdSetMotors(); break;
    case 'D':
      // PID controller D commands
      switch (cmdType) {
        case ' ': 
          if (cmdVal > 0) {PID_d_En = true;}
          else {PID_d_En = false;} break;
        case 'D': pid_d_gain -= 0.1;  break;
        case 'U': pid_d_gain += 0.1; break;
        case 'V': pid_d_gain = (float)cmdVal/10.0; break;
      } 
      Serial.print(F("D")); Serial.print((int)(pid_d_gain * 10.0)); break;
    case 'I':
      // PID controller I commands
      switch (cmdType) {
        case ' ': 
          if (cmdVal > 0) {PID_i_En = true;}
          else {PID_i_En = false;} break;
        case 'D': pid_i_gain -= 0.1;  break;
        case 'U': pid_i_gain += 0.1; break;
        case 'V': pid_i_gain = (float)cmdVal/100.0; break;
      }
      if (pid_i_gain < 0.01) {pid_i_memX = 0.0; pid_i_memY = 0.0;}
      Serial.print(F("I")); Serial.print((int)(pid_i_gain * 100.0)); break;
    case 'P':
      // PID controller P commands
      switch (cmdType) {
        case 'D': pid_p_gain -= 1.0;  break;
        case 'U': pid_p_gain += 1.0; break;
        case 'V': pid_p_gain = (float)cmdVal/10.0; break;
      } Serial.print(F("P")); Serial.print((int)(pid_p_gain * 10.0)); break;
    case 'Q':
      // WiFi query mode command received, so respond
      // this robot uses Mode = 0 WiFi transmission protocol
      switch (cmdType) {
        case 'M': Serial.print(F("MQ0.")); break;
      } break;
    case 'R':
      // PID controller report commands
      switch (cmdType) {
        case ' ': 
          // report the same set of values twice as WiFi data can easily be
          // corrupted. Therefore two consequitives messages must be received
          // for the PID Controller graphing function to work
          RP_ON = true; // set flag to indicate that we are reporting data
          RPms = millis() - RPt0; RPt0 = millis();
          RPP = 0; DebugReport(RPnn);
          RPP = 1; DebugReport(RPnn);
          zPLF = false; break;
        case 'P':
          RPnn = cmdVal; RP_Title = true;
          Serial.print(F("RP")); Serial.print(RPnn); break;
      } break;
    case 'S':
      // Motor Steer commands & PIS setpoint jolt
      switch (cmdType) {
        case ' ':
          if (cmdVal > 0) {Steer_En = true;}
          else {Steer_En = false;}
          cmdSetMotors(); break;
        case 'G':
          pid_s_gain = ((float)cmdVal)/10000.0;
          Serial.print(F("S")); Serial.print((int)(pid_s_gain * 10000.0)); break;
        case 'S':
          if (cmdVal < 1) {PID_SPJX = false; PID_SPJY = false;}
          if (cmdVal == 1) {PID_SPJX = true; PID_SPJY = false; PID_SPJXC = 0;}
          if (cmdVal == 2) {PID_SPJX = false; PID_SPJY = true; PID_SPJYC = 0;}
          if (cmdVal == 3) {PID_SPJX = true; PID_SPJY = true; PID_SPJXC = 0; PID_SPJYC = 0;}
          break;
        case 'V':
          cmdSteer = cmdVal * cmdSgn;
          cmdSetMotors(); break;
      } break;
    case 'X':
      // Motor X-Drive commands
      switch (cmdType) {
        case ' ':
          if (cmdVal > 0) {X_DriveEn = true;}
          else {X_DriveEn = false;}
          cmdSetMotors(); break;
        case 'V':
          cmdXDrive = cmdVal * cmdSgn;
          cmdSetMotors(); break;
      } break;
    case 'Y':
      // Motor Y-Drive commands
      switch (cmdType) {
        case ' ':
          if (cmdVal > 0) {Y_DriveEn = true;}
          else {Y_DriveEn = false;}
          cmdSetMotors(); break;
        case 'V':
          cmdYDrive = cmdVal * cmdSgn;
          cmdSetMotors(); break;
      } break;
  }
  // now reset the variables
  cmdMode = ' '; cmdType = ' '; cmdVal = 0; cmdSgn = 1;
  if (zPLF) {Serial.println("");}
}

// --------------------------------------------------------------------------------

void extendCmdVal(int zVal) {
  // adds a new digit to the right-hand end of cmdVal
  cmdVal = (cmdVal * 10) + zVal;  
}

// --------------------------------------------------------------------------------

void FpSerialPrint(float zP) {
  // print floating point number limited to 4 significant digits, without CR
  if (abs(zP) < 100.0) {Serial.print(zP); return;}
  if (abs(zP) < 1000.0) {Serial.print(zP,1); return;}
  Serial.print((int)zP);
}

// --------------------------------------------------------------------------------

void FpSerialPrintln(float zP) {
  // print floating point number limited to 4 significant digits, with CR
  if (abs(zP) < 100.0) {Serial.println(zP); return;}
  if (abs(zP) < 1000.0) {Serial.println(zP,1); return;}
  Serial.println((int)zP);
}

// --------------------------------------------------------------------------------

void printGains() {
  // print the current gain factors
  Serial.print(F("PID="));
  Serial.print(pid_p_gain); Serial.print(F(",\t"));
  if (PID_i_En) {Serial.print(pid_i_gain);}
  else {Serial.print(F("--.--"));} Serial.print(F(",\t"));
  if (PID_d_En) {Serial.print(pid_d_gain);}
  else {Serial.print(F("--.--"));} Serial.print(F(",\t"));
  Serial.println(pid_s_gain,4);
}
// --------------------------------------------------------------------------------

void readKey() {
  // reads a key from the keyboard annd reacts accordingly
  keyVal = Serial.read();
  if (keyVal == -1) return; // no serial data received

  // a character/byte has been received
  keyChar = char(keyVal); cmdRec = 1; WiFi_ON = true; // value received
  if (readTask > 0) {
    // receipt of MQ0 data has been scheduled due to '<' being received
    // the next byte after this is assumed to be a 'Nunchuk command
    // the next byter must be '>' or the command is invalid
    switch (readTask) {
      case 1:
        if (keyChar == '>') {received_cmd = true;} 
        else {received_byte = 0; received_cmd = false;}
        readTask = 0; return;
      case 2: received_byte = keyVal; readTask--; return;
    }
  }
//  Serial.print(F("keyVal=")); Serial.print(keyChar);
//  Serial.print(F("   ASCII=")); Serial.println(keyVal);
//  Serial.print(keyChar); // echo character received
  switch (keyChar) {
    case '.': doCmd(); return; // invokes command execution
    case '<': readTask = 2; return; // MQ0 data byte will be received next
    case '!': cmdReset(); return; // resets variables to their dfefaults
    case '#': cmdMode = ' '; cmdType = ' '; cmdVal = 0; cmdSgn = 1; return;
    case '~': RP_ON = false; return; // null tick received
    case '-': cmdSgn = -1; return; // declares number as negative
    case '0': extendCmdVal(0); return;
    case '1': extendCmdVal(1); return;
    case '2': extendCmdVal(2); return;
    case '3': extendCmdVal(3); return;
    case '4': extendCmdVal(4); return;
    case '5': extendCmdVal(5); return;
    case '6': extendCmdVal(6); return;
    case '7': extendCmdVal(7); return;
    case '8': extendCmdVal(8); return;
    case '9': extendCmdVal(9); return;
  }
  if (cmdMode == ' ') {
    // test for new Command Mode char?
    switch (keyChar) {
      case 'a': cmdMode = 'A'; break;
      case 'A': cmdMode = 'A'; break;
      case 'c': cmdMode = 'C'; break;
      case 'C': cmdMode = 'C'; break;
      case 'd': cmdMode = 'D'; break;
      case 'D': cmdMode = 'D'; break;
      case 'i': cmdMode = 'I'; break;
      case 'I': cmdMode = 'I'; break;
      case 'p': cmdMode = 'P'; break;
      case 'P': cmdMode = 'P'; break;
      case 'q': cmdMode = 'Q'; break;
      case 'Q': cmdMode = 'Q'; break;
      case 'r': cmdMode = 'R'; break;
      case 'R': cmdMode = 'R'; break;
      case 's': cmdMode = 'S'; break;
      case 'S': cmdMode = 'S'; break;
      case 'x': cmdMode = 'X'; break;
      case 'X': cmdMode = 'X'; break;
      case 'y': cmdMode = 'Y'; break;
      case 'Y': cmdMode = 'Y'; break;
    } cmdType = ' '; cmdVal = 0; cmdSgn = 1;
  } else {
    // test for Command Type char?
    switch (keyChar) {
      case 'd': cmdType = 'D'; break;
      case 'D': cmdType = 'D'; break;
      case 'g': cmdType = 'G'; break;
      case 'G': cmdType = 'G'; break;
      case 'm': cmdType = 'M'; break;
      case 'M': cmdType = 'M'; break;
      case 'p': cmdType = 'P'; break;
      case 'P': cmdType = 'P'; break;
      case 'u': cmdType = 'U'; break;
      case 'U': cmdType = 'U'; break;
      case 's': cmdType = 'S'; break;
      case 'S': cmdType = 'S'; break;
      case 'v': cmdType = 'V'; break;
      case 'V': cmdType = 'V'; break;
    }
  }
}

// --------------------------------------------------------------------------------
