///////////////////////////////////////////////////////////////////////
// Code for user modes
///////////////////////////////////////////////////////////////////////

void MainMode_0() {
  ///////////////////////////////////////////////////////////////////////
  // In waiting for user input mode (default)
  ///////////////////////////////////////////////////////////////////////
  // slow circular LED pattern, waiting for button press
}

// --------------------------------------------------------------------------------

void MainMode_1() {
  ///////////////////////////////////////////////////////////////////////
  // flash LEDs to simulate spirit level to determine upright position
  ///////////////////////////////////////////////////////////////////////
  // extinguish all LEDs
  ClrLEDFlags();
  // calculate X+Y acceleration vector and angle
  if (accelerometer_data_rawY_OA == 0) {accelerometer_data_rawY_OA = 1;} // avoid divide by zero
  AccAbsAng = abs((float)accelerometer_data_rawX_OA/(float)accelerometer_data_rawY_OA);
  AccVect = sqrt(sq((float)accelerometer_data_rawX_OA) + sq((float)accelerometer_data_rawY_OA));
  AccVectTrk += ((AccVect - AccVectTrk)/10.0); // apply noise filtering
  ///////////////////////////////////////////////////////////////////////
  // in safeMode == 0 green LEDs are ON, waiting for initial off-balance condition
  ///////////////////////////////////////////////////////////////////////
  // the user must move the robot to an off-vertical value of >= 5 degrees
  if (safeMode == 0) {
    LEDLftGrnOn = true; LEDRhtGrnOn = true; LEDBckGrnOn = true;
    if (AccVectTrk >= AccVectSafe) {
      if (OffBalance < 100) {OffBalance++;} // capture off-balance condition
      else {safeMode = 1;} // off-balance by more than 5 degrees so change safe modes
    } else {OffBalance = 0;}
  } else {
    ///////////////////////////////////////////////////////////////////////
    // safeMode > 0 so look for balance point and then go live
    ///////////////////////////////////////////////////////////////////////
    if (AccVectTrk <= AccVectTrgt) {
      // small vector size confirms 0.5 degree centre region
      LEDLftGrnOn = true; LEDLftRedOn = true;
      LEDRhtGrnOn = true; LEDRhtRedOn = true;
      LEDBckGrnOn = true; LEDBckRedOn = true;
      GoActive++; if (GoActive >= 2) {
        ///////////////////////////////////////////////////////////////////////
        // robot moved to vertical position, so go active
        ///////////////////////////////////////////////////////////////////////
        setMainMode(3);                                   // switch modes and set safety flag
        angle_gyroX = angle_accX; pid_setpointX = 0.0;    // Load the accelerometer angle in the angle_gyro variable
        angle_gyroFX = angle_gyroX;                       // correct rate limited gyro angle
        self_balance_pid_setpointX = 0.0;                 // reset any previous set points
        angle_gyroY = angle_accY; pid_setpointY = 0.0;    // Load the accelerometer angle in the angle_gyro variable
        angle_gyroFY = angle_gyroY;                       // correct rate limited gyro angle
        self_balance_pid_setpointY = 0.0;                 // reset any previous set points
        GyroOnce = false;                                 // match gyro angle with accelerometer
        pid_i_memX = 0.0;                                 // reset integrators
        pid_i_memY = 0.0;                                 // reset integrators
        pid_error_lastX = 0.0;                            // reset d error memories
        pid_error_lastY = 0.0;                            // reset d error memories
        PID_TuneX = 0; PID_TuneY = 0;
        pid_output_trendX = 0; pid_output_trendY= 0;
        turnLEDsON(); LED_Override = 100; LEDBrightness = 8;
        self_balance_pid_incX = 0.0005; // values used to inc/dec balance setpoint (0.0015)
        self_balance_pid_incY = 0.0005; // values used to inc/dec balance setpoint (0.0015)
        PID_Output_Power = 50.0;                          // soft start from 50%
        startEn = true;
      }
    } else {
      // not yet at upright balance point, so give LED indication
      GoActive = 0; // reset the Go Active counter
      angle_gyroX = 0.0; angle_gyroY = 0.0; // lock gyros prior to balance point
      LEDCnt--; if (LEDCnt <= 5) {
        // LEDs are OFF for 50ms pulse
        if (LEDCnt < 1) {
          // count reached zero so reset based on current vector size
          LEDCnt = 10000 /((int)AccVectTrk + 1);
          LEDCnt = max(LEDCnt,11); LEDCnt = min(LEDCnt,99);
        }
      } else {
        // LEDs will be ON
        // light the LED which corresponds to the highest edge to indicate the
        // degree of out of balance
        if ((accelerometer_data_rawX_OA < 0) && (accelerometer_data_rawY_OA >= 0)) {
          // front left quadrant
          if (AccAbsAng >= 1.0) {LEDLftRedOn = true;}
          else if (AccAbsAng >= 0.26795) {LEDLftGrnOn = true; LEDLftRedOn = true;}
          else {LEDLftGrnOn = true;}
        } else if ((accelerometer_data_rawX_OA < 0) && (accelerometer_data_rawY_OA < 0)) {
          // front right quadrant
          if (AccAbsAng >= 1.0) {LEDRhtGrnOn = true;}
          else if (AccAbsAng >= 0.26795) {LEDRhtGrnOn = true; LEDRhtRedOn = true;}
          else {LEDRhtRedOn = true;}
        } else if ((accelerometer_data_rawX_OA >= 0) && (accelerometer_data_rawY_OA < 0)) {
          // rear right quadrant
          if (AccAbsAng >= 1.0) {LEDBckGrnOn = true;}
          else if (AccAbsAng >= 0.26795) {LEDBckGrnOn = true; LEDRhtRedOn = true;}
          else {LEDRhtRedOn = true;}
        } else {
         // rear left quadrant
          if (AccAbsAng >= 1.0) {LEDBckRedOn = true;}
          else if (AccAbsAng >= 0.26795) {LEDLftGrnOn = true; LEDBckRedOn = true;}
          else {LEDLftGrnOn = true;}
        }
      }
    }
  }
}

// --------------------------------------------------------------------------------

void MainMode_2() {
  ///////////////////////////////////////////////////////////////////////
  // Phantom MainMode 1
  ///////////////////////////////////////////////////////////////////////
  // mode setup is completed with only the PID P-gain value set, all other
  // gains are set to zero.
  // now switch back to MainMode 1
  MainMode = 1;
}

// --------------------------------------------------------------------------------

void MainMode_3() {
  ///////////////////////////////////////////////////////////////////////
  // Main self-balancing code
  ///////////////////////////////////////////////////////////////////////
  // bring up output power slowly to full on
  // then track PWM outputs with LEDs
  if (PID_Output_Power < 100.0) {PID_Output_Power += 0.1;}
}

// --------------------------------------------------------------------------------

void MainMode_4() {
  ///////////////////////////////////////////////////////////////////////
  // Upside down motor drive demo
  ///////////////////////////////////////////////////////////////////////
  // after an initial pause to allow the ball to be placed within the wheels
  // we start with circular motion
  if (Z_orientation >= 0) {setMainMode(0); return;} // exit if turned over
  
  switch(ModeTask) {
    case 0:
      // apply a 5 second delay before starting motor movements
      ModeCnt++; if (ModeCnt > 1250) {ModeTask++;}
      break;
    case 1:
      ModeSteer = 0.0; ModePID = 0.0; ModeAngle = 0.0;
      ModeCycle = 0; ModeTask++;
      break;
    case 2:
      DriveEn = true;
      driveMotors(ModePID,ModeAngle,ModeSteer);
      ModeSteer += 0.5;
      if (ModeSteer > 255.0) {
        // stay at this speed for 2 second then slow down & change direction
        ModeSteer = 254.5; ModeTaskNext = 3; ModeTask = 99; ModeCnt = 500;
      } break;
    case 3:
      driveMotors(ModePID,ModeAngle,ModeSteer);
      if (ModeSteer == 0.0) {
        ModeCycle++;
        if (ModeCycle >= 2) {
          // pause for 2 seconds then switch task
          ModeTaskNext = 10; ModeTask =99; ModeCnt = 500;
        }
      }
      ModeSteer -= 0.5;
      if (ModeSteer < -255.0) {
        // stay at this speed for 2 second then slow down & change direction
        ModeSteer = -254.5; ModeTaskNext = 2; ModeTask = 99; ModeCnt = 500;
      } break;

    // now we perform rolling movements
    case 10:
      // initialise the sequence
      ModeAngle = 0.0;  // angle pointer, start at 0 degrees
      ModePID = 0.5;    // counter used as the vector
      ModeSteer = 0.0;  // no steering in this mode
      ModeCycle = 0; ModeTask++; break;
    case 11:
      // for each angle speed up to vector max = 200
      driveMotors(ModePID,ModeAngle,0.0);
      if (ModePID == 0.0) {
        ModeCycle++;
        if (ModeCycle == 1) {ModeAngle = 60.0;}
        if (ModeCycle == 2) {ModeAngle = -60.0;}
        // pause for 2 seconds then switch task
        if (ModeCycle == 3) {ModeTaskNext = 20; ModeTask = 99; ModeCnt = 500;}
      }
      ModePID += 0.5;
      if (ModePID > 200.0) {
        // run at full speed for 2 second
        ModePID = 199.5; ModeTaskNext = 12; ModeTask =99; ModeCnt = 500;
      } break;
    case 12:
      // now slow down to zero and increment the angle by 120 degrees
      driveMotors(ModePID,ModeAngle,0.0);
      ModePID -= 0.5;
      if (ModePID < -200.0) {
        // run at full speed for 2 second
        ModePID = -199.5; ModeTaskNext = 11; ModeTask = 99; ModeCnt = 500;
      } break;

    // now we perform a rotating rolling movement
    case 20:
      // initialise the sequence
      ModeAngle = 0.0;  // angle pointer, start at 0 degrees
      ModePID = 0.5;    // counter used as the vector
      ModeSteer = 0.0;  // no steering in this mode
      ModeCycle = 0; ModeTask++; break;
      break;
    case 21:
      // first get the ball up to speed vector max = 200
      driveMotors(ModePID,ModeAngle,0.0);
      if (ModePID >= 200.0) {ModeTask++;}
      ModePID += 0.5; break;
    case 22:
      // now rotate the vector angle through 360 degrees
      driveMotors(ModePID,ModeAngle,0.0);
      ModeAngle += 0.1;
      if (ModeAngle >= 0.0) {
        // angles should be between -180 to 0 to +180 degrees
        if (ModeAngle > 180.0) {ModeAngle = -180.0;}
      } else {
        // if angle approaching zero pause for 4 seconds then switch task
        if (ModeAngle >= -0.5) {ModeTask = 23;}
      } break;
    case 23:
      // now slow down before switching tasks
      driveMotors(ModePID,0.0,0.0);
      ModePID -= 0.5;
      if (ModePID < 0.5) {
        driveMotors(0.0,0.0,0.0);
        ModeTaskNext = 1; ModeTask = 99; ModeCnt = 1000;
      } break;
      
    case 99:
      // provides a delay of ModeCnt * 10ms before going to ModeTaskNext
      ModeCnt--; if (ModeCnt < 1) {ModeTask = ModeTaskNext;} break;
      break;
  }
}

// --------------------------------------------------------------------------------
