
// --------------------------------------------------------------------------------

void BatteryFailed() {
  // if battery voltage drops below trigger level for more than 1 second
  Serial.println(F("Battery Voltage LOW!"));
  // turn OFF motors
  PWM_OFF();
  // turn OFF LEDs
  LEDs_OFF();
  // flash Red LEDs for a short while
  for (int zL = 0; zL < 30; zL++) {
    digitalWrite(LEDLftRed,HIGH); digitalWrite(LEDRhtRed,HIGH); digitalWrite(LEDBckRed,HIGH);
    delay(20);
    digitalWrite(LEDLftRed,LOW); digitalWrite(LEDRhtRed,LOW); digitalWrite(LEDBckRed,LOW);
    delay(980);
  }
  Serial.println(F("Entering lockdown...."));
  while (true) {} // do nothing forever
}

// --------------------------------------------------------------------------------

void Calibrate_Accelerometers() {
  // called when TEST == true to determine offset values
  // note Z-axis does not apply, this would be average gravity reading
  long zAccRawX = 0; long zAccRawY = 0;
  Serial.println(F("TEST Acc offsets..."));
  nextMicros = micros() + 4000;             //set up a 4ms timer
  LED_Task = 0; anyCnt = 0;
  for(int zL = 0; zL < 2100; zL++){ //Create 2100 loops
    Wire.beginTransmission(gyro_address);
    Wire.write(0x3B);  // starting with register 0x3B (ACCEL_XOUT_H)
    Wire.endTransmission();                 //End the transmission
    Wire.requestFrom(gyro_address,4,true);  // request 1 register read
    if (zL >= 100) {
      zAccRawX += Wire.read()<<8|Wire.read();  // 0x3B (ACCEL_XOUT_H) & 0x3C (ACCEL_XOUT_L)
      zAccRawY += Wire.read()<<8|Wire.read();  // 0x3D (ACCEL_YOUT_H) & 0x3E (ACCEL_YOUT_L)
    } else {
      // discard first 100 values
      Wire.read(); Wire.read(); Wire.read(); Wire.read();
    }
    // rotate LEDs whilst doing this
    anyCnt++; if (anyCnt >= 10) {
      anyCnt = 0;
      LED_Task++; if (LED_Task > 7) {LED_Task = 0;}
      Do_LED_Task(true);
    }
    while(nextMicros > micros()) {} // pause here
    nextMicros += 4000;             // reset timer
  }
  // Use the negative of these values as offsets to correct any drift
  zAccRawX /= 2000; zAccRawY /= 2000;
  Serial.print(F("Acc X Cal.= ")); Serial.println(zAccRawX);
  Serial.print(F("Acc Y Cal.= ")); Serial.println(zAccRawY);
  Serial.println(F("STOPPED"));
}

// --------------------------------------------------------------------------------

void Calibrate_Gyros() {
  // called during post or on a long-press, this function assumes that the robot
  // is on level ground, upon which it will run a gyro offset calibration routine
  nextMicros = micros() + 4000;             //set up a 4ms timer
  LED_Task = 0; anyCnt = 0;
  for(int zL = 0; zL < 1100; zL++){ //Create 1020 loops
    if (Calibrate) {
      // flag is set to permanently list MPU-6050 sensor values
      // see calibration instructions on how to use these
      readAccelAll(); readPitchYaw(); zL = 0;
//      Serial.print(accelerometer_data_rawX_i); Serial.print(F(","));
//      Serial.print(accelerometer_data_rawY_i); Serial.print(F(","));
//      Serial.print(accelerometer_data_rawZ_i); Serial.print(F(","));
      Serial.print(gyro_yaw_data_raw); Serial.print(F(","));
      Serial.println(gyro_pitch_data_raw);
    } else {
      // normal use. Find gyro drift offset values
      // accumulate 1000 gyro readings in 4 seconds for calibration
      Wire.beginTransmission(gyro_address);   //Start communication with the gyro
      Wire.write(0x43);                       //Start reading the register GYRO_XOUT_H
      Wire.endTransmission();                 //End the transmission
      Wire.requestFrom(gyro_address, 4);      //Request 4 bytes from the gyro
      if (zL >= 100) {
        gyro_yaw_calibration_value += Wire.read()<<8|Wire.read();         //Combine the two bytes to make one integer
        gyro_pitch_calibration_value += Wire.read()<<8|Wire.read();       //Combine the two bytes to make one integer
      } else {
        // ignore the first 100 readings as they will contain significant gyro drift
        Wire.read(); Wire.read(); Wire.read(); Wire.read();
      }
    }
    // rotate LEDs whilst doing this
    anyCnt++; if (anyCnt >= 10) {
      anyCnt = 0;
      LED_Task++; if (LED_Task > 5) {LED_Task = 0;}
      Do_LED_Task(true);
    }
    while(nextMicros > micros()) {} // pause here
    nextMicros += 4000;             // reset timer
  }
  gyro_pitch_calibration_value /= 1000;      //Divide the total value by 1000 to get the avarage gyro offset
  gyro_yaw_calibration_value /= 1000;        //Divide the total value by 1000 to get the avarage gyro offset
  Serial.print(F("Pitch Cal.= ")); Serial.println(gyro_pitch_calibration_value);
  Serial.print(F("Yaw Cal.= ")); Serial.println(gyro_yaw_calibration_value);
}

// --------------------------------------------------------------------------------

void ClrLEDFlags() {
  // called to turn OFF LEDs that may have been turned on during a mode  
  LEDLftGrnOn = false; LEDLftRedOn = false;
  LEDRhtGrnOn = false; LEDRhtRedOn = false;
  LEDBckGrnOn = false; LEDBckRedOn = false;
}

// --------------------------------------------------------------------------------

void Do_LED_Task(bool zM) {
  // set LEDs or flags according to LED_Task value
  // zM = true turn LEDs ON/OFF
  // zM = false set LED flags
  if (zM) {
    // it modifies LED outputs based on LED_Task value
    // the LOW state is used as the LED OFF state
    switch (LED_Task) {
      case -1: LEDs_OFF(); break; // ensure all are in the OFF state (LOW)
      case 0: digitalWrite(LEDBckGrn, LOW); digitalWrite(LEDBckRed, HIGH); break;
      case 1: digitalWrite(LEDBckRed, LOW); digitalWrite(LEDLftGrn, HIGH); break;
      case 2: digitalWrite(LEDLftGrn, LOW); digitalWrite(LEDLftRed, HIGH); break;
      case 3: digitalWrite(LEDLftRed, LOW); digitalWrite(LEDRhtGrn, HIGH); break;
      case 4: digitalWrite(LEDRhtGrn, LOW); digitalWrite(LEDRhtRed, HIGH); break;
      case 5: digitalWrite(LEDRhtRed, LOW); digitalWrite(LEDBckGrn, HIGH); break;
    }
  } else {
    // this code is used in LEDMode = 2
    // it modifies flags based on LED_Task value
    ClrLEDFlags(); // set all flags to the OFF state (false)
    switch (LED_Task) {
      case 0: LEDBckRedOn = true; break;
      case 1: LEDLftGrnOn = true; break;
      case 2: LEDLftRedOn = true; break;
      case 3: LEDRhtGrnOn = true; break;
      case 4: LEDRhtRedOn = true; break;
      case 5: LEDBckGrnOn = true; break;
    }
  }
}

// --------------------------------------------------------------------------------

void driveMotors(float zPID,float zAng,float zSteer) {
  ///////////////////////////////////////////////////////////////////////////////////
  // Motor PWM calculations
  ///////////////////////////////////////////////////////////////////////////////////
  // uses pid_error_angle and pid_output to develop a motor demand for all 3 motors,
  // using a fully proportional sinusoidal relationship
  // Steer applies a rotating vector, +ve = right, -ve = left

  MotorDriveA = (int)(zPID * sin((60.0 + zAng)/57.2958));
  MotorDriveB = (int)(zPID * sin((-60.0 + zAng)/57.2958));
  MotorDriveC = (int)(zPID * sin((180.0 + zAng)/57.2958));
  
  // now add in steering force
  MotorDriveA += (int)zSteer; MotorDriveB += (int)zSteer; MotorDriveC += (int)zSteer;

  // as adding in steering can exceed the max PWM value we need to apply limits
  if (MotorDriveA > 255) {MotorDriveA = 255;}
  else if (MotorDriveA < -255) {MotorDriveA = -255;}
  if (MotorDriveB > 255) {MotorDriveB = 255;}
  else if (MotorDriveB < -255) {MotorDriveB = -255;}
  if (MotorDriveC > 255) {MotorDriveC = 255;}
  else if (MotorDriveC < -255) {MotorDriveC = -255;}
  
  // motor drive wires are connected in reverse so we need to reverse the polarity
  // of the drive signals at this point. This depends on how you have connected
  // the DC motors and may not be necessary.
  setMotorA_PWM(-MotorDriveA); setMotorB_PWM(-MotorDriveB); setMotorC_PWM(-MotorDriveC);
}

// --------------------------------------------------------------------------------

void FlushRxBuffer() {
  // Read and ignore all characters in the serial port buffer  
  while (Serial.available() > 0) {
      // read data to empty buffer
    keyVal = Serial.read();
  }
}

// --------------------------------------------------------------------------------

void I2C_Err() {
  // Unexpected I2C error
  TWCR = 0;     // reset TwoWire Control Register to default, inactive state
//  TWCR &= ~(_BV(TWEN));
  pinMode(A4,INPUT); pinMode(A4,INPUT_PULLUP);
  pinMode(A5,INPUT); pinMode(A5,INPUT_PULLUP);

//  pinMode(A4,OUTPUT); digitalWrite(A4,LOW);
//  pinMode(A5,OUTPUT); digitalWrite(A5,LOW);

  Serial.print(F("\n############ "));
  if (I2C_Error > 0) {
    Serial.print(F("I2C Error = ")); Serial.println(I2C_Error);
  } else {
    Serial.print(F("I2C Available Error = ")); Serial.println(Wire.available());
  }
  Wire.begin(); // restart I2C
  Initialise_MPU_6050();  // try to re-initiaise the MPU
}

// --------------------------------------------------------------------------------

void Initialise_MPU_6050() {
  // set up gyro hardware
  //By default the MPU-6050 sleeps. So we have to wake it up.
  Wire.beginTransmission(gyro_address);   //Start communication with the address found during search.
  Wire.write(0x6B);         //We want to write to the PWR_MGMT_1 register (6B hex)
  Wire.write(0x00);         //Set the register bits as 00000000 to activate the gyro
  Wire.endTransmission();   //End the transmission with the gyro.
  //Set the full scale of the gyro to +/- 250 degrees per second
  Wire.beginTransmission(gyro_address);   //Start communication with the address found during search.
  Wire.write(0x1B);         //We want to write to the GYRO_CONFIG register (1B hex)
  Wire.write(0x00);         //Set the register bits as 00000000 (250dps full scale)
  Wire.endTransmission();   //End the transmission with the gyro
  //Set the full scale of the accelerometer to +/- 4g.
  Wire.beginTransmission(gyro_address);   //Start communication with the address found during search.
  Wire.write(0x1C);         //We want to write to the ACCEL_CONFIG register (1A hex)
  Wire.write(0x08);         //Set the register bits as 00001000 (+/- 4g full scale range)
  Wire.endTransmission();   //End the transmission with the gyro
  //Set some filtering to improve the raw data.
  Wire.beginTransmission(gyro_address);   //Start communication with the address found during search
  Wire.write(0x1A);         //We want to write to the CONFIG register (1A hex)
  Wire.write(0x03);         //Set the register bits as 00000011 (Set Digital Low Pass Filter to ~43Hz)
  Wire.endTransmission();   //End the transmission with the gyro 
}

// --------------------------------------------------------------------------------

void LEDs_Grn() {
  // turn green LEDs ON
  digitalWrite(LEDBckGrn, HIGH); digitalWrite(LEDBckRed, LOW);
  digitalWrite(LEDLftGrn, HIGH); digitalWrite(LEDLftRed, LOW);
  digitalWrite(LEDRhtGrn, HIGH); digitalWrite(LEDRhtRed, LOW);
}

// --------------------------------------------------------------------------------

void LEDs_OFF() {
  // turn OFF all LEDs, but does not affect their flags
  // note LEDs are OFF if their respective outputs are set to the same state
  // so setting them all HIGH would be equally valid
  digitalWrite(LEDBckGrn, LOW); digitalWrite(LEDBckRed, LOW);
  digitalWrite(LEDLftGrn, LOW); digitalWrite(LEDLftRed, LOW);
  digitalWrite(LEDRhtGrn, LOW); digitalWrite(LEDRhtRed, LOW);
}

// --------------------------------------------------------------------------------

void LEDs_Red() {
  // turn red LEDs ON
  digitalWrite(LEDBckGrn, LOW); digitalWrite(LEDBckRed, HIGH);
  digitalWrite(LEDLftGrn, LOW); digitalWrite(LEDLftRed, HIGH);
  digitalWrite(LEDRhtGrn, LOW); digitalWrite(LEDRhtRed, HIGH);
}

// --------------------------------------------------------------------------------

void LEDswCntFlash(int zMM) {
  // flash LEDs to indicate mode change
  for (anyCnt = 0; anyCnt < zMM; anyCnt++) {
    LEDs_Grn(); delay(30);
    LEDs_OFF(); delay(300);
  }
}

// --------------------------------------------------------------------------------

int Limit255(int zI) {
  // return an integer value between 0 and 255
  if (zI > 255) {zI = 255;}
  if (zI < 0) {zI = 0;}
  return zI;
}

// --------------------------------------------------------------------------------

float mapFloat(float x,float in_min,float in_max,float out_min,float out_max) {
  // floating point version of the map() function
  return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
}

// --------------------------------------------------------------------------------

void motorCal() {
  // motor PWM mapping, to compensate for difference in H-bridge driver o/p
  // in clockwise (CW) rotation, braking is applied in the 'Space' phase
  // in anti-clockwise (AC) rotation the motor free wheels in the 'Space' phase
  // the declared constant ACM determines to what extent the AC speed curve is changed

  MotorMaxPWM = 255;    // maximum PWM in either rotation, normally = 255
  MotorMinPWMop = 0;      // minimum PWM to start in either rotation, 0 = not in calibration

  if (MotorCal) {
    MotorMinPWMop = 21;   // minimum PWM to start in either rotation, determined in Cal. process

    // the defined ACM constant determines the extent of speed profile modification
    // set ACM between 0 - 100 as % of speed curve modification
    MotorPWM50 = map(ACM,0,100,50,32);
    MotorPWM100 = map(ACM,0,100,100,40);
    MotorPWM150 = map(ACM,0,100,150,57);
    MotorPWM200 = map(ACM,0,100,200,93);
  }
}

// --------------------------------------------------------------------------------

int MotorRemapLin(int zPWM) {
  // function called to remap Linear PWM curve
  // the lower figure is to reduce the effects of stiction in the grearbox
  return map(zPWM,1,255,10,255);  
}

// --------------------------------------------------------------------------------

void PWM_OFF() {
  // turn OFF motor drives
  PWM_A = 0; analogWrite(PWMA,PWM_A); // stop Motor A left
  PWM_B = 0; analogWrite(PWMB,PWM_B); // stop Motor B right
  PWM_C = 0; analogWrite(PWMC,PWM_C); // stop Motor C rear
  DIR_A = LOW; digitalWrite(DIRA,DIR_A); // set direction for Motor A left
  DIR_B = LOW; digitalWrite(DIRB,DIR_B); // set direction for Motor B right
  DIR_C = LOW; digitalWrite(DIRC,DIR_C); // set direction for Motor C rear
}

// --------------------------------------------------------------------------------

void readAccelAll() {
  // read the X,Y,Z-axis acceleration values from the MPU
  Wire.beginTransmission(gyro_address);
  Wire.write(0x3B);  // starting with register 0x3B (ACCEL_XOUT_H)
  I2C_Error = Wire.endTransmission(false);
  if (I2C_Error > 0) {I2C_Err(); return;}
  delayMicroseconds(20);
  Wire.requestFrom(gyro_address,6,true);  // request 1 register read
  if (Wire.available() != 6) {I2C_Err(); return;}    // ensure that the correct number of bytes have been received
  accelerometer_data_rawX_i = Wire.read()<<8|Wire.read();  // 0x3B (ACCEL_XOUT_H) & 0x3C (ACCEL_XOUT_L)
  accelerometer_data_rawY_i = Wire.read()<<8|Wire.read();  // 0x3D (ACCEL_YOUT_H) & 0x3E (ACCEL_YOUT_L)
  accelerometer_data_rawZ_i = Wire.read()<<8|Wire.read();  // 0x3F (ACCEL_ZOUT_H) & 0x40 (ACCEL_ZOUT_L)
  // record values
  accelerometer_data_rawX_OALast = accelerometer_data_rawX_OA;
  accelerometer_data_rawY_OALast = accelerometer_data_rawY_OA;
  // correct with calibrated offset values
  accelerometer_data_rawX_OA = accelerometer_data_rawX_i + acc_cal_valueX; //Add the accelerometer calibration value
  accelerometer_data_rawY_OA = accelerometer_data_rawY_i + acc_cal_valueY; //Add the accelerometer calibration value
}

// --------------------------------------------------------------------------------

void readPitchYaw() {
  // read the raw pitch and yaw gyro values  
  Wire.beginTransmission(gyro_address);   //Start communication with the gyro
  Wire.write(0x43);                       //Start reading the register GYRO_XOUT_H
  I2C_Error = Wire.endTransmission(false);
  if (I2C_Error > 0) {I2C_Err(); return;}
  
  delayMicroseconds(20);
  Wire.requestFrom(gyro_address, 4);      //Request 4 bytes from the gyro
  if (Wire.available() != 4) {I2C_Err(); return;}    // ensure that the correct number of bytes have been received

  gyro_yaw_data_raw = Wire.read()<<8|Wire.read();   //Combine the two bytes to make one integer
  gyro_pitch_data_raw = Wire.read()<<8|Wire.read(); //Combine the two bytes to make one integer

  // determine intermeasurement time for increased precision
  if (GyT > 0) {
    GyTD = micros() - GyT;  // get the differential time between readings
    GyT = GyTD + GyT;       // set the timer for the next reading
  } else {
    // 1st reading after reset
    GyT = micros();
    GyTD = 4000;
  }
}

// --------------------------------------------------------------------------------

void readSwitch() {
  // read the button switch and respond accordingly, pressed == LOW
  // a button press will automatical drop the current task
  // this function is called every 4ms which is the swTimer increment period
  swState = HIGH;
  // check for low voltage on the switch pin for button press
  if (BattVol <= BattSw0) {swState = LOW;} 
  if ((swWaitHi) && (swState == LOW)) {return;} // waiting for HIGH release
  swWaitHi = false;

  if ((swLastState == HIGH) && (swState == LOW)) {
    // switch has just gone LOW, this is the falling edge
    PWM_OFF(); startEn = false; // ensure motor power is removed on button press
    swCnt++;      // count on the falling edge
    swTimer = 0;  // reset the timer
    LEDMode = -1; LEDs_Grn(); // turn green LEDs ON whilst down
  }
  if ((swLastState == LOW) && (swState == HIGH)) {
    // rising edge
    LEDs_OFF(); // turn OFF green LEDs
  }
  swLastState = swState;      // record current state
  if (swCnt > 0) {swTimer++;} // button was pressed so run timer
  if ((swTimer >= 125) && (swState == HIGH)) {
    // button released for 1 sec so assume valid button count
//    Serial.print(F("swCnt = ")); Serial.println(swCnt);
    if (swCnt > 2) {swCnt = 0;} // limit switch count to 2 presses
    if (MainMode > 0) {MainMode = 0;} // active so go back to waiting ManMode 0
    else if (MainMode == 0) {MainMode = swCnt;} // set MainMode directly
    if (Z_orientation < 0) {MainMode = 4;} // motor drive demonstration
    LEDswCntFlash(MainMode); delay(1000);  // flash LEDs to indicate MainMOde value
    setMainMode(MainMode);
    swCnt = 0; swTimer = 0; synchLoopTimers();
  } else if(swTimer >= 250) {
    if (swState == LOW) {
      // button held down for >= 2 seconds so re-calibrate
      Calibrate_Gyros();
      setMainMode(0);                   // return to waiting mode
      nextMicros = micros() + interval; // seed 250Hz loop timer
      swWaitHi = true;                  // wait for button release
    }
    swCnt = 0; swTimer = 0;
   }
}

// --------------------------------------------------------------------------------

void reset_PID() {
  // called when dropping out of active mode  
  startEn = false;                  // shut down motor drive
  pid_output = 0.0;                 // Set the PID controller vector output to 0 so the motors stop moving
  pid_i_memX = 0.0;                 // Reset the I-controller memory
  pid_i_memY = 0.0;                 // Reset the I-controller memory
  self_balance_pid_setpointX = 0.0; // Reset the self_balance_pid_setpoint variable
  self_balance_pid_setpointY = 0.0; // Reset the self_balance_pid_setpoint variable
}

// --------------------------------------------------------------------------------

void setMainMode(int zMM) {
  // set the appropriate conditions for a given mode
  PWM_OFF();        // stop motors when changing modes
  AccVectTrk = 0.0; // default state
  GoActive = 0;     // default state
  LEDMode = -1;     // LED mode pointer, default = 1, slow rotation
  LEDs_OFF();       // extinguish current pattern
  LED_Task = 0;     // default state
  ModeCnt = 0;      // counter used in MainMode tasks
  ModeCycle = 0;    // cycle counter used in MainMode tasks
  ModeTask = 0;     // task poiinter used in MainMode tasks
  OffBalance = 0;   // flag capturing initial off-balance condition
  safeMode = 0;     // default condition is safe
  ClrLEDFlags();    // start with all LEDs OFF
  switch(zMM) {
    case 0:
      setDefaults(); // reset all variables when entering MainMode 0
      reset_PID(); LEDMode = 1; LEDBrightness = 4; break;
    case 1: // user looking for balance start, with full PID settings
      reset_PID(); break;
    case 2: // user looking for balance start, with only PID P-gain active
      reset_PID();
      pid_p_gain = 88.0; pid_i_gain = 0.0; pid_d_gain = 0.0; pid_s_gain = 0.0;
      break;
    case 3: // gone LIVE balancing
       LEDMode = 2; LEDA_Cnt = 1; LEDB_Cnt = 1; LEDC_Cnt = 1;  // set LED mode
       safeMode = 1; break;
    case 4: // motor drive demo
       LEDMode = 2; LEDA_Cnt = 1; LEDB_Cnt = 1; LEDC_Cnt = 1;  // set LED mode
      break;
  } MainMode = zMM;
  Serial.flush(); Serial.print(F("MM = ")); Serial.println(MainMode);
}

// --------------------------------------------------------------------------------

void setMotorA_PWM(int zPWM) {
  // sets the motor drive based on the PWM value and sign
  // +ve = clockwise, -ve = anti-clockwise
//  Serial.println(); Serial.print(zPWM);
  if (zPWM < 0) {setMotorA(false, -zPWM);}
  else {setMotorA(true, zPWM);}

//  int zDir = true; // default direction is clockwise
//  if (zPWM < 0) {zDir = false; zPWM = -zPWM;}
//  setMotorA(zDir, zPWM);
}

// --------------------------------------------------------------------------------

void setMotorA(bool zDir,int zPWM) {
  // apply a drive condition to motor A
  // PWM mapping is performed to overcome motor/gearbox stiction at start
  // PWM/speed curves are different for CW and AC rotation. See Cal. curves.
  PWM_A = Limit255(zPWM); // ensure PWM is within 0 -255
  DIR_A = zDir; // assign state to global variable
  if (DIR_A) {
    PWM_A = MotorRemapLin(PWM_A);
  } else {
    PWM_A = MotorRemapLin(PWM_A);
  } 
//  Serial.println(); Serial.print(PWM_A);

//  if (PWM_A <= MotorMinPWMip) {
//    PWM_A = map(PWM_A,0,MotorMinPWMip,0,MotorMinPWMop);
//  } else {PWM_A = map(PWM_A,MotorMinPWMip,MotorMaxPWM,MotorMinPWMop,MotorMaxPWM);}
//  DIR_A = zDir; // assign state to global variable
//  digitalWrite(DIRA,DIR_A);
//  if (DIR_A) {
//    // clockwise so correct PWM
//    analogWrite(PWMA,255-PWM_A);
//  } else {
//    // anti-clockwise
//    analogWrite(PWMA,PWM_A);
//  } 
}

// --------------------------------------------------------------------------------

void setMotorB_PWM(int zPWM) {
  // sets the motor drive based on the PWM value and sign
  // +ve = clockwise, -ve = anti-clockwise
//  Serial.print(","); Serial.print(zPWM);
  if (zPWM < 0) {setMotorB(false, -zPWM);}
  else {setMotorB(true, zPWM);}

//  int zDir = true; // default direction is clockwise
//  if (zPWM < 0) {zDir = false; zPWM = -zPWM;}
//  setMotorB(zDir, zPWM);
}

// --------------------------------------------------------------------------------

void setMotorB(bool zDir,int zPWM) {
  // apply a drive condition to motor A
  // PWM mapping is performed to overcome motor/gearbox stiction at start
  // PWM/speed curves are different for CW and AC rotation. See Cal. curves.
  PWM_B = Limit255(zPWM); // ensure PWM is within 0 -255
  DIR_B = zDir; // assign state to global variable
  if (DIR_B) {
    PWM_B = MotorRemapLin(PWM_B);
  } else {
    PWM_B = MotorRemapLin(PWM_B);
  } 

//  if (PWM_B <= MotorMinPWMip) {
//    PWM_B = map(PWM_B,0,MotorMinPWMip,0,MotorMinPWMop);
//  } else {PWM_B = map(PWM_B,MotorMinPWMip,MotorMaxPWM,MotorMinPWMop,MotorMaxPWM);}
//  DIR_B = zDir; // assign state to global variable
//  digitalWrite(DIRB,DIR_B);
//  if (DIR_B) {
//    // clockwise so correct PWM
//    analogWrite(PWMB,255-PWM_B);
//  } else {
//    // anti-clockwise
//    analogWrite(PWMB,PWM_B);
//  } 
}

// --------------------------------------------------------------------------------

void setMotorC_PWM(int zPWM) {
  // sets the motor drive based on the PWM value and sign
  // +ve = clockwise, -ve = anti-clockwise
//  Serial.print(","); Serial.print(zPWM);
  if (zPWM < 0) {setMotorC(false, -zPWM);}
  else {setMotorC(true, zPWM);}

//  int zDir = true; // default direction is clockwise
//  if (zPWM < 0) {zDir = false; zPWM = -zPWM;}
//  setMotorC(zDir, zPWM);
}

// --------------------------------------------------------------------------------

void setMotorC(bool zDir,int zPWM) {
  // apply a drive condition to motor A
  // PWM mapping is performed to overcome motor/gearbox stiction at start
  // PWM/speed curves are different for CW and AC rotation. See Cal. curves.
  PWM_C = Limit255(zPWM); // ensure PWM is within 0 -255
  DIR_C = zDir; // assign state to global variable
  if (DIR_C) {
    PWM_C = MotorRemapLin(PWM_C);
  } else {
    PWM_C = MotorRemapLin(PWM_C);
  }

//  if (PWM_C <= MotorMinPWMip) {
//    PWM_C = map(PWM_C,0,MotorMinPWMip,0,MotorMinPWMop);
//  } else {PWM_C = map(PWM_C,MotorMinPWMip,MotorMaxPWM,MotorMinPWMop,MotorMaxPWM);}
//  DIR_C = zDir; // assign state to global variable
//  digitalWrite(DIRC,DIR_C);
//  if (DIR_C) {
//    // clockwise so correct PWM
//    analogWrite(PWMC,255-PWM_C);
//  } else {
//    // anti-clockwise
//    analogWrite(PWMC,PWM_C);
//  } 
}

// --------------------------------------------------------------------------------

void synchLoopTimers() {
  // reset main loop timers
  nextMicros = micros() + interval; // set loop timer
}

// --------------------------------------------------------------------------------

void turnLEDsON() {
  // called to set all of the LEDE flags active  
  LEDBckGrnOn = true; LEDBckRedOn = true;
  LEDLftGrnOn = true; LEDLftRedOn = true;
  LEDRhtGrnOn = true; LEDRhtRedOn = true;
}

// --------------------------------------------------------------------------------
