///////////////////////////////////////////////////////////////////////////////////
//
// Functions mainly used for development and debugging
//
///////////////////////////////////////////////////////////////////////////////////

void ScopeReport(int zGPnn ) {
  ///////////////////////////////////////////////////////////////////////
  // a choice of print statements to inspect variables dynamically
  ///////////////////////////////////////////////////////////////////////
  // Note at 4ms cycle and 115200 baud string length is limited to 46 chars
  // max in a 4ms period, otherwise blocking will occur. If used over WiFi then
  // link corruption may occur; so to prevent rogue values we send data twice and
  // checked on receive as a valid pair of duplicate values, otherwise disgard it.
  // Adjust the following three values to match the switch() list below, so that
  // title reports the extent of the GPnn list to the Monitor+ app, whenever a
  // new GPnn us called for.
  GPmin = 0; GPmax = 4; String zGM = "GM3\n";

  switch (zGPnn) {
    case 0:
      if (GP_Title) {PrintTx += "#PtchAC-P,PtchAC-I,PtchBD-P,PtchBD-I\n" + zGM; GP_Title = false;}
      PrintTx += String(PtchAC_p_Val) + ",";
      PrintTx += String(PtchAC_i_mem) + ",";
      PrintTx += String(PtchBD_p_Val) + ",";
      PrintTx += String(PtchBD_i_mem) + "\n";
      break;

    case 1:
      if (GP_Title) {PrintTx += "#PtchAC-P,PtchAC-I,PtchAC-D,PtchAC-Op\n" + zGM; GP_Title = false;}
      PrintTx += String(PtchAC_p_Val) + ",";
      PrintTx += String(PtchAC_i_mem) + ",";
      PrintTx += String(PtchAC_d_Val) + ",";
      PrintTx += String(PtchAC_pid_output) + "\n";
      break;

    case 2:
      if (GP_Title) {PrintTx += "#PtchBD-P,PtchBD-I,PtchBD-D,PtchBD-Op\n" + zGM; GP_Title = false;}
      PrintTx += String(PtchBD_p_Val) + ",";
      PrintTx += String(PtchBD_i_mem) + ",";
      PrintTx += String(PtchBD_d_Val) + ",";
      PrintTx += String(PtchBD_pid_output) + "\n";
      break;
      
    case 3:
      if (GP_Title) {PrintTx += "#AcX_OA,AngX,AcY_OA,AngY\n" + zGM; GP_Title = false;}
      PrintTx += String(AcX_OA) + ",";
      PrintTx += String(AngAcX) + ",";
      PrintTx += String(AcY_OA) + ",";
      PrintTx += String(AngAcY) + "\n";
      break;

    case 4:
      if (GP_Title) {PrintTx += "#PitchAC,PitchBD,Yaw,0v\n" + zGM; GP_Title = false;}
      PrintTx += String(PitchAC) + ",";
      PrintTx += String(PitchBD) + ",";
      PrintTx += String(Yaw) + ",";
      PrintTx += "0\n";
      break;

    default:
      // zRPnn was out of range so reset the reporting pointer and send commands
      // to set RP = 0 and RMax to the highest number in your case list. ie. 7
      GPnn = GPmin; PrintTx += "GP" + String(GPmin) + "\n";
      PrintTx += "GM" + String(GPmax) + "\n"; break;
  }
}

// --------------------------------------------------------------------------------
