
// --------------------------------------------------------------------------------

void JoyEyeMove(int16_t zX,int16_t zY) {
  // A left joystick demand has occured, so ensure eye is in cyclopse mode, and
  // enable the joystick to steer it
  if (JoyEye == 0) {
    // The eye is not in user cyclops mode, so set that up
    GFX_ModeLast = GFX_Mode;        // record current eye mode
    GFX_Mode = 0; GFX_RST = true;
  }
  JoyEye = 100;  // set 20ms timeout counter to 2 seconds
  if ((EyeJx != zX) || (EyeJy != zY)) {GFX_Wait = 0; GFX_ESC = true;}
  EyeJx = zX; EyeJy = zY;
}

// --------------------------------------------------------------------------------

void JoyMoveBwd() {
  // called from main loop to respond to joystick demands
  // this function drives and steers in a backwards direction
  // Serial.println("JoyMoveBwd");
  DriveTxt = "Backwards";           // indicates drive mode
  if (Drive <= 0) {
    // the start of a new movement
    Drive = JoyMode; SetLEDmode(22); PWM_Start = PWM_StartMax; DispDel = 3;
  }
  // ensure joystick values are in the required range
  if (JoyX < 128) {JoyXV = 127 - JoyX;} // convert -ve vector to +ve
  else {JoyXV = JoyX - 128;} // ensure JoyX = 0 - 128
  if (JoyY < 128) {JoyYV = 127 - JoyY;} // convert -ve vector to +ve
  else {JoyYV = JoyY - 128;} // ensure JoyY = 0 - 128
  JoySpd = JoyYV; if (JoyXV > JoyYV) {JoySpd = JoyXV;}
  if (Gear == 1) {JoySpd = PWM_Start + ((JoySpd *  4)/10);}  // 1st gear demand
  if (Gear == 2) {JoySpd = PWM_Start + ((JoySpd *  7)/10);}  // 2nd gear demand
  if (Gear == 3) {JoySpd = PWM_Start + ((JoySpd * 10)/10);}  // 3rd gear demand
  if (Gear == 4) {JoySpd = PWM_Start + ((JoySpd * 14)/10);}  // 4th gear demand
  if (Gear == 5) {JoySpd = PWM_Start + ((JoySpd * 18)/10);}  // 5th gear demand
  LedSpd = JoySpd;  // grab speed for LED animation

  Steer = 0;
  // now apply steering
  if (JoyX < DbLLX) {
    // driving backwards to the left
    Steer =  (JoySpd * (DbLLX - JoyX))/DbLLX;
    DriveAC = -JoySpd - (Steer/Steer_); DriveBD = -JoySpd + Steer;
    if (JoyY > 64) {JoyMode = 7; Drive = -1;} // switching to JoyMoveLft()
  } else if (JoyX > DbULX) {
    // driving backwards to the right
    Steer = (JoySpd * (JoyX - DbULX))/DbLLX;
    DriveAC = -JoySpd + Steer; DriveBD = -JoySpd - (Steer/Steer_);
    if (JoyY > 64) {JoyMode = 3; Drive = -1;} // switching to JoyMoveRht()
  } else if (JoyY < DbLLY) {
    // Driving backwards, no steering
    Steer = 0; DriveAC = -JoySpd; DriveBD = -JoySpd;}
  else {Steer = 0; DriveAC = 0; DriveBD = 0;}   // Stop!
  
  // now apply constraints and demand
  DriveAC = constrain(DriveAC,-255,255);
  DriveBD = constrain(DriveBD,-255,255);
  // Serial.println("MotorPWM (" + String(DriveLft) + "," + String(DriveRht) + "," + String(DriveLft) + "," + String(DriveRht) + ")");
  MotorPWM (DriveAC,DriveBD);
  if (PWM_Start > PWM_StartMin) {PWM_Start = PWM_StartMin + ((PWM_Start - PWM_StartMin)/2);}
}

// --------------------------------------------------------------------------------

void JoyMoveFwd() {
  // Called from main loop to respond to joystick demands
  // this function drives and steers in a forwards direction
  // Serial.println("JoyMoveFwd");
  DriveTxt = "Forwards";          // indicates drive mode
  if (Drive == 0) {
    // the start of a new movement
    Drive = JoyMode; SetLEDmode(21); PWM_Start = PWM_StartMax; DispDel = 3;
  }
  // ensure joystick values are in the required range
  if (JoyX < 128) {JoyXV = 127 - JoyX;} // convert -ve vector to +ve
  else {JoyXV = JoyX - 128;}            // ensure JoyX = 0 - 128
  if (JoyY < 128) {JoyYV = 127 - JoyY;} // convert -ve vector to +ve
  else {JoyYV = JoyY - 128;}            // ensure JoyY = 0 - 128
  JoySpd = JoyYV; if (JoyXV > JoyYV) {JoySpd = JoyXV;}
  if (Gear == 1) {JoySpd = PWM_Start + ((JoySpd *  4)/10);}  // 1st gear demand
  if (Gear == 2) {JoySpd = PWM_Start + ((JoySpd *  7)/10);}  // 2nd gear demand
  if (Gear == 3) {JoySpd = PWM_Start + ((JoySpd * 10)/10);}  // 3rd gear demand
  if (Gear == 4) {JoySpd = PWM_Start + ((JoySpd * 14)/10);}  // 4th gear demand
  if (Gear == 5) {JoySpd = PWM_Start + ((JoySpd * 18)/10);}  // 5th gear demand
  LedSpd = JoySpd;  // grab speed for LED animation

  Steer = 0;
  // now apply steering
  if (JoyX < DbLLX) {
    // driving forwards to the left
    Steer =  (JoySpd * (DbLLX - JoyX))/DbLLX;
    DriveAC = JoySpd - Steer; DriveBD = JoySpd + (Steer/Steer_);
    if (JoyY < 192) {JoyMode = 7; Drive = -1;} // switching to JoyMoveLft()
  } else if (JoyX > DbULX) {
    // driving forwards to the right
    Steer = (JoySpd * (JoyX - DbULX))/DbLLX;
    DriveAC = JoySpd + (Steer/Steer_); DriveBD = JoySpd - Steer;
    if (JoyY < 192) {JoyMode = 3; Drive = -1;} // switching to JoyMoveRht()
  } else if (JoyY > DbULY) {
    // Driving forwards, no steering
    DriveAC = JoySpd; DriveBD = JoySpd;}
  else {DriveAC = 0; DriveBD = 0;}   // Stop!
  
  // now apply constraints and demand
  DriveAC = constrain(DriveAC,-255,255);
  DriveBD = constrain(DriveBD,-255,255);
  // Serial.println("MotorPWM (" + String(DriveLft) + "," + String(DriveRht) + "," + String(DriveLft) + "," + String(DriveRht) + ")");
  MotorPWM (DriveAC,DriveBD);
  if (PWM_Start > PWM_StartMin) {PWM_Start = PWM_StartMin + ((PWM_Start - PWM_StartMin)/2);}
}

// --------------------------------------------------------------------------------

void JoyMoveLft() {
  // called from main loop to respond to joystick demands
  // Serial.println("JoyTurnLft");
  DriveTxt = "Drive Left";          // indicates drive mode
  if (Drive == 0) {
    // the start of a new movement
    Drive = JoyMode; SetLEDmode(24); PWM_Start = PWM_StartMax; DispDel = 3;
  }
  // ensure joystick values are in the required range
  if (JoyX < 128) {JoyXV = 127 - JoyX;} // convert -ve vector to +ve
  else {JoyXV = JoyX - 128;} // ensure JoyX = 0 - 128
  if (JoyY < 128) {JoyYV = 127 - JoyY;} // convert -ve vector to +ve
  else {JoyYV = JoyY - 128;}            // ensure JoyY = 0 - 128
  JoySpd = JoyXV; if (JoyYV > JoyXV) {JoySpd = JoyYV;}
  if (Gear == 1) {JoySpd = PWM_Start + ((JoySpd *  4)/10);}  // 1st gear demand
  if (Gear == 2) {JoySpd = PWM_Start + ((JoySpd *  7)/10);}  // 2nd gear demand
  if (Gear == 3) {JoySpd = PWM_Start + ((JoySpd * 10)/10);}  // 3rd gear demand
  if (Gear == 4) {JoySpd = PWM_Start + ((JoySpd * 14)/10);}  // 4th gear demand
  if (Gear == 5) {JoySpd = PWM_Start + ((JoySpd * 18)/10);}  // 5th gear demand
  LedSpd = JoySpd;  // grab speed for LED animation

  Steer = 0;
  // now apply steering
  if (JoyY < DbLLY) {
    // driving left, backwards
    Steer =  (JoySpd * (DbLLY - JoyY))/DbLLY;
    DriveAC = -JoySpd - (Steer/Steer_); DriveBD = JoySpd - Steer;
    if (JoyX < 64) {JoyMode = 5; Drive = -1;} // switching to JoyMoveBwd()
  } else if (JoyY > DbULY) {
    // driving left, forwards
    Steer = (JoySpd * (JoyY - DbULY))/DbLLY;
    DriveAC = -JoySpd + Steer; DriveBD = JoySpd + (Steer/Steer_);
    if (JoyY > 192) {JoyMode = 1; Drive = -1;} // switching to JoyMoveFwd()
  } else if (JoyX < DbLLX) {
    // Driving left, no steering
    DriveAC = -JoySpd; DriveBD = JoySpd;}
  else {DriveAC = 0; DriveBD = 0;}   // Stop!
  
  // now apply constraints and demand
  DriveAC = constrain(DriveAC,-255,255);
  DriveBD = constrain(DriveBD,-255,255);
  // Serial.println("MotorPWM (" + String(DriveLft) + "," + String(DriveRht) + "," + String(DriveLft) + "," + String(DriveRht) + ")");
  MotorPWM (DriveAC,DriveBD);
  if (PWM_Start > PWM_StartMin) {PWM_Start = PWM_StartMin + ((PWM_Start - PWM_StartMin)/2);}
}

// --------------------------------------------------------------------------------

void JoyMoveRht() {
  // called from main loop to respond to joystick demands
  // this function turns in a rightwards direction
  // Serial.println("JoyTurnRgt");
  DriveTxt = "Drive Right";          // indicates drive mode
  if (Drive == 0) {
    // the start of a new movement
    Drive = JoyMode; SetLEDmode(23); PWM_Start = PWM_StartMax; DispDel = 3;
  }
  // ensure joystick values are in the required range
  if (JoyX < 128) {JoyXV = 127 - JoyX;} // convert -ve vector to +ve
  else {JoyXV = JoyX - 128;} // ensure JoyX = 0 - 128
  if (JoyY < 128) {JoyYV = 127 - JoyY;} // convert -ve vector to +ve
  else {JoyYV = JoyY - 128;}            // ensure JoyY = 0 - 128
  JoySpd = JoyXV; if (JoyYV > JoyXV) {JoySpd = JoyYV;}
  if (Gear == 1) {JoySpd = PWM_Start + ((JoySpd *  4)/10);}  // 1st gear demand
  if (Gear == 2) {JoySpd = PWM_Start + ((JoySpd *  7)/10);}  // 2nd gear demand
  if (Gear == 3) {JoySpd = PWM_Start + ((JoySpd * 10)/10);}  // 3rd gear demand
  if (Gear == 4) {JoySpd = PWM_Start + ((JoySpd * 14)/10);}  // 4th gear demand
  if (Gear == 5) {JoySpd = PWM_Start + ((JoySpd * 18)/10);}  // 5th gear demand
  LedSpd = JoySpd;  // grab speed for LED animation

  Steer = 0;
  // now apply steering
  if (JoyY < DbLLY) {
    // driving right, backwards
    Steer =  (JoySpd * (DbLLY - JoyY))/DbLLY;
    DriveAC = JoySpd - Steer; DriveBD = -JoySpd - (Steer/Steer_);
    if (JoyX < 64) {JoyMode = 5; Drive = -1;} // switching to JoyMoveBwd()
  } else if (JoyY > DbULY) {
    // driving right, forwards
    Steer = (JoySpd * (JoyY - DbULY))/DbLLY;
    DriveAC = JoySpd + (Steer/Steer_); DriveBD = -JoySpd + Steer;
    if (JoyY > 192) {JoyMode = 1; Drive = -1;} // switching to JoyMoveFwd()
  } else if (JoyX > DbULX) {
    // Driving right, no steering
    DriveAC = JoySpd; DriveBD = -JoySpd;}
  else {DriveAC = 0; DriveBD = 0;}   // Stop!
  
  // now apply constraints and demand
  DriveAC = constrain(DriveAC,-255,255);
  DriveBD = constrain(DriveBD,-255,255);
  // Serial.println("MotorPWM (" + String(DriveLft) + "," + String(DriveRht) + "," + String(DriveLft) + "," + String(DriveRht) + ")");
  MotorPWM (DriveAC,DriveBD);
  if (PWM_Start > PWM_StartMin) {PWM_Start = PWM_StartMin + ((PWM_Start - PWM_StartMin)/2);}
}

// --------------------------------------------------------------------------------

void MotorDriveTask() {
  // Called at 62.5Hz from the main task loop(), to control motor PWMs and dither.
  // Control variables are set through the Motor(,,) function.
  if (AppCnt > 0) {return;}     // If connected to Windows app, then abort
  if (StartEn) {return;}        // If in self-balance mode, abort
  
  // Now create PWM counter signals for each motor.
  // Serial.println("MotorDriveTask(" + String(PWM_AC) + "," + String(PWM_BD) + ")");
  // Front right wheel motor 'A' and rear left wheel motor 'C'
  int16_t zPWM = PWM_AC;
  TachoAC += PWM_AC;  // add energy to the tacho counter
  if (zPWM >  0) {
    analogWrite(Pin_AC0, 255); analogWrite(Pin_AC1, 255 - zPWM); DIR_AC = 1;
  } else if (PWM_AC == 0) {analogWrite(Pin_AC0, 0); analogWrite(Pin_AC1, 0); DIR_AC = 0;
  } else {analogWrite(Pin_AC0, 255 + zPWM); analogWrite(Pin_AC1, 255); DIR_AC = -1;}
  
  // Front left wheel motor 'D' and rear right wheel motor 'B'
  zPWM = PWM_BD; 
  TachoBD += PWM_BD;  // add energy to the tacho counter
  if (zPWM >  0) {
    analogWrite(Pin_BD0, 255); analogWrite(Pin_BD1, 255 - zPWM); DIR_BD = 1;
  } else if (PWM_BD == 0) {analogWrite(Pin_BD0, 0); analogWrite(Pin_BD1, 0); DIR_BD = 0;
  } else {analogWrite(Pin_BD0, 255 + zPWM); analogWrite(Pin_BD1, 255); DIR_BD = -1;}
}

// --------------------------------------------------------------------------------

void MotorPWM (int16_t zAC,int16_t zBD) {
  // Sets the four H-bridge PWM values for drive control
  // zV > 0 - move wheel in direction for forward motion
  // zV = 0 - lock wheel in brake condition
  // zV < 0 - move wheel in direction for reverse motion
  if (!PwmEn) {zAC = 0; zBD = 0;}  // motor PWM is disabled

  // Store variables for display and counters
  // Sign of motor drive needs to be reversed, given the way in which they are wired
  PWM_AC = -getModPWM(zAC); PWM_BD = -getModPWM(zBD);
}

// --------------------------------------------------------------------------------

