///////////////////////////////////////////////////////////////////////
// Code for User Modes and GFX engines
///////////////////////////////////////////////////////////////////////


// --------------------------------------------------------------------------------

void MainMode_0() {
  ///////////////////////////////////////////////////////////////////////
  // In waiting for user input, static mode (default)
  ///////////////////////////////////////////////////////////////////////
  // Called every 8ms from loop() timer
  // Monitors movement, setting displays and LEDs
  if (MainSkip > 0) {MainSkip--; return;}

  switch (ModeTask) {
    case  0: // Initialise this mode
      ModeMem = 1;  // set remembered orientation to upright
      AtState = At_REST;
      if (!TEST) {DispMode = 0;}
      Txt_Mode = 0; // set eye text to battery monitoring
      if (GFX_Mode != GFX_Last) {GFX_Mode = GFX_Last; GFX_RST = true;}
      // Upright == 1   if upright
      // Upright == 0   if on its side
      // Upright == -1 if upside down
           if (Upright  >  0) {if (WiFiConnected) {SetLEDmode(2);} else {SetLEDmode(1);}}
      else if (Upright  == 0) {SetLEDmode(3);}
      else {if (WiFiConnected) {SetLEDmode(2);} else {SetLEDmode(1);}}
      ModeTask++; break;
    case 1:
      if (Upright != ModeMem) {
        // Orientation has changed, so change LED pattern to suite
        // Serial.println("Upright=" + String(Upright));
        switch (Upright) {
          case -1: // Upside down
            if (WiFiConnected) {SetLEDmode(2);} else {SetLEDmode(1);}
            GFX_RST = true; break;
          case  0: // On its side
            GFX_RST = true; SetLEDmode(3); break;
          case  1: // Upright
            if (WiFiConnected) {SetLEDmode(2);} else {SetLEDmode(1);}
            GFX_RST = true; break;
        }
      } ModeMem = Upright; MainSkip = 25;
      break;
  }
}

// --------------------------------------------------------------------------------

void MainMode_1() {
  ///////////////////////////////////////////////////////////////////////
  // Start of self-balance sequence
  ///////////////////////////////////////////////////////////////////////
  bool zPtchACStart = false; bool zPtchBDStart = false;
  switch (SafeMode) {
    case 0: // Are we within the +/-5 degree window
      // This assumes start angles of ~0.00 degrees
      // If start angles are > +/-2.0 degrees then modify these figures
      if ((PitchAC < (5.0 + PtchACSbSpSa)) && (PitchAC > (-5.0 + PtchACSbSpSa)) && (PitchBD < (5.0 + PtchBDSbSpSa)) && (PitchBD > (-5.0 + PtchBDSbSpSa))) {
        // In correct start position, within 5 degrees of the vertical
        //  so set LEDs yellow and move on
        SetLEDmode(10); SafeMode++; // switch to yellow pulses
        Txt_Mode = 3; // set eye text to Pitch & Roll
      } else {setMainMode(0); return;}  // cancel selection
      break;
    case 1: // Look for going outside of +/-6 degree window trigger
      // Again, this assumes start angles of ~0.00 degrees
      // If start angles are > +/-2.0 degrees then modify these figures
      if ((PitchAC > (6.0 + PtchACSbSpSa)) || (PitchAC < (-6.0 + PtchACSbSpSa)) || (PitchBD > (6.0 + PtchBDSbSpSa)) || (PitchBD < (-6.0 + PtchBDSbSpSa))) {
        SetLEDmode(12); SafeMode++; // switch to spirit level mode
      } break;
    case 2: // Spirit level, looking for setpoint triggers
      if ((PitchAC >= PtchACSaN) && (PitchAC <= PtchACSaP)) {zPtchACStart = true;}
      if ((PitchBD >= PtchBDSaN) && (PitchBD <= PtchBDSaP)) {zPtchBDStart = true;}
      if (zPtchACStart && zPtchBDStart) {
        // We are within the start limits
        // Turn all LEDs red for a short burst
        LedMode = 0; LED_Fill(64,0,0); LED_Del = 1; LEDshow = true;
        // Then set LEDs to balancing mode
        SetLEDmode(30);
        // Switch to SafeMode display
        DispMode = DM_SafeMode;
        ///////////////////////////////////////////////////////////////////////
        // robot moved to vertical position, so go active
        ///////////////////////////////////////////////////////////////////////
        PID_Output_Power = 50.0;                          // soft start from 50%
        PitchAC_En = true;                                // enable PID Pitch AC error calcs
        PtchACPidOpTrend = 0;                             // Reset trend tracker
        PtchACPidTune = 0;                                // Reset SbSp tuning flag
        PtchACSp = 0.00;                                  // reset Pitch setpoint
        PtchACSbSp = PtchACSbSpSa;                        // Set PtchSbSp to start angle
        PitchBD_En = true;                                // enable PID Pitch BD error calcs
        PtchBDPidOpTrend = 0;                             // Reset trend tracker
        PtchBDPidTune = 0;                                // Reset SbSp tuning flag
        PtchBDSp = 0.00;                                  // reset Roll setpoint
        PtchBDSbSp = PtchBDSbSpSa;                        // Set PtchBDSbSp to start angle
        StartEn = true;                                   // enable PID d & i gain calcs
        Steer = 0.0;                                      // remove any steering demand
        SafeMode++;
      }
      break;
    case 3: // Wait for power to reach 100% in PID controller
      // Switch directly to MainMode 2, otherwise flags will be reset using setMainMode()
      if (PID_Output_Power >= 100.0) {SafeMode = 4; MainMode = 2;}
      break;
  }
}

// --------------------------------------------------------------------------------

void MainMode_2() {
  ///////////////////////////////////////////////////////////////////////
  // Main self-balancing state reached - SafeMode 4
  ///////////////////////////////////////////////////////////////////////
  // Wait for toppling over
}

// --------------------------------------------------------------------------------

void MainMode_3() {
  ///////////////////////////////////////////////////////////////////////
  // Drive mode
  ///////////////////////////////////////////////////////////////////////
  // Called every 8ms from loop() timer
  // Monitors movement, setting displays and LEDs
  if (MainSkip > 0) {MainSkip--; return;}

  switch (ModeTask) {
    case  0: // Initialise this mode
      ModeMem = 1;  // set remembered orientation to upright
      AtState = At_DRIVE;
      if (!TEST) {DispMode = 0;}
      Txt_Mode = 0; // set eye text to battery monitoring
      SetLEDmode(20);
      ModeTask++; break;
    case 1: // Wait
      MainSkip = 25;
      break;
  }
}

// --------------------------------------------------------------------------------

void MainMode_4() {
  ///////////////////////////////////////////////////////////////////////
  // Upside down motor drive demo
  ///////////////////////////////////////////////////////////////////////
  // Called every 8ms from loop() timer
  // Start by setting Monitor+ and display for this option
  // Ensure that the robot is on the level
  // Then after an initial pause to allow the ball to be placed within the wheels
  // we start with drive motions
  if (Upright >= 0) {
    // exit if turned over
    DispMode = DispLast; setMainMode(0); return;
  }
  
  // slow this process down if needed, without affecting the '99' delay timer
  // set MainSkipCnt = 1 or less to run on every cycle
  // set MainSkipCnt = 2 to run every second cycle (1/2 speed), etc
  if (ModeTask < 99) {
    MainSkip--; if (MainSkip > 0) {return;}
    MainSkip = MainSkipCnt; // reset the skip counter
  }
  
  switch(ModeTask) {
    case 0: // Initialise
      DispLast = DispMode;  // remember current Monitor+ mode
      GFX_Last = GFX_Mode;  // remember eye display mode
      DispMode = DM_MtrDemo; ModeStr$ = ""; SetLEDmode(20);
      GFX_Mode = 2; Txt_Mode = 1; GFX_RST = true; // display count down
      ModeTask++; break;
    case 1:
      // Apply a 10 second delay before starting motor movements
      ModeCnt++; ModeStr$ = String((525 - ModeCnt)/50);
      if (ModeCnt >= 500) {ModeTask++;}
      break;
    case 2:
      // initialise the variables for starting the run
      ModePID = 0.0; ModeStr$ = "Driving";
      ModeCycle = 0; SetMainSkip(2);
      Txt_Mode = 2;   // display motor PWM values in 4 quadrants
      ModeTask++; break;
    case 3:
      //############################################
      // Drive both motors backwards with increasing speed only
      //############################################
      // from 0 to 255, this will rotate the ball at increasing speed
      DriveEn = true; ModeStr$ = "Backwards"; SetLEDmode(22);
      PWM_AC = getModPWM((int)ModePID); PWM_BD = getModPWM((int)ModePID);
      LedSpd = abs(PWM_AC); // set LED speed
      ModePID += 1.0;
      if (ModePID > 255.0) {
        // stay at this speed for 2 second then slow down & change direction
        ModePID = 254.0; ModeTaskNext = 4; ModeTask = 99; ModeCnt = 250;
      } break;
    case 4:
      //############################################
      // Drive the motors with decreasing/forward speed
      //############################################
      // from 254 to -255, this will rotate the ball at decreasing speed
      // then reverse its direction
      PWM_AC = getModPWM((int)ModePID); PWM_BD = getModPWM((int)ModePID);
      LedSpd = abs(PWM_AC); // set LED speed
      ModePID -= 1.0;
      if (ModePID < 0.0) {ModeStr$ = "Forwards"; SetLEDmode(21);}
      if (ModePID < -255.0) {
        // stay at this speed for 2 second then slow down & change direction
        ModePID = -254.0; ModeTaskNext = 5; ModeTask = 99; ModeCnt = 250;
      } break;
    case 5:
      //############################################
      // Drive the motors with decreasing forward speed
      //############################################
      // from -255 to 0
      PWM_AC = getModPWM((int)ModePID); PWM_BD = getModPWM((int)ModePID);
      LedSpd = abs(PWM_AC); // set LED speed
      ModePID += 1.0;
      if (ModePID >= 0.0) {
        // stay at this speed for 2 second then slow down & change direction
        ModePID = 0.0; PWM_AC= 0; PWM_BD = 0; ModeStr$ = "Pause";  SetLEDmode(20);
        ModeTaskNext = 10; ModeTask = 99; ModeCnt = 250;
      } break;

    case 10:
      //############################################
      // Drive both motors left with increasing speed only
      //############################################
      // from 0 to 255, this will rotate the ball at increasing left speed
      DriveEn = true; ModeStr$ = "Drive Left"; SetLEDmode(24);
      PWM_AC = getModPWM((int)ModePID); PWM_BD = getModPWM(-(int)ModePID);
      LedSpd = abs(PWM_AC); // set LED speed
      ModePID += 1.0;
      if (ModePID > 255.0) {
        // stay at this speed for 2 second then slow down & change direction
        ModePID = 254.0; ModeTaskNext = 11; ModeTask = 99; ModeCnt = 250;
      } break;
    case 11:
      //############################################
      // Drive the motors with decreasing/right speed
      //############################################
      // from 254 to -255, this will rotate the ball at decreasing left speed
      // then reverse its direction
      PWM_AC = getModPWM((int)ModePID); PWM_BD = getModPWM(-(int)ModePID);
      LedSpd = abs(PWM_AC); // set LED speed
      ModePID -= 1.0;
      if (ModePID < 0.0) {ModeStr$ = "Drive Right"; SetLEDmode(23);}
      if (ModePID < -255.0) {
        // stay at this speed for 2 second then slow down & change direction
        ModePID = -254.0;
        ModeTaskNext = 12; ModeTask = 99; ModeCnt = 250;
      } break;
    case 12:
      //############################################
      // Drive the motors with decreasing right speed
      //############################################
      // from -255 to 0
      PWM_AC = getModPWM((int)ModePID); PWM_BD = getModPWM(-(int)ModePID);
      LedSpd = abs(PWM_AC); // set LED speed
      ModePID += 1.0;
      if (ModePID >= 0.0) {
        // stay at this speed for 2 second then slow down & change direction
        ModePID = 0.0; PWM_AC= 0; PWM_BD = 0; ModeStr$ = "Pause"; SetLEDmode(20);
        ModeTaskNext = 20; ModeTask = 99; ModeCnt = 250;
      } break;

    case 20:
      //############################################
      // Drive AC motors with increasing speed only
      //############################################
      // from 0 to 255, this will rotate the ball at increasing left speed
      DriveEn = true; ModeStr$ = "Drive AC"; SetLEDmode(24);
      PWM_AC = getModPWM((int)ModePID); PWM_BD = 0;
      LedSpd = abs(PWM_AC); // set LED speed
      ModePID += 1.0;
      if (ModePID > 255.0) {
        // stay at this speed for 2 second then slow down & change direction
        ModePID = 254.0; ModeTaskNext = 21; ModeTask = 99; ModeCnt = 250;
      } break;
    case 21:
      //############################################
      // Drive the motors with decreasing/right speed
      //############################################
      // from 254 to -255, this will rotate the ball at decreasing left speed
      // then reverse its direction
      PWM_AC = getModPWM((int)ModePID); PWM_BD = 0;
      LedSpd = abs(PWM_AC); // set LED speed
      ModePID -= 1.0;
      if (ModePID < 0.0) {ModeStr$ = "Reverse AC"; SetLEDmode(23);}
      if (ModePID < -255.0) {
        // stay at this speed for 2 second then slow down & change direction
        ModePID = -254.0;
        ModeTaskNext = 22; ModeTask = 99; ModeCnt = 250;
      } break;
    case 22:
      //############################################
      // Drive the AC motors with decreasing speed
      //############################################
      // from -255 to 0
      PWM_AC = getModPWM((int)ModePID); PWM_BD = 0;
      LedSpd = abs(PWM_AC); // set LED speed
      ModePID += 1.0;
      ModeStr$ = "Reducing AC";
      if (ModePID >= 0.0) {
        // stay at this speed for 2 second then slow down & change direction
        ModePID = 0.0; PWM_AC= 0; PWM_BD = 0; ModeStr$ = "Pause"; SetLEDmode(20);
        ModeTaskNext = 30; ModeTask = 99; ModeCnt = 250;
      } break;

    case 30:
      //############################################
      // Drive BD motors with increasing speed only
      //############################################
      // from 0 to 255, this will rotate the ball at increasing left speed
      DriveEn = true; ModeStr$ = "Drive BD"; SetLEDmode(23);
      PWM_BD = getModPWM((int)ModePID); PWM_AC = 0;
      LedSpd = abs(PWM_BD); // set LED speed
      ModePID += 1.0;
      if (ModePID > 255.0) {
        // stay at this speed for 2 second then slow down & change direction
        ModePID = 254.0; ModeTaskNext = 31; ModeTask = 99; ModeCnt = 250;
      } break;
    case 31:
      //############################################
      // Drive the DB motors with decreasing/reversing speed
      //############################################
      // from 254 to -255, this will rotate the ball at decreasing left speed
      // then reverse its direction
      PWM_BD = getModPWM((int)ModePID); PWM_AC = 0;
      LedSpd = abs(PWM_BD); // set LED speed
      ModePID -= 1.0;
      if (ModePID < 0.0) {ModeStr$ = "Reverse BD"; SetLEDmode(24);}
      if (ModePID < -255.0) {
        // stay at this speed for 2 second then slow down & change direction
        ModePID = -254.0;
        ModeTaskNext = 32; ModeTask = 99; ModeCnt = 250;
      } break;
    case 32:
      //############################################
      // Drive the BD motors with decreasing speed
      //############################################
      // from -255 to 0
      PWM_BD = getModPWM((int)ModePID); PWM_AC = 0;
      ModeStr$ = "Reducing BD";
      LedSpd = abs(PWM_BD); // set LED speed
      ModePID += 1.0;
      if (ModePID >= 0.0) {
        // stay at this speed for 2 second then slow down & change direction
        ModePID = 0.0; PWM_AC= 0; PWM_BD = 0; ModeStr$ = "Pause"; SetLEDmode(20);
        ModeTaskNext = 2; ModeTask = 99; ModeCnt = 250;
      } break;

    case 99:
      // provides a delay of ModeCnt * 10ms before going to ModeTaskNext
      ModeCnt--; if (ModeCnt < 1) {ModeTask = ModeTaskNext;}
      break;
  }
}

// --------------------------------------------------------------------------------

void MainMode_5() {
  ///////////////////////////////////////////////////////////////////////
  // Upright wheel drive test
  ///////////////////////////////////////////////////////////////////////
  // Called every 8ms from loop() timer
  
  if (MainDel > 0) {MainDel--; return;}

  if (!sw0State || !sw1State) {ModeTask = 99;}
  switch(ModeTask) {
    case 0: // Initialise
      DispLast = DispMode;  // remember current Monitor+ mode
      GFX_Last = GFX_Mode;  // remember eye display mode
      DispMode = DM_WheelTest;
      ModeTitle$ = "Wheel Test"; ModeStr$ = "Count Down";
      GFX_Mode = 2; Txt_Mode = 1; GFX_RST = true; // display count down
      SetLEDmode(20); ModeTask++; break;
    case 1:
      // Apply a 10 second count down delay before starting motor movements
      ModeCnt++; ModeStr$ = String((525 - ModeCnt)/50);
      if (ModeCnt >= 500) {SetLEDmode(40); ModeTask++;}
      break;
    case 2:
      // Apply increasing drive to AC wheels
      ModeStr$ = "Drive AC"; Txt_Mode = 5;
      Mode_PWM = 0; ModeTask++; break;
    case 3:
      // Increase the PWM on moters AC
      PWM_AC = -getModPWM(Mode_PWM);
      Mode_PWM+= 2; if (Mode_PWM > 120) {MainDel = 125; ModeTask++;}
      break;
    case 4:
      // Decrease the PWM on moters AC and reverse them
      PWM_AC = -getModPWM(Mode_PWM);
      Mode_PWM-= 2; if (Mode_PWM < -120) {MainDel = 125; ModeTask++;}
      break;
    case 5:
      // Reverse the -ve PWM on moters AC until zero
      PWM_AC = -getModPWM(Mode_PWM);
      Mode_PWM+= 2; if (Mode_PWM >= 0) {PWM_AC = 0; ModeTask++;}
      break;
    case 6:
      ModeStr$ = "Pause"; MainDel = 125;
      ModeTask++; break;
    case 7:
      // Apply increasing drive to BD wheels
      ModeStr$ = "Drive BD";
      Mode_PWM = 0; ModeTask++; break;
    case 8:
      // Increase the PWM on moters AC
      PWM_BD = -getModPWM(Mode_PWM);
      Mode_PWM+= 2; if (Mode_PWM > 120) {MainDel = 125; ModeTask++;}
      break;
    case 9:
      // Decrease the PWM on moters AC
      PWM_BD = -getModPWM(Mode_PWM);
      Mode_PWM-= 2; if (Mode_PWM < -120) {MainDel = 125; ModeTask++;}
      break;
    case 10:
      // Increase the PWM on moters AC
      PWM_BD = -getModPWM(Mode_PWM);
      Mode_PWM+= 2; if (Mode_PWM >= 0) {PWM_BD = 0; ModeTask++;}
      break;
    case 11:
      ModeStr$ = "Pause"; MainDel = 125;
      ModeTask = 2; break;
    
    case 99:  // User aborts with SW0 or SW1 press
      sw0WaitHi = true; sw1WaitHi = true; // block further switch action
      setMainMode(0); break;
  }
}

// --------------------------------------------------------------------------------

void MainMode_Test() {
  ///////////////////////////////////////////////////////////////////////
  // A special test mode used for debugging
  ///////////////////////////////////////////////////////////////////////
  // after an initial pause to allow the ball to be placed within the wheels
  // we start with circular motion
  // Z_orientation = -1; // over-ride the oriantation flag, so always upside down
  // MainMode_4();       // run upside down mode continuously until reset
}

// --------------------------------------------------------------------------------
