/*
  Adafruit GFX LIbrary Quick Reference (2021)

  Extracted from: https://learn.adafruit.com/adafruit-gfx-graphics-library

  Display 240 x 240, top left X,Y is 0,0

  .cp437(true);
  .color565(uint8_t r,uint8_t g,uint8_t b);

  // Color definitions
  #define GC9A01A_BLACK   0x0000
  #define GC9A01A_BLUE    0x001F
  #define GC9A01A_RED     0xF800
  #define GC9A01A_GREEN   0x07E0
  #define GC9A01A_CYAN    0x07FF
  #define GC9A01A_MAGENTA 0xF81F
  #define GC9A01A_YELLOW  0xFFE0
  #define GC9A01A_WHITE   0xFFFF
  
  .drawBitmap(int16_t x, int16_t y, uint8_t *bitmap, int16_t w, int16_t h, uint16_t color);
  .drawChar(uint16_t x, uint16_t y, char c, uint16_t color, uint16_t bg, uint8_t size);
  .drawCircle(uint16_t x0, uint16_t y0, uint16_t r, uint16_t color);
  .drawFastVLine(uint16_t x0, uint16_t y0, uint16_t length, uint16_t color);
  .drawFastHLine(uint8_t x0, uint8_t y0, uint8_t length, uint16_t color);
  .drawLine(uint16_t x0, uint16_t y0, uint16_t x1, uint16_t y1, uint16_t color);
  .drawPixel(uint16_t x, uint16_t y, uint16_t color);
  .drawRect(uint16_t x0, uint16_t y0, uint16_t w, uint16_t h, uint16_t color);
  .drawRoundRect(uint16_t x0, uint16_t y0, uint16_t w, uint16_t h, uint16_t radius, uint16_t color);
  .drawTriangle(uint16_t x0, uint16_t y0, uint16_t x1, uint16_t y1, uint16_t x2, uint16_t y2, uint16_t color);
  
  .fillCircle(uint16_t x0, uint16_t y0, uint16_t r, uint16_t color);
  .fillRect(uint16_t x0, uint16_t y0, uint16_t w, uint16_t h, uint16_t color);
  .fillRoundRect(uint16_t x0, uint16_t y0, uint16_t w, uint16_t h, uint16_t radius, uint16_t color);
  .fillScreen(uint16_t color);
  .fillTriangle(uint16_t x0, uint16_t y0, uint16_t x1, uint16_t y1, uint16_t x2, uint16_t y2, uint16_t color);

  .getTextBounds(string, x, y, &x1, &y1, &w, &h);

  .height();

  .print();
  .println();

  .setCursor(int16_t x0, int16_t y0);
  .setFont(&FontName);
  .setRotation(uint8_t rotation);
  .setTextColor(uint16_t color);
  .setTextColor(uint16_t color, uint16_t backgroundcolor);
  .setTextSize(uint8_t size);
  .setTextWrap(boolean w);

  .width();
 
*/

// --------------------------------------------------------------------------------

void GFX_ClrRun() {
  // Called at the end of an eye GFX_Run sequence to reset values for the next run
  GFX_Run = 0; GFX_Task = 0; 
}

// --------------------------------------------------------------------------------

void GFX_EyeTasks() {
  // GFX task sequences are run when GFX_Run > 0
  // Each sequence needs to have parameters preset before running it
  // Once completed GFX_Run is set to zero, so that another can be defined and called
  if (GFX_Del > 0) {GFX_Del--; return;}           // GFX_Run task delay in milliseconds

  // Choose a task to run based on GFX_Run
  switch (GFX_Run) {
    case 0: break;                                // default null, end of tasks returns here
    case GFX_EyeMove: GFX_Task_EyeMove(); break;  // draw an eye at a new location
    case GFX_EyeXY: GFX_Task_EyeXY(); break;      // draw an eye at a preset location
    case GFX_Pupil: GFX_Task_Pupil(); break;      // draw an eye pupil
    default: // safety net
      GFX_ClrRun(); break;
  }
}

// --------------------------------------------------------------------------------

void GFX_Reset() {
  // Called during boot and whenever the screen mode changes or orientation changes
  // First set orientation
  switch (Upright) {
    case -1: // Upside down
      GFX_Rot = 0; break;
    case  0: // On its side
           if (Upside ==  1) {GFX_Rot = 1;}
      else if (Upside == -1) {GFX_Rot = 3;}
      break;
    case  1: // Upright
      GFX_Rot = 2; break;
  }
  tft.setRotation(GFX_Rot);   // set screen rotation
  // Now clear the screen
  if (GFX_Mode > 1) {// Black text display
    ICM_En = false; tft.fillScreen(GC9A01A_BLACK); ICM_En = true;
    BakCol = GC9A01A_BLACK; TxtCol = GC9A01A_WHITE;
    Eye_En = false; Txt_En = true; GFX_Run = 0;
  } else {// white eye/text display
    // The background will be filled as part of the GFX_EyeXY() function
    BakCol = GC9A01A_WHITE; TxtCol = GC9A01A_BLACK;
    if (GFX_Mode == 0) {
      // This is a full eye
      GFX_R0 = 70; GFX_R1 = GFX_R0/2; // eye and cornea radii
      GFX_X = 120; GFX_Y = 120;}
    else if (GFX_Mode == 1) {
      // This is a partial eye
      GFX_R0 = 60; GFX_R1 = GFX_R0/2; // eye and cornea radii
      GFX_X = 120; GFX_Y =  80;}
    Eye_En = true; if (GFX_Mode == 1) {Txt_En = true;} else {Txt_En = false;}
    GFX_Run = GFX_EyeXY;
  }
  // Now set eye variables
  GFX_Task = 0; GFX_Eng = 0; GFX_Wait = 0; GFX_Del = 10;
  // Now set text variables
  GFX_Txt = 0; Txt_Del = 10; for (int16_t zP = 0; zP < TxtDepth; zP++) {TxtFP[zP] = 0;}
  // Clear the reset flag
  GFX_RST = false;
}

// --------------------------------------------------------------------------------

void GFX_Task_EyeXY() {
  // A GFX_Run task which draws an eye centred at GFX_X,GFX_Y
  switch (GFX_Task) {
    case 0: // draw sclera background
      // If ICM comms has failed then this will be in red
      // t0 = micros();
      if (I2C_ICM) {BakCol = GC9A01A_WHITE;} else {BakCol = GC9A01A_RED;}
      TxtCol = GC9A01A_BLACK;
      ICM_En = false; tft.fillScreen(BakCol); ICM_En = true; 
      break;
    case 1: // draw blue iris
      // set colour                          rrrrrggggggbbbbb
      ICM_En = false; tft.fillCircle(GFX_X, GFX_Y, GFX_R0, 0b0010010010011111); ICM_En = true;
      break;
    case 2: // draw black pupil
      ICM_En = false; tft.fillCircle(GFX_X, GFX_Y, GFX_R1, GC9A01A_BLACK); ICM_En = true;
      GFX_XL = GFX_X; GFX_YL = GFX_Y; // record the new position
      GFX_ClrRun();
      // Serial.println(micros() - t0);
      return;           // terminate the run
    default: // end of drawing tasks, so reset system
      GFX_ClrRun();
      return;           // avoid incrementing the task
  } GFX_Task++;
}

// --------------------------------------------------------------------------------

void GFX_Task_EyeMove() {
  // A GFX_Run task which redraws an eye centred at GFX_X,GFX_Y
  // Called from Loop0 Core0 when GFX_Run > 0
  switch (GFX_Task) {
    case 0: // draw sclera background bar to obliterate previous iris
      // t0 = micros();
      ICM_En = false;
      tft.fillRect(GFX_XL-GFX_R0, GFX_YL-GFX_R0, 1 + (2 * GFX_R0), 1 + (2 * GFX_R0), BakCol);
      ICM_En = true;
      break;
    case 1:
      // draw new iris
      // set colour                          rrrrrggggggbbbbb
      ICM_En = false; tft.fillCircle(GFX_X, GFX_Y, GFX_R0, 0b0010010010011111); ICM_En = true;
      // Serial.print(micros() - t0); Serial.print("\t");
      break;
    case 2: // draw black pupil
      ICM_En = false; tft.fillCircle(GFX_X, GFX_Y, GFX_R1, GC9A01A_BLACK); ICM_En = true;
      GFX_XL = GFX_X; GFX_YL = GFX_Y; // record the new position
      GFX_ClrRun();
      // Serial.println(micros() - t0);
      return;           // terminate the run
    default: // end of drawing tasks, so reset system
      GFX_ClrRun(); return;           // avoid incrementing the task
  } GFX_Task++;
}

// --------------------------------------------------------------------------------

void GFX_Task_Pupil() {
  // A GFX_Run task which draws an eye pupil centred at GFX_XL,GFX_YL
  // Called from Loop0 Core0 when GFX_Run > 0
  if (GFX_R1 < GFX_R1Tgt) {GFX_R1++;}
  else if (GFX_R1 > GFX_R1Tgt) {GFX_R1--;}
  ICM_En = false; tft.fillCircle(GFX_X, GFX_Y, GFX_R1, GC9A01A_BLACK); ICM_En = true;
  GFX_ClrRun();
}

// --------------------------------------------------------------------------------

void TFT_Text_Ctr(int16_t zX,int16_t zY,uint8_t zS,String zT$) {
  // Display text zT$ centred on zX,zY, in size zS
  // Standard font in GFX is 6 pixels wide, 8 pixels high, allowing 1 pixel border
  // Display co-ordinate system 0,0 is screen top left
  // Text co-ordinate system 0,0 is character top left
  tft.setTextSize(zS);                    // set the font size first
  zX = zX - ((zT$.length() * 6 * zS)/2);  // centre text based on half width
  tft.setCursor(zX, zY);
  ICM_En = false; tft.print(zT$); ICM_En = true;
}

// --------------------------------------------------------------------------------

void TFT_Text_Lft(int16_t zX,int16_t zY,uint8_t zS,String zT$) {
  // Display text zT$ left justified zX,zY, in size zS
  // Standard font in GFX is 6 pixels wide, 8 pixels high, allowing 1 pixel border
  // Display co-ordinate system 0,0 is screen top left
  // Text co-ordinate system 0,0 is character top left
  tft.setTextSize(zS);                    // set the font size first
  tft.setCursor(zX, zY);                  // place text at zX,zY top left
  ICM_En = false; tft.print(zT$); ICM_En = true;
}

// --------------------------------------------------------------------------------

void TFT_Text_Rht(int16_t zX,int16_t zY,uint8_t zS,String zT$) {
  // Display text zT$ right justified at zX,zY, in size zS
  // Standard font in GFX is 6 pixels wide, 8 pixels high, allowing 1 pixel border
  // Display co-ordinate system 0,0 is screen top left
  // Text co-ordinate system 0,0 is character top left
  tft.setTextSize(zS);                    // set the font size first
  zX = zX - (zT$.length() * 6 * zS);      // right justify text from zX
  tft.setCursor(zX, zY);
  ICM_En = false; tft.print(zT$); ICM_En = true;
}

// --------------------------------------------------------------------------------

void GFX_TxtTasks() {
  // GFX text task sequences are run when GFX_Txt > 0
  // Each sequence needs to have parameters preset before running it
  // Once completed GFX_Txt is set to zero, so that another can be defined and called
  while (GFX_Txt > 0) {
    GFX_Txt--;
    if (TxtFP[GFX_Txt] > 0) {
      // Previous text had been drawn, so rewrite it in background colour
      tft.setTextColor(BakCol);
           if (TxtAP[GFX_Txt] == 0) {TFT_Text_Rht(TxtXP[GFX_Txt],TxtYP[GFX_Txt],TxtFP[GFX_Txt],TxtP$[GFX_Txt]);}
      else if (TxtAP[GFX_Txt] == 1) {TFT_Text_Ctr(TxtXP[GFX_Txt],TxtYP[GFX_Txt],TxtFP[GFX_Txt],TxtP$[GFX_Txt]);}
      else if (TxtAP[GFX_Txt] == 2) {TFT_Text_Lft(TxtXP[GFX_Txt],TxtYP[GFX_Txt],TxtFP[GFX_Txt],TxtP$[GFX_Txt]);}
      TxtFP[GFX_Txt] = 0;
    }
    // Now draw new text if font size > 0
    if (TxtFN[GFX_Txt] > 0) {
      // New text has been defined
      tft.setTextColor(TxtCol);
           if (TxtAN[GFX_Txt] == 0) {TFT_Text_Rht(TxtXN[GFX_Txt],TxtYN[GFX_Txt],TxtFN[GFX_Txt],TxtN$[GFX_Txt]);}
      else if (TxtAN[GFX_Txt] == 1) {TFT_Text_Ctr(TxtXN[GFX_Txt],TxtYN[GFX_Txt],TxtFN[GFX_Txt],TxtN$[GFX_Txt]);}
      else if (TxtAN[GFX_Txt] == 2) {TFT_Text_Lft(TxtXN[GFX_Txt],TxtYN[GFX_Txt],TxtFN[GFX_Txt],TxtN$[GFX_Txt]);}
      // Store references in previous for erasure process
      TxtAP[GFX_Txt] = TxtAN[GFX_Txt]; TxtFP[GFX_Txt] = TxtFN[GFX_Txt];
      TxtXP[GFX_Txt] = TxtXN[GFX_Txt]; TxtYP[GFX_Txt] = TxtYN[GFX_Txt];
      TxtP$[GFX_Txt] = TxtN$[GFX_Txt];
      break;  // exit after drawing new text string
    }
  }
}

// --------------------------------------------------------------------------------

