///////////////////////////////////////////////////////////////////////
// Code for User Modes and GFX engines
///////////////////////////////////////////////////////////////////////


// --------------------------------------------------------------------------------

void MainMode_0() {
  ///////////////////////////////////////////////////////////////////////
  // In waiting for user input mode (default)
  ///////////////////////////////////////////////////////////////////////
  // Called every 8ms from loop() timer
  // Monitors movement, setting displays and LEDs
  if (MainSkip > 0) {MainSkip--; return;}

  switch (ModeTask) {
    case  0: // Initialise this mode
      ModeMem = 1;  // set remembered orientation to upright
      if (!TEST) {DispMode = 0;}
      Txt_Mode = 0; // set eye text to battery monitoring
      if (GFX_Mode != GFX_Last) {GFX_Mode = GFX_Last; GFX_RST = true;}
           if (Upright  >  0) {SetLEDmode(1);}
      else if (Upright  == 0) {SetLEDmode(2);}
         else {SetLEDmode(3);}
      ModeTask++; break;
    case 1:
      if (Upright != ModeMem) {
        // Orientation has changed, so change LED pattern to suite
        // Serial.println("Upright=" + String(Upright));
        switch (Upright) {
          case -1: // Upside down
            GFX_RST = true; SetLEDmode(3); break;
          case  0: // On its side
            GFX_RST = true; SetLEDmode(2); break;
          case  1: // Upright
            GFX_RST = true; SetLEDmode(1); break;
        }
      } ModeMem = Upright; MainSkip = 25;
      break;
  }
}

// --------------------------------------------------------------------------------

void MainMode_1() {
  ///////////////////////////////////////////////////////////////////////
  // Start of self-balance sequence
  ///////////////////////////////////////////////////////////////////////
  float zPtchDrv = 0.0; float zRollDrv = 0.0;
  bool zPtchStart = false; bool zRollStart = false;
  switch (SafeMode) {
    case 0: // Are we within the +/-5 degree window
      // This assumes start angles of ~0.00 degrees
      // If start angles are > +/-2.0 degrees then modify these figures
      if ((Pitch < 5.0) && (Pitch > -5.0) && (Roll < 5.0) && (Roll > -5.0)) {
        // In correct start position so set LEDs yellow and move on
        SetLEDmode(10); SafeMode++;
        Txt_Mode = 3; // set eye text to Pitch & Roll
      } else {setMainMode(0); return;}  // cancel selection
      break;
    case 1: // Look for going outside of +/-6 degree window trigger
      // Again, this assumes start angles of ~0.00 degrees
      // If start angles are > +/-2.0 degrees then modify these figures
      if ((Pitch > 6.0) || (Pitch < -6.0) || (Roll > 6.0) || (Roll < -6.0)) {
        SetLEDmode(20); SafeMode++;
      } break;
    case 2: // Spirit level, looking for setpoint triggers
      if ((Pitch >= PtchSaN) && (Pitch <= PtchSaP)) {zPtchStart = true;}
      if ((Roll  >= RollSaN) && (Roll  <= RollSaP)) {zRollStart = true;}
      if (zPtchStart && zRollStart) {
        // We are within the start limits
        // Turn all LEDs red for a short burst
        LEDshow = false; LedMode = 0; LED_Fill(64,0,0); FastLED.show();
        // Switch to SafeMode display
        DispMode = DM_SafeMode;
        ///////////////////////////////////////////////////////////////////////
        // robot moved to vertical position, so go active
        ///////////////////////////////////////////////////////////////////////
        PID_Output_Power = 50.0;                          // soft start from 50%
        Pitch_En = true;                                  // enable PID Pitch error calcs
        PtchPidOpTrend = 0;                               // Reset trend tracker
        PtchPidTune = 0;                                  // Reset SbSp tuning flag
        PtchSp = 0.00;                                    // reset Pitch setpoint
        PtchSbSp = PtchSbSpSa;                            // Set PtchSbSp to start angle
        Roll_En = true;                                   // enable PID Roll error calcs
        RollPidOpTrend = 0;                               // Reset trend tracker
        RollPidTune = 0;                                  // Reset SbSp tuning flag
        RollSp = 0.00;                                    // reset Roll setpoint
        RollSbSp = RollSbSpSa;                            // Set RollSbSp to start angle
        StartEn = true;                                   // enable PID d & i gain calcs
        Steer = 0.0;                                      // remove any steering demand
        SafeMode++;
      }
      break;
    case 3: // Wait for power to reach 100% in PID controller
      // Switch directly to MainMode 2, otherwise flags will be reset using setMainMode()
      if (PID_Output_Power >= 100.0) {SafeMode = 4; MainMode = 2; SetLEDmode(30);}
      break;
  }
}

// --------------------------------------------------------------------------------

void MainMode_2() {
  ///////////////////////////////////////////////////////////////////////
  // Main self-balancing state reached - SafeMode 4
  ///////////////////////////////////////////////////////////////////////
  // Wait for toppling over
}

// --------------------------------------------------------------------------------

void MainMode_4() {
  ///////////////////////////////////////////////////////////////////////
  // Upside down motor drive demo
  ///////////////////////////////////////////////////////////////////////
  // Called every 8ms from loop() timer
  // Start by setting Monitor+ and display for this option
  // Ensure that the robot is on the level
  // Then after an initial pause to allow the ball to be placed within the wheels
  // we start with circular motion
  if (Upright >= 0) {
    // exit if turned over
    DispMode = DispLast; setMainMode(0); return;
  }
  
  // slow this process down if needed, without affecting the '99' delay timer
  // set MainSkipCnt = 1 or less to run on every cycle
  // set MainSkipCnt = 2 to run every second cycle (1/2 speed), etc
  if (ModeTask < 99) {
    MainSkip--; if (MainSkip > 0) {return;}
    MainSkip = MainSkipCnt; // reset the skip counter
  }
  
  
  switch(ModeTask) {
    case 0: // Initialise
      DispLast = DispMode;  // remember current Monitor+ mode
      GFX_Last = GFX_Mode;  // remember eye display mode
      DispMode = DM_MtrDemo; ModeStr$ = "";
      GFX_Mode = 2; Txt_Mode = 1; GFX_RST = true; // display count down
      ModeTask++; break;
    case 1:
      // Apply a 10 second delay before starting motor movements
      ModeCnt++; ModeStr$ = String((525 - ModeCnt)/50);
      if (ModeCnt >= 500) {ModeTask++;}
      break;
    case 2:
      // initialise the variables for starting the run
      ModeSteer = 0; ModePID = 0.0; ModeStr$ = "Rotating";
      ModeCycle = 0; SetMainSkip(2);
      Txt_Mode = 2;   // display motor PWM values
      ModeTask++; break;
    case 3:
      // drive the motors with increasing steering only
      // from 0 to 255, this will rotate the ball at increasing speed
      DriveEn = true;
      driveMotors(0.0,0.0,ModeSteer);
      ModeSteer += 1;
      if (ModeSteer > 255) {
        // stay at this speed for 2 second then slow down & change direction
        ModeSteer = 254; ModeTaskNext = 4; ModeTask = 99; ModeCnt = 250;
      } break;
    case 4:
      // drive the motors with decreasing/reversing steering
      // from 254 to -255, this will rotate the ball at decreasing speed
      // then reverse its direction
      driveMotors(0.0,0.0,ModeSteer);
      if (ModeSteer == 0) {
        ModeCycle++;
        if (ModeCycle >= 2) {
          // pause for 2 seconds then switch task
          ModeTaskNext = 10; ModeTask = 99; ModeCnt = 250;
        }
      }
      ModeSteer -= 1;
      if (ModeSteer < -255) {
        // stay at this speed for 2 second then slow down & change direction
        ModeSteer = -254; ModeTaskNext = 3; ModeTask = 99; ModeCnt = 250;
      } break;

    // now we perform rolling movements
    case 10:
      // initialise the sequence
      ModePID = 0.5;    // counter used as the vector
      ModeCycle = 0; ModeTask++; break;
    case 11:
      // for each direction speed up to max = 255.0
      if (ModeCycle == 0) {driveMotors(ModePID,0.0,0);}
      if (ModeCycle == 1) {driveMotors(0.0,ModePID,0);}
      if (ModePID == 0.0) {
        ModeCycle++;
        // pause for 2 seconds then switch task
        if (ModeCycle == 2) {
          ModeTaskNext = 20; ModeTask = 99; ModeCnt = 250;
        }
      }
      ModePID += 0.5;
      if (ModePID > 255.0) {
        // run at full speed for 2 second
        ModePID >= 254.5; ModeTaskNext = 12; ModeTask =99; ModeCnt = 250;
      } break;
    case 12:
      // now slow down to zero and increment the angle by 120 degrees
      if (ModeCycle == 0) {driveMotors(ModePID,0.0,0);}
      if (ModeCycle == 1) {driveMotors(0.0,ModePID,0);}
      ModePID -= 0.5;
      if (ModePID < -255.0) {
        // run at full speed for 2 second
        ModePID = -254.5; ModeTaskNext = 11; ModeTask = 99; ModeCnt = 250;
      } break;

    // now we perform a rotating rolling movement
    case 20:
      // initialise the sequence
      ModePID = 0.5;    // counter used as the vector
      SetMainSkip(0); ModeCycle = 0; ModeTask++; break;
      break;
    case 21:
      // for each direction speed up to max = 255.0
      if (ModeCycle == 0) {driveMotors(ModePID,ModePID,0);}
      if (ModeCycle == 1) {driveMotors(ModePID,-ModePID,0);}
      if (ModePID == 0.0) {
        ModeCycle++;
        // pause for 2 seconds then switch task
        if (ModeCycle >= 2) {
          ModeTask = 1; ModeCnt = 250; SetMainSkip(0); // restart the sequence after 2 seconds
          return;
        }
      }
      ModePID += 0.5;
      if (ModePID > 255.0) {
        // run at full speed for 2 second
        ModePID >= 254.5; ModeTaskNext = 22; ModeTask =99; ModeCnt = 250;
      } break;
    case 22:
      // now slow down to zero and increment the angle by 120 degrees
      if (ModeCycle == 0) {driveMotors(ModePID,ModePID,0);}
      if (ModeCycle == 1) {driveMotors(ModePID,-ModePID,0);}
      ModePID -= 0.5;
      if (ModePID < -255.0) {
        // run at full speed for 2 second
        ModePID = -254.5; ModeTaskNext = 21; ModeTask = 99; ModeCnt = 250;
      } break;
      
    case 99:
      // provides a delay of ModeCnt * 10ms before going to ModeTaskNext
      ModeCnt--; if (ModeCnt < 1) {ModeTask = ModeTaskNext;}
      break;
  }
}

// --------------------------------------------------------------------------------

void MainMode_Test() {
  ///////////////////////////////////////////////////////////////////////
  // A special test mode used for debugging
  ///////////////////////////////////////////////////////////////////////
  // after an initial pause to allow the ball to be placed within the wheels
  // we start with circular motion
  // Z_orientation = -1; // over-ride the oriantation flag, so always upside down
  // MainMode_4();       // run upside down mode continuously until reset
}

// --------------------------------------------------------------------------------
