
// --------------------------------------------------------------------------------

void CalcLimits() {
  // Called to set soft limits, at start or during TEST mode changes
  // Battery multiplier used in PWM limiting
  BatMult = 255.0 * V_max;

  // Start limits based on PtchSbSpSa and RollSbSpSa
  PtchSaN = PtchSbSpSa - 0.5;
  PtchSaP = PtchSbSpSa + 0.5;
  RollSaN = RollSbSpSa - 0.5;
  RollSaP = RollSbSpSa + 0.5;
}

// ---------------------------------------------------------------------------------

void decodeKey(int zkeyVal) {
  // Decodes zkeyVal and excutes commands on '.'
  // Slow down the sending function when receiving
  // if ((millis() - print40ms) > 6) {print40ms -= 6;}

  if (zkeyVal == 10) {return;}
  if (zkeyVal == 13) {return;}
  keyChar = char(zkeyVal);
  switch (keyChar) {
    case '.': doCmd(); return;                        // command terminator
    case '~': // connected to OLED Mirror app via USB or WiFi
      if (!DispMon) {DispMon = true; Display_Intro();} // display mirrored message
      DispTx = 50; return;
    case '-': cmdSgn = -1; return;                    // numeric sign
    case '*': cmdMode = ' '; cmdType = ' '; cmdVal = 0; cmdSgn = 1; return; // ESC abort command
    case '0': extendCmdVal(0); return;
    case '1': extendCmdVal(1); return;
    case '2': extendCmdVal(2); return;
    case '3': extendCmdVal(3); return;
    case '4': extendCmdVal(4); return;
    case '5': extendCmdVal(5); return;
    case '6': extendCmdVal(6); return;
    case '7': extendCmdVal(7); return;
    case '8': extendCmdVal(8); return;
    case '9': extendCmdVal(9); return;
  }
  if (cmdMode == ' ') {
    // test for new Command Mode char?
    // only accept certain characters as valid commands, or ignore them
    // delay battery update by 10 seconds whilst receiving commands
    cmdMode = keyChar;
    switch (keyChar) {
      // check for valid mode and convert upper-case
      case 'd': cmdMode = 'D'; break;
      case 'g': cmdMode = 'G'; break;
      // case 'j': cmdMode = 'J'; break;
      // case 'm': cmdMode = 'M'; break;
      // case 'p': cmdMode = 'P'; break;
      // case 's': cmdMode = 'S'; break;
      // case 'v': cmdMode = 'V'; break;
      // case 'W': cmdMode = 'W'; break;
    } cmdType = ' '; cmdVal = 0;
  } else {
    // test for Command Type char?
    cmdType = keyChar;
    switch (keyChar) {
      // check for lower-case and convert to upper-case
      // case 'a': cmdType = 'A'; break;
      // case 'c': cmdType = 'C'; break;
      case 'd': cmdType = 'D'; break;
      case 'e': cmdType = 'E'; break;
      // case 'h': cmdType = 'H'; break;
      case 'l': cmdType = 'L'; break;
      case 'm': cmdType = 'M'; break;
      // case 'o': cmdType = 'O'; break;
      case 'p': cmdType = 'P'; break;
      // case 'r': cmdType = 'R'; break;
      case 's': cmdType = 'S'; break;
      // case 't': cmdType = 'T'; break;
      // case 'u': cmdType = 'U'; break;
      // case 'v': cmdType = 'V'; break;
      // case 'x': cmdType = 'X'; break;
      // case 'y': cmdType = 'Y'; break;
    }
  }
}

// --------------------------------------------------------------------------------

void displayLft() {
  // change the DispMode pointer to the previous display
  if (DispLock) {return;} // ignore mouse click when display is locked
  if (DmDwn) {return;}    // Only respond to one mouse down event

  DispMode--; if (DispMode < DM_Min) {DispMode = DM_Max;}
  DispDel = 1; DispCnt = 0; DmDwn = true;
}

// --------------------------------------------------------------------------------

void displayRht() {
  // Change the DispMode pointer to the next display
  if (DispLock) {return;} // ignore mouse click when display is locked
  if (DmDwn) {return;}    // Only respond to one mouse down event

  DispMode++; if (DispMode > DM_Max) {DispMode = DM_Min;}
  DispDel = 1; DispCnt = 0; DmDwn = true;
}

// --------------------------------------------------------------------------------

void DM_BrkPntInc() {
  // Adjust BrkPnt value
  float zI = 0.1;
       if (DmX <= 34) {zI = 10.0;}
  else if (DmX <= 40) {zI =  1.0;}
  if (DmB) {BrkPnt-= zI;} else {BrkPnt+= zI;}
  if (BrkPnt > 99.9) {BrkPnt = 99.9;} else if (BrkPnt < 0.0) {BrkPnt = 0.00;}
}

// --------------------------------------------------------------------------------

void DM_BrkValInc() {
  // Adjust BrkVal value
  float zI = 0.001;
       if (DmX <= 79) {zI =  1.0;}
  else if (DmX <= 84) {zI =  0.1;}
  else if (DmX <= 88) {zI =  0.01;}
  if (DmB) {BrkVal-= zI;} else {BrkVal+= zI;}
  if (BrkVal > 99.9) {BrkVal = 99.9;} else if (BrkVal < 0.0) {BrkVal = 0.00;}
}

// --------------------------------------------------------------------------------

void DM_Control_() {
  //##################################
  // Control display
  //##################################
  // user has clicked on a blue field in Monitor+ display
  if (DmX < 50) {displayLft();}
  else {
    // Has user clicked on a blue field?
         if ((DmX >= 50) && (DmX <= 64) && (DmY >= 25) && (DmY <= 36)) {ToggleTestMode(); DmDwn = true;}
    else if ((DmX >= 50) && (DmX <= 64) && (DmY >= 43) && (DmY <= 54)) {BatAvg = 0; BatSum = 0; DmDwn = true;}
    else if ((DmX >= 66) && (DmX <= 78) && (DmY >= 62) && (DmY <= 73)) {setMainMode(MainTest); DmDwn = true;}
    else if ((DmX >= 84) && (DmX <= 88) && (DmY >= 62) && (DmY <= 73)) {DM_IncMainTest(); DmDwn = true;}
    else if ((DmX >= 50) && (DmX <= 66) && (DmY >= 80) && (DmY <= 91)) {WiFiKill(); DmDwn = true;}
    else {displayRht();}
  }
  DispDel = 1;  // Update after 40ms
}

// ---------------------------------------------------------------------------------

void DM_DriveCtrl_() {
  //##################################
  // Drive Control display
  //##################################
  // user has clicked on a blue field in Monitor+ display
  if (DmX < 50) {displayLft();}
  else {
    // Has user clicked on a blue field?
         if ((DmX <= 64) && (DmY >= 25) && (DmY <= 36)) {DM_TurnMaxInc(); DmDwn = true;}
    else if ((DmX <= 64) && (DmY >= 43) && (DmY <= 54)) {DM_TurnMinInc(); DmDwn = true;}
    else if ((DmX <= 64) && (DmY >= 62) && (DmY <= 73)) {DriveMinInc(); DmDwn = true;}
    else if ((DmX <= 64) && (DmY >= 80) && (DmY <= 91)) {DriveMaxInc(); DmDwn = true;}
    else {displayRht();}
  }
  DispDel = 1;  // Update after 40ms
}

// ---------------------------------------------------------------------------------

void DM_D_gainInc() {
  // Adjust pid_d_gain value
  float zI = 0.01;
       if (DmX <= 53) {zI = 10.0;}
  else if (DmX <= 59) {zI =  1.0;}
  else if (DmX <= 64) {zI =  0.1;}
  if (DmB) {pid_d_gain-= zI;} else {pid_d_gain+= zI;}
  if (pid_d_gain > 99.99) {pid_d_gain = 99.99;} else if (pid_d_gain < 0.00) {pid_d_gain = 0.00;}
}

// --------------------------------------------------------------------------------

void DM_EyeEng_() {
  //##################################
  // Eye Engine display
  //##################################
  // user has clicked on a blue field in Monitor+ display
  if (DmX < 50) {displayLft();}
  else {
    // Has user clicked on a blue field?
         if ((DmX >= 50) && (DmX <= 65) && (DmY >= 25) && (DmY <= 36)) {Eye_En = !Eye_En; DmDwn = true;}
    else {displayRht();}
  }
  DispDel = 1;  // Update after 40ms
}

// ---------------------------------------------------------------------------------

void DM_GyAcModInc() {
  // Adjust GyAcMod value
  float zI = 0.001;
       if (DmX <= 52) {zI = 1.000;}
  else if (DmX <= 57) {zI = 0.100;}
  else if (DmX <= 62) {zI = 0.010;}
  if (DmB) {GyAcMod-= zI;} else {GyAcMod+= zI;}
  if (GyAcMod > 1.000) {GyAcMod = 1.000;} else if (GyAcMod < 0.000) {GyAcMod = 0.000;}
}

// ---------------------------------------------------------------------------------

void DM_I_gainInc() {
  // Adjust pid_i_gain value
  float zI = 0.01;
       if (DmX <= 53) {zI = 10.0;}
  else if (DmX <= 59) {zI =  1.0;}
  else if (DmX <= 64) {zI =  0.1;}
  if (DmB) {pid_i_gain-= zI;} else {pid_i_gain+= zI;}
  if (pid_i_gain > 99.99) {pid_i_gain = 99.99;} else if (pid_i_gain < 0.00) {pid_i_gain = 0.00;}
}

// --------------------------------------------------------------------------------

void DM_ICM_Acc_() {
  //##################################
  // ICM Acc display
  //##################################
  // user has clicked on a blue field in Monitor+ display
  if (DmX < 50) {displayLft();}
  else {
    // has user clicked on a blue field
    if ((DmX >= 67) && (DmX <= 72) && (DmY >= 9) && (DmY <= 19)) {AcOffEn = !AcOffEn; DmDwn = true;}
    else {displayRht();}
  }
  DispDel = 1;  // Update after 40ms
}

// --------------------------------------------------------------------------------

void DM_ICM_Gyr_() {
  //##################################
  // ICM Gyros display
  //##################################
  // user has clicked on a blue field in Monitor+ display
  if (DmX < 50) {displayLft();}
  else {
    // has user clicked on a blue field
    if ((DmX >= 70) && (DmX <= 74) && (DmY >= 9) && (DmY <= 19)) {GyOffEn = !GyOffEn; DmDwn = true;}
    else {displayRht();}
  }
  DispDel = 1;  // Update after 40ms
}

// ---------------------------------------------------------------------------------

void DM_IncMainTest() {
  // Increment/decrement MainTest value
  if (DmB == 0) {MainTest++;} else {MainTest--;}
  if (MainTest > 4) {MainTest = 0;}
  else if (MainTest < 0) {MainTest = 4;}
}

// ---------------------------------------------------------------------------------

void DM_Imax_gainInc() {
  // Adjust pid_i_max value
  float zI = 0.1;
       if (DmX <= 81) {zI = 100.0;}
  else if (DmX <= 85) {zI =  10.0;}
  else if (DmX <= 91) {zI =   1.0;}
  if (DmB) {pid_i_max-= zI;} else {pid_i_max+= zI;}
  if (pid_i_max > 255.00) {pid_i_max = 255.00;} else if (pid_i_max < 0.00) {pid_i_max = 0.00;}
}

// ---------------------------------------------------------------------------------

void DM_Limits_() {
  //##################################
  // Limits display
  //##################################
  // User has clicked on a blue field in Monitor+ display
  if (TEST) {
        if (DmY < 26) {if (DmX < 50) {displayLft();} else {displayRht();}}
    else if (DmY < 81) {
      if (DmX < 47) {displayLft();}
      else {
        // has user clicked on a blue field
            if ((DmX >= 48) && (DmX <= 62) && (DmY >= 26) && (DmY <= 36)) {DM_V_MaxInc();}
        else if ((DmX >= 48) && (DmX <= 58) && (DmY >= 44) && (DmY <= 54)) {DM_MtrMinInc();}
        else if ((DmX >= 48) && (DmX <= 66) && (DmY >= 62) && (DmY <= 73)) {DM_GyAcModInc();}
        else {displayRht();}
      }
    }
    else if (DmX < 30) {displayLft();}
    else if (DmX <= 45) {DM_BrkPntInc();}
    else if (DmX <= 72) {displayRht();}
    else {DM_BrkValInc();}
  } else {if (DmX < 50) {displayLft();} else {displayRht();}}
  DispDel = 1;  // Update after 40ms
}

// ---------------------------------------------------------------------------------

void DM_MtrInc0(int16_t zP) {
  // Adjust PWM_?0 value
  int16_t zI = 1; if (DmSft) {zI = 10;}
  switch (zP) {
    case 0:
      if (DmB) {PWM_A0-= zI;} else {PWM_A0+= zI;}
      if (PWM_A0 > 255) {PWM_A0 = 255;} else if (PWM_A0 < 0) {PWM_A0 = 0;}
      analogWrite(Pin_A0, PWM_A0); PWM_A = getPWM(PWM_A0,PWM_A1,PWM_A_); break;
    case 1:
      if (DmB) {PWM_B0-= zI;} else {PWM_B0+= zI;}
      if (PWM_B0 > 255) {PWM_B0 = 255;} else if (PWM_B0 < 0) {PWM_B0 = 0;}
      analogWrite(Pin_B0, PWM_B0); PWM_B = getPWM(PWM_B0,PWM_B1,PWM_B_); break;
    case 2:
      if (DmB) {PWM_C0-= zI;} else {PWM_C0+= zI;}
      if (PWM_C0 > 255) {PWM_C0 = 255;} else if (PWM_C0 < 0) {PWM_C0 = 0;}
      analogWrite(Pin_C0, PWM_C0); PWM_C = getPWM(PWM_C0,PWM_C1,PWM_C_); break;
    case 3:
      if (DmB) {PWM_D0-= zI;} else {PWM_D0+= zI;}
      if (PWM_D0 > 255) {PWM_D0 = 255;} else if (PWM_D0 < 0) {PWM_D0 = 0;}
      analogWrite(Pin_D0, PWM_D0); PWM_D = getPWM(PWM_D0,PWM_D1,PWM_D_); break;
  }
}

// ---------------------------------------------------------------------------------

void DM_MtrInc1(int16_t zP) {
  // Adjust PWM_?1 value
  int16_t zI = 1; if (DmSft) {zI = 10;}
  switch (zP) {
    case 0:
      if (DmB) {PWM_A1-= zI;} else {PWM_A1+= zI;}
      if (PWM_A1 > 255) {PWM_A1 = 255;} else if (PWM_A1 < 0) {PWM_A1 = 0;}
      analogWrite(Pin_A1, PWM_A1); PWM_A = getPWM(PWM_A0,PWM_A1,PWM_A_); break;
    case 1:
      if (DmB) {PWM_B1-= zI;} else {PWM_B1+= zI;}
      if (PWM_B1 > 255) {PWM_B1 = 255;} else if (PWM_B1 < 0) {PWM_B1 = 0;}
      analogWrite(Pin_B1, PWM_B1); PWM_B = getPWM(PWM_B0,PWM_B1,PWM_B_); break;
    case 2:
      if (DmB) {PWM_C1-= zI;} else {PWM_C1+= zI;}
      if (PWM_C1 > 255) {PWM_C1 = 255;} else if (PWM_C1 < 0) {PWM_C1 = 0;}
      analogWrite(Pin_C1, PWM_C1); PWM_C = getPWM(PWM_C0,PWM_C1,PWM_C_); break;
    case 3:
      if (DmB) {PWM_D1-= zI;} else {PWM_D1+= zI;}
      if (PWM_D1 > 255) {PWM_D1 = 255;} else if (PWM_D1 < 0) {PWM_D1 = 0;}
      analogWrite(Pin_D1, PWM_D1); PWM_D = getPWM(PWM_D0,PWM_D1,PWM_D_); break;
  }
}

// ---------------------------------------------------------------------------------

void DM_MtrInc2(int16_t zP) {
  // Adjust PWM_? value
  int16_t zI = 1; if (DmSft) {zI = 10;}
  switch (zP) {
    case 0:
      if (DmB) {PWM_A-= zI;} else {PWM_A+= zI;}
      if (PWM_A > 255) {PWM_A = 255;} else if (PWM_A < -255) {PWM_A = -255;}
      if (PWM_A_) {
             if (PWM_A > 0) {PWM_A0 = 255 - PWM_A; PWM_A1 = 255;}
        else if (PWM_A < 0) {PWM_A0 = 255; PWM_A1 = 255 + PWM_A;}
        else {PWM_A0 = 255; PWM_A1 = 255;}
      } else {
             if (PWM_A > 0) {PWM_A0 = 0; PWM_A1 = PWM_A;}
        else if (PWM_A < 0) {PWM_A0 = -PWM_A; PWM_A1 = 0;}
        else {PWM_A0 = 0; PWM_A1 = 0;}
      }
      analogWrite(Pin_A0, PWM_A0); analogWrite(Pin_A1, PWM_A1); break;
    case 1:
      if (DmB) {PWM_B-= zI;} else {PWM_B+= zI;}
      if (PWM_B > 255) {PWM_B = 255;} else if (PWM_B < -255) {PWM_B = -255;}
      if (PWM_B_) {
             if (PWM_B > 0) {PWM_B0 = 255 - PWM_B; PWM_B1 = 255;}
        else if (PWM_B < 0) {PWM_B0 = 255; PWM_B1 = 255 + PWM_B;}
        else {PWM_B0 = 255; PWM_B1 = 255;}
      } else {
             if (PWM_B > 0) {PWM_B0 = 0; PWM_B1 = PWM_B;}
        else if (PWM_B < 0) {PWM_B0 = -PWM_B; PWM_B1 = 0;}
        else {PWM_B0 = 0; PWM_B1 = 0;}
      }
      analogWrite(Pin_B0, PWM_B0); analogWrite(Pin_B1, PWM_B1); break;
    case 2:
      if (DmB) {PWM_C-= zI;} else {PWM_C+= zI;}
      if (PWM_C > 255) {PWM_C = 255;} else if (PWM_C < -255) {PWM_C = -255;}
      if (PWM_C_) {
             if (PWM_C > 0) {PWM_C0 = 255 - PWM_C; PWM_C1 = 255;}
        else if (PWM_C < 0) {PWM_C0 = 255; PWM_C1 = 255 + PWM_C;}
        else {PWM_C0 = 255; PWM_C1 = 255;}
      } else {
             if (PWM_C > 0) {PWM_C0 = 0; PWM_C1 = PWM_C;}
        else if (PWM_C < 0) {PWM_C0 = -PWM_C; PWM_C1 = 0;}
        else {PWM_C0 = 0; PWM_C1 = 0;}
      }
      analogWrite(Pin_C0, PWM_C0); analogWrite(Pin_C1, PWM_C1); break;
    case 3:
      if (DmB) {PWM_D-= zI;} else {PWM_D+= zI;}
      if (PWM_D > 255) {PWM_D = 255;} else if (PWM_D < -255) {PWM_D = -255;}
      if (PWM_D_) {
             if (PWM_D > 0) {PWM_D0 = 255 - PWM_D; PWM_D1 = 255;}
        else if (PWM_D < 0) {PWM_D0 = 255; PWM_D1 = 255 + PWM_D;}
        else {PWM_D0 = 255; PWM_D1 = 255;}
      } else {
             if (PWM_D > 0) {PWM_D0 = 0; PWM_D1 = PWM_D;}
        else if (PWM_D < 0) {PWM_D0 = -PWM_D; PWM_D1 = 0;}
        else {PWM_D0 = 0; PWM_D1 = 0;}
      }
      analogWrite(Pin_D0, PWM_D0); analogWrite(Pin_D1, PWM_D1); break;
  }
}

// ---------------------------------------------------------------------------------

void DM_MtrMinInc() {
  // Adjust MtrMin value
  int16_t zI = 1;
  if (DmX <= 51) {zI = 10;}
  if (DmB) {MtrMin-= zI;} else {MtrMin+= zI;}
  if (MtrMin > 150) {MtrMin = 150;} else if (MtrMin < 0) {MtrMin = 0;}
}

// ---------------------------------------------------------------------------------

void DM_MtrOff(int16_t zP) {
  // Turn off PWM_?
  int16_t zI = 1; if (DmSft) {zI = 10;}
  switch (zP) {
    case 0:
      PWM_A = 0;
      if (DmB) {PWM_A0 = 0; PWM_A1 = 0; PWM_A_ = 0;} else {PWM_A0 = 255; PWM_A1 = 255; PWM_A_ = 1;}
      analogWrite(Pin_A0, PWM_A0); analogWrite(Pin_A1, PWM_A1); break;
    case 1:
      PWM_B = 0;
      if (DmB) {PWM_B0 = 0; PWM_B1 = 0; PWM_B_ = 0;} else {PWM_B0 = 255; PWM_B1 = 255; PWM_B_ = 1;}
      analogWrite(Pin_B0, PWM_B0); analogWrite(Pin_B1, PWM_B1); break;
    case 2:
      PWM_C = 0;
      if (DmB) {PWM_C0 = 0; PWM_C1 = 0; PWM_C_ = 0;} else {PWM_C0 = 255; PWM_C1 = 255; PWM_C_ = 1;}
      analogWrite(Pin_C0, PWM_C0); analogWrite(Pin_C1, PWM_C1); break;
    case 3:
      PWM_D = 0;
      if (DmB) {PWM_D0 = 0; PWM_D1 = 0; PWM_D_ = 0;} else {PWM_D0 = 255; PWM_D1 = 255; PWM_D_ = 1;}
      analogWrite(Pin_D0, PWM_D0); analogWrite(Pin_D1, PWM_D1); break;
  }
}

// ---------------------------------------------------------------------------------

void DM_MtrTest_() {
  //##################################
  // Motor Test display
  //##################################
  // user has clicked on a blue field in Monitor+ display
  if (DmY < 27) {
    if (DmX < 50) {displayLft();} else {displayRht();}
  } else {
    if (DmX < 43) {
      // has user clicked on a blue field
      if ((DmX >= 14) && (DmX <= 27)) {
            if ((DmY >= 27) && (DmY <= 38)) {DM_MtrInc0(0);}
        else if ((DmY >= 45) && (DmY <= 55)) {DM_MtrInc0(1);}
        else if ((DmY >= 63) && (DmY <= 74)) {DM_MtrInc0(2);}
        else if ((DmY >= 82) && (DmY <= 92)) {DM_MtrInc0(3);}
      } else {displayLft();}
    } else {
      // has user clicked on a blue field
      if ((DmX >= 43) && (DmX <= 55)) {
            if ((DmY >= 27) && (DmY <= 38)) {DM_MtrInc1(0);}
        else if ((DmY >= 45) && (DmY <= 55)) {DM_MtrInc1(1);}
        else if ((DmY >= 63) && (DmY <= 74)) {DM_MtrInc1(2);}
        else if ((DmY >= 82) && (DmY <= 92)) {DM_MtrInc1(3);}
      }
      else if ((DmX >= 64) && (DmX <= 79)) {
            if ((DmY >= 27) && (DmY <= 38)) {DM_MtrInc2(0);}
        else if ((DmY >= 45) && (DmY <= 55)) {DM_MtrInc2(1);}
        else if ((DmY >= 63) && (DmY <= 74)) {DM_MtrInc2(2);}
        else if ((DmY >= 82) && (DmY <= 92)) {DM_MtrInc2(3);}
      }
      else if ((DmX >= 82) && (DmX <= 96)) {
            if ((DmY >= 27) && (DmY <= 38)) {DM_MtrOff(0);}
        else if ((DmY >= 45) && (DmY <= 55)) {DM_MtrOff(1);}
        else if ((DmY >= 63) && (DmY <= 74)) {DM_MtrOff(2);}
        else if ((DmY >= 82) && (DmY <= 92)) {DM_MtrOff(3);}
      }
      else {displayRht();}
    }
  }
  DispDel = 1;  // Update after 40ms
}

// ---------------------------------------------------------------------------------

void DM_P_gainInc() {
  // Adjust pid_p_gain value
  float zI = 0.1;
       if (DmX <= 53) {zI = 100.0;}
  else if (DmX <= 58) {zI =  10.0;}
  else if (DmX <= 63) {zI =   1.0;}
  if (DmB) {pid_p_gain-= zI;} else {pid_p_gain+= zI;}
  if (pid_p_gain > 999.9) {pid_p_gain = 999.9;} else if (pid_p_gain < 0.00) {pid_p_gain = 0.00;}
}

// ---------------------------------------------------------------------------------

void DM_PID_() {
  //##################################
  // PID Controller display
  //##################################
  // User has clicked on a red or blue field in Monitor+ display
  if (TEST) {
          if (DmY < 26) {
              if (DmX < 15) {setDefPID();}
              else if (DmX < 50) {displayLft();} else {displayRht();}}
      else if ((DmY >= 26) && (DmY < 74)) {
          if (DmX < 50) {displayLft();}
      else if ((DmX >= 50) && (DmX <= 68) && (DmY <= 36)) {DM_P_gainInc();}
      else if ((DmX >= 86) && (DmX <= 96) && (DmY <= 36)) {DM_PID_dbInc();}
      else if ((DmX >= 50) && (DmX <= 68) && (DmY >= 44) && (DmY <= 54)) {DM_I_gainInc();}
      else if ((DmX >= 74) && (DmX <= 96) && (DmY >= 44) && (DmY <= 54)) {DM_Imax_gainInc();}
      else if ((DmX >= 50) && (DmX <= 68) && (DmY >= 62) && (DmY <= 73)) {DM_D_gainInc();}
      else {displayRht();}
    }
    else if ((DmY >= 81) && (DmY <= 91)) {
          if ((DmX >= 29) && (DmX <= 47)) {DM_PtchSaInc();}
      else if ((DmX >= 77) && (DmX <= 97)) {DM_RollSaInc();}
      else if (DmX < 50) {displayLft();} else {displayRht();}
    }
    else if (DmX < 50) {displayLft();} else {displayRht();}
  } else if (DmX < 50) {displayLft();} else {displayRht();}
  DispDel = 1;  // Update after 40ms
}

// ---------------------------------------------------------------------------------

void DM_PID_dbInc() {
  // Adjust PID_db value
  float zI = 0.1;
  if (DmX <= 91) {zI = 1.0;}
  if (DmB) {PID_db-= zI;} else {PID_db+= zI;}
  if (PID_db > 4.9) {PID_db = 4.9;} else if (PID_db < 0.0) {PID_db = 0.0;}
}

// ---------------------------------------------------------------------------------

void DM_PtchSaInc() {
  // Adjust PtchSbSpSa value
  float zI = 0.01;
       if (DmX <= 37) {zI = 1.0;}
  else if (DmX <= 42) {zI = 0.1;}
  if (PtchSbSpSa < 0.0) {zI = -zI;} // reverse adjustment for negative values
  if (DmB) {PtchSbSpSa-= zI;} else {PtchSbSpSa+= zI;}
  if (PtchSbSpSa > 9.99) {PtchSbSpSa = 9.99;} else if (PtchSbSpSa < -9.99) {PtchSbSpSa = -9.99;}
}

// ---------------------------------------------------------------------------------

void DM_RollSaInc() {
  // Adjust RollSbSpSa value
  float zI = 0.01;
       if (DmX <= 84) {zI = 1.0;}
  else if (DmX <= 89) {zI = 0.1;}
  if (RollSbSpSa < 0.0) {zI = -zI;} // reverse adjustment for negative values
  if (DmB) {RollSbSpSa-= zI;} else {RollSbSpSa+= zI;}
  if (RollSbSpSa > 9.99) {RollSbSpSa = 9.99;} else if (RollSbSpSa < -9.99) {RollSbSpSa = -9.99;}
}

// ---------------------------------------------------------------------------------

void DM_TurnMaxInc() {
  // Adjust TurnMax value
  float zI = 0.1;
       if (DmX <= 54) {zI = 10.0;}
  else if (DmX <= 59) {zI =  1.0;}
  if (DmB) {TurnMax-= zI;} else {TurnMax+= zI;}
  if (TurnMax > 99.9) {TurnMax = 99.9;} else if (TurnMax < 0.00) {TurnMax = 0.00;}
}

// ---------------------------------------------------------------------------------

void DM_TurnMinInc() {
  // Adjust TurnMin value
  float zI = 0.1;
       if (DmX <= 54) {zI = 10.0;}
  else if (DmX <= 59) {zI =  1.0;}
  if (DmB) {TurnMin-= zI;} else {TurnMin+= zI;}
  if (TurnMin > 99.9) {TurnMin = 99.9;} else if (TurnMin < 0.00) {TurnMin = 0.00;}
}

// ---------------------------------------------------------------------------------

void DM_V_MaxInc() {
  // Adjust V_max value
  float zI = 0.1;
       if (DmX <= 52) {zI = 1.0;}
  else if (DmX <= 57) {zI = 0.1;}
  if (DmB) {V_max-= zI;} else {V_max+= zI;}
  if (V_max > 8.20) {V_max = 8.20;} else if (V_max < 6.60) {V_max = 6.60;}
  CalcLimits();   // update soft limits
}

// ---------------------------------------------------------------------------------

void DriveMaxInc() {
  // Adjust DrvSpMax value
  float zI = 0.01;
       if (DmX <= 55) {zI = 1.0;}
  else if (DmX <= 59) {zI = 0.1;}
  if (DmB) {DrvSpMax-= zI;} else {DrvSpMax+= zI;}
  if (DrvSpMax > 9.99) {DrvSpMax = 9.99;} else if (DrvSpMax < 0.00) {DrvSpMax = 0.00;}
}

// ---------------------------------------------------------------------------------

void DriveMinInc() {
  // Adjust DrvSpMin value
  float zI = 0.01;
       if (DmX <= 55) {zI = 1.0;}
  else if (DmX <= 59) {zI = 0.1;}
  if (DmB) {DrvSpMin-= zI;} else {DrvSpMin+= zI;}
  if (DrvSpMin > 9.99) {DrvSpMin = 9.99;} else if (DrvSpMin < 0.00) {DrvSpMin = 0.00;}
}

// ---------------------------------------------------------------------------------

void doCmd() {
  // a '.' has been received on the serial port so execute command if valid
  // Commands:
  // DDn.     - increase (1) or decrease (-1) DispDel global delay offset DispDelGbl
  // DLn.     - toggle display lock, n=0 OFF, n=1 ON
  // DMxxyy.  - display monitor left mouse click, xx = 0-99, yy = 0-99
  // DM-.     - display monitor mouse up event
  // DS.      - SHIFT-key added to DMxxyy. message
  // G.       - report Scope data for graphing app
  // GE.      - end of Scope graphing mode
  // GPnn.    - nn points to data to be sent

  cmdVal*= cmdSgn;  // correct cmdVal with the sign value
  
  switch (cmdMode) {
    case ' ':
      PrintTx = "Hello\n"; break;
    case 'D':
      switch (cmdType) {
        case 'D': // DDn. command, adjust global delay offset
          if (cmdVal > 0) {DispDelGbl ++;} else {DispDelGbl --;}
          if (DispDelGbl < 0) {DispDelGbl = 0;}
          // display this in the Rx field of Monitor+
          PrintTx+= "$DispDelGbl: " + String(DispDelGbl) +"\n";
          break;
        case 'L':
          if (cmdVal != 0) {DispLock = true; DispOveride = DispMode;}
          else {DispLock = false;}
          break;
        case 'M':
          if (cmdSgn < 0) {  // mouse click released
            DmDwn = false;
            // Serial.println("DwDwn=false");
          } else {
            if (cmdVal >= 10000) {
              // this is a Display Monitor mouse right-click
              // determine whether it is a left or right button click
              cmdVal /= 10000; cmdVal --; DmB = 1;
              DmY = cmdVal % 100; DmX = cmdVal/100;
            } else {
              // this is a Display Monitor mouse left-click
              DmY = cmdVal % 100; DmX = cmdVal/100; DmB = 0;
            }
            if (!DmDwn) {
                  if (DispMode == DM_Control) {DM_Control_();}
              else if (DispMode == DM_DriveCtrl) {DM_DriveCtrl_();}
              else if (DispMode == DM_EyeEng) {DM_EyeEng_();}
              else if (DispMode == DM_ICM_Acc) {DM_ICM_Acc_();}
              else if (DispMode == DM_ICM_Gyros) {DM_ICM_Gyr_();}
              else if (DispMode == DM_Limits) {DM_Limits_();}
              else if (DispMode == DM_MtrTest) {DM_MtrTest_();}
              else if (DispMode == DM_PID) {DM_PID_();}
              else {
                // this is not a special 'clickable' display, so simply change it
                if (DmX < 50) {displayLft();  // left side click
                } else {displayRht();}       // right side click
              }
            }
            // Serial.println("DwDwn=true");
          } DmSft = false; break;
        case 'S': // embedded SHIFT key
          DmSft = true; break;
        break;
      } break;
    case 'G':
      // Scope graphing app report commands
      switch (cmdType) {
        case ' ': 
          // Report the same set of values twice as WiFi data can easily be
          // corrupted. Therefore two matching consequitives messages must be
          // received for the graphing function to work
          // if in Display Monitor mode then switch that off
          if (DispMon) {DispMon = false; PrintTx = ""; DispTx = -1;}
          // RPms = millis() - RPt0; RPt0 = millis();
          ScopeReport(GPnn); ScopeReport(GPnn);
          break;
        case 'E': // GE. enter monitor mode when dropping out of graphing mode
          // return to Display Monitor mode if it was previously active
          if (DispTx < 0) {DispMon = true; PrintTx = ""; DispTx = 50; DispDel = 0; DispCnt = 0;}
          break;
        case 'P': // GPnn. sets the reporting mode and triggers title reporting
          if (DispMon) {DispMon = false; PrintTx = ""; DispTx = -1;}
          GPnn = cmdVal; 
          if (G_once) {G_once = false; GPnn = 0;}
          GP_Title = true;
          PrintTx += "GP" + String(GPnn) + "\n";
          break;
      } break;
   default:
      PrintTx += "Unknown cmd: " + cmdMode + cmdType + String(cmdVal) + "\n";
      break;
  }
  // now reset the variables
  cmdMode = ' '; cmdType = ' '; cmdVal = 0; cmdSgn = 1; //cmdBlock = false;
}

// --------------------------------------------------------------------------------

void Do_LED_Task(bool zM) {
  // set LEDs or flags according to LED_Task value
  // zM = true turn LEDs ON/OFF
  // zM = false set LED flags
  // if (zM) {
  //   // it modifies LED outputs based on LED_Task value
  //   // the LOW state is used as the LED OFF state
  //   switch (LED_Task) {
  //     case -1: LEDs_OFF(); break; // ensure all are in the OFF state (LOW)
  //     case 0: // turns ON front blue LED_AB and LED_HL
  //       pinMode(LedCol2,INPUT_PULLUP); digitalWrite(LedRow1,LOW);
  //       digitalWrite(LedRow0, HIGH); digitalWrite(LedRow2, HIGH);
  //       pinMode(LedCol2,OUTPUT); digitalWrite(LedCol2, LOW); break;
  //     case 1: // turns ON right yellow LED_BY
  //       pinMode(LedCol2,INPUT_PULLUP); digitalWrite(LedRow0,LOW); digitalWrite(LedRow2, LOW);
  //       digitalWrite(LedRow1,HIGH); 
  //       pinMode(LedCol1,OUTPUT); digitalWrite(LedCol1,LOW); break;
  //     case 2: // turns ON right blue LED_BB
  //       pinMode(LedCol1,INPUT_PULLUP);
  //       digitalWrite(LedRow1,HIGH);
  //       pinMode(LedCol0,OUTPUT); digitalWrite(LedCol0,LOW); break;
  //     case 3: // turns ON rear yellow LED_CY
  //       pinMode(LedCol0,INPUT_PULLUP); digitalWrite(LedRow1,LOW);
  //       digitalWrite(LedRow2,HIGH);
  //       pinMode(LedCol1,OUTPUT); digitalWrite(LedCol1,LOW); break;
  //     case 4: // turns ON rear blue LED_CB
  //       pinMode(LedCol1,INPUT_PULLUP);
  //       digitalWrite(LedRow2,HIGH);
  //       pinMode(LedCol0,OUTPUT); digitalWrite(LedCol0,LOW); break;
  //     case 5: // turns ON left yellow LED_DY
  //       pinMode(LedCol0,INPUT_PULLUP); digitalWrite(LedRow2,LOW);
  //       digitalWrite(LedRow0,HIGH);
  //       pinMode(LedCol1,OUTPUT); digitalWrite(LedCol1,LOW); break;
  //     case 6: // turns ON left blue LED_DB
  //       pinMode(LedCol1,INPUT_PULLUP);
  //       digitalWrite(LedRow0,HIGH);
  //       pinMode(LedCol0,OUTPUT); digitalWrite(LedCol0,LOW); break;
  //     case 7: // turns ON front yellow LED_AY and LED_HL
  //       pinMode(LedCol0,INPUT_PULLUP); digitalWrite(LedRow0,LOW);
  //       digitalWrite(LedRow1,HIGH);  digitalWrite(LedRow2, HIGH);
  //       pinMode(LedCol2,OUTPUT); digitalWrite(LedCol2,LOW); break;
  //   }
  // } else {
  //   // this code is used in LEDMode = 2
  //   // it modifies flags based on LED_Task value
  //   ClrLEDFlags(); // set all flags to the OFF state (false)
  //   switch (LED_Task) {
  //     case 0: LED_AB = HIGH; break;
  //     case 1: LED_BY = HIGH; break;
  //     case 2: LED_BB = HIGH; break;
  //     case 3: LED_CY = HIGH; break;
  //     case 4: LED_CB = HIGH; break;
  //     case 5: LED_DY = HIGH; break;
  //     case 6: LED_DB = HIGH; break;
  //     case 7: LED_AY = HIGH; break;
  //   }
  // }
}

// --------------------------------------------------------------------------------

void driveMotors(float zPID_X,float zPID_Y,int zSteer) {
  //#################################################################################
  // Motor PWM calculations
  //#################################################################################
  // Uses pid_outputs to develop a motor demand for all 4 motors,
  // Steer applies a rotating vector, +ve = right, -ve = left
  MotorDriveA = (int)zPID_Y; MotorDriveC = -(int)zPID_Y;
  MotorDriveB = (int)zPID_X; MotorDriveD = -(int)zPID_X;
 
  // now add in steering force -255 to +255
  MotorDriveA += zSteer; MotorDriveC += zSteer;
  MotorDriveB += zSteer; MotorDriveD += zSteer;

  // as adding in steering can exceed the max PWM value we need to apply limits
  if (MotorDriveA > 255) {MotorDriveA = 255;}
  else if (MotorDriveA < -255) {MotorDriveA = -255;}
  if (MotorDriveB > 255) {MotorDriveB = 255;}
  else if (MotorDriveB < -255) {MotorDriveB = -255;}
  if (MotorDriveC > 255) {MotorDriveC = 255;}
  else if (MotorDriveC < -255) {MotorDriveC = -255;}
  if (MotorDriveD > 255) {MotorDriveD = 255;}
  else if (MotorDriveD < -255) {MotorDriveD = -255;}
  
  // Motor drive wires are connected in reverse so we need to reverse the polarity
  // of the drive signals at this point. This depends on how you have connected
  // the DC motors and may not be necessary.
  setMotorA_PWM(MotorDriveA); setMotorB_PWM(MotorDriveB);
  setMotorC_PWM(MotorDriveC); setMotorD_PWM(MotorDriveD);
}

// ---------------------------------------------------------------------------------

void extendCmdVal(int zVal) {
  // adds a new digit to the right-hand end of cmdVal
  cmdVal = abs(cmdVal * 10) + zVal;
}

// --------------------------------------------------------------------------------

void FlushRxBuffer() {
  // Read and ignore all characters in the serial port buffer  
  // while (Serial.available() > 0) {
  //     // read data to empty buffer
  //   keyVal = Serial.read();
  // }
}

// --------------------------------------------------------------------------------

String getAtState() {
  // returns the AtState value as a string
  String zT$ = "";
  GAScnt++; if (GAScnt > 2) {GAScnt = 0;}
  switch (GAScnt) {
    case 0: zT$ = "..z  "; break;
    case 1: zT$ = ".zz "; break;
    case 2: zT$ = "zzZ"; break;
  }
  Any$ = "???";
  switch (AtState) {
    case CAL:   Any$ = "READY!"; break;
    case READY:   Any$ = "READY!"; break;
    case RESET:   Any$ = "RESET..."; break;
    case REST:    Any$ = "Resting " + zT$; break;
  }
  if (Upright  <  0) {
  switch (GAScnt) {
    case 0: Any$ = "Upside"; break;
    case 1: Any$ = "Down"; break;
    case 2: Any$ = "???"; break;
  }
  }
  return Any$;
}

// --------------------------------------------------------------------------------

String getBAhex() {
  // Rerturns the current Broardcast Address MAC, ie: 50:02:91:68:F7:3F
  String zRet$ = ""; uint8_t zV;
  for (int zP = 0;zP < 6;zP++) {
    zV = broadcastAddress[zP]/16;
    if (zV < 10) {zRet$ += char(zV + 48);} else {zRet$ += char(zV + 55);}
    zV = broadcastAddress[zP] - (zV *16);
    if (zV < 10) {zRet$ += char(zV + 48);} else {zRet$ += char(zV + 55);}
    if (zP < 5) {zRet$ += ":";}
  }
  return zRet$;
}

// --------------------------------------------------------------------------------

int16_t getBatV(int32_t zAvg) {
  // Determine the battery voltage, and percentage, by mapping the ADC readings onto threshold Voltages
  // These threshold voltages were determined using a multimeter, to calibrate the ESP32's ADC
  // if the voltage exceeds BatMax, the estimated voltage is displayed, but battery capacity will be limited to 100%
       if (zAvg > Bat8v2)  {BatV = map(zAvg,Bat7v6,Bat8v4,760,840); BatPc = 100;} // >= 100%
  else if (zAvg > Bat7v6) {BatV = map(zAvg,Bat7v6,Bat8v2,760,820); BatPc = map(zAvg,Bat7v6,Bat8v2,80,100);}  // >= 80%
  else if (zAvg > Bat7v2) {BatV = map(zAvg,Bat7v2,Bat7v6,720,760); BatPc = map(zAvg,Bat7v2,Bat7v6,20, 80);}  // >= 20%
  else {BatV = map(zAvg,Bat6v6,Bat7v2,660,720); BatPc = map(zAvg,Bat6v6,Bat7v2,0,20);}  // < 20%
  if (BatPc < 0) {BatPc = 0;}   // Ignore < 0 percentages
  return BatV;
}

// --------------------------------------------------------------------------------

String GetBIN(byte zVal) {
  // returns an 8 character binary representation of zVal
  String zBIN$ = "";
  // convert zVal into binary
  if (zVal & 0B10000000) {zBIN$ += "1";} else {zBIN$ += "0";}
  if (zVal & 0B01000000) {zBIN$ += "1";} else {zBIN$ += "0";}
  if (zVal & 0B00100000) {zBIN$ += "1";} else {zBIN$ += "0";}
  if (zVal & 0B00010000) {zBIN$ += "1";} else {zBIN$ += "0";}
  if (zVal & 0B00001000) {zBIN$ += "1";} else {zBIN$ += "0";}
  if (zVal & 0B00000100) {zBIN$ += "1";} else {zBIN$ += "0";}
  if (zVal & 0B00000010) {zBIN$ += "1";} else {zBIN$ += "0";}
  if (zVal & 0B00000001) {zBIN$ += "1";} else {zBIN$ += "0";}
  return zBIN$;
}

// --------------------------------------------------------------------------------

String getHmsTime(unsigned long zMillis) {
  // returns a 'time' string in Hrs:Min:sec base on zMillis
  String zTime$ = "";
  long zU = zMillis/3600000; zMillis = zMillis%3600000;
  if (zU > 0) {zTime$ = String(zU) + ":";}
  zU = zMillis/60000; zMillis = zMillis%60000;
  if (zU < 10) {zTime$ += "0";}
  zTime$ += String(zU);
  zU = zMillis/1000;
  if (zU < 10) {zTime$ += ":0";} else {zTime$ += ":";}
  zTime$ += String(zU);
  return zTime$;
}

// --------------------------------------------------------------------------------

int16_t getModPWM(int16_t zPWM) {
  // Returns a modified PWM value, which is offset by MtrMin and scaled by PWM_Max from V_max
  // Note that it is assumed zPWM is positive, and ranges from 0 - 255
  return map(zPWM,0,255,MtrMin,PWM_Max);
}

// --------------------------------------------------------------------------------

int16_t getPWM(int16_t z0,int16_t z1,int16_t zF) {
  // Returns the combined PWM value, as in PWM_A, for PWM_A0, PWM_A1 and PWM_A_
  // Note this value is +/-
  int16_t zV = 0;
  if (zF) {
         if (z0 == 255) {zV = z1 - 255;}
    else if (z1 == 255) {zV = 255 - z0;}
    else if (z0  >  z1) {zV = z1 - z0;}
    else if (z0  <  z1) {zV = z1 - z0;}
  } else {
         if (z0 ==   0) {zV =  z1;}
    else if (z1 ==   0) {zV = -z0;}
    else if (z0  >  z1) {zV = z1 - z0;}
    else if (z0  <  z1) {zV = z1 - z0;}
  }
  return zV;
}

// --------------------------------------------------------------------------------

void ICM_42607_Initialise() {
  // set up gyro hardware
  // By default the MPU-6050 sleeps. So we have to wake it up.
  Wire.beginTransmission(ICM_address);  // Start communication with the address found during search.
  Wire.write(0x1F);                     // We want to write to the PWR_MGMT_0 register (1F hex)
  Wire.write(0b00001111);               // Turn ON gyros and accelerometers in Low Noise mode
  I2C_Err = Wire.endTransmission();     // End the transmission with the MPU.
  if (I2C_Err != 0) {return;}
  delayMicroseconds(200);               // Allow ICM time to turn ON sensors

  // Set the full scale of the gyro to +/- 250 degrees per second, ODR = 800Hz
  Wire.beginTransmission(ICM_address);  // Start communication with the address found during search.
  Wire.write(0x20);                     // We want to write to the GYRO_CONFIG register (20 hex)
  Wire.write(0b01100110);               // Set the gyro bits as +/-250dps full scale, 800Hz ODR
  I2C_Err = Wire.endTransmission();     // End the transmission with the MPU.
  if (I2C_Err != 0) {return;}
  delayMicroseconds(I2Cdel);            // Allow ICM time to respond

  //Set the full scale of the accelerometer to +/- 4g. ODR = 800Hz
  Wire.beginTransmission(ICM_address);  // Start communication with the address found during search.
  Wire.write(0x21);                     // We want to write to the ACCEL_CONFIG register (21 hex)
  Wire.write(0b01000110);               // Set the accel bits as +/- 4g full scale range, 800Hz ODR
  I2C_Err = Wire.endTransmission();     // End the transmission with the MPU.
  if (I2C_Err != 0) {return;}
  delayMicroseconds(I2Cdel);            // Allow ICM time to respond

  //Set gyro filtering to improve the raw data.
  Wire.beginTransmission(ICM_address);  // Start communication with the address found during search
  Wire.write(0x23);                     // We want to write to the CONFIG register (23 hex)
  Wire.write(0b00000100);               // Set Digital Low Pass Filter to ~53Hz
  I2C_Err = Wire.endTransmission();     // End the transmission with the MPU.
  if (I2C_Err != 0) {return;}
  delayMicroseconds(I2Cdel);            // Allow ICM time to respond

  //Set accelerometer filtering to improve the raw data.
  Wire.beginTransmission(ICM_address);  // Start communication with the address found during search
  Wire.write(0x24);                     // We want to write to the CONFIG register (24 hex)
  Wire.write(0b00000100);               // Set 2x averaging and Low Pass Filter to ~53Hz
  I2C_Err = Wire.endTransmission();     // End the transmission with the MPU.
  if (I2C_Err != 0) {return;}
  delayMicroseconds(I2Cdel);            // Allow ICM time to respond

  // Bypass FIFO mode
  Wire.beginTransmission(ICM_address);  // Start communication with the address found during search
  Wire.write(0x28);                     // We want to write to the CONFIG register (28 hex)
  Wire.write(0b00000001);               // Set FIFO to bypassed
  I2C_Err = Wire.endTransmission();     // End the transmission with the MPU.
  if (I2C_Err != 0) {return;}
  delayMicroseconds(I2Cdel);            // Allow ICM time to respond

  // APEX config1
  Wire.beginTransmission(ICM_address);  // Start communication with the address found during search
  Wire.write(0x26);                     // We want to write to the CONFIG register (26 hex)
  Wire.write(0b00000000);               // All motion detection disabled, ODR = 25Hz
  I2C_Err = Wire.endTransmission();     // End the transmission with the MPU.
  if (I2C_Err != 0) {return;}
  delayMicroseconds(I2Cdel);            // Allow ICM time to respond
}

// --------------------------------------------------------------------------------

void initBatteryRead() {
  // called during runPOST() or on a soft reset
  // take 100 battery readings over a 100ms period to get an average
  BatVol = 0;
  for (int zI = 0;zI < 100;zI++) {BatVol+= analogRead(BatPin); delay(1);}
  BatVol/= 100;

  BatAvg = BatVol; BatSum = BatVol * 50;  // preload the battery sum for averaging
  BatV = getBatV(BatVol); BatVfp = (float)BatV/100.0;
  Serial.println("Battery " + String(BatVol) + "\t" + String(BatVfp) + "v\t" + String(BatPc) + "%");
  randomSeed(BatVol); // use the battery voltage as the random seed factor
  // if battery is less than 5.5v then USB mode is assumed, which makes servos inoperable
  if (BatAvg <= BatUSB) {USB = true; Serial.println(F("USB power assumed."));}
  // Convert BatAvg to a mapped voltage and floating point equivalent
  BatV = getBatV(BatAvg); BatVfp = (float)BatV/10.0;
}

// --------------------------------------------------------------------------------

void Init_ESP_NOW() { 
  // called to initiate an ESEP-NOW link or connect to another trannsceiver
  // each time this function is called it will attempt to connect to a different
  // boradcast address, cycling through them, over and over
  //  Serial.println("Init_ESP_NOW()");

  // if we have previously tried a connection then we need to de-initialise it
  if (ESP_NOW_Init) {
    // already attempted to initialise ESP-NOW so strip everything back
    Serial.println("Closing ESP-NOW");
    esp_now_del_peer(broadcastAddress);
    // WiFi.disconnect();
  }
  
  // Init ESP-NOW and returns its status
  if (esp_now_init() != ESP_OK) {
    Serial.println("Error initializing ESP-NOW");
    return;
  }
  ESP_NOW_Init = true;
  
  // change the broadcast address pointer each time
  ESP_NOW_BA++;
  Serial.println("ESP_NOW_BA = " + String(ESP_NOW_BA));
  
  switch (ESP_NOW_BA) {
    case 0: // Wii Transciever unique MAC: 50:02:91:68:F7:3F
      broadcastAddress[0] = 0x50;
      broadcastAddress[1] = 0x02;
      broadcastAddress[2] = 0x91;
      broadcastAddress[3] = 0x68;
      broadcastAddress[4] = 0xF7;
      broadcastAddress[5] = 0x3F;
      break;
    case 1: // Wii Transciever unique MAC: 50:02:91:68:F0:D2
      broadcastAddress[0] = 0x50;
      broadcastAddress[1] = 0x02;
      broadcastAddress[2] = 0x91;
      broadcastAddress[3] = 0x68;
      broadcastAddress[4] = 0xF0;
      broadcastAddress[5] = 0xD2;
      break;
    case 2: // Wii D1 Mk1 Transciever unique MAC: 58:BF:25:DB:27:A2
      broadcastAddress[0] = 0x58;
      broadcastAddress[1] = 0xBF;
      broadcastAddress[2] = 0x25;
      broadcastAddress[3] = 0xDB;
      broadcastAddress[4] = 0x27;
      broadcastAddress[5] = 0xA2;
      break;
    case 3: // Wii ESP32-C3 Zero Transciever unique MAC: EC:DA:3B:BD:4B:AC
      broadcastAddress[0] = 0xEC;
      broadcastAddress[1] = 0xDA;
      broadcastAddress[2] = 0x3B;
      broadcastAddress[3] = 0xBD;
      broadcastAddress[4] = 0x4B;
      broadcastAddress[5] = 0xAC;
      break;
    default:
      // End of list reached, so extend pause time and reset cycle
      // Turn off serial port reporting after first pass, unless connection fails
      ESP_NOW_BA = -1;      // 1st case will be 0
      WiFiConCnt = 75;      // 3 sec delay between trying cycles
      WiFiTryOnce = false;  // don't report trying after one cycle
      break;
  }

  // Once ESPNow is successfully Init, we will register for Send CB to
  // get the status of Trasnmitted packet
  esp_now_register_send_cb(OnDataSent);

  // Register peer
  esp_now_peer_info_t peerInfo; //initialize and assign the peer information as a pointer to an addres
  memset(&peerInfo, 0, sizeof(peerInfo));
  memcpy(peerInfo.peer_addr, broadcastAddress, 6); //copy the value of  broadcastAddress with 6 bytes to peerInfo.peer_addr
  peerInfo.channel = 0;     //channel at which the esp talk. 0 means undefined and data will be sent on the current channel. 1-14 are valid channels which is the same with the local device 
  peerInfo.encrypt = false; //not encrypted

  //Add the device to the paired device list 
  if (esp_now_add_peer(&peerInfo) != ESP_OK){ 
    Serial.println("Failed to add peer");
    return;
  }

  // Register for a callback function that will be called when data is received
  esp_now_register_recv_cb(OnDataRecv);
}

// --------------------------------------------------------------------------------

void LED_Balancing() {
  // Live balancing mode
  // LEDs represent motor drive values, with colour and brightness
  LED_Fill(0,0,0);
  if (Ptch_pid_output > 0.0) {
    // Driving forwards, so light LED 1 & 8
    LED_BalDrv(Ptch_pid_output,1); LED[8] = LED[1];
  } else if (Ptch_pid_output < 0.0) {
    // Driving backwards, so light LED 2 & 7
    LED_BalDrv(-Ptch_pid_output,2); LED[7] = LED[2];
  } else {LED[1].setRGB(1,1,0); LED[2] = LED[1]; LED[7] = LED[1]; LED[8] = LED[1];}
  if (Roll_pid_output > 0.0) {
    // Driving to the right, so light LED 5 & 10
    LED_BalDrv(Roll_pid_output,5); LED[10] = LED[5];
  } else if (Roll_pid_output < 0.0) {
    // Driving to the left, so light LED 4 & 11
    LED_BalDrv(-Roll_pid_output,4); LED[11] = LED[4];
  } else {LED[4].setRGB(1,1,0); LED[5] = LED[4]; LED[10] = LED[4]; LED[11] = LED[4];}
  LED_Del = 3; LEDshow = true;
}

// --------------------------------------------------------------------------------

void LED_BalDrv(float zOp,int16_t zL) {
  // Determine the colour and brightness of LED zL for output zOp
  // Colour will go from green to red, brightness limited to 64
  ColR = 0; ColG = 0; ColB = 0;
  if (zOp > 64) {zOp = 64;}                       // limit zOp
       if (zOp <=  8.0) {ColR =  2; ColG = 2;}    // yellow
  else if (zOp <= 16.0) {ColG =  6;}              // green
  else if (zOp <= 24.0) {ColG =  4; ColB = 4;}    // turquise
  else if (zOp <= 32.0) {ColB = 10;}              // blue
  else if (zOp <= 40.0) {ColR =  6; ColB = 6;}    // purple
  else if (zOp <= 48.0) {ColR = 16;}              // red
     else {ColR = 32;}                            // bright red    
  LED[zL].setRGB(ColR,ColG,ColB);
}

// --------------------------------------------------------------------------------

void LED_Blue_Rot() {
  // Rotating Blue band
  switch (LED_Task) {
    case 0: // set initial state
      LED_Fill(0,0,0);
      LED[0].setRGB(0,0,16); LED[ 1].setRGB(0,0,4); LED[ 2].setRGB(0,0,2); LED[ 3].setRGB(0,0,0);
      LED[4].setRGB(0,0,16); LED[ 5].setRGB(0,0,4); LED[ 6].setRGB(0,0,2); LED[ 7].setRGB(0,0,0);
      LED[8].setRGB(0,0,16); LED[ 9].setRGB(0,0,4); LED[10].setRGB(0,0,2); LED[11].setRGB(0,0,0);
      LED_Task++; break;
    case 1: // rotate LEDs
      LED_Rot_Rht(); break;
  }
  LED_Del = 5; LEDshow = true;
}

// --------------------------------------------------------------------------------

void LED_Fill(uint8_t zR,uint8_t zG,uint8_t zB) {
  // Fill the LED array with a specific colour
  for (int zL = 0;zL < NumLEDs;zL++) {LED[zL].setRGB(zR,zG,zB);}
}

// --------------------------------------------------------------------------------

void LED_Green_Rot() {
  // Rotating Green band
  switch (LED_Task) {
    case 0: // set initial state
      LED_Fill(0,0,0);
      LED[0].setRGB(0,16,0); LED[ 1].setRGB(0,4,0); LED[ 2].setRGB(0,2,0); LED[ 3].setRGB(0,0,0);
      LED[4].setRGB(0,16,0); LED[ 5].setRGB(0,4,0); LED[ 6].setRGB(0,2,0); LED[ 7].setRGB(0,0,0);
      LED[8].setRGB(0,16,0); LED[ 9].setRGB(0,4,0); LED[10].setRGB(0,2,0); LED[11].setRGB(0,0,0);
      LED_Task++; break;
    case 1: // rotate LEDs
      LED_Rot_Rht(); break;
  }
  LED_Del = 5; LEDshow = true;
}

// --------------------------------------------------------------------------------

void LED_Main() {
  // Tasks for manipulating RGB LED patterns
  // Normally called at 20ms intervals, but variable if walking
  // Serial.print(String(LedMode) + " ");
  if (LedNop) {return;}
  
  // Blink background clock
  Blink = false; BlinkCnt++; if (BlinkCnt > 30) {BlinkCnt = 0; Blink = true;}
  // switch over-rides
  if (sw0State == LOW) {
    if (!LED_SW) {
      FastLED.clear();
      LED[1].setRGB(0,0,24); LED[2].setRGB(0,0,24); LEDshow = true;
    } LED_SW = true; return;
  }
  else if (sw1State == LOW) {
    if (!LED_SW) {
      FastLED.clear();
      LED[7].setRGB(0,0,24); LED[8].setRGB(0,0,24); LEDshow = true;
    } LED_SW = true; return;
  }
  if (LED_Del > 0) {LED_Del--; return;} // delay by skipping tasks
  if (LED_SW) {LED_SW = false; SetLEDmode(-LedMode);}

  // Serial.println(LedMode);
  switch(LedMode) {
    case  0: break;                     // do nothing
    case  1: LED_Green_Rot(); break;    // rotating green band
    case  2: LED_Blue_Rot(); break;     // rotating blue band
    case  3: LED_Purple_Rot(); break;   // rotating purple band
    case 10: LED_Yellow_Ring(); break;  // pulsating yellow ring
    case 20: LED_SpiritLevel(); break;  // spirit level
    case 30: LED_Balancing(); break;    // LIVE balancing
  }
}

// --------------------------------------------------------------------------------

void LED_Purple_Rot() {
  // Rotating Purple band
  switch (LED_Task) {
    case 0: // set initial state
      LED_Fill(0,0,0);
      LED[0].setRGB(8,0,8); LED[ 1].setRGB(2,0,2); LED[ 2].setRGB(1,0,1); LED[ 3].setRGB(0,0,0);
      LED[4].setRGB(8,0,8); LED[ 5].setRGB(2,0,2); LED[ 6].setRGB(1,0,1); LED[ 7].setRGB(0,0,0);
      LED[8].setRGB(8,0,8); LED[ 9].setRGB(2,0,2); LED[10].setRGB(1,0,1); LED[11].setRGB(0,0,0);
      LED_Task++; break;
    case 1: // rotate LEDs
      LED_Rot_Rht(); break;
  }
  LED_Del = 5; LEDshow = true;
}

// --------------------------------------------------------------------------------

void LED_Rot_Lft() {
  // Rotate all of the LEDs by one to the left, anti-clockwise when viewed from above
  LEDX[0] = LED[11];
  for (int zL = 11; zL > 0;zL--) {LED[zL] = LED[zL-1];}
  LED[0] = LEDX[0];
}

// --------------------------------------------------------------------------------

void LED_Rot_Rht() {
  // Rotate all of the LEDs by one to the right, clockwise when viewed from above
  LEDX[0] = LED[0];
  for (int zL = 0; zL < 11;zL++) {LED[zL] = LED[zL+1];}
  LED[11] = LEDX[0];
}

// --------------------------------------------------------------------------------

void LED_SpiritLevel() {
  // Spirit level ring
  float zV = 3.0; int16_t zL = 0; int16_t zNum;
  LED_Fill(0,0,0); ColR = 0; ColG = 0; ColB = 0;
  // Find the LED which is the highest
  if (Pitch > PtchSbSpSa) {
    // Tilting forwards
    if (Roll > RollSbSpSa) {
      // Tilting forwards left
             if (Pitch > (Roll + zV)) {zL = 5; zV = Pitch;}
        else if (Pitch < (Roll - zV)) {zL = 7; zV = Roll;}
        else {zL = 6; if (Pitch > Roll) {zV = Pitch;} else {zV = Roll;}}
    } else {
      // Tilting forwards right
             if (Pitch > (-Roll + zV)) {zL = 4; zV = Pitch;}
        else if (Pitch < (-Roll - zV)) {zL = 2; zV = -Roll;}
        else {zL = 3; if (Pitch > -Roll) {zV = Pitch;} else {zV = -Roll;}}
    }
  } else {
    // Tilting backwards
    if (Roll > 0.0) {
      // Tilting backwards left
             if (-Pitch > (Roll + zV)) {zL = 10; zV = -Pitch;}
        else if (-Pitch < (Roll - zV)) {zL = 8; zV = Roll;}
        else {zL = 9; if (-Pitch > Roll) {zV = -Pitch;} else {zV = Roll;}}
    } else {
      // Tilting backwards right
             if (-Pitch > (-Roll + zV)) {zL = 11; zV = -Pitch;}
        else if (-Pitch < (-Roll - zV)) {zL = 1; zV = -Roll;}
        else {zL = 0; if (-Pitch > -Roll) {zV = -Pitch;} else {zV = -Roll;}}
    }
  }
  // Use angle zV and LED pointer zL to determine number of LEDs to light
  // The larger the angle the fewer the LEDs, and colour turns from green towards red
       if (zV < 1.0) {zNum = 5; ColG =  4;}
  else if (zV < 2.0) {zNum = 4; ColG =  8;}
  else if (zV < 3.0) {zNum = 3; ColG =  6; ColB = 6;}
  else if (zV < 4.0) {zNum = 2; ColB = 18;}
  else if (zV < 5.0) {zNum = 1; ColB = 12; ColR = 12;}
  else {zNum = 0; ColR = 32;}
  // Now set the LEDs
  switch (zNum) {
    case 0: LED_SetNum(zL); break;
    case 1: LED_SetNum(zL); LED_SetNum(zL+1); LED_SetNum(zL-1); break;
    case 2: LED_SetNum(zL); LED_SetNum(zL+1); LED_SetNum(zL-1);
     LED_SetNum(zL+2); LED_SetNum(zL-2); break;
    case 3: LED_SetNum(zL); LED_SetNum(zL+1); LED_SetNum(zL-1);
     LED_SetNum(zL+2); LED_SetNum(zL-2);
     LED_SetNum(zL+3); LED_SetNum(zL-3); break;
    case 4: LED_SetNum(zL); LED_SetNum(zL+1); LED_SetNum(zL-1);
     LED_SetNum(zL+2); LED_SetNum(zL-2);
     LED_SetNum(zL+3); LED_SetNum(zL-3);
     LED_SetNum(zL+4); LED_SetNum(zL-4); break;
    case 5: LED_SetNum(zL); LED_SetNum(zL+1); LED_SetNum(zL-1);
     LED_SetNum(zL+2); LED_SetNum(zL-2);
     LED_SetNum(zL+3); LED_SetNum(zL-3);
     LED_SetNum(zL+4); LED_SetNum(zL-4);
     LED_SetNum(zL+5); LED_SetNum(zL-5); break;
  }
  LED_Del = 3; LEDshow = true;
}

// --------------------------------------------------------------------------------

void LED_SetNum(int16_t zP) {
  // Called to set a specific LED to preset colours
  // If teh pointer zP exceeds array limits it is corrected
       if (zP <  0) {zP += 12;}
  else if (zP > 11) {zP -= 12;}
  LED[zP].setRGB(ColR,ColG,ColB);
}

// --------------------------------------------------------------------------------

void LEDswCntFlash(int zMM) {
  // flash LEDs to indicate mode change
  // for (anyCnt = 0; anyCnt < zMM; anyCnt++) {
  //   for (anyFor = 0; anyFor < 30; anyFor++) {
  //     // LEDs are multiplexed so we need to create a temporary scanner
  //     digitalWrite(LedRow0, HIGH); digitalWrite(LedRow1, HIGH); digitalWrite(LedRow2, HIGH);
  //     pinMode(LedCol2,INPUT_PULLUP); pinMode(LedCol1,OUTPUT); digitalWrite(LedCol1,LOW);
  //     delayMicroseconds(500);
  //     digitalWrite(LedRow0, LOW); digitalWrite(LedRow1, HIGH); digitalWrite(LedRow2, LOW);
  //     pinMode(LedCol1,INPUT_PULLUP); pinMode(LedCol2,OUTPUT); digitalWrite(LedCol2,LOW);
  //     delayMicroseconds(500);
  //   }
  //   LEDs_OFF(); delay(300);
  // }
}

// --------------------------------------------------------------------------------

void LED_Yellow_Ring() {
  // Pulsing yellow ring, used in self-balance sequence
  LedCnt += LedInc;
       if (LedCnt >= 16) {LedInc = -2;}
  else if (LedCnt < 1) {LedInc = 1;}
  LED_Fill(LedCnt,LedCnt,0);
  LED_Del = 3; LEDshow = true;
}

// --------------------------------------------------------------------------------

int Limit255(int zI) {
  // return an integer value between 0 and 255
  if (zI > 255) {zI = 255;}
  if (zI < 0) {zI = 0;}
  return zI;
}

// --------------------------------------------------------------------------------

float mapFp(float x,float in_min,float in_max,float out_min,float out_max) {
  // floating point version of the map() function
  return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
}

// ---------------------------------------------------------------------------------

void PwmAttach(uint8_t zCh) {
  // Attached the micros internal PWM counter to an output pin
  switch (zCh) {
    case 0: analogWrite(Pin_A0, 0); break;
    case 1: analogWrite(Pin_A1, 0); break;
    case 2: analogWrite(Pin_B0, 0); break;
    case 3: analogWrite(Pin_B1, 0); break;
    case 4: analogWrite(Pin_C0, 0); break;
    case 5: analogWrite(Pin_C1, 0); break;
    case 6: analogWrite(Pin_D0, 0); break;
    case 7: analogWrite(Pin_D1, 0); break;
  }
}

// ---------------------------------------------------------------------------------

void PwmSetup(uint8_t zCh) {
  // Set the PWM counter to an output pin
  switch (zCh) {
    case 0: analogWriteFrequency(Pin_A0, PwmFreq); analogWriteResolution(Pin_A0, PwmBits); break;
    case 1: analogWriteFrequency(Pin_A1, PwmFreq); analogWriteResolution(Pin_A1, PwmBits); break;
    case 2: analogWriteFrequency(Pin_B0, PwmFreq); analogWriteResolution(Pin_B0, PwmBits); break;
    case 3: analogWriteFrequency(Pin_B1, PwmFreq); analogWriteResolution(Pin_B1, PwmBits); break;
    case 4: analogWriteFrequency(Pin_C0, PwmFreq); analogWriteResolution(Pin_C0, PwmBits); break;
    case 5: analogWriteFrequency(Pin_C1, PwmFreq); analogWriteResolution(Pin_C1, PwmBits); break;
    case 6: analogWriteFrequency(Pin_D0, PwmFreq); analogWriteResolution(Pin_D0, PwmBits); break;
    case 7: analogWriteFrequency(Pin_D1, PwmFreq); analogWriteResolution(Pin_D1, PwmBits); break;
  }
}

// --------------------------------------------------------------------------------

void PWM_OFF() {
  // turn OFF motor drives
  StartEn = false; DriveEn = false;   // disable drive task
  PWM_A0 = 0; PWM_A1 = 0; PWM_A = 0;  // stop Motor A front
  PWM_B0 = 0; PWM_B1 = 0; PWM_B = 0;  // stop Motor B right
  PWM_C0 = 0; PWM_C1 = 0; PWM_C = 0;  // stop Motor C rear
  PWM_D0 = 0; PWM_D1 = 0; PWM_D = 0;  // stop Motor D left
  analogWrite(Pin_A0, PWM_A0); analogWrite(Pin_A1, PWM_A1);
  analogWrite(Pin_B0, PWM_B0); analogWrite(Pin_B1, PWM_B1);
  analogWrite(Pin_C0, PWM_C0); analogWrite(Pin_C1, PWM_C1);
  analogWrite(Pin_D0, PWM_D0); analogWrite(Pin_D1, PWM_D1);
}

// --------------------------------------------------------------------------------

void read_Battery() {
  // Called to read the battery voltage every 8ms
  // In TEST mode we don't apply critical checks, so that we can adjust voltage
  // feeds freely for test purposes.
  BatVol = analogRead(BatPin);
  BatSum = BatSum + BatVol - BatAvg;
  BatAvg = BatSum/50;     // ADC is rolling averaged over 50 readings to remove noise
  // Serial.println(BatAvg);

  if ((BatAvg > Bat6v6) && (USB)) {
    // power has returned
    USB = false;
    synchLoopTimers();
  } 
  if (USB && !TEST) {return;}

  BatV = getBatV(BatAvg); BatVfp = (float)BatV/100.0;

  // Determine the max PWM value for this battery voltage
       if (BatVfp <= V_max) {PWM_Max = 255;}
  else if (BatVfp <= 8.20) {PWM_Max = (BatMult/BatVfp);}  // BatMult = 255.0 * V_max
  else {PWM_Max = 236;}

  // report WARNING state
  if ((BatPc < 20) && !TEST) {Display_BatWarning();}

  // If battery voltage falls below critical threshold, trigger a shutdown
  if (BatAvg < Bat6v6) {
    // Below critical threshold
    // Ensure motors are OFF
    PWM_OFF();
    // Clear eye updates
    GFX_Txt = 0; GFX_Run = 0; LEDshow= false;
    // Turn OFF LEDs
    FastLED.clear(); FastLED.show(); LedNop = true;
    // If Monitor+ is running, send warning, then terminate
    PrintTx = ""; Display_Batt_Low();
    while (PrintTx.length() > 0) {PrintTxHandler(); delay(40);}
    DispMon = false;
    // Put a message on the eye display
    tft.fillScreen(GC9A01A_BLACK);
    tft.setTextColor(GC9A01A_RED);
    TFT_Text_Ctr(120,80,5,"Battery");
    TFT_Text_Ctr(120,128,5,"LOW");
    delay(1000);  // allow time for messages
    // Enter low power state
    esp_deep_sleep_start();
    // Endless loop...
    while (true) {yield();}
  }
}

// --------------------------------------------------------------------------------

void readSerial() {
  // Reads characters from the serial port and responds to commands
  // set PrintTgt to indicate source as serial port for responses
  // This function empties the serial buffer, to prevent overload
  while (Serial.available() > 0) {
    keyVal = Serial.read();
    SerialRx = true; PrintTgt = 0;
    decodeKey(keyVal);
  }
}

// --------------------------------------------------------------------------------

void read_SW0() {
  // Read the left SW0 button switch and respond accordingly, pressed == LOW
  // A button press will automatical drop the current task
  // this function is called every 8ms which is the swTimer increment period
  sw0State = digitalRead(sw0Pin);
  if ((sw0WaitHi) && (sw0State == LOW)) {return;} // waiting for HIGH release
  if (sw0WaitHi) {sw0WaitHi = false; sw0LastState = HIGH; return;}  // clear hold flag
  
  if (!sw0State) {
    // Test for Hi-Lo transition
    if (sw0LastState != sw0State) {
      // SW0 switch has just gone LOW, this is the falling edge
      // Serial.println("SW0 Lo");
      if (MainMode != 0) {setMainMode(0); sw0WaitHi = true; return;}
      sw0Cnt++;      // count on the falling edge
      sw0Timer = 0;  // reset the timer
    }
    if (sw0Timer >= 125) {
      // SW0 held down for 1 second so change eye display mode
      GFX_Mode++; if (GFX_Mode > 2) {GFX_Mode = 0;}
      GFX_RST = true; sw0WaitHi = true; sw0Cnt = 0; sw0Timer = 0; return;
    }
    sw0Timer++;

  } else {
    // Test for Lo-Hi transition
    if (sw0LastState != sw0State) {
      // rising edge of SW0
      // Serial.println("SW0 Hi");
           if (MainMode != 0) {setMainMode(0);}  // active so go back to waiting ManMode 0
      else if (Upright < 0) {setMainMode(4);}    // motor drive demonstration
    }
    if (sw0Cnt > 0) {sw0Timer++;} // button was pressed so run timer
    if (sw0Timer >= 125) {
      // Button released for 1 sec so assume valid button count
    } else if(sw0Timer >= 250) {
      sw0Cnt = 0; sw0Timer = 0;
    }
  }
  sw0LastState = sw0State;      // record current state
}

// --------------------------------------------------------------------------------

void read_SW1() {
  // Read the right SW1 button switch and respond accordingly, pressed == LOW
  // A button press will automatical drop the current task
  // this function is called every 8ms which is the swTimer increment period
  sw1State = digitalRead(sw1Pin);
  if ((sw1WaitHi) && (sw1State == LOW)) {return;} // waiting for HIGH release
  if (sw1WaitHi) {sw1WaitHi = false; sw1LastState = HIGH; return;}  // clear hold flag
  
  if (!sw1State) {
    // Test for Hi-Lo transition
    if (sw1LastState != sw1State) {
      // SW0 switch has just gone LOW, this is the falling edge
      // Serial.println("SW1 Lo");
      if (MainMode != 0) {setMainMode(0); sw1WaitHi = true; return;}
      sw1Cnt++;      // count on the falling edge
      sw1Timer = 0;  // reset the timer
    }
  } else {
    // Test for Lo-Hi transition
    if (sw1LastState != sw1State) {
      // rising edge of SW1
      // Serial.println("SW1 Hi");
           if (MainMode != 0) {setMainMode(0);}  // active so go back to waiting ManMode 0
      else if (Upright  >  0) {setMainMode(1);}  // try to enter self balance sequence
      else if (Upright  <  0) {setMainMode(4);}  // motor drive demonstration
      sw1Cnt = 0; sw1Timer = 0;
    }
  }
  sw1LastState = sw1State;      // record current state
}

// ----------------------------------------------------------------------

void SetLEDmode(int16_t zM) {
  // Starts a new LED sequence on Core0
  // Set zM to -ve to restart that mode
  if (LedMode == zM) {return;}      // already in this mode, so exit

  LedModeNew = zM; SetLEDs = true;  // trigger Core0 to set this mode
}

// ----------------------------------------------------------------------

void SetLEDmodeNow(int16_t zM) {
  // Called from Core0 task, starts a new LED sequence
  if ((zM < 0) || (LedMode != zM)) {
    LedCnt = 0;             // counter used in LED sequencing
    LED_Del = 0;            // delay timer used in LED functions
    LedInc = 1;             // increment used in LED sequencing
    LedLast = 0;            // previous task when change set
    LedMem = -1;            // previous recorded LED variable, default -1
    LedNop = false;         // if == true then skip LED modes
    LEDshow = false;        // LED show flag for mouth LEDs
    LED_Task = 0;           // reset LED task pointer
    LEDVal = 0;             // values used in LED tasks
  }
  LedMode = abs(zM);        // set mode to zM
  // Serial.println("\nSetLEDmode: " + String(zM) + "\t" + String(LedMode));
}

// --------------------------------------------------------------------------------

void setMainMode(int16_t zMM) {
  // set the appropriate conditions for a given mode
  PWM_OFF();            // stop motors when changing modes
  MainSkip = 0;           // counter used to skip MainMOde tasks
  MainSkipCnt = 0;        // value used to pre-load MainSkip
  ModeCnt = 0;            // counter used in MainMode tasks
  ModeCycle = 0;          // cycle counter used in MainMode tasks
  ModeTask = 0;           // task poiinter used in MainMode tasks
  Pitch_En = false;       // disable PID Pitch error calcs
  Ptch_pid_output = 0.0;  // Pitch PID p-gain output
  Roll_En = false;        // disable PID Roll error calcs
  Roll_pid_output = 0.0;  // Pitch PID p-gain output
  SafeMode = 0;           // default condition is safe
  SetMainSkip(0);         // reset Main Mode skip timer
  StartEn = false;        // true to perform motor calcs and enable output
  Steer = 0.0;            // steering demand, +ve = right, -ve = left, max 255
  switch(zMM) {
    case 0: // default MainMode
      break;
    case 1: // user looking for balance start, with full PID settings
      // reset_PID();
      DispMode = DM_SaPtchRoll; DispDel = 1;
      break;
    case 2: // LIVE balancing
      // This mode is never set via this function, to avoid reseting flags
      break;
    case 4: // motor drive demo
      // LEDMode = 2; LEDA_Cnt = 1; LEDB_Cnt = 1; LEDC_Cnt = 1; LEDD_Cnt = 1;  // set LED mode
      break;
  } MainMode = zMM; MainTest = zMM;
  // Serial.flush(); Serial.print(F("MM = ")); Serial.println(MainMode);
}

// --------------------------------------------------------------------------------

void SetMainSkip(int zCnt) {
  // Sets a delay counter for controlling the speed of some Mode functions
  MainSkipCnt = zCnt; MainSkip = MainSkipCnt;
}

// --------------------------------------------------------------------------------

void setMotorA_PWM(int zPWM) {
  // Sets the motor drive based on the PWM value and sign
  // +ve = clockwise, -ve = anti-clockwise
  // clockwise  - set A0 = 255 - zPWM,  A1 = HIGH (255)
  // anti-clkw  - set A0 = HIGH (255),  A1 = 255 - zPWM
  // Serial.println(); Serial.print(zPWM);
  PWM_A = zPWM;
  if (zPWM < 0) {
    // negative drive, anti-clockwise
    PWM_A0 = 255; PWM_A1 = 255 - getModPWM(-zPWM); // 
  } else if (zPWM == 0) {
    PWM_A0 = 255; PWM_A1 = 255;         // H-bridge brake mode
  } else {
    // positive drive, clockwise
    PWM_A0 = 255 - getModPWM(zPWM); PWM_A1 = 255; // 
  }
  analogWrite(Pin_A0, PWM_A0); analogWrite(Pin_A1, PWM_A1);
}

// --------------------------------------------------------------------------------

void setMotorB_PWM(int zPWM) {
  // sets the motor drive based on the PWM value and sign
  // +ve = clockwise, -ve = anti-clockwise
  // clockwise  - set A0 = 255 - zPWM,  A1 = HIGH (255)
  // anti-clkw  - set A0 = HIGH (255),  A1 = 255 - zPWM
  // Serial.print(","); Serial.print(zPWM);
  PWM_B = zPWM;
  if (zPWM < 0) {
    // negative drive, anti-clockwise
    PWM_B0 = 255; PWM_B1 = 255 - getModPWM(-zPWM); // 
  } else if (zPWM == 0) {
    PWM_B0 = 255; PWM_B1 = 255;         // H-bridge brake mode
  } else {
    // positive drive, clockwise
    PWM_B0 = 255 - getModPWM(zPWM); PWM_B1 = 255; // 
  }
  analogWrite(Pin_B0, PWM_B0); analogWrite(Pin_B1, PWM_B1);
}

// --------------------------------------------------------------------------------

void setMotorC_PWM(int zPWM) {
  // sets the motor drive based on the PWM value and sign
  // +ve = clockwise, -ve = anti-clockwise
  // clockwise  - set A0 = 255 - zPWM,  A1 = HIGH (255)
  // anti-clkw  - set A0 = HIGH (255),  A1 = 255 - zPWM
  // Serial.print(","); Serial.print(zPWM);
  PWM_C = zPWM;
  if (zPWM < 0) {
    // negative drive, anti-clockwise
    PWM_C0 = 255; PWM_C1 = 255 - getModPWM(-zPWM); // 
  } else if (zPWM == 0) {
    PWM_C0 = 255; PWM_C1 = 255;         // H-bridge brake mode
  } else {
    // positive drive, clockwise
    PWM_C0 = 255 - getModPWM(zPWM); PWM_C1 = 255; // 
  }
  analogWrite(Pin_C0, PWM_C0); analogWrite(Pin_C1, PWM_C1);
}

// --------------------------------------------------------------------------------

void setMotorD_PWM(int zPWM) {
  // sets the motor drive based on the PWM value and sign
  // +ve = clockwise, -ve = anti-clockwise
  // clockwise  - set A0 = 255 - zPWM,  A1 = HIGH (255)
  // anti-clkw  - set A0 = HIGH (255),  A1 = 255 - zPWM
  PWM_D = zPWM;
  if (zPWM < 0) {
    // negative drive, anti-clockwise
    PWM_D0 = 255; PWM_D1 = 255 - getModPWM(-zPWM); // 
  } else if (zPWM == 0) {
    PWM_D0 = 255; PWM_D1 = 255;         // H-bridge brake mode
  } else {
    // positive drive, clockwise
    PWM_D0 = 255 - getModPWM(zPWM); PWM_D1 = 255; // 
  }
  analogWrite(Pin_D0, PWM_D0); analogWrite(Pin_D1, PWM_D1);
}

// --------------------------------------------------------------------------------

void ToggleTestMode() {
  // Toggle the TEST value and settings
  TEST = !TEST;
  getDispRef();             // read references, without displaying screens
}

// ---------------------------------------------------------------------------------



  //###############################################################################
  //
  //  WiFi Code
  //
  //###############################################################################

void WiFiClearRxBuff(int zNum) {
  // clears the contents of the receive buffer
  for (int zP = 0; zP < zNum;zP++) {Rx_Buff.ESPdata[zP] = 0;}
}

// --------------------------------------------------------------------------------

void WiFiClearTxBuff(int zNum) {
  // clears the contents of the transmit buffer
  for (int zP = 0; zP < zNum;zP++) {Tx_Buff.ESPdata[zP] = 0;}
}

// ---------------------------------------------------------------------------------

void WiFiDisable() {
  // when either a switch is pressed or WiFi disable is required
  WiFiEn = false; WiFiCntC = 0; WiFiRestCnt = 0; C_Dn = 8; Z_Dn = 8;
}

// --------------------------------------------------------------------------------

void WiFiDisconnect() {
  // enter the WiFi disconnected state
  WiFiConnected = false;
  WiFiClearRxBuff(WiFiTx_len);
  WiFiClearTxBuff(WiFiTx_len);
  WiFiTryCnt = 0;     // reset the connection retry counter
  WiFiTx_CB = 1;      // set ready to send flag
  WiFiRxRec = false;  // clear the data received flag
  Serial.println("WiFiDisconnected!");
}

// --------------------------------------------------------------------------------

void WiFiKill() {
  // Called to permanently disconnect WiFi
  // You need to press RESET to recover from this
  WiFi.disconnect();  // Disconnect existing link
  WiFiDisconnect();   // reset variables
  WiFiOff = true;     // Flag prevents reconnection attempts
}

// --------------------------------------------------------------------------------

void WiFiNotConnected() {
  // If not connected to WiFi then try to connect every second
  // only try to connect WiFi if no 'Pings' are being received from an application
  if (WiFiOff) {return;}  // WiFi has been turned off

  if (Ping == 0) {
    WiFiConCnt--; if (WiFiConCnt < 1) {
      WiFiConCnt = 10; WiFiTryToConnect();  // 400 ms retry time-out
      if (WiFiTryOnce) {Serial.println("Trying to connect: " + getBAhex());}
    }
  }
}

// --------------------------------------------------------------------------------

void WiFiPingHandler() {
  // Ping is set to a value whenever data is received from an app
  // For the app to remain connected, this must be continuous
  WiFiPing--;
  if (WiFiPing < 1) {
      // We have stopped receiving so disconnect WiFi
    WiFiDisconnect();
    ESP_NOW_BA = -1;
    WiFiTryOnce = true;
    Serial.println("WiFiPing == 0");
    // set defaults here
    WiFiEn = false; SetLEDmode(0);
  }
}

// --------------------------------------------------------------------------------

void WiFiReadRx() {
  // called from the main loop every cycle to check for ESP-NOW data  
  // a state machine is used to separate the data blocks by header type
  // DispDel = 500;  // hold off display updates for 10 sec
  switch(Rx_Task) {
    case 0: // determine the type of data to handle
           if (Rx_Buff.ESPdata[Rx_Pnt] == 'B') {Rx_Task = 3; break;}
      else if (Rx_Buff.ESPdata[Rx_Pnt] == 'C') {WiiType = 'C'; Rx_Task = 1; break;} // Classic
      else if (Rx_Buff.ESPdata[Rx_Pnt] == 'P') {WiiType = 'P'; Rx_Task = 1; break;} // Classic Pro
      else if (Rx_Buff.ESPdata[Rx_Pnt] == 'N') {WiiType = 'N'; Rx_Task = 1; break;} // Nunchuk
      else if (Rx_Buff.ESPdata[Rx_Pnt] == '-') {WiiType = '-'; Rx_Task = 1; break;}
      else if (Rx_Buff.ESPdata[Rx_Pnt] == '$') {Rx_Task = 2; break;}
      // oh dear! bloick header not recognised so discard the block and flag error
      else {WiFiRxErr++; WiFiRx = false;}
      break;
      
    case 1: // load Wii I2C data
      // after the header byte there are 6 data bytes + checksum
      // perform XOR on 6 bytes to check for errors
      if (Rx_Buff.ESPdata[7] == (Rx_Buff.ESPdata[1] ^ Rx_Buff.ESPdata[2] ^ Rx_Buff.ESPdata[3] ^ Rx_Buff.ESPdata[4] ^ Rx_Buff.ESPdata[5] ^ Rx_Buff.ESPdata[6])) {
        // data has passed the checksum test
        RxWiFi[0] = Rx_Buff.ESPdata[1];
        RxWiFi[1] = Rx_Buff.ESPdata[2];
        RxWiFi[2] = Rx_Buff.ESPdata[3];
        RxWiFi[3] = Rx_Buff.ESPdata[4];
        RxWiFi[4] = Rx_Buff.ESPdata[5];
        RxWiFi[5] = Rx_Buff.ESPdata[6];

        // if Nunchuk data strip off the JX,JY and CZ values
        RxRec = true; // indicate a valid frame
        if (WiiType == 'N') {           // Wii Nunchuk
          JoyX = RxWiFi[0];             // joystick X 0-255
          JoyY = RxWiFi[1];             // joystick Y 0-255
          CZ = RxWiFi[5] & 3;           // CZ buttons, C = 2/0, Z = 1/0, active low
        } else if (WiiType == 'C') {    // Wii Classic
          JoyX = WiiRightStickX() * 8;  // joystick X 0-255
          JoyY = WiiRightStickY() * 8;  // joystick Y 0-255
          CZ = ((RxWiFi[4] & 0b100000)>>5) + (RxWiFi[4] & 0b10); // read LT and RT buttons as C,Z
        } else if (WiiType == 'P') {    // Wii Classic Pro
          JoyX = WiiRightStickX() * 8;  // joystick X 0-255
          JoyY = WiiRightStickY() * 8;  // joystick Y 0-255
          CZ = (RxWiFi[4] & 0b10) + ((RxWiFi[5] & 0b100)>2); // read RT and ZR buttons as C,Z
        } else {
          // not Nunchuk so set defaults
          JoyX = 128; JoyY = 128; CZ = 3;
        }
      } else {
        WiFiRxErr++;
      }
      Rx_Task = 0;  // reset the task pointer to lok at another block if needed
      Rx_Pnt += 8;  // increase the data pointer beyond this block
      if (Rx_Pnt >= Rx_len) {WiFiRx = false; Rx_len = 0;} // reached end of buffer
      break;

    case 2: // load text data as if from a serial port
      // read characters up to the end of the buffer
      Rx_Pnt++;
      if (Rx_Pnt >= Rx_len) {WiFiRx = false; Rx_len = 0; break;} // reached end of buffer
      keyVal = Rx_Buff.ESPdata[Rx_Pnt]; PrintTgt = 1; decodeKey(keyVal);
      // Serial.write(keyVal);
      break;

    case 3: // load binary data block
      // data length is specified in second byte
      Rx_Pnt++;
      // at the moment just jump over it, binary transfer is not needed
      Rx_Pnt += Rx_Buff.ESPdata[Rx_Pnt] + 1;
      if (Rx_Pnt >= Rx_len) {WiFiRx = false; break;} // reached end of buffer
      break;
  }
}

// ---------------------------------------------------------------------------------

void WiFiRxGetChecksum(int zlen) {
  // performs an XOR checksum calc on the Rx buffer of length zlen
  Rx_Chk = 0x55;  // define checksum seed as 01010101
  for (int zP = 0;zP < zlen;zP++) {
    Rx_Chk = Rx_Chk ^ Rx_Buff.ESPdata[zP];
  }
}

// --------------------------------------------------------------------------------

void WiFiTryToConnect() {
  // Try to connect with the Wii Transceiver by sending devices name
  // Constantly trying to connect can impact on robot performance
  if (WiFiTryNum >= 20) {return;} // maximum number of tries
  // Initialise ESP-NOW link first
  Init_ESP_NOW();

  Tx_Buff.ESPdata[0] = 'B';
  Tx_Buff.ESPdata[1] = 'a';
  Tx_Buff.ESPdata[2] = 'l';
  Tx_Buff.ESPdata[3] = 'l';
  Tx_Buff.ESPdata[4] = 'B';
  Tx_Buff.ESPdata[5] = 'o';
  Tx_Buff.ESPdata[6] = 't';
  Tx_Buff.ESPdata[7] = '4';
  Tx_Buff.ESPdata[8] = 'x';
  Tx_Buff.ESPdata[9] = '4';
  WiFiTx_len = 10;
  // t0 = micros();
  esp_err_t result = esp_now_send(broadcastAddress, (uint8_t *) &Tx_Buff, WiFiTx_len);
  if (result == ESP_OK) {
    // Serial.println("Sent with success");
  } else {
    // Serial.println("Error sending the data");
  } 

  WiFiTryNum++; // count the total number of attempts
  // Serial.println("WiFiTryToConnect...");
}

// --------------------------------------------------------------------------------

void WiFiTxGetChecksum(int zlen) {
  // performs an XOR checksum calc on the Tx buffer of length zlen
  WiFiTx_Chk = 0x55;  // define checksum seed as 01010101
  for (int zP = 0;zP < zlen;zP++) {
    WiFiTx_Chk = WiFiTx_Chk ^ Tx_Buff.ESPdata[zP];
  }
}

// ----------------------------------------------------------------------

int WiiRightStickX() {
  // returns a Wii Classic RX value 0/16/31
  return ((RxWiFi[0] & (byte)0xc0) >> 3) + ((RxWiFi[1] & (byte)0xc0) >> 5) +  ((RxWiFi[2] & (byte)0x80) >> 7);
}

// ----------------------------------------------------------------------

int WiiRightStickY() {
  // returns a Wii Classic RY value 0/16/31
  return RxWiFi[2] & (byte)0x1f;    
}

// --------------------------------------------------------------------------------

