
// --------------------------------------------------------------------------------

void Eye_Engine() {
  // Called every 40ms to perform a series of tasks to keep the eye moving.
  // Text is handled as the higher priority task
  // GFX_Mode:
  // 0  - full eye, no text   - 240x240 eye, no text
  // 1  - most eye, some text - 240x160 eye, 240,80 text
  // 2  - no eye, full text   - no eye, 240x240 text
  if (!Eye_En) {return;}    // Abort if eye function is disabled

  //#########################################################
  // Cyclopse eye engime
  //#########################################################
  // Only perform next task if the previous has completed
  if (GFX_Run == 0) {
    // Check for a wait skip delay
    if (GFX_Wait > 0) {GFX_Wait--;}   // pause/wait timer and exit
    else if (GFX_Mode < 2) {
      // Draw full or partial eye, depending on GFX_Mode
      switch (GFX_Eng) {
        case  0: // initialise, draws full eye as if for the first time
          if (GFX_Mode == 0) {
            // This is a full eye
            GFX_R0 = 70; GFX_R1 = GFX_R0/2; // eye and cornea radii
            GFX_X = 120; GFX_Y = 120; GFX_Run = GFX_EyeXY;}
          else if (GFX_Mode == 1) {
            // This is a partial eye
            GFX_R0 = 60; GFX_R1 = GFX_R0/2; // eye and cornea radii
            GFX_X = 120; GFX_Y =  80; GFX_Run = GFX_EyeXY;}
          else if (GFX_Mode == 2) {
            // This is no eye mode
            GFX_Run = 0;}
          GFX_Eng = 2; break;
        case  1: // set eye random target position
          if (GFX_Mode == 0) {
            // This is a full eye
            GFX_R0 = 70; GFX_R1 = GFX_R0/2; // eye and cornea radii
            if (Steer == 0.00) { // No steer
                  GFX_X = 120 + random(-(120 - GFX_R0),1 + (120 - GFX_R0));
                  GFX_Y = 120 + random(-(120 - GFX_R0),1 + (120 - GFX_R0));}
            else if (Steer > 0.10) { // Steer left
              GFX_X = 240 - GFX_R0; GFX_Y = 120;}
            else {GFX_X = GFX_R0; GFX_Y = 120;} // Steer right
            GFX_R1 = GFX_R0/4; GFX_R1Tgt = (GFX_R0 * (30 + random(21)))/100;
            GFX_Run = GFX_EyeMove;}
          else if (GFX_Mode == 1) {
            // This is a partial eye
            GFX_R0 = 60; GFX_R1 = GFX_R0/2; // eye and cornea radii
            if (Steer == 0.00) { // No steer
                  GFX_X = 120 + random(-(120 - GFX_R0),1 + (120 - GFX_R0));
                  GFX_Y =  80 + random(-( 80 - GFX_R0),1 + ( 80 - GFX_R0));}
            else if (Steer > 0.10) { // Steer left
              GFX_X = 240 - GFX_R0; GFX_Y = 160 - GFX_R0;}
            else {GFX_X = GFX_R0; GFX_Y = 160 - GFX_R0;} // Steer right
            GFX_R1 = GFX_R0/4; GFX_R1Tgt = (GFX_R0 * (30 + random(21)))/100;
            GFX_Run = GFX_EyeMove;}
          else if (GFX_Mode == 2) {
            // This is no eye mode
            GFX_Run = 0;}
          GFX_Eng++; break;
        case 2: // resize the pupil
          if (GFX_Mode < 2) {
            if (GFX_R1 != GFX_R1Tgt) {GFX_Run = GFX_Pupil;}
            else {GFX_Eng++;}}
          else {GFX_Eng++;}
          break;
        case 3: // random pause before next move
          if (GFX_Mode < 2) {GFX_Wait = 10 + random(30);}
          GFX_Eng = 1; break;
      }
    }
  }
}

// --------------------------------------------------------------------------------

void Txt_Clear() {
  // Clears the 'new' text memory for creating a fresh display
  for (int16_t zP = 0;zP < TxtDepth; zP++) {
    TxtN$[zP] = ""; TxtFN[zP] = 0;
  }
}

// --------------------------------------------------------------------------------

void Txt_Engine() {
  // Called from the main loop every 40ms
  // Perform a series of tasks to present text on valid displays.
  // Text is handled as the highest display priority task
  // GFX_Mode:
  // 0  - full eye, no text   - 240x240 eye, no text
  // 1  - most eye, some text - 240x160 eye, 240,80 text
  // 2  - no eye, full text   - no eye, 240x240 text
  if (GFX_Mode < 1) {return;}   // display does not support text mode
  if (!Txt_En) {return;}        // Abort if Text function is disabled

  //#########################################################
  // Text engime
  //#########################################################
  // The text display functions will position and format the text.
  // The GFX_Mode value will determine the amount of text draw.
  // Data relating to each text string is recorded as it is created.
  // This data then allows the text to be erased later, and replaced.
  // Text data consists of Text string, size, justification & co-ordinates.
  if (Txt_Del > 0) {Txt_Del--; return;}   // Text update is delayed

  // Each function sets the GFX_Txt value, depending on text quantity
  switch (Txt_Mode) {
    case 0: Txt_Battery();  break;
    case 1: Txt_CntDwn(); break;
    case 2: Txt_MtrPwm(); break;
    case 3: Txt_PtchRoll(); break;
  }
}

// --------------------------------------------------------------------------------

void Txt_Battery() {
  // Display battery text on the round display
       if (GFX_Mode == 0) { return;}
  else if (GFX_Mode == 1) {
    // 1/4 white eye, 80hx240w, 0X,0Y = 160,0
    Txt_Clear();
    TxtN$[0] = "Batt: " + String(BatVfp,2) + "v";
    TxtXN[0] = 120; TxtYN[0] = 190; TxtAN[0] = 1;TxtFN[0] = 2;
    TxtN$[1] = String(BatPc) + "%";
    TxtXN[1] = 120; TxtYN[1] = 210; TxtAN[1] = 1;TxtFN[1] = 2;
  }
  else if (GFX_Mode == 2) {
    // Full black window, 240hx240w, 0X,0Y = 0,0
    Txt_Clear();
    TxtN$[0] = "Batt: " + String(BatVfp,2) + "v";
    TxtXN[0] = 120; TxtYN[0] = 100; TxtAN[0] = 1;TxtFN[0] = 3;
    TxtN$[1] = String(BatPc) + "%";
    TxtXN[1] = 120; TxtYN[1] = 130; TxtAN[1] = 1;TxtFN[1] = 3;
  }
  tft.setTextColor(TxtCol);
  GFX_Txt = TxtDepth; Txt_Del = 10;
}

// --------------------------------------------------------------------------------

void Txt_CntDwn() {
  // Display motor test count down on the round display
       if (GFX_Mode == 0) { return;}
  else if (GFX_Mode == 1) {
    // 1/4 white eye, 80hx240w, 0X,0Y = 160,0
    Txt_Clear();
    TxtN$[0] = ModeStr$;
    TxtXN[0] = 120; TxtYN[0] = 190; TxtAN[0] = 1;TxtFN[0] = 3;
  }
  else if (GFX_Mode == 2) {
    // Full black window, 240hx240w, 0X,0Y = 0,0
    Txt_Clear();
    TxtN$[0] = ModeStr$;
    TxtXN[0] = 120; TxtYN[0] = 90; TxtAN[0] = 1;TxtFN[0] = 9;
  }
  tft.setTextColor(TxtCol);
  GFX_Txt = TxtDepth; Txt_Del = 10;
}

// --------------------------------------------------------------------------------

void Txt_MtrPwm() {
  // Display motor pWM values
       if (GFX_Mode == 0) { return;}
  else if (GFX_Mode == 1) {
    // 1/4 white eye, 80hx240w, 0X,0Y = 160,0
    Txt_Mode = 0; return; // not supported in 1/4 screen mode
  }
  else if (GFX_Mode == 2) {
    // Full black window, 240hx240w, 0X,0Y = 0,0
    Txt_Clear();
    TxtN$[0] = String(PWM_C);
    TxtXN[0] = 120; TxtYN[0] =  20; TxtAN[0] = 1;TxtFN[0] = 4;
    TxtN$[1] = String(PWM_D);
    TxtXN[1] =  10; TxtYN[1] = 105; TxtAN[1] = 2;TxtFN[1] = 4;
    TxtN$[2] = String(PWM_B);
    TxtXN[2] = 230; TxtYN[2] = 105; TxtAN[2] = 0;TxtFN[2] = 4;
    TxtN$[3] = String(PWM_A);
    TxtXN[3] = 120; TxtYN[3] = 200; TxtAN[3] = 1;TxtFN[3] = 4;
  }
  tft.setTextColor(TxtCol);
  GFX_Txt = TxtDepth; Txt_Del = 5;
}

// --------------------------------------------------------------------------------

void Txt_PtchRoll() {
  // Display Pitch & Roll text on the round display
       if (GFX_Mode == 0) { return;}
  else if (GFX_Mode == 1) {
    // 1/4 white eye, 80hx240w, 0X,0Y = 160,0
    Txt_Clear();
    TxtN$[0] = "Pitch:" + String((Pitch - PtchSbSpSa),1) + char(0xF7);
    TxtXN[0] = 120; TxtYN[0] = 190; TxtAN[0] = 1;TxtFN[0] = 2;
    TxtN$[1] = "Roll:" + String((Roll - RollSbSpSa),1) + char(0xF7);
    TxtXN[1] = 120; TxtYN[1] = 210; TxtAN[1] = 1;TxtFN[1] = 2;
  }
  else if (GFX_Mode == 2) {
    // Full black window, 240hx240w, 0X,0Y = 0,0
    Txt_Clear();
    TxtN$[0] = "Pitch:" + String((Pitch - PtchSbSpSa),1) + char(0xF7);
    TxtXN[0] = 120; TxtYN[0] = 100; TxtAN[0] = 1;TxtFN[0] = 3;
    TxtN$[1] = "Roll:" + String((Roll - RollSbSpSa),1) + char(0xF7);
    TxtXN[1] = 120; TxtYN[1] = 130; TxtAN[1] = 1;TxtFN[1] = 3;
  }
  tft.setTextColor(TxtCol);
  GFX_Txt = TxtDepth; Txt_Del = 10;
}

// --------------------------------------------------------------------------------
