// ######################################################################
//
//  Motor Current Test v0.00 Beta
//
//  Released:  11/08/2017
//
//  Author: TechKnowTone
//
// ######################################################################
/*
    This software is furnished "as is", without technical support, and
    with no warranty, expressed or implied, as to its usefulness for any
    purpose.

    Elements of this software were taken from the public domain. It uses
    libraries which must be installed on your system.

    This enables the stepper motor drivers in turn, such that the mootor
    current limit can be set. The ON period starts at 250 ms and slowly
    increases towards 5 seconds. The red LED is lit to indicate which
    motor is active.

    Start by turning the pots on the DRV8825 boards fully clockwise. Then
    turn counter clockwise to increase the current. A value of 200 mA to
    each motor should be sufficient. If your multimeter readings don't
    settle quickly enough you may need to extend the ON time for each
    driver to gain a more accurate reading.
*/
// Declare constants
#define LEDPinR0 9
#define LEDPinR1 10
#define LEDPinL0 12
#define LEDPinL1 11
#define MotEnR 7  // RH stepper motor enable, active LOW
#define MotEnL 6  // LH stepper motor enable, active LOW


// Declare and initialise global variables
long timedelay = 250;

void setup() {
  // put your setup code here, to run once:
  pinMode(MotEnR, OUTPUT); digitalWrite(MotEnR, HIGH);
  pinMode(MotEnL, OUTPUT); digitalWrite(MotEnL, HIGH);
  pinMode(LEDPinR0, OUTPUT);
  pinMode(LEDPinR1, OUTPUT);
  pinMode(LEDPinL0, OUTPUT);
  pinMode(LEDPinL1, OUTPUT);
}

// --------------------------------------------------------------------------------

void loop() {
  // light Green LEDs
  digitalWrite(LEDPinR0, LOW);
  digitalWrite(LEDPinR1, HIGH);
  digitalWrite(LEDPinL0, LOW);
  digitalWrite(LEDPinL1, HIGH);
  delay(1000);
  // light right Red LEDs
  digitalWrite(MotEnR, LOW);  // enable RH motor drive
  digitalWrite(LEDPinR0, HIGH);
  digitalWrite(LEDPinR1, LOW);
  digitalWrite(LEDPinL0, LOW);
  digitalWrite(LEDPinL1, LOW);
  delay(timedelay);
  digitalWrite(MotEnR, HIGH);  // disable RH motor drive
  
  digitalWrite(LEDPinR0, LOW);
  digitalWrite(LEDPinR1, LOW);
  digitalWrite(LEDPinL0, LOW);
  digitalWrite(LEDPinL1, LOW);
  delay(500);
  
  // light left Red LEDs
  digitalWrite(MotEnL, LOW);  // enable LH motor drive
  digitalWrite(LEDPinR0, LOW);
  digitalWrite(LEDPinR1, LOW);
  digitalWrite(LEDPinL0, HIGH);
  digitalWrite(LEDPinL1, LOW);
  delay(timedelay);
  digitalWrite(MotEnL, HIGH);  // disable LH motor drive
  
  digitalWrite(LEDPinR0, LOW);
  digitalWrite(LEDPinR1, LOW);
  digitalWrite(LEDPinL0, LOW);
  digitalWrite(LEDPinL1, LOW);
  delay(1000);

  if (timedelay < 5000) {timedelay = timedelay + 50;}
}

// --------------------------------------------------------------------------------

