// ################################################################################
//
//  Balance Bot Hardware Test v0.01 Beta
//
//  Released:  31/08/2017
//
//  Author: TechKnowTone
//
// ################################################################################
/*
    TERMS OF USE: This software is furnished "as is", without technical support, and
    with no warranty, expressed or implied, as to its usefulness for any purpose. In
    no event shall the author or copyright holder be liable for any claim, damages,
    or other liability, whether in an action of contract, tort or otherwise, arising
    from, out of or in connection with the software or the use or other dealings in
    the software.

    Elements of this software were taken from the public domain. It uses
    libraries which must be installed on your system.

    This code is an extended version of that written by Joop Brokking for his
    self-balancing robot. The main differences are as follows:
    
    - The loop repeats readings every 2 seconds
    - Battery voltage is now displayed

*/
// Declare libraries
#include <Wire.h>

// Define constants
#define DrvLftEn 6                  // left driver enable signal, active HIGH
#define DrvRgtEn 7                  // right driver enable signal, active HIGH
#define interval 2000               // loop interval 2 seconds

// Declare and initialise global variables
int address;              // I2C address variable
int battery_voltage;      // battery voltage variable, ie. 1110 = 11.1v
byte error;               // I2C read error flag
byte lowByte;             // received I2C lower byte
byte highByte;            // received I2C upper byte
byte MPU_6050_found;      // TRUE if MPU6050 detected on I2C
int nDevices;             // number of devices detected
unsigned long nextMillis = 0;   // loop timer
byte nunchuck_found;      // TRUE if Nunchul detected on I2C
int once = 0;             //run once flag
byte RxByte = 0;          // received byte from serial port

void setup() {
  // Setup basic functions
  pinMode(DrvLftEn, OUTPUT); digitalWrite(DrvLftEn, HIGH);  //Configure digital pin for left Enable output, start disabled
  pinMode(DrvRgtEn, OUTPUT); digitalWrite(DrvRgtEn, HIGH);  //Configure digital pin for right Enable output, start disabled
  Wire.begin();
  Serial.begin(9600);
  nextMillis = millis() + interval; // initialise timer
}

// --------------------------------------------------------------------------------

void loop()
{
  if (once < 1) {
    once = 1;
    Serial.println("\n\n\n\n\nScanning I2C bus...");
  
    nDevices = 0;
    for(address = 1; address < 127; address++ )
    {
      Wire.beginTransmission(address);
      error = Wire.endTransmission();
  
      if (error == 0)
      {
        Serial.print("I2C device found at address 0x");
        if (address<16)Serial.print("0");
        Serial.println(address,HEX);
        nDevices++;
        if(address == 0x68 || address == 0x69){
          Serial.println("This could be a MPU-6050");
          Wire.beginTransmission(address);
          Wire.write(0x75);
          Wire.endTransmission();
          Serial.println("Send Who am I request...");
          Wire.requestFrom(address, 1);
          while(Wire.available() < 1);
          lowByte = Wire.read();
          if(lowByte == 0x68){
            Serial.print("Who Am I responce is ok: 0x");
            Serial.println(lowByte, HEX);
          }
          else{
            Serial.print("Wrong Who Am I responce: 0x");
            if (lowByte<16)Serial.print("0");
            Serial.println(lowByte, HEX);
          }
          if(lowByte == 0x68 && address == 0x68){
            MPU_6050_found = 1;
            Serial.println("Starting Gyro....");
            set_gyro_registers();
          }
        }
        if(address == 0x52){
          Serial.println("This could be a Nunchuck");
          Serial.println("Trying to initialise the device...");
          Wire.beginTransmission(0x52);
          Wire.write(0xF0);
          Wire.write(0x55);
          Wire.endTransmission();
          delay(20);
          Wire.beginTransmission(0x52);
          Wire.write(0xFB);
          Wire.write(0x00);
          Wire.endTransmission();
          delay(20);
          Serial.println("Sending joystick data request...");
          Wire.beginTransmission(0x52);
          Wire.write(0x00);
          Wire.endTransmission();
          Wire.requestFrom(0x52,1);
          while(Wire.available() < 1);
          lowByte = Wire.read();
          if(lowByte > 100 && lowByte < 160){
            Serial.print("Data response normal: ");
            Serial.println(lowByte);
            nunchuck_found = 1;
          }
          else{
            Serial.print("Data response is not normal: ");
            Serial.println(lowByte);
          }
        }
      }
      else if (error==4)
      {
        Serial.print("Unknown error at address 0x");
        if (address<16)
          Serial.print("0");
        Serial.println(address,HEX);
      }    
    }
    if (nDevices == 0)
      Serial.println("No I2C devices found\n");
    else
      Serial.println("done\n");
  }
  // Display battery voltage
  // There is no reverse protection diode in this robot
  // Resistor divider => 2.2k/(2.2k + 3.3k) = 0.4
  // Hence 12.5v equals 5v @ Analog input A0
  // Hence 12.5v equals 1023 analogRead(0)
  // 1250 / 1023 = 1.222
  battery_voltage = int((float)analogRead(0) * 1.222);
  Serial.print("Battery Voltage = ");
  Serial.print(battery_voltage);
  Serial.print("  ==  ");
  Serial.print(battery_voltage/100.0);
  Serial.println(" volts");

  
  // MPU6050 data
  if(MPU_6050_found){
    Serial.print("Balance value: ");
    Wire.beginTransmission(0x68);
    Wire.write(0x3F);
    Wire.endTransmission();
    Wire.requestFrom(0x68,2);
    Serial.println((Wire.read()<<8|Wire.read())*-1);
    delay(20);
    Serial.println("Printing raw gyro values");
    for(address = 0; address < 20; address++ ){
      Wire.beginTransmission(0x68);
      Wire.write(0x43);
      Wire.endTransmission();
      Wire.requestFrom(0x68,6);
      while(Wire.available() < 6);
      Serial.print("Gyro X = "); 
      Serial.print(Wire.read()<<8|Wire.read());
      Serial.print(" Gyro Y = "); 
      Serial.print(Wire.read()<<8|Wire.read());
      Serial.print(" Gyro Z = "); 
      Serial.println(Wire.read()<<8|Wire.read());
    }
    Serial.println("\n\n");
  }
  else Serial.println("No MPU-6050 device found at address 0x68");

  if(nunchuck_found){
    Serial.println("Printing raw Nunchuck values");
    for(address = 0; address < 20; address++ ){ 
      Wire.beginTransmission(0x52);
      Wire.write(0x00);
      Wire.endTransmission();
      Wire.requestFrom(0x52,2);
      while(Wire.available() < 2);
      Serial.print("Joystick X = "); 
      Serial.print(Wire.read());
      Serial.print(" Joystick y = ");
      Serial.println(Wire.read());
      delay(100);
    }
  }
  else Serial.println("No Nunchuck device found at address 0x52");
  while(nextMillis > millis()) {
    if (Serial.available() > 0) {RxByte = Serial.read();}
  } nextMillis = nextMillis + interval;
}

// --------------------------------------------------------------------------------

void set_gyro_registers(){
  //Setup the MPU-6050
  Wire.beginTransmission(0x68);                                     //Start communication with the address found during search.
  Wire.write(0x6B);                                                         //We want to write to the PWR_MGMT_1 register (6B hex)
  Wire.write(0x00);                                                         //Set the register bits as 00000000 to activate the gyro
  Wire.endTransmission();                                                   //End the transmission with the gyro.
  
  Wire.beginTransmission(0x68);                                     //Start communication with the address found during search.
  Wire.write(0x1B);                                                         //We want to write to the GYRO_CONFIG register (1B hex)
  Wire.write(0x00);                                                         //Set the register bits as 00000000 (250dps full scale)
  Wire.endTransmission();                                                   //End the transmission with the gyro

  Wire.beginTransmission(0x68);                                     //Start communication with the address found during search.
  Wire.write(0x1C);                                                         //We want to write to the ACCEL_CONFIG register (1A hex)
  Wire.write(0x08);                                                         //Set the register bits as 00001000 (+/- 4g full scale range)
  Wire.endTransmission();                                                   //End the transmission with the gyro

  Wire.beginTransmission(0x68);                                     //Start communication with the address found during search
  Wire.write(0x1A);                                                         //We want to write to the CONFIG register (1A hex)
  Wire.write(0x03);                                                         //Set the register bits as 00000011 (Set Digital Low Pass Filter to ~43Hz)
  Wire.endTransmission();                                                   //End the transmission with the gyro 
}

// --------------------------------------------------------------------------------

